/**
    SDL_wx - using wxWidgets in SDL
    Copyright (C) 2003-2006 kr2.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp
*/
/*
	App定義
*/
#ifndef __WXSDLAPP_HPP__
#define __WXSDLAPP_HPP__

#include <wx/wxprec.h>

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

#include "WX_Object.hpp"

WX_DECLARE_LIST(WX_Object, SDLWXList);

class wxSDLApp : public wxApp
{
public :
	/* 初期化時に呼ばれる */
	bool OnInit();

	/* SDLから呼ばれるウィンドウ生成メソッド */
	void OnRegisterObject(wxCommandEvent& evt) ;
	void OnUnregisterObject(wxCommandEvent& evt) ;

	/* 以下、ハンドル */
	void OnAssert(const wxChar *file, int line, const wxChar *cond, const wxChar *msg) ;
	int OnExit () ;
	void OnData (wxCommandEvent& evt) ;
	bool OnCmdLineError(wxCmdLineParser& parser) ;
	bool OnCmdLineHelp(wxCmdLineParser& parser) ;
	bool OnCmdLineParsed(wxCmdLineParser& parser) ;
	void OnFatalException() ;
	void OnInitCmdLine(wxCmdLineParser& parser) ;
	void OnQueryEndSession(wxCloseEvent& event) ;

private :
	/* GUI構造体のリスト */
	SDLWXList m_SDLWXObjList ;
	/* イベントテーブルの定義 */
	DECLARE_EVENT_TABLE()
};

#endif // __WXSDLAPP_HPP__
