/**
    SDL_wx - using wxWidgets in SDL
    Copyright (C) 2003-2006 kr2.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp
*/
#ifndef __WX_DATA_HPP__
#define __WX_DATA_HPP__

#include <wx/wxprec.h>

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

#include <SDL.h>
#include <SDL_thread.h>

/**
	\class WX_Data
	\brief CxgMɑBKnewRelease邱ƁB
*/
class WX_Data
{
public :
	WX_Data () ;
	virtual ~WX_Data () ;

	int AddRef () ;
	int Release () ;

	bool Lock () ;
	bool Unlock () ;

	virtual void* GetData () ;
	virtual void OnRelease () ;

private :
	int m_iRefCount ;
	SDL_mutex *m_pMutex ;
};

#endif // __WX_DATA_HPP__
