/**
    SDL_wx - using wxWidgets in SDL
    Copyright (C) 2003-2006 kr2.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp
*/
#ifndef __SDL_WX_HPP__
#define __SDL_WX_HPP__

#include "SDL_wx.h"

#include <wx/wxprec.h>

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

#include "WX_Object.hpp"
#include "WX_Data.hpp"

#include <begin_code.h>

typedef void* WX_ObjectID ;

/**
	\fn WX_RegisterObjectInner
	こいつは、絶対に呼び出さないこと。
*/
extern DECLSPEC WX_ObjectID SDLCALL WX_RegisterObjectInner(WX_Object* obj) ;

/**
	\def WX_RegisterObject
	wxWidgetsにWX_Objectを登録
	XはWX_Objectから派生したクラス名を指定。
*/
#define WX_RegisterObject(X) WX_RegisterObjectInner(new X)

/**
	\fn WX_UnregisterObject
	wxWidgetsからSDLWXObjectの登録を抹消
*/
extern DECLSPEC void SDLCALL WX_UnregisterObject(WX_ObjectID id) ;

/**
	\fn WX_SendData
	\brief wxWidgetsにデータを送る
*/
extern DECLSPEC void SDLCALL WX_SendData(WX_Data* obj) ;

/**
	\fn WX_SendData
	\brief SDLにデータを送る
*/
extern DECLSPEC void SDLCALL WX_SendData(::Uint8 type, int code, WX_Data* obj) ;

#include <close_code.h>

#endif // __SDL_WX_HPP__
