/**
    SDL_wx - using wxWidgets in SDL
    Copyright (C) 2003-2006 kr2.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp
*/

#ifdef SAVE_RCSID
static char rcsid =
"@(#) $Id: SDL_wx.h,v 0.0.3 2007/01/02 22:14 kr2 Exp $";
#endif

#ifndef __SDL_WX_H__
#define __SDL_WX_H__

#include <SDL_types.h>
#include <SDL_version.h>

#include <begin_code.h>
/* Set up for C function definitions, even when using C++ */
#ifdef __cplusplus
extern "C" {
#endif

/* Printable format: "%d.%d.%d", MAJOR, MINOR, PATCHLEVEL
*/
#define SDL_WX_MAJOR_VERSION	0
#define SDL_WX_MINOR_VERSION	0
#define SDL_WX_PATCHLEVEL	4

/* This macro can be used to fill a version structure with the compile-time
 * version of the SDL_wx library.
 */
#define SDL_WX_VERSION(X)						\
{									\
	(X)->major = SDL_WX_MAJOR_VERSION;				\
	(X)->minor = SDL_WX_MINOR_VERSION;				\
	(X)->patch = SDL_WX_PATCHLEVEL;				\
}

/* Backwards compatibility */
#define WX_MAJOR_VERSION	SDL_WX_MAJOR_VERSION
#define WX_MINOR_VERSION	SDL_WX_MINOR_VERSION
#define WX_PATCHLEVEL		SDL_WX_PATCHLEVEL
#define WX_VERSION(X)		SDL_WX_VERSION(X)

/* This function gets the version of the dynamically linked SDL_wx library.
   it should NOT be used to fill a version structure, instead you should
   use the SDL_WX_VERSION() macro.
 */
extern DECLSPEC const SDL_version * SDLCALL WX_Linked_Version(void);

/**
	\fn WX_Init
	\brief wxWidgetsを初期化 
	\note 初期化が正常に終了した場合・もしくは既に初期化されている場合は
	何もせずに0を返し、それ以外なら-1を返す。
*/
extern DECLSPEC int SDLCALL WX_Init(int argc, char* argv[]) ;

/**
	\fn WX_WasInit
	\brief wxWidgetsが初期化されたかどうかを調べる
	\note 既に初期化されているなら1,まだ初期化されていないなら0を返す
*/
extern DECLSPEC int SDLCALL WX_WasInit () ;

/**
	\fn WX_Quit
	\brief wxWidgetsを終了
	\note 正常に終了した場合・もしくは既に終了されている場合は、何もせずに0を返す
*/
extern DECLSPEC int SDLCALL WX_Quit() ;

/* Ends C function definitions when using C++ */
#ifdef __cplusplus
}
#endif
#include "close_code.h"

#endif /* __SDL_WX_H__ */
