/**
    SDL_wx - using wxWidgets in SDL
    Copyright (C) 2003-2006 kr2.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    kr2
    ee12054g@hotmail.co.jp
*/
/*
	main関数の引数を保持するクラス
*/
#ifndef __SDLWX_CARGS_HPP__
#define __SDLWX_CARGS_HPP__

#include <string.h>

class SDLWX_CArgs {
public :
	/* 初期化 */
	SDLWX_CArgs ( int argc, char* argv[] ) {
		/* メンバーの初期化 */
		Init () ;
		/* 異常な引数の回避 */
		if ( argc==0 ) return ;
		if ( argv==NULL ) return ;
		m_iArgc = argc ;
		int i ;
		/* 終端NULLを考慮して+1する。 */
		m_pstrArgv = new char*[m_iArgc+1] ;
		/* argvのコピー */
		for ( i=0; i<m_iArgc; i++ ) {
			m_pstrArgv[i] = new char[strlen(argv[i])+1] ;
			strcpy ( m_pstrArgv[i], argv[i] ) ;
		}
		/* 終端をNULLにする */
		m_pstrArgv[m_iArgc] = NULL ;
	}

	/* 開放 */
	~SDLWX_CArgs ()
	{
		int i ;
		for ( i=0; i<m_iArgc; i++ ) {
			delete[] m_pstrArgv[i] ;
		}
		if ( m_pstrArgv != NULL ) {
			delete[] m_pstrArgv ;
		}
	}

	int Argc() { return m_iArgc ; }
	char** Argv() { return m_pstrArgv ; }

	/* メンバーの初期化 */
	void Init ()
	{
		m_iArgc = 0 ;
		m_pstrArgv = NULL ;
	}
private :
	int m_iArgc ;
	char** m_pstrArgv ;
	/* デフォルトコンストラクタの禁止 */
	SDLWX_CArgs () {}
} ;

#endif // __SDLWX_CARGS_HPP__
