/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.exe;

import java.util.HashMap;
import java.util.Map;

import net.morilib.awk.Awk;
import net.morilib.bc.Bc;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShProcess;
import net.morilib.sh.builtin.ShBasename;
import net.morilib.sh.builtin.ShCat;
import net.morilib.sh.builtin.ShCd;
import net.morilib.sh.builtin.ShCp;
import net.morilib.sh.builtin.ShCut;
import net.morilib.sh.builtin.ShD;
import net.morilib.sh.builtin.ShDate;
import net.morilib.sh.builtin.ShDirname;
import net.morilib.sh.builtin.ShEcho;
import net.morilib.sh.builtin.ShExit;
import net.morilib.sh.builtin.ShExport;
import net.morilib.sh.builtin.ShFalse;
import net.morilib.sh.builtin.ShGetopts;
import net.morilib.sh.builtin.ShGrep;
import net.morilib.sh.builtin.ShHead;
import net.morilib.sh.builtin.ShLocal;
import net.morilib.sh.builtin.ShMkdir;
import net.morilib.sh.builtin.ShMsgbox;
import net.morilib.sh.builtin.ShMv;
import net.morilib.sh.builtin.ShPwd;
import net.morilib.sh.builtin.ShRead;
import net.morilib.sh.builtin.ShReadonly;
import net.morilib.sh.builtin.ShRm;
import net.morilib.sh.builtin.ShRmdir;
import net.morilib.sh.builtin.ShSed;
import net.morilib.sh.builtin.ShSet;
import net.morilib.sh.builtin.ShShift;
import net.morilib.sh.builtin.ShSleep;
import net.morilib.sh.builtin.ShSort;
import net.morilib.sh.builtin.ShSqlc;
import net.morilib.sh.builtin.ShTail;
import net.morilib.sh.builtin.ShTee;
import net.morilib.sh.builtin.ShTouch;
import net.morilib.sh.builtin.ShTr;
import net.morilib.sh.builtin.ShTrap;
import net.morilib.sh.builtin.ShTrue;
import net.morilib.sh.builtin.ShUniq;
import net.morilib.sh.builtin.ShUnset;
import net.morilib.sh.builtin.ShWc;
import net.morilib.sh.builtin.ShWhich;
import net.morilib.sh.builtin.ShWread;
import net.morilib.sh.testcmd.ShTestParser;

public final class ShDefaultBuiltInCommands
implements ShBuiltInCommands {

	private static ShBuiltInCommands COMMANDS = _getInstance();
	private Map<String, ShProcess> commands;

	//
	ShDefaultBuiltInCommands(Map<String, ShProcess> cmd) {
		this.commands = cmd;
	}

	//
	static ShBuiltInCommands _getInstance() {
		Map<String, ShProcess> m = new HashMap<String, ShProcess>();

		m.put(":", new ShTrue());
		m.put("awk", Awk.getInstance());
		m.put("basename", new ShBasename());
		m.put("bc", new Bc());
		m.put("cat", new ShCat());
		m.put("cd", new ShCd());
		m.put("cp", new ShCp());
		m.put("cut", new ShCut());
		m.put("d", new ShD());
		m.put("date", new ShDate());
//		m.put("diff", new ShDiff());
		m.put("dirname", new ShDirname());
		m.put("echo", new ShEcho());
		m.put("exit", new ShExit());
		m.put("export", new ShExport());
		m.put("false", new ShFalse());
		m.put("getopts", new ShGetopts());
		m.put("grep", new ShGrep());
		m.put("head", new ShHead());
		m.put("local", new ShLocal());
		m.put("mkdir", new ShMkdir());
		m.put("msgbox", new ShMsgbox());
		m.put("mv", new ShMv());
		m.put("pwd", new ShPwd());
		m.put("read", new ShRead());
		m.put("readonly", new ShReadonly());
		m.put("rm", new ShRm());
		m.put("rmdir", new ShRmdir());
		m.put("sed", new ShSed());
		m.put("set", new ShSet());
		m.put("shift", new ShShift());
		m.put("sleep", new ShSleep());
		m.put("sort", new ShSort());
		m.put("sqlc", new ShSqlc());
		m.put("tail", new ShTail());
		m.put("tee", new ShTee());
		m.put("test", ShTestParser.getDefault());
		m.put("touch", new ShTouch());
		m.put("tr", new ShTr());
		m.put("trap", new ShTrap());
		m.put("true", new ShTrue());
		m.put("uniq", new ShUniq());
		m.put("unset", new ShUnset());
		m.put("wc", new ShWc());
		m.put("which", new ShWhich());
		m.put("wread", new ShWread());
		return new ShDefaultBuiltInCommands(m);
	}

	/**
	 * 
	 * @return
	 */
	public static ShBuiltInCommands getInstance() {
		return COMMANDS;
	}

	/**
	 * 
	 * @param name
	 * @return
	 */
	public ShProcess find(String name) {
		return commands.get(name);
	}

}
