/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sed;

/**
 * 正規表現エンジンのインターフェースです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public interface SedPatternEngine {

	/**
	 * マッチするかを調べます。
	 * 
	 * @param pattern パターン文字列
	 * @param s 入力
	 * @param caseInsensitive 大文字小文字を区別しないときtrue
	 * @param allmatch 全体一致のときにtrue
	 * @return
	 */
	public boolean matches(String pattern, String s,
			boolean caseInsensitive, boolean allmatch);

	/**
	 * マッチした部分に置き換えます。
	 * 
	 * @param pattern パターン文字列
	 * @param source  置換前の文字列
	 * @param replace 置換する文字列
	 * @param flags   フラグ
	 * @return 置換後の文字列
	 */
	public String replace(String pattern, String source,
			String replace, SedSubstituteFlags flags);

}
