/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.dc.number;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/07/14
 */
public interface AlgebricInteger
<E extends NumericalRingElement<E>> {

	/**
	 * 
	 * @return
	 */
	public boolean isZero();

	/**
	 * 
	 * @return
	 */
	public int signum();

	/**
	 * 
	 * @param x
	 * @return
	 */
	public E divide(E x);

	/**
	 * 
	 * @param x
	 * @return
	 */
	public E remainder(E x);

	/**
	 * 
	 * @param x
	 * @return
	 */
	public QuotientAndRemainder<E> divideAndRemainder(E x);

}
