/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.parser;

import java.util.HashMap;
import java.util.Map;

/**
 * 文字列定数のトークンです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkStringToken extends AwkToken {

	private String name;

	private static Map<String, AwkStringToken> vars =
		new HashMap<String, AwkStringToken>();

	private AwkStringToken(String name) {
		super("\"" + name + "\"");
		this.name = name;
	}

	/**
	 * 文字列定数を取得します。
	 * 
	 * @param name 文字列
	 * @return トークン
	 */
	public static AwkStringToken getInstance(String name) {
		AwkStringToken v;

		if((v = vars.get(name)) == null) {
			vars.put(name, v = new AwkStringToken(name));
		}
		return v;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.parser.AwkToken#getString()
	 */
	public String getString() {
		return name;
	}

}
