/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkRegex;
import net.morilib.awk.value.AwkValue;

/**
 * 正規表現パターンを表す中間表現です。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkLiteralRegex extends AwkExpression {

	private String value;

	/**
	 * 中間表現を生成します。
	 * 
	 * @param value 正規表現
	 */
	public AwkLiteralRegex(String value) {
		this.value = value;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.expr.AwkExpression#eval(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles)
	 */
	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		return AwkRegex.valueOf(value);
	}

}
