/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

/**
 * awkiumの実行時エラーの基底クラスです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkRuntimeException extends AwkException {

	/**
	 * 例外を発生します。
	 */
	public AwkRuntimeException() {
		super();
	}

	/**
	 * 例外を発生します。
	 * 
	 * @param message メッセージ
	 * @param cause   原因
	 */
	public AwkRuntimeException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * 例外を発生します。
	 * 
	 * @param message メッセージ
	 */
	public AwkRuntimeException(String message) {
		super(message);
	}

	/**
	 * 例外を発生します。
	 * 
	 * @param cause 原因
	 */
	public AwkRuntimeException(Throwable cause) {
		super(cause);
	}

}
