/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.nio.charset.Charset;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShRuntimeException;
import net.morilib.sh.ShSignal;
import net.morilib.sh.ShTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShFunctionEnvironment
implements ShEnvironment {
    private Map<String, String> map;
    private Map<String, ShTree> functions;
    private Map<String, ShEnvironment.Attributes> attrs;
    private ShEnvironment env;
    private EnumMap<ShSignal, String> traps;

    public ShFunctionEnvironment(ShEnvironment env) {
        this.env = env;
        this.map = new HashMap<String, String>();
        this.functions = new HashMap<String, ShTree>();
        this.attrs = new HashMap<String, ShEnvironment.Attributes>();
    }

    @Override
    public void bind(String name, String value) {
        if (this.isReadonly(name)) {
            throw new ShRuntimeException();
        }
        if (this.map.containsKey(name)) {
            this.map.put(name, value);
        } else {
            this.env.bind(name, value);
        }
    }

    @Override
    public void bind(String name, ShTree f) {
        if (this.functions.containsKey(name)) {
            this.functions.put(name, f);
        } else {
            this.env.bind(name, f);
        }
    }

    @Override
    public boolean contains(String name) {
        return this.map.containsKey(name) || this.env.contains(name);
    }

    @Override
    public void export(String name) {
        this.env.export(name);
        if (this.map.containsKey(name)) {
            this.env.bind(name, this.map.get(name));
            this.map.remove(name);
        }
    }

    @Override
    public String find(String name) {
        String v = this.map.get(name);
        return v != null ? v : this.env.find(name);
    }

    @Override
    public ShTree findFunction(String name) {
        ShTree v = this.functions.get(name);
        return v != null ? v : this.env.findFunction(name);
    }

    @Override
    public ShEnvironment getEnvironment() {
        return this.env.getEnvironment();
    }

    @Override
    public List<String> getPath() {
        return this.env.getPath();
    }

    @Override
    public boolean isEnvironment() {
        return false;
    }

    @Override
    public boolean isSet(String name) {
        return this.env.isSet(name);
    }

    @Override
    public void put(String name, String value) {
        this.map.put(name, value);
    }

    @Override
    public void put(String name, ShTree function) {
        this.functions.put(name, function);
    }

    @Override
    public void reset(String name) {
        this.env.reset(name);
    }

    @Override
    public void set(String name) {
        this.env.set(name);
    }

    @Override
    public void set(String name, boolean value) {
        this.env.set(name, value);
    }

    @Override
    public void unbind(String name) {
        if (this.map.containsKey(name)) {
            this.map.remove(name);
        } else {
            this.env.unbind(name);
        }
    }

    @Override
    public boolean isReadonly(String name) {
        ShEnvironment.Attributes a;
        return this.isSystem(name) || this.map.containsKey(name) && (a = this.attrs.get(name)) != null && a.isReadonly() || !this.map.containsKey(name) && this.env.isReadonly(name);
    }

    @Override
    public boolean isSystem(String name) {
        return name.matches("[0-9]+") || name.equals("@") || name.equals("*");
    }

    @Override
    public void setReadonly(String name) {
        if (this.map.containsKey(name)) {
            this.attrs.put(name, READONLY);
        } else {
            this.env.setReadonly(name);
        }
    }

    @Override
    public Properties toProperties() {
        Properties p = this.env.toProperties();
        for (Map.Entry<String, String> e : this.map.entrySet()) {
            p.setProperty(e.getKey(), e.getValue());
        }
        return p;
    }

    @Override
    public String getTrap(ShSignal signal) {
        if (!signal.isInherit()) {
            return this.traps.get((Object)signal);
        }
        String s = this.traps.get((Object)signal);
        if (s != null) {
            return s;
        }
        return this.env.getTrap(signal);
    }

    @Override
    public void setTrap(ShSignal signal, String cmd) {
        this.traps.put(signal, cmd);
    }

    @Override
    public Charset getCharset() {
        return this.env.getCharset();
    }

    @Override
    public Locale getLocale() {
        return this.env.getLocale();
    }
}

