/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.expr;

import net.morilib.c.pre.CpreMacros;

/**
 * Cプリプロセッサ式の中間表現を表すインターフェースです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public abstract class CpreExpression {

	/**
	 * 中間表現を評価します。
	 * 
	 * @param lineno 行番号
	 * @param m      マクロ空間
	 * @return 評価された結果
	 */
	public abstract CpreValue eval(int lineno, CpreMacros m);

}
