/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.strftime;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 日付フォーマットに関連するアクションです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/05/11
 */
public class StrftimeSimpleDateAction implements StrftimeAction {

	/**
	 * %aに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_a =
		new StrftimeSimpleDateAction("EEE");

	/**
	 * %Aに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_A =
		new StrftimeSimpleDateAction("EEEE");

	/**
	 * %bに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_b =
		new StrftimeSimpleDateAction("MMM");

	/**
	 * %Bに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_B =
		new StrftimeSimpleDateAction("MMMM");

	/**
	 * %dに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_d =
		new StrftimeSimpleDateAction("dd");

	/**
	 * %Hに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_H =
		new StrftimeSimpleDateAction("HH");

	/**
	 * %Iに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_I =
		new StrftimeSimpleDateAction("hh");

	/**
	 * %mに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_m =
		new StrftimeSimpleDateAction("MM");

	/**
	 * %Mに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_M =
		new StrftimeSimpleDateAction("mm");

	/**
	 * %pに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_p =
		new StrftimeSimpleDateAction("a");

	/**
	 * %sに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_S =
		new StrftimeSimpleDateAction("ss");

	/**
	 * %yに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_y =
		new StrftimeSimpleDateAction("yy");

	/**
	 * %Yに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_Y =
		new StrftimeSimpleDateAction("yyyy");

	/**
	 * %Zに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_Z =
		new StrftimeSimpleDateAction("z");

	/**
	 * %Dに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_D =
		new StrftimeSimpleDateAction("MM/dd/yy");

	/**
	 * %rに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_r =
		new StrftimeSimpleDateAction("hh:mm:ss a");

	/**
	 * %Rに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_R =
		new StrftimeSimpleDateAction("HH:mm");

	/**
	 * %Tに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_T =
		new StrftimeSimpleDateAction("HH:mm:ss");

	/**
	 * %Cに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_C =
		new StrftimeSimpleDateAction("yy");

	/**
	 * %Vに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_V =
		new StrftimeSimpleDateAction("ww");

	/**
	 * %zに対応するアクションです。
	 */
	public static final StrftimeAction ACTION_z =
		new StrftimeSimpleDateAction("Z");

	private SimpleDateFormat fmt;

	/**
	 * 日付フォーマットに対するアクションを生成します。
	 * 
	 * @param format SimpleDateFormatのフォーマット
	 */
	public StrftimeSimpleDateAction(String format) {
		fmt = new SimpleDateFormat(format);
	}

	public void action(Writer writer,
			Date date) throws IOException {
		writer.append(fmt.format(date.getTime()));
	}

}
