/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import java.math.BigInteger;

import net.morilib.awk.AwkCastException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkFloat;
import net.morilib.awk.value.AwkInteger;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * デクリメントを表す中間表現です。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkDeclementer extends AwkExpression {

	private AwkExpression e1;
	private boolean prefix;

	/**
	 * 中間表現を生成します。
	 * 
	 * @param e1     式
	 * @param prefix 前置のときtrue
	 */
	public AwkDeclementer(AwkExpression e1, boolean prefix) {
		this.e1 = e1;
		this.prefix = prefix;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.expr.AwkExpression#eval(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles)
	 */
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		BigInteger b;
		AwkValue v, w;

		v = e1.eval(ns, o);
		if(v.isInteger() || (v.isString() && v.isIntegerValue())) {
			b = v.toInteger();
			w = AwkInteger.valueOf(b.subtract(BigInteger.ONE));
		} else if(v.isFloat() || (v.isString() && v.isFloatValue())) {
			w = AwkFloat.valueOf(v.toFloat() - 1);
		} else if(v instanceof AwkUndefined) {
			v = AwkInteger.ZERO;
			w = AwkInteger.valueOf(-1);
		} else {
			throw new AwkCastException("number required");
		}
		v = prefix ? w : v;
		e1.assign(ns, w, o);
		return v;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.expr.AwkExpression#isLvalue()
	 */
	public boolean isLvalue() {
		return false;
	}

}
