/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

import net.morilib.awk.parser.AwkToken;

/**
 * awkiumの構文エラーです。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkSyntaxException extends AwkCompilationException {

	//
	private AwkToken expected, but;
	private String variable;

	/**
	 * 例外を発生します。
	 * 
	 * @param lineno   行番号
	 * @param expected 期待するトークン
	 * @param but      実際のトークン
	 */
	public AwkSyntaxException(int lineno, AwkToken expected,
			AwkToken but) {
		super(lineno, "expected " + expected + " but " + but);
		this.expected = expected;
		this.but = but;
	}

	/**
	 * 例外を発生します。
	 * 
	 * @param lineno   行番号
	 * @param variable 変数名
	 * @param but      実際のトークン
	 */
	public AwkSyntaxException(int lineno, String variable,
			AwkToken but) {
		super(lineno, "expected <" + variable + "> but " + but);
		this.variable = variable;
		this.but = but;
	}

	/**
	 * 例外を発生します。
	 * 
	 * @param lineno 行番号
	 * @param mesg   メッセージ
	 */
	public AwkSyntaxException(int lineno, String mesg) {
		super(lineno, mesg);
	}

	/**
	 * 期待されるトークンを得ます。
	 */
	public AwkToken getExpected() {
		return expected;
	}

	/**
	 * 実際のトークンを得ます。
	 */
	public AwkToken getBut() {
		return but;
	}

	/**
	 * 期待される変数名を得ます。
	 */
	public String getVariable() {
		return variable;
	}

}
