/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.special;

import net.morilib.awk.stat.DoubleContinuedFractionFunction;
import net.morilib.awk.stat.DoubleTransform;
import net.morilib.awk.stat.special.HypergeometricFunction;

public final class Gamma {
    private static final double LOG_SQRT_2PI = Math.log(Math.PI * 2) / 2.0;
    private static final double[] COEFFS = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};

    private Gamma() {
    }

    public static double lnGamma(double x) {
        double g = 4.7421875;
        double r = 0.0;
        double s = 0.0;
        if (x > 0.0) {
            int k = COEFFS.length - 1;
            while (k > 0) {
                s += COEFFS[k] / (x + (double)k);
                --k;
            }
            double t = x + g + 0.5;
            r = (x + 0.5) * Math.log(t);
            r -= t;
            r += LOG_SQRT_2PI;
            return r += Math.log((s += COEFFS[0]) / x);
        }
        return Double.NaN;
    }

    public static double incompleteGammaLower(double s, double x) {
        return Math.exp(Gamma.lnIncompleteGammaLower(s, x));
    }

    public static double lnIncompleteGammaLower(double s, double x) {
        double t = new HypergeometricFunction(1.0, 1.0 + s).f(x);
        return Math.log(t) + s * Math.log(x) - x - Math.log(s);
    }

    public static double incompleteGammaUpper(double s, double x) {
        return Math.exp(Gamma.lnIncompleteGammaUpper(s, x));
    }

    public static double lnIncompleteGammaUpper(double s, double x) {
        return Math.log(new IGammaU(s).f(x)) + s * Math.log(x) - x;
    }

    public static DoubleTransform incompleteGammaLowerFunction(final double s) {
        final HypergeometricFunction f = new HypergeometricFunction(1.0, 1.0 + s);
        return new DoubleTransform(){

            public double f(double x) {
                return Math.exp(Math.log(f.f(x)) + s * Math.log(x) - x - Math.log(s));
            }
        };
    }

    public static DoubleTransform lnIncompleteGammaLowerFunction(final double s) {
        final HypergeometricFunction f = new HypergeometricFunction(1.0, 1.0 + s);
        return new DoubleTransform(){

            public double f(double x) {
                return Math.log(f.f(x)) + s * Math.log(x) - x - Math.log(s);
            }
        };
    }

    public static DoubleTransform incompleteGammaUpperFunction(final double s) {
        final IGammaU f0 = new IGammaU(s);
        return new DoubleTransform(){

            public double f(double x) {
                return Math.exp(Math.log(f0.f(x)) + s * Math.log(x) - x);
            }
        };
    }

    public static DoubleTransform lnIncompleteGammaUpperFunction(final double s) {
        final IGammaU f0 = new IGammaU(s);
        return new DoubleTransform(){

            public double f(double x) {
                return Math.log(f0.f(x)) + s * Math.log(x) - x;
            }
        };
    }

    static class IGammaL
    extends DoubleContinuedFractionFunction {
        private double s;

        private IGammaL(double s) {
            this.s = s;
        }

        protected double getA1(double x) {
            return 1.0;
        }

        protected double getAn(int n, double x) {
            return (n % 2 == 0 ? -this.s - (double)((n - 1) / 2) : (double)(n / 2)) * x;
        }

        protected double getB0(double x) {
            return 0.0;
        }

        protected double getB1(double x) {
            return this.s;
        }

        protected double getBn(int n, double x) {
            return this.s + (double)n - 1.0;
        }
    }

    static class IGammaU
    extends DoubleContinuedFractionFunction {
        private double s;

        private IGammaU(double s) {
            this.s = s;
        }

        protected double getA1(double x) {
            return 1.0;
        }

        protected double getAn(int n, double x) {
            return n % 2 > 0 ? (double)((n - 1) / 2) : (double)(n / 2) - this.s;
        }

        protected double getB0(double x) {
            return 0.0;
        }

        protected double getB1(double x) {
            return x;
        }

        protected double getBn(int n, double x) {
            return n % 2 > 0 ? x : 1.0;
        }
    }
}

