/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.stat.dist;

import net.morilib.awk.stat.dist.AbstractDiscreteDistribution;

public class HypergeometricDistribution
extends AbstractDiscreteDistribution {
    private int num;
    private int N;
    private int K;

    public HypergeometricDistribution(int all, int part, int trial) {
        this.N = all;
        this.K = part;
        this.num = trial;
        if (this.K >= this.N) {
            throw new IllegalArgumentException();
        }
        if (this.num >= this.N) {
            throw new IllegalArgumentException();
        }
    }

    public int getAll() {
        return this.N;
    }

    public int getPart() {
        return this.K;
    }

    public int getTrial() {
        return this.num;
    }

    /*
     * Unable to fully structure code
     */
    public double f(int n) {
        k = this.num;
        m = 0;
        r = 1.0;
        c = 1.0;
        if (this.isInSupport(n)) ** GOTO lbl11
        return 0.0;
lbl-1000:
        // 1 sources

        {
            r *= (double)(this.N - this.K - m) / (double)(this.N - m);
            c *= (double)(this.num - n - m) / (double)k;
            --k;
            ++m;
lbl11:
            // 2 sources

            ** while (k > n)
        }
lbl12:
        // 2 sources

        while (k > 0) {
            r *= (double)(this.K + k - n) / (double)(this.N - m);
            --k;
            ++m;
        }
        return r / c;
    }

    public boolean isInSupport(int n) {
        return this.supportMinimum() <= n && n <= this.supportMaximum();
    }

    public int supportMinimum() {
        return Math.max(0, this.num + this.K - this.N);
    }

    public int supportMaximum() {
        return Math.min(this.K, this.num);
    }

    public double expectedValue() {
        return this.num * this.K / this.N;
    }

    public double kurtosis() {
        double n = this.num;
        double NK = this.N - this.K;
        double N1 = this.N - 1;
        double N2 = this.N - 2;
        double N3 = this.N - 3;
        double Ni = this.N + 1;
        double Nn = (double)this.N - n;
        double xd = n * (double)this.K * Nn * N2 * N3;
        double xn = N1 * (double)this.N * (double)this.N * ((double)this.N * Ni - 6.0 * (double)this.K * NK - 6.0 * n * Nn);
        return (xn += 6.0 * n * (double)this.K * NK * Nn * (5.0 * (double)this.N - 6.0)) / xd;
    }

    public double mode() {
        return Math.floor(((double)this.num + 1.0) * ((double)this.K + 1.0) / ((double)this.N + 2.0));
    }

    public double skewness() {
        double n = this.num;
        double NK = this.N - this.K;
        double N1 = this.N - 1;
        double N2 = this.N - 2;
        double Nn = (double)this.N - n;
        double N2n = (double)this.N - 2.0 * n;
        double N2K = this.N - 2 * this.K;
        double xn = N2K * Math.sqrt(N1) * N2n;
        double xd = Math.sqrt(n * (double)this.K * NK * Nn) * N2;
        return xn / xd;
    }

    public double variance() {
        double n = this.num;
        double NK = this.N - this.K;
        double N1 = this.N - 1;
        double Nn = this.N - this.num;
        return n * (double)this.K / (double)this.N * NK / (double)this.N * Nn / N1;
    }
}

