/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.awk.matrix;

import net.morilib.awk.matrix.AbstractDoubleMatrix;
import net.morilib.awk.matrix.ArrayDoubleVector;
import net.morilib.awk.matrix.DoubleMatrix;
import net.morilib.awk.matrix.DoubleVector;

public abstract class AbstractArrayDoubleMatrix
extends AbstractDoubleMatrix
implements Cloneable {
    protected int rows;
    protected int columns;

    protected abstract double array(int var1);

    protected abstract void arrayset(int var1, double var2);

    protected abstract AbstractArrayDoubleMatrix prototype();

    protected abstract AbstractArrayDoubleMatrix prototype(int var1, int var2);

    public abstract DoubleMatrix clone();

    protected abstract void arraycopy(int var1, Object var2, int var3, int var4);

    public double get(int row, int column) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException();
        }
        return this.array(row * this.columns + column);
    }

    public DoubleVector getRowVector(int row) {
        double[] ra = new double[this.columns];
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        this.arraycopy(row * this.columns, ra, 0, this.columns);
        return new ArrayDoubleVector(ra);
    }

    public int rowSize() {
        return this.rows;
    }

    public int columnSize() {
        return this.columns;
    }

    public double get(int index) {
        return this.array(index);
    }

    public int size() {
        return this.rows * this.columns;
    }

    public void set(int row, int column, double x) {
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException();
        }
        if (column < 0 || column >= this.columns) {
            throw new IndexOutOfBoundsException();
        }
        this.arrayset(row * this.columns + column, x);
    }
}

