<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: exportTextVisitor.class.php 78 2006-04-11 13:51:37Z sakamoto $
 */

/**
 * XML̕ɃGNX|[g܂B
 * ʂɂ͐ꍇɂTRUEAsꍇFALSEԂ܂B
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_exportTextVisitor extends AutoSOAP_XMLogic_Visitor {
    private $_flg_start = false;
    private $_flg_error = false;

    /**
     * GNX|[g
     */
    private function export(AutoSOAP_XMLogic_Obj $target, $func)
    { 
        // G[`FbN
        if (true == $this -> _flg_error) {
            return false;
        } 

        $is_root = false;
        if (false === $this -> _flg_start) {
            $this -> setResult("");
            $this -> _flg_start = true;
            $this -> _flg_error = false;
            $is_root = true;
        } 
        // p[cGNX|[gʂ擾
        $result = $this -> $func($target); 
        // --------------------------------
        // G[`FbN
        if (true == $this -> _flg_error) {
            return false;
        } 
        // ̃p[c[gȂ猋ʂi[ďI
        if ($is_root) {
            $this -> setResult($result);
            $this -> _flg_error = false;
            $this -> _flg_start = false;
            return true;
        } 
        // GNX|[gʂe֕Ԃ
        return $result;
    } 

    /**
     * ʂԂ
     */
    public function getResult($to_encoding = null, $from_encoding = null)
    {
        if (is_null($to_encoding)) {
            $result = "<?xml version=\"1.0\" encoding=\"" . mb_internal_encoding() . "\"?>\n" . parent :: getResult();
            return $result;
        } else if (is_null($from_encoding)) {
            $result = "<?xml version=\"1.0\" encoding=\"" . $to_encoding . "\"?>\n" . parent :: getResult();
            return mb_convert_encoding($result, $to_encoding);
        } else {
            $result = "<?xml version=\"1.0\" encoding=\"" . $to_encoding . "\"?>\n" . parent :: getResult();
            return mb_convert_encoding($result, $to_encoding, $from_encoding);
        } 
    } 
    // Gg
    public function visitElement(AutoSOAP_XMLogic_Element $elem)
    {
        return $this -> export($elem, "exportElement");
    } 
    // O
    public function visitVariable(AutoSOAP_XMLogic_Variable $nobj)
    {
        return $this -> export($nobj, "exportVariable");
    } 
    // e
    public function visitContent(AutoSOAP_XMLogic_Content $content)
    {
        return $this -> export($content, "exportContent");
    } 
    // q
    public function visitChildren(AutoSOAP_XMLogic_Children $children)
    {
        return $this -> export($children, "exportChildren");
    } 
    // 
    public function visitAttribute(AutoSOAP_XMLogic_Attribute $attr)
    {
        return $this -> export($attr, "exportAttribute");
    } 
    // l[Xy[X
    public function visitXmlns(AutoSOAP_XMLogic_NS $nsobj)
    {
        return $this -> export($nsobj, "exportXmlns");
    } 
    // GgGNX|[g
    private function exportElement(AutoSOAP_XMLogic_Element $elem)
    {
        $name = $elem -> getTagName() -> accept($this);
        $node = $elem -> getNode() -> accept($this);
        $attr = $elem -> getAttribute() -> accept($this);
        $xmlns = $elem -> getXmlns() -> accept($this);
        $result = "";

        $result = "<" . $name;
        if ('' != $attr)
            $result .= $attr;
        if ('' != $xmlns)
            $result .= $xmlns;

        if ('' == $node) {
            return $result . "/>\n";
        } 

        $result .= ">";
        $result .= ((preg_match("/[\n]/", $node))?"\n":"") . $node;
        $result .= "</" . $name . ">\n";

        return $result;
    } 
    // OGNX|[g
    private function exportVariable(AutoSOAP_XMLogic_Variable $nobj)
    {
        $name = htmlspecialchars($nobj -> getName());
        if (0 == strlen($nobj -> getNamespace())) {
            return $name;
        } 
        $ns = $this -> searchXmlns($nobj, $nobj -> getNamespace());
        return ('' == $ns)
        ? $name
        : $ns . ':' . $name;
    } 
    // eGNX|[g
    private function exportContent(AutoSOAP_XMLogic_Content $content)
    {
        return htmlspecialchars($content -> getContent());
    } 
    // qGNX|[g
    private function exportChildren(AutoSOAP_XMLogic_Children $children)
    {
        $result = "";
        $itr = $children -> getIterator();
        while ($itr -> valid()) {
            $result .= $itr -> current() -> accept($this);
            $itr -> next();
        } 
        return $result;
    } 
    // GNX|[g
    private function exportAttribute(AutoSOAP_XMLogic_Attribute $attr)
    {
        return " " . $attr -> getKey() -> accept($this) . '="' . $attr -> getValue() -> accept($this) . '"';
    } 
    // l[Xy[XGNX|[g
    private function exportXmlns(AutoSOAP_XMLogic_NS $nsobj)
    {
        return ('' == $nsobj -> getNS())
        ? ' xmlns="' . $nsobj -> getURI() . '"'
        : ' xmlns:' . $nsobj -> getNS() . '="' . $nsobj -> getURI() . '"' ;
    } 

    /**
     * l[Xy[XɑΉL[Ԃ
     */
    private function searchXmlns($target, $uri)
    {
        $search = new AutoSOAP_XMLogic_searchXmlnsVisitor($uri);
        if ($target -> accept($search))
            return $search -> getResult(); 
        // L[ꂸ
        trigger_error("Namespace '" . $uri . "' was not found." , E_USER_WARNING);
        $this -> _flg_error = true;

        return null;
    } 
} 

?>