<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: class2SoapXsdVisitor.class.php 78 2006-04-11 13:51:37Z sakamoto $
 */

/**
 * NXSOAPbZ[WؗpXSDf[^ւ̕ϊprW^[NX
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_class2SoapXsdVisitor implements AutoSOAP_ReflectionVisitor {
    // SOAPf[^Ǘ
    private $_class2soap;

    /**
     * 
     */
    public function init($target_uri, $soapenv_uri = null, $soapenc_uri = null)
    {
        $schema = AutoSOAP_XMLogic_SchemaFactory :: getInstance();

        /**
         * XSD̑g̍쐬
         */
        $root = $schema -> createRoot($target_uri);
        $class2xsd = new AutoSOAP_class2xsdVisitor();
        $class2xsd -> init($root);

        /**
         * SOAPGu[uXL[}C|[g
         */
        $xml = AutoSOAP_XMLogic_XMLFactory :: getInstance();
        if (is_null($soapenv_uri))
            $soapenv_uri = AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENV;
        if (is_null($soapenc_uri))
            $soapenc_uri = AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENC;
        $root -> add($schema -> createImport(AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENV, $soapenv_uri));
        $root -> add($xml -> xmlns('soapenv', AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENV));

        $root -> add($schema -> createImport(AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENC, $soapenc_uri));
        $root -> add($xml -> xmlns('soapenc', AutoSOAP_XMLogic_WsdlFactory :: XMLNS_SOAP_ENC)); 
        
        $this -> _class2soap = new AutoSOAP_class2soap($target_uri, $root, $class2xsd);
    } 

    /**
     * ʂԂ
     */
    public function getResult($to_encoding = null, $from_encoding = null)
    {
        return $this -> _class2soap -> getResult($to_encoding, $from_encoding);
    } 

    /**
     * q
     */
    public function visitChildren(AutoSOAP_ReflectionChildren $children)
    {
        return AutoSOAP_class2soap :: visitChildren($this, $children);
    } 

    /**
     * NX
     */
    public function visitClass(AutoSOAP_ReflectionAccept $class)
    {
        /**
         * C^[tF[XV^CN[h
         */
        $this -> _class2soap -> createNewTypes($class); 
        // \bhǉ
        $class -> getMethods() -> accept($this);
    } 

    /**
     * \bhǉ
     */
    public function visitMethod(AutoSOAP_ReflectionAccept $method)
    {
        if (!$this -> _class2soap -> createMethodInfo($method)) {
            return ;
        } 

        $method_name = $method -> getName(); 
        // XMLXL[}^ONX
        $schema = AutoSOAP_XMLogic_SchemaFactory :: getInstance();

        /**
         * NGXg\bhǉ
         */
        $request_name = $method_name . "Request";
        $request = $schema -> createComplexType($request_name);

        /**
         * p[^ǉ
         */
        $parameters = $method -> getParameters() -> accept($this);
        if (0 < count($parameters)) {
            $seq = $schema -> createSequence();
            foreach($parameters as $param) {
                $seq -> add($param);
            } 
            $request -> add($seq);
        } 
        $request -> add($schema -> createAnyAttribute("##other", "lax"));
        $this -> _class2soap -> appendXML($request);

        /**
         * ʖǉĂ
         */
        $alias = $schema -> createComplexType($method_name);
        $alias_tmp = $schema -> createComplexContent();
        $alias_tmp -> add($schema -> createExtensionBase($request_name, $this -> _class2soap -> getTargetURI()));
        $alias -> add($alias_tmp);
        $this -> _class2soap -> appendXML($alias);

        /**
         * X|X\bhǉ
         */
        $response_name = $method_name . "Response";
        $response = $this -> _class2soap -> getDataTypeElement($response_name, $this -> _class2soap -> getReturnInfo());
        $this -> _class2soap -> appendXML($response);
    } 

    /**
     * 
     */
    public function visitParameter(AutoSOAP_ReflectionAccept $param)
    {
        $elemType = $this -> _class2soap -> getParameterInfo($param -> getName());
        $options = AutoSOAP_class2soap :: getParamOptions($param);

        return $this -> _class2soap -> getDataTypeElement($param -> getName(), $elemType, $options);
    } 

    /**
     * vpeB
     */
    public function visitProperty(AutoSOAP_ReflectionAccept $property)
    {
    } 
    /**
     * ֐
     */
    public function visitFunction(AutoSOAP_ReflectionAccept $func)
    {
    } 
    /**
     * IuWFNg
     */
    public function visitObject(AutoSOAP_ReflectionAccept $object)
    {
    } 
    /**
     * GNXeV
     */
    public function visitExtension(AutoSOAP_ReflectionAccept $extension)
    {
    } 

    /**
     * SOAPf[^ǗԂ
     */
    public function getClass2soap()
    {
        return $this -> _class2soap;
    } 
} 

?>