<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Session.class.php 77 2006-04-09 15:57:21Z sakamoto $
 */

/**
 * ZbVǗNX
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Session {
    /**
     * @var string
     */
    private $namespace;

    /**
     * CX^XIuWFNg
     * 
     * @var AutoSOAP_Session
     */
    private static $instance = null;

    /**
     * RXgN^
     * 
     * @access private
     * @param string $namespace
     * @return void 
     */
    private function __construct($namespace=null)
    {
        $this->namespace = (is_null($namespace)) ? null : '__'.$namespace.'__' ;
    }

    /**
     * CX^̎擾
     * 
     * @static 
     * @access public 
     * @param mixed $namespace ZbV㏑h~p̃l[Xy[X
     * @return AutoSOAP_Session
     */
    static public function getSession($namespace)
    {
        $key = (is_object($namespace)) ? get_class($namespace) : $namespace ;
        
        if (is_null(self :: $instance)) {
            session_start();
            self :: $instance = array();
        }

        if (!isset(self :: $instance[$key])) {
            $class = __CLASS__;
            self :: $instance[$key] = new $class($key);
        } 
        return self :: $instance[$key];
    }
    
    /**
     * vpeBݒ
     *
     * @access public 
     * @param string $name vpeB
     * @param string $val l
     * @return void
     */
    public function __set($name, $val) {
        if(is_null($this->namespace)) {
            $_SESSION[$name] = $val;
        } else {
            if(!isset($_SESSION[$this->namespace])) {
                $_SESSION[$this->namespace] = array();
            }
            $_SESSION[$this->namespace][$name] = $val;
        }
    }

    /**
     * vpeBݒ
     *
     * @access public 
     * @param string $name vpeB
     * @return mixed
     */
    public function __get($name) {
        if(is_null($this->namespace)) {
            return (isset($_SESSION[$name])) ? $_SESSION[$name] : null;
        } else {
            if(!isset($_SESSION[$this->namespace])) {
                $_SESSION[$this->namespace] = array();
            }
            return (isset($_SESSION[$this->namespace][$name])) ? $_SESSION[$this->namespace][$name] : null;
        }
    }
}
?>