<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Server.class.php 78 2006-04-11 13:51:37Z sakamoto $
 */

/**
 * AutoSOAPT[o{
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Server {
    /**
     * 񋟂T[rX̏
     * 
     * @var AutoSOAP _Service
     */
    private $service;

    /**
     * MONX
     * 
     * @var AutoSOAP _Logger
     */
    private $logger;

    /**
     * ϊ̃GR[h
     * 
     * @var string 
     */
    private $to_encoding = null;

    /**
     * ϊÕGR[h
     * 
     * @var string 
     */
    private $from_encoding = null;

    /**
     * SoapServerIuWFNg
     * 
     * @var SoapServer 
     */
    private $server;

    /**
     * \bh"schemaValidate"̃G[bZ[W
     * 
     * @var string 
     */
    private static $error_schemaValidate;

    /**
     * tB^[
     * 
     * @var array 
     */
    private static $filters;

    /**
     * CX^XIuWFNg
     * 
     * @var AutoSOAP _Server
     */
    private static $instance;

    /**
     * RXgN^
     * 
     * @access private 
     * @return void 
     */
    private function __construct()
    {
        $this -> filters = array();
    } 

    /**
     * CX^̎擾
     * 
     * @access public 
     * @return AutoSOAP _Server
     */
    static public function getInstance()
    {
        if (is_null(self :: $instance)) {
            $class = __CLASS__;
            self :: $instance = new $class();
            set_error_handler(array(self :: $instance, "soap_error_handler"));
        } 
        return self :: $instance;
    } 

    /**
     * SOAPbZ[W؂B
     * 
     * @static 
     * @access private 
     * @param string $soap_message 
     * @param string $xsd_file 
     * @return boolean 
     */
    static private function schemaValidate(&$soap_message, $xsd_file, $error_msg)
    {
        $aDOM = new DOMDocument('1.0', 'UTF-8');
        $patterns = array("/[^\s\:\"\']+\:encodingStyle=[\"\'][^\"\'\s]*[\"\']/i" ,
            "/([^<>\'\"\s]=[\'\"]http:\/\/www.w3.org)\/1999\/(XMLSchema)/i",
            );
        $replacements = array("", "\\1/2001/\\2");

        $aDOM -> loadXML(preg_replace($patterns, $replacements, $soap_message));

        $old = set_error_handler(array(self :: $instance, "schemaValidate_error_handler"));
        $result = $aDOM -> schemaValidate($xsd_file);
        set_error_handler($old);

        if (false === $result) {
            if (is_null($error_msg)) {
                $error_msg = self :: $error_schemaValidate;
            } 
            trigger_error($error_msg, E_USER_ERROR);
            return false;
        } 
        return true;
    } 

    /**
     * NGXgꂽ\bhԂ
     * sꍇ́ANULLԂ
     * 
     * @static 
     * @access private 
     * @param string $soap_message 
     * @param string $namespace 
     * @return boolean 
     */
    static private function getSoapMethodName(&$soap_message, $namespace)
    {
        $xml = simplexml_load_string($soap_message);
        if (false === $xml) {
            trigger_error("Not found the Soap Message.", E_USER_ERROR);
            return null;
        } 

        $path = "/*[local-name() = 'Envelope']/*[local-name() = 'Body']";
        $path .= "/*[namespace-uri() = '" . $namespace . "'][position()=1]";

        $result = $xml -> xpath($path);

        if (0 < count($result)) {
            $args = array();
            if (preg_match("/^<([^: \/\"'>]*:)?([^: \/\"'>]+)/", $result[0] -> asXML(), $args)) {
                if (isset($args[2]))
                    return $args[2];
            } 
        } 
        trigger_error("Not found the Soap Method or The namespace is wrong.", E_USER_ERROR);
        return null;
    } 

    /**
     * MONXZbg
     * 
     * @access public 
     * @param AutoSOAP $ _Logger $logger
     * @return boolean 
     */
    public function setLogger(AutoSOAP_Logger $logger)
    {
        $this -> logger = $logger;
    } 

    /**
     * T[rXZbg
     * 
     * @access public 
     * @param AutoSOAP $ _Service $service
     * @param integer $load_mode 
     * @return boolean 
     */
    public function setService(AutoSOAP_Service $service)
    {
        $this -> service = $service; 
        // T[rXNX̃CN[h
        $this -> service -> include_class();

        /**
         * WSDLXSDt@C𐶐
         */
        $timestamp = $this -> service -> getTimestamp();
        if ($this -> service -> need_update_wsdl_file()) {
            $this -> make_wsdl_file($timestamp);
        } 
        if ($this -> service -> need_update_xsd_file()) {
            $this -> make_xsd_file($timestamp);
        } 
    } 

    /**
     * T[rX̎s
     * 
     * @access public 
     * @return boolean 
     */
    public function execute($request = null)
    {
        if (is_null($request)) {
            global $HTTP_RAW_POST_DATA;
            $request = &$HTTP_RAW_POST_DATA;
        } 
        // T[o
        $this -> server = null; 
        // \bh݂̑̃`FbN
        $web_method = self :: getSoapMethodName($request, $this -> service -> getNamespace());
        if (is_null($web_method)) {
            return false;
        } 
        // tB^[s
        foreach($this -> filters as $filter) {
            // ZbVꍞ
            $filter_class_name = get_class($filter);
            $ref = new ReflectionClass($filter_class_name);
            $filter_static_properties = $ref -> getStaticProperties();
            foreach ($filter_static_properties as $key => $val) {
                $matches = array();
                if (preg_match("/^(?:__global_sess|__sess_(\S+))$/i", $key, $matches)) {
                    switch ($matches[0]) {
                    case '__global_sess' :
                        eval($filter_class_name . '::$' . $key . ' = AutoSOAP_Session::getSession(null);');
                        break;
                    default :
                        eval($filter_class_name . '::$' . $key . ' = AutoSOAP_Session::getSession("' . $matches[1] . '");');
                        break;
                    } 
                }
            }
            $filter -> execute($this -> service, $web_method);
        } 
  
        // Ó̃`FbN
        if (!is_null($this -> service -> getXsdPath())) {
            $error_msg = $this -> getValidateError($web_method);
            if (false === self :: schemaValidate($request, $this -> service -> getXsdPath(), $error_msg)) {
                return false;
            } 
        } 
        // T[rXNX̃CN[h
        $this -> service -> include_class(); 
        // SOAPT[o
        $this -> server = new SoapServer($this -> service -> getWsdlPath(),
            array('soap_version' => SOAP_1_1,
                'classmap' => $this -> getClassmap()
                )
            ); 
        // NX擾
        $class_name = $this -> service -> getClassName(); 
        // ZbVꍞ
        $ref = new ReflectionClass($class_name);
        $static_properties = $ref -> getStaticProperties();
        foreach ($static_properties as $key => $val) {
            $matches = array();
            if (preg_match("/^(?:__global_sess|__sess(?:_(\S+))?)$/i", $key, $matches)) {
                switch ($matches[0]) {
                case '__global_sess' :
                    eval($class_name . '::$' . $key . ' = AutoSOAP_Session::getSession(null);');
                    break;
                case '__sess' :
                    eval($class_name . '::$' . $key . ' = AutoSOAP_Session::getSession("' . $class_name . '");');
                    break;
                default :
                    eval($class_name . '::$' . $key . ' = AutoSOAP_Session::getSession("' . $matches[1] . '");');
                    break;
                } 
            } 
        } 
        // T[rX̎s
        $this -> server -> setClass($class_name);
        $this -> server -> handle($request); 
        // T[oZbg
        $this -> server = null;

        return true;
    } 

    /**
     * WSDLt@C\
     * 
     * @access public 
     * @return void 
     */
    public function wsdl()
    {
        // header("Content-Type: text/xml; charset=UTF-8");
        header("Content-Type: text/xml;");
        echo file_get_contents($this -> service -> getWsdlPath());
    } 

    /**
     * WSDLt@C쐬
     * 
     * @access private 
     * @return boolean 
     */
    private function make_wsdl_file($timestamp)
    {
        include_once(dirname(__FILE__) . "/class2soap.php");
        $engine = new AutoSOAP_class2wsdl($this -> service -> getClassName(),
            $this -> service -> getNamespace(),
            $this -> service -> getLocation());

        $result = file_put_contents($this -> service -> getWsdlPath(), $engine -> getResult($this -> to_encoding, $this -> from_encoding));
        if ($result && !is_null($timestamp)) {
            touch($this -> service -> getWsdlPath(), $timestamp);
        } 
        // NX}bvĂ
        $content = "<?php\n";
        $content .= "\$_=" . var_export($engine -> getClassmap(), true) . ";\n";
        $content .= "\$_validate_errors=" . var_export($engine -> getValidateErrorMap(), true) . ";\n";
        $content .= "?>";
        $result_c = file_put_contents($this -> service -> getClassmapPath(), $content);
        if ($result_c && !is_null($timestamp)) {
            touch($this -> service -> getClassmapPath(), $timestamp);
        } 

        return $result;
    } 

    /**
     * XSDt@C쐬
     * 
     * @access private 
     * @return boolean 
     */
    private function make_xsd_file($timestamp)
    {
        if (is_null($this -> service -> getXsdPath())) {
            return false;
        } 

        include_once(dirname(__FILE__) . "/class2soap.php");
        $base_dir = str_replace("\\", "/", dirname(__FILE__));
        $soapenv_uri = $base_dir . '/xsd/soapenv.xsd';
        $soapenc_uri = $base_dir . '/xsd/soapenc.xsd';

        $engine = new AutoSOAP_class2SoapXsd($this -> service -> getClassName(),
            $this -> service -> getNamespace(),
            $soapenv_uri,
            $soapenc_uri);

        $result = file_put_contents($this -> service -> getXsdPath(), $engine -> getResult($this -> to_encoding, $this -> from_encoding));
        if ($result && !is_null($timestamp)) {
            touch($this -> service -> getXsdPath(), $timestamp);
        } 

        return $result;
    } 

    /**
     * NX}bv擾
     * 
     * @access public 
     * @return array 
     */
    private function getClassmap()
    {
        include($this -> service -> getClassmapPath());
        return (isset($_))?$_ : array();
    } 

    /**
     * ؎̃G[bZ[W擾
     * 
     * @access public 
     * @return array 
     */
    private function getValidateError($method)
    {
        include($this -> service -> getClassmapPath());
        return (isset($_validate_errors[$method]))?$_validate_errors[$method] : null;
    } 

    /**
     * GR[hݒ肷
     * 
     * @access public 
     * @return void 
     */
    public function setEncoding($to_encoding = null, $from_encoding = null)
    {
        $this -> to_encoding = $to_encoding;
        $this -> from_encoding = $from_encoding;
    } 

    /**
     * tB^[Zbg
     * 
     * @access public 
     * @param AutoSOAP $ _Filter $filter
     */
    public function appendFilter(AutoSOAP_Filter $filter)
    {
        $this -> filters[] = $filter;
    } 

    /**
     * SOAPpG[nhO
     * 
     * @access public 
     * @return void 
     */
    public function soap_error_handler($errno, $errstr, $errfile, $errline)
    { 
        // E_STRICT͖
        if (E_STRICT === $errno) {
            return;
        } 

        $result = false; 
        // Oo
        if ($this -> logger instanceof AutoSOAP_Logger) {
            $result = $this -> logger -> output($this -> service, $errno, $errstr, $errfile, $errline);
        } 
        // TRUEꍇASOAPG[bZ[W͏o͂ȂB
        if (true === $result) {
            return ;
        } 
        // SOAPG[bZ[Wo
        $errortype = array (
            E_ERROR => "Error",
            E_WARNING => "Warning",
            E_PARSE => "Parsing Error",
            E_NOTICE => "Notice",
            E_CORE_ERROR => "Core Error",
            E_CORE_WARNING => "Core Warning",
            E_COMPILE_ERROR => "Compile Error",
            E_COMPILE_WARNING => "Compile Warning",
            E_USER_ERROR => "User Error",
            E_USER_WARNING => "User Warning",
            E_USER_NOTICE => "User Notice",
            E_STRICT => "Runtime Notice"
            );
        $mssg = $errortype[$errno] . ': ' . $errstr;
        $debug = debug_backtrace();
        $faultactor = "\n";
        foreach($debug as $key => $val) {
            $faultactor .= '#' . $key . ' ' . $val['class'] . $val['type'] . $val['function'] . '()' . ' called at [' . $val['file'] . ':' . $val['line'] . "]\n";
        } 
        if (is_null($this -> server)) {
            $this -> server = new SoapServer(null, array('soap_version' => SOAP_1_1, 'uri' => "http://localhost/"));
            $this -> server -> fault("Server", $mssg, null, $faultactor);
            $this -> server = null;
        } else {
            throw new SoapFault("Server", $mssg, null, $faultactor);
        } 
    } 

    /**
     * schemaValidatepSOAPpG[nhO
     * 
     * @access public 
     * @return void 
     */
    public function schemaValidate_error_handler($errno, $errstr, $errfile, $errline)
    {
        self :: $error_schemaValidate = $errstr;
    } 
} 

?>