<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: class2soapVisitor.class.php 75 2006-04-06 13:35:12Z sakamoto $
 */

/**
 * NXSOAPpXML𐶐ׂ̃rW^[eNX
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
abstract class AutoSOAP_class2soapVisitor implements AutoSOAP_ReflectionVisitor {
    // XMLf[^ێIuWFNg
    protected $_root; 
    // ^[Qbgl[Xy[X
    protected $_Target_uri; 
    // ClassXSDNX
    protected $_class2xsd; 
    // XMLXL[}^ONX
    protected $_schema; 
    // \bh̃Ame[Vꎞۑp
    private $_method_elemTypes;

    public function __construct()
    {
        $this->_schema = AutoSOAP_XMLogic_SchemaFactory :: getInstance();
    } 

    /**
     * 
     */
    public function init($target_uri, $root, $class2xsd)
    {
        $this->_Target_uri = $target_uri;
        $this->_root = $root;
        $this->_class2xsd = $class2xsd;
    } 

    /**
     * NX}bvԂ
     */
    public function getClassmap()
    {
        return $this->_class2xsd->getClassmap();
    } 

    /**
     * z}bvԂ
     */
    public function getArraymap()
    {
        return $this->_class2xsd->getArraymap();
    } 

    /**
     * ʂԂ
     */
    public function getResult($to_encoding = null, $from_encoding = null)
    {
        $text = new AutoSOAP_XMLogic_exportTextVisitor();
        if ($this->_root->accept($text)) {
            return $text->getResult($to_encoding, $from_encoding);
        } 
        return null;
    } 

    /**
     * NX
     */
    public function visitClass(AutoSOAP_ReflectionAccept $class)
    { 
        /*
         * C^[tF[XV^CN[h
         */
        $interfaces = $class->getInterfaces();
        $interfaces->accept($this->_class2xsd);
        
        /*
         * Ame[V̎擾
         */
        //$annotation = AutoSOAP_Anno :: parseReflector($class);
        //$elemTypes = AutoSOAP_ElementType :: createByClass($annotation);
        //foreach($elemTypes as $newtype => $elemType) {
        //    $this->_class2xsd->getElementInfo('', $elemType, array('new_type'=>$newtype));
        //}

        // \bhǉ
        $class->getMethods()->accept($this);
    } 

    /**
     * \bh
     */
    public function visitMethod(AutoSOAP_ReflectionAccept $method)
    {
        $method_name = $method->getName(); 
        // ANZX public oȂꍇ́AǉȂ
        if (!$method->isPublic()) {
            return null;
        } 

        /*
         * \bh̓Ɂu__vꍇ́AǉȂ
         */
        if(preg_match("/^__/i",$method_name)) {
            return null;
        }
        
        /*
         * Ame[V̎擾
         */
        $annotation = AutoSOAP_Anno :: parseReflector($method);
        // ANZX擾
        $anno_access = $annotation->execute(new AutoSOAP_Anno_AccessCmd());
        if ('public' !== $anno_access && !is_null($anno_access)) {
            return ;
        }
        $this->_method_elemTypes = AutoSOAP_ElementType :: createByMethod($annotation);
        
        return $this->appendMethod($method, $this->_method_elemTypes);
    } 

    /**
     * 
     */
    public function visitParameter(AutoSOAP_ReflectionAccept $param)
    {
        $options = array();
        $options['default'] = $param->isDefaultValueAvailable();
        $ref_class = $param->getClass();
        if (is_null($ref_class)) {
            $options['ref_class'] = $ref_class;
        }
        
		$elemType = (isset($this->_method_elemTypes['$' . $param->getName()]))
		          ? $this->_method_elemTypes['$' . $param->getName()]
		          : new  AutoSOAP_ElementType();
        return $this->appendParameter($param, $elemType, $options);
    } 

    /**
     * q
     */
    public function visitChildren(AutoSOAP_ReflectionChildren $children)
    {
        $itr = $children->getIterator();
        if (!$itr->valid()) {
            return ;
        } 
        $type = $itr->current()->getReflectionType();
        switch ($type) {
        case 'ReflectionMethod':
            while ($itr->valid()) {
                $itr->current()->accept($this);
                $itr->next();
            } 
            return ;

        case 'ReflectionParameter':
            $result = array();
            while ($itr->valid()) {
                $tmp = $itr->current()->accept($this);
                if (!is_null($tmp))
                    $result[] = $tmp;
                $itr->next();
            } 
            return $result;
        } 

        return null;
    } 

    /**
     * vpeB
     */
    final public function visitProperty(AutoSOAP_ReflectionAccept $property)
    {
    } 
    /**
     * ֐
     */
    final public function visitFunction(AutoSOAP_ReflectionAccept $func)
    {
    } 
    /**
     * IuWFNg
     */
    final public function visitObject(AutoSOAP_ReflectionAccept $object)
    {
    } 
    /**
     * GNXeV
     */
    final public function visitExtension(AutoSOAP_ReflectionAccept $extension)
    {
    } 

    /**
     * \bhǉ
     */
    abstract public function appendMethod(AutoSOAP_ReflectionAccept $method, $elemTypes);

    /**
     * ǉ
     */
    abstract public function appendParameter(AutoSOAP_ReflectionAccept $param, AutoSOAP_ElementType $elemType, $options);
} 

?>