<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: XMLogic.php 68 2006-04-01 14:27:55Z sakamoto $
 */

/**
 * l[Xy[XɑΉL[To܂B
 * ʂɂ͒ToꂽL[i[܂B
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_searchXmlnsVisitor extends AutoSOAP_XMLogic_Visitor {
    private $_uri;

    public function __construct($uri)
    {
        $this->_uri = $uri;
    } 
    // Gg
    public function visitElement(AutoSOAP_XMLogic_Element $elem)
    {
        return (false === $elem->getXmlns()->accept($this))
        ? $this->acceptParent($elem)
        : true ;
    } 
    // O
    public function visitVariable(AutoSOAP_XMLogic_Variable $nobj)
    {
        return $this->acceptParent($nobj);
    } 
    // e
    public function visitContent(AutoSOAP_XMLogic_Content $content)
    {
        return $this->acceptParent($content);
    } 
    // q
    public function visitChildren(AutoSOAP_XMLogic_Children $children)
    {
        $itr = $children->getIterator();
        while ($itr->valid()) {
            if (false !== $itr->current()->accept($this))
                return true;
            $itr->next();
        } 
        return false;
    } 
    // 
    public function visitAttribute(AutoSOAP_XMLogic_Attribute $attr)
    {
        return $this->acceptParent($attr);
    } 
    // l[Xy[X
    public function visitXmlns(AutoSOAP_XMLogic_NS $nsobj)
    {
        if ($this->_uri == $nsobj->getURI()) {
            $this->setResult($nsobj->getNS()) ;
            return true;
        } 
        return false;
    } 

    private function acceptParent($target)
    {
        return ($target->getParent())
        ? $target->getParent()->accept($this)
        : false ;
    } 
} 

/**
 * L[ɑTo܂B
 * ʂɂ͒Toꂽ̒li[܂B
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_searchAttributeVisitor extends AutoSOAP_XMLogic_Visitor {
    private $_name;

    public function __construct($name, $namespace = null)
    {
        $this->_name = new AutoSOAP_XMLogic_Variable($name, $namespace);
    } 
    // Gg
    public function visitElement(AutoSOAP_XMLogic_Element $elem)
    {
        return $elem->getAttribute()->accept($this);
    } 
    // O
    public function visitVariable(AutoSOAP_XMLogic_Variable $nobj)
    {
        return $this->acceptParent($nobj);
    } 
    // e
    public function visitContent(AutoSOAP_XMLogic_Content $content)
    {
        return $this->acceptParent($content);
    } 
    // q
    public function visitChildren(AutoSOAP_XMLogic_Children $children)
    {
        $itr = $children->getIterator();
        while ($itr->valid()) {
            if (false !== $itr->current()->accept($this))
                return true;
            $itr->next();
        } 
        return false;
    } 
    // 
    public function visitAttribute(AutoSOAP_XMLogic_Attribute $attr)
    {
        $keyobj = $attr->getKey();

        if ($this->_name->getName() == $keyobj->getName() && $this->_name->getNamespace() == $keyobj->getNamespace()
                ) {
            $this->setResult($attr->getValue()) ;
            return true;
        } 
        return false;
    } 
    // l[Xy[X
    public function visitXmlns(AutoSOAP_XMLogic_NS $nsobj)
    {
        return $this->acceptParent($nsobj);
    } 

    private function acceptParent($target)
    {
        return ($target->getParent())
        ? $target->getParent()->accept($this)
        : false ;
    } 
} 

/**
 * AutoSOAP_XMLogicGgNX
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_Element extends AutoSOAP_XMLogic_Obj {
    private $_node = null;
    private $_tag_name;
    private $_attributes = null;
    private $_xmlns = null;

    final public function getAcceptMethodName()
    {
        return "visitElement";
    } 

    public function __construct(AutoSOAP_XMLogic_Variable $name)
    {
        $this->_tag_name = $name;
        $this->_attributes = new AutoSOAP_XMLogic_Children();
        $this->_xmlns = new AutoSOAP_XMLogic_Children();

        $this->_tag_name->setParent($this);
        $this->_attributes->setParent($this);
        $this->_xmlns->setParent($this);
    } 

    protected function setNode($node)
    {
        if (is_null($this->_node)) {
            $this->_node = $node;
            $this->_node->setParent($this);
        } 
    } 

    public function getTagName()
    {
        return $this->_tag_name;
    } 

    public function getNode()
    {
        return $this->_node;
    } 

    public function getAttribute()
    {
        return $this->_attributes;
    } 

    public function getXmlns()
    {
        return $this->_xmlns;
    } 

    public function add(AutoSOAP_XMLogic_Obj $obj)
    {
        if ($obj instanceof AutoSOAP_XMLogic_Attribute) {
            $key = $obj->getKey()->getName() . '@' . $obj->getKey()->getNamespace();
            return $this->getAttribute()->add($obj, $key);
        } else if ($obj instanceof AutoSOAP_XMLogic_NS) {
            return $this->getXmlns()->add($obj, $obj->getNS());
        } 

        trigger_error("Class of " . get_class($obj) . " was not able to be added.", E_USER_WARNING);

        return null;
    } 
} 

/**
 * AutoSOAP_XMLogicGgŃc[\ׂ̃NX
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_Tree extends AutoSOAP_XMLogic_Element {
    public function __construct(AutoSOAP_XMLogic_Variable $name)
    {
        parent :: __construct($name);
        $this->setNode(new AutoSOAP_XMLogic_Children());
    } 
    public function add(AutoSOAP_XMLogic_Obj $obj, $index = -1)
    {
        if ($obj instanceof AutoSOAP_XMLogic_Element) {
            return $this->getNode()->add($obj, $index);
        } 

        return parent :: add($obj);
    } 
} 

/**
 * AutoSOAP_XMLogicGgŒl\ׂ̃NX
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_Value extends AutoSOAP_XMLogic_Element {
    public function __construct(AutoSOAP_XMLogic_Variable $name, $content)
    {
        parent :: __construct($name);
        $this->setNode(new AutoSOAP_XMLogic_Content($content));
    } 
} 

/**
 * AutoSOAP_XMLogic̖O\ׂ̃NX
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_Variable extends AutoSOAP_XMLogic_Obj {
    private $_name;
    private $_namespace;

    final public function getAcceptMethodName()
    {
        return "visitVariable";
    } 

    public function __construct($name, $namespace = null)
    {
        $this->_name = $name;
        $this->_namespace = $namespace;
    } 

    public function getName()
    {
        return $this->_name;
    } 

    public function getNamespace()
    {
        return $this->_namespace;
    } 
} 

/**
 * AutoSOAP_XMLogic̑\ׂ̃NX
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_Attribute extends AutoSOAP_XMLogic_Obj {
    private $_key;
    private $_value;

    final public function getAcceptMethodName()
    {
        return "visitAttribute";
    } 

    public function __construct(AutoSOAP_XMLogic_Variable $key, AutoSOAP_XMLogic_Variable $value)
    {
        $this->_key = $key;
        $this->_value = $value;
        $this->_key->setParent($this);
        $this->_value->setParent($this);
    } 

    public function getKey()
    {
        return $this->_key;
    } 

    public function getValue()
    {
        return $this->_value;
    } 
} 

/**
 * AutoSOAP_XMLogic̃l[Xy[X\ׂ̃NX
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_NS extends AutoSOAP_XMLogic_Obj {
    private $_ns;
    private $_uri;

    final public function getAcceptMethodName()
    {
        return "visitXmlns";
    } 

    public function __construct($ns, $uri)
    {
        $this->_ns = $ns;
        $this->_uri = $uri;
    } 

    public function getNS()
    {
        return $this->_ns;
    } 

    public function getURI()
    {
        return $this->_uri;
    } 
} 

/**
 * AutoSOAP_XMLogic̓e\ׂ̃NX
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_Content extends AutoSOAP_XMLogic_Obj {
    private $_content;

    final public function getAcceptMethodName()
    {
        return "visitContent";
    } 

    public function __construct($content)
    {
        $this->_content = $content;
    } 

    public function getContent()
    {
        return $this->_content;
    } 
} 

/**
 * AutoSOAP_XMLogic̎qǗׂ̃NX
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_Children extends AutoSOAP_XMLogic_Obj {
    private $_children = array();

    final public function getAcceptMethodName()
    {
        return "visitChildren";
    } 

    public function add($child, $index = -1)
    {
        $child->setParent($this->getParent());
        if ('' == $index) {
            $index = 0;
        } 
        $count = count($this->_children);
        if (is_numeric($index) && -1 < $index && $count > $index) {
            if (0 == $index) {
                array_unshift($this->_children, $child);
            } else {
                for($i = $count;$i > $index;$i--) {
                    $this->_children[$i] = $this->_children[$i-1];
                } 
                $this->_children[$index] = $child;
            } 
        } else if (is_string($index)) {
            $this->_children[$index] = $child;
        } else {
            $this->_children[] = $child;
        } 
        return $child;
    } 

    public function getIterator()
    {
        $tmp = new ArrayObject($this->_children);
        return $tmp->getIterator();
    } 
} 

/**
 * AutoSOAP_XMLogicIuWFNg𐶐ׂ̃NX
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_XMLogic_XMLFactory {
    private static $instance;

    private function __construct()
    { ;
    } 

    public static function getInstance()
    {
        if (self :: $instance == null) {
            self :: $instance = new AutoSOAP_XMLogic_XMLFactory();
        } 
        return self :: $instance;
    } 

    /**
     * c[^̃Gg𐶐
     */
    public function node($name, $namespace = null)
    {
        return new AutoSOAP_XMLogic_Tree(new AutoSOAP_XMLogic_Variable($name, $namespace));
    } 

    /**
     * l^̃Gg𐶐
     */
    public function content($name, $value, $namespace = null)
    {
        return new AutoSOAP_XMLogic_Value(new AutoSOAP_XMLogic_Variable($name, $namespace), $value);
    } 

    /**
     * 𐶐
     */
    public function attr($name, $value)
    {
        $name_obj = (is_array($name))
        ? new AutoSOAP_XMLogic_Variable($name[0], $name[1])
        : new AutoSOAP_XMLogic_Variable($name) ;
        $value_obj = (is_array($value))
        ? new AutoSOAP_XMLogic_Variable($value[0], $value[1])
        : new AutoSOAP_XMLogic_Variable($value) ;

        return new AutoSOAP_XMLogic_Attribute($name_obj, $value_obj);
    } 

    /**
     * l[Xy[X𐶐
     */
    public function xmlns($name, $namespace = null)
    {
        return new AutoSOAP_XMLogic_NS($name, $namespace);
    } 

    /**
     * l[Xy[XɌAl[Xy[X̃L[Ԃ
     */
    static public function searchXmlns($target, $uri)
    {
        $searcher = new AutoSOAP_XMLogic_searchXmlnsVisitor($uri);
        $target->accept($searcher);
        return $searcher->getResult();
    } 

    /**
     * ̃L[ɌA̒lԂ
     */
    static public function searchAttrigute($target, $name, $namespace = null)
    {
        $searcher = new AutoSOAP_XMLogic_searchAttributeVisitor($name, $namespace);
        $target->accept($searcher);
        return $searcher->getResult();
    } 
} 

/**
 * AutoSOAP_XMLogicIuWFNgNXB
 * 
 * @package jp.servlet.AutoSOAP.XMLogic
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
abstract class AutoSOAP_XMLogic_Obj {
    private $_parent;
    public function setParent($parent)
    {
        $this->_parent = $parent;
    } 
    public function getParent()
    {
        return $this->_parent;
    } 
    public function accept(AutoSOAP_XMLogic_Visitor $visitor)
    {
        $func = $this->getAcceptMethodName();
        return $visitor->$func($this);
    } 

    abstract public function getAcceptMethodName();
} 

?>