<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: FileLogger.class.php 74 2006-04-05 14:29:06Z sakamoto $
 */

/**
 * AutoSOAP_ServerpȈՃMO
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_FileLogger implements AutoSOAP_Logger {
    private $dir;

    /**
     * RXgN^
     * 
     * @access public 
     * @param string $dir O̕ۑ
     */
    public function __construct($dir)
    {
        $this->dir = $dir . '/';
    } 

    /**
     * Ȍo
     * 
     * @access public 
     * @param AutoSOAP_Service $service s̃T[rX
     * @param integer $errno G[ԍ
     * @param string $errstr G[bZ[W
     * @param string $errfile G[ot@CpX
     * @param string $errline G[os
     */
    public function output(AutoSOAP_Service $service, $errno, $errstr, $errfile, $errline)
    {
        $errortype = array (
                E_ERROR           => "Error",
                E_WARNING         => "Warning",
                E_PARSE           => "Parsing Error",
                E_NOTICE          => "Notice",
                E_CORE_ERROR      => "Core Error",
                E_CORE_WARNING    => "Core Warning",
                E_COMPILE_ERROR   => "Compile Error",
                E_COMPILE_WARNING => "Compile Warning",
                E_USER_ERROR      => "User Error",
                E_USER_WARNING    => "User Warning",
                E_USER_NOTICE     => "User Notice",
                E_STRICT          => "Runtime Notice"
                );
				$err_mark = $errortype[$errno];
				
        date_default_timezone_set('UTC');
        $file_path = $this->dir . date("Ymd", time()) . '.txt';
        if (!$handle = fopen($file_path, 'a+')) {
            return false;
        } 
        $mssg = date("H:i:s", time()) . ' ' . $err_mark . ': ' . $errstr . "\r\n";
        if (false === fwrite($handle, $mssg)) {
            fclose($handle);
            return false;
        } 

        if (!is_null($request)) {
            if (false === fwrite($handle, $request . "\r\n")) {
                fclose($handle);
                return false;
            } 
        } 
        fclose($handle);
        
        return (boolean)((E_STRICT | E_NOTICE | E_USER_NOTICE) & $errno);
    } 
} 

?>