<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Service.class.php 71 2006-04-05 12:37:38Z sakamoto $
 */

/**
 * AutoSOAPT[rX`NX
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Service {
    /**
     * ^CX^v(YYYY/MM/DD HH:MM:SS)
     * null̏ꍇAWSDLt@C̍XV擾
     * 
     * @var string 
     */
    private $timestamp = null;

    /**
     * NX
     * 
     * @var string 
     */
    private $class_name;
    /**
     * NX̃t@CpX
     * 
     * @var string 
     */
    private $class_path;
    /**
     * WSDLt@CpX
     * 
     * @var string 
     */
    private $wsdl_path;
    /**
     * XSDt@CpX
     * 
     * @var string 
     */
    private $xsd_path;
    /**
     * NX}bvt@CpX
     * 
     * @var string 
     */
    private $classmap_path;
    /**
     * P[ViNCAgANZXURLj
     * 
     * @var string 
     */
    private $location;
    /**
     * l[Xy[X
     * 
     * @var string 
     */
    private $namespace;

    /**
     * RXgN^
     * 
     * @access public 
     * @param AutoSOAPEnvironment $env 
     * @return void 
     */
    public function __construct($class_name, $class_path, $wsdl_path, $xsd_path, $classmap_path, $location, $namespace, $timestamp=null)
    {
        $this->class_name = $class_name;
        $this->class_path = $class_path;
        $this->wsdl_path = $wsdl_path;
        $this->xsd_path = $xsd_path;
        $this->classmap_path = $classmap_path;
        $this->location = $location;
        $this->namespace = $namespace;
        $this->timestamp = $timestamp;
    } 

    /**
     * P[VԂ
     * 
     * @return string 
     */
    public function getLocation()
    {
        return $this->location;
    } 

    /**
     * l[Xy[XԂ
     * 
     * @return string 
     */
    public function getNamespace()
    {
        return $this->namespace;
    } 

    /**
     * NXԂ
     * 
     * @return string 
     */
    public function getClassName()
    {
        return $this->class_name;
    } 

    /**
     * NXCN[h
     * 
     * @return void 
     */
    public function include_class()
    {
        if (!is_null($this->class_path)) {
            include_once($this->class_path);
        } 
    } 

    /**
     * WSDLt@CpXԂ
     * 
     * @return string 
     */
    public function getWsdlPath()
    {
        return $this->wsdl_path;
    } 

    /**
     * XSDt@CpXԂ
     * 
     * @return string 
     */
    public function getXsdPath()
    {
        return $this->xsd_path;
    } 

    /**
     * NX}bṽt@CpXԂ
     * 
     * @return string 
     */
    public function getClassmapPath()
    {
        return $this->classmap_path;
    } 

    /**
     * ^CX^vԂ
     * 
     * @access public 
     * @return integer 
     */
    public function getTimestamp()
    {
        $timezone = date_default_timezone_get();
        if(!$timezone) {
            date_default_timezone_get('GMT');
        }
        $timestamp = (is_null($this->timestamp))
                   ? filemtime($this->class_path)
                   : preg_replace("/^([0-9]{4})?\/?([0-9]{1,2})?\/?([0-9]{1,2})? ?([0-9]{1,2})?:?([0-9]{1,2})?:?([0-9]{1,2})?/e", "mktime(((int)'$4'),((int)'$5'),((int)'$6'),((int)'$2'),((int)'$3'),((int)'$1'))", $this->timestamp);

        if(!$timezone) {
            date_default_timezone_get($timezone);
        }
        return $timestamp;
    }
    
    /**
     * WSDLt@C̍XVKvԂ
     * 
     * @access public 
     * @return boolean 
     */
    public function need_update_wsdl_file()
    {
        return (is_file($this->getWsdlPath()))
             ? ($this->getTimestamp() != filemtime($this->getWsdlPath()))
             : true ;
    } 

    /**
     * WSDLt@C̍XVKvԂ
     * 
     * @access public 
     * @return boolean 
     */
    public function need_update_xsd_file()
    {
        return (is_file($this->getXsdPath()))
              ? ($this->getTimestamp() != filemtime($this->getXsdPath()))
              : true ;
    } 
} 
?>