<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: Server.class.php 74 2006-04-05 14:29:06Z sakamoto $
 */

/**
 * AutoSOAPT[o{
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_Server {
    /**
     * 񋟂T[rX̏
     * 
     * @var AutoSOAP_Service
     */
    private $service;

    /**
     * MONX
     * 
     * @var AutoSOAP_Logger
     */
    private $logger;

    /**
     * ϊ̃GR[h
     * 
     * @var string 
     */
    private $to_encoding = null;

    /**
     * ϊÕGR[h
     * 
     * @var string 
     */
    private $from_encoding = null;

    /**
     * SoapServerIuWFNg
     * 
     * @var SoapServer
     */
    private $server;

    /**
     * CX^XIuWFNg
     * 
     * @var AutoSOAP_Server
     */
    private static $instance;

    /**
     * RXgN^
     * 
     * @access private 
     * @return void 
     */
    private function __construct()
    {
    } 

    /**
     * CX^̎擾
     * 
     * @access public 
     * @return AutoSOAP_Server
     */
    static public function getInstance()
    {
        if (is_null(self :: $instance)) {
            $class = __CLASS__;
            self :: $instance = new $class();
            set_error_handler(array(self :: $instance, "soap_error_handler"));
        } 
        return self :: $instance;
    } 

    /**
     * SOAPbZ[W؂B
     * 
     * @static 
     * @access private 
     * @param string $soap_message 
     * @param string $xsd_file 
     * @return boolean 
     */
    static private function schemaValidate(&$soap_message, $xsd_file)
    {
        $aDOM = new DOMDocument('1.0', 'UTF-8');
        $patterns = array("/[^\s\:\"\']+\:encodingStyle=[\"\'][^\"\'\s]*[\"\']/i" ,
            "/([^<>\'\"\s]=[\'\"]http:\/\/www.w3.org)\/1999\/(XMLSchema)/i",
            );
        $replacements = array("", "\\1/2001/\\2");

        $aDOM->loadXML(preg_replace($patterns, $replacements, $soap_message));

        if (false === @$aDOM->schemaValidate($xsd_file)) {
            trigger_error("Validate Error", E_USER_ERROR);
            return false;
        } 
        return true;
    } 

    /**
     * NGXgꂽ\bhԂ
     * sꍇ́ANULLԂ
     * 
     * @static 
     * @access private 
     * @param string $soap_message 
     * @param string $namespace 
     * @return boolean 
     */
    static private function getSoapMethodName(&$soap_message, $namespace)
    {
        $xml = simplexml_load_string($soap_message);
        if(false === $xml) {
            trigger_error("Not found the Soap Message.", E_USER_ERROR);
            return null;
        }
        
        $path = "/*[local-name() = 'Envelope']/*[local-name() = 'Body']";
        $path .= "/*[namespace-uri() = '" . $namespace . "'][position()=1]";

        $result = $xml->xpath($path);

        if (0 < count($result)) {
            $args = array();
            if (preg_match("/^<([^: \/\"'>]*:)?([^: \/\"'>]+)/", $result[0]->asXML(), $args)) {
                if (isset($args[2]))
                    return $args[2];
            } 
        }
        trigger_error("Not found the Soap Method or The namespace is wrong.", E_USER_ERROR);
        return null;
    } 

    /**
     * MONXZbg
     * 
     * @access public 
     * @param AutoSOAP_Logger $logger
     * @return boolean 
     */
    public function setLogger(AutoSOAP_Logger $logger)
    {
        $this->logger = $logger;
    } 

    /**
     * T[rXZbg
     * 
     * @access public 
     * @param AutoSOAP_Service $service
     * @param integer $load_mode 
     * @return boolean 
     */
    public function setService(AutoSOAP_Service $service)
    {
        $this->service = $service;

        // T[rXNX̃CN[h
        $this->service->include_class();

        /*
         * WSDLXSDt@C𐶐
         */
        $timestamp = $this->service->getTimestamp();
        if ($this->service->need_update_wsdl_file()) {
            $this->make_wsdl_file($timestamp);
        }
        if ($this->service->need_update_xsd_file()) {
            $this->make_xsd_file($timestamp);
        }
    } 

    /**
     * T[rX̎s
     * 
     * @access public 
     * @return boolean 
     */
    public function execute($request = null)
    {
        if (is_null($request)) {
            global $HTTP_RAW_POST_DATA;
            $request = $HTTP_RAW_POST_DATA;
        }
        
        //T[o
        $this->server = null;

        // Ó̃`FbN
        if(is_null(self :: getSoapMethodName($request, $this->service->getNamespace()))) {
        	return false;
        }

        if(!is_null($this->service->getXsdPath())) {
            if(false === self :: schemaValidate($request, $this->service->getXsdPath())) {
                return false;
            }
        }
        
        // T[rXNX̃CN[h
        $this->service->include_class(); 
        
        // SOAPT[o
        $this->server = new SoapServer($this->service->getWsdlPath(),
            array('soap_version' => SOAP_1_1,
                'classmap' => $this->getClassmap()
                )
            );

        $this->server->setClass($this->service->getClassName());
        $this->server->setPersistence(SOAP_PERSISTENCE_SESSION);
        $this->server->handle($request);

        //T[oZbg
        $this->server = null;
        
        return true;
    } 

    /**
     * WSDLt@C\
     * 
     * @access public 
     * @return void 
     */
    public function wsdl()
    {
//      header("Content-Type: text/xml; charset=UTF-8");
        header("Content-Type: text/xml;");
        echo file_get_contents($this->service->getWsdlPath());
    } 

    /**
     * WSDLt@C쐬
     * 
     * @access private 
     * @return boolean 
     */
    private function make_wsdl_file($timestamp)
    {
        include_once(dirname(__FILE__) . "/class2soap.php");
        $engine = new AutoSOAP_class2wsdl($this->service->getClassName(),
            $this->service->getNamespace(),
            $this->service->getLocation());

        $result = file_put_contents($this->service->getWsdlPath(), $engine->getResult($this->to_encoding, $this->from_encoding));
        if($result && !is_null($timestamp)) {
            touch($this->service->getWsdlPath(), $timestamp);
        }

        // NX}bvĂ
        $result_c = file_put_contents($this->service->getClassmapPath(), "<?\$_=" . var_export($engine->getClassmap(), true) . ";?>");
        if($result_c && !is_null($timestamp)) {
            touch($this->service->getClassmapPath(), $timestamp);
        }
        
        return $result;
    } 

    /**
     * XSDt@C쐬
     * 
     * @access private 
     * @return boolean 
     */
    private function make_xsd_file($timestamp)
    {
        if(is_null($this->service->getXsdPath())) {
            return false;
        }
        
        include_once(dirname(__FILE__) . "/class2soap.php");
        $base_dir = str_replace("\\", "/", dirname(__FILE__));
        $soapenv_uri = $base_dir . '/xsd/soapenv.xsd';
        $soapenc_uri = $base_dir . '/xsd/soapenc.xsd';

        $engine = new AutoSOAP_class2SoapXsd($this->service->getClassName(),
            $this->service->getNamespace(),
            $soapenv_uri,
            $soapenc_uri);
        
        $result = file_put_contents($this->service->getXsdPath(), $engine->getResult($this->to_encoding, $this->from_encoding));
        if($result && !is_null($timestamp)) {
            touch($this->service->getXsdPath(), $timestamp);
        }
        
        return $result;
   } 

    /**
     * NX}bv擾
     * 
     * @access public 
     * @return array 
     */
    private function getClassmap()
    {
        include_once($this->service->getClassmapPath());
        return (isset($_))?$_ : array();
    } 

    /**
     * GR[hݒ肷
     * 
     * @access public 
     * @return void 
     */
    public function setEncoding($to_encoding = null, $from_encoding = null)
    {
        $this->to_encoding = $to_encoding;
        $this->from_encoding = $from_encoding;
    } 

    /**
     * SOAPpG[nhO
     * 
     * @access public 
     * @return void 
     */
    public function soap_error_handler($errno, $errstr, $errfile, $errline)
    {
        //E_STRICT͖
        if(E_STRICT === $errno) {
        	return;
        }
        
        $result = false;
        
        // Oo
        if ($this->logger instanceof AutoSOAP_Logger) {
            $result = $this->logger->output($this->service, $errno, $errstr, $errfile, $errline);
        }
        
        //TRUEꍇASOAPG[bZ[W͏o͂ȂB
        if(true === $result) {
        	return ;
        }
        
        // SOAPG[bZ[Wo
        $errortype = array (
                E_ERROR           => "Error",
                E_WARNING         => "Warning",
                E_PARSE           => "Parsing Error",
                E_NOTICE          => "Notice",
                E_CORE_ERROR      => "Core Error",
                E_CORE_WARNING    => "Core Warning",
                E_COMPILE_ERROR   => "Compile Error",
                E_COMPILE_WARNING => "Compile Warning",
                E_USER_ERROR      => "User Error",
                E_USER_WARNING    => "User Warning",
                E_USER_NOTICE     => "User Notice",
                E_STRICT          => "Runtime Notice"
                );
        $mssg = $errortype[$errno].': '.$errstr;
				$debug = debug_backtrace();
				$faultactor = "\n";
				foreach($debug as $key=>$val) {
					$faultactor .= '#'.$key.' '.$val['class'].$val['type'].$val['function'].'()'.' called at ['.$val['file'].':'.$val['line']."]\n";
				}
        if (is_null($this->server)) {
            $this->server = new SoapServer(null, array('soap_version' => SOAP_1_1, 'uri' => "http://localhost/"));
            $this->server->fault("Server", $errstr, null, $faultactor);
            $this->server = null;
        } else {
            throw new SoapFault("Server", $errstr, null, $faultactor);
        }
    } 
} 

?>