<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: ServiceFactory.class.php 73 2006-04-05 13:26:00Z sakamoto $
 */

/**
 * ȈՓIȃT[rXt@Ng[
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_ServiceFactory {
    private $services_dir;
    private $wsdls_dir;
    private $xsds_dir;
    private $classmaps_dir;

    public function __construct($services_dir, $wsdls_dir, $xsds_dir, $classmaps_dir)
    {
        $this->services_dir = $services_dir . '/';
        $this->wsdls_dir = $wsdls_dir . '/';
        $this->xsds_dir = $xsds_dir . '/';
        $this->classmaps_dir = $classmaps_dir . '/';
    } 

    public function getService($service_path, $location)
    {
        $matches = array();
        if (preg_match("/[\/@\;\: ]/", $service_path)) {
            trigger_error("Parse Error!!", E_USER_ERROR);
            return null;
        }
        
        $class_name = preg_replace("/[\.]+/","_",$service_path);
        $class_path = $this->services_dir . str_replace("_", "/", $class_name) . '.service.php';
        $wsdl_path  = $this->wsdls_dir . $class_name . ".wsdl";
        $xsd_path   = $this->xsds_dir  . $class_name . ".xsd";
        $classmap_path = $this->classmaps_dir . $class_name . ".classmap.php";

        return new AutoSOAP_Service($class_name,
            $class_path,
            $wsdl_path,
            $xsd_path,
            $classmap_path,
            $location,
            $location
            );
    } 
} 

?>