<?php
/**
 * AutoSOAP - Expanded SOAP Server
 * 
 * PHP version 5
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 * @copyright 2006 Sakamoto Kouichi
 * @license http://www.apache.org/licenses/LICENSE-2.0 Apache Software License 2.0
 * 
 * $Id: class2wsdlVisitor.class.php 74 2006-04-05 14:29:06Z sakamoto $
 */

/**
 * NXWSDLf[^ւ̕ϊprW^[NX
 * 
 * @package jp.servlet.AutoSOAP
 * @author Sakamoto Kouichi <sakamoto@servlet.sakura.ne.jp> 
 */
class AutoSOAP_class2wsdlVisitor extends AutoSOAP_class2soapVisitor {
    // WSDL̊ep[c
    private $_portType;
    private $_binding;

    /**
     * 
     */
    public function init($target_uri, $wsdl_name, $location)
    {
        $this->_wsdl = AutoSOAP_XMLogic_WsdlFactory :: getInstance();

        /**
         * WSDL̑g̍쐬
         */ 
        // Root
        $root = $this->_wsdl->createRoot($target_uri); 
        // Types
        $types = $this->_wsdl->createTypes();
        $root->add($types); 
        // Types_Schema
        $types_schema = $this->_schema->createRoot($target_uri);
        $types->add($types_schema); 
        // portType
        $this->_portType = $this->_wsdl->createPortType($wsdl_name . '_portType');
        $root->add($this->_portType); 
        // Binding
        $this->_binding = $this->_wsdl->createBinding($wsdl_name . '_Binding', $wsdl_name . '_portType', $target_uri, AutoSOAP_XMLogic_WsdlFactory :: XMLNS_HTTP);
        $root->add($this->_binding); 
        // Service
        $service = $this->_wsdl->createService($wsdl_name . '_Service', $wsdl_name . '_Binding', $target_uri, $location);
        $root->add($service); 
        
        $class2xsd = new AutoSOAP_class2xsdVisitor();
        $class2xsd->init($types_schema, $this->_wsdl); 
        
        parent :: init($target_uri, $root, $class2xsd);
    } 

    /**
     * \bhǉ
     */
    public function appendMethod(AutoSOAP_ReflectionAccept $method, $annotation)
    {
        $method_name = $method->getName();

        /**
         * NGXg\bhǉ
         */
        $request_name = $method_name . "Request";
        $request = $this->_wsdl->createMessage($request_name); 
        // p[^ǉ
        $parameters = $method->getParameters()->accept($this);
        if (0 < count($parameters)) {
            foreach($parameters as $param) {
                $request->add($param);
            } 
        } 
        $this->_root->add($request, 1);

        /**
         * X|X\bhǉ
         */
        $response_name = $method_name . "Response";
        $datatype = null;
        $restriction = (isset($annotation['restrictions']['#return'])) ? $annotation['restrictions']['#return'] : null ;

        if (is_array($annotation['return'])) {
            $return_types = $annotation['return'][0]; 
            // ^w肪Pp^[ȊOׂ͂NULLɂ
            if (1 == count($return_types)) {
                $datatype = $return_types[0];
            } 
        } 
        $response = $this->_wsdl->createMessage($response_name);
        $response->add($this->getMessagePort('return', $datatype, $restriction));
        $this->_root->add($response, 1);

        /**
         * portType֒ǉ
         */
        $this->_portType->add($this->_wsdl->createOperationOfPortType($method_name,
                $request_name,
                $response_name,
                $this->_Target_uri)
            );

        /**
         * binding֒ǉ
         */
        $this->_binding->add($this->_wsdl->createOperationOfBinding($method_name,
                (0 < strlen($request_name)),
                (0 < strlen($response_name)),
                $this->_Target_uri)
            );
    } 

    /**
     * ǉ
     */
    public function appendParameter(AutoSOAP_ReflectionAccept $param, $datatype, $restriction, $options)
    {
        return $this->getMessagePort($param->getName(), $datatype, $restriction, $options);
    } 

    /**
     * bZ[W|[g̃GgԂB
     */
    private function getMessagePort($name, $datatype, $restriction, $options = null)
    {
        $info = $this->_class2xsd->getElementInfo($name, $datatype, $restriction);
        return $this->_wsdl->createPart($info['name'], $info['datatype'], $info['namespace'], $options);
    } 
} 

?>