/*
 * Copyright (c) 2009, Yama
 * All rights reserved.
 * 
 * 
 * \[XR[h`oCi`AύX邩Ȃ킸Aȉ̏𖞂ꍇɌAĔЕzюgp܂B 
 * 
 * \[XR[hĔЕzꍇAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB 
 * oCi`ōĔЕzꍇAЕzɕt̃hLg̎ɁAL̒쌠\A{ꗗAщLƐӏ܂߂邱ƁB 
 * ʂɂʂ̋ȂɁA{\tgEFAhi̐`܂͔̔iɁA<gD>̖O܂̓Rgr[^[̖OgpĂ͂ȂȂB 
 * {\tgEFÁA쌠҂уRgr[^[ɂāû܂܁v񋟂ĂAَ킸AƓIȎgp\Aѓ̖ړIɑ΂KɊւÖق̕ۏ؂܂߁A܂Ɍ肳ȂAȂۏ؂܂B쌠҂Rgr[^[AR̂킸A Q̌킸AӔC̍_ł邩iӔCł邩iߎ̑́js@sׂł邩킸Aɂ̂悤ȑQ\m炳ĂƂĂA{\tgEFA̎gpɂĔi֕i܂͑pT[rX̒BAgp̑rAf[^̑rAv̑rAƖ̒f܂߁A܂Ɍ肳ȂjڑQAԐڑQAIȑQAʑQAIQA܂͌ʑQɂāAؐӔC𕉂Ȃ̂Ƃ܂B 
 */

/*!
 @file HardwareInit.c
 @brief n[hEFȀ܂
 @author RTi
 @date 7-jan-09, new
*/

/* SPLINT pDefine */
#ifdef S_SPLINT_S /* splint ғp */

/* RpCɐݒ肳define */
#ifndef __AVR_ATtiny2313__
#define __AVR_ATtiny2313__
#endif

#endif /* SPLINT pDefine */

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include "HardwareInit.h"
#include "Usart.h"

/* O[oϐ */
static uint8_t Reset = 0;/*!< Zbg擾yѕێ */

/* [J֐ */
int hardwareInit(void);
uint8_t GetResetSetRegi(uint8_t wdtcsr);

/* @MCU|[gZbeBO@
AutoKey 2009.1.9
No.	Name	Pin-No.	Net name	IO	Description
1	PA0	5	nouse	IN	v_E
2	PA1	4	nouse	IN	v_E
3	PA2	1	RES		IN	ZbgsiROMݗpj
4	PB0	12	nouse	IN	v_E
5	PB1	13	nouse	IN	v_E
6	PB2	14	/OE		OUT	74HC595o͋ vAbv
7	PB3	15	/SCLR	OUT	74HC595VtgWX^NA
8	PB4	16	RCK		OUT	74HC595b`M
9	PB5	17	MOSI	IN	ROMݗp
10	PB6	18	MISO	OUT	ROMݗp 74HC595VAf[^o
11	PB7	19	SCK		OUT	ROMݗp 74HC595VANbN
12	PD0	2	U_RXD	IN	UART RXDizXgMj
13	PD1	3	U_TXD	OUT	UART TXDizXgMj
14	PD2	6	nouse	IN	v_E
15	PD3	7	nouse	IN	v_E
16	PD4	8	nouse	IN	v_E
17	PD5	9	nouse	IN	v_E
18	PD6	11	nouse	IN	v_E

*/

/*!
 @brief n[hEFA֐
 @return HARDINIT_NO_ERROR
*/
int hardwareInit(void)
{
	int ret = HARDINIT_NO_ERROR;

	/* Prepearing Port Output */
	PORTB = PORT_BIT3_H | PORT_BIT2_H; /* /SCLR:H /OE:H */
	PORTD = PORT_BIT1_H; /* TXD:H */

	/* Port setting */
	DDRA = DDR_ALLINPUT; /* PORTA͑Sē */
	DDRB = DDR_BIT7_OUT | DDR_BIT6_OUT | DDR_BIT4_OUT | DDR_BIT3_OUT | DDR_BIT2_OUT; /* OUT 7,6,4,3,2 */
	DDRD = DDR_BIT1_OUT; /* o͂1̂ */

	/* UART */
	UBRRH = BPS_38400H;
	UBRRL = BPS_38400L; /* 38400bps */
	//UCSRA = UCSRA_RESET;
	UCSRB = UCSRB_SET;
	//UCSRC = UCSRC_RESET;

	/* o */
	sei();/*! 荞݉ - Set enable interrupt */

	return ret;
}

/*!
 @brief Zbg擾֐
 @return rbg}XN
	PON_RESET 0x01 dONZbg
	EXT_RESET 0x02 OZbg
	BOR_RESET 0x04 dቺmZbg
	WDT_RESET 0x08 EHb`hbO^C}Zbg
*/
uint8_t GetResetSetRegi(uint8_t wdtcsr)
{	
	Reset = MCUSR & 0x0f; /* WDRF:WDT BORF:BOR EXTRF:External PORF:PowerOnReset */
	MCUSR = 0; /* dON㒼ɃNA */
	wdt_reset(); /* EHb`hbOݒOɃ^C}NA */
	WDTCSR |= WDCE_set; /* WDEyWDP3-0ύXO1ɃZbgBI0ɃNA */
	WDTCSR = wdtcsr; /* 1bEHb` WDT荞݂͖gp@WDTX^[g */

	return Reset;
}

