/****************************
        KOF2000 Patch
****************************/

#define PATCH_END (-1)

#include "driver.h"

long kof2000_p1_address[] =
{
	0x027796, 0x027797, 0x027A4A, 0x027A4B, 0x0A226E, 0x0A226F,
	0x0D1D8A, 0x0D1D93, 0x0D1E10, 0x0D1E12, 0x0D1E13, 0x0D1E14,
	0x0D1E15, 0x0D1E16, 0x0D1E17, 0x0D1E1E, 0x0D1E27, 0x0D1EA8,
	0x0D1EAA, 0x0D1EAB, 0x0D1F38, 0x0D1F3C, 0x0D1F3D, 0x0D1F3E,
	0x0D1F3F,

	PATCH_END
};

data8_t kof2000_p1_data[] =
{
	0x71, 0x4E, 0x71, 0x4E, 0x75, 0x4E,
	0x22, 0x22, 0x23, 0x02, 0x00, 0x1C,
	0x22, 0x02, 0x00, 0x23, 0x23, 0x1C,
	0x02, 0x00, 0x23, 0x1C, 0x22, 0x02,
	0x00,
};

void neogeo_kof2000n_patch(void)
{
	data8_t *mem8 = memory_region(REGION_CPU1);
	int i = 0;

	while (kof2000_p1_address[i] != PATCH_END)
	{
		mem8[kof2000_p1_address[i]] = kof2000_p1_data[i];
		i++;
	}
}
