/*************************************************************************

	SNK NeoGeo hardware

*************************************************************************/

/*----------- defined in drivers/neogeo.c -----------*/

#ifdef MAME32JP
extern UINT32 neogeo_frame_counter;
extern UINT32 neogeo_frame_counter_speed;
#else
extern unsigned int neogeo_frame_counter;
extern unsigned int neogeo_frame_counter_speed;
#endif
extern int neogeo_has_trackball;

void neogeo_set_cpu1_second_bank(UINT32 bankaddress);
void neogeo_init_cpu2_setbank(void);
void neogeo_register_main_savestate(void);

/*----------- defined in machine/neogeo.c -----------*/

extern data16_t *neogeo_ram16;
extern data16_t *neogeo_sram16;

extern int mcd_action;
extern int mcd_number;
extern int memcard_status;
extern int memcard_number;
extern int memcard_manager;
extern UINT8 *neogeo_memcard;

MACHINE_INIT( neogeo );
DRIVER_INIT( neogeo );

WRITE16_HANDLER( neogeo_sram16_lock_w );
WRITE16_HANDLER( neogeo_sram16_unlock_w );
READ16_HANDLER( neogeo_sram16_r );
WRITE16_HANDLER( neogeo_sram16_w );

NVRAM_HANDLER( neogeo );

READ16_HANDLER( neogeo_memcard16_r );
WRITE16_HANDLER( neogeo_memcard16_w );
int neogeo_memcard_load(int);
void neogeo_memcard_save(void);
void neogeo_memcard_eject(void);
int neogeo_memcard_create(int);

/*----------- defined in machine/neocrypt.c -----------*/
extern int neogeo_fix_bank_type;

void kof99_neogeo_gfx_decrypt(int extra_xor);
void kof2000_neogeo_gfx_decrypt(int extra_xor);
void cmc50_neogeo_gfx_decrypt(int extra_xor);
void cmc42_neogeo_gfx_decrypt(int extra_xor);
void kof99_decrypt_68k(void);
void garou_decrypt_68k(void);
void garouo_decrypt_68k(void);
void mslug3_decrypt_68k(void);
void kof2000_decrypt_68k(void);
void kof98_decrypt_68k(void);
void kof2002_decrypt_68k(void);
void matrim_decrypt_68k(void);
void mslug5_decrypt_68k(void);
void svcchaos_px_decrypt(void);
void svcpcb_gfx_decrypt(void);
void svcpcb_s1data_decrypt(void);
void samsho5_decrypt_68k(void);
void kf2k3pcb_gfx_decrypt(void);
void kf2k3pcb_decrypt_68k(void);
void kf2k3pcb_decrypt_s1data(void);
void kof2003_decrypt_68k(void);
void kof2003biosdecode(void);
void samsh5p_decrypt_68k(void);

void neo_pcm2_snk_1999(int value);
void neo_pcm2_swap(int value);
void neogeo_sfix_decrypt(void);

#ifdef EXTRA_GAMES
void cthd2k3a_px_decrypt(void);
#endif /* EXTRA_GAMES */


/*----------- defined in machine/neoprot.c -----------*/
extern int neogeo_rng;

void install_sram_protection(void);
void fatfury2_install_protection(void);
void mslugx_install_protection(void);
void kof99_install_protection(void);
void garou_install_protection(void);
void garouo_install_protection(void);
void mslug3_install_protection(void);
void kof2000_install_protection(void);
void install_kof98_protection(void);
void install_pvc_protection(void);


/*----------- defined in machine/neoboot.c -----------*/
void kog_px_decrypt(void);
void neogeo_bootleg_cx_decrypt(void);
void install_kof10th_protection(void);
void decrypt_kof10th(void);
void decrypt_kf10thep(void);
void decrypt_kf2k5uni(void);
void neogeo_bootleg_sx_decrypt(int value);
void kf2k2mp_decrypt(void);
void kof2km2_px_decrypt(void);
void decrypt_cthd2003(void);
void patch_cthd2003(void);
void decrypt_ct2k3sp(void);
void decrypt_kof2k4se_68k(void);
void lans2004_decrypt_68k(void);
void lans2004_vx_decrypt(void);
void install_ms5plus_protection(void);
void svcboot_px_decrypt( void );
void svcboot_cx_decrypt( void );
void svcplus_px_decrypt( void );
void svcplus_px_hack( void );
void svcplusa_px_decrypt( void );
void svcsplus_px_decrypt( void );
void svcsplus_px_hack( void );
void kof2003b_px_decrypt( void );
void kof2003b_install_protection(void);
void kof2k3pl_px_decrypt( void );
void kof2k3up_px_decrypt( void );
void kof2k3up_install_protection(void);
void kf2k3pl_install_protection(void);
void samsh5bl_px_decrypt( void );

#ifdef EXTRA_GAMES
void decrypt_matrimbl(void);
void kof96ep_px_decrypt(void);
void kf2k1pa_sx_decrypt(void);
void kof2002b_gfx_decrypt(UINT8 *src, int size);
void kf2k2mp_px_decrypt(void);
void transparency_s1(void);
void install_fr2ch_fix(void);
#endif /* EXTRA_GAMES */


/*----------- defined in vidhrdw/neogeo.c -----------*/

VIDEO_START( neogeo_mvs );

WRITE16_HANDLER( neogeo_setpalbank0_16_w );
WRITE16_HANDLER( neogeo_setpalbank1_16_w );
READ16_HANDLER( neogeo_paletteram16_r );
WRITE16_HANDLER( neogeo_paletteram16_w );

WRITE16_HANDLER( neogeo_vidram16_offset_w );
READ16_HANDLER( neogeo_vidram16_data_r );
WRITE16_HANDLER( neogeo_vidram16_data_w );
WRITE16_HANDLER( neogeo_vidram16_modulo_w );
READ16_HANDLER( neogeo_vidram16_modulo_r );
WRITE16_HANDLER( neo_board_fix_16_w );
WRITE16_HANDLER( neo_game_fix_16_w );

WRITE16_HANDLER (neogeo_select_bios_vectors);
WRITE16_HANDLER (neogeo_select_game_vectors);


VIDEO_UPDATE( neogeo );
VIDEO_UPDATE( neogeo_raster );
void neogeo_vh_raster_partial_refresh(struct mame_bitmap *bitmap,int current_line);

#ifdef NEOGEO_BIOS_SELECT
enum {
	NEOGEO_BIOS_ES1,	/* Europe, 1 Slot (the old hacks were designed for this one) */
	NEOGEO_BIOS_ES4,	/* Europe, 4 Slot */
	NEOGEO_BIOS_US2,  	/* US, 2 Slot */
	NEOGEO_BIOS_US6,  	/* US, 6 Slot */
	NEOGEO_BIOS_ASIA,  	/* Asia */
	NEOGEO_BIOS_J6VS,	/* Japan MVS (Ver. 3) */
	NEOGEO_BIOS_JOLD,  	/* Japan MVS (Ver. 2) */
	NEOGEO_BIOS_S1,		/* Japan MVS (Ver. 1) */
	NEOGEO_BIOS_U10,	/* Universe Bios v1.0 (hack) */
	NEOGEO_BIOS_U11,	/* Universe Bios v1.1 (hack) */
	NEOGEO_BIOS_U12,	/* Universe Bios v1.2 (hack) */
	NEOGEO_BIOS_U13,	/* Universe Bios v1.3 (hack) */
	NEOGEO_BIOS_U20,	/* Universe Bios v2.0 (hack) */
	NEOGEO_BIOS_U21,	/* Universe Bios v2.1 (hack) */
	NEOGEO_BIOS_U22,	/* Universe Bios v2.2 (hack) */
	NEOGEO_BIOS_DEBUG,	/* Debug (Development) Bios (doesn't work in mame? console?) */
	NEOGEO_BIOS_AES,	/* AES Console (Asia?) */
	NEOGEO_BIOS_AESJ,	/* AES Console (Japan?) */
	NEOGEO_BIOS_MAX
};

/* use NEOGEO_BIOS_ES1 as default BIOS */
#define NEOGEO_BIOS_DEFAULT	NEOGEO_BIOS_ES1
#define NEOGEO_BIOS_NAME	"sp-s2.sp1"
#define NEOGEO_BIOS_CRC 	0x9036d879

struct neogeo_bios_info
{
	const char *name;	/* name of the rom file to load */
	UINT32 crc;		/* standard CRC-32 checksum */
	const char *desc;	/* description */
};

extern struct neogeo_bios_info neogeo_bios[NEOGEO_BIOS_MAX];
#endif /* NEOGEO_BIOS_SELECT */
