/********************************************************************

 Vampire 1/2 and other Hyperstone-based games

 ***VERY WIP***

 To be used only for testing Hyperstone CPU core, probably the only correct
 thing in the driver so far is the ROM loading and graphics decoding.

 These will be split into separate drivers later.

 CHANGELOG:

 MooglyGuy - 10/25/03
    - Changed prelim driver to only load the ROM in the upper part of mem,
      loading the ROM at 0x00000000 and setting the bank to point there was
      completely wrong since apparently there's RAM at 0x00000000.

*********************************************************************/
#include "driver.h"

static MEMORY_READ32_START( readmem )
	{ 0x00000000, 0x0007ffff, MRA32_RAM },
	{ 0xfff80000, 0xffffffff, MRA32_BANK1 },
MEMORY_END

static MEMORY_WRITE32_START( writemem )
	{ 0x00000000, 0x0007ffff, MWA32_RAM },
	{ 0xfff80000, 0xffffffff, MWA32_ROM },
MEMORY_END

static MEMORY_READ32_START( xfiles_readmem )
	{ 0x00000000, 0x0007ffff, MRA32_RAM },
	{ 0xffc00000, 0xffffffff, MRA32_BANK1 },
MEMORY_END

static MEMORY_WRITE32_START( xfiles_writemem )
	{ 0x00000000, 0x0007ffff, MWA32_RAM },
	{ 0xffc00000, 0xffffffff, MWA32_ROM },
MEMORY_END

INPUT_PORTS_START( vamphalf )
INPUT_PORTS_END


VIDEO_START( vamphalf )
{
	return 0;
}

VIDEO_UPDATE( vamphalf )
{

}

static struct GfxLayout vamphalf_layout =
{
	16,16,
	RGN_FRAC(1,1),
	8,
	{ 0,1,2,3,4,5,6,7 },
	{ 0,8,16,24, 32,40,48,56, 64,72,80,88 ,96,104,112,120 },
	{ 0*128, 1*128, 2*128, 3*128, 4*128, 5*128, 6*128, 7*128, 8*128,9*128,10*128,11*128,12*128,13*128,14*128,15*128 },
	16*128,
};

static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ REGION_GFX1, 0, &vamphalf_layout,   0x0, 1  }, /* bg tiles */
	{ -1 } /* end of array */
};

static MACHINE_DRIVER_START( vamphalf )
	MDRV_CPU_ADD(E132XS,10000000)		 /* ?? */
	MDRV_CPU_MEMORY(readmem,writemem)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(256, 256)
	MDRV_VISIBLE_AREA(0*8, 32*8-1, 0*8, 32*8-1)

	MDRV_GFXDECODE(gfxdecodeinfo)

	MDRV_PALETTE_LENGTH(256)

	MDRV_VIDEO_START(vamphalf)
	MDRV_VIDEO_UPDATE(vamphalf)
MACHINE_DRIVER_END


static MACHINE_DRIVER_START( xfiles )
	MDRV_CPU_ADD(E132XS,10000000)		 /* ?? */
	MDRV_CPU_MEMORY(xfiles_readmem,xfiles_writemem)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(256, 256)
	MDRV_VISIBLE_AREA(0*8, 32*8-1, 0*8, 32*8-1)

	MDRV_GFXDECODE(gfxdecodeinfo)

	MDRV_PALETTE_LENGTH(256)

	MDRV_VIDEO_START(vamphalf)
	MDRV_VIDEO_UPDATE(vamphalf)
MACHINE_DRIVER_END

/* f2 systems hardware */

ROM_START( vamphalf )
	ROM_REGION( 0x80000, REGION_CPU1, 0 )

	ROM_REGION32_BE( 0x80000, REGION_USER1, 0 ) /* Hyperstone CPU Code */
	ROM_LOAD("prom1", 0x00000000,    0x00080000,   0xf05e8e96)

	ROM_REGION( 0x800000, REGION_GFX1, 0 ) /* 16x16x8 Sprites? */
	ROM_LOAD32_WORD( "roml00",       0x000000, 0x200000, 0xcc075484 )
	ROM_LOAD32_WORD( "roml01",       0x400000, 0x200000, 0x626c9925 )
	ROM_LOAD32_WORD( "romu00",       0x000002, 0x200000, 0x711c8e20 )
	ROM_LOAD32_WORD( "romu01",       0x400002, 0x200000, 0xd5be3363 )

	ROM_REGION( 0x040000, REGION_SOUND1, 0 ) /* Oki Samples */
	ROM_LOAD( "vrom1",        0x000000, 0x040000, 0xee9e371e )
ROM_END

/* eolith hardware */

/*



Name         Size     CRC32       Chip Type
-------------------------------------------
hc0_u39.bin  4194304  0xeefb6add  C32000 dumped as SGS 27C322
hc1_u34.bin  4194304  0x482f3e52  C32000 dumped as SGS 27C322
hc2_u40.bin  4194304  0x914a1544  C32000 dumped as SGS 27C322
hc3_u35.bin  4194304  0x80c59133  C32000 dumped as SGS 27C322
hc4_u41.bin  4194304  0x9a9e2203  C32000 dumped as SGS 27C322
hc5_u36.bin  4194304  0x74b1719d  C32000 dumped as SGS 27C322
hc_u108.bin   524288  0x2bae46cb  27C040
hc_u43.bin    524288  0x635b4478  27C040
hc_u97.bin    524288  0xebf9f77b  27C040
hc_u107.bin    32768  0xafd5263d  AMIC 275308 dumped as 27256
hc_u111.bin    32768  0x79012474  AMIC 275308 dumped as 27256
*/

ROM_START( hidnctch )
	ROM_REGION( 0x80000, REGION_CPU1, 0 )

	ROM_REGION32_BE( 0x80000, REGION_USER1, 0 ) /* Hyperstone CPU Code */
	ROM_LOAD("hc_u43.bin", 0x00000000,    0x080000,  0x635b4478 )

	ROM_REGION( 0x2000000, REGION_GFX1, 0 ) /* GFX (not tile based) */
	ROM_LOAD16_BYTE("hc0_u39.bin", 0x0000001,    0x0400000, 0xeefb6add)
	ROM_LOAD16_BYTE("hc1_u34.bin", 0x0000000,    0x0400000, 0x482f3e52)
	ROM_LOAD16_BYTE("hc2_u40.bin", 0x0800001,    0x0400000, 0x914a1544)
	ROM_LOAD16_BYTE("hc3_u35.bin", 0x0800000,    0x0400000, 0x80c59133)
	ROM_LOAD16_BYTE("hc4_u41.bin", 0x1000001,    0x0400000, 0x9a9e2203)
	ROM_LOAD16_BYTE("hc5_u36.bin", 0x1000000,    0x0400000, 0x74b1719d)

	ROM_REGION( 0x080000, REGION_GFX2, 0 ) /* ? */
	ROM_LOAD("hc_u108.bin", 0x000000,    0x080000, 0x2bae46cb)

	ROM_REGION( 0x080000, REGION_GFX3, 0 ) /* ? */
	ROM_LOAD("hc_u107.bin", 0x000000,    0x08000, 0xafd5263d ) // same in landbrk

	ROM_REGION( 0x080000, REGION_GFX4, 0 ) /* ? */
	ROM_LOAD("hc_u111.bin", 0x000000,    0x08000, 0x79012474)

	ROM_REGION( 0x080000, REGION_SOUND1, 0 ) /* ? */
	ROM_LOAD("hc_u97.bin", 0x000000,    0x080000, 0xebf9f77b )
ROM_END

/*

Documentation
-------------------------------------------
lb_pcb.jpg    614606  0xf041e24c

Name         Size     CRC32       Chip Type
-------------------------------------------
lb.107         32768  0xafd5263d  AMIC 275308 dumped as 27256
lb2-000.u39  4194304  0xb37faf7a  C32000 dumped as SGS 27C322
lb2-001.u34  4194304  0x07e620c9  C32000 dumped as SGS 27C322
lb2-002.u40  4194304  0x3bb4bca6  C32000 dumped as SGS 27C322
lb2-003.u35  4194304  0x28ce863a  C32000 dumped as SGS 27C322
lb2-004.u41  4194304  0xcbe84b06  C32000 dumped as SGS 27C322
lb2-005.u36  4194304  0x350c77a3  C32000 dumped as SGS 27C322
lb2-006.u42  4194304  0x22c57cd8  C32000 dumped as SGS 27C322
lb2-007.u37  4194304  0x31f957b3  C32000 dumped as SGS 27C322
lb_1.u43      524288  0xf8bbcf44  27C040
lb_2.108      524288  0xa99182d7  27C040
lb_3.u97      524288  0x5b34dff0  27C040

*/

ROM_START( landbrk )
	ROM_REGION( 0x80000, REGION_CPU1, 0 )

	ROM_REGION32_BE( 0x80000, REGION_USER1, 0 ) /* Hyperstone CPU Code */
	ROM_LOAD("lb_1.u43", 0x00000000,    0x080000,   0xf8bbcf44 )

	ROM_REGION( 0x2000000, REGION_GFX1, 0 ) /* GFX (not tile based) */
	ROM_LOAD16_BYTE("lb2-000.u39", 0x0000001,    0x0400000, 0xb37faf7a )
	ROM_LOAD16_BYTE("lb2-001.u34", 0x0000000,    0x0400000, 0x07e620c9 )
	ROM_LOAD16_BYTE("lb2-002.u40", 0x0800001,    0x0400000, 0x3bb4bca6 )
	ROM_LOAD16_BYTE("lb2-003.u35", 0x0800000,    0x0400000, 0x28ce863a )
	ROM_LOAD16_BYTE("lb2-004.u41", 0x1000001,    0x0400000, 0xcbe84b06)
	ROM_LOAD16_BYTE("lb2-005.u36", 0x1000000,    0x0400000, 0x350c77a3 )
	ROM_LOAD16_BYTE("lb2-006.u42", 0x1800001,    0x0400000, 0x22c57cd8)
	ROM_LOAD16_BYTE("lb2-007.u37", 0x1800000,    0x0400000, 0x31f957b3 )

	ROM_REGION( 0x080000, REGION_GFX2, 0 ) /* ? */
	ROM_LOAD("lb_2.108", 0x000000,    0x080000,  0xa99182d7 )

	ROM_REGION( 0x080000, REGION_GFX3, 0 ) /* ? */
	ROM_LOAD("lb.107", 0x000000,    0x08000,    0xafd5263d )

	ROM_REGION( 0x080000, REGION_GFX4, 0 ) /* ? */
	/* 111 isn't populated? */

	ROM_REGION( 0x080000, REGION_SOUND1, 0 ) /* ? */
	ROM_LOAD("lb_3.u97", 0x000000,    0x080000,  0x5b34dff0 )
ROM_END

/*

Racoon World by Eolith

U43, u97, u108   are 27c040 devices

u111, u107   are 27c256 devices

On the ROM sub board:
u1, u2, u5, u10, u11, u14  are all 27c160 devices
--------------------------------------------------------------------------
Stereo sound?
24MHz crystal near the sound section

there is a 4 position DIP switch.

Hyperstone E1-32N    45.00000 MHz  near this chip
QDSP     QS1001A
QDSP     QS1000
EOLITH  EV0514-001  custom??   14.31818MHz  xtl near this chip
12MHz crystal is near the U111

U107 and U97 are mostlikely sound roms but not sure

*/

ROM_START( racoon )
	ROM_REGION( 0x80000, REGION_CPU1, 0 )

	ROM_REGION32_BE( 0x80000, REGION_USER1, 0 ) /* Hyperstone CPU Code */
	ROM_LOAD("racoon-u.43", 0x00000000,    0x080000,  0x711ee026 )

	ROM_REGION( 0x2000000, REGION_GFX1, 0 ) /* GFX (not tile based) */
	ROM_LOAD16_BYTE("racoon.u1", 0x0000001,    0x0200000, 0x49775125 )
	ROM_LOAD16_BYTE("racoon.u10",0x0000000,    0x0200000, 0xf702390e )
	ROM_LOAD16_BYTE("racoon.u2", 0x0800001,    0x0200000, 0x1eb00529 )
	ROM_LOAD16_BYTE("racoon.u11",0x0800000,    0x0200000, 0x3f23f368 )
	ROM_LOAD16_BYTE("racoon.u5", 0x1000001,    0x0200000, 0x5fbac174 )
	ROM_LOAD16_BYTE("racoon.u14",0x1000000,    0x0200000, 0x870fe45e )

	ROM_REGION( 0x080000, REGION_GFX2, 0 ) /* ? */
	ROM_LOAD("racoon-u.108", 0x000000,    0x080000,  0xfc4f30ee )

	ROM_REGION( 0x080000, REGION_GFX3, 0 ) /* ? */
	ROM_LOAD("racoon-u.107", 0x000000,    0x08000,    0x89450a2f )

	ROM_REGION( 0x080000, REGION_GFX4, 0 ) /* ? */
	ROM_LOAD("racoon-u.111", 0x000000,    0x08000, 0x52f419ea)

	ROM_REGION( 0x080000, REGION_SOUND1, 0 ) /* ? */
	ROM_LOAD("racoon-u.97", 0x000000,    0x080000,  0xfef828b1)
ROM_END

/* ?? dfpix hardware */

/*

X-Files
dfPIX Entertainment Inc. 1999

Contrary to what you might think on first hearing the title, this game
is like Match It 2 etc. However, the quality of the graphics
is outstanding, perhaps the most high quality seen in this "type" of game.
At the end of the level, you are presented with a babe, where you can use
the joystick and buttons to scroll up and down and zoom in for erm...
a closer inspection of the 'merchandise' ;-))


PCB Layout
----------


VRenderOMinus Rev4
-------------------------------------------------------
|                                                     |
|   DA1545A             C-O-N-N-1                 C   |
|                                                 O   |
|  POT1    T2316162               SEC KS0164      N   |
|  POT2    T2316162                               N   |
|J                                    169NDK19:   3   |
|A     14.31818MHz                     CONN2          |
|M  KA4558                                            |
|M                                                    |
|A                                SEC KM6161002CJ-12  |
|          E1-32XT                                    |
|                                 SEC KM6161002CJ-12  |
|                                                     |
|       ST7705C                   SEC KM6161002CJ-12  |
| B1             XCS05                                |
| B2 B3          14.31818MHz      SEC KM6161002CJ-12  |
-------------------------------------------------------


Notes
-----
ST7705C          : EEPROM?
E1-32XT          : Hyperstone E1-32XT CPU
169NDK19         : Xtal, 16.9MHz
CONN1,CONN2,CONN3: Connectors for small daughterboard containing
                   3x DA28F320J5 (32M surface mounted SSOP56 Flash ROM)
XCS05            : XILINX XCS05 PLD
B1,B2,B3         : Push Buttons for TEST, SERVICE and RESET
SEC KS0164       : Manufactured by Samsung Electronics. Possibly sound
                   related or Sound CPU? (QFP100)
T2316162         : Main program RAM (SOJ44)
SEC KM6161002    : Graphics RAM (SOJ44)

*/

ROM_START( xfiles )
	ROM_REGION( 0x400000, REGION_CPU1, 0 )

	ROM_REGION32_BE( 0x400000, REGION_USER1, 0 ) /* Hyperstone CPU Code */
	ROM_LOAD16_WORD_SWAP("u9.bin", 0x00000000,    0x400000,   0xebdb75c0 )

	/* the following probably aren't in the right regions etc. */

	ROM_REGION( 0x400000, REGION_GFX1, 0 )
	ROM_LOAD16_WORD_SWAP("u8.bin", 0x00000000,    0x400000,   0x3b2c2bc1 )

	ROM_REGION( 0x400000, REGION_SOUND1, 0 )
	ROM_LOAD16_WORD_SWAP("u10.bin", 0x00000000,    0x400000,   0xf2ef1eb9 )
ROM_END

DRIVER_INIT( vamphalf )
{
	cpu_setbank(1, memory_region(REGION_USER1));
}

/*           rom       parent    machine   inp       init */
GAMEX( 19??, vamphalf, 0,        vamphalf, vamphalf, vamphalf, ROT0, "Danbi", "Vamp 1/2", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 19??, hidnctch, 0,        vamphalf, vamphalf, vamphalf, ROT0, "Eolith", "Hidden Catch", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 19??, landbrk,  0,        vamphalf, vamphalf, vamphalf, ROT0, "Eolith", "Land Breaker", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 19??, racoon,   0,        vamphalf, vamphalf, vamphalf, ROT0, "Eolith", "Racoon World", GAME_NO_SOUND | GAME_NOT_WORKING )
GAMEX( 19??, xfiles,   0,        xfiles,   vamphalf, vamphalf, ROT0, "dfPIX Entertainment Inc.", "X-Files", GAME_NO_SOUND | GAME_NOT_WORKING )
