/*
    Super Real Mahjong P6 (JPN Ver.)
    (c)1996 Seta

WIP driver by Sebastien Volpe, Tomasz Slanina and David Haywood

Emulation Notes:
The graphics are compressed, using the same 8bpp RLE scheme as CPS3 uses
for the background on Sean's stage of Street Fighter III.

DMA Operations are not fully understood


according prg ROM (offset $0fff80):

    S12 SYSTEM
    SUPER REAL MAJAN P6
    SETA CO.,LTD
    19960410
    V1.00

TODO:
 - fix sound emulation
 - fix DMA operations
 - fix video emulation

Are there other games on this 'System S12' hardware ???

---------------- dump infos ----------------

[Jun/15/2000]

Super Real Mahjong P6 (JPN Ver.)
(c)1996 Seta

SX011
E47-REV01B

CPU:    68000-16
Sound:  NiLe
OSC:    16.0000MHz
        42.9545MHz
        56.0000MHz

Chips:  ST-0026 NiLe (video, sound)
        ST-0017


SX011-01.22  chr, samples (?)
SX011-02.21
SX011-03.20
SX011-04.19
SX011-05.18
SX011-06.17
SX011-07.16
SX011-08.15

SX011-09.10  68000 data

SX011-10.4   68000 prg.
SX011-11.5


Dumped 06/15/2000

*/


#include "driver.h"

static UINT16* tileram;
static UINT8* dirty_tileram;
static UINT16* dmaram;
static UINT16* rom_base;

static UINT16 *sprram, *sprram_old;

static int brightness;

#define VERBOSE 0
#define LOG(x) do { if (VERBOSE) logerror x; } while (0)

static const struct GfxLayout tiles8x8_layout =
{
	8,8,
	(0x100000*16)/0x40,
	8,
	{ 0,1,2,3,4,5,6,7 },
	{ 0*8,1*8,2*8,3*8,4*8,5*8,6*8,7*8 },
	{ 0*64,1*64,2*64,3*64,4*64,5*64,6*64,7*64 },
	8*64
};

void update_palette(void)
{
	INT8 r, g ,b;
	int brg = brightness - 0x60;
	int i;

	for(i = 0; i < 0x800; i++)
	{
		r = paletteram16[i] >>  0 & 0x1F;
		g = paletteram16[i] >>  5 & 0x1F;
		b = paletteram16[i] >> 10 & 0x1F;

		if(brg < 0) {
			r += (r * brg) >> 5;
			if(r < 0) r = 0;
			g += (g * brg) >> 5;
			if(g < 0) g = 0;
			b += (b * brg) >> 5;
			if(b < 0) b = 0;
		}
		else if(brg > 0) {
			r += ((0x1F - r) * brg) >> 5;
			if(r > 0x1F) r = 0x1F;
			g += ((0x1F - g) * brg) >> 5;
			if(g > 0x1F) g = 0x1F;
			b += ((0x1F - b) * brg) >> 5;
			if(b > 0x1F) b = 0x1F;
		}
		palette_set_color(i, r << 3, g << 3, b << 3);
	}
}

static VIDEO_START(srmp6)
{
	struct GfxElement *gfx;

	tileram = auto_malloc(0x100000*16);
	dirty_tileram = auto_malloc((0x100000*16)/0x40); // every 8x8x8 tile is 0x40 bytes
	if( !tileram || !dirty_tileram ) return 1;

	memset(tileram,0x00,(0x100000*16));
	memset(dirty_tileram,1,(0x100000*16)/0x40);

	dmaram = auto_malloc(0x100);

	sprram_old = auto_malloc(0x80000);
	if( !dmaram || !sprram_old ) return 1;
	memset(sprram_old, 0, 0x80000);

	brightness = 0x60;

	/* create the char set (gfx will then be updated dynamically from RAM) */
	gfx = decodegfx( (UINT8 *)tileram,&tiles8x8_layout );
	if( !gfx ) return 1;
	Machine->gfx[0] = gfx;
	Machine->gfx[0]->colortable   = Machine->remapped_colortable;
	Machine->gfx[0]->total_colors = Machine->drv->total_colors / 256;
	Machine->gfx[0]->color_granularity=256;
	return 0;
}

/* Debug code */
#ifdef UNUSED_FUNCTION
static void srmp6_decode_charram(void)
{
	if(input_code_pressed_once(KEYCODE_Z))
	{
		int i;
		for (i=0;i<(0x100000*16)/0x40;i++)
		{
			decodechar(Machine->gfx[0], i, (UINT8*)tileram, &tiles8x8_layout);
			dirty_tileram[i] = 0;
		}
	}
}
#endif

#if 0
static int xixi=0;
#endif

static VIDEO_UPDATE(srmp6)
{
	int trans = TRANSPARENCY_PEN;
	int x,y,tileno,height,width,xw,yw,sprite,xb,yb;
	UINT16 *sprite_list=sprram_old;
	UINT16 mainlist_offset = 0;

	union
	{
		INT16  a;
		UINT16 b;
	} temp;

	fillbitmap(bitmap,0,cliprect);

#if 0
	/* debug */
	srmp6_decode_charram();



	/* debug */
	if(input_code_pressed_once(KEYCODE_Q))
	{
		++xixi;
		printf("%x\n",xixi);
	}

	if(input_code_pressed_once(KEYCODE_W))
	{
		--xixi;
		printf("%x\n",xixi);
	}
#endif

	/* Main spritelist is 0x0000 - 0x1fff in spriteram, sublists follow */
	while (mainlist_offset<0x2000/2)
	{

		UINT16 *sprite_sublist=&sprram_old[sprite_list[mainlist_offset+1]<<3];
		UINT16 sublist_length=sprite_list[mainlist_offset+0]&0x7fff; //+1 ?
		INT16 global_x,global_y, flip_x, flip_y;
		UINT16 global_pal;

		/* end of list marker */
		if (sprite_list[mainlist_offset+0] == 0x8000)
			break;


		if(sprite_list[mainlist_offset+0]!=0)
		{
			temp.b=sprite_list[mainlist_offset+2];
			global_x=temp.a;
			temp.b=sprite_list[mainlist_offset+3];
			global_y=temp.a;

			global_pal = sprite_list[mainlist_offset+4] & 0x7;

			if((sprite_list[mainlist_offset+5] & 0x700) == 0x700)
			{
				trans = TRANSPARENCY_ALPHA;
				alpha_set_level((sprite_list[mainlist_offset+5] & 0x1F) << 3);
			}
			else
			{
				trans = TRANSPARENCY_PEN;
				alpha_set_level(255);
			}
	//  printf("%x %x \n",sprite_list[mainlist_offset+1],sublist_length);

			while(sublist_length)
			{
				sprite=sprite_sublist[0]&0x7fff;
				flip_x=sprite_sublist[1]>>8&1;
				flip_y=sprite_sublist[1]>>9&1;
				temp.b=sprite_sublist[2];
				x=temp.a;
				temp.b=sprite_sublist[3];
				y=temp.a;
				//x+=global_x;
				//y+=global_y;

				width=((sprite_sublist[1])&0x3);
				height=((sprite_sublist[1]>>2)&0x3);

				height = 1 << height;
				width = 1 << width;

				y-=height*8;
				tileno = sprite;
				//tileno += (sprite_list[4]&0xf)*0x4000; // this makes things worse in places (title screen for example)

				for(xw=0;xw<width;xw++)
				{
					for(yw=0;yw<height;yw++)
					{

						if(!flip_x)
							xb=x+xw*8+global_x;
						else
							xb=x+(width-xw-1)*8+global_x;

						if(!flip_y)
							yb=y+yw*8+global_y;
						else
							yb=y+(height-yw-1)*8+global_y;

						if (dirty_tileram[tileno])
						{
							decodechar(Machine->gfx[0], tileno, (UINT8*)tileram, &tiles8x8_layout);
							dirty_tileram[tileno] = 0;
						}

						drawgfx(bitmap,Machine->gfx[0],tileno,global_pal,flip_x,flip_y,xb,yb,cliprect,trans,0);
						tileno++;
		 			}
				}

				sprite_sublist+=8;
				--sublist_length;
			}
		}
		mainlist_offset+=8;
	}

	memcpy(sprram_old, sprram, 0x80000);
}

/***************************************************************************
    Main CPU memory handlers
***************************************************************************/

static UINT16 srmp6_input_select = 0;

static WRITE16_HANDLER( srmp6_input_select_w )
{
	srmp6_input_select = data & 0x0f;
}

static READ16_HANDLER( srmp6_inputs_r )
{
	if (offset == 0)			// DSW
		return readinputport(4);

	switch(srmp6_input_select)	// inputs
	{
		case 1<<0: return readinputport(0);
		case 1<<1: return readinputport(1);
		case 1<<2: return readinputport(2);
		case 1<<3: return readinputport(3);
	}

	return 0;
}


static UINT16 *video_regs;

static WRITE16_HANDLER( video_regs_w )
{
	switch(offset)
	{

		case 0x5e/2: // bank switch, used by ROM check
			LOG(("%x\n",data));

			memory_set_bankptr(1,(UINT16 *)(memory_region(REGION_USER2) + (data & 0x0f)*0x200000));
			break;

		// set by IT4
		case 0x5c/2: // either 0x40 explicitely in many places, or according $2083b0 (IT4)
			//Fade in/out (0x40(dark)-0x60(normal)-0x7e?(bright) reset by 0x00?
			data = (!data)?0x60:(data == 0x5e)?0x60:data;
			if(brightness != data) {
				brightness = data;
				update_palette();
			}
			break;

		/* unknown registers - there are others */

		// set by IT4 (jsr $b3c), according flip screen dsw
		case 0x48/2: //     0 /  0xb0 if flipscreen
		case 0x52/2: //     0 / 0x2ef if flipscreen
		case 0x54/2: // 0x152 / 0x15e if flipscreen

		// set by IT4 ($82e-$846)
		case 0x56/2: // written 8,9,8,9 successively

		default:
			logerror("video_regs_w (PC=%06X): %04x = %04x & %04x\n", activecpu_get_previouspc(), offset*2, data, mem_mask);
			break;
	}
	COMBINE_DATA(&video_regs[offset]);
}

static READ16_HANDLER( video_regs_r )
{
	logerror("video_regs_r (PC=%06X): %04x\n", activecpu_get_previouspc(), offset*2);
	return video_regs[offset];
}


/* DMA RLE stuff - the same as CPS3 */
static unsigned short lastb;
static unsigned short lastb2;
static int destl;

static UINT32 process(UINT8 b,UINT32 dst_offset)
{

 	int l=0;

 	UINT8 *tram=(UINT8*)tileram;

 	if(lastb==lastb2)	//rle
 	{
		int i;
 		int rle=(b+1)&0xff;

 		for(i=0;i<rle;++i)
 		{
			tram[dst_offset+destl] = lastb;
			dirty_tileram[(dst_offset+destl)/0x40] = 1;

			dst_offset++;
 			++l;
 		}
 		lastb2=0xffff;

 		return l;
 	}
 	else
 	{
 		lastb2=lastb;
 		lastb=b;
		tram[dst_offset+destl] = b;
		dirty_tileram[(dst_offset+destl)/0x40] = 1;

 		return 1;
 	}
 }


static WRITE16_HANDLER(srmp6_dma_w)
{
	COMBINE_DATA(&dmaram[offset]);
	if(offset==13 && dmaram[offset]==0x40)
	{
		const UINT8 *rom = memory_region(REGION_USER2);
		UINT32 srctab=2*((((UINT32)dmaram[5])<<16)|dmaram[4]);
		UINT32 srcdata=2*((((UINT32)dmaram[11])<<16)|dmaram[10]);
		UINT32 len=4*(((((UINT32)dmaram[7]&3)<<16)|dmaram[6])+1); //??? WRONG!
		int tempidx=0;

		/* show params */
		LOG(("DMA! %04x %04x %04x %04x %04x %04x %04x %04x %04x %04x %04x %04x %04x %04x\n",
				dmaram[0x00/2],
				dmaram[0x02/2],
				dmaram[0x04/2],
				dmaram[0x06/2],
				dmaram[0x08/2],
				dmaram[0x0a/2],
				dmaram[0x0c/2],
				dmaram[0x0e/2],
				dmaram[0x10/2],
				dmaram[0x12/2],
				dmaram[0x14/2],
				dmaram[0x16/2],
				dmaram[0x18/2],
				dmaram[0x1a/2]));

		destl=dmaram[9]*0x40000;

		lastb=0xfffe;
		lastb2=0xffff;

		while(1)
		{
			int i;
			UINT8 ctrl=rom[srcdata];
 			++srcdata;

			for(i=0;i<8;++i)
			{
				UINT8 p=rom[srcdata];

				if(ctrl&0x80)
				{
					UINT8 real_byte;
					real_byte = rom[srctab+p*2];
					tempidx+=process(real_byte,tempidx);
					real_byte = rom[srctab+p*2+1];//px[DMA_XOR((current_table_address+p*2+1))];
					tempidx+=process(real_byte,tempidx);
 				}
 				else
 				{
 					tempidx+=process(p,tempidx);
 				}

 				ctrl<<=1;
 				++srcdata;


				if(tempidx>=len)
				{
					LOG(("%x\n",srcdata));
					return;
				}
 			}
		}
	}
}

/* if tileram is actually bigger than the mapped area, how do we access the rest? */
static READ16_HANDLER(tileram_r)
{
//  return tileram[offset];
	return 0x0000;
}

static WRITE16_HANDLER(tileram_w)
{
	//UINT16 tmp;
//  COMBINE_DATA(&tileram[offset]);

	/* are the DMA registers enabled some other way, or always mapped here, over RAM? */
	if (offset >= 0xfff00/2 && offset <= 0xfff1a/2 )
	{
		offset &=0x1f;
		srmp6_dma_w(offset,data,mem_mask);
	}
}

static WRITE16_HANDLER(paletteram_w)
{
	INT8 r, g, b;
	int brg = brightness - 0x60;

	paletteram16_xBBBBBGGGGGRRRRR_word_w(offset, data, mem_mask);

	if(brg)
	{
		r = data >>  0 & 0x1F;
		g = data >>  5 & 0x1F;
		b = data >> 10 & 0x1F;

		if(brg < 0) {
			r += (r * brg) >> 5;
			if(r < 0) r = 0;
			g += (g * brg) >> 5;
			if(g < 0) g = 0;
			b += (b * brg) >> 5;
			if(b < 0) b = 0;
		}
		else if(brg > 0) {
			r += ((0x1F - r) * brg) >> 5;
			if(r > 0x1F) r = 0x1F;
			g += ((0x1F - g) * brg) >> 5;
			if(g > 0x1F) g = 0x1F;
			b += ((0x1F - b) * brg) >> 5;
			if(b > 0x1F) b = 0x1F;
		}

		palette_set_color(offset, r << 3, g << 3, b << 3);
	}
}

static MEMORY_READ16_START( srmp6_readmem )
	{ 0x000000, 0x0fffff, MRA16_ROM },
	{ 0x200000, 0x23ffff, MRA16_RAM },					// work RAM
	{ 0x600000, 0x7fffff, MRA16_BANK1 },	// banked ROM (used by ROM check)
	{ 0x800000, 0x9fffff, MRA16_ROM },

	{ 0x300000, 0x300005, srmp6_inputs_r },		// inputs
	{ 0x480000, 0x480fff, MRA16_RAM },
	{ 0x4d0000, 0x4d0001, watchdog_reset16_r },	// watchdog

	// OBJ RAM: checked [$400000-$47dfff]
	{ 0x400000, 0x47dfff, MRA16_RAM },	// 512 sprites & character list

	// CHR RAM: checked [$500000-$5fffff]
	{ 0x500000, 0x5fffff, tileram_r },
//  { 0x5fff00, 0x5fffff, MRA16_RAM },

	{ 0x4c0000, 0x4c006f, video_regs_r },	// ? gfx regs ST-0026 NiLe
  	{ 0x4e0000, 0x4e00ff, nile_snd_r },
  	{ 0x4e0100, 0x4e0101, nile_sndctrl_r },
//  { 0x4e0110, 0x4e0111, MRA16_NOP }, // ? accessed once ($268dc, written $b.w)
//  { 0x5fff00, 0x5fff1f, MRA16_RAM }, // ? see routine $5ca8, video_regs related ???

//  { 0xf00004, 0xf00005, MRA16_RAM }, // ?
//  { 0xf00006, 0xf00007, MRA16_RAM }, // ?
MEMORY_END

static MEMORY_WRITE16_START( srmp6_writemem )
	{ 0x000000, 0x0fffff, MWA16_ROM },
	{ 0x200000, 0x23ffff, MWA16_RAM },					// work RAM
	{ 0x600000, 0x7fffff, MWA16_BANK1 },	// banked ROM (used by ROM check)
	{ 0x800000, 0x9fffff, MWA16_ROM, &rom_base },

	{ 0x300000, 0x300005, srmp6_input_select_w },		// inputs
	{ 0x480000, 0x480fff, paletteram_w, &paletteram16 },
	{ 0x4d0000, 0x4d0001, watchdog_reset16_w },	// watchdog

	// OBJ RAM: checked [$400000-$47dfff]
	{ 0x400000, 0x47dfff, MWA16_RAM, &sprram },	// 512 sprites & character list

	// CHR RAM: checked [$500000-$5fffff]
	{ 0x500000, 0x5fffff, tileram_w },
//  { 0x5fff00, 0x5fffff, dma_w, &dmaram },

	{ 0x4c0000, 0x4c006f, video_regs_w, &video_regs },	// ? gfx regs ST-0026 NiLe
  	{ 0x4e0000, 0x4e00ff, nile_snd_w, &nile_sound_regs },
  	{ 0x4e0100, 0x4e0101, nile_sndctrl_w },
//  { 0x4e0110, 0x4e0111, MWA16_NOP }, // ? accessed once ($268dc, written $b.w)
//  { 0x5fff00, 0x5fff1f, MWA16_RAM }, // ? see routine $5ca8, video_regs related ???

//  { 0xf00004, 0xf00005, MWA16_RAM }, // ?
//  { 0xf00006, 0xf00007, MWA16_RAM }, // ?
MEMORY_END


/***************************************************************************
    Port definitions
***************************************************************************/

INPUT_PORTS_START( srmp6 )

	PORT_START
	PORT_BIT ( 0xfe01, IP_ACTIVE_LOW, IPT_UNUSED ) // explicitely discarded
	PORT_BITX( 0x0002, IP_ACTIVE_LOW, 0, "P1 A", KEYCODE_A, IP_JOY_NONE )
	PORT_BITX( 0x0004, IP_ACTIVE_LOW, 0, "P1 E", KEYCODE_E, IP_JOY_NONE )
	PORT_BITX( 0x0008, IP_ACTIVE_LOW, 0, "P1 I", KEYCODE_I, IP_JOY_NONE )
	PORT_BITX( 0x0010, IP_ACTIVE_LOW, 0, "P1 M", KEYCODE_M, IP_JOY_NONE )
	PORT_BITX( 0x0020, IP_ACTIVE_LOW, 0, "P1 Kan", KEYCODE_LCONTROL, IP_JOY_NONE )
	PORT_BIT ( 0x0040, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT ( 0x0080, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BITX( 0x0100, IP_ACTIVE_LOW, IPT_SERVICE, DEF_STR( Test ), KEYCODE_F2, IP_JOY_NONE )

	PORT_START
	PORT_BIT ( 0xfe41, IP_ACTIVE_LOW, IPT_UNUSED ) // explicitely discarded
	PORT_BITX( 0x0002, IP_ACTIVE_LOW, 0, "P1 B", KEYCODE_B, IP_JOY_NONE )
	PORT_BITX( 0x0004, IP_ACTIVE_LOW, 0, "P1 F", KEYCODE_F, IP_JOY_NONE )
	PORT_BITX( 0x0008, IP_ACTIVE_LOW, 0, "P1 J", KEYCODE_J, IP_JOY_NONE )
	PORT_BITX( 0x0010, IP_ACTIVE_LOW, 0, "P1 N", KEYCODE_N, IP_JOY_NONE )
	PORT_BITX( 0x0020, IP_ACTIVE_LOW, 0, "P1 Reach", KEYCODE_LSHIFT, IP_JOY_NONE )
	PORT_BIT ( 0x0180, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START
	PORT_BIT ( 0xfe41, IP_ACTIVE_LOW, IPT_UNUSED ) // explicitely discarded
	PORT_BITX( 0x0002, IP_ACTIVE_LOW, 0, "P1 C", KEYCODE_C, IP_JOY_NONE )
	PORT_BITX( 0x0004, IP_ACTIVE_LOW, 0, "P1 G", KEYCODE_G, IP_JOY_NONE )
	PORT_BITX( 0x0008, IP_ACTIVE_LOW, 0, "P1 K", KEYCODE_K, IP_JOY_NONE )
	PORT_BITX( 0x0010, IP_ACTIVE_LOW, 0, "P1 Chi", KEYCODE_SPACE, IP_JOY_NONE )
	PORT_BITX( 0x0020, IP_ACTIVE_LOW, 0, "P1 Ron", KEYCODE_Z, IP_JOY_NONE )
	PORT_BIT ( 0x0180, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START
	PORT_BIT ( 0xfe61, IP_ACTIVE_LOW, IPT_UNUSED ) // explicitely discarded
	PORT_BITX( 0x0002, IP_ACTIVE_LOW, 0, "P1 D", KEYCODE_D, IP_JOY_NONE )
	PORT_BITX( 0x0004, IP_ACTIVE_LOW, 0, "P1 H", KEYCODE_H, IP_JOY_NONE )
	PORT_BITX( 0x0008, IP_ACTIVE_LOW, 0, "P1 L", KEYCODE_L, IP_JOY_NONE )
	PORT_BITX( 0x0010, IP_ACTIVE_LOW, 0, "P1 Pon", KEYCODE_LALT, IP_JOY_NONE )
	PORT_BIT ( 0x0180, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* 16-bit DSW1+DSW2 */
	PORT_DIPNAME( 0x0007, 0x0007, DEF_STR( Coinage ) )		// DSW1
	PORT_DIPSETTING(      0x0000, DEF_STR( 5C_1C ) )
	PORT_DIPSETTING(      0x0001, DEF_STR( 4C_1C ) )
	PORT_DIPSETTING(      0x0002, DEF_STR( 3C_1C ) )
	PORT_DIPSETTING(      0x0003, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(      0x0007, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(      0x0006, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(      0x0005, DEF_STR( 1C_3C ) )
	PORT_DIPSETTING(      0x0004, DEF_STR( 1C_4C ) )
	PORT_DIPNAME( 0x0008, 0x0008, DEF_STR( Unused ) )
	PORT_DIPSETTING(      0x0008, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( On ) )
	PORT_DIPNAME( 0x0010, 0x0010, DEF_STR( Unused ) )
	PORT_DIPSETTING(      0x0010, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( On ) )
	PORT_DIPNAME( 0x0020, 0x0020, DEF_STR( Unused ) )
	PORT_DIPSETTING(      0x0020, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( On ) )
	PORT_DIPNAME( 0x0040, 0x0000, "Re-Clothe" )
	PORT_DIPSETTING(      0x0000, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x0040, DEF_STR( On ) )
	PORT_DIPNAME( 0x0080, 0x0080, "Nudity" )
	PORT_DIPSETTING(      0x0000, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x0080, DEF_STR( On ) )
	PORT_DIPNAME( 0x0700, 0x0700, DEF_STR( Difficulty ) )	// DSW2
	PORT_DIPSETTING(      0x0000, "8" )
	PORT_DIPSETTING(      0x0100, "7" )
	PORT_DIPSETTING(      0x0200, "6" )
	PORT_DIPSETTING(      0x0300, "5" )
	PORT_DIPSETTING(      0x0400, "3" )
	PORT_DIPSETTING(      0x0500, "2" )
	PORT_DIPSETTING(      0x0600, "1" )
	PORT_DIPSETTING(      0x0700, "4" )
	PORT_DIPNAME( 0x0800, 0x0000, "Kuitan" )
	PORT_DIPSETTING(      0x0000, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x0800, DEF_STR( On ) )
	PORT_DIPNAME( 0x1000, 0x1000, DEF_STR( Continues ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x1000, DEF_STR( On ) )
	PORT_DIPNAME( 0x2000, 0x2000, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x2000, DEF_STR( On ) )
	PORT_DIPNAME( 0x4000, 0x4000, DEF_STR( Flip_Screen ) )
	PORT_DIPSETTING(      0x4000, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( On ) )
	PORT_SERVICE( 0x8000, IP_ACTIVE_LOW )
INPUT_PORTS_END

/***************************************************************************
    Machine driver
***************************************************************************/

INTERRUPT_GEN(srmp6_interrupt)
{
	if(!cpu_getiloops())
	{
		cpu_set_irq_line(0,3,HOLD_LINE);
	}
	else
	{
		cpu_set_irq_line(0,4,HOLD_LINE);
	}
}
static struct NiLe_interface nile_interface =
{
	REGION_USER2,
	{ MIXER(100,MIXER_PAN_LEFT), MIXER(100,MIXER_PAN_RIGHT) },
};

static MACHINE_DRIVER_START( srmp6 )
	MDRV_CPU_ADD(M68000, 16000000)
	MDRV_CPU_MEMORY(srmp6_readmem,srmp6_writemem)
	MDRV_CPU_VBLANK_INT(srmp6_interrupt,2)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER | VIDEO_NEEDS_6BITS_PER_GUN)
	MDRV_SCREEN_SIZE(64*8, 64*8)
	MDRV_VISIBLE_AREA(0*8, 42*8-1, 0*8, 30*8-1)
	MDRV_PALETTE_LENGTH(0x800)

	MDRV_VIDEO_START(srmp6)
	MDRV_VIDEO_UPDATE(srmp6)

	/* sound hardware */
	MDRV_SOUND_ATTRIBUTES(SOUND_SUPPORTS_STEREO)
	MDRV_SOUND_ADD(NILE, nile_interface)
MACHINE_DRIVER_END


/***************************************************************************
    ROM definition(s)
***************************************************************************/

ROM_START( srmp6 )
	ROM_REGION( 0x100000, REGION_CPU1, 0 ) /* 68000 Code */
	ROM_LOAD16_BYTE( "sx011-10.4", 0x000001, 0x080000, 0x8f4318a5 )
	ROM_LOAD16_BYTE( "sx011-11.5", 0x000000, 0x080000, 0x7503d9cf )

	ROM_REGION( 0x200000, REGION_USER1, 0 ) /* 68000 Data */
	ROM_LOAD( "sx011-09.10", 0x000000, 0x200000, 0x58f74438 )

 	/* these are accessed directly by the 68k, DMA device etc.  NOT decoded */
	ROM_REGION( 0x2000000, REGION_USER2, 0)	/* Banked ROM */
	ROM_LOAD16_WORD_SWAP( "sx011-08.15", 0x0000000, 0x0400000, 0x01b3b1f0 ) // CHR00
	ROM_LOAD16_WORD_SWAP( "sx011-07.16", 0x0400000, 0x0400000, 0x26e57dac ) // CHR01
	ROM_LOAD16_WORD_SWAP( "sx011-06.17", 0x0800000, 0x0400000, 0x220ee32c ) // CHR02
	ROM_LOAD16_WORD_SWAP( "sx011-05.18", 0x0c00000, 0x0400000, 0x87e5fea9 ) // CHR03
	ROM_LOAD16_WORD_SWAP( "sx011-04.19", 0x1000000, 0x0400000, 0xe90d331e ) // CHR04
	ROM_LOAD16_WORD_SWAP( "sx011-03.20", 0x1400000, 0x0400000, 0xf1f24b35 ) // CHR05
	ROM_LOAD16_WORD_SWAP( "sx011-02.21", 0x1800000, 0x0400000, 0xc56d7e50 ) // CHR06
	ROM_LOAD16_WORD_SWAP( "sx011-01.22", 0x1c00000, 0x0400000, 0x785409d1 ) // CHR07
ROM_END


/***************************************************************************
    Driver initialization
***************************************************************************/

static DRIVER_INIT( srmp6 )
{
	/* copy the ROM data */
	memcpy(rom_base, memory_region(REGION_USER1), memory_region_length(REGION_USER1));
}


/***************************************************************************
    Game driver(s)
***************************************************************************/

/*GAME( YEAR,NAME,PARENT,MACHINE,INPUT,INIT,MONITOR,COMPANY,FULLNAME,FLAGS)*/
GAMEX( 1995, srmp6, 0, srmp6, srmp6, srmp6, ROT0, "Seta", "Super Real Mahjong P6 (Japan)", GAME_IMPERFECT_GRAPHICS | GAME_IMPERFECT_SOUND)

