/*

Funny Bubble ...

It's a puzzloop rip-off .. but with two Z80 CPUs
the program roms say omega 1997
the gfx roms say 1999
title screen has no date

( a z80 as the main cpu in 1999 ??! )

todo :
Funny Bubble has three clocks, 8 mhz, 12 mhz and 30 mhz
8 mhz is near to roms 1/3/4, 30 mhz near to rom 2 (and the z80), 12 mhz is near to the gfx roms (7-10)

convert to tilemaps

*/



#include "driver.h"

/* vidhrdw/funybubl.c */
extern data8_t* funybubl_banked_videoram;
extern data8_t *funybubl_paletteram;
WRITE_HANDLER ( funybubl_paldatawrite );
VIDEO_START(funybubl);
VIDEO_UPDATE(funybubl);



static WRITE_HANDLER ( funybubl_vidram_bank_w )
{
	if ((data&1) == 0)
		cpu_setbank(1,&funybubl_banked_videoram[0x000000]);
	else
		cpu_setbank(1,&funybubl_banked_videoram[0x001000]);
}

static WRITE_HANDLER ( funybubl_cpurombank_w )
{
	unsigned char *rom = memory_region(REGION_CPU1);

	cpu_setbank(2,&rom[0x10000+0x4000*(data&0x3f)]);
}



WRITE_HANDLER( funybubl_soundcommand_w )
{
	soundlatch_w(0,data);
	cpu_set_irq_line(1,0, PULSE_LINE);
}

WRITE_HANDLER( funybubl_oki_bank_sw )
{
	OKIM6295_set_bank_base(0, ((data & 1) * 0x40000));
}


static MEMORY_READ_START( readmem )
	{ 0x0000, 0x7fff, MRA_ROM },
	{ 0x8000, 0xbfff, MRA_BANK2 },	// banked port 1?
	{ 0xc400, 0xc7ff, MRA_RAM },
	{ 0xc800, 0xcfff, MRA_RAM },
	{ 0xd000, 0xdfff, MRA_BANK1 },	// banked port 0?
	{ 0xe000, 0xffff, MRA_RAM },
MEMORY_END

static MEMORY_WRITE_START( writemem )
	{ 0x0000, 0x7fff, MWA_ROM },
	{ 0x8000, 0xbfff, MWA_ROM },
	{ 0xc400, 0xcfff, funybubl_paldatawrite, &funybubl_paletteram }, // palette
	{ 0xd000, 0xdfff, MWA_BANK1 },	// banked port 0?
	{ 0xe000, 0xffff, MWA_RAM },
MEMORY_END

static PORT_READ_START( readport )
	{ 0x00, 0x00, input_port_0_r },
	{ 0x01, 0x01, input_port_1_r },
	{ 0x02, 0x02, input_port_2_r },
	{ 0x03, 0x03, input_port_3_r },
	{ 0x06, 0x06, IORP_NOP },		/* Nothing is done with the data read */
PORT_END

static PORT_WRITE_START( writeport )
	{ 0x00, 0x00, funybubl_vidram_bank_w },	// vidram bank
	{ 0x01, 0x01, funybubl_cpurombank_w },		// rom bank?
	{ 0x03, 0x03, funybubl_soundcommand_w },
	{ 0x06, 0x06, IOWP_NOP },		/* Written directly after IO port 0 */
	{ 0x07, 0x07, IOWP_NOP },		/* Reset something on startup - Sound CPU ?? */
PORT_END


/* Sound CPU */

static MEMORY_READ_START( soundreadmem )
	{ 0x0000, 0x7fff, MRA_ROM },
	{ 0x8000, 0x87ff, MRA_RAM },
	{ 0x9800, 0x9800, OKIM6295_status_0_r },
	{ 0xa000, 0xa000, soundlatch_r },
MEMORY_END

static MEMORY_WRITE_START( soundwritemem )
	{ 0x0000, 0x7fff, MWA_ROM },
	{ 0x8000, 0x87ff, MWA_RAM },
	{ 0x9000, 0x9000, funybubl_oki_bank_sw },
	{ 0x9800, 0x9800, OKIM6295_data_0_w },
MEMORY_END



INPUT_PORTS_START( funybubl )
	PORT_START	/* System inputs */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_START2 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_UNKNOWN )	/* Maybe unused */
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNKNOWN )	/* Maybe unused */
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )	/* Maybe unused */
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )	/* Maybe unused */

	PORT_START	/* Player 1 controls */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP     | IPF_8WAY | IPF_PLAYER1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN   | IPF_8WAY | IPF_PLAYER1 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT   | IPF_8WAY | IPF_PLAYER1 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT  | IPF_8WAY | IPF_PLAYER1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER1 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNKNOWN )	/* Maybe unused */
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )	/* Maybe unused */
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )	/* Maybe unused */

	PORT_START	/* Player 2 controls */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP     | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN   | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT   | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT  | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_UNKNOWN )	/* Maybe unused */
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNKNOWN )	/* Maybe unused */
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNKNOWN )	/* Maybe unused */

	PORT_START	/* DSW 1 */
	PORT_DIPNAME( 0x07, 0x07, DEF_STR( Coin_A ) )
	PORT_DIPSETTING(    0x01, DEF_STR( 3C_1C ) )
	PORT_DIPSETTING(    0x02, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(    0x03, DEF_STR( 3C_2C ) )
	PORT_DIPSETTING(    0x07, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(    0x04, DEF_STR( 2C_3C ) )
	PORT_DIPSETTING(    0x06, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(    0x05, DEF_STR( 1C_3C ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play) )
	PORT_DIPNAME( 0x38, 0x38, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x30, "Very Easy" )
	PORT_DIPSETTING(    0x28, "Easy" )
	PORT_DIPSETTING(    0x38, "Normal" )
	PORT_DIPSETTING(    0x20, "Hard 1" )
	PORT_DIPSETTING(    0x18, "Hard 2" )
	PORT_DIPSETTING(    0x10, "Hard 3" )
	PORT_DIPSETTING(    0x08, "Hard 4" )
	PORT_DIPNAME( 0x40, 0x00, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x00, "Nudity" )
	PORT_DIPSETTING(    0x80, "Semi" )
	PORT_DIPSETTING(    0x00, "Full" )

	/* Looks like the PCB shows an empty DSW 2 location */
INPUT_PORTS_END



static struct GfxLayout tiles16x16x8_1_layout =
{
	8,8,
	RGN_FRAC(1,8),
	8,
	{ RGN_FRAC(3,8),RGN_FRAC(2,8),RGN_FRAC(1,8),RGN_FRAC(0,8),RGN_FRAC(7,8),RGN_FRAC(6,8),RGN_FRAC(5,8), RGN_FRAC(4,8) },
	{ 0, 1, 2,  3,  4, 5, 6, 7 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	8*8
};

static struct GfxLayout tiles16x16x8_2_layout =
{
	16,16,
	RGN_FRAC(1,4),
	8,
	{ RGN_FRAC(3,4)+4,RGN_FRAC(3,4)+0, RGN_FRAC(2,4)+4, RGN_FRAC(2,4)+0, RGN_FRAC(1,4)+4, RGN_FRAC(1,4)+0, RGN_FRAC(0,4)+4, RGN_FRAC(0,4)+0  },
	{ 0, 1,2,3, 8,9,10,11, 256,257,258,259, 264,265,266,267},
	{ 0*16, 1*16, 2*16, 3*16, 4*16, 5*16, 6*16, 7*16,
	  8*16, 9*16,10*16,11*16,12*16,13*16,14*16,15*16 },
	32*16
};


static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ REGION_GFX1, 0, &tiles16x16x8_1_layout, 0, 16 },
	{ REGION_GFX2, 0, &tiles16x16x8_2_layout, 0, 16 },
	{ -1 }
};



static struct OKIM6295interface okim6295_interface =
{
	1,					/* 1 chip */
	{ 8000 },			/* ? frequency */
	{ REGION_SOUND1 },	/* memory region */
	{ 100 }
};

DRIVER_INIT( funybubl )
{
	funybubl_banked_videoram = auto_malloc (0x2000);

	cpu_setbank(1,&funybubl_banked_videoram[0x000000]);
}



static MACHINE_DRIVER_START( funybubl )
	/* basic machine hardware */
	MDRV_CPU_ADD(Z80,8000000)		 /* ? MHz */
	MDRV_CPU_MEMORY(readmem,writemem)
	MDRV_CPU_PORTS(readport,writeport)
	MDRV_CPU_VBLANK_INT(irq0_line_hold,1)

	MDRV_CPU_ADD(Z80,8000000)		 /* ? MHz */
	MDRV_CPU_MEMORY(soundreadmem,soundwritemem)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER )
	MDRV_SCREEN_SIZE(512, 256)
	MDRV_VISIBLE_AREA(12*8, 512-12*8-1, 16, 256-16-1)
//	MDRV_VISIBLE_AREA(0*8, 512-1, 0, 256-1)

	MDRV_GFXDECODE(gfxdecodeinfo)
	MDRV_PALETTE_LENGTH(0x400)

	MDRV_VIDEO_START(funybubl)
	MDRV_VIDEO_UPDATE(funybubl)

	/* sound hardware */
	MDRV_SOUND_ADD(OKIM6295, okim6295_interface)
MACHINE_DRIVER_END



ROM_START( funybubl )
	ROM_REGION( 0x50000, REGION_CPU1, 0 ) /* main z80, lots of banked data */
	ROM_LOAD( "2.bin", 0x00000, 0x40000, 0xd684c13f  )
	ROM_RELOAD ( 0x10000, 0x40000 )

	ROM_REGION( 0x200000, REGION_GFX1, ROMREGION_DISPOSE | ROMREGION_INVERT  ) // bg gfx 8x8x8
	ROM_LOAD( "7.bin", 0x000000, 0x40000, 0x87603d7b )
	ROM_LOAD( "8.bin", 0x040000, 0x40000, 0xab6031bd )
	ROM_LOAD( "9.bin", 0x080000, 0x40000, 0x0e8352ff )
	ROM_LOAD( "10.bin",0x0c0000, 0x40000, 0xdf7dd356 )
	ROM_LOAD( "13.bin",0x100000, 0x40000, 0x9f57bdd5 )
	ROM_LOAD( "14.bin",0x140000, 0x40000, 0x2ac15ea3 )
	ROM_LOAD( "15.bin",0x180000, 0x40000, 0x9a5e66a6 )
	ROM_LOAD( "16.bin",0x1c0000, 0x40000, 0x218060b3 )

	ROM_REGION( 0x200000, REGION_GFX2, ROMREGION_DISPOSE | ROMREGION_INVERT )
	ROM_LOAD( "5.bin", 0x000000, 0x80000, 0xb7ebbc00 )
	ROM_LOAD( "6.bin", 0x080000, 0x80000, 0x28afc396 )
	ROM_LOAD( "11.bin",0x100000, 0x80000, 0x9e8687cd )
	ROM_LOAD( "12.bin",0x180000, 0x80000, 0x63f0e810 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 ) /* sound z80 (not much code here ..) */
	ROM_LOAD( "1.bin", 0x00000,  0x10000, 0xb8b5b675 )
	ROM_FILL(          0x08000,  0x08000, 0x00 )

	ROM_REGION( 0x80000, REGION_SOUND1, 0 )
	ROM_LOAD( "3.bin", 0x00000,  0x20000, 0xa2d780f4 )
	ROM_RELOAD(        0x40000,  0x20000 )
	ROM_LOAD( "4.bin", 0x20000,  0x20000, 0x1f7e9269 )
	ROM_CONTINUE(      0x60000,  0x20000 )
ROM_END


GAME( 1999, funybubl, 0, funybubl, funybubl, funybubl, ROT0, "Comad", "Funny Bubble" )
