/***************************************************************************

Mr. Do's Castle memory map (preliminary)

TODO:
- the function of the third CPU is not clear.


FIRST CPU:
0000-7fff ROM
8000-97ff RAM
9800-99ff Sprites
b000-b3ff Video RAM
b400-b7ff Color RAM

read:
a000-a008 data from second CPU

write:
a000-a008 data for second CPU
a800      Watchdog reset?
e000      Trigger NMI on second CPU

SECOND CPU:
0000-3fff ROM
8000-87ff RAM

read:
a000-a008 data from first CPU
all the following ports can be read both from c00x and from c08x. I don't know
what's the difference.
c001      DSWB
c081      coins per play
c002      DSWA
          bit 6-7 = lives
		  bit 5 = upright/cocktail (0 = upright)
          bit 4 = difficulty of EXTRA (1 = easy)
          bit 3 = unused?
          bit 2 = RACK TEST
		  bit 0-1 = difficulty
c003      IN0
          bit 4-7 = joystick player 2
          bit 0-3 = joystick player 1
c004      flipscreen (proper cocktail mode implemented by Chad Hendrickson Aug 1, 1999)
c005	  IN1
          bit 7 = START 2
		  bit 6 = unused
		  bit 5 = jump player 2
		  bit 4 = fire player 2
		  bit 3 = START 1
		  bit 2 = unused
          bit 1 = jump player 1(same effect as fire)
          bit 0 = fire player 1
c085      during the boot sequence, clearing any of bits 0, 1, 3, 4, 5, 7 enters the
          test mode, while clearing bit 2 or 6 seems to lock the machine.
c007      IN2
          bit 7 = unused
          bit 6 = unused
          bit 5 = COIN 2
          bit 4 = COIN 1
          bit 3 = PAUSE
          bit 2 = SERVICE (keep pressed)
          bit 1 = TEST (doesn't work?)
          bit 0 = TILT

write:
a000-a008 data for first CPU
e000      sound port 1
e400      sound port 2
e800      sound port 3
ec00      sound port 4


Mr. Do Wild Ride / Mr. Do Run Run memory map (preliminary)

0000-1fff ROM
2000-37ff RAM
3800-39ff Sprites
4000-9fff ROM
a000-a008 Shared with second CPU
b000-b3ff Video RAM
b400-b7ff Color RAM

write:
a800      Watchdog reset?
b800      Trigger NMI on second CPU (?)

SECOND CPU:
0000-3fff ROM
8000-87ff RAM

read:
e000-e008 data from first CPU
c003      bit 0-3 = joystick
          bit 4-7 = ?
c004      flipscreen (proper cocktail mode implemented by Chad Hendrickson Aug 1, 1999)
c005      bit 0 = fire
          bit 1 = fire (again?!)
		  bit 2 = ?
		  bit 3 = START 1
		  bit 4-6 = ?
		  bit 4 = START 2
c081      coins per play

write:
e000-e008 data for first CPU
a000      sound port 1
a400      sound port 2
a800      sound port 3
ac00      sound port 4

Note:
idsoccer seems to run on a modified version of this board which allows for
more sprite tiles, it also has a MSM5205 chip for sample playback, this is
not currently hooked up

***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"



extern READ_HANDLER( docastle_shared0_r );
extern READ_HANDLER( docastle_shared1_r );
extern WRITE_HANDLER( docastle_shared0_w );
extern WRITE_HANDLER( docastle_shared1_w );
extern WRITE_HANDLER( docastle_nmitrigger_w );

extern WRITE_HANDLER( docastle_videoram_w );
extern WRITE_HANDLER( docastle_colorram_w );
extern READ_HANDLER( docastle_flipscreen_off_r );
extern READ_HANDLER( docastle_flipscreen_on_r );
extern WRITE_HANDLER( docastle_flipscreen_off_w );
extern WRITE_HANDLER( docastle_flipscreen_on_w );

extern PALETTE_INIT( docastle );
extern PALETTE_INIT( dorunrun );
extern VIDEO_START( docastle );
extern VIDEO_UPDATE( docastle );

static MEMORY_READ_START( docastle_readmem )
	{ 0x0000, 0x7fff, MRA_ROM },
	{ 0x8000, 0x97ff, MRA_RAM },
	{ 0xa000, 0xa008, docastle_shared0_r },
	{ 0xb800, 0xbbff, videoram_r }, /* mirror of video ram */
	{ 0xbc00, 0xbfff, colorram_r }, /* mirror of color ram */
MEMORY_END

static MEMORY_WRITE_START( docastle_writemem )
	{ 0x0000, 0x7fff, MWA_ROM },
	{ 0x8000, 0x97ff, MWA_RAM },
	{ 0x9800, 0x99ff, MWA_RAM, &spriteram, &spriteram_size },
	{ 0xa000, 0xa008, docastle_shared1_w },
	{ 0xa800, 0xa800, watchdog_reset_w },
	{ 0xb000, 0xb3ff, docastle_videoram_w, &videoram },
	{ 0xb400, 0xb7ff, docastle_colorram_w, &colorram },
	{ 0xe000, 0xe000, docastle_nmitrigger_w },
MEMORY_END

static MEMORY_READ_START( dorunrun_readmem )
	{ 0x0000, 0x1fff, MRA_ROM },
	{ 0x2000, 0x37ff, MRA_RAM },
	{ 0x4000, 0x9fff, MRA_ROM },
	{ 0xa000, 0xa008, docastle_shared0_r },
MEMORY_END

static MEMORY_WRITE_START( dorunrun_writemem )
	{ 0x0000, 0x1fff, MWA_ROM },
	{ 0x2000, 0x37ff, MWA_RAM },
	{ 0x3800, 0x39ff, MWA_RAM, &spriteram, &spriteram_size },
	{ 0x4000, 0x9fff, MWA_ROM },
	{ 0xa000, 0xa008, docastle_shared1_w },
	{ 0xb000, 0xb3ff, docastle_videoram_w, &videoram },
	{ 0xb400, 0xb7ff, docastle_colorram_w, &colorram },
	{ 0xb800, 0xb800, docastle_nmitrigger_w },
	{ 0xa800, 0xa800, watchdog_reset_w },
MEMORY_END

/* what is this really, sound related? */
static READ_HANDLER(idsoccer_c000_r)
{
	static int i = 0x00;
	i ^= 0x80; return i;
}

static MEMORY_READ_START( idsoccer_readmem )
	{ 0x0000, 0x3fff, MRA_ROM },
	{ 0x4000, 0x59ff, MRA_RAM },
	{ 0x6000, 0x9fff, MRA_ROM },
	{ 0xa000, 0xa008, docastle_shared0_r },
	{ 0xb800, 0xbbff, videoram_r },
	{ 0xbc00, 0xbfff, colorram_r },
	{ 0xc000, 0xc000, idsoccer_c000_r }, /* ?? */
MEMORY_END

static MEMORY_WRITE_START( idsoccer_writemem )
	{ 0x0000, 0x3fff, MWA_ROM },
	{ 0x4000, 0x57ff, MWA_RAM },
	{ 0x5800, 0x59ff, MWA_RAM, &spriteram, &spriteram_size },
	{ 0x6000, 0x9fff, MWA_ROM },
	{ 0xa000, 0xa008, docastle_shared1_w },
	{ 0xa800, 0xa800, watchdog_reset_w },
	{ 0xb000, 0xb3ff, docastle_videoram_w, &videoram },
	{ 0xb400, 0xb7ff, docastle_colorram_w, &colorram },
	{ 0xc000, 0xc000, MWA_NOP }, /* ?? */
	{ 0xe000, 0xe000, docastle_nmitrigger_w },
MEMORY_END

static MEMORY_READ_START( docastle_readmem2 )
	{ 0x0000, 0x3fff, MRA_ROM },
	{ 0x8000, 0x87ff, MRA_RAM },
	{ 0xa000, 0xa008, docastle_shared1_r },
	{ 0xc003, 0xc003, input_port_0_r },
	{ 0xc083, 0xc083, input_port_0_r },
	{ 0xc005, 0xc005, input_port_1_r },
	{ 0xc085, 0xc085, input_port_1_r },
	{ 0xc007, 0xc007, input_port_2_r },
	{ 0xc087, 0xc087, input_port_2_r },
	{ 0xc002, 0xc002, input_port_3_r },
	{ 0xc082, 0xc082, input_port_3_r },
	{ 0xc001, 0xc001, input_port_4_r },
	{ 0xc081, 0xc081, input_port_4_r },
	{ 0xc004, 0xc004, docastle_flipscreen_off_r },
	{ 0xc084, 0xc084, docastle_flipscreen_on_r },
MEMORY_END

static MEMORY_WRITE_START( docastle_writemem2 )
	{ 0x0000, 0x3fff, MWA_ROM },
	{ 0x8000, 0x87ff, MWA_RAM },
	{ 0xa000, 0xa008, docastle_shared0_w },
	{ 0xe000, 0xe000, SN76496_0_w },
	{ 0xe400, 0xe400, SN76496_1_w },
	{ 0xe800, 0xe800, SN76496_2_w },
	{ 0xec00, 0xec00, SN76496_3_w },
	{ 0xc004, 0xc004, docastle_flipscreen_off_w },
	{ 0xc084, 0xc084, docastle_flipscreen_on_w },
MEMORY_END

static MEMORY_READ_START( idsoccer_readmem2 )
	{ 0x0000, 0x3fff, MRA_ROM },
	{ 0x8000, 0x87ff, MRA_RAM },
	{ 0xa000, 0xa008, docastle_shared1_r },
	{ 0xc003, 0xc003, input_port_0_r },
	{ 0xc083, 0xc083, input_port_0_r },
	{ 0xc005, 0xc005, input_port_1_r },
	{ 0xc085, 0xc085, input_port_1_r },
	{ 0xc007, 0xc007, input_port_2_r },
	{ 0xc087, 0xc087, input_port_2_r },
	{ 0xc002, 0xc002, input_port_3_r },
	{ 0xc082, 0xc082, input_port_3_r },
	{ 0xc001, 0xc001, input_port_4_r },
	{ 0xc081, 0xc081, input_port_4_r },
	{ 0xc004, 0xc004, input_port_5_r },
	{ 0xc084, 0xc084, input_port_5_r },
MEMORY_END

static MEMORY_READ_START( docastle_readmem3 )
	{ 0x0000, 0x0100, MRA_ROM },
MEMORY_END

static MEMORY_WRITE_START( docastle_writemem3 )
	{ 0x0000, 0x0100, MWA_ROM },
MEMORY_END

static MEMORY_READ_START( dorunrun_readmem2 )
	{ 0x0000, 0x3fff, MRA_ROM },
	{ 0x8000, 0x87ff, MRA_RAM },
	{ 0xc003, 0xc003, input_port_0_r },
	{ 0xc083, 0xc083, input_port_0_r },
	{ 0xc005, 0xc005, input_port_1_r },
	{ 0xc085, 0xc085, input_port_1_r },
	{ 0xc007, 0xc007, input_port_2_r },
	{ 0xc087, 0xc087, input_port_2_r },
	{ 0xc002, 0xc002, input_port_3_r },
	{ 0xc082, 0xc082, input_port_3_r },
	{ 0xc001, 0xc001, input_port_4_r },
	{ 0xc081, 0xc081, input_port_4_r },
	{ 0xc004, 0xc004, docastle_flipscreen_off_r },
	{ 0xc084, 0xc084, docastle_flipscreen_on_r },
	{ 0xe000, 0xe008, docastle_shared1_r },
MEMORY_END

static MEMORY_WRITE_START( dorunrun_writemem2 )
	{ 0x0000, 0x3fff, MWA_ROM },
	{ 0x8000, 0x87ff, MWA_RAM },
	{ 0xa000, 0xa000, SN76496_0_w },
	{ 0xa400, 0xa400, SN76496_1_w },
	{ 0xa800, 0xa800, SN76496_2_w },
	{ 0xac00, 0xac00, SN76496_3_w },
	{ 0xc004, 0xc004, docastle_flipscreen_off_w },
	{ 0xc084, 0xc084, docastle_flipscreen_on_w },
	{ 0xe000, 0xe008, docastle_shared0_w },
MEMORY_END



/* Coinage used for all games */
#define COINAGE_PORT \
	PORT_START \
	PORT_DIPNAME( 0x0f, 0x0f, DEF_STR( Coin_B ) ) \
	PORT_DIPSETTING(    0x06, DEF_STR( 4C_1C ) ) \
	PORT_DIPSETTING(    0x08, DEF_STR( 3C_1C ) ) \
	PORT_DIPSETTING(    0x0a, DEF_STR( 2C_1C ) ) \
	PORT_DIPSETTING(    0x07, DEF_STR( 3C_2C ) ) \
	PORT_DIPSETTING(    0x0f, DEF_STR( 1C_1C ) ) \
	PORT_DIPSETTING(    0x09, DEF_STR( 2C_3C ) ) \
	PORT_DIPSETTING(    0x0e, DEF_STR( 1C_2C ) ) \
	PORT_DIPSETTING(    0x0d, DEF_STR( 1C_3C ) ) \
	PORT_DIPSETTING(    0x0c, DEF_STR( 1C_4C ) ) \
	PORT_DIPSETTING(    0x0b, DEF_STR( 1C_5C ) ) \
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) ) \
	/* 0x01, 0x02, 0x03, 0x04, 0x05 all give 1 Coin/1 Credit */ \
	PORT_DIPNAME( 0xf0, 0xf0, DEF_STR( Coin_A ) ) \
	PORT_DIPSETTING(    0x60, DEF_STR( 4C_1C ) ) \
	PORT_DIPSETTING(    0x80, DEF_STR( 3C_1C ) ) \
	PORT_DIPSETTING(    0xa0, DEF_STR( 2C_1C ) ) \
	PORT_DIPSETTING(    0x70, DEF_STR( 3C_2C ) ) \
	PORT_DIPSETTING(    0xf0, DEF_STR( 1C_1C ) ) \
	PORT_DIPSETTING(    0x90, DEF_STR( 2C_3C ) ) \
	PORT_DIPSETTING(    0xe0, DEF_STR( 1C_2C ) ) \
	PORT_DIPSETTING(    0xd0, DEF_STR( 1C_3C ) ) \
	PORT_DIPSETTING(    0xc0, DEF_STR( 1C_4C ) ) \
	PORT_DIPSETTING(    0xb0, DEF_STR( 1C_5C ) ) \
	PORT_DIPSETTING(    0x00, DEF_STR( Free_Play ) ) \
	/* 0x10, 0x20, 0x30, 0x40, 0x50 all give 1 Coin/1 Credit */


INPUT_PORTS_START( docastle )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_4WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_4WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_4WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_4WAY )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_4WAY | IPF_COCKTAIL )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_COCKTAIL )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_START2 )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_TILT )
	PORT_BITX( 0x02, IP_ACTIVE_LOW, IPT_SERVICE, DEF_STR( Service_Mode ), KEYCODE_F2, JOYCODE_NONE )
	PORT_BIT_IMPULSE( 0x04, IP_ACTIVE_LOW, IPT_SERVICE1, 32 ) /* coin input must be active for 32 frames to be consistently recognized */
	PORT_DIPNAME( 0x08, 0x08, "Freeze" )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* DSW0 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x03, "Easy" )
	PORT_DIPSETTING(    0x02, "Medium" )
	PORT_DIPSETTING(    0x01, "Hard" )
	PORT_DIPSETTING(    0x00, "Hardest" )
	PORT_DIPNAME( 0x04, 0x04, "Automatic Screen Renewal" )
	PORT_DIPSETTING(    0x00, DEF_STR( No ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x08, 0x08, "Advance Level on Getting Diamond" )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, "Extra" )
	PORT_DIPSETTING(    0x10, "Easy" )
	PORT_DIPSETTING(    0x00, "Hard" )
	PORT_DIPNAME( 0x20, 0x00, DEF_STR( Cabinet ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Upright ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Cocktail ) )
	PORT_DIPNAME( 0xc0, 0xc0, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x00, "2" )
	PORT_DIPSETTING(    0xc0, "3" )
	PORT_DIPSETTING(    0x80, "4" )
	PORT_DIPSETTING(    0x40, "5" )

	COINAGE_PORT
INPUT_PORTS_END

INPUT_PORTS_START( dorunrun )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_4WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_4WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_4WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_4WAY )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_4WAY | IPF_COCKTAIL )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_COCKTAIL )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_START2 )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_TILT )
	PORT_BITX( 0x02, IP_ACTIVE_LOW, IPT_SERVICE, DEF_STR( Service_Mode ), KEYCODE_F2, JOYCODE_NONE )
	PORT_BIT_IMPULSE( 0x04, IP_ACTIVE_LOW, IPT_SERVICE1, 32 ) /* coin input must be active for 32 frames to be consistently recognized */
	PORT_DIPNAME( 0x08, 0x08, "Freeze" )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* DSW0 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x03, "Easy" )
	PORT_DIPSETTING(    0x02, "Medium" )
	PORT_DIPSETTING(    0x01, "Hard" )
	PORT_DIPSETTING(    0x00, "Hardest" )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x04, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Flip_Screen ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, "Extra" )
	PORT_DIPSETTING(    0x10, "Easy" )
	PORT_DIPSETTING(    0x00, "Hard" )
	PORT_DIPNAME( 0x20, 0x00, DEF_STR( Cabinet ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Upright ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Cocktail ) )
	PORT_DIPNAME( 0x40, 0x40, "Special" )
	PORT_DIPSETTING(    0x40, "Given" )
	PORT_DIPSETTING(    0x00, "Not Given" )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x80, "3" )
	PORT_DIPSETTING(    0x00, "5" )

	COINAGE_PORT
INPUT_PORTS_END

INPUT_PORTS_START( dowild )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_4WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_4WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_4WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_4WAY )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_4WAY | IPF_COCKTAIL )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_COCKTAIL )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_START2 )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_TILT )
	PORT_BITX( 0x02, IP_ACTIVE_LOW, IPT_SERVICE, DEF_STR( Service_Mode ), KEYCODE_F2, JOYCODE_NONE )
	PORT_BIT_IMPULSE( 0x04, IP_ACTIVE_LOW, IPT_SERVICE1, 32 ) /* coin input must be active for 32 frames to be consistently recognized */
	PORT_DIPNAME( 0x08, 0x08, "Freeze" )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* DSW0 */
	PORT_DIPNAME( 0x03, 0x03, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(    0x03, "Easy" )
	PORT_DIPSETTING(    0x02, "Medium" )
	PORT_DIPSETTING(    0x01, "Hard" )
	PORT_DIPSETTING(    0x00, "Hardest" )
	PORT_BITX(    0x04, 0x04, IPT_DIPSWITCH_NAME | IPF_CHEAT, "Rack Test", KEYCODE_F1, IP_JOY_NONE )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Flip_Screen ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, "Extra" )
	PORT_DIPSETTING(    0x10, "Easy" )
	PORT_DIPSETTING(    0x00, "Hard" )
	PORT_DIPNAME( 0x20, 0x00, DEF_STR( Cabinet ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Upright ) )

PORT_DIPSETTING(    0x20, DEF_STR( Cocktail ) )
	PORT_DIPNAME( 0x40, 0x40, "Special" )
	PORT_DIPSETTING(    0x40, "Given" )
	PORT_DIPSETTING(    0x00, "Not Given" )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x80, "3" )
	PORT_DIPSETTING(    0x00, "5" )

	COINAGE_PORT
INPUT_PORTS_END

INPUT_PORTS_START( jjack )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_4WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_4WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_4WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_4WAY )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_4WAY | IPF_COCKTAIL )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_4WAY | IPF_COCKTAIL )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_COCKTAIL )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_START2 )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_TILT )
	PORT_BITX( 0x02, IP_ACTIVE_LOW, IPT_SERVICE, DEF_STR( Service_Mode ), KEYCODE_F2, JOYCODE_NONE )
	PORT_BIT_IMPULSE( 0x04, IP_ACTIVE_LOW, IPT_SERVICE1, 32 ) /* coin input must be active for 32 frames to be consistently recognized */
	PORT_DIPNAME( 0x08, 0x08, "Freeze" )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* DSW0 */
	PORT_DIPNAME( 0x03, 0x03, "Difficulty?" )
	PORT_DIPSETTING(    0x03, "Easy" )
	PORT_DIPSETTING(    0x02, "Medium" )
	PORT_DIPSETTING(    0x01, "Hard" )
	PORT_DIPSETTING(    0x00, "Hardest" )
	PORT_BITX(    0x04, 0x04, IPT_DIPSWITCH_NAME | IPF_CHEAT, "Rack Test", KEYCODE_F1, IP_JOY_NONE )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Flip_Screen ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, "Extra?" )
	PORT_DIPSETTING(    0x10, "Easy" )
	PORT_DIPSETTING(    0x00, "Hard" )
	PORT_DIPNAME( 0x20, 0x00, DEF_STR( Cabinet ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Upright ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Cocktail ) )
	PORT_DIPNAME( 0xc0, 0xc0, DEF_STR( Lives ) )
	PORT_DIPSETTING(    0x00, "2" )
	PORT_DIPSETTING(    0xc0, "3" )
	PORT_DIPSETTING(    0x80, "4" )
	PORT_DIPSETTING(    0x40, "5" )

	COINAGE_PORT
INPUT_PORTS_END

INPUT_PORTS_START( kickridr )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT | IPF_8WAY | IPF_COCKTAIL )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICK_UP | IPF_8WAY | IPF_COCKTAIL )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT | IPF_8WAY | IPF_COCKTAIL )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN | IPF_8WAY | IPF_COCKTAIL )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_COCKTAIL )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_COCKTAIL )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_START2 )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_TILT )
	PORT_BITX( 0x02, IP_ACTIVE_LOW, IPT_SERVICE, DEF_STR( Service_Mode ), KEYCODE_F2, JOYCODE_NONE )
	PORT_BIT_IMPULSE( 0x04, IP_ACTIVE_LOW, IPT_SERVICE1, 32 ) /* coin input must be active for 32 frames to be consistently recognized */
	PORT_DIPNAME( 0x08, 0x08, "Freeze" )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* DSW0 */
	PORT_DIPNAME( 0x03, 0x03, "Difficulty?" )
	PORT_DIPSETTING(    0x03, "Easy" )
	PORT_DIPSETTING(    0x02, "Medium" )
	PORT_DIPSETTING(    0x01, "Hard" )
	PORT_DIPSETTING(    0x00, "Hardest" )
	PORT_BITX(    0x04, 0x04, IPT_DIPSWITCH_NAME | IPF_CHEAT, "Rack Test", KEYCODE_F1, IP_JOY_NONE )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Flip_Screen ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, "DSW4" )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x00, DEF_STR( Cabinet ) )
	PORT_DIPSETTING(    0x00, DEF_STR( Upright ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Cocktail ) )
	PORT_DIPNAME( 0x40, 0x40, "DSW2" )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, "DSW1" )
	PORT_DIPSETTING(    0x00, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x80, DEF_STR( On ) )

	COINAGE_PORT
INPUT_PORTS_END

INPUT_PORTS_START( idsoccer )
	PORT_START	/* IN0 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_RIGHT | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_UP | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_LEFT | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_DOWN | IPF_8WAY )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_RIGHT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_UP | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_LEFT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_JOYSTICKLEFT_DOWN | IPF_8WAY | IPF_PLAYER2 )

	PORT_START	/* IN1 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_BUTTON1 )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_BUTTON2 )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_START1 )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_BUTTON1 | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_BUTTON2 | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_START2 )

	PORT_START	/* IN2 */
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_TILT )
	PORT_BITX( 0x02, IP_ACTIVE_LOW, IPT_SERVICE, DEF_STR( Service_Mode ), KEYCODE_F2, JOYCODE_NONE )
	PORT_BIT_IMPULSE( 0x04, IP_ACTIVE_LOW, IPT_SERVICE1, 32 ) /* coin input must be active for 32 frames to be consistently recognized */
	PORT_DIPNAME( 0x08, 0x08, "Freeze" )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_COIN2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_COIN1 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_UNUSED )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_UNUSED )

	PORT_START	/* DSW0 */
	PORT_DIPNAME( 0x01, 0x01, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x01, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x02, 0x02, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x02, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x04, 0x04, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x04, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x08, 0x08, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x08, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x10, 0x10, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x10, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x20, 0x20, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x20, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x40, 0x40, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x40, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )
	PORT_DIPNAME( 0x80, 0x80, DEF_STR( Unknown ) )
	PORT_DIPSETTING(    0x80, DEF_STR( Off ) )
	PORT_DIPSETTING(    0x00, DEF_STR( On ) )

	COINAGE_PORT

	PORT_START
	PORT_BIT( 0x01, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_RIGHT | IPF_8WAY )
	PORT_BIT( 0x02, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_UP | IPF_8WAY )
	PORT_BIT( 0x04, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_LEFT | IPF_8WAY )
	PORT_BIT( 0x08, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_DOWN | IPF_8WAY )
	PORT_BIT( 0x10, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_RIGHT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x20, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_UP | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x40, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_LEFT | IPF_8WAY | IPF_PLAYER2 )
	PORT_BIT( 0x80, IP_ACTIVE_LOW, IPT_JOYSTICKRIGHT_DOWN | IPF_8WAY | IPF_PLAYER2 )
INPUT_PORTS_END



static struct GfxLayout charlayout =
{
	8,8,
	RGN_FRAC(1,1),
	4,
	{ 0, 1, 2, 3 },
	{ 0, 4, 8, 12, 16, 20, 24, 28 },
	{ 0*32, 1*32, 2*32, 3*32, 4*32, 5*32, 6*32, 7*32 },
	32*8
};
static struct GfxLayout spritelayout =
{
	16,16,
	RGN_FRAC(1,1),
	4,
	{ 0, 1, 2, 3 },
	{ 0, 4, 8, 12, 16, 20, 24, 28,
			32, 36, 40, 44, 48, 52, 56, 60 },
	{ 0*64, 1*64, 2*64, 3*64, 4*64, 5*64, 6*64, 7*64,
			8*64, 9*64, 10*64, 11*64, 12*64, 13*64, 14*64, 15*64 },
	128*8
};



static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ REGION_GFX1, 0, &charlayout,       0, 64 },
	{ REGION_GFX2, 0, &spritelayout, 64*16, 32*2 },
	{ -1 } /* end of array */
};



static struct SN76496interface sn76496_interface =
{
	4,	/* 4 chips */
	{ 4000000, 4000000, 4000000, 4000000 },	/* 4 MHz? */
	{ 25, 25, 25, 25 }
};



static MACHINE_DRIVER_START( docastle )

	/* basic machine hardware */
	MDRV_CPU_ADD(Z80, 4000000)	/* 4 MHz */
	MDRV_CPU_MEMORY(docastle_readmem,docastle_writemem)
	MDRV_CPU_VBLANK_INT(irq0_line_hold,1)

	MDRV_CPU_ADD(Z80, 4000000)	/* 4 MHz */
	MDRV_CPU_MEMORY(docastle_readmem2,docastle_writemem2)
	MDRV_CPU_VBLANK_INT(irq0_line_hold,8)

	MDRV_CPU_ADD(Z80, 4000000)	/* 4 MHz */
	MDRV_CPU_MEMORY(docastle_readmem3,docastle_writemem3)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(32*8, 32*8)
	MDRV_VISIBLE_AREA(1*8, 31*8-1, 4*8, 28*8-1)
	MDRV_GFXDECODE(gfxdecodeinfo)
	MDRV_PALETTE_LENGTH(258)
	MDRV_COLORTABLE_LENGTH(64*16+2*32*16)

	MDRV_PALETTE_INIT(docastle)
	MDRV_VIDEO_START(docastle)
	MDRV_VIDEO_UPDATE(docastle)

	/* sound hardware */
	MDRV_SOUND_ADD(SN76496, sn76496_interface)
MACHINE_DRIVER_END

static MACHINE_DRIVER_START( dorunrun )

	/* basic machine hardware */
	MDRV_CPU_ADD(Z80, 4000000)	/* 4 MHz */
	MDRV_CPU_MEMORY(dorunrun_readmem,dorunrun_writemem)
	MDRV_CPU_VBLANK_INT(irq0_line_hold,1)

	MDRV_CPU_ADD(Z80, 4000000)	/* 4 MHz */
	MDRV_CPU_MEMORY(dorunrun_readmem2,dorunrun_writemem2)
	MDRV_CPU_VBLANK_INT(irq0_line_hold,8)

	MDRV_CPU_ADD(Z80, 4000000)	/* 4 MHz */
	MDRV_CPU_MEMORY(docastle_readmem3,docastle_writemem3)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(32*8, 32*8)
	MDRV_VISIBLE_AREA(1*8, 31*8-1, 4*8, 28*8-1)
	MDRV_GFXDECODE(gfxdecodeinfo)
	MDRV_PALETTE_LENGTH(258)
	MDRV_COLORTABLE_LENGTH(64*16+2*32*16)

	MDRV_PALETTE_INIT(dorunrun)
	MDRV_VIDEO_START(docastle)
	MDRV_VIDEO_UPDATE(docastle)

	/* sound hardware */
	MDRV_SOUND_ADD(SN76496, sn76496_interface)
MACHINE_DRIVER_END

static MACHINE_DRIVER_START( idsoccer )

	/* basic machine hardware */
	MDRV_CPU_ADD(Z80, 4000000)	/* 4 MHz */
	MDRV_CPU_MEMORY(idsoccer_readmem,idsoccer_writemem)
	MDRV_CPU_VBLANK_INT(irq0_line_hold,1)

	MDRV_CPU_ADD(Z80, 4000000)	/* 4 MHz */
	MDRV_CPU_MEMORY(idsoccer_readmem2,docastle_writemem2)
	MDRV_CPU_VBLANK_INT(irq0_line_hold,8)

	MDRV_CPU_ADD(Z80, 4000000)	/* 4 MHz */
	MDRV_CPU_MEMORY(docastle_readmem3,docastle_writemem3)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(32*8, 32*8)
	MDRV_VISIBLE_AREA(1*8, 31*8-1, 4*8, 28*8-1)
	MDRV_GFXDECODE(gfxdecodeinfo)
	MDRV_PALETTE_LENGTH(258)
	MDRV_COLORTABLE_LENGTH(64*16+2*32*16)

	MDRV_PALETTE_INIT(dorunrun)
	MDRV_VIDEO_START(docastle)
	MDRV_VIDEO_UPDATE(docastle)

	/* sound hardware */
	MDRV_SOUND_ADD(SN76496, sn76496_interface)
	/* also an MSM5205 */
MACHINE_DRIVER_END



/***************************************************************************

  Game driver(s)

***************************************************************************/

ROM_START( docastle )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "01p_a1.bin",   0x0000, 0x2000, 0x17c6fc24 )
	ROM_LOAD( "01n_a2.bin",   0x2000, 0x2000, 0x1d2fc7f4 )
	ROM_LOAD( "01l_a3.bin",   0x4000, 0x2000, 0x71a70ba9 )
	ROM_LOAD( "01k_a4.bin",   0x6000, 0x2000, 0x479a745e )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )
	ROM_LOAD( "07n_a0.bin",   0x0000, 0x4000, 0xf23b5cdb )

	ROM_REGION( 0x10000, REGION_CPU3, 0 )
	ROM_LOAD( "01d.bin",      0x0000, 0x0200, 0x2747ca77 )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "03a_a5.bin",   0x0000, 0x4000, 0x0636b8f4 )

	ROM_REGION( 0x8000, REGION_GFX2, ROMREGION_DISPOSE )
	ROM_LOAD( "04m_a6.bin",   0x0000, 0x2000, 0x3bbc9b26 )
	ROM_LOAD( "04l_a7.bin",   0x2000, 0x2000, 0x3dfaa9d1 )
	ROM_LOAD( "04j_a8.bin",   0x4000, 0x2000, 0x9afb16e9 )
	ROM_LOAD( "04h_a9.bin",   0x6000, 0x2000, 0xaf24bce0 )

	ROM_REGION( 0x0200, REGION_PROMS, 0 )
	ROM_LOAD( "09c.bin",      0x0000, 0x0200, 0x066f52bc ) /* color prom */
ROM_END

ROM_START( docastl2 )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "a1",           0x0000, 0x2000, 0x0d81fafc )
	ROM_LOAD( "a2",           0x2000, 0x2000, 0xa13dc4ac )
	ROM_LOAD( "a3",           0x4000, 0x2000, 0xa1f04ffb )
	ROM_LOAD( "a4",           0x6000, 0x2000, 0x1fb14aa6 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )
	ROM_LOAD( "a10",          0x0000, 0x4000, 0x45f7f69b )

	ROM_REGION( 0x10000, REGION_CPU3, 0 )
	ROM_LOAD( "01d.bin",      0x0000, 0x0200, 0x2747ca77 )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "03a_a5.bin",   0x0000, 0x4000, 0x0636b8f4 )

	ROM_REGION( 0x8000, REGION_GFX2, ROMREGION_DISPOSE )
	ROM_LOAD( "04m_a6.bin",   0x0000, 0x2000, 0x3bbc9b26 )
	ROM_LOAD( "04l_a7.bin",   0x2000, 0x2000, 0x3dfaa9d1 )
	ROM_LOAD( "04j_a8.bin",   0x4000, 0x2000, 0x9afb16e9 )
	ROM_LOAD( "04h_a9.bin",   0x6000, 0x2000, 0xaf24bce0 )

	ROM_REGION( 0x0200, REGION_PROMS, 0 )
	ROM_LOAD( "09c.bin",      0x0000, 0x0200, 0x066f52bc ) /* color prom */
ROM_END

ROM_START( docastlo )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "c1.bin", 	0x0000, 0x2000, 0xc9ce96ab )
	ROM_LOAD( "c2.bin",     0x2000, 0x2000, 0x42b28369 )
	ROM_LOAD( "c3.bin",     0x4000, 0x2000, 0xc8c13124 )
	ROM_LOAD( "c4.bin",     0x6000, 0x2000, 0x7ca78471 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )
	ROM_LOAD( "dorev10.bin",  0x0000, 0x4000, 0x4b1925e3 )

	ROM_REGION( 0x10000, REGION_CPU3, 0 )
	ROM_LOAD( "01d.bin",      0x0000, 0x0200, 0x2747ca77 )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "03a_a5.bin",   0x0000, 0x4000, 0x0636b8f4 )

	ROM_REGION( 0x8000, REGION_GFX2, ROMREGION_DISPOSE )
	ROM_LOAD( "dorev6.bin",   0x0000, 0x2000, 0x9e335bf8 )
	ROM_LOAD( "dorev7.bin",   0x2000, 0x2000, 0xf5d5701d )
	ROM_LOAD( "dorev8.bin",   0x4000, 0x2000, 0x7143ca68 )
	ROM_LOAD( "dorev9.bin",   0x6000, 0x2000, 0x893fc004 )

	ROM_REGION( 0x0200, REGION_PROMS, 0 )
	/* which prom? this set has the same gfx as douni so i'm using that prom */
//	ROM_LOAD( "09c.bin",      0x0000, 0x0200, 0x066f52bc ) /* color prom */
	ROM_LOAD( "dorevc9.bin",  0x0000, 0x0200, 0x96624ebe ) /* color prom */
ROM_END

ROM_START( douni )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "dorev1.bin",   0x0000, 0x2000, 0x1e2cbb3c )
	ROM_LOAD( "dorev2.bin",   0x2000, 0x2000, 0x18418f83 )
	ROM_LOAD( "dorev3.bin",   0x4000, 0x2000, 0x7b9e2061 )
	ROM_LOAD( "dorev4.bin",   0x6000, 0x2000, 0xe013954d )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )
	ROM_LOAD( "dorev10.bin",  0x0000, 0x4000, 0x4b1925e3 )

	ROM_REGION( 0x10000, REGION_CPU3, 0 )
	ROM_LOAD( "01d.bin",      0x0000, 0x0200, 0x2747ca77 )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "03a_a5.bin",   0x0000, 0x4000, 0x0636b8f4 )

	ROM_REGION( 0x8000, REGION_GFX2, ROMREGION_DISPOSE )
	ROM_LOAD( "dorev6.bin",   0x0000, 0x2000, 0x9e335bf8 )
	ROM_LOAD( "dorev7.bin",   0x2000, 0x2000, 0xf5d5701d )
	ROM_LOAD( "dorev8.bin",   0x4000, 0x2000, 0x7143ca68 )
	ROM_LOAD( "dorev9.bin",   0x6000, 0x2000, 0x893fc004 )

	ROM_REGION( 0x0200, REGION_PROMS, 0 )
	ROM_LOAD( "dorevc9.bin",  0x0000, 0x0200, 0x96624ebe ) /* color prom */
ROM_END

ROM_START( dorunruc )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "rev-0-1.p1",   0x0000, 0x2000, 0x49906ebd )
	ROM_LOAD( "rev-0-2.n1",   0x2000, 0x2000, 0xdbe3e7db )
	ROM_LOAD( "rev-0-3.l1",   0x4000, 0x2000, 0xe9b8181a )
	ROM_LOAD( "rev-0-4.k1",   0x6000, 0x2000, 0xa63d0b89 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )
	ROM_LOAD( "rev-0-2.n7",   0x0000, 0x4000, 0x6dac2fa3 )

	ROM_REGION( 0x10000, REGION_CPU3, 0 )
	ROM_LOAD( "bprom2.bin",   0x0200, 0x0200, 0x2747ca77 )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "rev-0-5.a3",   0x0000, 0x4000, 0xe20795b7 )

	ROM_REGION( 0x8000, REGION_GFX2, ROMREGION_DISPOSE )
	ROM_LOAD( "2764.m4",      0x0000, 0x2000, 0x4bb231a0 )
	ROM_LOAD( "2764.l4",      0x2000, 0x2000, 0x0c08508a )
	ROM_LOAD( "2764.j4",      0x4000, 0x2000, 0x79287039 )
	ROM_LOAD( "2764.h4",      0x6000, 0x2000, 0x523aa999 )

	ROM_REGION( 0x0100, REGION_PROMS, 0 )
	ROM_LOAD( "dorunrun.clr", 0x0000, 0x0100, 0xd5bab5d5 )
ROM_END

ROM_START( dorunrun )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "2764.p1",      0x0000, 0x2000, 0x95c86f8e )
	ROM_LOAD( "2764.l1",      0x4000, 0x2000, 0xe9a65ba7 )
	ROM_LOAD( "2764.k1",      0x6000, 0x2000, 0xb1195d3d )
	ROM_LOAD( "2764.n1",      0x8000, 0x2000, 0x6a8160d1 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )
	ROM_LOAD( "27128.p7",     0x0000, 0x4000, 0x8b06d461 )

	ROM_REGION( 0x10000, REGION_CPU3, 0 )
	ROM_LOAD( "bprom2.bin",   0x0200, 0x0200, 0x2747ca77 )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "27128.a3",     0x0000, 0x4000, 0x4be96dcf )

	ROM_REGION( 0x8000, REGION_GFX2, ROMREGION_DISPOSE )
	ROM_LOAD( "2764.m4",      0x0000, 0x2000, 0x4bb231a0 )
	ROM_LOAD( "2764.l4",      0x2000, 0x2000, 0x0c08508a )
	ROM_LOAD( "2764.j4",      0x4000, 0x2000, 0x79287039 )
	ROM_LOAD( "2764.h4",      0x6000, 0x2000, 0x523aa999 )

	ROM_REGION( 0x0100, REGION_PROMS, 0 )
	ROM_LOAD( "dorunrun.clr", 0x0000, 0x0100, 0xd5bab5d5 )
ROM_END

ROM_START( dorunru2 )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "p1",           0x0000, 0x2000, 0x12a99365 )
	ROM_LOAD( "l1",           0x4000, 0x2000, 0x38609287 )
	ROM_LOAD( "k1",           0x6000, 0x2000, 0x099aaf54 )
	ROM_LOAD( "n1",           0x8000, 0x2000, 0x4f8fcbae )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )
	ROM_LOAD( "27128.p7",     0x0000, 0x4000, 0x8b06d461 )

	ROM_REGION( 0x10000, REGION_CPU3, 0 )
	ROM_LOAD( "bprom2.bin",   0x0200, 0x0200, 0x2747ca77 )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "27128.a3",     0x0000, 0x4000, 0x4be96dcf )

	ROM_REGION( 0x8000, REGION_GFX2, ROMREGION_DISPOSE )
	ROM_LOAD( "2764.m4",      0x0000, 0x2000, 0x4bb231a0 )
	ROM_LOAD( "2764.l4",      0x2000, 0x2000, 0x0c08508a )
	ROM_LOAD( "2764.j4",      0x4000, 0x2000, 0x79287039 )
	ROM_LOAD( "2764.h4",      0x6000, 0x2000, 0x523aa999 )

	ROM_REGION( 0x0100, REGION_PROMS, 0 )
	ROM_LOAD( "dorunrun.clr", 0x0000, 0x0100, 0xd5bab5d5 )
ROM_END

ROM_START( spiero )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "sp1.bin",      0x0000, 0x2000, 0x08d23e38 )
	ROM_LOAD( "sp3.bin",      0x4000, 0x2000, 0xfaa0c18c )
	ROM_LOAD( "sp4.bin",      0x6000, 0x2000, 0x639b4e5d )
	ROM_LOAD( "sp2.bin",      0x8000, 0x2000, 0x3a29ccb0 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )
	ROM_LOAD( "27128.p7",     0x0000, 0x4000, 0x8b06d461 )

	ROM_REGION( 0x10000, REGION_CPU3, 0 )
	ROM_LOAD( "bprom2.bin",   0x0200, 0x0200, 0x2747ca77 )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "sp5.bin",      0x0000, 0x4000, 0x1b704bb0 )

	ROM_REGION( 0x8000, REGION_GFX2, ROMREGION_DISPOSE )
	ROM_LOAD( "sp6.bin",      0x0000, 0x2000, 0x00f893a7 )
	ROM_LOAD( "sp7.bin",      0x2000, 0x2000, 0x173e5c6a )
	ROM_LOAD( "sp8.bin",      0x4000, 0x2000, 0x2e66525a )
	ROM_LOAD( "sp9.bin",      0x6000, 0x2000, 0x9c571525 )

	ROM_REGION( 0x0200, REGION_PROMS, 0 )
	ROM_LOAD( "bprom1.bin",   0x0000, 0x0200, 0xfc1b66ff ) /* color prom */
ROM_END

ROM_START( dowild )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "w1",           0x0000, 0x2000, 0x097de78b )
	ROM_LOAD( "w3",           0x4000, 0x2000, 0xfc6a1cbb )
	ROM_LOAD( "w4",           0x6000, 0x2000, 0x8aac1d30 )
	ROM_LOAD( "w2",           0x8000, 0x2000, 0x0914ab69 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )
	ROM_LOAD( "w10",          0x0000, 0x4000, 0xd1f37fba )

	ROM_REGION( 0x10000, REGION_CPU3, 0 )
	ROM_LOAD( "01d.bin",      0x0000, 0x0200, 0 )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "w5",           0x0000, 0x4000, 0xb294b151 )

	ROM_REGION( 0x8000, REGION_GFX2, ROMREGION_DISPOSE )
	ROM_LOAD( "w6",           0x0000, 0x2000, 0x57e0208b )
	ROM_LOAD( "w7",           0x2000, 0x2000, 0x5001a6f7 )
	ROM_LOAD( "w8",           0x4000, 0x2000, 0xec503251 )
	ROM_LOAD( "w9",           0x6000, 0x2000, 0xaf7bd7eb )

	ROM_REGION( 0x0100, REGION_PROMS, 0 )
	ROM_LOAD( "dowild.clr",   0x0000, 0x0100, 0xa703dea5 )
ROM_END

ROM_START( jjack )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "j1.bin",       0x0000, 0x2000, 0x87f29bd2 )
	ROM_LOAD( "j3.bin",       0x4000, 0x2000, 0x35b0517e )
	ROM_LOAD( "j4.bin",       0x6000, 0x2000, 0x35bb316a )
	ROM_LOAD( "j2.bin",       0x8000, 0x2000, 0xdec52e80 )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )
	ROM_LOAD( "j0.bin",       0x0000, 0x4000, 0xab042f04 )

	ROM_REGION( 0x10000, REGION_CPU3, 0 )
	ROM_LOAD( "bprom2.bin",   0x0200, 0x0200, 0x2747ca77 )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "j5.bin",       0x0000, 0x4000, 0x75038ff9 )

	ROM_REGION( 0x8000, REGION_GFX2, ROMREGION_DISPOSE )
	ROM_LOAD( "j6.bin",       0x0000, 0x2000, 0x5937bd7b )
	ROM_LOAD( "j7.bin",       0x2000, 0x2000, 0xcf8ae8e7 )
	ROM_LOAD( "j8.bin",       0x4000, 0x2000, 0x84f6fc8c )
	ROM_LOAD( "j9.bin",       0x6000, 0x2000, 0x3f9bb09f )

	ROM_REGION( 0x0200, REGION_PROMS, 0 )
	ROM_LOAD( "bprom1.bin",   0x0000, 0x0200, 0x2f0955f2 ) /* color prom */
ROM_END

ROM_START( kickridr )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "k1",           0x0000, 0x2000, 0xdfdd1ab4 )
	ROM_LOAD( "k3",           0x4000, 0x2000, 0x412244da )
	ROM_LOAD( "k4",           0x6000, 0x2000, 0xa67dd2ec )
	ROM_LOAD( "k2",           0x8000, 0x2000, 0xe193fb5c )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )
	ROM_LOAD( "k10",          0x0000, 0x4000, 0x6843dbc0 )

	ROM_REGION( 0x10000, REGION_CPU3, 0 )
	ROM_LOAD( "01d.bin",      0x0000, 0x0200, 0 )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "k5",           0x0000, 0x4000, 0x3f7d7e49 )

	ROM_REGION( 0x8000, REGION_GFX2, ROMREGION_DISPOSE )
	ROM_LOAD( "k6",           0x0000, 0x2000, 0x94252ed3 )
	ROM_LOAD( "k7",           0x2000, 0x2000, 0x7ef2420e )
	ROM_LOAD( "k8",           0x4000, 0x2000, 0x29bed201 )
	ROM_LOAD( "k9",           0x6000, 0x2000, 0x847584d3 )

	ROM_REGION( 0x0100, REGION_PROMS, 0 )
	ROM_LOAD( "kickridr.clr", 0x0000, 0x0100, 0x73ec281c )
ROM_END

ROM_START( idsoccer )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "id01",           0x0000, 0x2000, 0xf1c3bf09 )
	ROM_LOAD( "id02",           0x2000, 0x2000, 0x184e6af0 )
	ROM_LOAD( "id03",           0x6000, 0x2000, 0x22524661 )
	ROM_LOAD( "id04",           0x8000, 0x2000, 0xe8cd95fd )

	ROM_REGION( 0x10000, REGION_CPU2, 0 )
	ROM_LOAD( "id10",           0x0000, 0x4000, 0x6c8b2037 )

	ROM_REGION( 0x10000, REGION_CPU3, 0 )
	ROM_LOAD( "id_8p",          0x0000, 0x0200, 0x2747ca77 )

	ROM_REGION( 0x8000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "id05",          0x0000, 0x4000, 0xa57c7a11 )

	ROM_REGION( 0x20000, REGION_GFX2, ROMREGION_DISPOSE )
	ROM_LOAD( "id06",           0x00000, 0x8000, 0xb42a6f4a )
	ROM_LOAD( "id07",           0x08000, 0x8000, 0xfa2b1c77 )
	ROM_LOAD( "id08",           0x10000, 0x8000, 0x5e97eab9 )
	ROM_LOAD( "id09",           0x18000, 0x8000, 0xa2a69223 )

	ROM_REGION( 0x10000, REGION_SOUND1, 0 )
	ROM_LOAD( "is1",            0x0000, 0x4000, 0x9eb76196 )
	ROM_LOAD( "is3",            0x8000, 0x4000, 0x27bebba3 )
	ROM_LOAD( "is4",            0xc000, 0x4000, 0xdd5ffaa2 )

	ROM_REGION( 0x0200, REGION_PROMS, 0 )
	ROM_LOAD( "id_3d.clr",   0x0000, 0x0200, 0xa433ff62 )
ROM_END


GAME( 1983, docastle, 0,        docastle, docastle, 0, ROT270, "Universal", "Mr. Do's Castle (set 1)" )
GAME( 1983, docastl2, docastle, docastle, docastle, 0, ROT270, "Universal", "Mr. Do's Castle (set 2)" )
GAME( 1983, docastlo, docastle, docastle, docastle, 0, ROT270, "Universal", "Mr. Do's Castle (older)" )
GAME( 1983, douni,    docastle, docastle, docastle, 0, ROT270, "Universal", "Mr. Do vs. Unicorns" )
GAMEX(1984, dorunrun, 0,        dorunrun, dorunrun, 0, ROT0,   "Universal", "Do! Run Run (set 1)", GAME_NO_COCKTAIL )
GAMEX(1984, dorunru2, dorunrun, dorunrun, dorunrun, 0, ROT0,   "Universal", "Do! Run Run (set 2)", GAME_NO_COCKTAIL )
GAMEX(1984, dorunruc, dorunrun, docastle, dorunrun, 0, ROT0,   "Universal", "Do! Run Run (Do's Castle hardware)", GAME_NO_COCKTAIL )
GAMEX(1987, spiero,   dorunrun, dorunrun, dorunrun, 0, ROT0,   "Universal", "Super Pierrot (Japan)", GAME_NO_COCKTAIL )
GAME( 1984, dowild,   0,        dorunrun, dowild,   0, ROT0,   "Universal", "Mr. Do's Wild Ride" )
GAME( 1984, jjack,    0,        dorunrun, jjack,    0, ROT270, "Universal", "Jumping Jack" )
GAME( 1984, kickridr, 0,        dorunrun, kickridr, 0, ROT0,   "Universal", "Kick Rider" )
GAMEX(1985, idsoccer, 0,        idsoccer, idsoccer, 0, ROT0,   "Universal", "Indoor Soccer", GAME_IMPERFECT_SOUND )
