#pragma option push -b -a8 -pc -A- /*P_O_Push*/
//----------------------------------------------------------------------------
// Systems Management Server WBEM SDK
// 
//   This file is automatically generated by traversing all class ojects in
//   a WBEM namespace.
// 
// 
// Generation information :
// 
// Date:           03/12/1999    (MM/DD/YYYYY)  (Friday)
// Time:           09:53:37.0217 (HH:MM:SS:MMMM)
// WBEM Namespace: root\sms\site_egh
// 
// 
// Release notes: 
// 
//   This file includes useful symbols for accessing WBEM objects. All symbols  
//   are partitioned in separate namespaces.  The primary C++ namespace is      
//   SMSSDK.  Each WBEM class name then defines another partition of the C++    
//   namespace.  Then one more nested C++ namespace is created for the property.
//   For interesting enumeration's and bit-fields, a C++ enumeration is created 
//   in the form tagBitField_ClassName_PropertyName or                          
//   tagEnumeration_ClassName_PropertyName.  Finally all published value        
//   constraints are placed in the C++ enumeration.  Each constraint is prefixed
//   with BIT_ or ENUM_ for constraints that are bit-fields or enumeration's    
//   respectively.                                                              
// 
// 
// Copyright (c)1997-1999 Microsoft Corporation, All Rights Reserved
//----------------------------------------------------------------------------
// 
// Example Usage : 
// 

#if 0
    // Explicitly reference the symbol                                                 
    unsigned long ulValue = SMSSDK::SMS_Advertisement::AdvertFlags::BIT_ONSLOWNET;     
                                                                                       
    // Reference the symbol after promoting SMSSDK                                     
    {                                                                                  
        using namespace SMSSDK;                                                        
        unsigned long ulValue = SMS_Advertisement::AdvertFlags::BIT_ONSLOWNET;         
    }                                                                                  
                                                                                       
    // Reference the symbol after promoting SMSSDK::SMS_Advertisement                  
    {                                                                                  
        using namespace SMSSDK::SMS_Advertisement;                                     
        unsigned long ulValue = AdvertFlags::BIT_ONSLOWNET;                            
    }                                                                                  
                                                                                       
    // Reference after promoting SMSSDK::SMS_Advertisement::AdvertFlags                
    {                                                                                  
        using namespace SMSSDK::SMS_Advertisement::AdvertFlags;                        
        unsigned long ulValue = BIT_ONSLOWNET;                                         
    }                                                                                  
#endif



#if !defined(__SMS_SDK_NAMESPACE_ENUMS)
#define      __SMS_SDK_NAMESPACE_ENUMS
#pragma once



#if defined(_USE_AUTOSYMBOLS)

   #include<comdef.h>

   #if defined(_EXPORT_AUTO_SYMBOLS) && defined(_INIT_AUTOSYMBOLS)
       #define AUTOSYM_Export __declspec(dllexport)
   #elif defined(_EXPORT_AUTO_SYMBOLS)
       #define AUTOSYM_Export __declspec(dllimport)
   #else
       #define AUTOSYM_Export
   #endif

   #if defined(_INIT_AUTOSYMBOLS)

       #define DEFINE_CLASS(name)\
               extern AUTOSYM_Export LPCWSTR CLASS_##name = L#name

       #define DEFINE_PROP(name)\
               extern AUTOSYM_Export LPCWSTR PROP_##name = L#name

       #define DEFINE_METHOD(name)\
               extern AUTOSYM_Export LPCWSTR METHOD_##name = L#name

       #define DEFINE_PARAM(name)\
               extern AUTOSYM_Export LPCWSTR PARAM_##name = L#name

       #define DEFINE_CONTEXTVALUE(name)\
               extern AUTOSYM_Export LPCWSTR CONTEXTVALUE_##name = L#name
   #else

       #define DEFINE_CLASS(name)\
               extern AUTOSYM_Export LPCWSTR CLASS_##name

       #define DEFINE_PROP(name)\
               extern AUTOSYM_Export LPCWSTR PROP_##name

       #define DEFINE_METHOD(name)\
               extern AUTOSYM_Export LPCWSTR METHOD_##name

       #define DEFINE_PARAM(name)\
               extern AUTOSYM_Export LPCWSTR PARAM_##name

       #define DEFINE_CONTEXTVALUE(name)\
               extern AUTOSYM_Export LPCWSTR CONTEXTVALUE_##name
   #endif

#else                                                                      

   #define DEFINE_CLASS(name)
   #define DEFINE_PROP(name)
   #define DEFINE_METHOD(name)
   #define DEFINE_PARAM(name)
   #define DEFINE_CONTEXTVALUE(name)

#endif

namespace SMSSDK
{
//----------------------------------------------------------------------------
// Context Values : 
// 
// 
// 
DEFINE_CONTEXTVALUE(ContextHandle);
DEFINE_CONTEXTVALUE(LocaleID);
DEFINE_CONTEXTVALUE(SessionHandle);
DEFINE_CONTEXTVALUE(IMapSessionHandle);
DEFINE_CONTEXTVALUE(LimitToCollectionIDs);
DEFINE_CONTEXTVALUE(InstanceCount);
DEFINE_CONTEXTVALUE(MachineName);
DEFINE_CONTEXTVALUE(ApplicationName);
DEFINE_CONTEXTVALUE(QueryQualifiers);

//----------------------------------------------------------------------------
// SMS_ProviderLocation : 
// 
// 
// 
DEFINE_CLASS(SMS_ProviderLocation);
namespace SMS_ProviderLocation
{
	DEFINE_PROP(SiteCode);
	DEFINE_PROP(Machine);
	DEFINE_PROP(NamespacePath);
	DEFINE_PROP(ProviderForLocalSite);
} // namespace 

//----------------------------------------------------------------------------
// SMS_Advertisement : 
// 
// 
// 
DEFINE_CLASS(SMS_Advertisement);
namespace SMS_Advertisement
{
    DEFINE_PROP(ActionInProgress);
    
    namespace ActionInProgress
    {

        enum tagEnumeration_SMS_Advertisement_ActionInProgress
        {
            ENUM_NONE                                     = 0L,
            ENUM_UPDATE                                   = 1L,
            ENUM_ADD                                      = 2L,
            ENUM_DELETE                                   = 3L
        };
    
    } // namespace ActionInProgress


    DEFINE_PROP(AdvertFlags);
    
    namespace AdvertFlags
    {

        enum tagBitField_SMS_Advertisement_AdvertFlags
        {
            BIT_IMMEDIATE                                = 0x00000020,
            BIT_ONSYSTEMSTARTUP                          = 0x00000100,
            BIT_ONUSERLOGON                              = 0x00000200,
            BIT_ONUSERLOGOFF                             = 0x00000400,
            BIT_NO_DISPLAY                               = 0x02000000,
            BIT_ONSLOWNET                                = 0x04000000
        };
    
    } // namespace AdvertFlags


    DEFINE_PROP(AdvertisementID);
    DEFINE_PROP(AdvertisementName);
    DEFINE_PROP(AssignedSchedule);
    DEFINE_PROP(AssignedScheduleEnabled);
    DEFINE_PROP(AssignedScheduleIsGMT);
    DEFINE_PROP(CollectionID);
    DEFINE_PROP(Comment);
    DEFINE_PROP(ExpirationTime);
    DEFINE_PROP(ExpirationTimeEnabled);
    DEFINE_PROP(ExpirationTimeIsGMT);
    DEFINE_PROP(HierarchyPath);
    DEFINE_PROP(IncludeSubCollection);
    DEFINE_PROP(PackageID);
    DEFINE_PROP(PresentTime);
    DEFINE_PROP(PresentTimeEnabled);
    DEFINE_PROP(PresentTimeIsGMT);
    DEFINE_PROP(Priority);
    
    namespace Priority
    {

        enum tagEnumeration_SMS_Advertisement_Priority
        {
            ENUM_HIGH                                     = 1L,
            ENUM_NORMAL                                   = 2L,
            ENUM_LOW                                      = 3L
        };
    
    } // namespace Priority


    DEFINE_PROP(ProgramName);
    DEFINE_PROP(SourceSite);
    DEFINE_PROP(TimeFlags);
    
    namespace TimeFlags
    {

        enum tagBitField_SMS_Advertisement_TimeFlags
        {
            BIT_ENABLE_PRESENT                           = 0x00000001,
            BIT_ENABLE_EXPIRATION                        = 0x00000002,
            BIT_ENABLE_AVAILABLE                         = 0x00000004,
            BIT_ENABLE_UNAVAILABLE                       = 0x00000008,
            BIT_ENABLE_MANDATORY                         = 0x00000010,
            BIT_GMT_PRESENT                              = 0x00000100,
            BIT_GMT_EXPIRATION                           = 0x00000200,
            BIT_GMT_AVAILABLE                            = 0x00000400,
            BIT_GMT_UNAVAILABLE                          = 0x00000800,
            BIT_GMT_MANDATORY                            = 0x00001000
        };
    
    } // namespace TimeFlags



} // namespace SMS_Advertisement


//----------------------------------------------------------------------------
// SMS_AdvertisementStatusRootSummarizer : 
// 
// 
// 
DEFINE_CLASS(SMS_AdvertisementStatusRootSummarizer);
namespace SMS_AdvertisementStatusRootSummarizer
{
    DEFINE_PROP(AdvertisementID);
    DEFINE_PROP(AdvertisementName);
    DEFINE_PROP(AdvertisementsFailed);
    DEFINE_PROP(AdvertisementsReceived);
    DEFINE_PROP(CollectionID);
    DEFINE_PROP(CollectionName);
    DEFINE_PROP(DisplaySchedule);
    DEFINE_PROP(ExpirationTime);
    DEFINE_PROP(PackageID);
    DEFINE_PROP(PackageLanguage);
    DEFINE_PROP(PackageManufacturer);
    DEFINE_PROP(PackageName);
    DEFINE_PROP(PackageVersion);
    DEFINE_PROP(PresentTime);
    DEFINE_PROP(ProgramName);
    DEFINE_PROP(ProgramsFailed);
    DEFINE_PROP(ProgramsStarted);
    DEFINE_PROP(ProgramsSucceeded);
    DEFINE_PROP(SourceSite);
    DEFINE_PROP(TimeEnableFlag);

} // namespace SMS_AdvertisementStatusRootSummarizer


//----------------------------------------------------------------------------
// SMS_AdvertisementStatusSummarizer : 
// 
// 
// 
DEFINE_CLASS(SMS_AdvertisementStatusSummarizer);
namespace SMS_AdvertisementStatusSummarizer
{
    DEFINE_PROP(AdvertisementID);
    DEFINE_PROP(AdvertisementsFailed);
    DEFINE_PROP(AdvertisementsReceived);
    DEFINE_PROP(DisplaySchedule);
    DEFINE_PROP(LastUpdate);
    DEFINE_PROP(ProgramsFailed);
    DEFINE_PROP(ProgramsStarted);
    DEFINE_PROP(ProgramsSucceeded);
    DEFINE_PROP(SiteCode);

} // namespace SMS_AdvertisementStatusSummarizer


//----------------------------------------------------------------------------
// SMS_AdvertToSourceSite_a : 
// 
// 
// 
DEFINE_CLASS(SMS_AdvertToSourceSite_a);
namespace SMS_AdvertToSourceSite_a
{
    DEFINE_PROP(advertSourceSite);
    DEFINE_PROP(ownedAdvert);

} // namespace SMS_AdvertToSourceSite_a


//----------------------------------------------------------------------------
// SMS_BaseAssociation : 
// 
// 
// 
DEFINE_CLASS(SMS_BaseAssociation);
namespace SMS_BaseAssociation
{

} // namespace SMS_BaseAssociation


//----------------------------------------------------------------------------
// SMS_BaseClass : 
// 
// 
// 
DEFINE_CLASS(SMS_BaseClass);
namespace SMS_BaseClass
{

} // namespace SMS_BaseClass


//----------------------------------------------------------------------------
// SMS_Client_Reg_MultiString_List : 
// 
// 
// 
DEFINE_CLASS(SMS_Client_Reg_MultiString_List);
namespace SMS_Client_Reg_MultiString_List
{
    DEFINE_PROP(ItemType);
    DEFINE_PROP(KeyPath);
    DEFINE_PROP(ValueName);
    DEFINE_PROP(ValueStrings);

} // namespace SMS_Client_Reg_MultiString_List


//----------------------------------------------------------------------------
// SMS_Collection : 
// 
// 
// 
DEFINE_CLASS(SMS_Collection);
namespace SMS_Collection
{
    DEFINE_PROP(CollectionID);
    DEFINE_PROP(CollectionRules);
    DEFINE_PROP(Comment);
    DEFINE_PROP(CurrentStatus);
    
    namespace CurrentStatus
    {

        enum tagEnumeration_SMS_Collection_CurrentStatus
        {
            ENUM_NONE                                     = 0L,
            ENUM_READY                                    = 1L,
            ENUM_REFRESHING                               = 2L,
            ENUM_SAVING                                   = 3L,
            ENUM_EVALUATING                               = 4L,
            ENUM_AWAITING_REFRESH                         = 5L,
            ENUM_DELETING                                 = 6L,
            ENUM_APPENDING_MEMBER                         = 7L,
            ENUM_QUERYING                                 = 8L
        };
    
    } // namespace CurrentStatus


    DEFINE_PROP(LastChangeTime);
    DEFINE_PROP(LastRefreshTime);
    DEFINE_PROP(MemberClassName);
    DEFINE_PROP(Name);
    DEFINE_PROP(OwnedByThisSite);
    DEFINE_PROP(RefreshSchedule);
    DEFINE_PROP(RefreshType);
    
    namespace RefreshType
    {

        enum tagEnumeration_SMS_Collection_RefreshType
        {
            ENUM_MANUAL                                   = 1L,
            ENUM_PERIODIC                                 = 2L
        };
    
    } // namespace RefreshType


    DEFINE_PROP(ReplicateToSubSites);
    DEFINE_METHOD(AddMembershipRule);
    
    namespace AddMembershipRule
    {
        
        namespace In
        {
            DEFINE_PARAM(collectionRule);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(QueryID);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace AddMembershipRule


    DEFINE_METHOD(DeleteMembershipRule);
    
    namespace DeleteMembershipRule
    {
        
        namespace In
        {
            DEFINE_PARAM(collectionRule);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace DeleteMembershipRule


    DEFINE_METHOD(AddMembershipRules);
    
    namespace AddMembershipRules
    {
        
        namespace In
        {
            DEFINE_PARAM(collectionRules);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(QueryIDs);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace AddMembershipRules


    DEFINE_METHOD(DeleteMembershipRules);
    
    namespace DeleteMembershipRules
    {
        
        namespace In
        {
            DEFINE_PARAM(collectionRules);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace DeleteMembershipRules


    DEFINE_METHOD(RequestRefresh);
    
    namespace RequestRefresh
    {
        
        namespace In
        {
            DEFINE_PARAM(includesubcollections);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace RequestRefresh


    DEFINE_METHOD(DeleteAllMembers);
    
    namespace DeleteAllMembers
    {
        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace DeleteAllMembers


    DEFINE_METHOD(VerifyNoLoops);
    
    namespace VerifyNoLoops
    {
        
        namespace In
        {
            DEFINE_PARAM(parentCollection);
            DEFINE_PARAM(subCollection);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(Result);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace VerifyNoLoops


    DEFINE_METHOD(GetNumResults);
    
    namespace GetNumResults
    {
        
        namespace In
        {
            DEFINE_PARAM(Collection);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(Result);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace GetNumResults


    DEFINE_METHOD(GetTotalNumResults);
    
    namespace GetTotalNumResults
    {
        
        namespace In
        {
            DEFINE_PARAM(Collection);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(Result);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace GetTotalNumResults



} // namespace SMS_Collection


//----------------------------------------------------------------------------
// SMS_CollectionMember : 
// 
// 
// 
DEFINE_CLASS(SMS_CollectionMember);
namespace SMS_CollectionMember
{
    DEFINE_PROP(Domain);
    DEFINE_PROP(IsAssigned);
    DEFINE_PROP(IsClient);
    DEFINE_PROP(IsDirect);
    DEFINE_PROP(Name);
    DEFINE_PROP(ResourceID);
    DEFINE_PROP(ResourceType);
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(SMSID);

} // namespace SMS_CollectionMember


//----------------------------------------------------------------------------
// SMS_CollectionMember_a : 
// 
// 
// 
DEFINE_CLASS(SMS_CollectionMember_a);
namespace SMS_CollectionMember_a
{
    DEFINE_PROP(collection);
    DEFINE_PROP(CollectionID);
    DEFINE_PROP(Domain);
    DEFINE_PROP(IsAssigned);
    DEFINE_PROP(IsClient);
    DEFINE_PROP(IsDirect);
    DEFINE_PROP(Name);
    DEFINE_PROP(resource);
    DEFINE_PROP(ResourceID);
    DEFINE_PROP(ResourceType);
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(SMSID);

} // namespace SMS_CollectionMember_a


//----------------------------------------------------------------------------
// SMS_CollectionRule : 
// 
// 
// 
DEFINE_CLASS(SMS_CollectionRule);
namespace SMS_CollectionRule
{
    DEFINE_PROP(RuleName);

} // namespace SMS_CollectionRule


//----------------------------------------------------------------------------
// SMS_CollectionRuleDirect : 
// 
// 
// 
DEFINE_CLASS(SMS_CollectionRuleDirect);
namespace SMS_CollectionRuleDirect
{
    DEFINE_PROP(ResourceClassName);
    DEFINE_PROP(ResourceID);

} // namespace SMS_CollectionRuleDirect


//----------------------------------------------------------------------------
// SMS_CollectionRuleQuery : 
// 
// 
// 
DEFINE_CLASS(SMS_CollectionRuleQuery);
namespace SMS_CollectionRuleQuery
{
    DEFINE_PROP(LimitToCollectionID);
    DEFINE_PROP(QueryExpression);
    DEFINE_PROP(QueryID);

} // namespace SMS_CollectionRuleQuery


//----------------------------------------------------------------------------
// SMS_CollectionToPkgAdvert_a : 
// 
// 
// 
DEFINE_CLASS(SMS_CollectionToPkgAdvert_a);
namespace SMS_CollectionToPkgAdvert_a
{
    DEFINE_PROP(advert);
    DEFINE_PROP(collection);

} // namespace SMS_CollectionToPkgAdvert_a


//----------------------------------------------------------------------------
// SMS_CollectToSubCollect : 
// 
// 
// 
DEFINE_CLASS(SMS_CollectToSubCollect);
namespace SMS_CollectToSubCollect
{
    DEFINE_PROP(parentCollectionID);
    DEFINE_PROP(subCollectionID);

} // namespace SMS_CollectToSubCollect


//----------------------------------------------------------------------------
// SMS_CollectToSubCollect_a : 
// 
// 
// 
DEFINE_CLASS(SMS_CollectToSubCollect_a);
namespace SMS_CollectToSubCollect_a
{
    DEFINE_PROP(parentCollection);
    DEFINE_PROP(subCollection);

} // namespace SMS_CollectToSubCollect_a


//----------------------------------------------------------------------------
// SMS_ComponentSummarizer : 
// 
// 
// 
DEFINE_CLASS(SMS_ComponentSummarizer);
namespace SMS_ComponentSummarizer
{
    DEFINE_PROP(ComponentName);
    DEFINE_PROP(Errors);
    DEFINE_PROP(Infos);
    DEFINE_PROP(LastContacted);
    DEFINE_PROP(LastStarted);
    DEFINE_PROP(MachineName);
    DEFINE_PROP(NextScheduledTime);
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(State);
    
    namespace State
    {

        enum tagEnumeration_SMS_ComponentSummarizer_State
        {
            ENUM_STOPPED                                  = 0L,
            ENUM_STARTED                                  = 1L,
            ENUM_PAUSED                                   = 2L,
            ENUM_INSTALLING                               = 3L,
            ENUM_RE_INSTALLING                            = 4L,
            ENUM_DE_INSTALLING                            = 5L
        };
    
    } // namespace State


    DEFINE_PROP(Status);
    
    namespace Status
    {

        enum tagEnumeration_SMS_ComponentSummarizer_Status
        {
            ENUM_GREEN                                    = 0L,
            ENUM_YELLOW                                   = 1L,
            ENUM_RED                                      = 2L
        };
    
    } // namespace Status


    DEFINE_PROP(TallyInterval);
    DEFINE_PROP(Type);
    
    namespace Type
    {

        enum tagEnumeration_SMS_ComponentSummarizer_Type
        {
            ENUM_AUTOSTARTING                             = 0L,
            ENUM_SCHEDULED                                = 1L,
            ENUM_MANUAL                                   = 2L
        };
    
    } // namespace Type


    DEFINE_PROP(Warnings);

} // namespace SMS_ComponentSummarizer


//----------------------------------------------------------------------------
// SMS_ConfigData : 
// 
// 
// 
DEFINE_CLASS(SMS_ConfigData);
namespace SMS_ConfigData
{
    DEFINE_PROP(MaxSQLConnections);
    DEFINE_PROP(QueryInstanceBatchCount);

} // namespace SMS_ConfigData


//----------------------------------------------------------------------------
// SMS_ContextMethods : 
// 
// 
// 
DEFINE_CLASS(SMS_ContextMethods);
namespace SMS_ContextMethods
{
    DEFINE_METHOD(GetContextHandle);
    
    namespace GetContextHandle
    {
        
        namespace Out
        {
            DEFINE_PARAM(ContextHandle);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace GetContextHandle


    DEFINE_METHOD(ClearContextHandle);
    
    namespace ClearContextHandle
    {
        
        namespace In
        {
            DEFINE_PARAM(ContextHandle);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace ClearContextHandle



} // namespace SMS_ContextMethods


//----------------------------------------------------------------------------
// SMS_DistributionPoint : 
// 
// 
// 
DEFINE_CLASS(SMS_DistributionPoint);
namespace SMS_DistributionPoint
{
    DEFINE_PROP(LastRefreshTime);
    DEFINE_PROP(PackageID);
    DEFINE_PROP(RefreshNow);
    DEFINE_PROP(ServerNALPath);
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(SiteName);
    DEFINE_PROP(SourceSite);
    DEFINE_PROP(Status);
    
    namespace Status
    {

        enum tagEnumeration_SMS_DistributionPoint_Status
        {
            ENUM_NONE                                     = 0L,
            ENUM_UPDATED                                  = 1L,
            ENUM_ADDED                                    = 2L,
            ENUM_DELETED                                  = 3L
        };
    
    } // namespace Status



} // namespace SMS_DistributionPoint


//----------------------------------------------------------------------------
// SMS_DistributionPointGroup : 
// 
// 
// 
DEFINE_CLASS(SMS_DistributionPointGroup);
namespace SMS_DistributionPointGroup
{
    DEFINE_PROP(arrNALPath);
    DEFINE_PROP(sGroupName);

} // namespace SMS_DistributionPointGroup


//----------------------------------------------------------------------------
// SMS_EmbeddedProperty : 
// 
// 
// 
DEFINE_CLASS(SMS_EmbeddedProperty);
namespace SMS_EmbeddedProperty
{
    DEFINE_PROP(ItemType);
    DEFINE_PROP(PropertyName);
    DEFINE_PROP(Value);
    DEFINE_PROP(Value1);
    DEFINE_PROP(Value2);

} // namespace SMS_EmbeddedProperty


//----------------------------------------------------------------------------
// SMS_EmbeddedPropertyList : 
// 
// 
// 
DEFINE_CLASS(SMS_EmbeddedPropertyList);
namespace SMS_EmbeddedPropertyList
{
    DEFINE_PROP(ItemType);
    DEFINE_PROP(PropertyListName);
    DEFINE_PROP(Values);

} // namespace SMS_EmbeddedPropertyList


//----------------------------------------------------------------------------
// SMS_ExtendedStatus : 
// 
// 
// 
DEFINE_CLASS(SMS_ExtendedStatus);
namespace SMS_ExtendedStatus
{
    DEFINE_PROP(CauseInfo);
    DEFINE_PROP(ErrorCode);
    DEFINE_PROP(File);
    DEFINE_PROP(Line);
    DEFINE_PROP(ObjectInfo);
    DEFINE_PROP(SQLMessage);
    DEFINE_PROP(SQLSeverity);
    DEFINE_PROP(SQLStatus);

} // namespace SMS_ExtendedStatus


//----------------------------------------------------------------------------
// SMS_Group : 
// 
// 
// 
DEFINE_CLASS(SMS_Group);
namespace SMS_Group
{
    DEFINE_PROP(ResourceID);

} // namespace SMS_Group


//----------------------------------------------------------------------------
// SMS_Identification : 
// 
// 
// 
DEFINE_CLASS(SMS_Identification);
namespace SMS_Identification
{
    DEFINE_PROP(LocaleID);
    DEFINE_PROP(ServiceAccountName);
    DEFINE_PROP(SMSBuildNumber);
    DEFINE_PROP(SMSMinBuildNumber);
    DEFINE_PROP(SMSProviderServer);
    DEFINE_PROP(SMSSiteServer);
    DEFINE_PROP(SMSVersion);
    DEFINE_PROP(ThisSiteCode);
    DEFINE_PROP(ThisSiteName);
    DEFINE_METHOD(GetCurrentUser);
    
    namespace GetCurrentUser
    {
        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);
            DEFINE_PARAM(UserName);

        } // namespace Out



    } // namespace GetCurrentUser


    DEFINE_METHOD(GetProviderVersion);
    
    namespace GetProviderVersion
    {
        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);
            DEFINE_PARAM(VersionString);

        } // namespace Out



    } // namespace GetProviderVersion



} // namespace SMS_Identification


//----------------------------------------------------------------------------
// SMS_Legacy_PackageLocations : 
// 
// 
// 
DEFINE_CLASS(SMS_Legacy_PackageLocations);
namespace SMS_Legacy_PackageLocations
{
    DEFINE_PROP(ComponentName);
    DEFINE_PROP(InstanceKey);
    DEFINE_PROP(MachineID);
    DEFINE_PROP(MasterCopyFlag);
    DEFINE_PROP(ObjectKey);
    DEFINE_PROP(PackageKey);
    DEFINE_PROP(ServerName);
    DEFINE_PROP(ShareName);
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(TimeKey);
    DEFINE_PROP(WkstaServerFlag);

} // namespace SMS_Legacy_PackageLocations


//----------------------------------------------------------------------------
// SMS_Legacy_Packages : 
// 
// 
// 
DEFINE_CLASS(SMS_Legacy_Packages);
namespace SMS_Legacy_Packages
{
    DEFINE_PROP(Comments);
    DEFINE_PROP(InventoryFlag);
    DEFINE_PROP(LastUpdateTime);
    DEFINE_PROP(ObjectKey);
    DEFINE_PROP(PackageKey);
    DEFINE_PROP(PackageName);
    DEFINE_PROP(PermissionFlags);
    DEFINE_PROP(ServerFlag);
    DEFINE_PROP(ServerRoot);
    DEFINE_PROP(ServerTransfer);
    DEFINE_PROP(ShareName);
    DEFINE_PROP(TotalConcurrentUses);
    DEFINE_PROP(WkstaRoot);
    DEFINE_PROP(WkstaTransfer);
    DEFINE_PROP(WorkstationFlag);

} // namespace SMS_Legacy_Packages


//----------------------------------------------------------------------------
// SMS_Legacy_ProgramGroupProgramItems : 
// 
// 
// 
DEFINE_CLASS(SMS_Legacy_ProgramGroupProgramItems);
namespace SMS_Legacy_ProgramGroupProgramItems
{
    DEFINE_PROP(ItemKey);
    DEFINE_PROP(ObjectKey);
    DEFINE_PROP(PackageKey);
    DEFINE_PROP(ProgramGroupKey);

} // namespace SMS_Legacy_ProgramGroupProgramItems


//----------------------------------------------------------------------------
// SMS_Legacy_ProgramGroups : 
// 
// 
// 
DEFINE_CLASS(SMS_Legacy_ProgramGroups);
namespace SMS_Legacy_ProgramGroups
{
    DEFINE_PROP(Comment);
    DEFINE_PROP(Name);
    DEFINE_PROP(ObjectKey);
    DEFINE_PROP(ProgramGroupKey);

} // namespace SMS_Legacy_ProgramGroups


//----------------------------------------------------------------------------
// SMS_Legacy_ProgramGroupUserGroups : 
// 
// 
// 
DEFINE_CLASS(SMS_Legacy_ProgramGroupUserGroups);
namespace SMS_Legacy_ProgramGroupUserGroups
{
    DEFINE_PROP(ObjectKey);
    DEFINE_PROP(ProgramGroupKey);
    DEFINE_PROP(UserGroupName);

} // namespace SMS_Legacy_ProgramGroupUserGroups


//----------------------------------------------------------------------------
// SMS_Legacy_ProgramItems : 
// 
// 
// 
DEFINE_CLASS(SMS_Legacy_ProgramItems);
namespace SMS_Legacy_ProgramItems
{
    DEFINE_PROP(CommandLine);
    DEFINE_PROP(ConfigScript);
    DEFINE_PROP(ConversionComment);
    DEFINE_PROP(ConversionFlags);
    DEFINE_PROP(Description);
    DEFINE_PROP(DriveLetter);
    DEFINE_PROP(DriveMethod);
    DEFINE_PROP(ExecutableFlag);
    DEFINE_PROP(Icon);
    DEFINE_PROP(IniFile);
    DEFINE_PROP(ItemKey);
    DEFINE_PROP(ObjectKey);
    DEFINE_PROP(PackageKey);
    DEFINE_PROP(Platforms);
    DEFINE_PROP(RegistryName);
    DEFINE_PROP(RunMinimized);
    DEFINE_PROP(SearchLocal);
    DEFINE_PROP(Win31);
    DEFINE_PROP(WinNT);

} // namespace SMS_Legacy_ProgramItems


//----------------------------------------------------------------------------
// SMS_LegacyClass : 
// 
// 
// 
DEFINE_CLASS(SMS_LegacyClass);
namespace SMS_LegacyClass
{

} // namespace SMS_LegacyClass


//----------------------------------------------------------------------------
// SMS_NAL_Methods : 
// 
// 
// 
DEFINE_CLASS(SMS_NAL_Methods);
namespace SMS_NAL_Methods
{
    DEFINE_METHOD(PackNALPath);
    
    namespace PackNALPath
    {
        
        namespace In
        {
            DEFINE_PARAM(DisplayQualifiers);
            DEFINE_PARAM(NALType);
            DEFINE_PARAM(NetworkConnectionQualifiers);
            DEFINE_PARAM(NetworkOSPath);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(NALPath);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace PackNALPath


    DEFINE_METHOD(UnPackNALPath);
    
    namespace UnPackNALPath
    {
        
        namespace In
        {
            DEFINE_PARAM(NALPath);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(DisplayQualifiers);
            DEFINE_PARAM(NALType);
            DEFINE_PARAM(NetworkConnectionQualifiers);
            DEFINE_PARAM(NetworkOSPath);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace UnPackNALPath



} // namespace SMS_NAL_Methods


//----------------------------------------------------------------------------
// SMS_ObjectToClassPermissions_a : 
// 
// 
// 
DEFINE_CLASS(SMS_ObjectToClassPermissions_a);
namespace SMS_ObjectToClassPermissions_a
{
    DEFINE_PROP(classPermissions);
    DEFINE_PROP(object);

} // namespace SMS_ObjectToClassPermissions_a


//----------------------------------------------------------------------------
// SMS_ObjectToInstancePermissions_a : 
// 
// 
// 
DEFINE_CLASS(SMS_ObjectToInstancePermissions_a);
namespace SMS_ObjectToInstancePermissions_a
{
    DEFINE_PROP(instancePermissions);
    DEFINE_PROP(object);

} // namespace SMS_ObjectToInstancePermissions_a


//----------------------------------------------------------------------------
// SMS_OS_Details : 
// 
// 
// 
DEFINE_CLASS(SMS_OS_Details);
namespace SMS_OS_Details
{
    DEFINE_PROP(MaxVersion);
    DEFINE_PROP(MinVersion);
    DEFINE_PROP(Name);
    DEFINE_PROP(Platform);

} // namespace SMS_OS_Details


//----------------------------------------------------------------------------
// SMS_Package : 
// 
// 
// 
DEFINE_CLASS(SMS_Package);
namespace SMS_Package
{
    DEFINE_PROP(ActionInProgress);
    
    namespace ActionInProgress
    {

        enum tagEnumeration_SMS_Package_ActionInProgress
        {
            ENUM_NONE                                     = 0L,
            ENUM_UPDATE                                   = 1L,
            ENUM_ADD                                      = 2L,
            ENUM_DELETE                                   = 3L
        };
    
    } // namespace ActionInProgress


    DEFINE_PROP(Description);
    DEFINE_PROP(ForcedDisconnectDelay);
    DEFINE_PROP(ForcedDisconnectEnabled);
    DEFINE_PROP(ForcedDisconnectNumRetries);
    DEFINE_PROP(Icon);
    DEFINE_PROP(IconSize);
    DEFINE_PROP(IgnoreAddressSchedule);
    DEFINE_PROP(Language);
    DEFINE_PROP(LastRefreshTime);
    DEFINE_PROP(Manufacturer);
    DEFINE_PROP(MIFFilename);
    DEFINE_PROP(MIFName);
    DEFINE_PROP(MIFPublisher);
    DEFINE_PROP(MIFVersion);
    DEFINE_PROP(Name);
    DEFINE_PROP(PackageID);
    DEFINE_PROP(PkgFlags);
    
    namespace PkgFlags
    {

        enum tagBitField_SMS_Package_PkgFlags
        {
            BIT_USE_SPECIAL_MIF                          = 0x20000000
        };
    
    } // namespace PkgFlags


    DEFINE_PROP(PkgSourceFlag);
    
    namespace PkgSourceFlag
    {

        enum tagEnumeration_SMS_Package_PkgSourceFlag
        {
            ENUM_STORAGE_NEEDS_SPECIFYING                 = 0L,
            ENUM_STORAGE_NO_SOURCE                        = 1L,
            ENUM_STORAGE_DIRECT                           = 2L,
            ENUM_STORAGE_COMPRESS                         = 3L,
            ENUM_STORAGE_LOCAL                            = 4L
        };
    
    } // namespace PkgSourceFlag


    DEFINE_PROP(PkgSourcePath);
    DEFINE_PROP(PreferredAddressType);
    DEFINE_PROP(Priority);
    
    namespace Priority
    {

        enum tagEnumeration_SMS_Package_Priority
        {
            ENUM_HIGH                                     = 1L,
            ENUM_NORMAL                                   = 2L,
            ENUM_LOW                                      = 3L
        };
    
    } // namespace Priority


    DEFINE_PROP(RefreshPkgSourceFlag);
    DEFINE_PROP(RefreshSchedule);
    DEFINE_PROP(ShareName);
    DEFINE_PROP(ShareType);
    
    namespace ShareType
    {

        enum tagEnumeration_SMS_Package_ShareType
        {
            ENUM_SHARE_COMMON                             = 1L,
            ENUM_SHARE_SPECIFIC                           = 2L
        };
    
    } // namespace ShareType


    DEFINE_PROP(SourceDate);
    DEFINE_PROP(SourceSite);
    DEFINE_PROP(SourceVersion);
    DEFINE_PROP(StoredPkgPath);
    DEFINE_PROP(StoredPkgVersion);
    DEFINE_PROP(Version);
    DEFINE_METHOD(RefreshPkgSource);
    
    namespace RefreshPkgSource
    {
        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace RefreshPkgSource



} // namespace SMS_Package


//----------------------------------------------------------------------------
// SMS_PackageAccessByUsers : 
// 
// 
// 
DEFINE_CLASS(SMS_PackageAccessByUsers);
namespace SMS_PackageAccessByUsers
{
    DEFINE_PROP(Access);
    
    namespace Access
    {

        enum tagBitField_SMS_PackageAccessByUsers_Access
        {
            BIT_READ                                     = 0x00000001,
            BIT_WRITE                                    = 0x00000002,
            BIT_EXECUTE                                  = 0x00000004,
            BIT_CREATE                                   = 0x00000008,
            BIT_DELETE                                   = 0x00000010,
            BIT_VIEW_FOLDERS                             = 0x00000020,
            BIT_VIEW_FILES                               = 0x00000040,
            BIT_CHANGE_PERMISSIONS                       = 0x00000080,
            BIT_CHANGE_ATTRIBUTES                        = 0x00000100
        };
    
    } // namespace Access


    DEFINE_PROP(PackageID);
    DEFINE_PROP(UserName);

} // namespace SMS_PackageAccessByUsers


//----------------------------------------------------------------------------
// SMS_PackageStatus : 
// 
// 
// 
DEFINE_CLASS(SMS_PackageStatus);
namespace SMS_PackageStatus
{
    DEFINE_PROP(Location);
    DEFINE_PROP(PackageID);
    DEFINE_PROP(Personality);
    
    namespace Personality
    {

        enum tagEnumeration_SMS_PackageStatus_Personality
        {
            ENUM_NONE                                     = 0L,
            ENUM_MAC                                      = 1L,
            ENUM_FPNW                                     = 2L
        };
    
    } // namespace Personality


    DEFINE_PROP(PkgServer);
    DEFINE_PROP(ShareName);
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(Status);
    
    namespace Status
    {

        enum tagEnumeration_SMS_PackageStatus_Status
        {
            ENUM_NONE                                     = 0L,
            ENUM_SENT                                     = 1L,
            ENUM_RECEIVED                                 = 2L,
            ENUM_INSTALLED                                = 3L,
            ENUM_RETRY                                    = 4L,
            ENUM_FAILED                                   = 5L,
            ENUM_REMOVED                                  = 6L,
            ENUM_PENDING_REMOVE                           = 7L
        };
    
    } // namespace Status


    DEFINE_PROP(Type);
    
    namespace Type
    {

        enum tagEnumeration_SMS_PackageStatus_Type
        {
            ENUM_MASTER                                   = 1L,
            ENUM_COPY                                     = 2L
        };
    
    } // namespace Type


    DEFINE_PROP(UpdateTime);

} // namespace SMS_PackageStatus


//----------------------------------------------------------------------------
// SMS_PackageStatusDetailSummarizer : 
// 
// 
// 
DEFINE_CLASS(SMS_PackageStatusDetailSummarizer);
namespace SMS_PackageStatusDetailSummarizer
{
    DEFINE_PROP(Failed);
    DEFINE_PROP(Installed);
    DEFINE_PROP(Name);
    DEFINE_PROP(PackageID);
    DEFINE_PROP(Retrying);
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(SiteName);
    DEFINE_PROP(SourceVersion);
    DEFINE_PROP(SummaryDate);
    DEFINE_PROP(Targeted);

} // namespace SMS_PackageStatusDetailSummarizer


//----------------------------------------------------------------------------
// SMS_PackageStatusDistPointsSummarizer : 
// 
// 
// 
DEFINE_CLASS(SMS_PackageStatusDistPointsSummarizer);
namespace SMS_PackageStatusDistPointsSummarizer
{
    DEFINE_PROP(LastCopied);
    DEFINE_PROP(PackageID);
    DEFINE_PROP(ServerNALPath);
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(SourceNALPath);
    DEFINE_PROP(SourceVersion);
    DEFINE_PROP(State);
    
    namespace State
    {

        enum tagEnumeration_SMS_PackageStatusDistPointsSummarizer_State
        {
            ENUM_INSTALLED                                = 0L,
            ENUM_INSTALL_PENDING                          = 1L,
            ENUM_INSTALL_RETRYING                         = 2L,
            ENUM_INSTALL_FAILED                           = 3L,
            ENUM_REMOVAL_PENDING                          = 4L,
            ENUM_REMOVAL_RETRYING                         = 5L,
            ENUM_REMOVAL_FAILED                           = 6L
        };
    
    } // namespace State


    DEFINE_PROP(SummaryDate);

} // namespace SMS_PackageStatusDistPointsSummarizer


//----------------------------------------------------------------------------
// SMS_PackageStatusRootSummarizer : 
// 
// 
// 
DEFINE_CLASS(SMS_PackageStatusRootSummarizer);
namespace SMS_PackageStatusRootSummarizer
{
    DEFINE_PROP(Failed);
    DEFINE_PROP(Installed);
    DEFINE_PROP(Name);
    DEFINE_PROP(PackageID);
    DEFINE_PROP(Retrying);
    DEFINE_PROP(SourceCompressedSize);
    DEFINE_PROP(SourceDate);
    DEFINE_PROP(SourceSite);
    DEFINE_PROP(SourceSize);
    DEFINE_PROP(SourceVersion);
    DEFINE_PROP(Targeted);

} // namespace SMS_PackageStatusRootSummarizer


//----------------------------------------------------------------------------
// SMS_PackageToAdvert_a : 
// 
// 
// 
DEFINE_CLASS(SMS_PackageToAdvert_a);
namespace SMS_PackageToAdvert_a
{
    DEFINE_PROP(advert);
    DEFINE_PROP(package);

} // namespace SMS_PackageToAdvert_a


//----------------------------------------------------------------------------
// SMS_PackageToSourceSite_a : 
// 
// 
// 
DEFINE_CLASS(SMS_PackageToSourceSite_a);
namespace SMS_PackageToSourceSite_a
{
    DEFINE_PROP(ownedPackage);
    DEFINE_PROP(pkgSourcesite);

} // namespace SMS_PackageToSourceSite_a


//----------------------------------------------------------------------------
// SMS_PDF_Package : 
// 
// 
// 
DEFINE_CLASS(SMS_PDF_Package);
namespace SMS_PDF_Package
{
    DEFINE_PROP(Icon);
    DEFINE_PROP(IconSize);
    DEFINE_PROP(Language);
    DEFINE_PROP(Name);
    DEFINE_PROP(PDFFileName);
    DEFINE_PROP(PDFID);
    DEFINE_PROP(Publisher);
    DEFINE_PROP(RequiredIconNames);
    DEFINE_PROP(Status);
    
    namespace Status
    {

        enum tagEnumeration_SMS_PDF_Package_Status
        {
            ENUM_Loaded                                   = 0L,
            ENUM_RequiresIcon                             = 1L
        };
    
    } // namespace Status


    DEFINE_PROP(Version);
    DEFINE_METHOD(ProcessInBox);
    
    namespace ProcessInBox
    {
        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace ProcessInBox


    DEFINE_METHOD(LoadPDF);
    
    namespace LoadPDF
    {
        
        namespace In
        {
            DEFINE_PARAM(PDFFile);
            DEFINE_PARAM(PDFFileName);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(PDFID);
            DEFINE_PARAM(RequiredIconNames);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace LoadPDF


    DEFINE_METHOD(LoadIconForPDF);
    
    namespace LoadIconForPDF
    {
        
        namespace In
        {
            DEFINE_PARAM(Icon);
            DEFINE_PARAM(IconFileName);
            DEFINE_PARAM(PDFID);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace LoadIconForPDF


    DEFINE_METHOD(GetPDFData);
    
    namespace GetPDFData
    {
        
        namespace In
        {
            DEFINE_PARAM(PDFID);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(PackageData);
            DEFINE_PARAM(ProgramData);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace GetPDFData



} // namespace SMS_PDF_Package


//----------------------------------------------------------------------------
// SMS_PDF_Program : 
// 
// 
// 
DEFINE_CLASS(SMS_PDF_Program);
namespace SMS_PDF_Program
{
    DEFINE_PROP(CommandLine);
    DEFINE_PROP(Comment);
    DEFINE_PROP(DependentProgram);
    DEFINE_PROP(Description);
    DEFINE_PROP(DiskSpaceReq);
    DEFINE_PROP(DriveLetter);
    DEFINE_PROP(Duration);
    DEFINE_PROP(Icon);
    DEFINE_PROP(IconSize);
    DEFINE_PROP(PDFID);
    DEFINE_PROP(ProgramFlags);
    DEFINE_PROP(ProgramName);
    DEFINE_PROP(Publisher);
    DEFINE_PROP(Requirements);
    DEFINE_PROP(WorkingDirectory);

} // namespace SMS_PDF_Program


//----------------------------------------------------------------------------
// SMS_PDFPkgToPDFProgram_a : 
// 
// 
// 
DEFINE_CLASS(SMS_PDFPkgToPDFProgram_a);
namespace SMS_PDFPkgToPDFProgram_a
{
    DEFINE_PROP(PDF_Package);
    DEFINE_PROP(PDF_Program);

} // namespace SMS_PDFPkgToPDFProgram_a


//----------------------------------------------------------------------------
// SMS_PkgToPkgAccess_a : 
// 
// 
// 
DEFINE_CLASS(SMS_PkgToPkgAccess_a);
namespace SMS_PkgToPkgAccess_a
{
    DEFINE_PROP(package);
    DEFINE_PROP(pkgAccess);

} // namespace SMS_PkgToPkgAccess_a


//----------------------------------------------------------------------------
// SMS_PkgToPkgProgram_a : 
// 
// 
// 
DEFINE_CLASS(SMS_PkgToPkgProgram_a);
namespace SMS_PkgToPkgProgram_a
{
    DEFINE_PROP(package);
    DEFINE_PROP(pkgProgram);

} // namespace SMS_PkgToPkgProgram_a


//----------------------------------------------------------------------------
// SMS_PkgToPkgServer_a : 
// 
// 
// 
DEFINE_CLASS(SMS_PkgToPkgServer_a);
namespace SMS_PkgToPkgServer_a
{
    DEFINE_PROP(package);
    DEFINE_PROP(pkgServer);

} // namespace SMS_PkgToPkgServer_a


//----------------------------------------------------------------------------
// SMS_Program : 
// 
// 
// 
DEFINE_CLASS(SMS_Program);
namespace SMS_Program
{
    DEFINE_PROP(ActionInProgress);
    
    namespace ActionInProgress
    {

        enum tagEnumeration_SMS_Program_ActionInProgress
        {
            ENUM_NONE                                     = 0L,
            ENUM_UPDATE                                   = 1L,
            ENUM_ADD                                      = 2L,
            ENUM_DELETE                                   = 3L
        };
    
    } // namespace ActionInProgress


    DEFINE_PROP(ApplicationHierarchy);
    DEFINE_PROP(CommandLine);
    DEFINE_PROP(Comment);
    DEFINE_PROP(DependentProgram);
    DEFINE_PROP(Description);
    DEFINE_PROP(DiskSpaceReq);
    DEFINE_PROP(DriveLetter);
    DEFINE_PROP(Duration);
    DEFINE_PROP(Icon);
    DEFINE_PROP(IconSize);
    DEFINE_PROP(PackageID);
    DEFINE_PROP(ProgramFlags);
    
    namespace ProgramFlags
    {

        enum tagBitField_SMS_Program_ProgramFlags
        {
            BIT_DISABLED                                 = 0x00001000,
            BIT_UNATTENDED                               = 0x00002000,
            BIT_USERCONTEXT                              = 0x00004000,
            BIT_ADMINRIGHTS                              = 0x00008000,
            BIT_EVERYUSER                                = 0x00010000,
            BIT_NOUSERLOGGEDIN                           = 0x00020000,
            BIT_OKTOQUIT                                 = 0x00040000,
            BIT_OKTOREBOOT                               = 0x00080000,
            BIT_USEUNCPATH                               = 0x00100000,
            BIT_PERSISTCONNECTION                        = 0x00200000,
            BIT_RUNMINIMIZED                             = 0x00400000,
            BIT_RUNMAXIMIZED                             = 0x00800000,
            BIT_HIDEWINDOW                               = 0x01000000,
            BIT_OKLOGOFF                                 = 0x02000000,
            BIT_RUNACCOUNT                               = 0x04000000,
            BIT_ANY_PLATFORM                             = 0x08000000,
            BIT_STILL_RUNNING                            = 0x10000000,
            BIT_SUPPORT_UNINSTALL                        = 0x20000000
        };
    
    } // namespace ProgramFlags


    DEFINE_PROP(ProgramName);
    DEFINE_PROP(RemovalKey);
    DEFINE_PROP(Requirements);
    DEFINE_PROP(SupportedOperatingSystems);
    DEFINE_PROP(WorkingDirectory);

} // namespace SMS_Program


//----------------------------------------------------------------------------
// SMS_PropertyDisplayNode : 
// 
// 
// 
DEFINE_CLASS(SMS_PropertyDisplayNode);
namespace SMS_PropertyDisplayNode
{
    DEFINE_PROP(ClassDisplayName);
    DEFINE_PROP(ClassName);
    DEFINE_PROP(Flags);
    
    namespace Flags
    {

        enum tagBitField_SMS_PropertyDisplayNode_Flags
        {
            BIT_Static                                   = 0x00000001,
            BIT_RootNode                                 = 0x00000002,
            BIT_LeafNode                                 = 0x00000004,
            BIT_HasHistory                               = 0x00000008,
            BIT_UserDefined                              = 0x00000040
        };
    
    } // namespace Flags


    DEFINE_PROP(NodeKey);
    DEFINE_PROP(NodeName);
    DEFINE_PROP(PaneOrder);
    DEFINE_PROP(ParentNodeKey);
    DEFINE_PROP(ResourceDisplayName);
    DEFINE_PROP(ResultProperties);
    DEFINE_PROP(ResultPropertyIDName);
    DEFINE_PROP(ScopePropertyIDName);
    DEFINE_PROP(ScopePropertyNames);

} // namespace SMS_PropertyDisplayNode


//----------------------------------------------------------------------------
// SMS_Query : 
// 
// 
// 
DEFINE_CLASS(SMS_Query);
namespace SMS_Query
{
    DEFINE_PROP(Comments);
    DEFINE_PROP(Expression);
    DEFINE_PROP(LimitToCollectionID);
    DEFINE_PROP(Name);
    DEFINE_PROP(QueryID);
    DEFINE_PROP(TargetClassName);

} // namespace SMS_Query

//----------------------------------------------------------------------------
// SMS_R_IPNetwork : 
// 
// 
// 
DEFINE_CLASS(SMS_R_IPNetwork);
namespace SMS_R_IPNetwork
{
    DEFINE_PROP(AgentName);
    DEFINE_PROP(AgentSite);
    DEFINE_PROP(AgentTime);
    DEFINE_PROP(Name);
    DEFINE_PROP(ResourceType);
    DEFINE_PROP(SMSAssignedSites);
    DEFINE_PROP(SubnetAddress);
    DEFINE_PROP(SubnetMask);

} // namespace SMS_R_IPNetwork

//----------------------------------------------------------------------------
// SMS_R_System : 
// 
// 
// 
DEFINE_CLASS(SMS_R_System);
namespace SMS_R_System
{
    DEFINE_PROP(AgentName);
    DEFINE_PROP(AgentSite);
    DEFINE_PROP(AgentTime);
    DEFINE_PROP(Client);
    DEFINE_PROP(ClientVersion);
    DEFINE_PROP(IPAddresses);
    DEFINE_PROP(IPSubnets);
    DEFINE_PROP(IPXAddresses);
    DEFINE_PROP(IPXNetworkNumbers);
    DEFINE_PROP(LastLogonUserDomain);
    DEFINE_PROP(LastLogonUserName);
    DEFINE_PROP(MACAddresses);
    DEFINE_PROP(Name);
    DEFINE_PROP(NetbiosName);
    DEFINE_PROP(OperatingSystemNameandVersion);
    DEFINE_PROP(ResourceDomainORWorkgroup);
    DEFINE_PROP(ResourceNames);
    DEFINE_PROP(ResourceType);
    DEFINE_PROP(SMSAssignedSites);
    DEFINE_PROP(SMSInstalledSites);
    DEFINE_PROP(SMSUniqueIdentifier);
    DEFINE_PROP(SNMPCommunityName);
    DEFINE_PROP(SystemRoles);

} // namespace SMS_R_System


//----------------------------------------------------------------------------
// SMS_R_User : 
// 
// 
// 
DEFINE_CLASS(SMS_R_User);
namespace SMS_R_User
{
    DEFINE_PROP(AgentName);
    DEFINE_PROP(AgentSite);
    DEFINE_PROP(AgentTime);
    DEFINE_PROP(FullUserName);
    DEFINE_PROP(Name);
    DEFINE_PROP(NetworkOperatingSystem);
    DEFINE_PROP(ResourceType);
    DEFINE_PROP(SMSAssignedSites);
    DEFINE_PROP(UniqueUserName);
    DEFINE_PROP(UserName);
    DEFINE_PROP(WindowsNTDomain);

} // namespace SMS_R_User


//----------------------------------------------------------------------------
// SMS_R_UserGroup : 
// 
// 
// 
DEFINE_CLASS(SMS_R_UserGroup);
namespace SMS_R_UserGroup
{
    DEFINE_PROP(AgentName);
    DEFINE_PROP(AgentSite);
    DEFINE_PROP(AgentTime);
    DEFINE_PROP(Name);
    DEFINE_PROP(NetworkOperatingSystem);
    DEFINE_PROP(ResourceType);
    DEFINE_PROP(SMSAssignedSites);
    DEFINE_PROP(UniqueUsergroupName);
    DEFINE_PROP(UsergroupName);
    DEFINE_PROP(WindowsNTDomain);

} // namespace SMS_R_UserGroup


//----------------------------------------------------------------------------
// SMS_ResIDValueLookup : 
// 
// 
// 
DEFINE_CLASS(SMS_ResIDValueLookup);
namespace SMS_ResIDValueLookup
{
    DEFINE_PROP(IntLookupValue);
    DEFINE_PROP(LookupName);
    DEFINE_PROP(ResDLL);
    DEFINE_PROP(ResID);
    DEFINE_PROP(StringLookupValue);

} // namespace SMS_ResIDValueLookup


//----------------------------------------------------------------------------
// SMS_Resource : 
// 
// 
// 
DEFINE_CLASS(SMS_Resource);
namespace SMS_Resource
{
    DEFINE_PROP(ResourceId);

} // namespace SMS_Resource


//----------------------------------------------------------------------------
// SMS_ResourceMap : 
// 
// 
// 
DEFINE_CLASS(SMS_ResourceMap);
namespace SMS_ResourceMap
{
    DEFINE_PROP(DisplayName);
    DEFINE_PROP(ResourceClassName);
    DEFINE_PROP(ResourceType);
    DEFINE_METHOD(Refresh);
    
    namespace Refresh
    {
        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace Refresh



} // namespace SMS_ResourceMap


//----------------------------------------------------------------------------
// SMS_SCFToSCI_a : 
// 
// 
// 
DEFINE_CLASS(SMS_SCFToSCI_a);
namespace SMS_SCFToSCI_a
{
    DEFINE_PROP(SiteControlFile);
    DEFINE_PROP(SiteControlItem);

} // namespace SMS_SCFToSCI_a


//----------------------------------------------------------------------------
// SMS_SCFToSite_a : 
// 
// 
// 
DEFINE_CLASS(SMS_SCFToSite_a);
namespace SMS_SCFToSite_a
{
    DEFINE_PROP(Site);
    DEFINE_PROP(SiteControlFile);

} // namespace SMS_SCFToSite_a


//----------------------------------------------------------------------------
// SMS_ScheduleMethods : 
// 
// 
// 
DEFINE_CLASS(SMS_ScheduleMethods);
namespace SMS_ScheduleMethods
{
    DEFINE_METHOD(WriteToString);
    
    namespace WriteToString
    {
        
        namespace In
        {
            DEFINE_PARAM(TokenData);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);
            DEFINE_PARAM(StringData);

        } // namespace Out



    } // namespace WriteToString


    DEFINE_METHOD(ReadFromString);
    
    namespace ReadFromString
    {
        
        namespace In
        {
            DEFINE_PARAM(StringData);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);
            DEFINE_PARAM(TokenData);

        } // namespace Out



    } // namespace ReadFromString



} // namespace SMS_ScheduleMethods


//----------------------------------------------------------------------------
// SMS_ScheduleToken : 
// 
// 
// 
DEFINE_CLASS(SMS_ScheduleToken);
namespace SMS_ScheduleToken
{
    DEFINE_PROP(DayDuration);
    DEFINE_PROP(HourDuration);
    DEFINE_PROP(IsGMT);
    DEFINE_PROP(MinuteDuration);
    DEFINE_PROP(StartTime);

} // namespace SMS_ScheduleToken


//----------------------------------------------------------------------------
// SMS_SCI_Address : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_Address);
namespace SMS_SCI_Address
{
    DEFINE_PROP(AddressType);
    DEFINE_PROP(DesSiteCode);
    DEFINE_PROP(Order);
    DEFINE_PROP(PropLists);
    DEFINE_PROP(Props);
    DEFINE_PROP(RateLimitingSchedule);
    DEFINE_PROP(UnlimitedRateForAll);
    DEFINE_PROP(UsageSchedule);

} // namespace SMS_SCI_Address


//----------------------------------------------------------------------------
// SMS_SCI_ClientComp : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_ClientComp);
namespace SMS_SCI_ClientComp
{
    DEFINE_PROP(ClientComponentName);
    DEFINE_PROP(Flags);
    
    namespace Flags
    {

        enum tagBitField_SMS_SCI_ClientComp_Flags
        {
            BIT_ACTIVE                                   = 0x00000001
        };
    
    } // namespace Flags


    DEFINE_PROP(PropLists);
    DEFINE_PROP(Props);
    DEFINE_PROP(RegMultiStringLists);

} // namespace SMS_SCI_ClientComp


//----------------------------------------------------------------------------
// SMS_SCI_ClientConfig : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_ClientConfig);
namespace SMS_SCI_ClientConfig
{
    DEFINE_PROP(ClientConfigName);
    DEFINE_PROP(Flags);
    
    namespace Flags
    {

        enum tagEnumeration_SMS_SCI_ClientConfig_Flags
        {
            ENUM_ACTIVE                                   = 1L,
            ENUM_BASE_INSTALL                             = 2L
        };
    
    } // namespace Flags


    DEFINE_PROP(Platforms);
    DEFINE_PROP(PropLists);
    DEFINE_PROP(Props);
    DEFINE_PROP(RegMultiStringLists);

} // namespace SMS_SCI_ClientConfig


//----------------------------------------------------------------------------
// SMS_SCI_Component : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_Component);
namespace SMS_SCI_Component
{
    DEFINE_PROP(ComponentName);
    DEFINE_PROP(Flag);
    
    namespace Flag
    {

        enum tagEnumeration_SMS_SCI_Component_Flag
        {
            ENUM_ROLE_NOT_INSTALLED                       = 1L,
            ENUM_NAMED_SERVER_NOT_INSTALLED               = 2L,
            ENUM_ROLE_INSTALLED                           = 5L,
            ENUM_NAMED_SERVER_INSTALLED                   = 6L
        };
    
    } // namespace Flag


    DEFINE_PROP(Name);
    DEFINE_PROP(PropLists);
    DEFINE_PROP(Props);

} // namespace SMS_SCI_Component


//----------------------------------------------------------------------------
// SMS_SCI_Configuration : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_Configuration);
namespace SMS_SCI_Configuration
{
    DEFINE_PROP(ConfigurationName);
    DEFINE_PROP(PropLists);
    DEFINE_PROP(Props);

} // namespace SMS_SCI_Configuration


//----------------------------------------------------------------------------
// SMS_SCI_FileDefinition : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_FileDefinition);
namespace SMS_SCI_FileDefinition
{
    DEFINE_PROP(Comment);
    DEFINE_PROP(OriginatingSite);
    DEFINE_PROP(SerialNumber);
    DEFINE_PROP(TargetSite);

} // namespace SMS_SCI_FileDefinition


//----------------------------------------------------------------------------
// SMS_SCI_Property : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_Property);
namespace SMS_SCI_Property
{
    DEFINE_PROP(PropertyName);
    DEFINE_PROP(Value);
    DEFINE_PROP(Value1);
    DEFINE_PROP(Value2);

} // namespace SMS_SCI_Property


//----------------------------------------------------------------------------
// SMS_SCI_PropertyList : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_PropertyList);
namespace SMS_SCI_PropertyList
{
    DEFINE_PROP(PropertyListName);
    DEFINE_PROP(Values);

} // namespace SMS_SCI_PropertyList


//----------------------------------------------------------------------------
// SMS_SCI_SiteAssignment : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_SiteAssignment);
namespace SMS_SCI_SiteAssignment
{
    DEFINE_PROP(AssignDetails);
    DEFINE_PROP(AssignTypes);

} // namespace SMS_SCI_SiteAssignment


//----------------------------------------------------------------------------
// SMS_SCI_SiteDefinition : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_SiteDefinition);
namespace SMS_SCI_SiteDefinition
{
    DEFINE_PROP(AddressPublicKey);
    DEFINE_PROP(InstallDirectory);
    DEFINE_PROP(ParentSiteCode);
    DEFINE_PROP(PropLists);
    DEFINE_PROP(Props);
    DEFINE_PROP(ServiceAccount);
    DEFINE_PROP(ServiceAccountDomain);
    DEFINE_PROP(ServiceAccountPassword);
    DEFINE_PROP(ServiceExchangeKey);
    DEFINE_PROP(ServicePlaintextAccount);
    DEFINE_PROP(ServicePublicKey);
    DEFINE_PROP(SiteName);
    DEFINE_PROP(SiteServerDomain);
    DEFINE_PROP(SiteServerName);
    DEFINE_PROP(SiteServerPlatform);
    DEFINE_PROP(SiteType);
    
    namespace SiteType
    {

        enum tagEnumeration_SMS_SCI_SiteDefinition_SiteType
        {
            ENUM_SECONDARY                                = 1L,
            ENUM_PRIMARY                                  = 2L
        };
    
    } // namespace SiteType


    DEFINE_PROP(SQLAccount);
    DEFINE_PROP(SQLAccountPassword);
    DEFINE_PROP(SQLDatabaseName);
    DEFINE_PROP(SQLPublicKey);
    DEFINE_PROP(SQLServerName);

} // namespace SMS_SCI_SiteDefinition


//----------------------------------------------------------------------------
// SMS_SCI_SQLCmd : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_SQLCmd);
namespace SMS_SCI_SQLCmd
{
    DEFINE_PROP(BeginTime);
    DEFINE_PROP(DaysOfWeek);
    
    namespace DaysOfWeek
    {

        enum tagBitField_SMS_SCI_SQLCmd_DaysOfWeek
        {
            BIT_SUNDAY                                   = 0x00000001,
            BIT_MONDAY                                   = 0x00000002,
            BIT_TUESDAY                                  = 0x00000004,
            BIT_WEDNESDAY                                = 0x00000008,
            BIT_THURSDAY                                 = 0x00000010,
            BIT_FRIDAY                                   = 0x00000020,
            BIT_SATURDAY                                 = 0x00000040
        };
    
    } // namespace DaysOfWeek


    DEFINE_PROP(LatestBeginTime);
    DEFINE_PROP(LogFile);
    DEFINE_PROP(Name);
    DEFINE_PROP(NumRefreshDays);
    DEFINE_PROP(On);
    DEFINE_PROP(SQLCmd);

} // namespace SMS_SCI_SQLCmd


//----------------------------------------------------------------------------
// SMS_SCI_SQLTask : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_SQLTask);
namespace SMS_SCI_SQLTask
{
    DEFINE_PROP(BeginTime);
    DEFINE_PROP(DaysOfWeek);
    
    namespace DaysOfWeek
    {

        enum tagBitField_SMS_SCI_SQLTask_DaysOfWeek
        {
            BIT_SUNDAY                                   = 0x00000001,
            BIT_MONDAY                                   = 0x00000002,
            BIT_TUESDAY                                  = 0x00000004,
            BIT_WEDNESDAY                                = 0x00000008,
            BIT_THURSDAY                                 = 0x00000010,
            BIT_FRIDAY                                   = 0x00000020,
            BIT_SATURDAY                                 = 0x00000040
        };
    
    } // namespace DaysOfWeek


    DEFINE_PROP(DeleteOlderThan);
    DEFINE_PROP(DeviceName);
    DEFINE_PROP(LatestBeginTime);
    DEFINE_PROP(NumRefreshDays);
    DEFINE_PROP(On);
    DEFINE_PROP(TaskName);
    DEFINE_PROP(TaskType);
    
    namespace TaskType
    {

        enum tagEnumeration_SMS_SCI_SQLTask_TaskType
        {
            ENUM_BACKUP                                   = 1L,
            ENUM_PERIOD                                   = 2L,
            ENUM_DELETE                                   = 3L
        };
    
    } // namespace TaskType



} // namespace SMS_SCI_SQLTask


//----------------------------------------------------------------------------
// SMS_SCI_SysResUse : 
// 
// 
// 
DEFINE_CLASS(SMS_SCI_SysResUse);
namespace SMS_SCI_SysResUse
{
    DEFINE_PROP(InboxRoot);
    DEFINE_PROP(NALPath);
    DEFINE_PROP(NALType);
    DEFINE_PROP(NetworkOSPath);
    DEFINE_PROP(PropLists);
    DEFINE_PROP(Props);
    DEFINE_PROP(RoleName);

} // namespace SMS_SCI_SysResUse


//----------------------------------------------------------------------------
// SMS_SecuredObject : 
// 
// 
// 
DEFINE_CLASS(SMS_SecuredObject);
namespace SMS_SecuredObject
{
    DEFINE_PROP(AvailableClassPermissions);
    
    namespace AvailableClassPermissions
    {

        enum tagBitField_SMS_SecuredObject_AvailableClassPermissions
        {
            BIT_READ                                     = 0x00000001,
            BIT_MODIFY                                   = 0x00000002,
            BIT_DELETE                                   = 0x00000004,
            BIT_DISTRIBUTE                               = 0x00000008,
            BIT_CREATE_CHILD                             = 0x00000010,
            BIT_REMOTE_CONTROL                           = 0x00000020,
            BIT_ADVERTISE                                = 0x00000040,
            BIT_MODIFY_RESOURCE                          = 0x00000080,
            BIT_ADMINISTER                               = 0x00000100,
            BIT_DELETE_RESOURCE                          = 0x00000200,
            BIT_CREATE                                   = 0x00000400,
            BIT_VIEW_COLL_FILE                           = 0x00000800,
            BIT_READ_RESOURCE                            = 0x00001000
        };
    
    } // namespace AvailableClassPermissions


    DEFINE_PROP(AvailableInstancePermissions);
    
    namespace AvailableInstancePermissions
    {

        enum tagBitField_SMS_SecuredObject_AvailableInstancePermissions
        {
            BIT_READ                                     = 0x00000001,
            BIT_MODIFY                                   = 0x00000002,
            BIT_DELETE                                   = 0x00000004,
            BIT_DISTRIBUTE                               = 0x00000008,
            BIT_CREATE_CHILD                             = 0x00000010,
            BIT_REMOTE_CONTROL                           = 0x00000020,
            BIT_ADVERTISE                                = 0x00000040,
            BIT_MODIFY_RESOURCE                          = 0x00000080,
            BIT_ADMINISTER                               = 0x00000100,
            BIT_DELETE_RESOURCE                          = 0x00000200,
            BIT_CREATE                                   = 0x00000400,
            BIT_VIEW_COLL_FILE                           = 0x00000800,
            BIT_READ_RESOURCE                            = 0x00001000
        };
    
    } // namespace AvailableInstancePermissions


    DEFINE_PROP(DefaultClassPermissions);
    
    namespace DefaultClassPermissions
    {

        enum tagBitField_SMS_SecuredObject_DefaultClassPermissions
        {
            BIT_READ                                     = 0x00000001,
            BIT_MODIFY                                   = 0x00000002,
            BIT_DELETE                                   = 0x00000004,
            BIT_DISTRIBUTE                               = 0x00000008,
            BIT_CREATE_CHILD                             = 0x00000010,
            BIT_REMOTE_CONTROL                           = 0x00000020,
            BIT_ADVERTISE                                = 0x00000040,
            BIT_MODIFY_RESOURCE                          = 0x00000080,
            BIT_ADMINISTER                               = 0x00000100,
            BIT_DELETE_RESOURCE                          = 0x00000200,
            BIT_CREATE                                   = 0x00000400,
            BIT_VIEW_COLL_FILE                           = 0x00000800,
            BIT_READ_RESOURCE                            = 0x00001000
        };
    
    } // namespace DefaultClassPermissions


    DEFINE_PROP(DefaultInstancePermissions);
    
    namespace DefaultInstancePermissions
    {

        enum tagBitField_SMS_SecuredObject_DefaultInstancePermissions
        {
            BIT_READ                                     = 0x00000001,
            BIT_MODIFY                                   = 0x00000002,
            BIT_DELETE                                   = 0x00000004,
            BIT_DISTRIBUTE                               = 0x00000008,
            BIT_CREATE_CHILD                             = 0x00000010,
            BIT_REMOTE_CONTROL                           = 0x00000020,
            BIT_ADVERTISE                                = 0x00000040,
            BIT_MODIFY_RESOURCE                          = 0x00000080,
            BIT_ADMINISTER                               = 0x00000100,
            BIT_DELETE_RESOURCE                          = 0x00000200,
            BIT_CREATE                                   = 0x00000400,
            BIT_VIEW_COLL_FILE                           = 0x00000800,
            BIT_READ_RESOURCE                            = 0x00001000
        };
    
    } // namespace DefaultInstancePermissions


    DEFINE_PROP(ObjectKey);
    DEFINE_PROP(ObjectName);
    DEFINE_METHOD(UserHasPermissions);
    
    namespace UserHasPermissions
    {
        
        namespace In
        {
            DEFINE_PARAM(ObjectPath);
            DEFINE_PARAM(Permissions);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace UserHasPermissions


    DEFINE_METHOD(RefreshNTGroupMembership);
    
    namespace RefreshNTGroupMembership
    {
        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace RefreshNTGroupMembership


    DEFINE_METHOD(GetCollectionsWithResourcePermissions);
    
    namespace GetCollectionsWithResourcePermissions
    {
        
        namespace In
        {
            DEFINE_PARAM(Permissions);
            DEFINE_PARAM(ResourceID);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(CollectionIDs);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace GetCollectionsWithResourcePermissions



} // namespace SMS_SecuredObject


//----------------------------------------------------------------------------
// SMS_SetupInfo : 
// 
// 
// 
DEFINE_CLASS(SMS_SetupInfo);
namespace SMS_SetupInfo
{
    DEFINE_PROP(id);
    DEFINE_PROP(String1);
    DEFINE_PROP(String2);
    DEFINE_PROP(Value1);
    DEFINE_PROP(Value2);

} // namespace SMS_SetupInfo


//----------------------------------------------------------------------------
// SMS_SII_Property : 
// 
// 
// 
DEFINE_CLASS(SMS_SII_Property);
namespace SMS_SII_Property
{
    DEFINE_PROP(PropertyName);
    DEFINE_PROP(Value);
    DEFINE_PROP(Value1);
    DEFINE_PROP(Value2);

} // namespace SMS_SII_Property


//----------------------------------------------------------------------------
// SMS_SII_PropertyList : 
// 
// 
// 
DEFINE_CLASS(SMS_SII_PropertyList);
namespace SMS_SII_PropertyList
{
    DEFINE_PROP(PropertyListName);
    DEFINE_PROP(Values);

} // namespace SMS_SII_PropertyList


//----------------------------------------------------------------------------
// SMS_SIIB_AddressType : 
// 
// 
// 
DEFINE_CLASS(SMS_SIIB_AddressType);
namespace SMS_SIIB_AddressType
{
    DEFINE_PROP(AddressType);
    DEFINE_PROP(ChmFile);
    DEFINE_PROP(DescriptionID);
    DEFINE_PROP(DispIconID);
    DEFINE_PROP(DispNameID);
    DEFINE_PROP(Flags);
    
    namespace Flags
    {

        enum tagBitField_SMS_SIIB_AddressType_Flags
        {
            BIT_ALLOW_ADD                                = 0x00000001,
            BIT_ALLOW_DELETE                             = 0x00000002,
            BIT_ALLOW_MODIFY                             = 0x00000004,
            BIT_ALLOW_SCHEDULE                           = 0x00000008,
            BIT_ALLOW_RATE_LIMITING                      = 0x00000010
        };
    
    } // namespace Flags


    DEFINE_PROP(GUID);
    DEFINE_PROP(HtmFile);
    DEFINE_PROP(ResDLL);

} // namespace SMS_SIIB_AddressType


//----------------------------------------------------------------------------
// SMS_SIIB_Component_FileList : 
// 
// 
// 
DEFINE_CLASS(SMS_SIIB_Component_FileList);
namespace SMS_SIIB_Component_FileList
{
    DEFINE_PROP(ComponentName);
    DEFINE_PROP(Flags);
    
    namespace Flags
    {

        enum tagBitField_SMS_SIIB_Component_FileList_Flags
        {
            BIT_INSTALL                                  = 0x00000001,
            BIT_LOCAL_SYSTEM_ACCOUNT                     = 0x00000002,
            BIT_LITERAL_PATH                             = 0x00000004,
            BIT_PRIMARY_SITE                             = 0x00000008,
            BIT_SECONDARY_SITE                           = 0x00000010,
            BIT_AUTO_START                               = 0x00000020,
            BIT_AS_THREAD                                = 0x00000040,
            BIT_MULTI_SITE                               = 0x00000080,
            BIT_SCHEDULED                                = 0x00000100,
            BIT_ON_SITE_SERVER                           = 0x00000200,
            BIT_ON_SQL_SERVER                            = 0x00000400,
            BIT_ON_CLIENT_ACCESS                         = 0x00000800,
            BIT_ONLY_ONE_COPY                            = 0x00001000,
            BIT_USE_NAL                                  = 0x00002000
        };
    
    } // namespace Flags


    DEFINE_PROP(PropLists);
    DEFINE_PROP(Props);

} // namespace SMS_SIIB_Component_FileList


//----------------------------------------------------------------------------
// SMS_SIIB_Configuration : 
// 
// 
// 
DEFINE_CLASS(SMS_SIIB_Configuration);
namespace SMS_SIIB_Configuration
{
    DEFINE_PROP(ChmFile);
    DEFINE_PROP(ConfigUnitName);
    DEFINE_PROP(ConfigurationName);
    DEFINE_PROP(DescriptionID);
    DEFINE_PROP(DispIconID);
    DEFINE_PROP(DispNameID);
    DEFINE_PROP(Flags);
    
    namespace Flags
    {

        enum tagBitField_SMS_SIIB_Configuration_Flags
        {
            BIT_SECONDARY                                = 0x00000001,
            BIT_PRIMARY                                  = 0x00000002
        };
    
    } // namespace Flags


    DEFINE_PROP(GUID);
    DEFINE_PROP(HtmFile);
    DEFINE_PROP(ResDLL);
    DEFINE_PROP(Type);

} // namespace SMS_SIIB_Configuration


//----------------------------------------------------------------------------
// SMS_SIIB_Generic_Configuration : 
// 
// 
// 
DEFINE_CLASS(SMS_SIIB_Generic_Configuration);
namespace SMS_SIIB_Generic_Configuration
{
    DEFINE_PROP(ConfigurationName);
    DEFINE_PROP(PropLists);
    DEFINE_PROP(Props);

} // namespace SMS_SIIB_Generic_Configuration


//----------------------------------------------------------------------------
// SMS_SIIB_NALProvider : 
// 
// 
// 
DEFINE_CLASS(SMS_SIIB_NALProvider);
namespace SMS_SIIB_NALProvider
{
    DEFINE_PROP(Flags);
    
    namespace Flags
    {

        enum tagEnumeration_SMS_SIIB_NALProvider_Flags
        {
            ENUM_SERVER                                   = 1L,
            ENUM_ADMINUI                                  = 2L,
            ENUM_CLIENT                                   = 3L
        };
    
    } // namespace Flags


    DEFINE_PROP(ProviderName);

} // namespace SMS_SIIB_NALProvider


//----------------------------------------------------------------------------
// SMS_SIIB_SenderType : 
// 
// 
// 
DEFINE_CLASS(SMS_SIIB_SenderType);
namespace SMS_SIIB_SenderType
{
    DEFINE_PROP(ChmFile);
    DEFINE_PROP(DescriptionID);
    DEFINE_PROP(DispIconID);
    DEFINE_PROP(DispNameID);
    DEFINE_PROP(Flags);
    
    namespace Flags
    {

        enum tagBitField_SMS_SIIB_SenderType_Flags
        {
            BIT_ALLOW_ADD                                = 0x00000001,
            BIT_ALLOW_DELETE                             = 0x00000002,
            BIT_ALLOW_MODIFY                             = 0x00000004
        };
    
    } // namespace Flags


    DEFINE_PROP(GUID);
    DEFINE_PROP(HtmFile);
    DEFINE_PROP(ResDLL);
    DEFINE_PROP(SenderType);

} // namespace SMS_SIIB_SenderType


//----------------------------------------------------------------------------
// SMS_SIIB_SysResRole : 
// 
// 
// 
DEFINE_CLASS(SMS_SIIB_SysResRole);
namespace SMS_SIIB_SysResRole
{
    DEFINE_PROP(ChmFile);
    DEFINE_PROP(DescriptionID);
    DEFINE_PROP(DispIconID);
    DEFINE_PROP(DispNameID);
    DEFINE_PROP(Flags);
    
    namespace Flags
    {

        enum tagBitField_SMS_SIIB_SysResRole_Flags
        {
            BIT_ASSIGNABLE                               = 0x00000001
        };
    
    } // namespace Flags


    DEFINE_PROP(GUID);
    DEFINE_PROP(HtmFile);
    DEFINE_PROP(ResDLL);
    DEFINE_PROP(RoleName);

} // namespace SMS_SIIB_SysResRole


//----------------------------------------------------------------------------
// SMS_SIIB_UINALProvider : 
// 
// 
// 
DEFINE_CLASS(SMS_SIIB_UINALProvider);
namespace SMS_SIIB_UINALProvider
{
    DEFINE_PROP(DispIconID);
    DEFINE_PROP(DispNameID);
    DEFINE_PROP(DLLName);
    DEFINE_PROP(GUID);
    DEFINE_PROP(ProviderName);
    DEFINE_PROP(ResourceInfo);

} // namespace SMS_SIIB_UINALProvider


//----------------------------------------------------------------------------
// SMS_Site : 
// 
// 
// 
DEFINE_CLASS(SMS_Site);
namespace SMS_Site
{
    DEFINE_PROP(BuildNumber);
    DEFINE_PROP(InstallDir);
    DEFINE_PROP(ReportingSiteCode);
    DEFINE_PROP(RequestedStatus);
    
    namespace RequestedStatus
    {

        enum tagEnumeration_SMS_Site_RequestedStatus
        {
            ENUM_SEC_REQUEST_CREATE                       = 1001L,
            ENUM_SEC_REQUEST_CREATE_CD                    = 1002L,
            ENUM_SEC_CREATION_STARTED                     = 1003L,
            ENUM_SEC_REQUEST_UPGRADE                      = 1004L,
            ENUM_SEC_REQUEST_UPGRADE_CD                   = 1005L,
            ENUM_SEC_UPGRADE_STARTED                      = 1006L,
            ENUM_SEC_REQUEST_DEINSTALL                    = 1007L,
            ENUM_SEC_DEINSTALL_STARTED                    = 1008L
        };
    
    } // namespace RequestedStatus


    DEFINE_PROP(ServerName);
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(SiteName);
    DEFINE_PROP(Status);
    
    namespace Status
    {

        enum tagEnumeration_SMS_Site_Status
        {
            ENUM_ACTIVE                                   = 1L,
            ENUM_PENDING                                  = 2L,
            ENUM_FAILED                                   = 3L,
            ENUM_DELETED                                  = 4L,
            ENUM_UPGRADE                                  = 5L
        };
    
    } // namespace Status


    DEFINE_PROP(TimeZoneInfo);
    DEFINE_PROP(Type);
    
    namespace Type
    {

        enum tagEnumeration_SMS_Site_Type
        {
            ENUM_SECONDARY                                = 1L,
            ENUM_PRIMARY                                  = 2L
        };
    
    } // namespace Type


    DEFINE_PROP(Version);
    DEFINE_METHOD(VerifyNoLoops);
    
    namespace VerifyNoLoops
    {
        
        namespace In
        {
            DEFINE_PARAM(CentralSiteCode);
            DEFINE_PARAM(ParentSiteCode);
            DEFINE_PARAM(TargetSiteCode);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(Result);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace VerifyNoLoops



} // namespace SMS_Site


//----------------------------------------------------------------------------
// SMS_SiteControlDaySchedule : 
// 
// 
// 
DEFINE_CLASS(SMS_SiteControlDaySchedule);
namespace SMS_SiteControlDaySchedule
{
    DEFINE_PROP(Backup);
    DEFINE_PROP(HourUsage);
    
    namespace HourUsage
    {

        enum tagEnumeration_SMS_SiteControlDaySchedule_HourUsage
        {
            ENUM_ALL_PRIORITY                             = 1L,
            ENUM_ALL_BUT_LOW                              = 2L,
            ENUM_HIGH_ONLY                                = 3L,
            ENUM_CLOSED                                   = 4L
        };
    
    } // namespace HourUsage


    DEFINE_PROP(update);

} // namespace SMS_SiteControlDaySchedule


//----------------------------------------------------------------------------
// SMS_SiteControlFile : 
// 
// 
// 
DEFINE_CLASS(SMS_SiteControlFile);
namespace SMS_SiteControlFile
{
    DEFINE_PROP(BuildNumber);
    DEFINE_PROP(FileType);
    
    namespace FileType
    {

        enum tagEnumeration_SMS_SiteControlFile_FileType
        {
            ENUM_EMPTY                                    = 0L,
            ENUM_ACTUAL                                   = 1L,
            ENUM_PROPOSED                                 = 2L,
            ENUM_TRANSACTIONS                             = 4L,
            ENUM_LOCAL_TRANSACTIONS                       = 6L,
            ENUM_1XSTYLE                                  = 7L
        };
    
    } // namespace FileType


    DEFINE_PROP(FormatVersion);
    DEFINE_PROP(SCFData);
    DEFINE_PROP(SerialNumber);
    DEFINE_PROP(SiteCode);

    DEFINE_METHOD(CommitSCF);
    
    namespace CommitSCF
    {
        
        namespace In
        {
            DEFINE_PARAM(SiteCode);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace CommitSCF


    DEFINE_METHOD(RefreshSCF);
    
    namespace RefreshSCF
    {
        
        namespace In
        {
            DEFINE_PARAM(SiteCode);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace RefreshSCF


    DEFINE_METHOD(GetCurrentVersion);
    
    namespace GetCurrentVersion
    {
        
        namespace In
        {
            DEFINE_PARAM(SiteCode);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);
            DEFINE_PARAM(SCFData);

        } // namespace Out



    } // namespace GetCurrentVersion


    DEFINE_METHOD(GetSessionHandle);
    
    namespace GetSessionHandle
    {
        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);
            DEFINE_PARAM(SessionHandle);

        } // namespace Out



    } // namespace GetSessionHandle


    DEFINE_METHOD(ReleaseSessionHandle);
    
    namespace ReleaseSessionHandle
    {
        
        namespace In
        {
            DEFINE_PARAM(SessionHandle);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace ReleaseSessionHandle



} // namespace SMS_SiteControlFile


//----------------------------------------------------------------------------
// SMS_SiteControlItem : 
// 
// 
// 
DEFINE_CLASS(SMS_SiteControlItem);
namespace SMS_SiteControlItem
{
    DEFINE_PROP(FileType);
    
    namespace FileType
    {

        enum tagEnumeration_SMS_SiteControlItem_FileType
        {
            ENUM_EMPTY                                    = 0L,
            ENUM_ACTUAL                                   = 1L,
            ENUM_PROPOSED                                 = 2L,
            ENUM_TRANSACTIONS                             = 4L,
            ENUM_LOCAL_TRANSACTIONS                       = 6L
        };
    
    } // namespace FileType


    DEFINE_PROP(ItemName);
    DEFINE_PROP(ItemType);
    DEFINE_PROP(SiteCode);

} // namespace SMS_SiteControlItem


//----------------------------------------------------------------------------
// SMS_SiteDetailSummarizer : 
// 
// 
// 
DEFINE_CLASS(SMS_SiteDetailSummarizer);
namespace SMS_SiteDetailSummarizer
{
    DEFINE_PROP(DatabaseFree);
    DEFINE_PROP(Errors);
    DEFINE_PROP(Infos);
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(SiteName);
    DEFINE_PROP(Status);
    
    namespace Status
    {

        enum tagEnumeration_SMS_SiteDetailSummarizer_Status
        {
            ENUM_GREEN                                    = 0L,
            ENUM_YELLOW                                   = 1L,
            ENUM_RED                                      = 2L
        };
    
    } // namespace Status


    DEFINE_PROP(TallyInterval);
    DEFINE_PROP(TransFree);
    DEFINE_PROP(Version);
    DEFINE_PROP(Warnings);

} // namespace SMS_SiteDetailSummarizer


//----------------------------------------------------------------------------
// SMS_SiteInstallItem : 
// 
// 
// 
DEFINE_CLASS(SMS_SiteInstallItem);
namespace SMS_SiteInstallItem
{
    DEFINE_PROP(ItemName);
    DEFINE_PROP(ItemType);

} // namespace SMS_SiteInstallItem


//----------------------------------------------------------------------------
// SMS_SiteInstallItemBase : 
// 
// 
// 
DEFINE_CLASS(SMS_SiteInstallItemBase);
namespace SMS_SiteInstallItemBase
{
    DEFINE_PROP(Units);

} // namespace SMS_SiteInstallItemBase


//----------------------------------------------------------------------------
// SMS_SiteInstallMap : 
// 
// 
// 
DEFINE_CLASS(SMS_SiteInstallMap);
namespace SMS_SiteInstallMap
{
    DEFINE_PROP(BuildNumber);
    DEFINE_PROP(FileType);
    DEFINE_PROP(FormatVersion);
    DEFINE_PROP(IMapData);
    DEFINE_METHOD(Refresh);
    
    namespace Refresh
    {
        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace Refresh



} // namespace SMS_SiteInstallMap


//----------------------------------------------------------------------------
// SMS_SiteSystemSummarizer : 
// 
// 
// 
DEFINE_CLASS(SMS_SiteSystemSummarizer);
namespace SMS_SiteSystemSummarizer
{
    DEFINE_PROP(BytesFree);
    DEFINE_PROP(BytesTotal);
    DEFINE_PROP(DownSince);
    DEFINE_PROP(ObjectType);
    
    namespace ObjectType
    {

        enum tagEnumeration_SMS_SiteSystemSummarizer_ObjectType
        {
            ENUM_NALPATH                                  = 0L,
            ENUM_SQL_DB                                   = 1L,
            ENUM_SQL_LOG                                  = 2L
        };
    
    } // namespace ObjectType


    DEFINE_PROP(PercentFree);
    DEFINE_PROP(Role);
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(SiteObject);
    DEFINE_PROP(SiteSystem);
    DEFINE_PROP(Status);
    
    namespace Status
    {

        enum tagEnumeration_SMS_SiteSystemSummarizer_Status
        {
            ENUM_GREEN                                    = 0L,
            ENUM_YELLOW                                   = 1L,
            ENUM_RED                                      = 2L
        };
    
    } // namespace Status



} // namespace SMS_SiteSystemSummarizer


//----------------------------------------------------------------------------
// SMS_SiteToROOTColl_a : 
// 
// 
// 
DEFINE_CLASS(SMS_SiteToROOTColl_a);
namespace SMS_SiteToROOTColl_a
{
    DEFINE_PROP(collection);
    DEFINE_PROP(site);

} // namespace SMS_SiteToROOTColl_a


//----------------------------------------------------------------------------
// SMS_SiteToSiteID_a : 
// 
// 
// 
DEFINE_CLASS(SMS_SiteToSiteID_a);
namespace SMS_SiteToSiteID_a
{
    DEFINE_PROP(site);
    DEFINE_PROP(siteIdentification);

} // namespace SMS_SiteToSiteID_a


//----------------------------------------------------------------------------
// SMS_SiteToSubSite_a : 
// 
// 
// 
DEFINE_CLASS(SMS_SiteToSubSite_a);
namespace SMS_SiteToSubSite_a
{
    DEFINE_PROP(childSite);
    DEFINE_PROP(parentSite);

} // namespace SMS_SiteToSubSite_a


//----------------------------------------------------------------------------
// SMS_SoftwareConversionRules : 
// 
// 
// 
DEFINE_CLASS(SMS_SoftwareConversionRules);
namespace SMS_SoftwareConversionRules
{
    DEFINE_PROP(ConvertType);
    DEFINE_PROP(NewName);
    DEFINE_PROP(OriginalName);
    DEFINE_PROP(RuleId);

} // namespace SMS_SoftwareConversionRules


//----------------------------------------------------------------------------
// SMS_SoftwareProductCompliance : 
// 
// 
// 
DEFINE_CLASS(SMS_SoftwareProductCompliance);
namespace SMS_SoftwareProductCompliance
{
    DEFINE_PROP(Category);
    DEFINE_PROP(Comment);
    DEFINE_PROP(FileName);
    DEFINE_PROP(FileSize);
    DEFINE_PROP(ProdCompany);
    DEFINE_PROP(ProdLang);
    DEFINE_PROP(ProdName);
    DEFINE_PROP(ProdPlatform);
    DEFINE_PROP(ProdRev);
    DEFINE_PROP(ProdVer);
    DEFINE_PROP(RecordID);
    DEFINE_PROP(ResProdLangID);
    DEFINE_PROP(ResProdName);
    DEFINE_PROP(ResProdVer);
    DEFINE_PROP(Source);
    DEFINE_PROP(Type);
    DEFINE_PROP(URL);
    DEFINE_METHOD(Import);
    
    namespace Import
    {
        
        namespace In
        {
            DEFINE_PARAM(ComplianceData);
            DEFINE_PARAM(ReportErrors);
            DEFINE_PARAM(SourceFilter);
            DEFINE_PARAM(TypeFilter);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);
            DEFINE_PARAM(TotalRecordsProcessed);

        } // namespace Out



    } // namespace Import


    DEFINE_METHOD(Export);
    
    namespace Export
    {
        
        namespace In
        {
            DEFINE_PARAM(SourceFilter);
            DEFINE_PARAM(TypeFilter);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ComplianceData);
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace Export


    DEFINE_METHOD(ProcessInBox);
    
    namespace ProcessInBox
    {
        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);
            DEFINE_PARAM(TotalRecordsProcessed);

        } // namespace Out



    } // namespace ProcessInBox


    DEFINE_METHOD(DeleteByQuery);
    
    namespace DeleteByQuery
    {
        
        namespace In
        {
            DEFINE_PARAM(WQLSelect);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace DeleteByQuery



} // namespace SMS_SoftwareProductCompliance


//----------------------------------------------------------------------------
// SMS_ST_NonRecurring : 
// 
// 
// 
DEFINE_CLASS(SMS_ST_NonRecurring);
namespace SMS_ST_NonRecurring
{

} // namespace SMS_ST_NonRecurring


//----------------------------------------------------------------------------
// SMS_ST_RecurInterval : 
// 
// 
// 
DEFINE_CLASS(SMS_ST_RecurInterval);
namespace SMS_ST_RecurInterval
{
    DEFINE_PROP(DaySpan);
    DEFINE_PROP(HourSpan);
    DEFINE_PROP(MinuteSpan);

} // namespace SMS_ST_RecurInterval


//----------------------------------------------------------------------------
// SMS_ST_RecurMonthlyByDate : 
// 
// 
// 
DEFINE_CLASS(SMS_ST_RecurMonthlyByDate);
namespace SMS_ST_RecurMonthlyByDate
{
    DEFINE_PROP(ForNumberOfMonths);
    DEFINE_PROP(MonthDay);

} // namespace SMS_ST_RecurMonthlyByDate


//----------------------------------------------------------------------------
// SMS_ST_RecurMonthlyByWeekday : 
// 
// 
// 
DEFINE_CLASS(SMS_ST_RecurMonthlyByWeekday);
namespace SMS_ST_RecurMonthlyByWeekday
{
    DEFINE_PROP(Day);
    
    namespace Day
    {

        enum tagEnumeration_SMS_ST_RecurMonthlyByWeekday_Day
        {
            ENUM_SUNDAY                                   = 1L,
            ENUM_MONDAY                                   = 2L,
            ENUM_TUESDAY                                  = 3L,
            ENUM_WEDNESDAY                                = 4L,
            ENUM_THURSDAY                                 = 5L,
            ENUM_FRIDAY                                   = 6L,
            ENUM_SATURDAY                                 = 7L
        };
    
    } // namespace Day


    DEFINE_PROP(ForNumberOfMonths);
    DEFINE_PROP(WeekOrder);
    
    namespace WeekOrder
    {

        enum tagEnumeration_SMS_ST_RecurMonthlyByWeekday_WeekOrder
        {
            ENUM_LAST                                     = 0L,
            ENUM_FIRST                                    = 1L,
            ENUM_SECOND                                   = 2L,
            ENUM_THIRD                                    = 3L,
            ENUM_FOURTH                                   = 4L
        };
    
    } // namespace WeekOrder



} // namespace SMS_ST_RecurMonthlyByWeekday


//----------------------------------------------------------------------------
// SMS_ST_RecurWeekly : 
// 
// 
// 
DEFINE_CLASS(SMS_ST_RecurWeekly);
namespace SMS_ST_RecurWeekly
{
    DEFINE_PROP(Day);
    
    namespace Day
    {

        enum tagEnumeration_SMS_ST_RecurWeekly_Day
        {
            ENUM_SUNDAY                                   = 1L,
            ENUM_MONDAY                                   = 2L,
            ENUM_TUESDAY                                  = 3L,
            ENUM_WEDNESDAY                                = 4L,
            ENUM_THURSDAY                                 = 5L,
            ENUM_FRIDAY                                   = 6L,
            ENUM_SATURDAY                                 = 7L
        };
    
    } // namespace Day


    DEFINE_PROP(ForNumberOfWeeks);

} // namespace SMS_ST_RecurWeekly


//----------------------------------------------------------------------------
// SMS_StatMsgAttributes : 
// 
// 
// 
DEFINE_CLASS(SMS_StatMsgAttributes);
namespace SMS_StatMsgAttributes
{
    DEFINE_PROP(AttributeID);
    
    namespace AttributeID
    {

        enum tagEnumeration_SMS_StatMsgAttributes_AttributeID
        {
            ENUM_PackageID                                = 400L,
            ENUM_AdvertisementID                          = 401L,
            ENUM_CollectionID                             = 402L,
            ENUM_UserName                                 = 403L,
            ENUM_DistributionPoint                        = 404L
        };
    
    } // namespace AttributeID


    DEFINE_PROP(AttributeTime);
    DEFINE_PROP(AttributeValue);
    DEFINE_PROP(RecordID);

} // namespace SMS_StatMsgAttributes


//----------------------------------------------------------------------------
// SMS_StatMsgInsStrings : 
// 
// 
// 
DEFINE_CLASS(SMS_StatMsgInsStrings);
namespace SMS_StatMsgInsStrings
{
    DEFINE_PROP(InsStrIndex);
    DEFINE_PROP(InsStrValue);
    DEFINE_PROP(RecordID);

} // namespace SMS_StatMsgInsStrings


//----------------------------------------------------------------------------
// SMS_StatMsgModuleNames : 
// 
// 
// 
DEFINE_CLASS(SMS_StatMsgModuleNames);
namespace SMS_StatMsgModuleNames
{
    DEFINE_PROP(ModuleName);
    DEFINE_PROP(MsgDLLName);

} // namespace SMS_StatMsgModuleNames


//----------------------------------------------------------------------------
// SMS_StatusMessage : 
// 
// 
// 
DEFINE_CLASS(SMS_StatusMessage);
namespace SMS_StatusMessage
{
    DEFINE_PROP(Component);
    DEFINE_PROP(MachineName);
    DEFINE_PROP(MessageID);
    DEFINE_PROP(MessageType);
    
    namespace MessageType
    {

        enum tagEnumeration_SMS_StatusMessage_MessageType
        {
            ENUM_Milestone                                = 256L,
            ENUM_Detail                                   = 512L,
            ENUM_Audit                                    = 768L,
            ENUM_NTEvent                                  = 1024L
        };
    
    } // namespace MessageType


    DEFINE_PROP(ModuleName);
    DEFINE_PROP(PerClient);
    
    namespace PerClient
    {

        enum tagEnumeration_SMS_StatusMessage_PerClient
        {
            ENUM_False                                    = 0L,
            ENUM_True                                     = 2L
        };
    
    } // namespace PerClient


    DEFINE_PROP(ProcessID);
    DEFINE_PROP(RecordID);
    DEFINE_PROP(ReportFunction);
    
    namespace ReportFunction
    {

        enum tagEnumeration_SMS_StatusMessage_ReportFunction
        {
            ENUM_Report                                   = 0L,
            ENUM_BeginTransaction                         = 16L,
            ENUM_CommitSuccessfulTransaction              = 32L,
            ENUM_CommitFailedTransaction                  = 48L,
            ENUM_RollbackTransaction                      = 64L,
            ENUM_ReportEX                                 = 80L
        };
    
    } // namespace ReportFunction


    DEFINE_PROP(Severity);
    
    namespace Severity
    {

        enum tagEnumeration_SMS_StatusMessage_Severity
        {
            ENUM_Informational                            = 0x40000000L,
            ENUM_Warning                                  = 0x80000000L,
            ENUM_Error                                    = 0xC0000000L
        };
    
    } // namespace Severity


    DEFINE_PROP(SiteCode);
    DEFINE_PROP(SuccessfulTransaction);
    
    namespace SuccessfulTransaction
    {

        enum tagEnumeration_SMS_StatusMessage_SuccessfulTransaction
        {
            ENUM_Failed                                   = 0L,
            ENUM_Successful                               = 8L
        };
    
    } // namespace SuccessfulTransaction


    DEFINE_PROP(ThreadID);
    DEFINE_PROP(Time);
    DEFINE_PROP(TopLevelSiteCode);
    DEFINE_PROP(Transaction);
    
    namespace Transaction
    {

        enum tagEnumeration_SMS_StatusMessage_Transaction
        {
            ENUM_False                                    = 0L,
            ENUM_True                                     = 4L
        };
    
    } // namespace Transaction


    DEFINE_PROP(Win32Error);
    DEFINE_METHOD(RaiseRawStatusMsg);
    
    namespace RaiseRawStatusMsg
    {
        
        namespace In
        {
            DEFINE_PARAM(AttrIDs);
            DEFINE_PARAM(AttrValues);
            DEFINE_PARAM(InsStrings);
            DEFINE_PARAM(MessageID);
            DEFINE_PARAM(MessageType);

            namespace MessageType
            {

                enum tagEnumeration_SMS_StatusMessage_MessageType
                {
                    ENUM_Milestone                                = 256L,
                    ENUM_Detail                                   = 512L,
                    ENUM_Audit                                    = 768L,
                    ENUM_NTEvent                                  = 1024L
                };

            } // namespace MessageType


            DEFINE_PARAM(ModuleName);
            DEFINE_PARAM(ProcessID);
            DEFINE_PARAM(ThreadID);
            DEFINE_PARAM(Time);
            DEFINE_PARAM(TopLevelSiteCode);
            DEFINE_PARAM(Win32Error);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace RaiseRawStatusMsg


    DEFINE_METHOD(RaiseErrorStatusMsg);
    
    namespace RaiseErrorStatusMsg
    {
        
        namespace In
        {
            DEFINE_PARAM(AttrIDs);
            DEFINE_PARAM(AttrValues);
            DEFINE_PARAM(MessageText);
            DEFINE_PARAM(MessageType);

            namespace MessageType
            {

                enum tagEnumeration_SMS_StatusMessage_MessageType
                {
                    ENUM_Milestone                                = 256L,
                    ENUM_Detail                                   = 512L,
                    ENUM_Audit                                    = 768L,
                    ENUM_NTEvent                                  = 1024L
                };

            } // namespace MessageType


            DEFINE_PARAM(ProcessID);
            DEFINE_PARAM(ThreadID);
            DEFINE_PARAM(Time);
            DEFINE_PARAM(TopLevelSiteCode);
            DEFINE_PARAM(Win32Error);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace RaiseErrorStatusMsg


    DEFINE_METHOD(RaiseWarningStatusMsg);
    
    namespace RaiseWarningStatusMsg
    {
        
        namespace In
        {
            DEFINE_PARAM(AttrIDs);
            DEFINE_PARAM(AttrValues);
            DEFINE_PARAM(MessageText);
            DEFINE_PARAM(MessageType);

            namespace MessageType
            {

                enum tagEnumeration_SMS_StatusMessage_MessageType
                {
                    ENUM_Milestone                                = 256L,
                    ENUM_Detail                                   = 512L,
                    ENUM_Audit                                    = 768L,
                    ENUM_NTEvent                                  = 1024L
                };

            } // namespace MessageType


            DEFINE_PARAM(ProcessID);
            DEFINE_PARAM(ThreadID);
            DEFINE_PARAM(Time);
            DEFINE_PARAM(TopLevelSiteCode);
            DEFINE_PARAM(Win32Error);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace RaiseWarningStatusMsg


    DEFINE_METHOD(RaiseInformationalStatusMsg);
    
    namespace RaiseInformationalStatusMsg
    {
        
        namespace In
        {
            DEFINE_PARAM(AttrIDs);
            DEFINE_PARAM(AttrValues);
            DEFINE_PARAM(MessageText);
            DEFINE_PARAM(MessageType);

            namespace MessageType
            {

                enum tagEnumeration_SMS_StatusMessage_MessageType
                {
                    ENUM_Milestone                                = 256L,
                    ENUM_Detail                                   = 512L,
                    ENUM_Audit                                    = 768L,
                    ENUM_NTEvent                                  = 1024L
                };

            } // namespace MessageType


            DEFINE_PARAM(ProcessID);
            DEFINE_PARAM(ThreadID);
            DEFINE_PARAM(Time);
            DEFINE_PARAM(TopLevelSiteCode);
            DEFINE_PARAM(Win32Error);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace RaiseInformationalStatusMsg


    DEFINE_METHOD(DeleteByID);
    
    namespace DeleteByID
    {
        
        namespace In
        {
            DEFINE_PARAM(RecordIDs);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace DeleteByID


    DEFINE_METHOD(DeleteByQuery);
    
    namespace DeleteByQuery
    {
        
        namespace In
        {
            DEFINE_PARAM(WQLSelect);

        } // namespace In


        
        namespace Out
        {
            DEFINE_PARAM(ReturnValue);

        } // namespace Out



    } // namespace DeleteByQuery



} // namespace SMS_StatusMessage


//----------------------------------------------------------------------------
// SMS_SummarizerRootStatus : 
// 
// 
// 
DEFINE_CLASS(SMS_SummarizerRootStatus);
namespace SMS_SummarizerRootStatus
{
    DEFINE_PROP(Status);
    
    namespace Status
    {

        enum tagEnumeration_SMS_SummarizerRootStatus_Status
        {
            ENUM_GREEN                                    = 0L,
            ENUM_YELLOW                                   = 1L,
            ENUM_RED                                      = 2L
        };
    
    } // namespace Status



} // namespace SMS_SummarizerRootStatus


//----------------------------------------------------------------------------
// SMS_SummarizerSiteStatus : 
// 
// 
// 
DEFINE_CLASS(SMS_SummarizerSiteStatus);
namespace SMS_SummarizerSiteStatus
{
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(Status);
    
    namespace Status
    {

        enum tagEnumeration_SMS_SummarizerSiteStatus_Status
        {
            ENUM_GREEN                                    = 0L,
            ENUM_YELLOW                                   = 1L,
            ENUM_RED                                      = 2L
        };
    
    } // namespace Status



} // namespace SMS_SummarizerSiteStatus


//----------------------------------------------------------------------------
// SMS_SummarizerStatus : 
// 
// 
// 
DEFINE_CLASS(SMS_SummarizerStatus);
namespace SMS_SummarizerStatus
{
    DEFINE_PROP(GUID_ID);
    DEFINE_PROP(MessageDLL);
    DEFINE_PROP(MessageID);
    DEFINE_PROP(SiteCode);
    DEFINE_PROP(Status);
    
    namespace Status
    {

        enum tagEnumeration_SMS_SummarizerStatus_Status
        {
            ENUM_GREEN                                    = 0L,
            ENUM_YELLOW                                   = 1L,
            ENUM_RED                                      = 2L
        };
    
    } // namespace Status


    DEFINE_PROP(Updated);

} // namespace SMS_SummarizerStatus


//----------------------------------------------------------------------------
// SMS_SupportedPlatforms : 
// 
// 
// 
DEFINE_CLASS(SMS_SupportedPlatforms);
namespace SMS_SupportedPlatforms
{
    DEFINE_PROP(DisplayText);
    DEFINE_PROP(OSMaxVersion);
    DEFINE_PROP(OSMinVersion);
    DEFINE_PROP(OSName);
    DEFINE_PROP(OSPlatform);
    DEFINE_PROP(ResourceDll);
    DEFINE_PROP(StringId);

} // namespace SMS_SupportedPlatforms


//----------------------------------------------------------------------------
// SMS_SystemResourceList : 
// 
// 
// 
DEFINE_CLASS(SMS_SystemResourceList);
namespace SMS_SystemResourceList
{
    DEFINE_PROP(NALPath);
    DEFINE_PROP(ResourceType);
    DEFINE_PROP(RoleName);
    DEFINE_PROP(ServerName);
    DEFINE_PROP(SiteCode);

} // namespace SMS_SystemResourceList


//----------------------------------------------------------------------------
// SMS_UINAL_ResourceInfo : 
// 
// 
// 
DEFINE_CLASS(SMS_UINAL_ResourceInfo);
namespace SMS_UINAL_ResourceInfo
{
    DEFINE_PROP(ChmFile);
    DEFINE_PROP(ConfigUnit);
    DEFINE_PROP(DisplayNameIconID);
    DEFINE_PROP(DisplayNameResID);
    DEFINE_PROP(GUID);
    DEFINE_PROP(HtmFile);
    DEFINE_PROP(ResourceDLL);
    DEFINE_PROP(ResourceType);

} // namespace SMS_UINAL_ResourceInfo


//----------------------------------------------------------------------------
// SMS_UserClassPermissionNames : 
// 
// 
// 
DEFINE_CLASS(SMS_UserClassPermissionNames);
namespace SMS_UserClassPermissionNames
{
    DEFINE_PROP(ObjectKey);
    DEFINE_PROP(Permission);
    DEFINE_PROP(PermissionName);
    DEFINE_PROP(UserName);

} // namespace SMS_UserClassPermissionNames


//----------------------------------------------------------------------------
// SMS_UserClassPermissions : 
// 
// 
// 
DEFINE_CLASS(SMS_UserClassPermissions);
namespace SMS_UserClassPermissions
{
    DEFINE_PROP(ClassPermissions);
    
    namespace ClassPermissions
    {

        enum tagBitField_SMS_UserClassPermissions_ClassPermissions
        {
            BIT_READ                                     = 0x00000001,
            BIT_MODIFY                                   = 0x00000002,
            BIT_DELETE                                   = 0x00000004,
            BIT_DISTRIBUTE                               = 0x00000008,
            BIT_CREATE_CHILD                             = 0x00000010,
            BIT_REMOTE_CONTROL                           = 0x00000020,
            BIT_ADVERTISE                                = 0x00000040,
            BIT_MODIFY_RESOURCE                          = 0x00000080,
            BIT_ADMINISTER                               = 0x00000100,
            BIT_DELETE_RESOURCE                          = 0x00000200,
            BIT_CREATE                                   = 0x00000400,
            BIT_VIEW_COLL_FILE                           = 0x00000800,
            BIT_READ_RESOURCE                            = 0x00001000
        };
    
    } // namespace ClassPermissions


    DEFINE_PROP(ObjectKey);
    DEFINE_PROP(UserName);

} // namespace SMS_UserClassPermissions


//----------------------------------------------------------------------------
// SMS_UserInstancePermissionNames : 
// 
// 
// 
DEFINE_CLASS(SMS_UserInstancePermissionNames);
namespace SMS_UserInstancePermissionNames
{
    DEFINE_PROP(InstanceKey);
    DEFINE_PROP(ObjectKey);
    DEFINE_PROP(Permission);
    DEFINE_PROP(PermissionName);
    DEFINE_PROP(UserName);

} // namespace SMS_UserInstancePermissionNames


//----------------------------------------------------------------------------
// SMS_UserInstancePermissions : 
// 
// 
// 
DEFINE_CLASS(SMS_UserInstancePermissions);
namespace SMS_UserInstancePermissions
{
    DEFINE_PROP(InstanceKey);
    DEFINE_PROP(InstancePermissions);
    
    namespace InstancePermissions
    {

        enum tagBitField_SMS_UserInstancePermissions_InstancePermissions
        {
            BIT_READ                                     = 0x00000001,
            BIT_MODIFY                                   = 0x00000002,
            BIT_DELETE                                   = 0x00000004,
            BIT_DISTRIBUTE                               = 0x00000008,
            BIT_CREATE_CHILD                             = 0x00000010,
            BIT_REMOTE_CONTROL                           = 0x00000020,
            BIT_ADVERTISE                                = 0x00000040,
            BIT_MODIFY_RESOURCE                          = 0x00000080,
            BIT_ADMINISTER                               = 0x00000100,
            BIT_DELETE_RESOURCE                          = 0x00000200,
            BIT_CREATE                                   = 0x00000400,
            BIT_VIEW_COLL_FILE                           = 0x00000800,
            BIT_READ_RESOURCE                            = 0x00001000
        };
    
    } // namespace InstancePermissions


    DEFINE_PROP(ObjectKey);
    DEFINE_PROP(UserName);

} // namespace SMS_UserInstancePermissions


} // namespace SMSSDK


#endif //__SMS_SDK_NAMESPACE_ENUMS
#pragma option pop /*P_O_Pop*/
