/***************************************************************************

    MSM6242 Real Time Clock

***************************************************************************/

#include "machine/msm6242.h"
#include <time.h>

#ifdef KAILLERA
extern void *record;
extern void *playback;
extern int kPlay;
#endif /* KAILLERA */

READ8_HANDLER( msm6242_r )
{
	time_t ltime;
	struct tm *today;
#ifdef KAILLERA
	struct tm static_rtc;

	if( record != 0 || playback != 0 || kPlay )
	{
		static_rtc.tm_sec  = 0;
		static_rtc.tm_min  = 0;
		static_rtc.tm_hour = 0;
		static_rtc.tm_mday = 27;	/* 27 */
		static_rtc.tm_mon  = 3;		/* April */
		static_rtc.tm_year = 101;	/* 2001 */
		static_rtc.tm_wday = 5;		/* Fri */

		today = &static_rtc;
	}
	else
#endif /* KAILLERA */
	{
		time(&ltime);
		today = localtime(&ltime);
	}

	switch (offset)
	{
		case 0x0: return today->tm_sec%10;
		case 0x1: return today->tm_sec/10;
		case 0x2: return today->tm_min%10;
		case 0x3: return today->tm_min/10;
		case 0x4: return today->tm_hour%10;
		case 0x5: return today->tm_hour/10;
		case 0x6: return today->tm_mday%10;
		case 0x7: return today->tm_mday/10;
		case 0x8: return (today->tm_mon+1)%10;
		case 0x9: return (today->tm_mon+1)/10;
		case 0xa: return today->tm_year%10;
		case 0xb: return (today->tm_year%100)/10;
		case 0xc: return today->tm_wday%10;
		case 0xd:	return 1;
		case 0xe:	return 6;
		case 0xf:	return 4;
	}

	logerror("%04x: MSM6242 unmapped offset %02X read\n",activecpu_get_pc(),offset);
	return 0;
}

WRITE8_HANDLER( msm6242_w )
{
	switch(offset)
	{
		case 0x0:	return;
		case 0x1:	return;
		case 0x2:	return;
		case 0x3:	return;
		case 0x4:	return;
		case 0x5:	return;
		case 0x6:	return;
		case 0x7:	return;
		case 0x8:	return;
		case 0x9:	return;
		case 0xa:	return;
		case 0xb:	return;
		case 0xc:	return;
		case 0xd:	return;
		case 0xe:	return;
		case 0xf:	return;
	}
	logerror("%04x: MSM6242 unmapped offset %02X written with %02X\n",activecpu_get_pc(),offset,data);
}


READ16_HANDLER( msm6242_lsb_r )
{
	return msm6242_r(offset);
}

WRITE16_HANDLER( msm6242_lsb_w )
{
	if (ACCESSING_LSB)
		msm6242_w(offset,data);
}
