/*
    TODO:
    - bonkadv_mcu_43: extract data from MCU (dumped eeprom data for now)
    - bloodwar: verify all extracted data against real board (WIP)
*/

/***************************************************************************

    TOYBOX MCU data for Bonk's Adventure

***************************************************************************/

// notes based on test programs results, verified on PCB:
// - bonkadv_mcu_4_30 is the only cmd that ouputs an odd (655) number of bytes
// - bonkadv_mcu_4_33: the 32 'zeroed' bytes every 64 bytes are effectively written by the MCU

// MCU executed command: 4300 0100 - factory settings
// this command is issued whenever the nvram settings are corrupted
// the MCU writes directly to NVRAM
static UINT16 bonkadv_mcu_43[] = {
	0x8BE0,0x8E71,0x0102,0x0102,0x0300,0x010C,0x0202,0x0202,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0030,0x0020,0x4F6B,0x0305,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0082,0x6F82,0x628C,0xB490,0x6CAB
};

// MCU executed command: 0400 0E00 0034 - code
/*
200E00: 7071    moveq   #$71, D0
200E02: 7273    moveq   #$73, D1
200E04: 7475    moveq   #$75, D2
200E06: 7677    moveq   #$77, D3
200E08: 7879    moveq   #$79, D4
200E0A: 7A7B    moveq   #$7b, D5
200E0C: 7C7D    moveq   #$7d, D6
200E0E: 7E7F    moveq   #$7f, D7
200E10: 4E75    rts
*/
static UINT16 bonkadv_mcu_4_34[] = {
	0x7071,0x7273,0x7475,0x7677,0x7879,0x7a7b,0x7c7d,0x7e7f,
	0x4e75
};
// MCU executed command: 0400 0180 0032 - 128 bytes at $200180
static UINT16 bonkadv_mcu_4_32[] = {
	0x00cc,0xcc0c,0xc0c0,0xc080,0x0484,0xb6a6,0x0404,0x80c0,
	0x80b1,0xb1a1,0xa1b2,0xa2b3,0xb3a3,0xa3b1,0xb1b1,0xb1c0,
	0xc0a1,0xa1a1,0xa1b2,0xb2a2,0xa290,0x9090,0xb9b9,0xa9a9,
	0xbaaa,0xbbbb,0xabab,0xb9b9,0xb9b9,0xc8c8,0xa9a9,0xa9a9,
	0xbaba,0xaaaa,0x9898,0x98b9,0xb9a9,0xa9ba,0xaabb,0xbbab,
	0xabb9,0xb9b9,0xb9c8,0xc8a9,0xa9a9,0xa9ba,0xbaaa,0xaa98,
	0x9898,0xb1b1,0xa1a1,0xb2a2,0xb3b3,0xa3a3,0xb1b1,0xb1b1,
	0xc0c0,0xa1a1,0xa1a1,0xb2b2,0xa2a2,0x9090,0x9000,0x0000
};
// MCU executed command: 0400 0280 0031 - 112 bytes at $200280
static UINT16 bonkadv_mcu_4_31[] = {
	0x1013,0x1411,0x1216,0x1519,0x1a17,0x1824,0x2322,0x211f,
	0x201e,0x1d1c,0x1b27,0x2825,0x2629,0x2a2b,0x2e2f,0x2c2d,
	0x3130,0x3435,0x3233,0x3f3e,0x3d3c,0x3a3b,0x3938,0x3736,
	0x4243,0x4041,0x4445,0x4649,0x4a47,0x484c,0x4b4f,0x504d,
	0x4e5a,0x5958,0x5755,0x5654,0x5352,0x515d,0x5e5b,0x5c5f,
	0x6061,0x6465,0x6263,0x6766,0x6a6b,0x6869,0x7574,0x7372,
	0x7071,0x6f6e,0x6d6c,0x7879,0x7677,0x7a7b,0x7c7d,0x7e7f
};
// MCU executed command: 0400 0E50 0030 - 655 bytes at $200E50 (656 here)
static UINT16 bonkadv_mcu_4_30[] = {
	0x8c00,0x9700,0xa000,0xa700,0xb200,0xb700,0xc000,0xcc00,
	0xd600,0xdf00,0xef00,0xf500,0xfd00,0x0501,0x0b01,0x1801,
	0x1e01,0x2901,0x3101,0x3701,0x4101,0x4901,0x0b01,0x5d01,
	0xa700,0xb200,0x6c01,0x8101,0xb200,0x8101,0x8101,0x8101,
	0x8101,0x8101,0x8101,0x8101,0x8101,0x8101,0x8101,0x8101,
	0x8101,0x8101,0x8101,0x8101,0x8101,0x8101,0x8101,0x8101,
	0x8101,0x8101,0x8101,0x8101,0x8101,0x8101,0x8101,0x2e02,
	0x3602,0x3d02,0x4102,0x4f02,0x5502,0x5502,0x5f02,0x6402,
	0x6d02,0x7302,0x7802,0x7d02,0x8302,0x8a02,0x0165,0x712b,
	0x57fe,0x57a2,0xff00,0x0003,0x7c3a,0x436c,0x66ff,0x0000,
	0x026c,0x6d43,0xff00,0x0000,0x74a5,0x8373,0x3599,0x9fff,

	0x0000,0x074a,0xff00,0x0002,0x8788,0x3331,0x32ff,0x0000,
	0x0276,0x8c71,0x2d8c,0xfe12,0x8cff,0x0000,0x0171,0x0d29,
	0xfe0d,0x29ff,0x0000,0x0559,0x5a5b,0x8a8b,0xff00,0x0003,
	0x0d0e,0x576a,0x641e,0xfe0d,0x0efe,0x64a3,0xff00,0x0006,
	0x0262,0xff00,0x0007,0x3e3f,0x7a7b,0xff00,0x0007,0x7584,
	0x4c53,0xff00,0x0001,0x6645,0xff00,0x0007,0x0d18,0x2984,
	0x5384,0xfe0d,0x29ff,0x0000,0x0457,0x5cff,0x0000,0x0751,
	0x5202,0x45fe,0x4575,0xff00,0x0000,0x191a,0x1b6e,0xff00,
	0x0006,0x3472,0xff00,0x0000,0x6569,0x090f,0x8b23,0xff00,
	0x0004,0x3b3c,0x3d79,0xff00,0x0080,0x770a,0x8176,0x2a65,
	0x64fe,0x7776,0xfe2a,0x76fe,0x650a,0xff00,0x0000,0x1011,
	0x1226,0x2728,0xa655,0x940f,0x68ff,0x0000,0x8045,0x6477,
	0x0a81,0x762a,0x65fe,0x7776,0xfe2a,0x76fe,0x650a,0xff00,
	0x0000,0x166b,0xff00,0x0007,0x1e30,0x39ff,0x0000,0x0345,
	0x3a77,0x7843,0x4647,0xff00,0x0000,0x7335,0x8399,0x9fff,
	0x0000,0x0237,0x38ff,0x0000,0x0044,0x303b,0xff00,0x0000,

	0x7d7e,0x7fa1,0x0aff,0x0000,0x0070,0xff00,0x0000,0x3e3f,
	0x7a7b,0x6180,0x89a4,0xff00,0x0006,0x86a5,0x4f42,0xff00,
	0x0000,0x1011,0x1255,0x0f68,0xff00,0x0002,0x8788,0x4033,
	0xff00,0x0005,0x650f,0xff00,0x0008,0x9596,0x9ba7,0xff00,
	0x0000,0x4849,0x82ff,0x0000,0x022e,0x2f30,0xff00,0x0001,
	0x7778,0x5826,0x2728,0xa6ff,0x0000,0x0813,0x1402,0x51ff,
	0x0000,0x072e,0x5c5d,0xff00,0x0006,0x57ff,0x0000,0x0230,
	0x391e,0x65fe,0x6530,0xff00,0x0000,0x4bff,0x0000,0x008e,
	0x8f90,0x91ff,0x0000,0x0092,0x9d17,0xff00,0x0000,0xff00,
	0x0000,0x8d9b,0xa77d,0x7e7f,0xa10a,0x9596,0xff00,0x0001,
	0x1993,0xff00,0x0000,0x67ff,0x0000,0x0067,0xff00,0x0000,
	0x27ff,0x0000,0x0390,0x8e23,0x978b,0xff00,0x0000,0x1d9e,
	0xff00,0x0007,0x3bff,0x0000,0x001d,0xff00,0x0000,0x8e90,
	0xff00,0x0005,0x2495,0x96ff,0x0000,0x009a,0xff00,0x0000
};
// MCU executed command: 0400 0400 0033 - 2560 bytes at $200400
static UINT16 bonkadv_mcu_4_33[] = {
	0x00a4,0x0001,0x00a5,0x005a,0x00a6,0x0074,0x00a7,0x009b,
	0x00a8,0x00d0,0x00a9,0x00fe,0x00aa,0x015d,0x00ab,0x01b0,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0001,0x0002,0x0019,0x005b,0x0022,0x0075,0x002d,0x009c,
	0x0041,0x00d1,0x004e,0x00ff,0x0060,0x015f,0x0072,0x01b1,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0002,0x0008,0x001a,0x0061,0x0023,0x007b,0x002e,0x00a2,
	0x0042,0x00d7,0x004f,0x0107,0x0061,0x0165,0x0073,0x01b7,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x000a,0x0000,0x0063,0x0000,0x007d,0x0000,0x00a4,
	0x0000,0x00d9,0x0000,0x0109,0x0000,0x0167,0x0000,0x01b9,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

	0x0003,0x000b,0x001b,0x0064,0x0024,0x007e,0x002f,0x00a5,
	0x0043,0x00da,0x0050,0x010a,0x0062,0x0168,0x0074,0x01ba,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x000c,0x0000,0x0065,0x0000,0x007f,0x0000,0x00a6,
	0x0000,0x00db,0x0000,0x010b,0x0000,0x0169,0x0000,0x01bb,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0004,0x0008,0x001c,0x0061,0x0025,0x007b,0x0030,0x00a2,
	0x0044,0x00d7,0x0051,0x0107,0x0063,0x0165,0x0075,0x01b7,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0005,0x000d,0x001d,0x0066,0x0025,0x007b,0x0031,0x00a7,
	0x0045,0x00dc,0x0051,0x0107,0x0063,0x0165,0x0075,0x01b7,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

	0x0000,0x0017,0x0000,0x0069,0x0000,0x0089,0x0000,0x00af,
	0x0000,0x00df,0x0000,0x0115,0x0000,0x0173,0x0000,0x01c5,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0009,0x0015,0x001e,0x0067,0x0029,0x0087,0x0034,0x00ad,
	0x0046,0x00dd,0x0055,0x0113,0x0067,0x0171,0x0079,0x01c3,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0006,0x000e,0x0006,0x000e,0x0026,0x0080,0x0006,0x000e,
	0x0000,0x0000,0x0052,0x010c,0x0064,0x016a,0x0076,0x01bc,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0007,0x0010,0x0007,0x0010,0x0027,0x0082,0x0032,0x00a8,
	0x0000,0x0000,0x0053,0x010e,0x0065,0x016c,0x0077,0x01be,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

	0x0000,0x0013,0x0000,0x0013,0x0000,0x0085,0x0000,0x00ab,
	0x0000,0x0000,0x0000,0x0111,0x0000,0x016f,0x0000,0x01c1,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0008,0x0014,0x0008,0x0014,0x0028,0x0086,0x0033,0x00ac,
	0x0000,0x0000,0x0054,0x0112,0x0066,0x0170,0x0078,0x01c2,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0018,0x0000,0x006a,0x0000,0x008a,0x0000,0x00b0,
	0x0000,0x00e0,0x0000,0x0116,0x0000,0x0174,0x0000,0x01c6,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x000c,0x0000,0x0065,0x0000,0x007f,0x0000,0x00a6,
	0x0000,0x00db,0x0000,0x010b,0x0000,0x0169,0x0000,0x01bb,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

	0x000a,0x0019,0x001f,0x006b,0x002a,0x008b,0x0035,0x00b1,
	0x0047,0x00e1,0x0056,0x0117,0x0068,0x0175,0x007a,0x01c7,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x000b,0x0019,0x0020,0x006b,0x002b,0x008b,0x0036,0x00b1,
	0x0048,0x00e1,0x0057,0x0117,0x0069,0x0175,0x007a,0x01c7,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0015,0x003e,0x0015,0x003e,0x0099,0x0095,0x0015,0x003e,
	0x0000,0x0000,0x009e,0x013a,0x006d,0x018f,0x007e,0x01dc,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x000c,0x001d,0x000c,0x001d,0x000c,0x001d,0x000c,0x001d,
	0x0049,0x00e5,0x0058,0x011b,0x006a,0x0179,0x007b,0x01c9,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

	0x0000,0x001f,0x0000,0x001f,0x0000,0x001f,0x0000,0x001f,
	0x0000,0x00e7,0x0000,0x011d,0x0000,0x017b,0x0000,0x01cb,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x000d,0x0020,0x0021,0x006f,0x002c,0x008f,0x0037,0x00b5,
	0x004a,0x00e8,0x0059,0x011e,0x006b,0x017c,0x007c,0x01cc,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0022,0x0000,0x0071,0x0000,0x0091,0x0000,0x00b7,
	0x0000,0x00ea,0x0000,0x0120,0x0000,0x017e,0x0000,0x01ce,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0014,0x003b,0x0014,0x003b,0x005d,0x0092,0x0014,0x003b,
	0x0014,0x003b,0x009d,0x0137,0x00a0,0x018c,0x00a1,0x01d9,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

	0x0012,0x0036,0x0012,0x0036,0x0012,0x0036,0x0012,0x0036,
	0x008a,0x00e5,0x00be,0x013c,0x006c,0x0184,0x007d,0x01d1,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0013,0x0038,0x0013,0x0038,0x0013,0x0038,0x0013,0x0038,
	0x008a,0x00e5,0x00bf,0x013d,0x006c,0x0184,0x007d,0x01d1,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0038,0x00ba,0x0038,0x00ba,0x0038,0x00ba,0x0038,0x00ba,
	0x0038,0x00ba,0x00a2,0x0128,0x006e,0x019c,0x007f,0x01e7,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x005c,0x014d,0x005c,0x014d,0x005c,0x014d,0x005c,0x014d,
	0x0000,0x0000,0x009c,0x0124,0x0071,0x01a5,0x0082,0x01f0,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

	0x005b,0x014d,0x005b,0x014d,0x005b,0x014d,0x005b,0x014d,
	0x0000,0x0000,0x009b,0x0124,0x0070,0x01a1,0x0081,0x01ec,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0044,0x0000,0x0044,0x0000,0x0044,0x0000,0x0044,
	0x0000,0x00db,0x0000,0x010b,0x0000,0x0169,0x0000,0x01bb,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0018,0x0045,0x0018,0x0045,0x0018,0x0045,0x0018,0x0045,
	0x0044,0x00d7,0x0051,0x0107,0x0063,0x0165,0x0075,0x01b7,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x008b,0x000e,0x008b,0x000e,0x008c,0x0080,0x008b,0x000e,
	0x0000,0x0000,0x008d,0x010c,0x008e,0x016a,0x008f,0x01bc,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

	0x0090,0x0010,0x0090,0x0010,0x0091,0x0082,0x0092,0x00a8,
	0x0000,0x0000,0x0093,0x010e,0x0094,0x016c,0x0095,0x01be,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0096,0x003e,0x0096,0x003e,0x009a,0x0095,0x0096,0x003e,
	0x0000,0x0000,0x009f,0x013a,0x0097,0x018f,0x0098,0x01dc,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0049,0x0000,0x0069,0x0000,0x0098,0x0000,0x00af,
	0x0000,0x00df,0x0000,0x0145,0x0000,0x0173,0x0000,0x01c5,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x005e,0x0048,0x005f,0x0068,0x006f,0x0097,0x0080,0x00ae,
	0x00ac,0x00de,0x00ad,0x0144,0x00ae,0x0172,0x00af,0x01c4,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,

	0x004b,0x00ed,0x004b,0x00ed,0x004b,0x00ed,0x004b,0x00ed,
	0x004b,0x00ed,0x00b0,0x012b,0x00b6,0x0186,0x00ba,0x01d3,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0087,0x00f2,0x0087,0x00f2,0x0087,0x00f2,0x0087,0x00f2,
	0x0087,0x00f2,0x00b3,0x0130,0x00b8,0x018b,0x00bc,0x01d8,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x00c1,0x0050,0x00c1,0x0050,0x00c1,0x0050,0x00c1,0x0050,
	0x00c1,0x0050,0x00c3,0x0148,0x00c5,0x019a,0x00c7,0x01e5,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x00c2,0x0050,0x00c2,0x0050,0x00c2,0x0050,0x00c2,0x0050,
	0x00c2,0x0050,0x00c4,0x0148,0x00c6,0x019a,0x00c8,0x01e5,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};
// dynamic, per-level (29), in level order
// PC=078896 : MCU executed command: 0400 0300 00xx - xx = subcmd
static UINT16 bonkadv_mcu_4_00[] = { 0x0000,0x04C0,0x0000,0x0100,0x0600,0x0100 };
static UINT16 bonkadv_mcu_4_02[] = { 0x0000,0x0760,0x0000,0x0100,0x0270,0x0100,0x0320,0x01B0,
                                     0x0460,0x01B0,0x0510,0x0100,0x05E0,0x0100,0x0620,0x0120,
                                     0x08A0,0x0120 };
static UINT16 bonkadv_mcu_4_01[] = { 0x0000,0x0670,0x0000,0x0100,0x0200,0x0100,0x02E0,0x0090,
                                     0x0400,0x0090,0x04E0,0x0100,0x07B0,0x0100 };
static UINT16 bonkadv_mcu_4_05[] = { 0x0000,0x0610,0x0000,0x0100,0x0750,0x0100 };
static UINT16 bonkadv_mcu_4_07[] = { 0x0000,0x03C0,0x0000,0x0100,0x0500,0x0100 };
static UINT16 bonkadv_mcu_4_06[] = { 0x0000,0x05F0,0x0000,0x0100,0x0730,0x0100 };
static UINT16 bonkadv_mcu_4_09[] = { 0x0000,0x05C0,0x0000,0x0100,0x0700,0x0100 };
static UINT16 bonkadv_mcu_4_0D[] = { 0x0000,0x07A0,0x0000,0x0100,0x08E0,0x0100 };
static UINT16 bonkadv_mcu_4_03[] = { 0x0000,0x0920,0x0000,0x0100,0x0A60,0x0100 };
static UINT16 bonkadv_mcu_4_08[] = { 0x0000,0x0730,0x0000,0x0100,0x0870,0x0100 };
static UINT16 bonkadv_mcu_4_04[] = { 0x0000,0x05C0,0x0000,0x0100,0x0200,0x0100,0x0280,0x00C0,
                                     0x02E0,0x0060,0x03A0,0x0000,0x0700,0x0000 };
static UINT16 bonkadv_mcu_4_0C[] = { 0x0000,0x06E0,0x0000,0x0100,0x0820,0x0100 };
static UINT16 bonkadv_mcu_4_0A[] = { 0x0000,0x05A0,0x0000,0x0100,0x06E0,0x0100 };
static UINT16 bonkadv_mcu_4_0B[] = { 0x0000,0x0470,0x0000,0x0100,0x05B0,0x0100 };
static UINT16 bonkadv_mcu_4_10[] = { 0x0000,0x06C0,0x0000,0x0100,0x03B0,0x0100,0x0460,0x0050,
                                     0x05E0,0x0050,0x0650,0xFFE0,0x0800,0xFFE0 };
static UINT16 bonkadv_mcu_4_0E[] = { 0x0000,0x0630,0x0000,0x0100,0x0770,0x0100 };
static UINT16 bonkadv_mcu_4_13[] = { 0x0000,0x05C0,0x0000,0x0100,0x0700,0x0100 };
static UINT16 bonkadv_mcu_4_0F[] = { 0x0000,0x05C0,0x0000,0x0100,0x0700,0x0100 };
static UINT16 bonkadv_mcu_4_11[] = { 0x0000,0x05C0,0x0000,0x0100,0x0700,0x0100 };
static UINT16 bonkadv_mcu_4_14[] = { 0x0000,0x05C0,0x0000,0x0100,0x0700,0x0100 };
static UINT16 bonkadv_mcu_4_12[] = { 0x0000,0x05C0,0x0000,0x0100,0x0700,0x0100 };
static UINT16 bonkadv_mcu_4_17[] = { 0x0000,0x0520,0x0000,0x0100,0x0660,0x0100 };
static UINT16 bonkadv_mcu_4_1A[] = { 0x0000,0x03C0,0x0000,0x0100,0x0500,0x0100 };
static UINT16 bonkadv_mcu_4_15[] = { 0x0000,0x02C0,0x0000,0x0100,0x0400,0x0100 };
static UINT16 bonkadv_mcu_4_18[] = { 0x0000,0x03C0,0x0000,0x0100,0x0500,0x0100 };
static UINT16 bonkadv_mcu_4_16[] = { 0x0000,0x02F0,0x0000,0x0100,0x0430,0x0100 };
static UINT16 bonkadv_mcu_4_19[] = { 0x0000,0x03A0,0x0000,0x0100,0x04E0,0x0100 };
static UINT16 bonkadv_mcu_4_1B[] = { 0x0000,0x0460,0x0000,0x0100,0x05A0,0x0100 };
static UINT16 bonkadv_mcu_4_1C[] = { 0x0000,0x02C0,0x0000,0x0100,0x0400,0x0100 };


/***************************************************************************

    TOYBOX MCU data for Blood Warrior

***************************************************************************/

// bloodwar MCU writes by 16-bytes block, and data seems to be contiguous?
// unknown data: the last 4 words of a cmd are the 4 firsts of the next one
// palette data: when the negative word is not on a 16-bytes boundary,
//               it is followed by the first bytes of the next palette
// unknown data are followed by tilemap (last tilemap ends with 0xff)
// palette (last ends with: 0x0004,0xce4a,0x0004 ???)
// fighter: order is unclear - cmd 26 is probably the last (ends with 0xff)

// --- unknown data ---
static UINT16 bloodwar_mcu_4_01[] = { 0x00E6,0x00C6,0x00E8,0x00D0,0xFC9A,0x05C0,0x0F00,0x08C0, // Warrior 1
                                      0x0001,0x0120,0x0090,0x021B,0x00B4,0x0094,0x00AC,0x0094 };
static UINT16 bloodwar_mcu_4_02[] = { 0x00B4,0x0094,0x00AC,0x0094,0xFCD2,0x03C0,0x1000,0x0900, // Warrior 2
                                      0x0001,0x0100,0x0080,0x0118,0x00F0,0x00D0,0x00F4,0x00DC };
static UINT16 bloodwar_mcu_4_03[] = { 0x00F0,0x00D0,0x00F4,0x00DC,0xFC90,0x03C0,0x0C00,0x0CC0, // Warrior 3
                                      0x0001,0x0200,0x0100,0x0930,0x00D2,0x00B2,0x00CA,0x00B0 };
static UINT16 bloodwar_mcu_4_04[] = { 0x00D2,0x00B2,0x00CA,0x00B0,0xFCB5,0x05C0,0x1000,0x0C00, // Warrior 4
                                      0x0001,0x0140,0x00A0,0x031E,0x00A0,0x0080,0x00DC,0x00C4 };
static UINT16 bloodwar_mcu_4_05[] = { 0x00A0,0x0080,0x00DC,0x00C4,0xFCA2,0x05C0,0x0AC0,0x0880, // Warrior 5
                                      0x0001,0x01A0,0x00D0,0x0627,0x00BE,0x009E,0x00C2,0x00A8 };
static UINT16 bloodwar_mcu_4_06[] = { 0x00BE,0x009E,0x00C2,0x00A8,0xFCBF,0x04C0,0x1100,0x0C00, // Warrior 6
                                      0x0001,0x0180,0x00C0,0x0524,0x00C8,0x00A8,0x00D6,0x009C };
static UINT16 bloodwar_mcu_4_07[] = { 0x00C8,0x00A8,0x00D6,0x009C,0xFCC8,0x05C0,0x0F40,0x0CC0, // Warrior 7
                                      0x0001,0x0160,0x00B0,0x0421,0x00AA,0x008A,0x00A0,0x0086 };
static UINT16 bloodwar_mcu_4_08[] = { 0x00AA,0x008A,0x00A0,0x0086,0xFCDB,0x05C0,0x1380,0x0F80, // Warrior 8
                                      0x0000,0x01E0,0x00F0,0x082D,0x00DC,0x00BC,0x00D6,0x00BC };
static UINT16 bloodwar_mcu_4_09[] = { 0x00DC,0x00BC,0x00D6,0x00BC,0xFCAC,0x04C0,0x10C0,0x1000, // Warrior 9
                                      0x0001,0x01C0,0x00E0,0x072A,0xFF08,0xFF02,0x0000,0xFF03 };

// --- palette data ---
//  number of palettes (>=1)
//  palette data follows (each palette is 0x200 bytes long)
//  a negative word will end the palette
static UINT16 bloodwar_mcu_4_0a[] = { // Warrior 1 Player 1
	0x000B,0x0000,0x4232,0x56F8,0x2D8D,0x27FF,0x3BFF,0x53FF,
	0x63FF,0x381F,0x4C1F,0x581F,0x6C1F,0x7C1F,0x7E1F,0x7EBF,
	0x7BDE,0x2DAF,0x296E,0x298E,0x29AE,0x2DAE,0x31CF,0x31D0,
	0x2DCF,0x258D,0x256D,0x190A,0x214D,0x214C,0x256E,0x1D4C,
	0x216C,0x216D,0x1D2B,0x192B,0x10E9,0x1D4B,0x1D2C,0x1509,
	0x10E8,0x14E9,0x1508,0x08A6,0x0CA6,0x1529,0x0CC7,0x10C8,
	0x0CA5,0x0CC3,0x0862,0x0882,0x0CA2,0x10C4,0x14E5,0x1927,
	0x1926,0x0CC5,0x2148,0x0CA4,0x1948,0x0CE3,0x0CE9,0x1509,
	0x14E7,0x1525,0x1D47,0x1103,0x1D64,0x1D66,0x1D65,0x1945,
	0x1104,0x0CC2,0x0CE2,0x0D03,0x2569,0x1906,0x1D67,0x10E7,
	0x422F,0x6F79,0x6F59,0x6B57,0x6737,0x6B37,0x6F7A,0x737A,
	0x6B78,0x6B58,0x6F99,0x6F78,0x4EB0,0x4A90,0x3E4E,0x4A8F,
	0x2DC9,0x466E,0x4A8F,0x6736,0x6756,0x5733,0x4AAF,0x468E,
	0x424D,0x31EA,0x2DE9,0x29C9,0x2DCA,0x29A9,0x320A,0x362B,
	0x2DCB,0x360C,0x360D,0x320B,0x1D45,0x1D46,0x10E3,0x0CC3,
	0x35EA,0x35EB,0x2186,0x2587,0x29A8,0x1945,0x1D65,0x1D66,

	0x2166,0x0CC2,0x0CE3,0x1524,0x1103,0x1503,0x0D02,0x1123,
	0x1543,0x08A2,0x08C2,0x0D42,0x0862,0x1924,0x0CE2,0x1523,
	0x2168,0x19A5,0x3A8C,0x21E6,0x2A28,0x36AA,0x2646,0x2EA9,
	0x36EB,0x2AA7,0x2286,0x22A6,0x1EE6,0x1F06,0x42CE,0x5753,
	0x1A05,0x0E02,0x1A44,0x32C9,0x3AEC,0x2EA9,0x470F,0x2226,
	0x1183,0x2E8A,0x36CB,0x2246,0x0D42,0x1A05,0x2687,0x2AE9,
	0x2227,0x472D,0x430D,0x42EC,0x3288,0x4F4F,0x46CD,0x36AA,
	0x2E87,0x2A07,0x3249,0x3689,0x1142,0x25C7,0x1DA4,0x42CC,
	0x366A,0x21A5,0x1984,0x470B,0x3EEA,0x430A,0x21C4,0x42CD,
	0x2E08,0x536E,0x2647,0x4F2F,0x5B72,0x3A8B,0x324A,0x21E5,
	0x2E29,0x67C8,0x67E8,0x67E9,0x6B8F,0x638A,0x5FCB,0x5B6B,
	0x6FCA,0x5BE8,0x4B48,0x67EE,0x5F8C,0x42A9,0x63CA,0x42C8,
	0x3666,0x2E05,0x2E06,0x1D63,0x4F4C,0x46B0,0x46CE,0x46EB,
	0x534D,0x29C4,0x25C3,0x3A88,0x5B67,0x5B87,0x4ACC,0x532D,
	0x4B0D,0x294A,0x0002,0x0002,0x0002,0x0002,0x0002,0x0002,
	0x0002,0x381F,0x4C1F,0x581F,0x6C1E,0x781E,0x7E1F,0x7EBF,

	0x7BDE,0x2DAF,0x296E,0x298E,0x29AE,0x2DAE,0x31CF,0x31D0,
	0x2DCF,0x258D,0x256D,0x190A,0x214D,0x214C,0x256E,0x1D4C,
	0x216C,0x216D,0x1D2B,0x192B,0x10E9,0x1D4B,0x1D2C,0x1509,
	0x10E8,0x14E9,0x1508,0x08A6,0x0CA6,0x1529,0x0CC7,0x10C8,
	0x0CA5,0x0CC3,0x0862,0x0882,0x0CA2,0x10C4,0x14E5,0x1927,
	0x1926,0x0CC5,0x2148,0x0CA4,0x1948,0x0CE3,0x0CE9,0x1509,
	0x14E7,0x1525,0x1D47,0x1103,0x1D64,0x1D66,0x1D65,0x1945,
	0x1104,0x0CC2,0x0CE2,0x0D03,0x2569,0x1906,0x1D67,0x10E7,
	0x422F,0x6F79,0x6F59,0x6B57,0x6737,0x6B37,0x6F7A,0x737A,
	0x6B78,0x6B58,0x6F99,0x6F78,0x4EB0,0x4A90,0x3E4E,0x4A8F,
	0x2DC9,0x466E,0x4A8F,0x6736,0x6756,0x5733,0x4AAF,0x468E,
	0x424D,0x31EA,0x2DE9,0x29C9,0x2DCA,0x29A9,0x320A,0x362B,
	0x2DCB,0x360C,0x360D,0x320B,0x1D45,0x1D46,0x10E3,0x0CC3,
	0x35EA,0x35EB,0x2186,0x2587,0x29A8,0x1945,0x1D65,0x1D66,
	0x2166,0x0CC2,0x0CE3,0x1524,0x1103,0x1503,0x0D02,0x1123,
	0x1543,0x08A2,0x08C2,0x0D42,0x0862,0x1924,0x0CE2,0x1523,

	0x2168,0x19A5,0x3A8C,0x21E6,0x2A28,0x36AA,0x2646,0x2EA9,
	0x36EB,0x2AA7,0x2286,0x22A6,0x1EE6,0x1F06,0x42CE,0x5753,
	0x1A05,0x0E02,0x1A44,0x32C9,0x3AEC,0x2EA9,0x470F,0x2226,
	0x1183,0x2E8A,0x36CB,0x2246,0x0D42,0x1A05,0x2687,0x2AE9,
	0x2227,0x472D,0x430D,0x42EC,0x3288,0x4F4F,0x46CD,0x36AA,
	0x2E87,0x2A07,0x3249,0x3689,0x1142,0x25C7,0x1DA4,0x42CC,
	0x366A,0x21A5,0x1984,0x470B,0x3EEA,0x430A,0x21C4,0x42CD,
	0x2E08,0x536E,0x2647,0x4F2F,0x5B72,0x3A8B,0x324A,0x21E5,
	0x2E29,0x67C8,0x67E8,0x67E9,0x6B8F,0x638A,0x5FCB,0x5B6B,
	0x6FCA,0x5BE8,0x4B48,0x67EE,0x5F8C,0x42A9,0x63CA,0x42C8,
	0x3666,0x2E05,0x2E06,0x1D63,0x4F4C,0x46B0,0x46CE,0x46EB,
	0x534D,0x29C4,0x25C3,0x3A88,0x5B67,0x5B87,0x4ACC,0x532D,
	0x4B0D,0x2D0C,0x0002,0x0002,0x0002,0x0002,0x0002,0x0002,
	0x0002,0x0360,0x13E0,0x2BE0,0x3BE9,0x4FEE,0x5FF3,0x6FF8,
	0x7BDE,0x2DAF,0x296E,0x298E,0x29AE,0x2DAE,0x31CF,0x31D0,
	0x2DCF,0x258D,0x256D,0x190A,0x214D,0x214C,0x256E,0x1D4C,

	0x216C,0x216D,0x1D2B,0x192B,0x10E9,0x1D4B,0x1D2C,0x1509,
	0x10E8,0x14E9,0x1508,0x08A6,0x0CA6,0x1529,0x0CC7,0x10C8,
	0x0CA5,0x0CC3,0x0862,0x0882,0x0CA2,0x10C4,0x14E5,0x1927,
	0x1926,0x0CC5,0x2148,0x0CA4,0x1948,0x0CE3,0x0CE9,0x1509,
	0x14E7,0x1525,0x1D47,0x1103,0x1D64,0x1D66,0x1D65,0x1945,
	0x1104,0x0CC2,0x0CE2,0x0D03,0x2569,0x1906,0x1D67,0x10E7,
	0x422F,0x6F79,0x6F59,0x6B57,0x6737,0x6B37,0x6F7A,0x737A,
	0x6B78,0x6B58,0x6F99,0x6F78,0x4EB0,0x4A90,0x3E4E,0x4A8F,
	0x2DC9,0x466E,0x4A8F,0x6736,0x6756,0x5733,0x4AAF,0x468E,
	0x424D,0x31EA,0x2DE9,0x29C9,0x2DCA,0x29A9,0x320A,0x362B,
	0x2DCB,0x360C,0x360D,0x320B,0x1D45,0x1D46,0x10E3,0x0CC3,
	0x35EA,0x35EB,0x2186,0x2587,0x29A8,0x1945,0x1D65,0x1D66,
	0x2166,0x0CC2,0x0CE3,0x1524,0x1103,0x1503,0x0D02,0x1123,
	0x1543,0x08A2,0x08C2,0x0D42,0x0862,0x1924,0x0CE2,0x1523,
	0x2168,0x19A5,0x3A8C,0x21E6,0x2A28,0x36AA,0x2646,0x2EA9,
	0x36EB,0x2AA7,0x2286,0x22A6,0x1EE6,0x1F06,0x42CE,0x5753,

	0x1A05,0x0E02,0x1A44,0x32C9,0x3AEC,0x2EA9,0x470F,0x2226,
	0x1183,0x2E8A,0x36CB,0x2246,0x0D42,0x1A05,0x2687,0x2AE9,
	0x2227,0x472D,0x430D,0x42EC,0x3288,0x4F4F,0x46CD,0x36AA,
	0x2E87,0x2A07,0x3249,0x3689,0x1142,0x25C7,0x1DA4,0x42CC,
	0x366A,0x21A5,0x1984,0x470B,0x3EEA,0x430A,0x21C4,0x42CD,
	0x2E08,0x536E,0x2647,0x4F2F,0x5B72,0x3A8B,0x324A,0x21E5,
	0x2E29,0x67C8,0x67E8,0x67E9,0x6B8F,0x638A,0x5FCB,0x5B6B,
	0x6FCA,0x5BE8,0x4B48,0x67EE,0x5F8C,0x42A9,0x63CA,0x42C8,
	0x3666,0x2E05,0x2E06,0x1D63,0x4F4C,0x46B0,0x46CE,0x46EB,
	0x534D,0x29C4,0x25C3,0x3A88,0x5B67,0x5B87,0x4ACC,0x532D,
	0x4B0D,0x4191,0x0002,0x0002,0x0002,0x0002,0x0002,0x0002,
	0x0002,0x2AC0,0x3700,0x47A0,0x5BC0,0x6FE4,0x7BEF,0x7FFB,
	0x7BDE,0x2DAF,0x296E,0x298E,0x29AE,0x2DAE,0x31CF,0x31D0,
	0x2DCF,0x258D,0x256D,0x190A,0x214D,0x214C,0x256E,0x1D4C,
	0x216C,0x216D,0x1D2B,0x192B,0x10E9,0x1D4B,0x1D2C,0x1509,
	0x10E8,0x14E9,0x1508,0x08A6,0x0CA6,0x1529,0x0CC7,0x10C8,

	0x0CA5,0x0CC3,0x0862,0x0882,0x0CA2,0x10C4,0x14E5,0x1927,
	0x1926,0x0CC5,0x2148,0x0CA4,0x1948,0x0CE3,0x0CE9,0x1509,
	0x14E7,0x1525,0x1D47,0x1103,0x1D64,0x1D66,0x1D65,0x1945,
	0x1104,0x0CC2,0x0CE2,0x0D03,0x2569,0x1906,0x1D67,0x10E7,
	0x422F,0x6F79,0x6F59,0x6B57,0x6737,0x6B37,0x6F7A,0x737A,
	0x6B78,0x6B58,0x6F99,0x6F78,0x4EB0,0x4A90,0x3E4E,0x4A8F,
	0x2DC9,0x466E,0x4A8F,0x6736,0x6756,0x5733,0x4AAF,0x468E,
	0x424D,0x31EA,0x2DE9,0x29C9,0x2DCA,0x29A9,0x320A,0x362B,
	0x2DCB,0x360C,0x360D,0x320B,0x1D45,0x1D46,0x10E3,0x0CC3,
	0x35EA,0x35EB,0x2186,0x2587,0x29A8,0x1945,0x1D65,0x1D66,
	0x2166,0x0CC2,0x0CE3,0x1524,0x1103,0x1503,0x0D02,0x1123,
	0x1543,0x08A2,0x08C2,0x0D42,0x0862,0x1924,0x0CE2,0x1523,
	0x2168,0x19A5,0x3A8C,0x21E6,0x2A28,0x36AA,0x2646,0x2EA9,
	0x36EB,0x2AA7,0x2286,0x22A6,0x1EE6,0x1F06,0x42CE,0x5753,
	0x1A05,0x0E02,0x1A44,0x32C9,0x3AEC,0x2EA9,0x470F,0x2226,
	0x1183,0x2E8A,0x36CB,0x2246,0x0D42,0x1A05,0x2687,0x2AE9,

	0x2227,0x472D,0x430D,0x42EC,0x3288,0x4F4F,0x46CD,0x36AA,
	0x2E87,0x2A07,0x3249,0x3689,0x1142,0x25C7,0x1DA4,0x42CC,
	0x366A,0x21A5,0x1984,0x470B,0x3EEA,0x430A,0x21C4,0x42CD,
	0x2E08,0x536E,0x2647,0x4F2F,0x5B72,0x3A8B,0x324A,0x21E5,
	0x2E29,0x67C8,0x67E8,0x67E9,0x6B8F,0x638A,0x5FCB,0x5B6B,
	0x6FCA,0x5BE8,0x4B48,0x67EE,0x5F8C,0x42A9,0x63CA,0x42C8,
	0x3666,0x2E05,0x2E06,0x1D63,0x4F4C,0x46B0,0x46CE,0x46EB,
	0x534D,0x29C4,0x25C3,0x3A88,0x5B67,0x5B87,0x4ACC,0x532D,
	0x4B0D,0x2D0C,0x0002,0x0002,0x0002,0x0002,0x0002,0x0002,
	0x0002,0x021C,0x0ABE,0x171E,0x275F,0x379F,0x4FBF,0x67BF,
	0x7BDE,0x2DAF,0x296E,0x298E,0x29AE,0x2DAE,0x31CF,0x31D0,
	0x2DCF,0x258D,0x256D,0x190A,0x214D,0x214C,0x256E,0x1D4C,
	0x216C,0x216D,0x1D2B,0x192B,0x10E9,0x1D4B,0x1D2C,0x1509,
	0x10E8,0x14E9,0x1508,0x08A6,0x0CA6,0x1529,0x0CC7,0x10C8,
	0x0CA5,0x0CC3,0x0862,0x0882,0x0CA2,0x10C4,0x14E5,0x1927,
	0x1926,0x0CC5,0x2148,0x0CA4,0x1948,0x0CE3,0x0CE9,0x1509,

	0x14E7,0x1525,0x1D47,0x1103,0x1D64,0x1D66,0x1D65,0x1945,
	0x1104,0x0CC2,0x0CE2,0x0D03,0x2569,0x1906,0x1D67,0x10E7,
	0x422F,0x6F79,0x6F59,0x6B57,0x6737,0x6B37,0x6F7A,0x737A,
	0x6B78,0x6B58,0x6F99,0x6F78,0x4EB0,0x4A90,0x3E4E,0x4A8F,
	0x2DC9,0x466E,0x4A8F,0x6736,0x6756,0x5733,0x4AAF,0x468E,
	0x424D,0x31EA,0x2DE9,0x29C9,0x2DCA,0x29A9,0x320A,0x362B,
	0x2DCB,0x360C,0x360D,0x320B,0x1D45,0x1D46,0x10E3,0x0CC3,
	0x35EA,0x35EB,0x2186,0x2587,0x29A8,0x1945,0x1D65,0x1D66,
	0x2166,0x0CC2,0x0CE3,0x1524,0x1103,0x1503,0x0D02,0x1123,
	0x1543,0x08A2,0x08C2,0x0D42,0x0862,0x1924,0x0CE2,0x1523,
	0x2168,0x19A5,0x3A8C,0x21E6,0x2A28,0x36AA,0x2646,0x2EA9,
	0x36EB,0x2AA7,0x2286,0x22A6,0x1EE6,0x1F06,0x42CE,0x5753,
	0x1A05,0x0E02,0x1A44,0x32C9,0x3AEC,0x2EA9,0x470F,0x2226,
	0x1183,0x2E8A,0x36CB,0x2246,0x0D42,0x1A05,0x2687,0x2AE9,
	0x2227,0x472D,0x430D,0x42EC,0x3288,0x4F4F,0x46CD,0x36AA,
	0x2E87,0x2A07,0x3249,0x3689,0x1142,0x25C7,0x1DA4,0x42CC,

	0x366A,0x21A5,0x1984,0x470B,0x3EEA,0x430A,0x21C4,0x42CD,
	0x2E08,0x536E,0x2647,0x4F2F,0x5B72,0x3A8B,0x324A,0x21E5,
	0x2E29,0x67C8,0x67E8,0x67E9,0x6B8F,0x638A,0x5FCB,0x5B6B,
	0x6FCA,0x5BE8,0x4B48,0x67EE,0x5F8C,0x42A9,0x63CA,0x42C8,
	0x3666,0x2E05,0x2E06,0x1D63,0x4F4C,0x46B0,0x46CE,0x46EB,
	0x534D,0x29C4,0x25C3,0x3A88,0x5B67,0x5B87,0x4ACC,0x532D,
	0x4B0D,0x35B3,0x7FE0,0x7C1F,0x7C00,0x001F,0x03FF,0x301F,
	0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,0x7DFF,0x7E9F,
	0x7BDE,0x1B01,0x23A0,0x2FC0,0x3BE0,0x43E0,0x4FC0,0x57C0,
	0x5FE0,0x63E0,0x67E0,0x6FE0,0x77EE,0x7FF3,0x7FFA,0x7FFC,
	0x7FFF,0x0220,0x0260,0x0280,0x02C0,0x02E0,0x0320,0x0340,
	0x2780,0x2BA0,0x37E0,0x3FE0,0x0340,0x0BE0,0x13E0,0x1DA3,
	0x2243,0x2D2F,0x7FE0,0x3405,0x3C05,0x4409,0x4C07,0x5407,
	0x5C0A,0x6409,0x6C09,0x7409,0x7CCF,0x7E15,0x7EBA,0x7F5D,
	0x7BDE,0xFFFF,0x35B3,0x7FE0,0x7C1F,0x7C00,0x001F,0x03FF,
	0x301F,0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,0x7DFF,

	0x7E9F,0x7BDE,0x2AA1,0x3724,0x3FA6,0x43E0,0x4FE8,0x5BC4,
	0x63C5,0x67EB,0x67EB,0x67ED,0x6FF0,0x77F3,0x7FF7,0x7FFA,
	0x7FFC,0x7FFF,0x0220,0x0260,0x0280,0x02C0,0x02E0,0x0320,
	0x0340,0x2780,0x2BA0,0x37E0,0x3FE0,0x0340,0x0BE0,0x13E0,
	0x1DA3,0x2243,0xFFFF,0x41D3,0x01D1,0x0215,0x0A77,0x12B9,
	0x16FB,0x273C,0x375D,0x435E,0x4B7F,0x537F,0x5B9F,0x639F,
	0x6FBF,0x77DF,0x7FFF,0xFFFF,0x4191,0x0011,0x0016,0x001A,
	0x1C1D,0x281E,0x341D,0x401E,0x501E,0x581E,0x641E,0x6C1F,
	0x785F,0x7E5F,0x7F3F,0x7BDE,0xFFFF,0x4191,0x2000,0x2800,
	0x3000,0x3400,0x3800,0x4000,0x4800,0x5400,0x5C00,0x6821,
	0x7084,0x7D29,0x7E52,0x7F39,0x7BDE,0xFFFF,0x4191,0x1320,
	0x2340,0x2B60,0x3380,0x3FA0,0x47A0,0x4FC1,0x5BC0,0x67E2,
	0x6FE4,0x77E6,0x7BEF,0x7FF4,0x7FFB,0x7BDE,0xFFFF,0x000B
};
static UINT16 bloodwar_mcu_4_0b[] = { // Warrior 1 Player 2
	0x000B,0x292A,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x2E2A,0x29E9,0x2609,0x29E9,0x2629,0x2A4A,0x2A4B,
	0x260A,0x25E8,0x25C8,0x1965,0x21A8,0x21A7,0x25E8,0x1DA7,
	0x21A8,0x21A8,0x2186,0x1D86,0x1524,0x2187,0x2146,0x1925,
	0x1504,0x1924,0x18E5,0x0CE2,0x10E2,0x1926,0x10C3,0x14E3,
	0x1082,0x10A0,0x0C40,0x0C60,0x1080,0x14A1,0x18C2,0x1925,
	0x1924,0x0CC3,0x2146,0x0CA2,0x1D25,0x10C0,0x1104,0x1905,
	0x18C4,0x1523,0x1D45,0x1101,0x1D62,0x1D66,0x1D65,0x1945,
	0x1104,0x0CC2,0x0CE2,0x0D03,0x25A9,0x1906,0x1D67,0x1125,
	0x422F,0x6F79,0x6F59,0x6B57,0x6737,0x6B37,0x6F7A,0x737A,
	0x6B78,0x6B58,0x6F99,0x6F78,0x4EB0,0x4A90,0x3E4E,0x4A8F,
	0x2DC9,0x466E,0x4A8F,0x6736,0x6756,0x5733,0x4AAF,0x468E,
	0x424D,0x31EA,0x2DE9,0x29C9,0x2DCA,0x29C9,0x320A,0x362B,
	0x2DCB,0x360C,0x360D,0x320B,0x1D45,0x1D46,0x10E3,0x0CC3,
	0x35EA,0x35EB,0x2186,0x2587,0x29A8,0x1945,0x1D65,0x1D66,

	0x2166,0x0CC2,0x0CE3,0x1524,0x1103,0x1503,0x0D02,0x1123,
	0x1543,0x08A2,0x08C2,0x0D42,0x0862,0x1924,0x0CE2,0x1523,
	0x2168,0x19A5,0x3A8C,0x21E6,0x2A28,0x36AA,0x2646,0x2EA9,
	0x36EB,0x2AA7,0x2286,0x22A6,0x1EE6,0x1F06,0x42CE,0x5753,
	0x1A05,0x0E02,0x1A44,0x32C9,0x3AEC,0x2EA9,0x470F,0x2226,
	0x1183,0x2E8A,0x36CB,0x2246,0x0D42,0x1A05,0x2687,0x2AE9,
	0x2227,0x472D,0x430D,0x42EC,0x3288,0x4F4F,0x46CD,0x36AA,
	0x2E87,0x2A07,0x3249,0x3689,0x1142,0x25C7,0x1DA4,0x42CC,
	0x366A,0x21A5,0x1984,0x470B,0x3EEA,0x430A,0x21C4,0x42CD,
	0x2E08,0x536E,0x2647,0x4F2F,0x5B72,0x3A8B,0x324A,0x21E5,
	0x2E29,0x7F88,0x7F88,0x7EA9,0x7B73,0x7E68,0x72CB,0x66CB,
	0x772A,0x6348,0x52A8,0x6F4E,0x66EC,0x5669,0x6B2A,0x5288,
	0x4585,0x2E05,0x2E06,0x1D63,0x4F4C,0x46B0,0x46CE,0x46EB,
	0x534D,0x29C4,0x25C3,0x3A88,0x62C7,0x62E7,0x4ACC,0x532D,
	0x4B0D,0x294A,0x0002,0x0002,0x0002,0x0002,0x0002,0x0002,
	0x0002,0x381F,0x4C1F,0x581F,0x6C1E,0x781E,0x7E1F,0x7EBF,

	0x7BDE,0x2DAF,0x296E,0x298E,0x29AE,0x2DAE,0x31CF,0x31D0,
	0x2DCF,0x258D,0x256D,0x190A,0x214D,0x214C,0x256E,0x1D4C,
	0x216C,0x216D,0x1D2B,0x192B,0x10E9,0x1D4B,0x1D2C,0x1509,
	0x10E8,0x14E9,0x1508,0x08A6,0x0CA6,0x1529,0x0CC7,0x10C8,
	0x0CA5,0x0CC3,0x0862,0x0882,0x0CA2,0x10C4,0x14E5,0x1927,
	0x1926,0x0CC5,0x2148,0x0CA4,0x1948,0x0CE3,0x0CE9,0x1509,
	0x14E7,0x1525,0x1D47,0x1103,0x1D64,0x1D66,0x1D65,0x1945,
	0x1104,0x0CC2,0x0CE2,0x0D03,0x2569,0x1906,0x1D67,0x10E7,
	0x422F,0x6F79,0x6F59,0x6B57,0x6737,0x6B37,0x6F7A,0x737A,
	0x6B78,0x6B58,0x6F99,0x6F78,0x4EB0,0x4A90,0x3E4E,0x4A8F,
	0x2DC9,0x466E,0x4A8F,0x6736,0x6756,0x5733,0x4AAF,0x468E,
	0x424D,0x31EA,0x2DE9,0x29C9,0x2DCA,0x29A9,0x320A,0x362B,
	0x2DCB,0x360C,0x360D,0x320B,0x1D45,0x1D46,0x10E3,0x0CC3,
	0x35EA,0x35EB,0x2186,0x2587,0x29A8,0x1945,0x1D65,0x1D66,
	0x2166,0x0CC2,0x0CE3,0x1524,0x1103,0x1503,0x0D02,0x1123,
	0x1543,0x08A2,0x08C2,0x0D42,0x0862,0x1924,0x0CE2,0x1523,

	0x2168,0x19A5,0x3A8C,0x21E6,0x2A28,0x36AA,0x2646,0x2EA9,
	0x36EB,0x2AA7,0x2286,0x22A6,0x1EE6,0x1F06,0x42CE,0x5753,
	0x1A05,0x0E02,0x1A44,0x32C9,0x3AEC,0x2EA9,0x470F,0x2226,
	0x1183,0x2E8A,0x36CB,0x2246,0x0D42,0x1A05,0x2687,0x2AE9,
	0x2227,0x472D,0x430D,0x42EC,0x3288,0x4F4F,0x46CD,0x36AA,
	0x2E87,0x2A07,0x3249,0x3689,0x1142,0x25C7,0x1DA4,0x42CC,
	0x366A,0x21A5,0x1984,0x470B,0x3EEA,0x430A,0x21C4,0x42CD,
	0x2E08,0x536E,0x2647,0x4F2F,0x5B72,0x3A8B,0x324A,0x21E5,
	0x2E29,0x67C8,0x67E8,0x67E9,0x6B8F,0x638A,0x5FCB,0x5B6B,
	0x6FCA,0x5BE8,0x4B48,0x67EE,0x5F8C,0x42A9,0x63CA,0x42C8,
	0x3666,0x2E05,0x2E06,0x1D63,0x4F4C,0x46B0,0x46CE,0x46EB,
	0x534D,0x29C4,0x25C3,0x3A88,0x5B67,0x5B87,0x4ACC,0x532D,
	0x4B0D,0x2D0C,0x0002,0x0002,0x0002,0x0002,0x0002,0x0002,
	0x0002,0x0360,0x13E0,0x2BE0,0x3BE9,0x4FEE,0x5FF3,0x6FF8,
	0x7BDE,0x2DAF,0x296E,0x298E,0x29AE,0x2DAE,0x31CF,0x31D0,
	0x2DCF,0x258D,0x256D,0x190A,0x214D,0x214C,0x256E,0x1D4C,

	0x216C,0x216D,0x1D2B,0x192B,0x10E9,0x1D4B,0x1D2C,0x1509,
	0x10E8,0x14E9,0x1508,0x08A6,0x0CA6,0x1529,0x0CC7,0x10C8,
	0x0CA5,0x0CC3,0x0862,0x0882,0x0CA2,0x10C4,0x14E5,0x1927,
	0x1926,0x0CC5,0x2148,0x0CA4,0x1948,0x0CE3,0x0CE9,0x1509,
	0x14E7,0x1525,0x1D47,0x1103,0x1D64,0x1D66,0x1D65,0x1945,
	0x1104,0x0CC2,0x0CE2,0x0D03,0x2569,0x1906,0x1D67,0x10E7,
	0x422F,0x6F79,0x6F59,0x6B57,0x6737,0x6B37,0x6F7A,0x737A,
	0x6B78,0x6B58,0x6F99,0x6F78,0x4EB0,0x4A90,0x3E4E,0x4A8F,
	0x2DC9,0x466E,0x4A8F,0x6736,0x6756,0x5733,0x4AAF,0x468E,
	0x424D,0x31EA,0x2DE9,0x29C9,0x2DCA,0x29A9,0x320A,0x362B,
	0x2DCB,0x360C,0x360D,0x320B,0x1D45,0x1D46,0x10E3,0x0CC3,
	0x35EA,0x35EB,0x2186,0x2587,0x29A8,0x1945,0x1D65,0x1D66,
	0x2166,0x0CC2,0x0CE3,0x1524,0x1103,0x1503,0x0D02,0x1123,
	0x1543,0x08A2,0x08C2,0x0D42,0x0862,0x1924,0x0CE2,0x1523,
	0x2168,0x19A5,0x3A8C,0x21E6,0x2A28,0x36AA,0x2646,0x2EA9,
	0x36EB,0x2AA7,0x2286,0x22A6,0x1EE6,0x1F06,0x42CE,0x5753,

	0x1A05,0x0E02,0x1A44,0x32C9,0x3AEC,0x2EA9,0x470F,0x2226,
	0x1183,0x2E8A,0x36CB,0x2246,0x0D42,0x1A05,0x2687,0x2AE9,
	0x2227,0x472D,0x430D,0x42EC,0x3288,0x4F4F,0x46CD,0x36AA,
	0x2E87,0x2A07,0x3249,0x3689,0x1142,0x25C7,0x1DA4,0x42CC,
	0x366A,0x21A5,0x1984,0x470B,0x3EEA,0x430A,0x21C4,0x42CD,
	0x2E08,0x536E,0x2647,0x4F2F,0x5B72,0x3A8B,0x324A,0x21E5,
	0x2E29,0x67C8,0x67E8,0x67E9,0x6B8F,0x638A,0x5FCB,0x5B6B,
	0x6FCA,0x5BE8,0x4B48,0x67EE,0x5F8C,0x42A9,0x63CA,0x42C8,
	0x3666,0x2E05,0x2E06,0x1D63,0x4F4C,0x46B0,0x46CE,0x46EB,
	0x534D,0x29C4,0x25C3,0x3A88,0x5B67,0x5B87,0x4ACC,0x532D,
	0x4B0D,0x4191,0x0002,0x0002,0x0002,0x0002,0x0002,0x0002,
	0x0002,0x2AC0,0x3700,0x47A0,0x5BC0,0x6FE4,0x7BEF,0x7FFB,
	0x7BDE,0x2DAF,0x296E,0x298E,0x29AE,0x2DAE,0x31CF,0x31D0,
	0x2DCF,0x258D,0x256D,0x190A,0x214D,0x214C,0x256E,0x1D4C,
	0x216C,0x216D,0x1D2B,0x192B,0x10E9,0x1D4B,0x1D2C,0x1509,
	0x10E8,0x14E9,0x1508,0x08A6,0x0CA6,0x1529,0x0CC7,0x10C8,

	0x0CA5,0x0CC3,0x0862,0x0882,0x0CA2,0x10C4,0x14E5,0x1927,
	0x1926,0x0CC5,0x2148,0x0CA4,0x1948,0x0CE3,0x0CE9,0x1509,
	0x14E7,0x1525,0x1D47,0x1103,0x1D64,0x1D66,0x1D65,0x1945,
	0x1104,0x0CC2,0x0CE2,0x0D03,0x2569,0x1906,0x1D67,0x10E7,
	0x422F,0x6F79,0x6F59,0x6B57,0x6737,0x6B37,0x6F7A,0x737A,
	0x6B78,0x6B58,0x6F99,0x6F78,0x4EB0,0x4A90,0x3E4E,0x4A8F,
	0x2DC9,0x466E,0x4A8F,0x6736,0x6756,0x5733,0x4AAF,0x468E,
	0x424D,0x31EA,0x2DE9,0x29C9,0x2DCA,0x29A9,0x320A,0x362B,
	0x2DCB,0x360C,0x360D,0x320B,0x1D45,0x1D46,0x10E3,0x0CC3,
	0x35EA,0x35EB,0x2186,0x2587,0x29A8,0x1945,0x1D65,0x1D66,
	0x2166,0x0CC2,0x0CE3,0x1524,0x1103,0x1503,0x0D02,0x1123,
	0x1543,0x08A2,0x08C2,0x0D42,0x0862,0x1924,0x0CE2,0x1523,
	0x2168,0x19A5,0x3A8C,0x21E6,0x2A28,0x36AA,0x2646,0x2EA9,
	0x36EB,0x2AA7,0x2286,0x22A6,0x1EE6,0x1F06,0x42CE,0x5753,
	0x1A05,0x0E02,0x1A44,0x32C9,0x3AEC,0x2EA9,0x470F,0x2226,
	0x1183,0x2E8A,0x36CB,0x2246,0x0D42,0x1A05,0x2687,0x2AE9,

	0x2227,0x472D,0x430D,0x42EC,0x3288,0x4F4F,0x46CD,0x36AA,
	0x2E87,0x2A07,0x3249,0x3689,0x1142,0x25C7,0x1DA4,0x42CC,
	0x366A,0x21A5,0x1984,0x470B,0x3EEA,0x430A,0x21C4,0x42CD,
	0x2E08,0x536E,0x2647,0x4F2F,0x5B72,0x3A8B,0x324A,0x21E5,
	0x2E29,0x67C8,0x67E8,0x67E9,0x6B8F,0x638A,0x5FCB,0x5B6B,
	0x6FCA,0x5BE8,0x4B48,0x67EE,0x5F8C,0x42A9,0x63CA,0x42C8,
	0x3666,0x2E05,0x2E06,0x1D63,0x4F4C,0x46B0,0x46CE,0x46EB,
	0x534D,0x29C4,0x25C3,0x3A88,0x5B67,0x5B87,0x4ACC,0x532D,
	0x4B0D,0x2D0C,0x0002,0x0002,0x0002,0x0002,0x0002,0x0002,
	0x0002,0x021C,0x0ABE,0x171E,0x275F,0x379F,0x4FBF,0x67BF,
	0x7BDE,0x2DAF,0x296E,0x298E,0x29AE,0x2DAE,0x31CF,0x31D0,
	0x2DCF,0x258D,0x256D,0x190A,0x214D,0x214C,0x256E,0x1D4C,
	0x216C,0x216D,0x1D2B,0x192B,0x10E9,0x1D4B,0x1D2C,0x1509,
	0x10E8,0x14E9,0x1508,0x08A6,0x0CA6,0x1529,0x0CC7,0x10C8,
	0x0CA5,0x0CC3,0x0862,0x0882,0x0CA2,0x10C4,0x14E5,0x1927,
	0x1926,0x0CC5,0x2148,0x0CA4,0x1948,0x0CE3,0x0CE9,0x1509,

	0x14E7,0x1525,0x1D47,0x1103,0x1D64,0x1D66,0x1D65,0x1945,
	0x1104,0x0CC2,0x0CE2,0x0D03,0x2569,0x1906,0x1D67,0x10E7,
	0x422F,0x6F79,0x6F59,0x6B57,0x6737,0x6B37,0x6F7A,0x737A,
	0x6B78,0x6B58,0x6F99,0x6F78,0x4EB0,0x4A90,0x3E4E,0x4A8F,
	0x2DC9,0x466E,0x4A8F,0x6736,0x6756,0x5733,0x4AAF,0x468E,
	0x424D,0x31EA,0x2DE9,0x29C9,0x2DCA,0x29A9,0x320A,0x362B,
	0x2DCB,0x360C,0x360D,0x320B,0x1D45,0x1D46,0x10E3,0x0CC3,
	0x35EA,0x35EB,0x2186,0x2587,0x29A8,0x1945,0x1D65,0x1D66,
	0x2166,0x0CC2,0x0CE3,0x1524,0x1103,0x1503,0x0D02,0x1123,
	0x1543,0x08A2,0x08C2,0x0D42,0x0862,0x1924,0x0CE2,0x1523,
	0x2168,0x19A5,0x3A8C,0x21E6,0x2A28,0x36AA,0x2646,0x2EA9,
	0x36EB,0x2AA7,0x2286,0x22A6,0x1EE6,0x1F06,0x42CE,0x5753,
	0x1A05,0x0E02,0x1A44,0x32C9,0x3AEC,0x2EA9,0x470F,0x2226,
	0x1183,0x2E8A,0x36CB,0x2246,0x0D42,0x1A05,0x2687,0x2AE9,
	0x2227,0x472D,0x430D,0x42EC,0x3288,0x4F4F,0x46CD,0x36AA,
	0x2E87,0x2A07,0x3249,0x3689,0x1142,0x25C7,0x1DA4,0x42CC,

	0x366A,0x21A5,0x1984,0x470B,0x3EEA,0x430A,0x21C4,0x42CD,
	0x2E08,0x536E,0x2647,0x4F2F,0x5B72,0x3A8B,0x324A,0x21E5,
	0x2E29,0x67C8,0x67E8,0x67E9,0x6B8F,0x638A,0x5FCB,0x5B6B,
	0x6FCA,0x5BE8,0x4B48,0x67EE,0x5F8C,0x42A9,0x63CA,0x42C8,
	0x3666,0x2E05,0x2E06,0x1D63,0x4F4C,0x46B0,0x46CE,0x46EB,
	0x534D,0x29C4,0x25C3,0x3A88,0x5B67,0x5B87,0x4ACC,0x532D,
	0x4B0D,0x35B3,0x7FE0,0x7C1F,0x7C00,0x001F,0x03FF,0x301F,
	0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,0x7DFF,0x7E9F,
	0x7BDE,0x1B01,0x23A0,0x2FC0,0x3BE0,0x43E0,0x4FC0,0x57C0,
	0x5FE0,0x63E0,0x67E0,0x6FE0,0x77EE,0x7FF3,0x7FFA,0x7FFC,
	0x7FFF,0x0220,0x0260,0x0280,0x02C0,0x02E0,0x0320,0x0340,
	0x2780,0x2BA0,0x37E0,0x3FE0,0x0340,0x0BE0,0x13E0,0x1DA3,
	0x2243,0x2D2F,0x7FE0,0x3405,0x3C05,0x4409,0x4C07,0x5407,
	0x5C0A,0x6409,0x6C09,0x7409,0x7CCF,0x7E15,0x7EBA,0x7F5D,
	0x7BDE,0xFFFF,0x35B3,0x7FE0,0x7C1F,0x7C00,0x001F,0x03FF,
	0x301F,0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,0x7DFF,

	0x7E9F,0x7BDE,0x2AA1,0x3724,0x3FA6,0x43E0,0x4FE8,0x5BC4,
	0x63C5,0x67EB,0x67EB,0x67ED,0x6FF0,0x77F3,0x7FF7,0x7FFA,
	0x7FFC,0x7FFF,0x0220,0x0260,0x0280,0x02C0,0x02E0,0x0320,
	0x0340,0x2780,0x2BA0,0x37E0,0x3FE0,0x0340,0x0BE0,0x13E0,
	0x1DA3,0x2243,0xFFFF,0x41D3,0x01D1,0x0215,0x0A77,0x12B9,
	0x16FB,0x273C,0x375D,0x435E,0x4B7F,0x537F,0x5B9F,0x639F,
	0x6FBF,0x77DF,0x7FFF,0xFFFF,0x4191,0x0011,0x0016,0x001A,
	0x1C1D,0x281E,0x341D,0x401E,0x501E,0x581E,0x641E,0x6C1F,
	0x785F,0x7E5F,0x7F3F,0x7BDE,0xFFFF,0x4191,0x2000,0x2800,
	0x3000,0x3400,0x3800,0x4000,0x4800,0x5400,0x5C00,0x6821,
	0x7084,0x7D29,0x7E52,0x7F39,0x7BDE,0xFFFF,0x4191,0x1320,
	0x2340,0x2B60,0x3380,0x3FA0,0x47A0,0x4FC1,0x5BC0,0x67E2,
	0x6FE4,0x77E6,0x7BEF,0x7FF4,0x7FFB,0x7BDE,0xFFFF,0x0004
};
static UINT16 bloodwar_mcu_4_0c[] = { // Warrior 5 Player 1
	0x0004,0x0000,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x1422,0x1423,0x2044,0x1803,0x1C23,0x2CA6,0x2445,
	0x2446,0x38CA,0x2C87,0x38EA,0x30A8,0x34A9,0x2C88,0x2887,
	0x2866,0x1824,0x3089,0x28A7,0x2466,0x2867,0x30C9,0x34E9,
	0x59F0,0x59D0,0x6212,0x6654,0x6211,0x5DF0,0x59CE,0x558D,
	0x518F,0x4D2F,0x492E,0x34AB,0x4D4E,0x55B1,0x40EB,0x5591,
	0x40CB,0x59B1,0x5590,0x450D,0x2865,0x5170,0x3D0D,0x2045,
	0x2046,0x51D0,0x4D8D,0x2885,0x30C8,0x3CEA,0x3CEB,0x38C9,
	0x3087,0x3088,0x2465,0x2064,0x1C43,0x1822,0x494E,0x412C,
	0x452D,0x51AC,0x5E0F,0x6653,0x6A53,0x496B,0x55CF,0x34AA,
	0x38A9,0x3CEB,0x3489,0x2006,0x1C05,0x308A,0x450F,0x40EE,
	0x40CD,0x38AC,0x2C48,0x2C89,0x496E,0x55D0,0x59B2,0x55D2,
	0x492E,0x5970,0x5991,0x61D3,0x5DB2,0x44EB,0x55B0,0x494B,
	0x5171,0x5570,0x5571,0x5191,0x38EB,0x34AA,0x2846,0x4D8E,
	0x2CA7,0x2464,0x410C,0x3CCB,0x38CC,0x410B,0x3CEC,0x30CA,

	0x408B,0x20A7,0x452C,0x51AF,0x454C,0x24A3,0x494C,0x518E,
	0x61F1,0x55AE,0x5DF2,0x5A0E,0x55ED,0x6271,0x38AA,0x30A6,
	0x2887,0x2A40,0x53A0,0x63E1,0x6FE5,0x6FE5,0x5BC2,0x5FC4,
	0x5FC3,0x67C4,0x6FC8,0x73C6,0x6BE6,0x29E0,0x2E00,0x2E00,
	0x3E82,0x5B47,0x1DA0,0x3EC0,0x3681,0x3680,0x4B03,0x5364,
	0x2A00,0x5384,0x5787,0x5B26,0x5FC4,0x5FE2,0x5BE2,0x3F00,
	0x4320,0x3AC0,0x2E40,0x2A20,0x4760,0x4300,0x4B41,0x3240,
	0x3220,0x3A61,0x3260,0x3280,0x2A60,0x32A0,0x2E00,0x3AA0,
	0x4722,0x3AA0,0x31C0,0x3200,0x3220,0x3620,0x3200,0x5385,
	0x67E7,0x5784,0x6388,0x6368,0x73AA,0x73CB,0x3A82,0x73C5,
	0x6BE7,0x1943,0x1542,0x08A1,0x0CE3,0x0CE1,0x1962,0x2164,
	0x29E5,0x25A3,0x25C4,0x2E25,0x3226,0x3227,0x1963,0x21A4,
	0x2DE8,0x1D84,0x25A5,0x1122,0x0460,0x0CE2,0x1543,0x1DA3,
	0x1DA4,0x25E5,0x25C5,0x2DE7,0x29C6,0x2E07,0x3A49,0x42CB,
	0x4F0C,0x35B3,0x7FE0,0x7C1F,0x7C00,0x001F,0x03FF,0x301F,
	0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,0x7DFF,0x7E9F,

	0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x001F,0x0FE0,0x1BE0,
	0x27E0,0x37E0,0x43E0,0x4FE0,0x63E0,0x67ED,0x77EE,0x7FF5,
	0x7BDE,0xFFFF,0x35B3,0x7FE0,0x7C1F,0x7C00,0x001F,0x03FF,
	0x301F,0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,0x7DFF,
	0x7E9F,0x7BDE,0x7F9F,0x186B,0x1CAB,0x1C6C,0x208E,0x204F,
	0x28B2,0x28B2,0x28B2,0x28B2,0x28B2,0x2873,0x2893,0x2C92,
	0x2CB2,0x3074,0x3094,0x30D4,0x30F4,0x3076,0x34D4,0x34F4,
	0x3476,0x34B7,0x34F7,0x3517,0x3478,0x34B8,0x3479,0x3CD6,
	0x3CB7,0x3CB8,0x3D58,0x3CD9,0x3D39,0x3C7B,0x3CBB,0x3CDB,
	0x3CFB,0x3CFC,0x407F,0x44F8,0x4578,0x44D9,0x44F9,0x4539,
	0x44BB,0x44DB,0x455C,0x44BD,0x44DD,0x451D,0x44BE,0x447F,
	0x4D9A,0x4CDA,0x4D3C,0x4CDD,0x4D3E,0x4CBF,0x4CDF,0x4D1F,
	0x4D3F,0x54DE,0x553E,0x54DF,0x551F,0x553F,0x557F,0x5CDF,
	0x5D1F,0x5D3F,0x5D5F,0x5D7F,0x5D9F,0x651F,0x655F,0x65BF,
	0x65DF,0x661F,0x691F,0x695F,0x69BE,0x69DF,0x6A1F,0x715F,
	0x717F,0x71BF,0x71DF,0x721F,0x723F,0x725F,0x727F,0x79BF,

	0x79FF,0x7A1F,0x7A5F,0x7A7F,0x7ABF,0x7B5F,0x7B7F,0x7DDF,
	0x7E1F,0x7E5F,0x7F1F,0x7F7F,0x7D7F,0x7E1F,0x7E5F,0x7EBF,
	0x7EFF,0x7F5F,0x7FBF,0x7FDF,0x7E3F,0x7E5F,0x7E7F,0x7E9F,
	0x7EBF,0x7EDF,0x7EFF,0x7F1F,0x7F3F,0x7F5F,0x7F7F,0x7FBF,
	0x7FFF,0x0000,0xFFFF,0x3C48,0x7FE0,0x7C1F,0x7C00,0x001F,
	0x03FF,0x301F,0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,
	0x7DFF,0x7E9F,0x7BDE,0x7FE0,0x0445,0x08C5,0x04E5,0x0505,
	0x0525,0x0545,0x0565,0x0945,0x0965,0x0966,0x0986,0x09A6,
	0x198C,0x19AA,0x1D66,0x7FE0,0x1D82,0x1DA2,0x1DC2,0x218C,
	0x21AC,0x21C2,0x258D,0x25AC,0x29AD,0x29AE,0x29AF,0x29CF,
	0x29E2,0x2D91,0x2DB0,0x7FE0,0x2DF0,0x31D0,0x31D1,0x31D2,
	0x31F1,0x31F2,0x3592,0x35D1,0x35D2,0x35F2,0x35F3,0x3A33,
	0x3DF3,0x3DF4,0x3DF5,0x7FE0,0x3E14,0x3E15,0x3E33,0x3E34,
	0x3F62,0x41D3,0x41F5,0x4215,0x4216,0x4234,0x4235,0x4236,
	0x4382,0x4616,0x4617,0x7FE0,0x4636,0x4637,0x4639,0x4656,
	0x4657,0x4676,0x4A17,0x4A19,0x4A37,0x4A39,0x4E77,0x4E78,

	0x4FAD,0x5259,0x525A,0x7FE0,0x5279,0x527A,0x5299,0x5299,
	0x529A,0x53EC,0x53EE,0x5699,0x569A,0x56B9,0x56BA,0x56BC,
	0x5A9C,0x5ABA,0x5ABC,0x7FE0,0x5BF1,0x5EFB,0x5EFC,0x62BD,
	0x62FD,0x62FE,0x631D,0x66FD,0x671D,0x671E,0x673D,0x67B2,
	0x67D4,0x6B3E,0x6B3F,0x7FE0,0x6F7F,0x737F,0x739E,0x739F,
	0x73FD,0x77BF,0x77F9,0x7BBE,0x7BDD,0x7BFC,0x7FFA,0x7FFB,
	0x7FFC,0x7FFD,0x7FFF,0x7FE0,0x1D6C,0x2DD0,0x3E13,0x4635,
	0x5278,0x5ABD,0x6F7F,0x3C48,0x3C48,0x3C48,0x3C48,0x3C48,
	0x3C48,0x3C48,0x3C48,0x3971,0x0842,0x15C6,0x2666,0x1E8C,
	0x270A,0x32F1,0x2EAB,0x3BCF,0x3BD2,0x4BEE,0x53F6,0x5B94,
	0x6BB5,0x6FFB,0x7BDE,0xFFFF,0x0004,0x0000,0x4232,0x56F8
};
static UINT16 bloodwar_mcu_4_0d[] = { // Warrior 5 Player 2
	0x0004,0x0000,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x0C29,0x0C2A,0x184B,0x100A,0x142A,0x24AD,0x1C4C,
	0x1C4D,0x30D1,0x248E,0x30F1,0x28AF,0x2CB0,0x248F,0x208E,
	0x206D,0x102B,0x2890,0x20AE,0x1C6D,0x206E,0x28D0,0x2CF0,
	0x51F7,0x51D7,0x5A19,0x5E5B,0x5A18,0x55F7,0x51D5,0x4D94,
	0x4996,0x4536,0x4135,0x2CB2,0x4555,0x4DB8,0x38F2,0x4D98,
	0x38D2,0x51B8,0x4D97,0x3D14,0x206C,0x4977,0x3514,0x184C,
	0x184D,0x49D7,0x4594,0x208C,0x28CF,0x34F1,0x34F2,0x30D0,
	0x288E,0x288F,0x1C6C,0x186B,0x144A,0x1029,0x4155,0x3933,
	0x3D34,0x49B3,0x5616,0x5E5A,0x625A,0x4172,0x4DD6,0x2CB1,
	0x30B0,0x34F2,0x2C90,0x180D,0x140C,0x2891,0x3D16,0x38F5,
	0x38D4,0x30B3,0x244F,0x2490,0x4174,0x4DD7,0x51B9,0x4DD9,
	0x4135,0x5177,0x5198,0x59DA,0x55B9,0x3CF2,0x4DB7,0x4152,
	0x4978,0x4D77,0x4D78,0x4998,0x30F2,0x2CB1,0x204D,0x4595,
	0x24AE,0x1C6B,0x3913,0x34D2,0x30D3,0x3912,0x34F3,0x28D1,

	0x3892,0x18AE,0x3D33,0x49B6,0x3D53,0x1CAA,0x4153,0x4995,
	0x59F8,0x4DB5,0x55F9,0x5215,0x4DF4,0x5A78,0x30B1,0x28AD,
	0x208E,0x2A40,0x53A0,0x63E1,0x6FE5,0x6FE5,0x5BC2,0x5FC4,
	0x5FC3,0x67C4,0x6FC8,0x73C6,0x6BE6,0x29E0,0x2E00,0x2E00,
	0x3E82,0x5B47,0x1DA0,0x3EC0,0x3681,0x3680,0x4B03,0x5364,
	0x2A00,0x5384,0x5787,0x5B26,0x5FC4,0x5FE2,0x5BE2,0x3F00,
	0x4320,0x3AC0,0x2E40,0x2A20,0x4760,0x4300,0x4B41,0x3240,
	0x3220,0x3A61,0x3260,0x3280,0x2A60,0x32A0,0x2E00,0x3AA0,
	0x4722,0x3AA0,0x31C0,0x3200,0x3220,0x3620,0x3200,0x5385,
	0x67E7,0x5784,0x6388,0x6368,0x73AA,0x73CB,0x3A82,0x73C5,
	0x6BE7,0x1943,0x1542,0x08A1,0x0CE3,0x0CE1,0x1962,0x2164,
	0x29E5,0x25A3,0x25C4,0x2E25,0x3226,0x3227,0x1963,0x21A4,
	0x2DE8,0x1D84,0x25A5,0x1122,0x0460,0x0CE2,0x1543,0x1DA3,
	0x1DA4,0x25E5,0x25C5,0x2DE7,0x29C6,0x2E07,0x3A49,0x42CB,
	0x4F0C,0x35B3,0x7FE0,0x7C1F,0x7C00,0x001F,0x03FF,0x301F,
	0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,0x7DFF,0x7E9F,

	0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x001F,0x0FE0,0x1BE0,
	0x27E0,0x37E0,0x43E0,0x4FE0,0x63E0,0x67ED,0x77EE,0x7FF5,
	0x7BDE,0xFFFF,0x35B3,0x7FE0,0x7C1F,0x7C00,0x001F,0x03FF,
	0x301F,0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,0x7DFF,
	0x7E9F,0x7BDE,0x7F9F,0x186B,0x1CAB,0x1C6C,0x208E,0x204F,
	0x28B2,0x28B2,0x28B2,0x28B2,0x28B2,0x2873,0x2893,0x2C92,
	0x2CB2,0x3074,0x3094,0x30D4,0x30F4,0x3076,0x34D4,0x34F4,
	0x3476,0x34B7,0x34F7,0x3517,0x3478,0x34B8,0x3479,0x3CD6,
	0x3CB7,0x3CB8,0x3D58,0x3CD9,0x3D39,0x3C7B,0x3CBB,0x3CDB,
	0x3CFB,0x3CFC,0x407F,0x44F8,0x4578,0x44D9,0x44F9,0x4539,
	0x44BB,0x44DB,0x455C,0x44BD,0x44DD,0x451D,0x44BE,0x447F,
	0x4D9A,0x4CDA,0x4D3C,0x4CDD,0x4D3E,0x4CBF,0x4CDF,0x4D1F,
	0x4D3F,0x54DE,0x553E,0x54DF,0x551F,0x553F,0x557F,0x5CDF,
	0x5D1F,0x5D3F,0x5D5F,0x5D7F,0x5D9F,0x651F,0x655F,0x65BF,
	0x65DF,0x661F,0x691F,0x695F,0x69BE,0x69DF,0x6A1F,0x715F,
	0x717F,0x71BF,0x71DF,0x721F,0x723F,0x725F,0x727F,0x79BF,

	0x79FF,0x7A1F,0x7A5F,0x7A7F,0x7ABF,0x7B5F,0x7B7F,0x7DDF,
	0x7E1F,0x7E5F,0x7F1F,0x7F7F,0x7D7F,0x7E1F,0x7E5F,0x7EBF,
	0x7EFF,0x7F5F,0x7FBF,0x7FDF,0x7E3F,0x7E5F,0x7E7F,0x7E9F,
	0x7EBF,0x7EDF,0x7EFF,0x7F1F,0x7F3F,0x7F5F,0x7F7F,0x7FBF,
	0x7FFF,0x0000,0xFFFF,0x3C48,0x7FE0,0x7C1F,0x7C00,0x001F,
	0x03FF,0x301F,0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,
	0x7DFF,0x7E9F,0x7BDE,0x7FE0,0x0445,0x08C5,0x04E5,0x0505,
	0x0525,0x0545,0x0565,0x0945,0x0965,0x0966,0x0986,0x09A6,
	0x198C,0x19AA,0x1D66,0x7FE0,0x1D82,0x1DA2,0x1DC2,0x218C,
	0x21AC,0x21C2,0x258D,0x25AC,0x29AD,0x29AE,0x29AF,0x29CF,
	0x29E2,0x2D91,0x2DB0,0x7FE0,0x2DF0,0x31D0,0x31D1,0x31D2,
	0x31F1,0x31F2,0x3592,0x35D1,0x35D2,0x35F2,0x35F3,0x3A33,
	0x3DF3,0x3DF4,0x3DF5,0x7FE0,0x3E14,0x3E15,0x3E33,0x3E34,
	0x3F62,0x41D3,0x41F5,0x4215,0x4216,0x4234,0x4235,0x4236,
	0x4382,0x4616,0x4617,0x7FE0,0x4636,0x4637,0x4639,0x4656,
	0x4657,0x4676,0x4A17,0x4A19,0x4A37,0x4A39,0x4E77,0x4E78,

	0x4FAD,0x5259,0x525A,0x7FE0,0x5279,0x527A,0x5299,0x5299,
	0x529A,0x53EC,0x53EE,0x5699,0x569A,0x56B9,0x56BA,0x56BC,
	0x5A9C,0x5ABA,0x5ABC,0x7FE0,0x5BF1,0x5EFB,0x5EFC,0x62BD,
	0x62FD,0x62FE,0x631D,0x66FD,0x671D,0x671E,0x673D,0x67B2,
	0x67D4,0x6B3E,0x6B3F,0x7FE0,0x6F7F,0x737F,0x739E,0x739F,
	0x73FD,0x77BF,0x77F9,0x7BBE,0x7BDD,0x7BFC,0x7FFA,0x7FFB,
	0x7FFC,0x7FFD,0x7FFF,0x7FE0,0x1D6C,0x2DD0,0x3E13,0x4635,
	0x5278,0x5ABD,0x6F7F,0x3C48,0x3C48,0x3C48,0x3C48,0x3C48,
	0x3C48,0x3C48,0x3C48,0x3971,0x0842,0x15C6,0x2666,0x1E8C,
	0x270A,0x32F1,0x2EAB,0x3BCF,0x3BD2,0x4BEE,0x53F6,0x5B94,
	0x6BB5,0x6FFB,0x7BDE,0xFFFF,0x0005,0x40CE,0x4232,0x56F8
};
static UINT16 bloodwar_mcu_4_0e[] = { // Warrior 4 Player 2
	0x0005,0x40CE,0x4232,0x56F8,0x2D8D,0x1D08,0x254A,0x2D8C,
	0x35CE,0x3E10,0x4652,0x4E94,0x56D6,0x5F18,0x675A,0x6F9C,
	0x7BDE,0x7BF9,0x6FF5,0x6BD4,0x63F1,0x538D,0x63F2,0x57EE,
	0x57EF,0x53EE,0x57CE,0x36E7,0x4FCD,0x4FEC,0x4FCA,0x2F06,
	0x1A63,0x3B29,0x1201,0x1622,0x0DC1,0x3F4A,0x3707,0x1A42,
	0x1221,0x3307,0x2EC6,0x0DE1,0x1E63,0x434B,0x53AC,0x67F0,
	0x1E24,0x3EE9,0x472B,0x4B4C,0x6BF3,0x6FF5,0x73F6,0x73F6,
	0x73F6,0x73F5,0x6FF5,0x5FF0,0x5FF1,0x476A,0x19A1,0x1161,
	0x19E1,0x2AC5,0x32C7,0x32E6,0x3F6A,0x3B28,0x2665,0x0941,
	0x3289,0x47CB,0x4BEB,0x4389,0x1A44,0x2285,0x2AA6,0x2284,
	0x1A23,0x7FFF,0x7FFE,0x7FFD,0x7FFD,0x77F9,0x5370,0x5392,
	0x4B2F,0x5792,0x5BB3,0x4F31,0x7FFD,0x7FFC,0x73D8,0x4F11,
	0x46F0,0x3E8E,0x322B,0x4EF1,0x4ED3,0x5332,0x5773,0x46AF,
	0x428F,0x266F,0x3AB0,0x364C,0x29E9,0x2A6D,0x2DEA,0x29C9,
	0x25C9,0x25C8,0x2E4B,0x1144,0x0D64,0x21A7,0x3B0B,0x2207,
	0x478E,0x4FB0,0x4B8F,0x53D2,0x6FF6,0x7FFA,0x6FF8,0x5FF4,

	0x36CC,0x536F,0x474D,0x3AEC,0x2A49,0x1DE5,0x2627,0x2E88,
	0x2E89,0x1E05,0x1184,0x0D24,0x15A6,0x1104,0x0D23,0x08E2,
	0x08E1,0x6BFF,0x577D,0x42D8,0x3697,0x3677,0x3256,0x3A98,
	0x3EBA,0x3EB9,0x3AB8,0x3654,0x2E55,0x2A13,0x3274,0x2610,
	0x21F1,0x2A91,0x0545,0x0946,0x2631,0x2A4F,0x2231,0x21AE,
	0x0566,0x15C8,0x29ED,0x25EC,0x222A,0x2EB0,0x36B4,0x3A94,
	0x1E11,0x7FFF,0x77F9,0x3ACA,0x3288,0x2A66,0x4B4E,0x3EEB,
	0x0900,0x2606,0x1563,0x0940,0x1142,0x1E43,0x430C,0x430B,
	0x3F0A,0x5FF3,0x53B0,0x3689,0x1DE3,0x2E67,0x15A2,0x5791,
	0x15A2,0x2E68,0x15A2,0x4F6E,0x2A47,0x4B2E,0x2607,0x2E47,
	0x3A8A,0x5390,0x3688,0x7BF8,0x77FB,0x5FD5,0x5BD4,0x73F7,
	0x77F9,0x3F0A,0x4F4F,0x2608,0x6FF7,0x5FF4,0x5FF1,0x5BB1,
	0x3EEA,0x4F6E,0x3EEC,0x1583,0x4B2D,0x57B1,0x2605,0x25C5,
	0x536F,0x73FA,0x6FF9,0x328A,0x3ECD,0x470D,0x5792,0x474E,
	0x5371,0x4191,0x3C00,0x4000,0x4400,0x4800,0x4C21,0x5063,
	0x5484,0x5CA5,0x64C6,0x7063,0x78A5,0x7DCE,0x7E94,0x7F39,

	0x7BDE,0xFFFF,0x41D3,0x0300,0x0340,0x0362,0x03A2,0x03C9,
	0x1FCC,0x27EE,0x37F0,0x3FF3,0x47F6,0x53FB,0x5FFF,0x6BFF,
	0x6FFF,0x7FFF,0xFFFF,0x4191,0x0019,0x001B,0x001C,0x18DD,
	0x295D,0x319F,0x39DF,0x421F,0x4A5F,0x529F,0x5ADF,0x631F,
	0x6B5F,0x739F,0x7BDE,0xFFFF,0x4191,0x2EE0,0x3300,0x3B20,
	0x4340,0x4760,0x4F80,0x57A1,0x5BC0,0x67E2,0x6FE4,0x77E6,
	0x7BEF,0x7FF4,0x7FFB,0x7BDE,0xFFFF,0x0005,0x40CE,0x4232
};
static UINT16 bloodwar_mcu_4_0f[] = { // Warrior 4 Player 1
	0x0005,0x40CE,0x4232,0x56F8,0x2D8D,0x20E9,0x292B,0x316D,
	0x39AF,0x41F1,0x4A33,0x5275,0x5AB7,0x62F9,0x6B3B,0x737D,
	0x7BDF,0x7FFA,0x73F6,0x6FF5,0x67F2,0x57CE,0x67F3,0x5BEF,
	0x5BF0,0x57EF,0x5BEF,0x3B08,0x53EE,0x53ED,0x53EB,0x3327,
	0x1E84,0x3B29,0x1201,0x1622,0x0DC1,0x3F4A,0x3707,0x1A42,
	0x1221,0x3307,0x2EC6,0x0DE1,0x1E63,0x434B,0x53AC,0x67F0,
	0x1E24,0x3EE9,0x472B,0x4B4C,0x6BF3,0x6FF5,0x6FF6,0x73F7,
	0x73F6,0x73F7,0x6FF5,0x5FF0,0x5FF1,0x476A,0x19A1,0x1161,
	0x19E1,0x2AC5,0x32C7,0x32E6,0x3F6A,0x3B28,0x2665,0x0941,
	0x3289,0x47CB,0x4BEB,0x4389,0x1A44,0x2285,0x2AA6,0x2284,
	0x1A23,0x7FFF,0x7FFE,0x7FFD,0x7FFC,0x77F9,0x5370,0x5392,
	0x4B2F,0x5792,0x5BB3,0x4F31,0x7FFC,0x7FFB,0x73F8,0x4F11,
	0x46F0,0x3ECE,0x3289,0x4EF1,0x4F32,0x5332,0x5773,0x46AF,
	0x428F,0x1EC8,0x3309,0x368A,0x2A27,0x22C8,0x2E28,0x2A07,
	0x2607,0x25E6,0x2E69,0x1162,0x0D82,0x21C5,0x3B0B,0x2225,
	0x478E,0x4FB0,0x4B8F,0x53D2,0x6FF6,0x7FFA,0x6FF8,0x5FF4,

	0x36CC,0x538F,0x476D,0x3B0C,0x2A69,0x1E05,0x2647,0x2EA8,
	0x2EA9,0x1E25,0x11C3,0x0D63,0x15E5,0x1143,0x0D62,0x0921,
	0x0920,0x63F8,0x4FF2,0x3B8D,0x2F4C,0x2F2C,0x2B0B,0x334D,
	0x376F,0x376E,0x336D,0x2F09,0x270A,0x22C8,0x2B28,0x1EC5,
	0x1AA6,0x2327,0x05E1,0x05E1,0x1EC5,0x22E5,0x1AC5,0x1A44,
	0x0601,0x0E61,0x2283,0x1E82,0x1A81,0x2B46,0x2F49,0x332A,
	0x16A6,0x7FFF,0x77F9,0x3ACA,0x3288,0x2A66,0x4B4E,0x3EEB,
	0x0900,0x2606,0x1563,0x0940,0x1142,0x1E43,0x430C,0x430B,
	0x3F0A,0x5FF3,0x53B0,0x3689,0x1DE3,0x2E67,0x15A2,0x5791,
	0x15A2,0x2E68,0x15A2,0x4F6E,0x2A47,0x4B2E,0x2607,0x2E47,
	0x3A8A,0x5390,0x3688,0x7BF8,0x77FB,0x5FD5,0x5BD4,0x73F7,
	0x77F9,0x3F0A,0x4F4F,0x2608,0x6FF7,0x5FF4,0x5FF1,0x5BB1,
	0x3EEA,0x4B4D,0x3ACB,0x1162,0x470C,0x5390,0x21E4,0x21A4,
	0x4F4E,0x6FF9,0x6BF8,0x2E69,0x3AAC,0x42EC,0x5371,0x432D,
	0x4F50,0x4191,0x3C00,0x4000,0x4400,0x4800,0x4C21,0x5063,
	0x5484,0x5CA5,0x64C6,0x7063,0x78A5,0x7DCE,0x7E94,0x7F39,

	0x7BDE,0xFFFF,0x41D3,0x0300,0x0340,0x0362,0x03A2,0x03C9,
	0x1FCC,0x27EE,0x37F0,0x3FF3,0x47F6,0x53FB,0x5FFF,0x6BFF,
	0x6FFF,0x7FFF,0xFFFF,0x4191,0x0019,0x001B,0x001C,0x18DD,
	0x295D,0x319F,0x39DF,0x421F,0x4A5F,0x529F,0x5ADF,0x631F,
	0x6B5F,0x739F,0x7BDE,0xFFFF,0x4191,0x2EE0,0x3300,0x3B20,
	0x4340,0x4760,0x4F80,0x57A1,0x5BC0,0x67E2,0x6FE4,0x77E6,
	0x7BEF,0x7FF4,0x7FFB,0x7BDE,0xFFFF,0x0009,0x0000,0x4232
};
static UINT16 bloodwar_mcu_4_10[] = { // Warrior 6 Player 1
	0x0009,0x0000,0x4232,0x56F8,0x2D8D,0x27FF,0x3BFF,0x53FF,
	0x63FF,0x401E,0x4C1F,0x581F,0x6C1F,0x7C1F,0x7E1F,0x7EBF,
	0x7BDE,0x4BCD,0x47EC,0x43CA,0x3BC8,0x2F45,0x2703,0x22E2,
	0x1EC1,0x1EE1,0x1AE1,0x16C0,0x12C0,0x0E80,0x0E40,0x1221,
	0x0580,0x2765,0x2324,0x1F03,0x1F23,0x1B22,0x12E0,0x12C1,
	0x1281,0x1241,0x0A00,0x05C0,0x0180,0x0140,0x0540,0x0520,
	0x0100,0x1A42,0x1622,0x1201,0x0E01,0x0580,0x0100,0x1A62,
	0x1E83,0x1641,0x0DE0,0x05A0,0x0560,0x53AF,0x3F4A,0x3308,
	0x2A86,0x3B29,0x2E87,0x1E43,0x26A5,0x1A22,0x1201,0x0DA1,
	0x1602,0x00C0,0x0540,0x0521,0x1663,0x1643,0x0DE1,0x1642,
	0x05C0,0x4EEF,0x5312,0x4AD0,0x3E4B,0x3A4B,0x31E9,0x3A2A,
	0x2DC8,0x2DA8,0x2987,0x2566,0x1D25,0x1504,0x25A7,0x2DC7,
	0x3608,0x2986,0x2DE7,0x3A2A,0x3207,0x25A5,0x21A4,0x29C5,
	0x3A4B,0x466A,0x3A08,0x3A28,0x3A08,0x2564,0x31A5,0x29A6,
	0x3184,0x2965,0x1903,0x2143,0x2163,0x2963,0x2164,0x2DA4,
	0x2583,0x31C5,0x1D63,0x2164,0x31A6,0x35E6,0x31C6,0x3E8A,

	0x3A69,0x2DE7,0x46CD,0x532F,0x3E8B,0x2DE6,0x10E2,0x1502,
	0x4ACD,0x530F,0x2E07,0x08C1,0x25A6,0x10E2,0x1522,0x1523,
	0x25A5,0x4ED1,0x3A2D,0x3A0C,0x31CA,0x360C,0x31EA,0x2DCA,
	0x360B,0x2568,0x2DA9,0x426E,0x468F,0x29A9,0x29A8,0x2588,
	0x1504,0x2988,0x2167,0x360A,0x426D,0x35EC,0x3E2D,0x52D1,
	0x4A90,0x3A2C,0x424E,0x3E4D,0x5310,0x5732,0x426C,0x6795,
	0x5B51,0x5B51,0x6FD5,0x6373,0x52EF,0x1D27,0x2549,0x10C4,
	0x08C2,0x18E6,0x35AE,0x31AC,0x2D8C,0x2DAD,0x31AD,0x256A,
	0x1D28,0x1506,0x0CC4,0x6FF8,0x63B3,0x4AED,0x3E8A,0x4F0F,
	0x42CC,0x6796,0x4A8F,0x3249,0x4AEE,0x5FB2,0x46ED,0x3A6A,
	0x322A,0x7BEE,0x63EA,0x57E9,0x4FA8,0x3B44,0x3AC4,0x2622,
	0x1141,0x4F0B,0x7BF9,0x67F2,0x5FB0,0x25E3,0x4F2D,0x5B70,
	0x4ACD,0x576E,0x574E,0x572F,0x1263,0x0E83,0x0EA3,0x1725,
	0x23C8,0x1304,0x17C4,0x22E6,0x1323,0x0A62,0x0621,0x01C1,
	0x05A1,0x41D3,0x0241,0x02A0,0x02E4,0x0322,0x0369,0x1F8C,
	0x27CE,0x37D0,0x3FF3,0x47F6,0x53FB,0x5FFF,0x6BFF,0x6FFF,

	0x7FFF,0xFFFF,0x4191,0x11E0,0x1A20,0x2680,0x32C0,0x3B00,
	0x4740,0x4F61,0x57A0,0x63E2,0x6FE4,0x77E6,0x7BEF,0x7FF4,
	0x7FFB,0x7BDE,0xFFFF,0x4191,0x2000,0x2800,0x3000,0x3400,
	0x3800,0x4000,0x4800,0x5400,0x5C00,0x6821,0x7084,0x7D29,
	0x7E52,0x7F39,0x7BDE,0xFFFF,0x41D3,0x01D1,0x0215,0x0A77,
	0x12B9,0x16FB,0x273C,0x375D,0x435E,0x4B7F,0x537F,0x5B9F,
	0x639F,0x6FBF,0x77DF,0x7FFF,0xFFFF,0x4191,0x7F40,0x7B60,
	0x7780,0x73A0,0x6FC0,0x6BE0,0x6BE0,0x6FE3,0x73E6,0x77E9,
	0x7BEC,0x7FEF,0x7FF4,0x7FF9,0x7BDE,0x4191,0x6000,0x6400,
	0x6800,0x6C00,0x7021,0x7484,0x78C6,0x7D29,0x7D68,0x7DA6,
	0x7DE4,0x7E23,0x7E82,0x7EE1,0x7BDE,0x21A6,0x2000,0x2400,
	0x2C00,0x3400,0x3800,0x3C00,0x4000,0x4400,0x4800,0x4C00,
	0x5000,0x5400,0x5800,0x5C00,0x31EA,0xFFFF,0x4191,0x47FF,
	0x4BFF,0x4FFF,0x53FF,0x57FF,0x5BFF,0x5FFF,0x63FF,0x67FF,
	0x6BFF,0x6FFF,0x73FF,0x77FF,0x7BFF,0x7BDE,0x0421,0x179F,
	0x1BBF,0x1FDF,0x23FF,0x27FF,0x2BFF,0x2FFF,0x33FF,0x37FF,

	0x3BFF,0x3FFF,0x43FF,0x47FF,0x4BFF,0x7BDE,0x21A6,0x143F,
	0x10BF,0x0D1F,0x099F,0x05FF,0x063F,0x0A7F,0x0ABF,0x0EDF,
	0x0EFF,0x131F,0x133F,0x175F,0x177F,0x31EA,0xFFFF,0x4191,
	0x53E0,0x57E0,0x5BE0,0x5FE0,0x63E0,0x67E0,0x6BE0,0x6FE3,
	0x73E6,0x77E9,0x7BEC,0x7FEF,0x7FF4,0x7FF9,0x7BDE,0x0421,
	0x1BE0,0x1FE0,0x23E0,0x27E0,0x2BE0,0x2FE0,0x33E0,0x37E0,
	0x3BE0,0x3FE0,0x43E0,0x47E0,0x4BE0,0x4FE0,0x7BDE,0x21A6,
	0x1600,0x1620,0x1640,0x1660,0x1680,0x16A0,0x16C0,0x16E0,
	0x1700,0x1720,0x1740,0x1760,0x1780,0x1BA0,0x31EA,0xFFFF,
	0x4191,0x03EF,0x03EA,0x03E5,0x03E0,0x03E0,0x17E0,0x2BE0,
	0x3FE0,0x53E0,0x67E0,0x7FE0,0x7FEF,0x7FF4,0x7FF9,0x7BDE,
	0x0000,0x641F,0x501F,0x3C1F,0x281F,0x141F,0x001F,0x00BF,
	0x015F,0x01FF,0x029F,0x033F,0x03FF,0x03F9,0x03F4,0x7BDE,
	0x0000,0x7FEA,0x7FE0,0x7F20,0x7E80,0x7DE0,0x7D40,0x7CA0,
	0x7C00,0x7C05,0x780A,0x7C0F,0x7C14,0x7C19,0x7C1F,0x7BDE,
	0xFFFF,0x0009,0x0000,0x4232,0x56F8,0x2D8D,0x6C1F,0x7C1F
};
static UINT16 bloodwar_mcu_4_11[] = { // Warrior 6 Player 2
	0x0009,0x0000,0x4232,0x56F8,0x2D8D,0x6C1F,0x7C1F,0x7E1F,
	0x7EBF,0x5C13,0x5C52,0x6432,0x7075,0x7992,0x7DF6,0x7EF9,
	0x7BDE,0x52F2,0x4F11,0x4AEF,0x42CD,0x368A,0x2E48,0x2A27,
	0x2606,0x2626,0x2226,0x1E05,0x1A05,0x15C4,0x1584,0x1966,
	0x0CC4,0x2E69,0x2A48,0x2627,0x2647,0x2246,0x1A04,0x19E5,
	0x19C5,0x1985,0x1144,0x0D04,0x08C4,0x08A4,0x0CA4,0x0C84,
	0x0864,0x21A6,0x1D86,0x1965,0x1565,0x1104,0x10A4,0x21C6,
	0x25E7,0x1DA5,0x1544,0x1124,0x10E4,0x5B13,0x46AE,0x3A6C,
	0x31EA,0x428D,0x35EB,0x2587,0x2DE9,0x2166,0x1945,0x1505,
	0x1D66,0x0C64,0x10C4,0x10A5,0x1DC7,0x1DA7,0x1545,0x1DA6,
	0x0D24,0x4EEF,0x5312,0x4AD0,0x3E4B,0x3A4B,0x31E9,0x3A2A,
	0x2DC8,0x2DA8,0x2987,0x2566,0x1D25,0x1504,0x25A7,0x2DC7,
	0x3608,0x2986,0x2DE7,0x3A2A,0x3207,0x25A5,0x21A4,0x29C5,
	0x3A4B,0x466A,0x3A08,0x3A28,0x3A08,0x2564,0x31A5,0x29A6,
	0x3184,0x2965,0x1903,0x2143,0x2163,0x2963,0x2164,0x2DA4,
	0x2583,0x31C5,0x1D63,0x2164,0x31A6,0x35E6,0x31C6,0x3E8A,

	0x3A69,0x2DE7,0x46CD,0x532F,0x3E8B,0x2DE6,0x10E2,0x1502,
	0x4ACD,0x530F,0x2E07,0x08C1,0x25A6,0x10E2,0x1522,0x1523,
	0x25A5,0x4ED1,0x3A2D,0x3A0C,0x31CA,0x360C,0x31EA,0x2DCA,
	0x360B,0x2568,0x2DA9,0x426E,0x468F,0x29A9,0x29A8,0x2588,
	0x1504,0x2988,0x2167,0x360A,0x426D,0x35EC,0x3E2D,0x52D1,
	0x4A90,0x3A2C,0x424E,0x3E4D,0x5310,0x5732,0x426C,0x6795,
	0x5B51,0x5B51,0x6FD5,0x6373,0x52EF,0x1D27,0x2549,0x10C4,
	0x08C2,0x18E6,0x35AE,0x31AC,0x2D8C,0x2DAD,0x31AD,0x256A,
	0x1D28,0x1506,0x0CC4,0x6FF8,0x63B3,0x4AED,0x3E8A,0x4F0F,
	0x42CC,0x6796,0x4A8F,0x3249,0x4AEE,0x5FB2,0x46ED,0x3A6A,
	0x322A,0x7BEE,0x63EA,0x57E9,0x4FA8,0x3B44,0x3AC4,0x2622,
	0x1141,0x4F0B,0x7BF9,0x67F2,0x5FB0,0x25E3,0x4F2D,0x5B70,
	0x4ACD,0x576E,0x574E,0x572F,0x1263,0x0E83,0x0EA3,0x1725,
	0x23C8,0x1304,0x17C4,0x22E6,0x1323,0x0A62,0x0621,0x01C1,
	0x05A1,0x41D3,0x0241,0x02A0,0x02E4,0x0322,0x0369,0x1F8C,
	0x27CE,0x37D0,0x3FF3,0x47F6,0x53FB,0x5FFF,0x6BFF,0x6FFF,

	0x7FFF,0xFFFF,0x4191,0x11E0,0x1A20,0x2680,0x32C0,0x3B00,
	0x4740,0x4F61,0x57A0,0x63E2,0x6FE4,0x77E6,0x7BEF,0x7FF4,
	0x7FFB,0x7BDE,0xFFFF,0x4191,0x2000,0x2800,0x3000,0x3400,
	0x3800,0x4000,0x4800,0x5400,0x5C00,0x6821,0x7084,0x7D29,
	0x7E52,0x7F39,0x7BDE,0xFFFF,0x41D3,0x01D1,0x0215,0x0A77,
	0x12B9,0x16FB,0x273C,0x375D,0x435E,0x4B7F,0x537F,0x5B9F,
	0x639F,0x6FBF,0x77DF,0x7FFF,0xFFFF,0x4191,0x7F40,0x7B60,
	0x7780,0x73A0,0x6FC0,0x6BE0,0x6BE0,0x6FE3,0x73E6,0x77E9,
	0x7BEC,0x7FEF,0x7FF4,0x7FF9,0x7BDE,0x4191,0x6000,0x6400,
	0x6800,0x6C00,0x7021,0x7484,0x78C6,0x7D29,0x7D68,0x7DA6,
	0x7DE4,0x7E23,0x7E82,0x7EE1,0x7BDE,0x21A6,0x2000,0x2400,
	0x2C00,0x3400,0x3800,0x3C00,0x4000,0x4400,0x4800,0x4C00,
	0x5000,0x5400,0x5800,0x5C00,0x31EA,0xFFFF,0x4191,0x47FF,
	0x4BFF,0x4FFF,0x53FF,0x57FF,0x5BFF,0x5FFF,0x63FF,0x67FF,
	0x6BFF,0x6FFF,0x73FF,0x77FF,0x7BFF,0x7BDE,0x0421,0x179F,
	0x1BBF,0x1FDF,0x23FF,0x27FF,0x2BFF,0x2FFF,0x33FF,0x37FF,

	0x3BFF,0x3FFF,0x43FF,0x47FF,0x4BFF,0x7BDE,0x21A6,0x143F,
	0x10BF,0x0D1F,0x099F,0x05FF,0x063F,0x0A7F,0x0ABF,0x0EDF,
	0x0EFF,0x131F,0x133F,0x175F,0x177F,0x31EA,0xFFFF,0x4191,
	0x53E0,0x57E0,0x5BE0,0x5FE0,0x63E0,0x67E0,0x6BE0,0x6FE3,
	0x73E6,0x77E9,0x7BEC,0x7FEF,0x7FF4,0x7FF9,0x7BDE,0x0421,
	0x1BE0,0x1FE0,0x23E0,0x27E0,0x2BE0,0x2FE0,0x33E0,0x37E0,
	0x3BE0,0x3FE0,0x43E0,0x47E0,0x4BE0,0x4FE0,0x7BDE,0x21A6,
	0x1600,0x1620,0x1640,0x1660,0x1680,0x16A0,0x16C0,0x16E0,
	0x1700,0x1720,0x1740,0x1760,0x1780,0x1BA0,0x31EA,0xFFFF,
	0x4191,0x03EF,0x03EA,0x03E5,0x03E0,0x03E0,0x17E0,0x2BE0,
	0x3FE0,0x53E0,0x67E0,0x7FE0,0x7FEF,0x7FF4,0x7FF9,0x7BDE,
	0x0000,0x641F,0x501F,0x3C1F,0x281F,0x141F,0x001F,0x00BF,
	0x015F,0x01FF,0x029F,0x033F,0x03FF,0x03F9,0x03F4,0x7BDE,
	0x0000,0x7FEA,0x7FE0,0x7F20,0x7E80,0x7DE0,0x7D40,0x7CA0,
	0x7C00,0x7C05,0x780A,0x7C0F,0x7C14,0x7C19,0x7C1F,0x7BDE,
	0xFFFF,0x0002,0x0000,0x4232,0x56F8,0x2D8D,0x2108,0x294A
};
static UINT16 bloodwar_mcu_4_12[] = { // Warrior 9 Player 1
	0x0002,0x0000,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x1AC2,0x1AE2,0x1B02,0x1703,0x1723,0x1743,0x1763,
	0x1784,0x1BA3,0x17A3,0x1BC4,0x1BC6,0x1FE5,0x12C2,0x1BE5,
	0x1FC5,0x1FA5,0x1B65,0x1F64,0x2386,0x2786,0x1B83,0x1BA4,
	0x23A6,0x23E7,0x1FC5,0x23E7,0x1FE6,0x1FE8,0x1FC8,0x1AA4,
	0x1A84,0x1703,0x1704,0x1B04,0x1F84,0x1723,0x1F46,0x23A7,
	0x1B05,0x1BC4,0x13A3,0x16C3,0x1AE4,0x2FE8,0x43EB,0x37EB,
	0x2FEA,0x37EC,0x3BED,0x3FEE,0x3FED,0x43EE,0x43EE,0x43EE,
	0x33EB,0x37EB,0x37EB,0x33EA,0x3BEC,0x3BEC,0x37EB,0x3FEC,
	0x3FED,0x25C7,0x2E08,0x428E,0x5751,0x5F93,0x5B71,0x67F3,
	0x67B5,0x6FD8,0x6793,0x6FF7,0x73F8,0x6BB6,0x73D8,0x77F9,
	0x77FA,0x428F,0x46CD,0x4B0F,0x46D0,0x5732,0x67D5,0x63B5,
	0x63B5,0x6BB6,0x6BD6,0x6FD7,0x67B7,0x73F9,0x6376,0x6776,
	0x5F54,0x1104,0x10E4,0x10E4,0x1524,0x1525,0x1164,0x15A4,
	0x1965,0x1103,0x1544,0x1103,0x1564,0x1584,0x1604,0x1986,

	0x0CA3,0x1525,0x10E4,0x1925,0x10C4,0x14E5,0x10A4,0x2167,
	0x29A8,0x2587,0x29C9,0x29C8,0x320A,0x320B,0x25A8,0x1DA6,
	0x1D47,0x1128,0x1528,0x1223,0x1664,0x158A,0x19AB,0x1DAC,
	0x21EE,0x21ED,0x220D,0x220C,0x222D,0x194A,0x21CD,0x21AD,
	0x260E,0x220E,0x25EF,0x29E9,0x2DEA,0x3A0C,0x3E2D,0x2A0F,
	0x29EE,0x46D2,0x428F,0x4AD1,0x46B1,0x4690,0x428D,0x2608,
	0x4250,0x2903,0x2D44,0x3565,0x41C8,0x3DA7,0x3986,0x41E8,
	0x4A08,0x41E7,0x45E8,0x524B,0x3526,0x564E,0x49ED,0x3DA8,
	0x416B,0x2E84,0x4746,0x5787,0x4F46,0x57A8,0x4B45,0x5FE9,
	0x5BAB,0x578A,0x57AA,0x5369,0x5FE8,0x53A8,0x4FA7,0x4344,
	0x4345,0x0D63,0x1162,0x1983,0x19A4,0x15A4,0x19C4,0x19E4,
	0x1DE4,0x1A04,0x1E05,0x2246,0x2647,0x2A26,0x2A46,0x2646,
	0x2625,0x2E88,0x3669,0x36AA,0x2626,0x2646,0x2226,0x36EA,
	0x36EB,0x3AEB,0x36CB,0x36CA,0x3ACC,0x3A8B,0x536F,0x63B3,
	0x4B0F,0x290D,0x6004,0x7FFF,0x6409,0x681F,0x281F,0x401F,
	0x2BFF,0x4FFF,0x77FF,0x7C5F,0x681F,0x541F,0x7E15,0x7FE0,

	0x03E0,0x41D3,0x6004,0x3FA6,0x2AA1,0x3724,0x3FA6,0x43E0,
	0x4FE8,0x5BC4,0x63C5,0x67ED,0x6FF0,0x77F3,0x7FFA,0x7FFC,
	0x7FFF,0x2E88,0x3669,0x1E04,0x0DE2,0x2646,0x2226,0x36EA,
	0x2E6A,0x3AEB,0x36CB,0x32A9,0x430C,0x3A8B,0x536F,0x63B3,
	0x4B0F,0x0000,0x201B,0x241D,0x2C1F,0x341F,0x3C1E,0x401F,
	0x481F,0x541F,0x5C1F,0x681F,0x701F,0x7C5F,0x7E5F,0x7B1F,
	0x7BDE,0x7FFA,0x1CC2,0x2065,0x2083,0x24C4,0x24E2,0x2502,
	0x2503,0x28A5,0x2D43,0x2D45,0x2D63,0x2D64,0x3144,0x3145,
	0x3583,0x3584,0x3586,0x3587,0x35C3,0x3986,0x3987,0x39C3,
	0x39E5,0x39E7,0x39E8,0x39E3,0x3A05,0x3A23,0x41C6,0x41E5,
	0x4205,0x420A,0x4226,0x4229,0x4263,0x4265,0x4266,0x4267,
	0x4287,0x46E3,0x4A07,0x4A0B,0x4A26,0x4A27,0x4A29,0x4A65,
	0x4A66,0x4A8A,0x4AA5,0x4AA6,0x4AA8,0x4AC5,0x4AE3,0x524C,
	0x5286,0x5289,0x52A6,0x52C9,0x52E5,0x52E6,0x52E8,0x52E9,
	0x5AC6,0x5AC9,0x5AE6,0x5AE8,0x5AE9,0x5AEB,0x62E6,0x62E8,
	0x62E9,0x62EA,0x62EB,0x62EC,0x6AE8,0x6AEA,0x6AED,0x6AEE,

	0x6AF0,0x6EE8,0x6EEA,0x6EED,0x6EEE,0x6EF0,0x76EA,0x76EB,
	0x76ED,0x770E,0x7710,0x7711,0x7712,0x7713,0x7F0D,0x7F0F,
	0x7F10,0x7F12,0x7F13,0x7F35,0x7F1A,0x7F1B,0x7F0E,0x7F30,
	0x7F32,0x7F38,0x7F5B,0x7F6B,0x7F70,0x7F92,0x7F95,0x7F97,
	0x7F9A,0x7FBE,0x7FDF,0x7F91,0x7FB2,0x7FB3,0x7FB4,0x7FB5,
	0x7FB6,0x7FB7,0x7FB8,0x7FB9,0x7FBF,0x7FBB,0x7FFF,0x7FFF,
	0x0000,0xFFFF,0x0002,0x0000,0x4232,0x56F8,0x2D8D,0x2108
};
static UINT16 bloodwar_mcu_4_13[] = { // Warrior 9 Player 2
	0x0002,0x0000,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x146D,0x1CAF,0x24EF,0x24EF,0x2910,0x3553,0x3DB7,
	0x45B8,0x3993,0x2610,0x4196,0x2632,0x2A52,0x1D2F,0x2652,
	0x569A,0x2A15,0x4A19,0x41D6,0x41F8,0x39D6,0x25F2,0x2613,
	0x2E15,0x2E56,0x2A34,0x2E56,0x2A55,0x2A56,0x2A36,0x1C6D,
	0x2931,0x20B0,0x2D33,0x3133,0x4196,0x3596,0x3575,0x39D6,
	0x3134,0x31D5,0x2994,0x2CF2,0x3113,0x3D98,0x41D8,0x3E3A,
	0x4E1B,0x4DF9,0x521A,0x563B,0x561A,0x5A3C,0x629F,0x5A3C,
	0x49B8,0x5618,0x4DD8,0x4997,0x49F9,0x51F9,0x4DF8,0x561A,
	0x561B,0x25E6,0x2E27,0x42CD,0x5F92,0x5FD2,0x5BB0,0x67F4,
	0x6FF7,0x6FF7,0x67D2,0x6FF6,0x73F7,0x6BF5,0x73F7,0x77F8,
	0x77F9,0x42EC,0x3EE9,0x4B4E,0x470F,0x5771,0x6FF7,0x67F3,
	0x63F3,0x67F4,0x73F7,0x5FB5,0x67F6,0x73F8,0x63B5,0x5FB5,
	0x5F93,0x1063,0x1484,0x18A5,0x0C42,0x1CC6,0x0C42,0x1063,
	0x0C42,0x0C42,0x1484,0x1484,0x1063,0x10C9,0x1449,0x1986,

	0x0C42,0x1484,0x1063,0x1063,0x1484,0x18A5,0x10A4,0x18A5,
	0x29A8,0x18A5,0x29C9,0x29C8,0x320A,0x320B,0x18A5,0x1484,
	0x1D47,0x1128,0x1528,0x1068,0x146B,0x158A,0x19AB,0x1DAC,
	0x21EE,0x21ED,0x220D,0x220C,0x222D,0x194A,0x21CD,0x21AD,
	0x260E,0x220E,0x25EF,0x29E9,0x2DEA,0x3A0C,0x3E2D,0x2A0F,
	0x29EE,0x46D2,0x428F,0x4AD1,0x46B1,0x4690,0x428D,0x2608,
	0x4250,0x11C2,0x1683,0x2302,0x2305,0x1B22,0x1EC3,0x2385,
	0x3FE6,0x3344,0x2FC4,0x4FE7,0x2AE3,0x376B,0x2B0A,0x22C5,
	0x2688,0x2E84,0x4746,0x5787,0x4F46,0x57A8,0x4B45,0x5FE9,
	0x5BAB,0x578A,0x57AA,0x5369,0x5FE8,0x53A8,0x4FA7,0x4344,
	0x4345,0x0D63,0x1162,0x1983,0x19A4,0x15A4,0x19C4,0x19E4,
	0x1DE4,0x1A04,0x1E05,0x2246,0x2647,0x2A26,0x2A46,0x2646,
	0x2625,0x2E88,0x3669,0x36AA,0x2626,0x2646,0x2226,0x36EA,
	0x36EB,0x3AEB,0x36CB,0x36CA,0x4B0D,0x3A8B,0x4F8E,0x63B3,
	0x4B0F,0x290D,0x6004,0x7FFF,0x6409,0x681F,0x281F,0x401F,
	0x2BFF,0x4FFF,0x77FF,0x7C5F,0x681F,0x541F,0x7E15,0x7FE0,

	0x03E0,0x41D3,0x6004,0x3FA6,0x2AA1,0x3724,0x3FA6,0x43E0,
	0x4FE8,0x5BC4,0x63C5,0x67ED,0x6FF0,0x77F3,0x7FFA,0x7FFC,
	0x7FFF,0x2E88,0x3669,0x1E04,0x0DE2,0x2646,0x2226,0x36EA,
	0x2E6A,0x3AEB,0x36CB,0x32A9,0x430C,0x3A8B,0x536F,0x63B3,
	0x4B0F,0x0000,0x201B,0x241D,0x2C1F,0x341F,0x3C1E,0x401F,
	0x481F,0x541F,0x5C1F,0x681F,0x701F,0x7C5F,0x7E5F,0x7B1F,
	0x7BDE,0x7FFA,0x1CC2,0x2065,0x2083,0x24C4,0x24E2,0x2502,
	0x2503,0x28A5,0x2D43,0x2D45,0x2D63,0x2D64,0x3144,0x3145,
	0x3583,0x3584,0x3586,0x3587,0x35C3,0x3986,0x3987,0x39C3,
	0x39E5,0x39E7,0x39E8,0x39E3,0x3A05,0x3A23,0x41C6,0x41E5,
	0x4205,0x420A,0x4226,0x4229,0x4263,0x4265,0x4266,0x4267,
	0x4287,0x46E3,0x4A07,0x4A0B,0x4A26,0x4A27,0x4A29,0x4A65,
	0x4A66,0x4A8A,0x4AA5,0x4AA6,0x4AA8,0x4AC5,0x4AE3,0x524C,
	0x5286,0x5289,0x52A6,0x52C9,0x52E5,0x52E6,0x52E8,0x52E9,
	0x5AC6,0x5AC9,0x5AE6,0x5AE8,0x5AE9,0x5AEB,0x62E6,0x62E8,
	0x62E9,0x62EA,0x62EB,0x62EC,0x6AE8,0x6AEA,0x6AED,0x6AEE,

	0x6AF0,0x6EE8,0x6EEA,0x6EED,0x6EEE,0x6EF0,0x76EA,0x76EB,
	0x76ED,0x770E,0x7710,0x7711,0x7712,0x7713,0x7F0D,0x7F0F,
	0x7F10,0x7F12,0x7F13,0x7F35,0x7F1A,0x7F1B,0x7F0E,0x7F30,
	0x7F32,0x7F38,0x7F5B,0x7F6B,0x7F70,0x7F92,0x7F95,0x7F97,
	0x7F9A,0x7FBE,0x7FDF,0x7F91,0x7FB2,0x7FB3,0x7FB4,0x7FB5,
	0x7FB6,0x7FB7,0x7FB8,0x7FB9,0x7FBF,0x7FBB,0x7FFF,0x7FFF,
	0x0000,0xFFFF,0x0006,0x0000,0x4232,0x56F8,0x2D8D,0x2108
};
static UINT16 bloodwar_mcu_4_14[] = { // Warrior 7 Player 1
	0x0006,0x0000,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x0D00,0x0D00,0x0D40,0x0D40,0x0D60,0x0D80,0x1140,
	0x1561,0x1581,0x15A1,0x15E1,0x1601,0x19A1,0x19C1,0x19C2,
	0x19E1,0x1E23,0x1E42,0x1E43,0x1E82,0x2204,0x2223,0x2242,
	0x2243,0x2244,0x2262,0x2263,0x22A2,0x22A3,0x2664,0x2683,
	0x2684,0x2AA3,0x2AA4,0x2EC3,0x2EC4,0x32A4,0x32C3,0x32C4,
	0x3304,0x3305,0x3325,0x3344,0x36C5,0x3704,0x3705,0x3706,
	0x3707,0x3B45,0x3B46,0x3B65,0x3B84,0x3B85,0x3F05,0x3F27,
	0x3F28,0x3F44,0x3F46,0x3F47,0x3F65,0x3F66,0x3F67,0x3F85,
	0x3FA5,0x4328,0x4347,0x43A6,0x47A7,0x47A8,0x47C6,0x47C7,
	0x47E5,0x47E6,0x4B69,0x4BA7,0x4BA8,0x4BC6,0x4BC7,0x4BC8,
	0x4BE7,0x57E9,0x57E8,0x57E7,0x5BCA,0x5BE9,0x5BEA,0x5BEC,
	0x5BE8,0x5BE9,0x5BE8,0x5BEB,0x5F6E,0x5FCD,0x5FEB,0x5FE9,
	0x5BEC,0x67E9,0x67EA,0x67EC,0x67ED,0x6FED,0x6FED,0x6FEE,
	0x6FEF,0x6FEC,0x6FEC,0x6FED,0x6FEB,0x6FED,0x6FEC,0x73EE,

	0x73EC,0x77F1,0x77F0,0x77F1,0x7BF1,0x7BF2,0x7BF3,0x7BF1,
	0x7BF2,0x7FF2,0x7FF4,0x7FF2,0x7FF4,0x7FF2,0x7FF4,0x7FF4,
	0x7FF5,0x33E9,0x0D82,0x0DC1,0x0DC2,0x0DE1,0x0DE2,0x0E02,
	0x1223,0x1243,0x1263,0x12A3,0x12C3,0x12E3,0x1303,0x1323,
	0x1343,0x16E3,0x1703,0x1723,0x1743,0x1783,0x1784,0x17A3,
	0x17A4,0x17C4,0x17E4,0x1AC3,0x1AE3,0x1AE4,0x1B03,0x1B04,
	0x1B43,0x1F45,0x1F65,0x1F85,0x1FA4,0x1FA5,0x1FA6,0x1FC5,
	0x1FE5,0x1FE6,0x1FE8,0x23E6,0x23E7,0x23E8,0x23E8,0x27E7,
	0x27E7,0x2BE8,0x2BE9,0x2BEA,0x2BE8,0x2FE9,0x2FEA,0x2FE9,
	0x2FEA,0x2FE9,0x2FE9,0x2FEB,0x33EB,0x3BEB,0x3FEE,0x3FEE,
	0x47F0,0x7FF8,0x25E6,0x29A6,0x29A7,0x2DE7,0x3A0A,0x46AC,
	0x4ACC,0x4EEF,0x4F2F,0x532F,0x574E,0x67F1,0x63D2,0x63EF,
	0x63F1,0x6BF5,0x6BF6,0x6FB7,0x6FF5,0x6FF6,0x6FF7,0x6FF6,
	0x77F6,0x77F7,0x77F8,0x77F9,0x7BF8,0x7FFA,0x7FFB,0x7BDC,
	0x7FFA,0x41D3,0x0000,0x0000,0x131A,0x2BBF,0x4FBF,0x23E0,
	0x43E0,0x67ED,0x4C07,0x6409,0x7CCF,0x3C1F,0x541F,0x6C1F,

	0x7FFF,0x7C00,0x3786,0x37A6,0x3B86,0x3BC6,0x3F47,0x3F86,
	0x3FC6,0x3FE6,0x3FE7,0x47A7,0x47C6,0x47C7,0x47E6,0x47E7,
	0x4BA7,0x4BA8,0x4BC7,0x4BC8,0x4BE7,0x4BE8,0x4FA8,0x4FC8,
	0x4FE8,0x53C8,0x53CA,0x53CB,0x53EA,0x53EB,0x53EC,0x5BCC,
	0x5BCD,0x5BD0,0x5BEB,0x5BEC,0x5BED,0x5BEE,0x5FD0,0x5FED,
	0x5FEF,0x5FF0,0x5FF2,0x63EF,0x63F1,0x63F2,0x63F3,0x63F5,
	0x63F6,0x6BF3,0x6BF5,0x6BF6,0x6BF7,0x6BF8,0x6FF6,0x6FF7,
	0x6FF8,0x6FFA,0x6FFB,0x6FFC,0x73FB,0x73FC,0x73FD,0x73FF,
	0x7FFF,0x53E7,0x5FE8,0x4FE7,0x4BE7,0x3FE6,0x37C6,0x33A6,
	0x2BA6,0x2366,0x2325,0x2346,0x2304,0x2786,0x2306,0x2746,
	0x1F24,0x1F04,0x2345,0x1F06,0x33C6,0x33E6,0x27A6,0x2785,
	0x2B86,0x1EC4,0x37E6,0x37A6,0x3BE6,0x2745,0x47E6,0x4BE6,
	0x4FE6,0x47E7,0x5BE8,0x5BEA,0x3B86,0x3766,0x4BE8,0x53E8,
	0x5FEA,0x63EB,0x6FEF,0x73F0,0x73F1,0x6FF0,0x6FED,0x6BEC,
	0x63EA,0x5FE9,0x63E9,0x1AE4,0x2365,0x2BA5,0x27A5,0x1AA4,
	0x22C6,0x2B85,0x1A24,0x3386,0x3FC6,0x3FE7,0x2726,0x2B46,

	0x3366,0x15C4,0x15E5,0x1644,0x1605,0x1604,0x1E84,0x1EC6,
	0x2306,0x15E4,0x1625,0x22C6,0x1664,0x1624,0x1EA6,0x1E86,
	0x1645,0x6ABB,0x6A9B,0x6A5B,0x663A,0x661A,0x5DD9,0x5D99,
	0x5519,0x48B7,0x4896,0x140C,0x140D,0x140B,0x100B,0x100A,
	0x1009,0x0C08,0x0C09,0x200F,0x200D,0x1C0D,0x1C0A,0x200C,
	0x200A,0x2009,0x202A,0x204A,0x208B,0x24C9,0x24C7,0x356D,
	0x1C0C,0x1410,0x1412,0x1C13,0x2015,0x2417,0x2C17,0x3419,
	0x3819,0x4419,0x4877,0x4C39,0x4C59,0x4C79,0x543A,0x5479,
	0x55D6,0x5859,0x5879,0x5CB9,0x5CBA,0x5CDA,0x5D39,0x5D59,
	0x5D9B,0x60F9,0x651B,0x655B,0x6A1B,0x6A3B,0x6ABB,0x6ADB,
	0x6F1B,0xFFFF,0x396C,0x7FE0,0x7C1F,0x7C00,0x001F,0x03FF,
	0x301F,0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,0x7DFF,
	0x7E9F,0x7BDE,0x7F9F,0x186B,0x1CAB,0x1C6C,0x208E,0x204F,
	0x28B2,0x28B2,0x28B2,0x28B2,0x28B2,0x2873,0x2893,0x2C92,
	0x2CB2,0x3074,0x3094,0x30D4,0x30F4,0x3076,0x34D4,0x34F4,
	0x3476,0x34B7,0x34F7,0x3517,0x3478,0x34B8,0x3479,0x3CD6,

	0x3CB7,0x3CB8,0x3D58,0x3CD9,0x3D39,0x3C7B,0x3CBB,0x3CDB,
	0x3CFB,0x3CFC,0x407F,0x44F8,0x4578,0x44D9,0x44F9,0x4539,
	0x44BB,0x44DB,0x455C,0x44BD,0x44DD,0x451D,0x44BE,0x447F,
	0x4D9A,0x4CDA,0x4D3C,0x4CDD,0x4D3E,0x4CBF,0x4CDF,0x4D1F,
	0x4D3F,0x54DE,0x553E,0x54DF,0x551F,0x553F,0x557F,0x5CDF,
	0x5D1F,0x5D3F,0x5D5F,0x5D7F,0x5D9F,0x651F,0x655F,0x65BF,
	0x65DF,0x661F,0x691F,0x695F,0x69BE,0x69DF,0x6A1F,0x715F,
	0x717F,0x71BF,0x71DF,0x721F,0x723F,0x725F,0x727F,0x75BF,
	0x75FF,0x761F,0x723F,0x725F,0x769F,0x773F,0x7B7F,0x75BF,
	0x75FF,0x7A3F,0x7AFF,0x7F7F,0x755F,0x75FF,0x763F,0x7A9F,
	0x7ADF,0x7F5F,0x7FBF,0x7FDF,0x75FF,0x761F,0x763F,0x765F,
	0x7A7F,0x7A9F,0x7ABF,0x7EDF,0x7EFF,0x7F3F,0x7F7F,0x7FBF,
	0x7FFF,0x0000,0xFFFF,0x31EC,0x7FE0,0x7C1F,0x7C00,0x001F,
	0x03FF,0x301F,0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,
	0x7DFF,0x7E9F,0x7BDE,0x7FFC,0x1C40,0x1C81,0x2060,0x2880,
	0x2C80,0x38C1,0x38C1,0x38C1,0x38C1,0x38C1,0x3CC0,0x3CC0,

	0x38E0,0x38E1,0x4100,0x4500,0x4503,0x4503,0x4D00,0x4522,
	0x4522,0x4D20,0x5121,0x5123,0x5124,0x5520,0x5521,0x5920,
	0x4D62,0x5161,0x5561,0x5565,0x5961,0x5964,0x6160,0x6160,
	0x6161,0x6162,0x6562,0x6982,0x55A2,0x59A6,0x59A1,0x59A2,
	0x59A4,0x61A0,0x61A1,0x65A4,0x69A0,0x69A0,0x69A2,0x6DA0,
	0x71A0,0x5DE6,0x5DE0,0x65E3,0x69E0,0x6DE3,0x71E0,0x71E1,
	0x71E3,0x71C3,0x6E20,0x6E24,0x7221,0x7223,0x7224,0x7226,
	0x7261,0x7263,0x7264,0x7265,0x7266,0x7267,0x72A3,0x72A5,
	0x72A8,0x72A9,0x72AB,0x72C3,0x72C5,0x72C7,0x72C9,0x72C1,
	0x7306,0x7306,0x7308,0x7309,0x730B,0x730C,0x730D,0x730E,
	0x7328,0x732A,0x732B,0x7308,0x774C,0x7B90,0x7BB4,0x7FD9,
	0x7728,0x774B,0x7B8C,0x7FB5,0x7FD9,0x7725,0x772A,0x7B4D,
	0x7B70,0x7FB4,0x7FF9,0x7FFC,0x7FFD,0x7B4A,0x7B4B,0x7B4C,
	0x7B2D,0x7B6E,0x7B6F,0x7B90,0x7BB2,0x7BB3,0x7FD6,0x7FD8,
	0x7BDA,0x7FFE,0x0000,0xFFFF,0x396C,0x7FE0,0x7C1F,0x7C00,
	0x001F,0x03FF,0x301F,0x401F,0x501F,0x5C1F,0x681F,0x701F,

	0x7C5F,0x7DFF,0x7E9F,0x7BDE,0x7F9F,0x1DD0,0x25F0,0x1DF1,
	0x2213,0x1A14,0x1E17,0x2237,0x2637,0x2657,0x2657,0x1E58,
	0x2278,0x2278,0x2678,0x1E99,0x22B9,0x2AB9,0x2EB9,0x1EBB,
	0x2AD9,0x2ED9,0x1EDB,0x2EDC,0x36DC,0x32DC,0x1EDD,0x26DE,
	0x1EDE,0x2B1B,0x271C,0x271D,0x3B3C,0x2B3D,0x331C,0x1B1E,
	0x26FE,0x2B1E,0x2F1F,0x2F1F,0x1F3F,0x335B,0x373B,0x2F3C,
	0x333C,0x333C,0x2B3E,0x2F3E,0x375E,0x235F,0x2F1F,0x2F5F,
	0x235F,0x1B5F,0x2B7A,0x2F9A,0x339C,0x2B9D,0x339E,0x379F,
	0x379F,0x3F9F,0x3F9F,0x3BDE,0x3B9E,0x2F9F,0x379F,0x3B9F,
	0x439F,0x2B9F,0x379F,0x3B9F,0x3F9F,0x439F,0x479F,0x37BF,
	0x3FDF,0x4BDF,0x4FDF,0x57DF,0x37BF,0x3FDF,0x479E,0x4B9F,
	0x539F,0x47DF,0x4BDF,0x4FDF,0x53DF,0x57DF,0x5BDF,0x5FDF,
	0x63FF,0x57FF,0x5BFF,0x5FFF,0x5BDF,0x63DF,0x6BFF,0x73FF,
	0x7BFF,0x5FFF,0x63FF,0x67FF,0x73FF,0x7BFF,0x5FFF,0x63FF,
	0x67FF,0x6FFF,0x73FF,0x77FF,0x7FBF,0x7FDF,0x57FF,0x5BFF,
	0x5FFF,0x63FF,0x67FF,0x6BFF,0x6FFF,0x73FF,0x77FF,0x7BFF,

	0x7BFF,0x7FFF,0x7FFF,0x0000,0xFFFF,0x28ED,0x7FE0,0x7C1F,
	0x7C00,0x001F,0x03FF,0x301F,0x401F,0x501F,0x5C1F,0x681F,
	0x701F,0x7C5F,0x7DFF,0x7E9F,0x7BDE,0x7FFA,0x1180,0x1580,
	0x15C0,0x19C0,0x1600,0x1A00,0x1A40,0x1E40,0x1E80,0x2280,
	0x1EA0,0x22A0,0x1EC0,0x22C0,0x26C0,0x2300,0x2302,0x2303,
	0x2300,0x2702,0x2B03,0x2720,0x2723,0x2743,0x2744,0x2760,
	0x2761,0x2762,0x2B60,0x2B62,0x2F61,0x3366,0x3380,0x3383,
	0x33A6,0x33A1,0x33A2,0x33C3,0x37C3,0x37C0,0x3762,0x3766,
	0x3781,0x3782,0x3784,0x37A0,0x37A1,0x3BA6,0x3BC1,0x3BC2,
	0x3BC4,0x3BE0,0x3BE3,0x3F87,0x3FA1,0x3FA4,0x3FC1,0x3FE4,
	0x3FE0,0x3FE1,0x3FE3,0x3FE4,0x43E0,0x4BE2,0x4BE4,0x4BE6,
	0x4BE8,0x4BEA,0x53E2,0x53E4,0x53E6,0x53E8,0x53EA,0x53EC,
	0x5BE4,0x5BE6,0x5BE8,0x5BEA,0x5BEC,0x5FE4,0x5FE6,0x5FE8,
	0x5FEA,0x5FEC,0x67E2,0x67E4,0x67E6,0x67E8,0x67EA,0x67EC,
	0x6FE8,0x6FEA,0x6FEC,0x6FEE,0x6FF0,0x73E0,0x73E8,0x73F0,
	0x73F4,0x73F9,0x77E0,0x77E8,0x77F0,0x77F4,0x77F9,0x7BE2,

	0x7BE6,0x7BEC,0x7BF2,0x7BF5,0x7BF9,0x7FFB,0x7BFC,0x77E0,
	0x77E2,0x77E4,0x77E6,0x77E8,0x7BEA,0x7BED,0x7BF0,0x7BF3,
	0x7BF6,0x7BF9,0x7BFB,0x7FFF,0x0000,0xFFFF,0x0006,0x3CB1
};
static UINT16 bloodwar_mcu_4_15[] = { // Warrior 7 Player 2
	0x0006,0x3CB1,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x1CCB,0x1049,0x184A,0x18E9,0x1CAA,0x1C4C,0x20AE,
	0x210D,0x214C,0x20EB,0x210D,0x20CB,0x292D,0x252D,0x292E,
	0x252D,0x254C,0x292E,0x254C,0x252C,0x294D,0x290C,0x2D2D,
	0x294C,0x2D4D,0x314F,0x296F,0x318E,0x3570,0x3571,0x3551,
	0x3531,0x35D0,0x39F1,0x3190,0x3DD1,0x41D1,0x3E12,0x41D3,
	0x3DB3,0x39B2,0x3DF2,0x4253,0x45F3,0x49F2,0x3DD2,0x3E32,
	0x41B3,0x4A55,0x4654,0x41F3,0x4613,0x45D3,0x4A56,0x4A75,
	0x45D4,0x45F4,0x4E35,0x45F2,0x4612,0x4674,0x45F4,0x4A35,
	0x4A35,0x4E35,0x4A55,0x4633,0x4A14,0x4E76,0x5696,0x4E75,
	0x5257,0x5A78,0x5296,0x4E76,0x4A35,0x5278,0x56D7,0x5B19,
	0x4E97,0x673C,0x631B,0x5ADA,0x6B1C,0x673C,0x66FE,0x66FB,
	0x5EFA,0x5ADA,0x5ED9,0x62FC,0x671A,0x6B1B,0x673C,0x677D,
	0x66FA,0x777F,0x777F,0x735F,0x6B7E,0x777F,0x7B9F,0x6F5F,
	0x6B9E,0x733D,0x6B1E,0x737F,0x6F5E,0x6F5E,0x6B3D,0x737F,

	0x6F3E,0x7FFF,0x7FFF,0x7FDF,0x7BBF,0x7FDF,0x7B9F,0x777F,
	0x7B9F,0x779F,0x7BBF,0x7FFF,0x7FFF,0x7BBF,0x7FDF,0x779F,
	0x7FDF,0x3FE7,0x0940,0x0960,0x0960,0x0980,0x09A0,0x09C0,
	0x1200,0x1220,0x1240,0x16A0,0x1AC0,0x1AE0,0x2760,0x1F40,
	0x1F60,0x26E0,0x2700,0x2720,0x2740,0x2780,0x2781,0x27A0,
	0x27A1,0x27C1,0x27E1,0x22C0,0x22E0,0x22E1,0x2300,0x2300,
	0x2340,0x3762,0x3782,0x37A2,0x37C1,0x37C2,0x37C3,0x37E2,
	0x37E2,0x37E3,0x37E5,0x3BE3,0x3BE4,0x3BE5,0x3BE5,0x3FE4,
	0x3FE4,0x4BE5,0x4BE6,0x4BE7,0x4BE5,0x4FE6,0x4FE7,0x4FE6,
	0x4FE7,0x4FE6,0x4FE6,0x4FE8,0x53E8,0x5BE8,0x5FEB,0x5FEB,
	0x67ED,0x6FF5,0x2245,0x1E03,0x21E5,0x2A46,0x3688,0x3F08,
	0x3707,0x3F48,0x47AB,0x4FAB,0x53AD,0x5FEF,0x57ED,0x57EC,
	0x57EE,0x4FCD,0x57F0,0x5BD1,0x5BEF,0x5FF0,0x5FF1,0x5FF2,
	0x63F0,0x63F1,0x63F2,0x63F3,0x6FF4,0x6BF4,0x6BF5,0x73F6,
	0x77F6,0x41D3,0x0000,0x0000,0x131A,0x2BBF,0x4FBF,0x23E0,
	0x43E0,0x67ED,0x4C07,0x6409,0x7CCF,0x3C1F,0x541F,0x6C1F,

	0x7FFF,0x7C00,0x3786,0x37A6,0x3B86,0x3BC6,0x3F47,0x3F86,
	0x3FC6,0x3FE6,0x3FE7,0x47A7,0x47C6,0x47C7,0x47E6,0x47E7,
	0x4BA7,0x4BA8,0x4BC7,0x4BC8,0x4BE7,0x4BE8,0x4FA8,0x4FC8,
	0x4FE8,0x53C8,0x53CA,0x53CB,0x53EA,0x53EB,0x53EC,0x5BCC,
	0x5BCD,0x5BD0,0x5BEB,0x5BEC,0x5BED,0x5BEE,0x5FD0,0x5FED,
	0x5FEF,0x5FF0,0x5FF2,0x63EF,0x63F1,0x63F2,0x63F3,0x63F5,
	0x63F6,0x6BF3,0x6BF5,0x6BF6,0x6BF7,0x6BF8,0x6FF6,0x6FF7,
	0x6FF8,0x6FFA,0x6FFB,0x6FFC,0x73FB,0x73FC,0x73FD,0x73FF,
	0x7FFF,0x53E7,0x5FE8,0x4FE7,0x4BE7,0x3FE6,0x37C6,0x33A6,
	0x2BA6,0x2366,0x2325,0x2346,0x2304,0x2786,0x2306,0x2746,
	0x1F24,0x1F04,0x2345,0x1F06,0x33C6,0x33E6,0x27A6,0x2785,
	0x2B86,0x1EC4,0x37E6,0x37A6,0x3BE6,0x2745,0x47E6,0x4BE6,
	0x4FE6,0x47E7,0x5BE8,0x5BEA,0x3B86,0x3766,0x4BE8,0x53E8,
	0x5FEA,0x63EB,0x6FEF,0x73F0,0x73F1,0x6FF0,0x6FED,0x6BEC,
	0x63EA,0x5FE9,0x63E9,0x1AE4,0x2365,0x2BA5,0x27A5,0x1AA4,
	0x22C6,0x2B85,0x1A24,0x3386,0x3FC6,0x3FE7,0x2726,0x2B46,

	0x3366,0x15C4,0x15E5,0x1644,0x1605,0x1604,0x1E84,0x1EC6,
	0x2306,0x15E4,0x1625,0x22C6,0x1664,0x1624,0x1EA6,0x1E86,
	0x1645,0x6ABB,0x6A9B,0x6A5B,0x663A,0x661A,0x5DD9,0x5D99,
	0x5519,0x48B7,0x4896,0x140C,0x140D,0x140B,0x100B,0x100A,
	0x1009,0x0C08,0x0C09,0x200F,0x200D,0x1C0D,0x1C0A,0x200C,
	0x200A,0x2009,0x202A,0x204A,0x208B,0x24C9,0x24C7,0x356D,
	0x1C0C,0x1410,0x1412,0x1C13,0x2015,0x2417,0x2C17,0x3419,
	0x3819,0x4419,0x4877,0x4C39,0x4C59,0x4C79,0x543A,0x5479,
	0x55D6,0x5859,0x5879,0x5CB9,0x5CBA,0x5CDA,0x5D39,0x5D59,
	0x5D9B,0x60F9,0x651B,0x655B,0x6A1B,0x6A3B,0x6ABB,0x6ADB,
	0x6F1B,0xFFFF,0x396C,0x7FE0,0x7C1F,0x7C00,0x001F,0x03FF,
	0x301F,0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,0x7DFF,
	0x7E9F,0x7BDE,0x7F9F,0x186B,0x1CAB,0x1C6C,0x208E,0x204F,
	0x28B2,0x28B2,0x28B2,0x28B2,0x28B2,0x2873,0x2893,0x2C92,
	0x2CB2,0x3074,0x3094,0x30D4,0x30F4,0x3076,0x34D4,0x34F4,
	0x3476,0x34B7,0x34F7,0x3517,0x3478,0x34B8,0x3479,0x3CD6,

	0x3CB7,0x3CB8,0x3D58,0x3CD9,0x3D39,0x3C7B,0x3CBB,0x3CDB,
	0x3CFB,0x3CFC,0x407F,0x44F8,0x4578,0x44D9,0x44F9,0x4539,
	0x44BB,0x44DB,0x455C,0x44BD,0x44DD,0x451D,0x44BE,0x447F,
	0x4D9A,0x4CDA,0x4D3C,0x4CDD,0x4D3E,0x4CBF,0x4CDF,0x4D1F,
	0x4D3F,0x54DE,0x553E,0x54DF,0x551F,0x553F,0x557F,0x5CDF,
	0x5D1F,0x5D3F,0x5D5F,0x5D7F,0x5D9F,0x651F,0x655F,0x65BF,
	0x65DF,0x661F,0x691F,0x695F,0x69BE,0x69DF,0x6A1F,0x715F,
	0x717F,0x71BF,0x71DF,0x721F,0x723F,0x725F,0x727F,0x75BF,
	0x75FF,0x761F,0x723F,0x725F,0x769F,0x773F,0x7B7F,0x75BF,
	0x75FF,0x7A3F,0x7AFF,0x7F7F,0x755F,0x75FF,0x763F,0x7A9F,
	0x7ADF,0x7F5F,0x7FBF,0x7FDF,0x75FF,0x761F,0x763F,0x765F,
	0x7A7F,0x7A9F,0x7ABF,0x7EDF,0x7EFF,0x7F3F,0x7F7F,0x7FBF,
	0x7FFF,0x0000,0xFFFF,0x31EC,0x7FE0,0x7C1F,0x7C00,0x001F,
	0x03FF,0x301F,0x401F,0x501F,0x5C1F,0x681F,0x701F,0x7C5F,
	0x7DFF,0x7E9F,0x7BDE,0x7FFC,0x1C40,0x1C81,0x2060,0x2880,
	0x2C80,0x38C1,0x38C1,0x38C1,0x38C1,0x38C1,0x3CC0,0x3CC0,

	0x38E0,0x38E1,0x4100,0x4500,0x4503,0x4503,0x4D00,0x4522,
	0x4522,0x4D20,0x5121,0x5123,0x5124,0x5520,0x5521,0x5920,
	0x4D62,0x5161,0x5561,0x5565,0x5961,0x5964,0x6160,0x6160,
	0x6161,0x6162,0x6562,0x6982,0x55A2,0x59A6,0x59A1,0x59A2,
	0x59A4,0x61A0,0x61A1,0x65A4,0x69A0,0x69A0,0x69A2,0x6DA0,
	0x71A0,0x5DE6,0x5DE0,0x65E3,0x69E0,0x6DE3,0x71E0,0x71E1,
	0x71E3,0x71C3,0x6E20,0x6E24,0x7221,0x7223,0x7224,0x7226,
	0x7261,0x7263,0x7264,0x7265,0x7266,0x7267,0x72A3,0x72A5,
	0x72A8,0x72A9,0x72AB,0x72C3,0x72C5,0x72C7,0x72C9,0x72C1,
	0x7306,0x7306,0x7308,0x7309,0x730B,0x730C,0x730D,0x730E,
	0x7328,0x732A,0x732B,0x7308,0x774C,0x7B90,0x7BB4,0x7FD9,
	0x7728,0x774B,0x7B8C,0x7FB5,0x7FD9,0x7725,0x772A,0x7B4D,
	0x7B70,0x7FB4,0x7FF9,0x7FFC,0x7FFD,0x7B4A,0x7B4B,0x7B4C,
	0x7B2D,0x7B6E,0x7B6F,0x7B90,0x7BB2,0x7BB3,0x7FD6,0x7FD8,
	0x7BDA,0x7FFE,0x0000,0xFFFF,0x396C,0x7FE0,0x7C1F,0x7C00,
	0x001F,0x03FF,0x301F,0x401F,0x501F,0x5C1F,0x681F,0x701F,

	0x7C5F,0x7DFF,0x7E9F,0x7BDE,0x7F9F,0x1DD0,0x25F0,0x1DF1,
	0x2213,0x1A14,0x1E17,0x2237,0x2637,0x2657,0x2657,0x1E58,
	0x2278,0x2278,0x2678,0x1E99,0x22B9,0x2AB9,0x2EB9,0x1EBB,
	0x2AD9,0x2ED9,0x1EDB,0x2EDC,0x36DC,0x32DC,0x1EDD,0x26DE,
	0x1EDE,0x2B1B,0x271C,0x271D,0x3B3C,0x2B3D,0x331C,0x1B1E,
	0x26FE,0x2B1E,0x2F1F,0x2F1F,0x1F3F,0x335B,0x373B,0x2F3C,
	0x333C,0x333C,0x2B3E,0x2F3E,0x375E,0x235F,0x2F1F,0x2F5F,
	0x235F,0x1B5F,0x2B7A,0x2F9A,0x339C,0x2B9D,0x339E,0x379F,
	0x379F,0x3F9F,0x3F9F,0x3BDE,0x3B9E,0x2F9F,0x379F,0x3B9F,
	0x439F,0x2B9F,0x379F,0x3B9F,0x3F9F,0x439F,0x479F,0x37BF,
	0x3FDF,0x4BDF,0x4FDF,0x57DF,0x37BF,0x3FDF,0x479E,0x4B9F,
	0x539F,0x47DF,0x4BDF,0x4FDF,0x53DF,0x57DF,0x5BDF,0x5FDF,
	0x63FF,0x57FF,0x5BFF,0x5FFF,0x5BDF,0x63DF,0x6BFF,0x73FF,
	0x7BFF,0x5FFF,0x63FF,0x67FF,0x73FF,0x7BFF,0x5FFF,0x63FF,
	0x67FF,0x6FFF,0x73FF,0x77FF,0x7FBF,0x7FDF,0x57FF,0x5BFF,
	0x5FFF,0x63FF,0x67FF,0x6BFF,0x6FFF,0x73FF,0x77FF,0x7BFF,

	0x7BFF,0x7FFF,0x7FFF,0x0000,0xFFFF,0x28ED,0x7FE0,0x7C1F,
	0x7C00,0x001F,0x03FF,0x301F,0x401F,0x501F,0x5C1F,0x681F,
	0x701F,0x7C5F,0x7DFF,0x7E9F,0x7BDE,0x7FFA,0x1180,0x1580,
	0x15C0,0x19C0,0x1600,0x1A00,0x1A40,0x1E40,0x1E80,0x2280,
	0x1EA0,0x22A0,0x1EC0,0x22C0,0x26C0,0x2300,0x2302,0x2303,
	0x2300,0x2702,0x2B03,0x2720,0x2723,0x2743,0x2744,0x2760,
	0x2761,0x2762,0x2B60,0x2B62,0x2F61,0x3366,0x3380,0x3383,
	0x33A6,0x33A1,0x33A2,0x33C3,0x37C3,0x37C0,0x3762,0x3766,
	0x3781,0x3782,0x3784,0x37A0,0x37A1,0x3BA6,0x3BC1,0x3BC2,
	0x3BC4,0x3BE0,0x3BE3,0x3F87,0x3FA1,0x3FA4,0x3FC1,0x3FE4,
	0x3FE0,0x3FE1,0x3FE3,0x3FE4,0x43E0,0x4BE2,0x4BE4,0x4BE6,
	0x4BE8,0x4BEA,0x53E2,0x53E4,0x53E6,0x53E8,0x53EA,0x53EC,
	0x5BE4,0x5BE6,0x5BE8,0x5BEA,0x5BEC,0x5FE4,0x5FE6,0x5FE8,
	0x5FEA,0x5FEC,0x67E2,0x67E4,0x67E6,0x67E8,0x67EA,0x67EC,
	0x6FE8,0x6FEA,0x6FEC,0x6FEE,0x6FF0,0x73E0,0x73E8,0x73F0,
	0x73F4,0x73F9,0x77E0,0x77E8,0x77F0,0x77F4,0x77F9,0x7BE2,

	0x7BE6,0x7BEC,0x7BF2,0x7BF5,0x7BF9,0x7FFB,0x7BFC,0x77E0,
	0x77E2,0x77E4,0x77E6,0x77E8,0x7BEA,0x7BED,0x7BF0,0x7BF3,
	0x7BF6,0x7BF9,0x7BFB,0x7FFF,0x0000,0xFFFF,0x0002,0x0000
};
static UINT16 bloodwar_mcu_4_16[] = { // Warrior 8 Player 1
	0x0002,0x0000,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x29A9,0x2DCA,0x31EB,0x360C,0x3A0D,0x3A2D,0x3A4D,
	0x3E4E,0x3E6E,0x3E6F,0x426E,0x428E,0x468E,0x468F,0x4AAF,
	0x4AB0,0x46D0,0x4AD0,0x4AF0,0x4AF1,0x4EF1,0x4F11,0x4F12,
	0x5311,0x5312,0x5330,0x5751,0x5752,0x5B73,0x5B74,0x5B93,
	0x5B94,0x6396,0x67D5,0x67D6,0x67D7,0x67D5,0x67D6,0x6BD6,
	0x6BD7,0x6BD9,0x6BD5,0x6BD6,0x6BD7,0x6BD6,0x6FD6,0x6FD7,
	0x6FD9,0x73D7,0x73D8,0x73DA,0x7BD8,0x7BF9,0x7BFA,0x7BFB,
	0x7BFC,0x7FFB,0x7FFB,0x7FFC,0x7FFD,0x7FFB,0x7FFD,0x7FFD,
	0x7FFE,0x1946,0x1965,0x2187,0x21A5,0x25A7,0x29C7,0x29E8,
	0x360A,0x362B,0x3A8C,0x426D,0x428C,0x46EF,0x4ACF,0x5350,
	0x5352,0x5752,0x5753,0x5791,0x5B53,0x5B73,0x5FB3,0x6374,
	0x63B3,0x63B4,0x63D4,0x67B4,0x67D4,0x67D6,0x6FF6,0x6FF7,
	0x73F7,0x0882,0x0CA3,0x10E3,0x10E4,0x1103,0x1104,0x1524,
	0x1945,0x1965,0x1D65,0x1985,0x1986,0x21A6,0x21A7,0x21C6,

	0x25A6,0x29E9,0x2E09,0x2E28,0x2E29,0x364B,0x3A4D,0x3E8C,
	0x42CC,0x4B0F,0x4EF2,0x5BD3,0x67F7,0x6BF5,0x73F8,0x77FB,
	0x7FFC,0x1982,0x1DA4,0x21C5,0x25E6,0x2A07,0x2E27,0x2E47,
	0x3267,0x36A8,0x3AC9,0x3EEA,0x3F0A,0x3F2B,0x434C,0x476C,
	0x478C,0x4F8E,0x4FAD,0x4FCE,0x53EF,0x53F0,0x57F0,0x5BF0,
	0x5BF1,0x5FF3,0x5FF4,0x5FF2,0x63F2,0x63F4,0x67F5,0x6BF6,
	0x73F8,0x1E24,0x1E44,0x2265,0x2287,0x22A7,0x26C8,0x26E8,
	0x2B09,0x2F2A,0x3349,0x3F6C,0x438D,0x47AE,0x53D2,0x57F2,
	0x5FF3,0x0C09,0x100A,0x180C,0x1C0D,0x200E,0x240F,0x2810,
	0x3052,0x3473,0x3CB5,0x44F7,0x4D39,0x557B,0x5DBD,0x65FE,
	0x7BBE,0x10C3,0x1905,0x2146,0x2546,0x2988,0x31C8,0x35C9,
	0x39EB,0x3E0C,0x422C,0x464E,0x56F2,0x5733,0x5753,0x5B33,
	0x5B52,0x10E3,0x0CA3,0x10E4,0x1103,0x1104,0x1524,0x1946,
	0x21A5,0x2A08,0x322A,0x366A,0x42EE,0x4F0F,0x5FB2,0x5FB3,
	0x63D3,0x3D71,0x7FE0,0x7C1F,0x7C00,0x0E60,0x1EC0,0x2300,
	0x2F60,0x33E0,0x43E0,0x4FE0,0x63E0,0x67ED,0x77EE,0x77F5,

	0x7BDE,0xFFFF,0x0002,0x0000,0x4232,0x56F8,0x2D8D,0x2108
};
static UINT16 bloodwar_mcu_4_17[] = { // Warrior 8 Player 2
	0x0002,0x0000,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x296A,0x2D8B,0x31AC,0x35CD,0x35EF,0x39F0,0x3A10,
	0x3DD1,0x3E11,0x3E12,0x4230,0x4231,0x4630,0x4631,0x4671,
	0x4673,0x4674,0x4A73,0x4A93,0x4AB3,0x4AB4,0x4E74,0x4E75,
	0x52B3,0x52B4,0x52D3,0x56F4,0x56F5,0x5B16,0x5B17,0x5B36,
	0x5B37,0x6339,0x6778,0x6779,0x677A,0x6778,0x6779,0x6B79,
	0x6B7A,0x6B7C,0x6B78,0x6B79,0x6B7A,0x6B79,0x6F79,0x6F7A,
	0x6F7C,0x737A,0x737B,0x737D,0x7B7B,0x7B9C,0x7B9D,0x7B9E,
	0x7B9F,0x7F9E,0x7F9E,0x7F9F,0x7FBF,0x7F9E,0x7FBF,0x7FBF,
	0x7FBF,0x18E9,0x1908,0x212A,0x2148,0x254A,0x296A,0x298B,
	0x35AD,0x35CE,0x3A2F,0x4210,0x422F,0x4692,0x4A72,0x52D3,
	0x52F5,0x56F5,0x56F6,0x5715,0x5AF6,0x5B16,0x5F36,0x6317,
	0x6356,0x6357,0x6377,0x6757,0x6777,0x6779,0x6F99,0x6F9A,
	0x739A,0x0825,0x0C46,0x1086,0x1087,0x10A6,0x10A7,0x14C7,
	0x18E8,0x1908,0x1D08,0x1928,0x1929,0x2149,0x214A,0x2169,

	0x2549,0x298C,0x2DAC,0x2DCB,0x2DCC,0x35EE,0x39F0,0x3E2F,
	0x426F,0x4AB2,0x4E95,0x5B76,0x679A,0x6B98,0x739B,0x779E,
	0x7F9F,0x1982,0x1DA4,0x21C5,0x25E6,0x2A07,0x2E27,0x2E47,
	0x3267,0x36A8,0x3AC9,0x3EEA,0x3F0A,0x3F2B,0x434C,0x476C,
	0x478C,0x4F8E,0x4FAD,0x4FCE,0x53EF,0x53F0,0x57F0,0x5BF0,
	0x5BF1,0x5FF3,0x5FF4,0x5FF2,0x63F2,0x63F4,0x67F5,0x6BF6,
	0x739B,0x2810,0x2C31,0x3473,0x3894,0x3CB5,0x40D6,0x44F7,
	0x4918,0x4D39,0x515A,0x557B,0x599C,0x5DBD,0x65FE,0x6A1F,
	0x767F,0x0C09,0x100A,0x180C,0x1C0D,0x200E,0x240F,0x2810,
	0x3052,0x3473,0x3CB5,0x44F7,0x4D39,0x557B,0x5DBD,0x65FE,
	0x7BBE,0x10C3,0x1905,0x2146,0x2546,0x2988,0x31C8,0x35C9,
	0x39EB,0x3E0C,0x422C,0x464E,0x56F2,0x5733,0x5753,0x5B33,
	0x5B52,0x10E3,0x0CA3,0x10E4,0x1103,0x1104,0x1524,0x1946,
	0x21A5,0x2A08,0x322A,0x366A,0x42EE,0x4F0F,0x5FB2,0x5FB3,
	0x63D3,0x3D71,0x7FE0,0x7C1F,0x7C00,0x0E60,0x1EC0,0x2300,
	0x2F60,0x33E0,0x43E0,0x4FE0,0x63E0,0x67ED,0x77EE,0x77F5,

	0x7BDE,0xFFFF,0x0003,0x0000,0x4232,0x56F8,0x2D8D,0x2108
};
static UINT16 bloodwar_mcu_4_18[] = { // Warrior 2 Player 2
	0x0003,0x0000,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x1524,0x0CC2,0x0CE2,0x0CE3,0x10E3,0x1103,0x14E3,
	0x1544,0x1946,0x1966,0x2166,0x2167,0x2187,0x2567,0x25A7,
	0x29E8,0x31EA,0x320A,0x3A4B,0x3A4D,0x3A6B,0x3E4D,0x3E6B,
	0x3E6D,0x3E6E,0x3E8D,0x426E,0x428E,0x468F,0x46AE,0x46CF,
	0x46EE,0x46EF,0x4710,0x4AEF,0x4EF0,0x4F10,0x4F11,0x52F1,
	0x5310,0x5312,0x5313,0x5332,0x5732,0x5753,0x5B33,0x5B34,
	0x5B53,0x5F95,0x5FB5,0x5FD4,0x63B4,0x63B5,0x63B6,0x63D5,
	0x67F7,0x6FD7,0x6FF7,0x6FF8,0x6FF7,0x6FF8,0x73FA,0x7BFC,
	0x7FFC,0x0440,0x0080,0x0940,0x0D80,0x11C0,0x1200,0x1240,
	0x1280,0x12E0,0x1300,0x1301,0x1761,0x1B81,0x1BC2,0x1BE1,
	0x1E01,0x1E80,0x1EA0,0x22C0,0x22E1,0x2361,0x2381,0x2382,
	0x2782,0x27C2,0x27E4,0x2BC3,0x2FC4,0x2FE5,0x33E5,0x33E6,
	0x37E8,0x1520,0x1500,0x1940,0x1960,0x1D80,0x25E1,0x2DE3,
	0x3242,0x3262,0x3683,0x3EC3,0x3EC4,0x3F23,0x42A5,0x42C7,

	0x4765,0x4B08,0x4B46,0x4B66,0x53C7,0x5769,0x57C7,0x5BC8,
	0x5BCA,0x5FC9,0x5FE8,0x5FE9,0x6FEB,0x73ED,0x77EF,0x7FF4,
	0x7FF8,0x2E0A,0x320A,0x3A4E,0x3A6D,0x3E4D,0x3E6D,0x3E6E,
	0x426E,0x46CF,0x5310,0x5312,0x5332,0x5B94,0x5FB6,0x6797,
	0x67D6,0x6BD8,0x6BDA,0x6BF9,0x6BFA,0x6FDC,0x6FFA,0x6FFB,
	0x73FB,0x73FC,0x7BFB,0x7BFC,0x7BFD,0x7BFE,0x7FFD,0x7FFE,
	0x7FFF,0x1504,0x10E4,0x1524,0x1945,0x1965,0x1D67,0x1D87,
	0x2587,0x25A8,0x29E8,0x2A07,0x2E08,0x324A,0x3268,0x3269,
	0x3A68,0x3A8B,0x3EAB,0x42CB,0x4F2E,0x5330,0x534F,0x5352,
	0x57B1,0x5FB3,0x5FB4,0x67F3,0x6BF4,0x6BF5,0x6BF8,0x6FF7,
	0x73F9,0x0461,0x0441,0x0862,0x0882,0x0CC2,0x0CC3,0x0CE2,
	0x0CE3,0x10C3,0x10E3,0x10E4,0x1103,0x1104,0x1123,0x14E4,
	0x1524,0xFFFF,0x390F,0x7FE0,0x7C1F,0x7C00,0x0013,0x101A,
	0x181C,0x1C1F,0x241F,0x0BE0,0x3BE0,0x53E0,0x381F,0x4C1F,
	0x65FF,0x7BDE,0xFFFF,0x41D3,0x0013,0x281F,0x581F,0x6DFF,
	0x2243,0x0000,0x0340,0x4210,0x4A52,0x5294,0x5AD6,0x6318,

	0x4409,0x7BC0,0x7FFF,0x352E,0x7FE0,0x7C1F,0x7C00,0x36A0,
	0x3EA0,0x46E0,0x5320,0x5F80,0x6BE0,0x73E0,0x7FE2,0x7FF0,
	0x7FF6,0x7FFC,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x3809,
	0x3C09,0x4009,0x4406,0x480E,0x500F,0x5812,0x6016,0x70FB,
	0x7DBD,0x7EBD,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x0013,
	0x101A,0x181C,0x201F,0x281F,0x341F,0x401F,0x481F,0x581F,
	0x681F,0x6DFF,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x301F,
	0x381F,0x401F,0x481F,0x541F,0x5C1F,0x681F,0x701F,0x7C5F,
	0x7E5F,0x7B5F,0x7FFF,0x0000,0x7FE0,0x7C1F,0x0B58,0x13BB,
	0x1FFF,0x33FF,0x43FF,0x47FF,0x4FFF,0x57FF,0x5FFF,0x67FF,
	0x6FFF,0x77FF,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x0200,
	0x0200,0x0260,0x02C0,0x0320,0x03E0,0x23E0,0x33E7,0x47EC,
	0x5FF3,0x6FF8,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x0E60,
	0x1EC0,0x2300,0x2F60,0x33E0,0x43E0,0x4FE0,0x63E0,0x67ED,
	0x77EE,0x77F5,0x7FFF,0x2D2F,0x7FE0,0x3405,0x3C05,0x4409,
	0x4C07,0x5407,0x5C0A,0x6409,0x6C09,0x7409,0x7CCF,0x7E15,

	0x7EBA,0x7F5D,0x7FFF,0x2AA1,0x3724,0x3FA6,0x43E0,0x4FE8,
	0x5BC4,0x63C5,0x67EB,0x67EB,0x67ED,0x6FF0,0x77F3,0x7FF7,
	0x7FFA,0x7FFC,0x7FFF,0x0220,0x0260,0x0280,0x02C0,0x02E0,
	0x0320,0x0340,0x2780,0x2BA0,0x37E0,0x3FE0,0x0340,0x0BE0,
	0x13E0,0x1DA3,0x2243,0x41D3,0x0842,0x1084,0x18C6,0x2108,
	0x294A,0x318C,0x39CE,0x03A0,0x23E0,0x37E0,0x3FE0,0x4FE0,
	0x67ED,0x77EE,0x7FFF,0xFFFF,0x0003,0x0000,0x4232,0x56F8
};
static UINT16 bloodwar_mcu_4_19[] = { // Warrior 2 Player 1
	0x0003,0x0000,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x1524,0x0CC2,0x0CE2,0x0CE3,0x10E3,0x1103,0x14E3,
	0x1544,0x1946,0x1966,0x2166,0x2167,0x2187,0x2567,0x25A7,
	0x29E8,0x2A05,0x2E05,0x2E45,0x3266,0x3285,0x3285,0x3284,
	0x32A5,0x36C5,0x3AE1,0x3EC1,0x3EE2,0x4704,0x4724,0x4745,
	0x4764,0x4765,0x4786,0x4B65,0x4F66,0x4F86,0x4F87,0x5367,
	0x5386,0x57A8,0x57A9,0x57C8,0x5BC8,0x5BE9,0x5FC9,0x5FCA,
	0x5FE9,0x63EC,0x63EC,0x63EB,0x67EB,0x6BEB,0x6BEE,0x6BED,
	0x6FEF,0x73EE,0x73EE,0x73EF,0x73EE,0x77EF,0x7BF3,0x7FF5,
	0x7FF6,0x0440,0x0080,0x0940,0x0D80,0x11C0,0x1200,0x1240,
	0x1280,0x12E0,0x1300,0x1301,0x1761,0x1B81,0x1BC2,0x1BE1,
	0x1E01,0x1E80,0x1EA0,0x22C0,0x22E1,0x2361,0x2381,0x2382,
	0x2782,0x27C2,0x27E4,0x2BC3,0x2FC4,0x2FE5,0x33E5,0x33E6,
	0x37E8,0x1520,0x1500,0x1940,0x1960,0x1D80,0x25E1,0x2DE3,
	0x3242,0x3262,0x3683,0x3EC3,0x3EC4,0x3F23,0x42A5,0x42C7,

	0x4765,0x4B08,0x4B46,0x4B66,0x53C7,0x5769,0x57C7,0x5BC8,
	0x5BCA,0x5FC9,0x5FE8,0x5FE9,0x6FEB,0x73ED,0x77EF,0x7FF4,
	0x7FF8,0x2A61,0x2E81,0x32A3,0x36C2,0x3AC2,0x3EE3,0x42E3,
	0x4303,0x4324,0x4B45,0x4F67,0x4F88,0x57A9,0x5BCD,0x63ED,
	0x63EE,0x6BEE,0x6BF0,0x6BEF,0x6BF0,0x6FF2,0x6FF0,0x6FF1,
	0x73F1,0x73F2,0x7BF2,0x7BF3,0x7BF4,0x7BF7,0x7FFC,0x7FFC,
	0x7FFC,0x1504,0x10E4,0x1524,0x1945,0x1965,0x1D67,0x1D87,
	0x2587,0x25A8,0x29E8,0x2A07,0x2E08,0x324A,0x3268,0x3269,
	0x3A68,0x32C0,0x36E0,0x3B00,0x3F20,0x4343,0x4B63,0x4F87,
	0x53A6,0x57C7,0x5BE9,0x5FE7,0x63E8,0x63E9,0x63EC,0x67EC,
	0x6BED,0x0461,0x0441,0x0862,0x0882,0x0CC2,0x0CC3,0x0CE2,
	0x0CE3,0x10C3,0x10E3,0x10E4,0x1103,0x1104,0x1123,0x14E4,
	0x1524,0xFFFF,0x390F,0x7FE0,0x7C1F,0x7C00,0x0013,0x101A,
	0x181C,0x1C1F,0x241F,0x0BE0,0x3BE0,0x53E0,0x381F,0x4C1F,
	0x65FF,0x7BDE,0xFFFF,0x41D3,0x0013,0x281F,0x581F,0x6DFF,
	0x2243,0x0000,0x0340,0x4210,0x4A52,0x5294,0x5AD6,0x6318,

	0x4409,0x7BC0,0x7FFF,0x352E,0x7FE0,0x7C1F,0x7C00,0x36A0,
	0x3EA0,0x46E0,0x5320,0x5F80,0x6BE0,0x73E0,0x7FE2,0x7FF0,
	0x7FF6,0x7FFC,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x3809,
	0x3C09,0x4009,0x4406,0x480E,0x500F,0x5812,0x6016,0x70FB,
	0x7DBD,0x7EBD,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x0013,
	0x101A,0x181C,0x201F,0x281F,0x341F,0x401F,0x481F,0x581F,
	0x681F,0x6DFF,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x301F,
	0x381F,0x401F,0x481F,0x541F,0x5C1F,0x681F,0x701F,0x7C5F,
	0x7E5F,0x7B5F,0x7FFF,0x0000,0x7FE0,0x7C1F,0x0B58,0x13BB,
	0x1FFF,0x33FF,0x43FF,0x47FF,0x4FFF,0x57FF,0x5FFF,0x67FF,
	0x6FFF,0x77FF,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x0200,
	0x0200,0x0260,0x02C0,0x0320,0x03E0,0x23E0,0x33E7,0x47EC,
	0x5FF3,0x6FF8,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x0E60,
	0x1EC0,0x2300,0x2F60,0x33E0,0x43E0,0x4FE0,0x63E0,0x67ED,
	0x77EE,0x77F5,0x7FFF,0x2D2F,0x7FE0,0x3405,0x3C05,0x4409,
	0x4C07,0x5407,0x5C0A,0x6409,0x6C09,0x7409,0x7CCF,0x7E15,

	0x7EBA,0x7F5D,0x7FFF,0x2AA1,0x3724,0x3FA6,0x43E0,0x4FE8,
	0x5BC4,0x63C5,0x67EB,0x67EB,0x67ED,0x6FF0,0x77F3,0x7FF7,
	0x7FFA,0x7FFC,0x7FFF,0x0220,0x0260,0x0280,0x02C0,0x02E0,
	0x0320,0x0340,0x2780,0x2BA0,0x37E0,0x3FE0,0x0340,0x0BE0,
	0x13E0,0x1DA3,0x2243,0x41D3,0x0842,0x1084,0x18C6,0x2108,
	0x294A,0x318C,0x39CE,0x03A0,0x23E0,0x37E0,0x3FE0,0x4FE0,
	0x67ED,0x77EE,0x7FFF,0xFFFF,0x0005,0x0000,0x4232,0x56F8
};
static UINT16 bloodwar_mcu_4_1a[] = { // Warrior 3 Player 1
	0x0005,0x0000,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x08A0,0x0D02,0x1142,0x19C2,0x3EEB,0x430D,0x4B6C,
	0x4F4F,0x4F50,0x432A,0x368A,0x328A,0x3AE9,0x3689,0x3268,
	0x2A26,0x2A27,0x3AE9,0x4B4E,0x3269,0x3EEB,0x3AA8,0x19A3,
	0x08E2,0x21E5,0x2E47,0x3F2A,0x4B4F,0x3F0B,0x3AEB,0x36A8,
	0x25E3,0x1DC6,0x2606,0x2E46,0x36AA,0x2E66,0x36A8,0x36CA,
	0x32A9,0x2604,0x15C2,0x1182,0x0D42,0x1583,0x1162,0x0D22,
	0x15A2,0x19E3,0x11C2,0x1E45,0x1A04,0x2204,0x2E68,0x25E4,
	0x1DA4,0x3268,0x3AC9,0x4B2D,0x36A9,0x430C,0x2A46,0x534F,
	0x532F,0x42EA,0x2A26,0x1964,0x4F8E,0x4F8D,0x4B6C,0x474D,
	0x434A,0x3F29,0x3AE8,0x3B08,0x474B,0x3F09,0x4349,0x4B6B,
	0x1944,0x1D44,0x25C7,0x2E08,0x3AEA,0x3688,0x3247,0x3A2A,
	0x3AC8,0x3689,0x3EAA,0x426E,0x10C3,0x2603,0x1503,0x1925,
	0x42CA,0x42EB,0x3F2A,0x25E3,0x42A8,0x534E,0x1924,0x46CC,
	0x4B0D,0x2EA4,0x1DE4,0x2605,0x2E67,0x3ACA,0x3AAA,0x2A45,

	0x1185,0x2E46,0x1122,0x0862,0x08C2,0x1562,0x2A25,0x2A26,
	0x2624,0x472E,0x3688,0x4B4D,0x15A3,0x21E4,0x4F4E,0x4F6E,
	0x4F6D,0x5F34,0x5F36,0x5F36,0x5F56,0x4ED1,0x46AF,0x426E,
	0x2E26,0x21C6,0x324A,0x5B14,0x6777,0x6356,0x5F15,0x1380,
	0x1380,0x0F60,0x0F80,0x0F80,0x0F20,0x1300,0x0EE0,0x0F00,
	0x1320,0x0E82,0x1300,0x0A02,0x0DE2,0x0E02,0x09A2,0x0DC2,
	0x0D82,0x0D85,0x0E22,0x0E42,0x1262,0x1720,0x0EE0,0x0F00,
	0x1320,0x0F20,0x0F60,0x1623,0x1AA4,0x1683,0x1283,0x12A3,
	0x0E62,0x15E3,0x13A0,0x0B60,0x1282,0x12A2,0x16E0,0x1760,
	0x1760,0x1B80,0x1780,0x1F80,0x1B80,0x1B60,0x1AE0,0x1B60,
	0x1720,0x5FE5,0x5BE5,0x5BE5,0x5BE4,0x57E4,0x5BE4,0x4FA4,
	0x4B84,0x4B84,0x4F85,0x53A4,0x4B85,0x53A6,0x57C5,0x4366,
	0x4B87,0x4BA7,0x4766,0x2EC4,0x2EA6,0x2643,0x3B07,0x32A3,
	0x36C3,0x57E8,0x57CA,0x4FC4,0x32E3,0x32E4,0x32C3,0x2263,
	0x2AA3,0x2E91,0x6004,0x3FA6,0x2AA1,0x3724,0x3FA6,0x43E0,
	0x4FE8,0x5BC4,0x63C5,0x67ED,0x6FF0,0x77F3,0x7FFA,0x7FFC,

	0x7FFF,0x352E,0x7FE0,0x7C1F,0x7C00,0x36A0,0x3EA0,0x46E0,
	0x5320,0x5F80,0x6BE0,0x73E0,0x7FE2,0x7FF0,0x7FF6,0x7FFC,
	0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x3809,0x3C09,0x4009,
	0x4406,0x480E,0x500F,0x5812,0x6016,0x70FB,0x7DBD,0x7EBD,
	0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x0013,0x101A,0x181C,
	0x201F,0x281F,0x341F,0x401F,0x481F,0x581F,0x681F,0x6DFF,
	0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x301F,0x381F,0x401F,
	0x481F,0x541F,0x5C1F,0x681F,0x701F,0x7C5F,0x7E5F,0x7B5F,
	0x7BDE,0x0000,0x7FE0,0x7C1F,0x024F,0x02B3,0x0AF5,0x1358,
	0x1B9C,0x23FD,0x2BFF,0x3FFF,0x4FFF,0x5FFF,0x6BFF,0x77FF,
	0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x0200,0x0200,0x0260,
	0x02C0,0x0320,0x03E0,0x23E0,0x33E7,0x47EC,0x5FF3,0x6FF8,
	0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x0E60,0x1EC0,0x2300,
	0x2F60,0x33E0,0x43E0,0x4FE0,0x63E0,0x67ED,0x77EE,0x77F5,
	0x7BDE,0x2D2F,0x7FE0,0x3405,0x3C05,0x4409,0x4C07,0x5407,
	0x5C0A,0x6409,0x6C09,0x7409,0x7CCF,0x7E15,0x7EBA,0x7F5D,

	0x7BDE,0x3408,0x3C0F,0x4813,0x4C12,0x5413,0x5C0F,0x680D,
	0x700A,0x7484,0x7900,0x7DA0,0x7ECD,0x7F6D,0x7FF5,0x7F7E,
	0x7BDE,0x240C,0x280C,0x2C0C,0x340C,0x380C,0x3C0C,0x400C,
	0x440E,0x4810,0x5012,0x5413,0x400E,0x440E,0x4C0E,0x284F,
	0x2C4E,0xFFFF,0x410E,0x6004,0x3FA6,0x2AA1,0x3724,0x3FA6,
	0x43E0,0x4FE8,0x5BC4,0x63C5,0x67ED,0x6FF0,0x77F3,0x7FFA,
	0x7FFC,0x7FFF,0x352E,0x7FE0,0x7C1F,0x7C00,0x36A0,0x3EA0,
	0x46E0,0x5320,0x5F80,0x6BE0,0x73E0,0x7FE2,0x7FF0,0x7FF6,
	0x7FFC,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x3809,0x3C09,
	0x4009,0x4406,0x480E,0x500F,0x5812,0x6016,0x70FB,0x7DBD,
	0x7EBD,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x0013,0x101A,
	0x181C,0x201F,0x281F,0x341F,0x401F,0x481F,0x581F,0x681F,
	0x6DFF,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x301F,0x381F,
	0x401F,0x481F,0x541F,0x5C1F,0x681F,0x701F,0x7C5F,0x7E5F,
	0x7B5F,0x7BDE,0x0000,0x7FE0,0x7C1F,0x024F,0x02B3,0x0AF5,
	0x1358,0x1B9C,0x23FD,0x2BFF,0x3FFF,0x4FFF,0x5FFF,0x6BFF,

	0x77FF,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x0200,0x0200,
	0x0260,0x02C0,0x0320,0x03E0,0x23E0,0x33E7,0x47EC,0x5FF3,
	0x6FF8,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x0E60,0x1EC0,
	0x2300,0x2F60,0x33E0,0x43E0,0x4FE0,0x63E0,0x67ED,0x77EE,
	0x77F5,0x7BDE,0x2D2F,0x7FE0,0x3405,0x3C05,0x4409,0x4C07,
	0x5407,0x5C0A,0x6409,0x6C09,0x7409,0x7CCF,0x7E15,0x7EBA,
	0x7F5D,0x7BDE,0x0216,0x0257,0x12D8,0x2718,0x2FB8,0x3FB9,
	0x47FA,0x4FFC,0x53FF,0x5BFF,0x5BFF,0x67FE,0x6FFF,0x73DF,
	0x7BDF,0x7FFF,0x01B2,0x01F4,0x0215,0x0237,0x0258,0x027A,
	0x029B,0x02DB,0x02FA,0x033A,0x035B,0x029B,0x02DD,0x031F,
	0x0210,0x0215,0xFFFF,0x41D3,0x6004,0x3FA6,0x2AA1,0x3724,
	0x3FA6,0x43E0,0x4FE8,0x5BC4,0x63C5,0x67ED,0x6FF0,0x77F3,
	0x7FFA,0x7FFC,0x7FFF,0x352E,0x7FE0,0x7C1F,0x7C00,0x36A0,
	0x3EA0,0x46E0,0x5320,0x5F80,0x6BE0,0x73E0,0x7FE2,0x7FF0,
	0x7FF6,0x7FFC,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x3809,
	0x3C09,0x4009,0x4406,0x480E,0x500F,0x5812,0x6016,0x70FB,

	0x7DBD,0x7EBD,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x0013,
	0x101A,0x181C,0x201F,0x281F,0x341F,0x401F,0x481F,0x581F,
	0x681F,0x6DFF,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x301F,
	0x381F,0x401F,0x481F,0x541F,0x5C1F,0x681F,0x701F,0x7C5F,
	0x7E5F,0x7B5F,0x7BDE,0x0000,0x7FE0,0x7C1F,0x024F,0x02B3,
	0x0AF5,0x1358,0x1B9C,0x23FD,0x2BFF,0x3FFF,0x4FFF,0x5FFF,
	0x6BFF,0x77FF,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x0200,
	0x0200,0x0260,0x02C0,0x0320,0x03E0,0x23E0,0x33E7,0x47EC,
	0x5FF3,0x6FF8,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x0E60,
	0x1EC0,0x2300,0x2F60,0x33E0,0x43E0,0x4FE0,0x63E0,0x67ED,
	0x77EE,0x77F5,0x7BDE,0x2D2F,0x7FE0,0x3405,0x3C05,0x4409,
	0x4C07,0x5407,0x5C0A,0x6409,0x6C09,0x7409,0x7CCF,0x7E15,
	0x7EBA,0x7F5D,0x7BDE,0x1B01,0x23A0,0x2FC0,0x3BE0,0x43E0,
	0x4FC0,0x57C0,0x5FE0,0x63E0,0x67E0,0x6FE0,0x77EE,0x7FF3,
	0x7FFA,0x7FFC,0x7FFF,0x0220,0x0260,0x0280,0x02C0,0x02E0,
	0x0320,0x0340,0x2780,0x2BA0,0x37E0,0x3FE0,0x0340,0x0BE0,

	0x13E0,0x1DA3,0x2243,0xFFFF,0x410E,0x6004,0x3FA6,0x2AA1,
	0x3724,0x3FA6,0x43E0,0x4FE8,0x5BC4,0x63C5,0x67ED,0x6FF0,
	0x77F3,0x7FFA,0x7FFC,0x7FFF,0x352E,0x7FE0,0x7C1F,0x7C00,
	0x36A0,0x3EA0,0x46E0,0x5320,0x5F80,0x6BE0,0x73E0,0x7FE2,
	0x7FF0,0x7FF6,0x7FFC,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,
	0x3809,0x3C09,0x4009,0x4406,0x480E,0x500F,0x5812,0x6016,
	0x70FB,0x7DBD,0x7EBD,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,
	0x0013,0x101A,0x181C,0x201F,0x281F,0x341F,0x401F,0x481F,
	0x581F,0x681F,0x6DFF,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,
	0x301F,0x381F,0x401F,0x481F,0x541F,0x5C1F,0x681F,0x701F,
	0x7C5F,0x7E5F,0x7B5F,0x7BDE,0x0000,0x7FE0,0x7C1F,0x024F,
	0x02B3,0x0AF5,0x1358,0x1B9C,0x23FD,0x2BFF,0x3FFF,0x4FFF,
	0x5FFF,0x6BFF,0x77FF,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,
	0x0200,0x0200,0x0260,0x02C0,0x0320,0x03E0,0x23E0,0x33E7,
	0x47EC,0x5FF3,0x6FF8,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,
	0x0E60,0x1EC0,0x2300,0x2F60,0x33E0,0x43E0,0x4FE0,0x63E0,

	0x67ED,0x77EE,0x77F5,0x7BDE,0x2D2F,0x7FE0,0x3405,0x3C05,
	0x4409,0x4C07,0x5407,0x5C0A,0x6409,0x6C09,0x7409,0x7CCF,
	0x7E15,0x7EBA,0x7F5D,0x7BDE,0x19B7,0x21DA,0x31BC,0x3D9E,
	0x499E,0x511D,0x5CFE,0x60DF,0x68BF,0x707F,0x741F,0x7C1F,
	0x7E7F,0x7F5F,0x7F9F,0x7FFF,0x018C,0x018E,0x018F,0x0191,
	0x0192,0x0194,0x0195,0x2597,0x2998,0x3599,0x3D99,0x0195,
	0x0999,0x1199,0x21CF,0x25D4,0xFFFF,0x0005,0x0000,0x4232
};
static UINT16 bloodwar_mcu_4_1b[] = { // Warrior 3 Player 2
	0x0005,0x0000,0x4232,0x56F8,0x2D8D,0x2108,0x294A,0x318C,
	0x39CE,0x4210,0x4A52,0x5294,0x5AD6,0x6318,0x6B5A,0x739C,
	0x7BDE,0x08A0,0x0D02,0x1142,0x19C2,0x3EEB,0x430D,0x4B6C,
	0x4F4F,0x4F50,0x432A,0x368A,0x328A,0x3AE9,0x3689,0x3268,
	0x2A26,0x2A27,0x3AE9,0x4B4E,0x3269,0x3EEB,0x3AA8,0x19A3,
	0x08E2,0x21E5,0x2E47,0x3F2A,0x4B4F,0x3F0B,0x3AEB,0x36A8,
	0x25E3,0x1DC6,0x2606,0x2E46,0x36AA,0x2E66,0x36A8,0x36CA,
	0x32A9,0x2604,0x15C2,0x1182,0x0D42,0x1583,0x1162,0x0D22,
	0x15A2,0x19E3,0x11C2,0x1E45,0x1A04,0x2204,0x2E68,0x25E4,
	0x1DA4,0x3268,0x3AC9,0x4B2D,0x36A9,0x430C,0x2A46,0x534F,
	0x532F,0x42EA,0x2A26,0x1964,0x4F8E,0x4F8D,0x4B6C,0x474D,
	0x434A,0x3F29,0x3AE8,0x3B08,0x474B,0x3F09,0x4349,0x4B6B,
	0x1944,0x1D44,0x25C7,0x2E08,0x3AEA,0x3688,0x3247,0x3A2A,
	0x3AC8,0x3689,0x3EAA,0x426E,0x10C3,0x2603,0x1503,0x1925,
	0x42CA,0x42EB,0x3F2A,0x25E3,0x42A8,0x534E,0x1924,0x46CC,
	0x4B0D,0x2EA4,0x1DE4,0x2605,0x2E67,0x3ACA,0x3AAA,0x2A45,

	0x1185,0x2E46,0x1122,0x0862,0x08C2,0x1562,0x2A25,0x2A26,
	0x2624,0x472E,0x3688,0x4B4D,0x15A3,0x21E4,0x4F4E,0x4F6E,
	0x4F6D,0x5F34,0x5F36,0x5F36,0x5F56,0x4ED1,0x46AF,0x426E,
	0x2E26,0x21C6,0x324A,0x5B14,0x6777,0x6356,0x5F15,0x036E,
	0x036F,0x032D,0x034D,0x034E,0x030C,0x02ED,0x02CC,0x02EC,
	0x030D,0x0289,0x02EE,0x0207,0x01E7,0x0207,0x09A2,0x0DC2,
	0x0D82,0x0D85,0x0227,0x0249,0x0269,0x030F,0x02CD,0x02ED,
	0x030E,0x030D,0x032E,0x0228,0x02AB,0x028A,0x028A,0x02AA,
	0x0269,0x01E8,0x036E,0x032D,0x0289,0x02A9,0x02CE,0x0332,
	0x0331,0x0351,0x0351,0x0350,0x0350,0x0330,0x02D1,0x0332,
	0x0310,0x5FE5,0x5BE5,0x5BE5,0x5BE4,0x57E4,0x5BE4,0x4FA4,
	0x4B84,0x4B84,0x4F85,0x53A4,0x4B85,0x53A6,0x57C5,0x4366,
	0x4B87,0x4BA7,0x4766,0x2EC4,0x2EA6,0x2643,0x3B07,0x32A3,
	0x36C3,0x57E8,0x57CA,0x4FC4,0x32E3,0x32E4,0x32C3,0x2263,
	0x2AA3,0x2E91,0x6004,0x3FA6,0x2AA1,0x3724,0x3FA6,0x43E0,
	0x4FE8,0x5BC4,0x63C5,0x67ED,0x6FF0,0x77F3,0x7FFA,0x7FFC,

	0x7FFF,0x352E,0x7FE0,0x7C1F,0x7C00,0x36A0,0x3EA0,0x46E0,
	0x5320,0x5F80,0x6BE0,0x73E0,0x7FE2,0x7FF0,0x7FF6,0x7FFC,
	0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x3809,0x3C09,0x4009,
	0x4406,0x480E,0x500F,0x5812,0x6016,0x70FB,0x7DBD,0x7EBD,
	0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x0013,0x101A,0x181C,
	0x201F,0x281F,0x341F,0x401F,0x481F,0x581F,0x681F,0x6DFF,
	0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x301F,0x381F,0x401F,
	0x481F,0x541F,0x5C1F,0x681F,0x701F,0x7C5F,0x7E5F,0x7B5F,
	0x7BDE,0x0000,0x7FE0,0x7C1F,0x024F,0x02B3,0x0AF5,0x1358,
	0x1B9C,0x23FD,0x2BFF,0x3FFF,0x4FFF,0x5FFF,0x6BFF,0x77FF,
	0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x0200,0x0200,0x0260,
	0x02C0,0x0320,0x03E0,0x23E0,0x33E7,0x47EC,0x5FF3,0x6FF8,
	0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x0E60,0x1EC0,0x2300,
	0x2F60,0x33E0,0x43E0,0x4FE0,0x63E0,0x67ED,0x77EE,0x77F5,
	0x7BDE,0x2D2F,0x7FE0,0x3405,0x3C05,0x4409,0x4C07,0x5407,
	0x5C0A,0x6409,0x6C09,0x7409,0x7CCF,0x7E15,0x7EBA,0x7F5D,

	0x7BDE,0x3408,0x3C0F,0x4813,0x4C12,0x5413,0x5C0F,0x680D,
	0x700A,0x7484,0x7900,0x7DA0,0x7ECD,0x7F6D,0x7FF5,0x7F7E,
	0x7BDE,0x240C,0x280C,0x2C0C,0x340C,0x380C,0x3C0C,0x400C,
	0x440E,0x4810,0x5012,0x5413,0x400E,0x440E,0x4C0E,0x284F,
	0x2C4E,0xFFFF,0x410E,0x6004,0x3FA6,0x2AA1,0x3724,0x3FA6,
	0x43E0,0x4FE8,0x5BC4,0x63C5,0x67ED,0x6FF0,0x77F3,0x7FFA,
	0x7FFC,0x7FFF,0x352E,0x7FE0,0x7C1F,0x7C00,0x36A0,0x3EA0,
	0x46E0,0x5320,0x5F80,0x6BE0,0x73E0,0x7FE2,0x7FF0,0x7FF6,
	0x7FFC,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x3809,0x3C09,
	0x4009,0x4406,0x480E,0x500F,0x5812,0x6016,0x70FB,0x7DBD,
	0x7EBD,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x0013,0x101A,
	0x181C,0x201F,0x281F,0x341F,0x401F,0x481F,0x581F,0x681F,
	0x6DFF,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x301F,0x381F,
	0x401F,0x481F,0x541F,0x5C1F,0x681F,0x701F,0x7C5F,0x7E5F,
	0x7B5F,0x7BDE,0x0000,0x7FE0,0x7C1F,0x024F,0x02B3,0x0AF5,
	0x1358,0x1B9C,0x23FD,0x2BFF,0x3FFF,0x4FFF,0x5FFF,0x6BFF,

	0x77FF,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x0200,0x0200,
	0x0260,0x02C0,0x0320,0x03E0,0x23E0,0x33E7,0x47EC,0x5FF3,
	0x6FF8,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x0E60,0x1EC0,
	0x2300,0x2F60,0x33E0,0x43E0,0x4FE0,0x63E0,0x67ED,0x77EE,
	0x77F5,0x7BDE,0x2D2F,0x7FE0,0x3405,0x3C05,0x4409,0x4C07,
	0x5407,0x5C0A,0x6409,0x6C09,0x7409,0x7CCF,0x7E15,0x7EBA,
	0x7F5D,0x7BDE,0x0216,0x0257,0x12D8,0x2718,0x2FB8,0x3FB9,
	0x47FA,0x4FFC,0x53FF,0x5BFF,0x5BFF,0x67FE,0x6FFF,0x73DF,
	0x7BDF,0x7FFF,0x01B2,0x01F4,0x0215,0x0237,0x0258,0x027A,
	0x029B,0x02DB,0x02FA,0x033A,0x035B,0x029B,0x02DD,0x031F,
	0x0210,0x0215,0xFFFF,0x41D3,0x6004,0x3FA6,0x2AA1,0x3724,
	0x3FA6,0x43E0,0x4FE8,0x5BC4,0x63C5,0x67ED,0x6FF0,0x77F3,
	0x7FFA,0x7FFC,0x7FFF,0x352E,0x7FE0,0x7C1F,0x7C00,0x36A0,
	0x3EA0,0x46E0,0x5320,0x5F80,0x6BE0,0x73E0,0x7FE2,0x7FF0,
	0x7FF6,0x7FFC,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x3809,
	0x3C09,0x4009,0x4406,0x480E,0x500F,0x5812,0x6016,0x70FB,

	0x7DBD,0x7EBD,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x0013,
	0x101A,0x181C,0x201F,0x281F,0x341F,0x401F,0x481F,0x581F,
	0x681F,0x6DFF,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x301F,
	0x381F,0x401F,0x481F,0x541F,0x5C1F,0x681F,0x701F,0x7C5F,
	0x7E5F,0x7B5F,0x7BDE,0x0000,0x7FE0,0x7C1F,0x024F,0x02B3,
	0x0AF5,0x1358,0x1B9C,0x23FD,0x2BFF,0x3FFF,0x4FFF,0x5FFF,
	0x6BFF,0x77FF,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,0x0200,
	0x0200,0x0260,0x02C0,0x0320,0x03E0,0x23E0,0x33E7,0x47EC,
	0x5FF3,0x6FF8,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,0x0E60,
	0x1EC0,0x2300,0x2F60,0x33E0,0x43E0,0x4FE0,0x63E0,0x67ED,
	0x77EE,0x77F5,0x7BDE,0x2D2F,0x7FE0,0x3405,0x3C05,0x4409,
	0x4C07,0x5407,0x5C0A,0x6409,0x6C09,0x7409,0x7CCF,0x7E15,
	0x7EBA,0x7F5D,0x7BDE,0x1B01,0x23A0,0x2FC0,0x3BE0,0x43E0,
	0x4FC0,0x57C0,0x5FE0,0x63E0,0x67E0,0x6FE0,0x77EE,0x7FF3,
	0x7FFA,0x7FFC,0x7FFF,0x0220,0x0260,0x0280,0x02C0,0x02E0,
	0x0320,0x0340,0x2780,0x2BA0,0x37E0,0x3FE0,0x0340,0x0BE0,

	0x13E0,0x1DA3,0x2243,0xFFFF,0x410E,0x6004,0x3FA6,0x2AA1,
	0x3724,0x3FA6,0x43E0,0x4FE8,0x5BC4,0x63C5,0x67ED,0x6FF0,
	0x77F3,0x7FFA,0x7FFC,0x7FFF,0x352E,0x7FE0,0x7C1F,0x7C00,
	0x36A0,0x3EA0,0x46E0,0x5320,0x5F80,0x6BE0,0x73E0,0x7FE2,
	0x7FF0,0x7FF6,0x7FFC,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,
	0x3809,0x3C09,0x4009,0x4406,0x480E,0x500F,0x5812,0x6016,
	0x70FB,0x7DBD,0x7EBD,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,
	0x0013,0x101A,0x181C,0x201F,0x281F,0x341F,0x401F,0x481F,
	0x581F,0x681F,0x6DFF,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,
	0x301F,0x381F,0x401F,0x481F,0x541F,0x5C1F,0x681F,0x701F,
	0x7C5F,0x7E5F,0x7B5F,0x7BDE,0x0000,0x7FE0,0x7C1F,0x024F,
	0x02B3,0x0AF5,0x1358,0x1B9C,0x23FD,0x2BFF,0x3FFF,0x4FFF,
	0x5FFF,0x6BFF,0x77FF,0x7FFF,0x0000,0x7FE0,0x7C1F,0x7C00,
	0x0200,0x0200,0x0260,0x02C0,0x0320,0x03E0,0x23E0,0x33E7,
	0x47EC,0x5FF3,0x6FF8,0x7BDE,0x0000,0x7FE0,0x7C1F,0x7C00,
	0x0E60,0x1EC0,0x2300,0x2F60,0x33E0,0x43E0,0x4FE0,0x63E0,

	0x67ED,0x77EE,0x77F5,0x7BDE,0x2D2F,0x7FE0,0x3405,0x3C05,
	0x4409,0x4C07,0x5407,0x5C0A,0x6409,0x6C09,0x7409,0x7CCF,
	0x7E15,0x7EBA,0x7F5D,0x7BDE,0x19B7,0x21DA,0x31BC,0x3D9E,
	0x499E,0x511D,0x5CFE,0x60DF,0x68BF,0x707F,0x741F,0x7C1F,
	0x7E7F,0x7F5F,0x7F9F,0x7FFF,0x018C,0x018E,0x018F,0x0191,
	0x0192,0x0194,0x0195,0x2597,0x2998,0x3599,0x3D99,0x0195,
	0x0999,0x1199,0x21CF,0x25D4,0xFFFF,0x0004,0xCE4A,0x0004
};

// --- tilemap data ---
//  tile data (ff means no tiles) followed by routine index (end marker: 0xff00)
static UINT16 bloodwar_mcu_4_1c[] = { // Warrior 8
	0xFF08,0xFF02,0x0000,0xFF03,0x0400,0xFF01,0x0D00,0xFF06,
	0x01BF,0xFF06,0x00FF,0xFF06,0x0008,0x2C01,0xFF06,0x0001,
	0xFF05,0x0002,0x2C02,0xFF06,0x0001,0xFF05,0x0002,0x2C55,
	0xFF06,0x0001,0x2C58,0xFF06,0x0008,0xFF06,0x0007,0xFF05,
	0x0007,0x2C05,0xFF05,0x0007,0x2C59,0xFF06,0x0007,0xFF06,
	0x0007,0xFF05,0x0007,0x2C0D,0xFF05,0x0007,0x2C61,0xFF06,
	0x0007,0xFF05,0x000F,0x2C15,0xFF05,0x000F,0x2C69,0xFF05,
	0x000F,0x2C25,0xFF05,0x000F,0x2C79,0xFF05,0x000F,0x2C35,
	0xFF05,0x000F,0x2C89,0xFF05,0x000F,0x2C45,0xFF05,0x000F,
	0x2C99,0xFF04,0x0002,0xFF09,0x0007,0x28D0,0xFF04,0x0000,
	0xFF05,0x0007,0x28A9,0xFF05,0x000F,0x28C1,0xFF04,0x0002,
	0xFF09,0x0007,0x28E0,0xFF04,0x0000,0xFF05,0x0007,0x28B1,
	0xFF05,0x000F,0x28D1,0xFF04,0x0002,0xFF09,0x0007,0x28F0,
	0xFF04,0x0000,0xFF05,0x0007,0x28B9,0xFF05,0x000F,0x28E1,
	0xFF08,0xFF02,0x0001,0xFF03,0x0400,0xFF01,0x0E00,0xFF06,
	0x01BF,0xFF06,0x001F,0xFF06,0x0001,0xFF05,0x0002,0x2401,

	0xFF06,0x001A,0xFF06,0x0001,0xFF05,0x0003,0x2404,0xFF06,
	0x0019,0xFF06,0x0001,0xFF05,0x0004,0x2409,0xFF06,0x0018,
	0xFF06,0x0001,0xFF05,0x0005,0x240E,0xFF06,0x0011,0xFF05,
	0x0003,0x2474,0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x0008,
	0x2414,0xFF06,0x000A,0xFF05,0x0007,0x2478,0xFF06,0x0001,
	0xFF06,0x0001,0xFF05,0x0008,0x241D,0xFF06,0x000A,0xFF05,
	0x0007,0x2480,0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x0009,
	0x2426,0xFF06,0x0009,0xFF05,0x0007,0x2488,0xFF06,0x0001,
	0xFF06,0x0001,0xFF05,0x0009,0x2430,0xFF06,0x0008,0xFF05,
	0x0008,0x2490,0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x000A,
	0x243A,0xFF06,0x0007,0xFF05,0x0008,0x2499,0xFF06,0x0001,
	0xFF06,0x0001,0xFF05,0x000A,0x2445,0xFF06,0x0007,0xFF05,
	0x0008,0x24A2,0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x0008,
	0x2450,0xFF06,0x0009,0xFF05,0x0008,0x24AB,0xFF06,0x0001,
	0xFF06,0x0001,0xFF05,0x0008,0x2459,0xFF06,0x0009,0xFF05,
	0x0008,0x24B4,0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x0008,

	0x2462,0xFF06,0x0009,0xFF05,0x0008,0x24BD,0xFF06,0x0001,
	0xFF06,0x0001,0xFF05,0x0008,0x246B,0xFF06,0x0008,0xFF05,
	0x0009,0x48C6,0xFF06,0x0001,0xFF05,0x001F,0x48C6,0xFF06,
	0x003F,0xFF08,0xFF02,0x0002,0xFF03,0x0400,0xFF01,0x0B00,
	0xFF06,0x01BF,0xFF06,0x005F,0xFF06,0x000A,0xFF05,0x0001,
	0x3001,0xFF06,0x0012,0xFF06,0x0008,0xFF05,0x0004,0x3003,
	0xFF06,0x0011,0xFF06,0x0006,0xFF05,0x0008,0x3008,0xFF06,
	0x000F,0xFF06,0x0004,0xFF05,0x000A,0x3011,0xFF06,0x000F,
	0xFF06,0x0004,0xFF05,0x000B,0x301C,0xFF05,0x0009,0x3461,
	0xFF06,0x0004,0xFF06,0x0004,0xFF05,0x000B,0x3028,0xFF05,
	0x0009,0x346B,0xFF06,0x0004,0xFF06,0x0004,0xFF05,0x0015,
	0x3034,0xFF06,0x0004,0xFF06,0x0004,0xFF05,0x0015,0x304A,
	0xFF06,0x0004,0xFF06,0x0004,0xFF0A,0x0015,0x3060,0xFF06,
	0x0004,0xFF06,0x00BF,0xFF08,0xFF02,0x0003,0xFF03,0x0400,
	0xFF01,0x0B00,0xFF06,0x01BF,0xFF06,0x003F,0xFF06,0x000E,
	0xFF05,0x0002,0x34D5,0xFF06,0x0001,0xFF05,0x0002,0x3880,

	0xFF06,0x0008,0xFF06,0x000E,0xFF05,0x0002,0x34D8,0xFF06,
	0x0000,0xFF05,0x0004,0x3883,0xFF06,0x0007,0xFF06,0x000E,
	0xFF05,0x0002,0x34DB,0xFF06,0x0000,0xFF05,0x0004,0x3888,
	0xFF06,0x0007,0xFF06,0x0011,0xFF05,0x0006,0x388D,0xFF06,
	0x0006,0xFF06,0x0010,0xFF05,0x0007,0x3894,0xFF06,0x0006,
	0xFF06,0x000E,0xFF05,0x000A,0x389C,0xFF06,0x0005,0xFF06,
	0x000F,0xFF05,0x0009,0x38A7,0xFF06,0x0005,0xFF06,0x000E,
	0xFF05,0x000A,0x38B1,0xFF06,0x0004,0xFF06,0x000E,0xFF05,
	0x000A,0x38BD,0xFF06,0x0004,0xFF06,0x000E,0xFF05,0x000A,
	0x38C9,0xFF06,0x0004,0xFF06,0x00BF,0xFF00,0xFF08,0xFF02
};
static UINT16 bloodwar_mcu_4_1d[] = { // Warrior 2
	0xFF08,0xFF02,0x0000,0xFF03,0x0400,0xFF01,0x0000,0xFF06,
	0x01BF,0xFF06,0x0003,0x4401,0xFF06,0x0002,0x4401,0xFF05,
	0x0001,0x340B,0xFF06,0x0000,0x4401,0xFF06,0x0005,0xFF04,
	0x0002,0x4401,0xFF06,0x0000,0xFF04,0x0000,0xFF05,0x0002,
	0x341F,0xFF04,0x0002,0x4401,0xFF06,0x0002,0x4401,0xFF04,
	0x0000,0xFF06,0x0002,0xFF06,0x0003,0x4402,0xFF06,0x0002,
	0x4402,0xFF05,0x0001,0x340B,0xFF06,0x0000,0x4402,0xFF06,
	0x0005,0xFF04,0x0002,0x4402,0xFF06,0x0000,0xFF04,0x0000,
	0xFF05,0x0002,0x341F,0xFF04,0x0002,0x4402,0xFF06,0x0002,
	0x4402,0xFF04,0x0000,0xFF06,0x0002,0xFF06,0x0002,0xFF05,
	0x0001,0x4403,0xFF06,0x0001,0xFF05,0x0001,0x4403,0xFF05,
	0x0001,0x340B,0xFF05,0x0001,0x4403,0xFF06,0x0005,0xFF04,
	0x0002,0xFF09,0x0001,0x4404,0xFF04,0x0000,0xFF05,0x0002,
	0x341F,0xFF04,0x0002,0xFF09,0x0001,0x4404,0xFF06,0x0001,
	0xFF09,0x0001,0x4404,0xFF04,0x0000,0xFF06,0x0001,0xFF06,
	0x0002,0xFF05,0x0001,0x4005,0xFF06,0x0001,0xFF05,0x0001,

	0x4005,0xFF05,0x0001,0x340B,0xFF05,0x0001,0x4005,0xFF06,
	0x0005,0xFF04,0x0002,0xFF09,0x0001,0x4006,0xFF04,0x0000,
	0xFF05,0x0002,0x341F,0xFF04,0x0002,0xFF09,0x0001,0x4006,
	0xFF06,0x0001,0xFF09,0x0001,0x4006,0xFF04,0x0000,0xFF06,
	0x0001,0xFF06,0x0002,0xFF05,0x0001,0x4007,0xFF06,0x0001,
	0xFF05,0x0001,0x4007,0xFF05,0x0001,0x340D,0xFF05,0x0001,
	0x4007,0xFF06,0x0005,0xFF04,0x0002,0xFF09,0x0001,0x4008,
	0xFF04,0x0000,0xFF05,0x0002,0x3422,0xFF04,0x0002,0xFF09,
	0x0001,0x4008,0xFF06,0x0001,0xFF09,0x0001,0x4008,0xFF04,
	0x0000,0xFF06,0x0001,0xFF06,0x0002,0xFF05,0x0001,0x4409,
	0xFF06,0x0001,0xFF05,0x0001,0x4409,0xFF05,0x0001,0x340F,
	0xFF05,0x0001,0x4409,0xFF06,0x0005,0xFF04,0x0002,0xFF09,
	0x0001,0x440A,0xFF04,0x0000,0xFF05,0x0002,0x3425,0xFF04,
	0x0002,0xFF09,0x0001,0x440A,0xFF06,0x0001,0xFF09,0x0001,
	0x440A,0xFF04,0x0000,0xFF06,0x0001,0xFF06,0x0008,0xFF05,
	0x0001,0x3411,0xFF06,0x0009,0xFF05,0x0002,0x3428,0xFF06,

	0x0007,0xFF06,0x0008,0xFF05,0x0001,0x3413,0xFF06,0x0009,
	0xFF05,0x0002,0x342B,0xFF06,0x0007,0xFF06,0x0008,0xFF05,
	0x0001,0x3415,0xFF06,0x0009,0xFF05,0x0002,0x342E,0xFF06,
	0x0007,0xFF06,0x0006,0x383E,0xFF06,0x0000,0xFF05,0x0001,
	0x3417,0x383D,0xFF06,0x0007,0x383E,0xFF05,0x0002,0x3431,
	0x383D,0xFF06,0x0006,0xFF05,0x0007,0x3841,0xFF06,0x0000,
	0xFF05,0x0001,0x3419,0xFF05,0x0009,0x383F,0xFF05,0x0002,
	0x3434,0xFF05,0x0007,0x383F,0xFF05,0x0007,0x384B,0xFF06,
	0x0000,0xFF05,0x0001,0x341B,0xFF05,0x0009,0x3849,0xFF05,
	0x0002,0x3437,0xFF05,0x0007,0x3849,0xFF05,0x0007,0x3855,
	0xFF06,0x0000,0xFF05,0x0001,0x341D,0xFF05,0x0009,0x3853,
	0xFF05,0x0002,0x343A,0xFF05,0x0007,0x3853,0xFF06,0x0006,
	0xFF05,0x0001,0x385E,0xFF06,0x0001,0x385D,0xFF06,0x0007,
	0xFF05,0x0001,0x385E,0xFF06,0x0001,0x385D,0xFF06,0x0006,
	0xFF04,0x0002,0xFF09,0x000D,0x3C71,0xFF04,0x0000,0xFF05,
	0x0011,0x3C60,0xFF04,0x0002,0xFF09,0x000D,0x3C83,0xFF04,

	0x0000,0xFF05,0x0011,0x3C72,0xFF04,0x0002,0xFF09,0x000D,
	0x3C95,0xFF04,0x0000,0xFF05,0x0011,0x3C84,0xFF04,0x0002,
	0xFF09,0x000D,0x3CA7,0xFF04,0x0000,0xFF05,0x0011,0x3C96,
	0xFF08,0xFF02,0x0001,0xFF03,0x0300,0xFF01,0x0000,0xFF06,
	0x01BF,0xFF06,0x0003,0xFF05,0x0002,0x2CB0,0xFF05,0x0002,
	0x2CB0,0xFF05,0x0002,0x2CB0,0xFF05,0x0002,0x2CB0,0xFF05,
	0x0002,0x2CB0,0xFF05,0x0002,0x2CB0,0xFF05,0x0002,0x2CB0,
	0xFF05,0x0002,0x2CB0,0xFF06,0x0003,0xFF06,0x0003,0xFF05,
	0x0002,0x2CB0,0xFF05,0x0002,0x2CB0,0xFF05,0x0002,0x2CB0,
	0xFF05,0x0002,0x2CB0,0xFF05,0x0002,0x2CB0,0xFF05,0x0002,
	0x2CB0,0xFF05,0x0002,0x2CB0,0xFF05,0x0002,0x2CB0,0xFF06,
	0x0003,0xFF06,0x0003,0xFF05,0x0003,0x2CB3,0xFF05,0x0003,
	0x2CB3,0xFF05,0x0003,0x2CB3,0xFF05,0x0003,0x2CB3,0xFF05,
	0x0003,0x2CB3,0xFF05,0x0003,0x2CB3,0xFF06,0x0003,0xFF06,
	0x0003,0xFF05,0x0001,0x2CB7,0xFF06,0x0004,0xFF05,0x0002,
	0x2CB9,0xFF06,0x0004,0xFF05,0x0002,0x2D13,0xFF06,0x0004,

	0x2D16,0xFF06,0x0003,0xFF06,0x0003,0xFF05,0x0001,0x2CBC,
	0xFF06,0x0004,0xFF05,0x0002,0x2CBE,0xFF06,0x0004,0xFF05,
	0x0002,0x2D17,0xFF06,0x0004,0x2D1A,0xFF06,0x0003,0xFF06,
	0x0003,0xFF05,0x0001,0x2CC1,0xFF06,0x0004,0xFF05,0x0002,
	0x2CC3,0xFF06,0x0004,0xFF05,0x0002,0x2D1B,0xFF06,0x0004,
	0x2D1E,0xFF06,0x0003,0xFF06,0x0003,0xFF05,0x0001,0x2CC6,
	0xFF06,0x0004,0xFF05,0x0002,0x2CC8,0xFF06,0x0004,0xFF05,
	0x0002,0x2D1F,0xFF06,0x0004,0x2D22,0xFF06,0x0003,0xFF06,
	0x0003,0xFF05,0x0001,0x2CCB,0xFF06,0x0004,0xFF05,0x0002,
	0x2CCD,0xFF06,0x0004,0xFF05,0x0002,0x2D23,0xFF06,0x0004,
	0x2D26,0xFF06,0x0003,0xFF06,0x0003,0xFF05,0x0001,0x2CD0,
	0xFF06,0x0004,0xFF05,0x0002,0x2CD2,0xFF06,0x0004,0xFF05,
	0x0002,0x2D27,0xFF06,0x0004,0x2D2A,0xFF06,0x0003,0xFF06,
	0x0003,0xFF05,0x0001,0x2CD5,0xFF06,0x0004,0xFF05,0x0002,
	0x2CD7,0xFF06,0x0004,0xFF05,0x0002,0x2D2B,0xFF06,0x0004,
	0x2D2E,0xFF06,0x0003,0xFF06,0x0003,0xFF05,0x0001,0x2CDA,

	0xFF06,0x0004,0xFF05,0x0002,0x2CDC,0xFF06,0x0004,0xFF05,
	0x0002,0x2D2F,0xFF06,0x0004,0x2D32,0xFF06,0x0003,0xFF06,
	0x0003,0xFF05,0x000B,0x2CDF,0xFF05,0x000B,0x2D33,0xFF06,
	0x0003,0xFF06,0x0003,0xFF05,0x000B,0x2CEB,0xFF05,0x000B,
	0x2D3F,0xFF06,0x0003,0xFF06,0x0001,0x2CF7,0xFF05,0x0008,
	0x2CF7,0xFF05,0x0003,0x2D01,0xFF05,0x000C,0x2D4B,0x2CF7,
	0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x000D,0x2D05,0xFF05,
	0x000D,0x2D58,0xFF06,0x0001,0xFF06,0x005F,0xFF08,0xFF02,
	0x0002,0xFF03,0x0400,0xFF01,0x0000,0xFF06,0x01BF,0xFF06,
	0x003F,0xFF05,0x0007,0x3001,0xFF05,0x0007,0x3001,0xFF05,
	0x0007,0x3001,0xFF05,0x0007,0x3001,0xFF05,0x0007,0x3009,
	0xFF05,0x0007,0x3009,0xFF05,0x0007,0x3009,0xFF05,0x0007,
	0x3009,0xFF06,0x001F,0xFF03,0x0300,0xFF06,0x0003,0xFF05,
	0x0001,0x2811,0xFF06,0x0003,0xFF05,0x0001,0x2811,0xFF06,
	0x0007,0xFF05,0x0001,0x2811,0xFF06,0x0003,0xFF05,0x0001,
	0x2811,0xFF06,0x0003,0xFF06,0x0003,0xFF05,0x0001,0x2813,

	0xFF06,0x0003,0xFF05,0x0001,0x2813,0xFF06,0x0007,0xFF05,
	0x0001,0x2813,0xFF06,0x0003,0xFF05,0x0001,0x2813,0xFF06,
	0x0003,0xFF06,0x0002,0xFF05,0x0003,0x2815,0xFF06,0x0001,
	0xFF05,0x0003,0x2815,0xFF06,0x0005,0xFF05,0x0003,0x2815,
	0xFF06,0x0001,0xFF05,0x0003,0x2815,0xFF06,0x0002,0xFF06,
	0x0002,0xFF05,0x0003,0x2819,0xFF06,0x0001,0xFF05,0x0003,
	0x2819,0xFF06,0x0005,0xFF05,0x0003,0x2819,0xFF06,0x0001,
	0xFF05,0x0003,0x2819,0xFF06,0x0002,0xFF06,0x0001,0xFF05,
	0x0004,0x281D,0xFF06,0x0000,0xFF05,0x0004,0x281D,0xFF06,
	0x0004,0xFF05,0x0004,0x281D,0xFF06,0x0000,0xFF05,0x0004,
	0x281D,0xFF06,0x0002,0xFF06,0x0001,0xFF05,0x0005,0x2822,
	0xFF05,0x0005,0x2822,0xFF06,0x0003,0xFF05,0x0005,0x2822,
	0xFF05,0x0005,0x2822,0xFF06,0x0001,0xFF06,0x0001,0xFF05,
	0x0005,0x2828,0xFF05,0x0005,0x2828,0xFF06,0x0003,0xFF05,
	0x0005,0x2828,0xFF05,0x0005,0x2828,0xFF06,0x0001,0xFF06,
	0x00BF,0xFF08,0xFF02,0x0003,0xFF03,0x0300,0xFF01,0x0000,

	0xFF06,0x01BF,0xFF06,0x007F,0xFF06,0x0003,0xFF05,0x0002,
	0x2432,0xFF05,0x0002,0x2046,0xFF05,0x0004,0x2430,0xFF05,
	0x0002,0x2046,0xFF05,0x0004,0x2430,0xFF05,0x0002,0x2046,
	0xFF05,0x0001,0x2430,0xFF06,0x0003,0xFF06,0x0003,0xFF05,
	0x0002,0x2437,0xFF05,0x0002,0x2049,0xFF05,0x0004,0x2435,
	0xFF05,0x0002,0x2049,0xFF05,0x0004,0x2435,0xFF05,0x0002,
	0x2049,0xFF05,0x0001,0x2435,0xFF06,0x0003,0xFF06,0x0003,
	0xFF05,0x0001,0x243C,0xFF05,0x0003,0x204C,0xFF05,0x0003,
	0x243A,0xFF05,0x0003,0x204C,0xFF05,0x0003,0x243A,0xFF05,
	0x0003,0x204C,0xFF05,0x0001,0x243A,0xFF06,0x0003,0xFF06,
	0x0003,0x243F,0xFF05,0x0005,0x2050,0xFF05,0x0001,0x243E,
	0xFF05,0x0005,0x2050,0xFF05,0x0001,0x243E,0xFF05,0x0005,
	0x2050,0x283E,0xFF06,0x0003,0xFF06,0x0003,0x2441,0xFF05,
	0x0005,0x2056,0xFF05,0x0001,0x2440,0xFF05,0x0005,0x2056,
	0xFF05,0x0001,0x2440,0xFF05,0x0005,0x2056,0x2840,0xFF06,
	0x0003,0xFF06,0x0003,0x2443,0xFF05,0x0005,0x205C,0xFF05,

	0x0001,0x2442,0xFF05,0x0005,0x205C,0xFF05,0x0001,0x2442,
	0xFF05,0x0005,0x205C,0x2842,0xFF06,0x0003,0xFF06,0x0003,
	0x2445,0xFF05,0x0005,0x2062,0xFF05,0x0001,0x2444,0xFF05,
	0x0005,0x2062,0xFF05,0x0001,0x2444,0xFF05,0x0005,0x2062,
	0x2844,0xFF06,0x0003,0xFF06,0x0003,0xFF05,0x0007,0x2068,
	0xFF05,0x0007,0x2068,0xFF05,0x0007,0x2068,0xFF06,0x0003,
	0xFF06,0x0003,0xFF05,0x0007,0x2070,0xFF05,0x0007,0x2070,
	0xFF05,0x0007,0x2070,0xFF06,0x0003,0xFF06,0x009F,0xFF00,
	0xFF08,0xFF02,0x0000,0xFF03,0x0400,0xFF01,0x0200,0xFF06
};
static UINT16 bloodwar_mcu_4_1e[] = { // Warrior 3
	0xFF08,0xFF02,0x0000,0xFF03,0x0400,0xFF01,0x0200,0xFF06,
	0x01BF,0xFF05,0x000F,0x2C01,0xFF05,0x000F,0x2C01,0xFF05,
	0x000F,0x2C11,0xFF05,0x000F,0x2C11,0xFF05,0x0001,0x3C27,
	0xFF06,0x0003,0xFF05,0x0003,0x3C25,0xFF06,0x0003,0xFF05,
	0x0003,0x3C25,0xFF06,0x0003,0xFF05,0x0003,0x3C25,0xFF06,
	0x0003,0xFF05,0x0001,0x3C25,0xFF05,0x0001,0x3C2B,0xFF06,
	0x0003,0xFF05,0x0003,0x3C29,0xFF06,0x0003,0xFF05,0x0003,
	0x3C29,0xFF06,0x0003,0xFF05,0x0003,0x3C29,0xFF06,0x0003,
	0xFF05,0x0001,0x3C29,0xFF05,0x0001,0x3C2F,0xFF06,0x0003,
	0xFF05,0x0003,0x3C2D,0xFF06,0x0003,0xFF05,0x0003,0x3C2D,
	0xFF06,0x0003,0xFF05,0x0003,0x3C2D,0xFF06,0x0003,0xFF05,
	0x0001,0x3C2D,0xFF05,0x0001,0x3C33,0xFF06,0x0003,0xFF05,
	0x0003,0x3C31,0xFF06,0x0003,0xFF05,0x0003,0x3C31,0xFF06,
	0x0003,0xFF05,0x0003,0x3C31,0xFF06,0x0003,0xFF05,0x0001,
	0x3C31,0x3C36,0xFF06,0x0005,0xFF05,0x0001,0x3C35,0xFF06,
	0x0005,0xFF05,0x0001,0x3C35,0xFF06,0x0005,0xFF05,0x0001,

	0x3C35,0xFF06,0x0005,0x3C35,0xFF06,0x00DF,0xFF03,0x0300,
	0xFF06,0x0001,0xFF05,0x0001,0x2439,0xFF05,0x0001,0x203B,
	0xFF05,0x0002,0x243D,0xFF05,0x000C,0x2040,0xFF04,0x0002,
	0x2040,0xFF09,0x0002,0x243F,0xFF09,0x0001,0x203C,0xFF09,
	0x0001,0x243A,0xFF04,0x0000,0xFF06,0x0001,0xFF06,0x0000,
	0xFF05,0x0002,0x244E,0xFF05,0x0001,0x2051,0xFF05,0x0002,
	0x2453,0xFF05,0x000C,0x2056,0xFF04,0x0002,0x2056,0xFF09,
	0x0002,0x2455,0xFF09,0x0001,0x2052,0xFF09,0x0002,0x2450,
	0xFF04,0x0000,0xFF06,0x0000,0xFF05,0x0003,0x2463,0xFF05,
	0x0001,0x2067,0xFF05,0x0002,0x2469,0xFF05,0x000C,0x206C,
	0xFF04,0x0002,0x206C,0xFF09,0x0002,0x246B,0xFF09,0x0001,
	0x2068,0xFF09,0x0003,0x2466,0xFF04,0x0000,0xFF05,0x0003,
	0x2479,0xFF05,0x0001,0x207D,0xFF05,0x0002,0x247F,0xFF05,
	0x000C,0x2082,0xFF04,0x0002,0x2082,0xFF09,0x0002,0x2481,
	0xFF09,0x0001,0x207E,0xFF09,0x0003,0x247C,0xFF04,0x0000,
	0xFF08,0xFF02,0x0001,0xFF03,0x0400,0xFF01,0x0200,0xFF06,

	0x01BF,0xFF06,0x003F,0xFF06,0x0003,0xFF05,0x0001,0x38AB,
	0xFF06,0x0002,0xFF05,0x0001,0x38AB,0xFF06,0x0009,0xFF04,
	0x0002,0xFF09,0x0001,0x38AC,0xFF06,0x0002,0xFF09,0x0001,
	0x38AC,0xFF04,0x0000,0xFF06,0x0003,0xFF06,0x0003,0xFF05,
	0x0001,0x38AD,0xFF06,0x0002,0xFF05,0x0001,0x38AD,0xFF06,
	0x0009,0xFF04,0x0002,0xFF09,0x0001,0x38AE,0xFF06,0x0002,
	0xFF09,0x0001,0x38AE,0xFF04,0x0000,0xFF06,0x0003,0xFF06,
	0x0003,0xFF05,0x0001,0x38AF,0xFF06,0x0002,0xFF05,0x0001,
	0x38AF,0xFF06,0x0009,0xFF04,0x0002,0xFF09,0x0001,0x38B0,
	0xFF06,0x0002,0xFF09,0x0001,0x38B0,0xFF04,0x0000,0xFF06,
	0x0003,0xFF06,0x0003,0xFF05,0x0001,0x38B1,0xFF06,0x0002,
	0xFF05,0x0001,0x38B1,0xFF06,0x0009,0xFF04,0x0002,0xFF09,
	0x0001,0x38B2,0xFF06,0x0002,0xFF09,0x0001,0x38B2,0xFF04,
	0x0000,0xFF06,0x0003,0xFF06,0x0003,0xFF05,0x0001,0x38B3,
	0xFF06,0x0002,0xFF05,0x0001,0x38B3,0xFF06,0x0000,0xFF05,
	0x0001,0x3490,0xFF06,0x0003,0xFF04,0x0002,0xFF09,0x0001,

	0x3091,0xFF06,0x0000,0xFF09,0x0001,0x38B4,0xFF06,0x0002,
	0xFF09,0x0001,0x38B4,0xFF04,0x0000,0xFF06,0x0003,0xFF06,
	0x0003,0xFF05,0x0001,0x38B5,0xFF06,0x0002,0xFF05,0x0001,
	0x38B5,0xFF06,0x0000,0xFF05,0x0002,0x3492,0xFF06,0x0001,
	0xFF04,0x0002,0xFF09,0x0002,0x3094,0xFF06,0x0000,0xFF09,
	0x0001,0x38B6,0xFF06,0x0002,0xFF09,0x0001,0x38B6,0xFF04,
	0x0000,0xFF06,0x0003,0xFF06,0x0003,0xFF05,0x0001,0x38B7,
	0xFF06,0x0002,0xFF05,0x0001,0x38B7,0xFF06,0x0000,0xFF05,
	0x0002,0x3495,0xFF06,0x0001,0xFF04,0x0002,0xFF09,0x0002,
	0x3097,0xFF06,0x0000,0xFF09,0x0001,0x38B8,0xFF06,0x0002,
	0xFF09,0x0001,0x38B8,0xFF04,0x0000,0xFF06,0x0003,0xFF06,
	0x0003,0xFF05,0x0001,0x38B9,0xFF06,0x0002,0xFF05,0x0001,
	0x38B9,0xFF05,0x0003,0x3498,0xFF06,0x0001,0xFF04,0x0002,
	0xFF09,0x0003,0x309B,0xFF09,0x0001,0x38BA,0xFF06,0x0002,
	0xFF09,0x0001,0x38BA,0xFF04,0x0000,0xFF06,0x0003,0xFF06,
	0x0003,0xFF05,0x0001,0x38BB,0xFF06,0x0002,0xFF05,0x0001,

	0x38BB,0xFF05,0x0004,0x349C,0xFF04,0x0002,0xFF09,0x0004,
	0x30A0,0xFF09,0x0001,0x38BC,0xFF06,0x0002,0xFF09,0x0001,
	0x38BC,0xFF04,0x0000,0xFF06,0x0003,0xFF06,0x0003,0xFF05,
	0x0001,0x38BD,0xFF06,0x0002,0xFF05,0x0001,0x38BD,0xFF05,
	0x0004,0x34A1,0xFF04,0x0002,0xFF09,0x0004,0x30A5,0xFF09,
	0x0001,0x38BE,0xFF06,0x0002,0xFF09,0x0001,0x38BE,0xFF04,
	0x0000,0xFF06,0x0003,0xFF06,0x0003,0xFF05,0x0001,0x38BF,
	0xFF06,0x0002,0xFF05,0x0001,0x38BF,0xFF05,0x0004,0x34A6,
	0xFF04,0x0002,0xFF09,0x0004,0x30AA,0xFF09,0x0001,0x38C0,
	0xFF06,0x0002,0xFF09,0x0001,0x38C0,0xFF04,0x0000,0xFF06,
	0x0003,0xFF06,0x0003,0xFF05,0x0001,0x38C1,0xFF06,0x0002,
	0xFF05,0x0007,0x38C1,0xFF04,0x0002,0xFF09,0x0005,0x38C6,
	0xFF06,0x0002,0xFF09,0x0001,0x38C2,0xFF04,0x0000,0xFF06,
	0x0003,0xFF06,0x0003,0xFF05,0x0001,0x38C9,0xFF06,0x0002,
	0xFF05,0x0007,0x38C9,0xFF04,0x0002,0xFF09,0x0005,0x38CE,
	0xFF06,0x0002,0xFF09,0x0001,0x38CA,0xFF04,0x0000,0xFF06,

	0x0003,0xFF06,0x005F,0xFF08,0xFF02,0x0002,0xFF03,0x0400,
	0xFF01,0x0100,0xFF06,0x01BF,0xFF06,0x003F,0xFF05,0x0002,
	0x2C01,0xFF05,0x0002,0x2C01,0xFF05,0x0002,0x2C01,0xFF05,
	0x0002,0x2C01,0xFF05,0x0002,0x2C01,0xFF05,0x0002,0x2C01,
	0xFF05,0x0002,0x2C01,0xFF05,0x0002,0x2C01,0xFF05,0x0002,
	0x2C01,0xFF05,0x0002,0x2C01,0xFF05,0x0001,0x2C01,0xFF05,
	0x0002,0x2C04,0xFF05,0x0002,0x2C04,0xFF05,0x0002,0x2C04,
	0xFF05,0x0002,0x2C04,0xFF05,0x0002,0x2C04,0xFF05,0x0002,
	0x2C04,0xFF05,0x0002,0x2C04,0xFF05,0x0002,0x2C04,0xFF05,
	0x0002,0x2C04,0xFF05,0x0002,0x2C04,0xFF05,0x0001,0x2C04,
	0xFF05,0x0007,0x2C07,0xFF05,0x0007,0x2C07,0xFF05,0x0007,
	0x2C07,0xFF05,0x0007,0x2C07,0xFF05,0x0007,0x2C0F,0xFF05,
	0x0007,0x2C0F,0xFF05,0x0007,0x2C0F,0xFF05,0x0007,0x2C0F,
	0xFF06,0x0002,0x3819,0xFF06,0x0003,0x3819,0xFF06,0x0003,
	0x3819,0xFF06,0x0003,0x3819,0xFF06,0x0003,0x3819,0xFF06,
	0x0003,0x3819,0xFF06,0x0002,0xFF06,0x0002,0x381A,0xFF06,

	0x0003,0x381A,0xFF06,0x0003,0x381A,0xFF06,0x0003,0x381A,
	0xFF06,0x0003,0x381A,0xFF06,0x0003,0x381A,0xFF06,0x0002,
	0xFF06,0x0002,0x381B,0xFF06,0x0003,0x381B,0xFF06,0x0003,
	0x381B,0xFF06,0x0003,0x381B,0xFF06,0x0003,0x381B,0xFF06,
	0x0003,0x381B,0xFF06,0x0002,0xFF06,0x0002,0x381C,0xFF06,
	0x0003,0x381C,0xFF06,0x0003,0x381C,0xFF06,0x0003,0x381C,
	0xFF06,0x0003,0x381C,0xFF06,0x0003,0x381C,0xFF06,0x0002,
	0xFF06,0x0002,0x381D,0xFF06,0x0003,0x381D,0xFF06,0x0003,
	0x381D,0xFF06,0x0003,0x381D,0xFF06,0x0003,0x381D,0xFF06,
	0x0003,0x381D,0xFF06,0x0002,0xFF06,0x0002,0x381E,0xFF06,
	0x0003,0x381E,0xFF06,0x0003,0x381E,0xFF06,0x0003,0x381E,
	0xFF06,0x0003,0x381E,0xFF06,0x0003,0x381E,0xFF06,0x0002,
	0xFF06,0x0002,0x381F,0xFF06,0x0003,0x381F,0xFF06,0x0003,
	0x381F,0xFF06,0x0003,0x381F,0xFF06,0x0003,0x381F,0xFF06,
	0x0003,0x381F,0xFF06,0x0002,0xFF06,0x0002,0x3820,0xFF06,
	0x0003,0x3820,0xFF06,0x0003,0x3820,0xFF06,0x0003,0x3820,

	0xFF06,0x0003,0x3820,0xFF06,0x0003,0x3820,0xFF06,0x0002,
	0xFF06,0x0002,0x3821,0xFF06,0x0003,0x3821,0xFF06,0x0003,
	0x3821,0xFF06,0x0003,0x3821,0xFF06,0x0003,0x3821,0xFF06,
	0x0003,0x3821,0xFF06,0x0002,0xFF06,0x005F,0xFF08,0xFF02,
	0x0003,0xFF03,0x0400,0xFF01,0x0100,0xFF06,0x01BF,0xFF06,
	0x00BF,0xFF05,0x0007,0x2C30,0xFF05,0x0007,0x2C30,0xFF05,
	0x0007,0x2C30,0xFF05,0x0007,0x2C30,0xFF05,0x000F,0x2C38,
	0xFF05,0x000F,0x2CA0,0xFF05,0x000F,0x2C48,0xFF05,0x000F,
	0x2CB0,0xFF05,0x000F,0x2C58,0xFF05,0x000F,0x2CC0,0xFF06,
	0x0002,0xFF04,0x0002,0xFF09,0x000B,0x2875,0xFF04,0x0000,
	0xFF05,0x000D,0x2868,0xFF06,0x0002,0xFF06,0x0002,0xFF04,
	0x0002,0xFF09,0x000B,0x2883,0xFF04,0x0000,0xFF05,0x000D,
	0x2876,0xFF06,0x0002,0xFF06,0x0002,0xFF04,0x0002,0xFF09,
	0x000B,0x2891,0xFF04,0x0000,0xFF05,0x000D,0x2884,0xFF06,
	0x0002,0xFF06,0x0002,0xFF04,0x0002,0xFF09,0x000B,0x289F,
	0xFF04,0x0000,0xFF05,0x000D,0x2892,0xFF06,0x0002,0xFF06,

	0x007F,0xFF00,0xFF08,0xFF02,0x0000,0xFF03,0x0200,0xFF01
};
static UINT16 bloodwar_mcu_4_1f[] = { // Warrior 5
	0xFF08,0xFF02,0x0000,0xFF03,0x0200,0xFF01,0x0800,0xFF06,
	0x01BF,0xFF06,0x007F,0xFF06,0x0009,0xFF05,0x0002,0x2801,
	0xFF05,0x0004,0x3429,0xFF06,0x0000,0xFF05,0x0002,0x342E,
	0xFF05,0x0002,0x2815,0xFF06,0x0006,0xFF06,0x0009,0xFF05,
	0x0002,0x2804,0xFF05,0x0008,0x3431,0xFF05,0x0002,0x2818,
	0xFF06,0x0006,0xFF06,0x0009,0xFF05,0x0001,0x2807,0xFF06,
	0x0000,0xFF05,0x0008,0x343A,0xFF06,0x0000,0xFF05,0x0001,
	0x281B,0xFF06,0x0006,0xFF06,0x0009,0xFF05,0x0001,0x2809,
	0xFF06,0x0000,0xFF05,0x0004,0x3443,0xFF06,0x0000,0xFF05,
	0x0002,0x3448,0xFF06,0x0000,0xFF05,0x0001,0x281D,0xFF06,
	0x0006,0xFF06,0x0009,0xFF05,0x0001,0x280B,0xFF06,0x000A,
	0xFF05,0x0001,0x281F,0xFF06,0x0006,0xFF06,0x0009,0xFF05,
	0x0001,0x280D,0xFF06,0x000A,0xFF05,0x0001,0x2821,0xFF06,
	0x0006,0xFF06,0x0009,0xFF05,0x0001,0x280F,0xFF06,0x000A,
	0xFF05,0x0001,0x2823,0xFF06,0x0006,0xFF06,0x0009,0xFF05,
	0x0001,0x2811,0xFF06,0x000A,0xFF05,0x0001,0x2825,0xFF06,

	0x0006,0xFF06,0x0009,0xFF05,0x0001,0x2813,0xFF06,0x000A,
	0xFF05,0x0001,0x2827,0xFF06,0x0006,0xFF05,0x0007,0x2053,
	0xFF05,0x000F,0x204B,0xFF05,0x0007,0x204B,0xFF05,0x0007,
	0x2063,0xFF05,0x000F,0x205B,0xFF05,0x0007,0x205B,0xFF05,
	0x0007,0x2073,0xFF05,0x000F,0x206B,0xFF05,0x0007,0x206B,
	0xFF06,0x003F,0xFF08,0xFF02,0x0001,0xFF03,0x0200,0xFF01,
	0x0900,0xFF06,0x01BF,0xFF06,0x0001,0xFF05,0x000D,0x2801,
	0xFF05,0x000F,0x284A,0xFF06,0x0003,0xFF05,0x000B,0x280F,
	0xFF05,0x000D,0x285A,0xFF06,0x0001,0xFF06,0x0005,0xFF05,
	0x0009,0x281B,0xFF05,0x000C,0x2868,0xFF06,0x0002,0xFF06,
	0x0006,0xFF05,0x0008,0x2825,0xFF05,0x000A,0x2875,0xFF06,
	0x0004,0xFF06,0x0008,0xFF05,0x0006,0x282E,0xFF05,0x0009,
	0x2880,0xFF06,0x0005,0xFF06,0x0009,0xFF05,0x0005,0x2835,
	0xFF05,0x0006,0x288A,0xFF06,0x0008,0xFF06,0x000A,0xFF05,
	0x0004,0x283B,0xFF05,0x0005,0x2891,0xFF06,0x0009,0xFF06,
	0x000B,0xFF05,0x0003,0x2840,0xFF05,0x0005,0x2897,0xFF06,

	0x0009,0xFF06,0x000C,0xFF05,0x0002,0x2844,0xFF05,0x0004,
	0x289D,0xFF06,0x000A,0xFF06,0x000C,0x2847,0xFF06,0x0005,
	0x28A2,0xFF06,0x000A,0xFF06,0x000C,0x2848,0xFF06,0x0005,
	0x28A3,0xFF06,0x000A,0xFF06,0x000C,0x2849,0xFF06,0x0005,
	0x28A4,0xFF06,0x000A,0xFF06,0x005F,0xFF03,0x0300,0xFF06,
	0x0000,0xFF04,0x0002,0xFF09,0x000E,0x30B3,0xFF04,0x0000,
	0xFF05,0x000E,0x30A5,0xFF06,0x0000,0xFF04,0x0002,0xFF09,
	0x000F,0x30C3,0xFF04,0x0000,0xFF05,0x000F,0x30B4,0xFF04,
	0x0002,0xFF09,0x000F,0x30D3,0xFF04,0x0000,0xFF05,0x000F,
	0x30C4,0xFF08,0xFF02,0x0002,0xFF03,0x0200,0xFF01,0x0400,
	0xFF06,0x01BF,0xFF06,0x005F,0xFF06,0x0005,0xFF05,0x0001,
	0x25C6,0xFF06,0x0005,0xFF05,0x0003,0x2401,0xFF06,0x000D,
	0xFF06,0x0003,0xFF05,0x0003,0x25C8,0xFF05,0x000C,0x2405,
	0xFF06,0x0003,0xFF05,0x0002,0x25E4,0xFF06,0x0003,0xFF06,
	0x0003,0xFF05,0x0003,0x25CC,0xFF05,0x000F,0x2412,0xFF05,
	0x0003,0x25E7,0xFF06,0x0003,0xFF06,0x0003,0xFF05,0x0003,

	0x25D0,0xFF05,0x000F,0x2422,0xFF05,0x0003,0x25EB,0xFF06,
	0x0003,0xFF06,0x0003,0xFF05,0x0003,0x25D4,0xFF05,0x000F,
	0x2432,0xFF05,0x0003,0x25EF,0xFF06,0x0003,0xFF06,0x0003,
	0xFF05,0x0003,0x25D8,0xFF05,0x000F,0x2442,0xFF05,0x0003,
	0x25F3,0xFF06,0x0003,0xFF06,0x0003,0xFF05,0x0003,0x25DC,
	0xFF05,0x000F,0x2452,0xFF05,0x0003,0x25F7,0xFF06,0x0003,
	0xFF06,0x0003,0xFF05,0x0003,0x25E0,0xFF05,0x000F,0x2462,
	0xFF05,0x0003,0x25FB,0xFF06,0x0003,0xFF06,0x005F,0xFF03,
	0x0400,0xFF06,0x0004,0xFF05,0x0002,0x3A01,0xFF06,0x0000,
	0xFF05,0x0001,0x3A07,0xFF06,0x0009,0xFF05,0x0001,0x3A0B,
	0xFF06,0x0000,0xFF05,0x0002,0x3A0F,0xFF06,0x0004,0xFF06,
	0x0004,0xFF05,0x0002,0x3A04,0xFF06,0x0000,0xFF05,0x0001,
	0x3A09,0xFF06,0x0009,0xFF05,0x0001,0x3A0D,0xFF06,0x0000,
	0xFF05,0x0002,0x3A12,0xFF06,0x0004,0xFF06,0x003F,0xFF08,
	0xFF02,0x0003,0xFF03,0x0200,0xFF01,0x0600,0xFF06,0x01BF,
	0xFF05,0x000F,0x3C6D,0xFF05,0x000F,0x3C6D,0xFF05,0x000F,

	0x3C7D,0xFF05,0x000F,0x3C7D,0xFF05,0x000F,0x3C8D,0xFF05,
	0x000F,0x3C8D,0xFF05,0x000F,0x3C6D,0xFF05,0x000F,0x3C6D,
	0xFF05,0x000F,0x3C7D,0xFF05,0x000F,0x3C7D,0xFF05,0x000F,
	0x3C8D,0xFF05,0x000F,0x3C8D,0xFF06,0x007F,0xFF03,0x0300,
	0xFF05,0x0007,0x2C28,0xFF05,0x000F,0x2C20,0xFF05,0x0007,
	0x2C20,0xFF05,0x0007,0x2C38,0xFF05,0x000F,0x2C30,0xFF05,
	0x0007,0x2C30,0xFF05,0x0007,0x2C48,0xFF05,0x000F,0x2C40,
	0xFF05,0x0007,0x2C40,0xFF05,0x0007,0x2C58,0xFF05,0x000F,
	0x2C50,0xFF05,0x0007,0x2C50,0xFF06,0x0003,0xFF05,0x0003,
	0x2C66,0xFF05,0x0004,0x2C60,0xFF06,0x0006,0xFF05,0x0003,
	0x2C66,0xFF05,0x0004,0x2C60,0xFF06,0x0002,0xFF06,0x0005,
	0xFF05,0x0001,0x2C6B,0x2C6A,0xFF06,0x000C,0xFF05,0x0001,
	0x2C6B,0x2C6A,0xFF06,0x0006,0xFF06,0x003F,0xFF00,0xFF08
};
static UINT16 bloodwar_mcu_4_20[] = { // Warrior 4
	0xFF08,0xFF02,0x0000,0xFF03,0x0400,0xFF01,0x1100,0xFF06,
	0x01BF,0xFF06,0x00DF,0xFF06,0x0001,0xFF04,0x0002,0xFF09,
	0x0001,0x2402,0xFF04,0x0000,0xFF06,0x0017,0xFF05,0x0001,
	0x2401,0xFF06,0x0001,0xFF04,0x0002,0xFF09,0x0004,0x2407,
	0xFF04,0x0000,0xFF06,0x0003,0xFF05,0x0001,0x3837,0xFF06,
	0x0009,0xFF04,0x0002,0xFF09,0x0001,0x3838,0xFF04,0x0000,
	0xFF06,0x0003,0xFF05,0x0004,0x2403,0xFF04,0x0002,0xFF09,
	0x0005,0x240D,0xFF04,0x0000,0xFF06,0x0002,0xFF05,0x0002,
	0x3839,0xFF06,0x0007,0xFF04,0x0002,0xFF09,0x0002,0x383B,
	0xFF04,0x0000,0xFF06,0x0002,0xFF05,0x0005,0x2408,0xFF04,
	0x0002,0xFF09,0x0005,0x2415,0xFF04,0x0000,0xFF06,0x0002,
	0xFF05,0x0001,0x383C,0xFF06,0x0009,0xFF04,0x0002,0xFF09,
	0x0001,0x383D,0xFF04,0x0000,0xFF06,0x0002,0xFF05,0x0005,
	0x2410,0xFF04,0x0002,0xFF09,0x0006,0x241E,0xFF04,0x0000,
	0xFF06,0x0001,0xFF05,0x0001,0x383E,0xFF06,0x0009,0xFF04,
	0x0002,0xFF09,0x0001,0x383F,0xFF04,0x0000,0xFF06,0x0001,

	0xFF05,0x0006,0x2418,0xFF04,0x0002,0xFF09,0x0006,0x2427,
	0xFF04,0x0000,0xFF06,0x0002,0x3840,0xFF06,0x0009,0xFF04,
	0x0002,0x3840,0xFF04,0x0000,0xFF06,0x0002,0xFF05,0x0006,
	0x2421,0xFF04,0x0002,0xFF09,0x0006,0x2430,0xFF04,0x0000,
	0xFF06,0x0001,0xFF05,0x0002,0x3841,0xFF06,0x0007,0xFF04,
	0x0002,0xFF09,0x0002,0x3843,0xFF04,0x0000,0xFF06,0x0001,
	0xFF05,0x0006,0x242A,0xFF06,0x0000,0xFF04,0x0002,0xFF09,
	0x0001,0x2434,0xFF04,0x0000,0xFF06,0x0005,0xFF05,0x0002,
	0x3844,0xFF06,0x0007,0xFF04,0x0002,0xFF09,0x0002,0x3846,
	0xFF04,0x0000,0xFF06,0x0005,0xFF05,0x0001,0x2433,0xFF06,
	0x0000,0xFF08,0xFF02,0x0001,0xFF03,0x0400,0xFF01,0x1100,
	0xFF06,0x01BF,0xFF06,0x003F,0xFF06,0x0001,0xFF04,0x0002,
	0xFF09,0x000D,0x347C,0xFF04,0x0000,0xFF05,0x000D,0x346F,
	0xFF06,0x0001,0xFF06,0x0001,0xFF04,0x0002,0xFF09,0x000D,
	0x348A,0xFF04,0x0000,0xFF05,0x000D,0x347D,0xFF06,0x0001,
	0xFF06,0x0000,0xFF04,0x0002,0xFF09,0x000E,0x3499,0xFF04,

	0x0000,0xFF05,0x000E,0x348B,0xFF06,0x0000,0xFF04,0x0002,
	0xFF09,0x000F,0x34A9,0xFF04,0x0000,0xFF05,0x000F,0x349A,
	0xFF04,0x0002,0xFF09,0x000F,0x34B9,0xFF04,0x0000,0xFF05,
	0x000F,0x34AA,0xFF06,0x0000,0xFF04,0x0002,0xFF09,0x000E,
	0x30C8,0xFF04,0x0000,0xFF05,0x000E,0x30BA,0xFF06,0x0000,
	0xFF04,0x0002,0xFF09,0x000F,0x30D8,0xFF04,0x0000,0xFF05,
	0x000F,0x30C9,0xFF04,0x0002,0xFF09,0x000C,0x30E5,0xFF04,
	0x0000,0xFF06,0x0005,0xFF05,0x000C,0x30D9,0xFF04,0x0002,
	0xFF09,0x000C,0x30F2,0xFF04,0x0000,0xFF06,0x0005,0xFF05,
	0x000C,0x30E6,0xFF04,0x0002,0xFF09,0x000C,0x30FF,0xFF04,
	0x0000,0xFF06,0x0005,0xFF05,0x000C,0x30F3,0xFF04,0x0002,
	0xFF09,0x000C,0x310D,0xFF04,0x0000,0xFF06,0x0005,0xFF05,
	0x000C,0x3101,0xFF04,0x0002,0xFF09,0x000C,0x311A,0xFF04,
	0x0000,0xFF06,0x0005,0xFF05,0x000C,0x310E,0xFF06,0x007F,
	0xFF08,0xFF02,0x0002,0xFF03,0x0400,0xFF01,0x0E00,0xFF06,
	0x01BF,0xFF06,0x00BF,0xFF06,0x000A,0xFF05,0x000B,0x2C01,

	0xFF06,0x0008,0xFF06,0x000A,0xFF05,0x000B,0x2C0D,0xFF06,
	0x0008,0xFF06,0x000A,0xFF05,0x000B,0x2C19,0xFF06,0x0008,
	0xFF06,0x000A,0xFF05,0x000B,0x2C25,0xFF06,0x0008,0xFF06,
	0x000A,0xFF05,0x000B,0x2C31,0xFF06,0x0008,0xFF06,0x000A,
	0xFF05,0x000B,0x2C3D,0xFF06,0x0008,0xFF06,0x000A,0xFF05,
	0x000B,0x2C49,0xFF06,0x0008,0xFF0A,0x000B,0x3C61,0xFF05,
	0x000B,0x2C55,0xFF0A,0x0007,0x3C61,0xFF04,0x0002,0xFF09,
	0x000D,0x3C79,0xFF04,0x0000,0xFF05,0x0001,0x3C62,0xFF05,
	0x000F,0x3C6A,0xFF04,0x0002,0xFF09,0x000D,0x3C89,0xFF04,
	0x0000,0xFF05,0x0001,0x3C64,0xFF05,0x000F,0x3C7A,0xFF04,
	0x0002,0xFF09,0x000D,0x3C99,0xFF04,0x0000,0xFF05,0x0001,
	0x3C66,0xFF05,0x000F,0x3C8A,0xFF04,0x0002,0xFF09,0x000D,
	0x3CA9,0xFF04,0x0000,0xFF05,0x0001,0x3C68,0xFF05,0x000F,
	0x3C9A,0xFF08,0xFF02,0x0003,0xFF03,0x0200,0xFF01,0x0E00,
	0xFF06,0x01BF,0xFF05,0x000F,0x20B0,0xFF05,0x000F,0x20B0,
	0xFF05,0x000F,0x20C0,0xFF05,0x000F,0x20C0,0xFF05,0x000F,

	0x20D0,0xFF05,0x000F,0x20D0,0xFF05,0x000F,0x20E0,0xFF05,
	0x000F,0x20E0,0xFF05,0x000F,0x20F0,0xFF05,0x000F,0x20F0,
	0xFF05,0x000F,0x2101,0xFF05,0x000F,0x2101,0xFF05,0x000F,
	0x2111,0xFF05,0x000F,0x2111,0xFF05,0x000F,0x2121,0xFF05,
	0x000F,0x2121,0xFF06,0x013F,0xFF00,0xFF08,0xFF02,0x0000
};
static UINT16 bloodwar_mcu_4_21[] = { // Warrior 6
	0xFF08,0xFF02,0x0000,0xFF03,0x0400,0xFF01,0x0F00,0xFF06,
	0x01BF,0xFF06,0x005F,0xFF06,0x000F,0x4401,0xFF06,0x000E,
	0xFF06,0x000C,0xFF05,0x0005,0x4402,0xFF06,0x000C,0xFF06,
	0x000C,0xFF05,0x0005,0x4408,0xFF06,0x000C,0xFF06,0x000C,
	0xFF05,0x0005,0x440E,0xFF06,0x000C,0xFF06,0x000C,0xFF05,
	0x0005,0x4414,0xFF06,0x000C,0xFF06,0x000C,0xFF05,0x0005,
	0x401A,0xFF06,0x000C,0xFF06,0x0008,0xFF05,0x0001,0x4901,
	0xFF06,0x0000,0xFF05,0x0007,0x4020,0xFF06,0x0000,0xFF04,
	0x0002,0xFF09,0x0001,0x4902,0xFF04,0x0000,0xFF06,0x0008,
	0xFF06,0x0007,0xFF05,0x0002,0x4903,0xFF06,0x0000,0xFF05,
	0x0007,0x4028,0xFF06,0x0000,0xFF04,0x0002,0xFF09,0x0002,
	0x4905,0xFF04,0x0000,0xFF06,0x0007,0xFF06,0x0007,0xFF05,
	0x0002,0x4906,0xFF06,0x0000,0xFF05,0x0007,0x3C30,0xFF06,
	0x0000,0xFF04,0x0002,0xFF09,0x0002,0x4908,0xFF04,0x0000,
	0xFF06,0x0007,0xFF06,0x0007,0xFF05,0x0002,0x4909,0xFF06,
	0x0000,0xFF05,0x0007,0x3C38,0xFF06,0x0000,0xFF04,0x0002,

	0xFF09,0x0002,0x490B,0xFF04,0x0000,0xFF06,0x0007,0xFF06,
	0x0007,0x490C,0xFF06,0x0000,0x490D,0xFF05,0x0009,0x3C40,
	0xFF04,0x0002,0x490D,0xFF06,0x0000,0x490C,0xFF04,0x0000,
	0xFF06,0x0007,0xFF06,0x0007,0x490E,0xFF06,0x0001,0xFF05,
	0x0009,0x3C4A,0xFF06,0x0001,0xFF04,0x0002,0x490E,0xFF04,
	0x0000,0xFF06,0x0007,0xFF06,0x0007,0x490F,0xFF06,0x0003,
	0xFF05,0x0005,0x3C54,0xFF06,0x0003,0xFF04,0x0002,0x490F,
	0xFF04,0x0000,0xFF06,0x0007,0xFF06,0x003F,0xFF08,0xFF02,
	0x0001,0xFF03,0x0300,0xFF01,0x0F00,0xFF06,0x01BF,0xFF06,
	0x007F,0xFF06,0x0001,0xFF05,0x0001,0x3870,0xFF06,0x0005,
	0xFF05,0x0001,0x3872,0xFF06,0x0007,0xFF05,0x0001,0x38CA,
	0xFF06,0x0005,0xFF04,0x0002,0xFF09,0x0001,0x3871,0xFF04,
	0x0000,0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x0002,0x3874,
	0xFF06,0x0000,0x3877,0xFF06,0x0001,0xFF05,0x0002,0x3878,
	0xFF06,0x0007,0xFF05,0x0002,0x38CC,0xFF06,0x0003,0xFF04,
	0x0002,0xFF09,0x0002,0x3876,0xFF04,0x0000,0xFF06,0x0001,

	0xFF06,0x0001,0xFF05,0x0005,0x387B,0xFF06,0x0000,0xFF05,
	0x0003,0x3881,0xFF06,0x0005,0xFF05,0x0003,0x38CF,0xFF06,
	0x0003,0xFF04,0x0002,0xFF09,0x0002,0x387D,0xFF04,0x0000,
	0xFF06,0x0001,0xFF06,0x0000,0xFF05,0x0006,0x3885,0xFF06,
	0x0000,0xFF05,0x0003,0x388C,0xFF06,0x0005,0xFF05,0x0007,
	0x38D3,0xFF04,0x0002,0xFF09,0x0003,0x3888,0xFF04,0x0000,
	0xFF06,0x0000,0xFF06,0x0000,0xFF05,0x0007,0x3890,0xFF06,
	0x0000,0xFF05,0x0002,0x3898,0xFF06,0x0005,0xFF05,0x0007,
	0x38DB,0xFF04,0x0002,0xFF09,0x0003,0x3893,0xFF04,0x0000,
	0xFF06,0x0000,0xFF06,0x0000,0xFF05,0x000B,0x389B,0xFF06,
	0x0005,0xFF05,0x0007,0x38E3,0xFF04,0x0002,0xFF09,0x0003,
	0x389E,0xFF04,0x0000,0xFF06,0x0000,0xFF06,0x0000,0xFF05,
	0x000B,0x38A7,0xFF06,0x0005,0xFF05,0x0007,0x38EB,0xFF04,
	0x0002,0xFF09,0x0003,0x38AA,0xFF04,0x0000,0xFF06,0x0000,
	0xFF06,0x0000,0xFF05,0x000B,0x38B3,0xFF06,0x0005,0xFF05,
	0x0007,0x38F3,0xFF04,0x0002,0xFF09,0x0003,0x38B6,0xFF04,

	0x0000,0xFF06,0x0000,0xFF06,0x0001,0xFF05,0x000A,0x38BF,
	0xFF06,0x0005,0xFF05,0x0004,0x38FB,0xFF05,0x0002,0x386D,
	0xFF04,0x0002,0xFF09,0x0002,0x38C1,0xFF04,0x0000,0xFF06,
	0x0001,0xFF06,0x009F,0xFF08,0xFF02,0x0002,0xFF03,0x0200,
	0xFF01,0x0C00,0xFF06,0x01BF,0xFF06,0x0001,0x2000,0xFF05,
	0x0001,0x2001,0x2400,0xFF05,0x0001,0x2590,0x2800,0xFF05,
	0x0001,0x29AC,0x2C00,0xFF05,0x0001,0x2DCB,0xFF06,0x0003,
	0xFF04,0x0002,0xFF09,0x0001,0x2002,0x2000,0xFF09,0x0001,
	0x2591,0x2400,0xFF09,0x0001,0x29AD,0x2800,0xFF09,0x0001,
	0x2DCC,0x2C00,0xFF04,0x0000,0xFF06,0x0001,0xFF06,0x0001,
	0x2000,0xFF05,0x0001,0x2003,0xFF05,0x0002,0x2592,0xFF05,
	0x0002,0x29AE,0xFF05,0x0002,0x2DCD,0xFF06,0x0003,0xFF04,
	0x0002,0xFF09,0x0001,0x2004,0x2000,0xFF09,0x0002,0x2594,
	0xFF09,0x0002,0x29B0,0xFF09,0x0002,0x2DCF,0xFF04,0x0000,
	0xFF06,0x0001,0xFF06,0x0001,0x2000,0xFF05,0x0001,0x2005,
	0xFF05,0x0002,0x2595,0xFF05,0x0002,0x29B1,0xFF05,0x0002,

	0x2DD0,0xFF06,0x0003,0xFF04,0x0002,0xFF09,0x0001,0x2006,
	0x2000,0xFF09,0x0002,0x2597,0xFF09,0x0002,0x29B3,0xFF09,
	0x0002,0x2DD2,0xFF04,0x0000,0xFF06,0x0001,0xFF06,0x0001,
	0x2000,0xFF05,0x0001,0x2007,0x2400,0xFF05,0x0001,0x2598,
	0xFF05,0x0002,0x29B4,0x2C00,0xFF05,0x0001,0x2DD3,0xFF06,
	0x0003,0xFF04,0x0002,0xFF09,0x0001,0x2008,0x2000,0xFF09,
	0x0001,0x2599,0x2400,0xFF09,0x0002,0x29B6,0xFF09,0x0001,
	0x2DD4,0x2C00,0xFF04,0x0000,0xFF06,0x0001,0xFF06,0x0001,
	0x2000,0xFF05,0x0001,0x2009,0xFF05,0x0002,0x259A,0xFF05,
	0x0002,0x29B7,0x2C00,0xFF05,0x0001,0x2DD5,0xFF06,0x0003,
	0xFF04,0x0002,0xFF09,0x0001,0x200A,0x2000,0xFF09,0x0002,
	0x259C,0xFF09,0x0002,0x29B9,0xFF09,0x0001,0x2DD6,0x2C00,
	0xFF04,0x0000,0xFF06,0x0001,0xFF06,0x0001,0x2000,0xFF05,
	0x0001,0x200B,0xFF05,0x0002,0x259D,0xFF05,0x0002,0x29BA,
	0x2C00,0xFF05,0x0001,0x2DD7,0xFF06,0x0003,0xFF04,0x0002,
	0xFF09,0x0001,0x200C,0x2000,0xFF09,0x0002,0x259F,0xFF09,

	0x0002,0x29BC,0xFF09,0x0001,0x2DD8,0x2C00,0xFF04,0x0000,
	0xFF06,0x0001,0xFF06,0x0001,0x2000,0xFF05,0x0001,0x200D,
	0xFF05,0x0002,0x25A0,0xFF05,0x0002,0x29BD,0x2C00,0xFF05,
	0x0001,0x2DD9,0xFF06,0x0003,0xFF04,0x0002,0xFF09,0x0001,
	0x200E,0x2000,0xFF09,0x0002,0x25A2,0xFF09,0x0002,0x29BF,
	0xFF09,0x0001,0x2DDA,0x2C00,0xFF04,0x0000,0xFF06,0x0001,
	0xFF06,0x0001,0xFF05,0x0002,0x200F,0xFF05,0x0002,0x25A3,
	0xFF05,0x0002,0x29C0,0xFF05,0x0002,0x2DDB,0xFF06,0x0003,
	0xFF04,0x0002,0xFF09,0x0002,0x2011,0xFF09,0x0002,0x25A5,
	0xFF09,0x0002,0x29C2,0xFF09,0x0002,0x2DDD,0xFF04,0x0000,
	0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x0002,0x2012,0xFF05,
	0x0002,0x25A6,0xFF05,0x0002,0x29C3,0xFF05,0x0002,0x2DDE,
	0xFF06,0x0003,0xFF04,0x0002,0xFF09,0x0002,0x2014,0xFF09,
	0x0002,0x25A8,0xFF09,0x0002,0x29C5,0xFF09,0x0002,0x2DE0,
	0xFF04,0x0000,0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x0002,
	0x2015,0x25A9,0xFF0A,0x0001,0x2400,0xFF05,0x0002,0x29C6,

	0x2DE1,0xFF0A,0x0001,0x2C00,0xFF06,0x0003,0xFF04,0x0002,
	0xFF09,0x0002,0x2017,0xFF0A,0x0001,0x2400,0x25A9,0xFF09,
	0x0002,0x29C8,0xFF0A,0x0001,0x2C00,0x2DE1,0xFF04,0x0000,
	0xFF06,0x0001,0xFF06,0x0001,0x2018,0xFF0A,0x0001,0x2000,
	0x25AA,0xFF0A,0x0001,0x2400,0x29C9,0xFF0A,0x0001,0x2800,
	0x2DE2,0xFF0A,0x0001,0x2C00,0xFF06,0x0003,0xFF04,0x0002,
	0xFF0A,0x0001,0x2000,0x2018,0xFF0A,0x0001,0x2400,0x25AA,
	0xFF0A,0x0001,0x2800,0x29C9,0xFF0A,0x0001,0x2C00,0x2DE2,
	0xFF04,0x0000,0xFF06,0x0001,0xFF06,0x0001,0x2019,0xFF0A,
	0x0001,0x2000,0x25AB,0xFF0A,0x0001,0x2400,0x29CA,0xFF0A,
	0x0001,0x2800,0x2DE3,0xFF0A,0x0001,0x2C00,0xFF06,0x0003,
	0xFF04,0x0002,0xFF0A,0x0001,0x2000,0x2019,0xFF0A,0x0001,
	0x2400,0x25AB,0xFF0A,0x0001,0x2800,0x29CA,0xFF0A,0x0001,
	0x2C00,0x2DE3,0xFF04,0x0000,0xFF06,0x0001,0xFF06,0x001F,
	0xFF03,0x0400,0xFF06,0x000B,0xFF05,0x0001,0x3170,0xFF0A,
	0x0004,0x3172,0x3173,0xFF06,0x000B,0xFF06,0x000A,0xFF05,

	0x0009,0x3174,0xFF06,0x000A,0xFF06,0x000A,0xFF05,0x0009,
	0x317E,0xFF06,0x000A,0xFF06,0x003F,0xFF08,0xFF02,0x0003,
	0xFF03,0x0200,0xFF01,0x0C00,0xFF06,0x01BF,0xFF04,0x0002,
	0xFF09,0x000F,0x343F,0xFF04,0x0000,0xFF05,0x000F,0x3430,
	0xFF04,0x0002,0xFF09,0x000F,0x344F,0xFF04,0x0000,0xFF05,
	0x000F,0x3440,0xFF04,0x0002,0xFF09,0x000F,0x345F,0xFF04,
	0x0000,0xFF05,0x000F,0x3450,0xFF04,0x0002,0xFF0A,0x0001,
	0x3463,0x3471,0x3463,0xFF09,0x0002,0x346E,0xFF0A,0x0001,
	0x3463,0xFF09,0x0001,0x3469,0xFF0A,0x0001,0x3463,0xFF09,
	0x0002,0x3462,0xFF04,0x0000,0xFF05,0x0002,0x3460,0xFF0A,
	0x0001,0x3463,0xFF05,0x0001,0x3468,0xFF0A,0x0001,0x3463,
	0xFF05,0x0002,0x346C,0x3463,0x3471,0xFF0A,0x0001,0x3463,
	0xFF04,0x0002,0xFF0A,0x0001,0x3463,0x3472,0xFF0A,0x0002,
	0x3463,0x346F,0xFF0A,0x0002,0x3463,0x346A,0xFF0A,0x0001,
	0x3463,0xFF09,0x0001,0x3465,0xFF0A,0x0001,0x3463,0xFF04,
	0x0000,0xFF05,0x0001,0x3464,0xFF0A,0x0001,0x3463,0x346A,

	0xFF0A,0x0002,0x3463,0x346F,0xFF0A,0x0002,0x3463,0x3472,
	0xFF0A,0x0001,0x3463,0xFF04,0x0002,0xFF0A,0x0001,0x341D,
	0x3473,0xFF0A,0x0002,0x341D,0x3470,0xFF0A,0x0002,0x341D,
	0x346B,0xFF0A,0x0001,0x341D,0xFF09,0x0001,0x3467,0xFF0A,
	0x0001,0x341D,0xFF04,0x0000,0xFF05,0x0001,0x3466,0xFF0A,
	0x0001,0x341D,0x346B,0xFF0A,0x0002,0x341D,0x3470,0xFF0A,
	0x0002,0x341D,0x3473,0xFF0A,0x0001,0x341D,0xFF03,0x0300,
	0xFF05,0x000A,0x3474,0xFF06,0x0008,0xFF05,0x0004,0x34BB,
	0xFF04,0x0002,0xFF09,0x0006,0x347A,0xFF04,0x0000,0xFF05,
	0x000B,0x347F,0xFF06,0x0007,0xFF05,0x0004,0x34C0,0xFF04,
	0x0002,0xFF09,0x0006,0x3485,0xFF04,0x0000,0xFF05,0x000B,
	0x348B,0xFF06,0x0007,0xFF05,0x0004,0x34C5,0xFF04,0x0002,
	0xFF09,0x0006,0x3491,0xFF04,0x0000,0xFF05,0x000B,0x3497,
	0xFF06,0x0007,0xFF05,0x0004,0x34CA,0xFF04,0x0002,0xFF09,
	0x0006,0x349D,0xFF04,0x0000,0xFF05,0x000B,0x34A3,0xFF06,
	0x0006,0xFF05,0x0005,0x34CF,0xFF04,0x0002,0xFF09,0x0006,

	0x34A9,0xFF04,0x0000,0xFF05,0x000B,0x34AF,0xFF06,0x0006,
	0xFF05,0x0005,0x34D5,0xFF04,0x0002,0xFF09,0x0006,0x34B5,
	0xFF04,0x0000,0xFF0A,0x001F,0x301D,0xFF05,0x0003,0x30DB,
	0xFF05,0x0003,0x30DB,0xFF05,0x0003,0x30DB,0xFF05,0x0003,
	0x30DB,0xFF05,0x0003,0x30DB,0xFF05,0x0003,0x30DB,0xFF05,
	0x0003,0x30DB,0xFF05,0x0003,0x30DB,0xFF05,0x000F,0x3121,
	0xFF05,0x000F,0x30DF,0xFF05,0x000F,0x3131,0xFF05,0x000F,
	0x30EF,0xFF05,0x000F,0x3141,0xFF05,0x000F,0x3101,0xFF05,
	0x000F,0x3151,0xFF05,0x000F,0x3111,0xFF00,0xFF08,0xFF02
};
static UINT16 bloodwar_mcu_4_22[] = { // Warrior 1
	0xFF08,0xFF02,0x0000,0xFF03,0x0300,0xFF01,0x0B00,0xFF06,
	0x01BF,0xFF06,0x0001,0x3401,0xFF06,0x0000,0xFF05,0x0002,
	0x3402,0xFF06,0x0010,0xFF05,0x0001,0x3440,0xFF06,0x0001,
	0xFF05,0x0001,0x345C,0xFF06,0x0001,0xFF06,0x0001,0x3405,
	0xFF06,0x0000,0xFF05,0x0002,0x3406,0xFF06,0x0000,0xFF05,
	0x0001,0x4880,0xFF06,0x000C,0x4882,0xFF05,0x0001,0x3442,
	0xFF06,0x0001,0xFF05,0x0001,0x345E,0xFF06,0x0001,0xFF06,
	0x0001,0x3409,0xFF06,0x0000,0xFF05,0x0002,0x340A,0xFF06,
	0x0000,0xFF05,0x000F,0x4883,0xFF05,0x0001,0x3444,0xFF06,
	0x0001,0xFF05,0x0001,0x3460,0xFF06,0x0001,0xFF06,0x0001,
	0x340D,0xFF06,0x0000,0xFF05,0x0002,0x340E,0xFF06,0x0000,
	0xFF05,0x000F,0x4893,0xFF05,0x0001,0x3446,0xFF06,0x0001,
	0xFF05,0x0001,0x3462,0xFF06,0x0001,0xFF06,0x0001,0x3411,
	0xFF06,0x0000,0xFF05,0x0002,0x3412,0xFF06,0x0002,0xFF05,
	0x0001,0x40A3,0x44A5,0xFF06,0x0001,0xFF05,0x0001,0x44A6,
	0xFF06,0x0001,0xFF05,0x0002,0x44A8,0xFF06,0x0001,0xFF05,

	0x0001,0x3448,0xFF06,0x0001,0xFF05,0x0001,0x3464,0xFF06,
	0x0001,0xFF06,0x0001,0x3415,0xFF06,0x0000,0xFF05,0x0002,
	0x3416,0xFF06,0x0000,0xFF05,0x0003,0x40AB,0xFF05,0x0009,
	0x44AF,0xFF05,0x0001,0x40B9,0xFF05,0x0001,0x344A,0xFF06,
	0x0001,0xFF05,0x0001,0x3466,0xFF06,0x0001,0xFF06,0x0001,
	0x3419,0xFF06,0x0000,0xFF05,0x0002,0x341A,0xFF06,0x0003,
	0xFF05,0x0001,0x44BB,0xFF06,0x0005,0xFF05,0x0001,0x44D0,
	0xFF06,0x0002,0xFF05,0x0001,0x344C,0xFF06,0x0001,0xFF05,
	0x0001,0x3468,0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x0004,
	0x341D,0xFF06,0x0003,0xFF05,0x0001,0x44BD,0xFF06,0x0005,
	0xFF05,0x0001,0x44D2,0xFF06,0x0002,0xFF05,0x0001,0x344E,
	0xFF06,0x0001,0xFF05,0x0001,0x346A,0xFF06,0x0001,0xFF06,
	0x0001,0xFF05,0x0004,0x3422,0xFF06,0x0003,0xFF05,0x0001,
	0x44BF,0xFF06,0x0005,0xFF05,0x0001,0x44D4,0xFF06,0x0002,
	0xFF05,0x0001,0x3450,0xFF06,0x0001,0xFF05,0x0001,0x346C,
	0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x0004,0x3427,0xFF06,

	0x0002,0xFF05,0x0002,0x44C1,0xFF06,0x0005,0xFF05,0x0002,
	0x44D6,0xFF06,0x0001,0xFF05,0x0001,0x3452,0xFF05,0x0001,
	0x3875,0xFF05,0x0001,0x346E,0xFF06,0x0001,0xFF06,0x0001,
	0xFF05,0x0004,0x342C,0xFF06,0x0002,0xFF05,0x0002,0x44C4,
	0xFF06,0x0005,0xFF05,0x0002,0x44D9,0xFF06,0x0001,0xFF05,
	0x0001,0x3454,0xFF05,0x0001,0x3877,0xFF05,0x0001,0x3470,
	0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x0004,0x3431,0xFF06,
	0x0002,0xFF05,0x0002,0x44C7,0xFF06,0x0005,0xFF05,0x0002,
	0x44DC,0xFF06,0x0001,0xFF05,0x0001,0x3456,0xFF05,0x0002,
	0x3879,0x3472,0xFF06,0x0001,0xFF06,0x0001,0xFF05,0x0004,
	0x3436,0xFF06,0x0002,0xFF05,0x0002,0x44CA,0xFF06,0x0005,
	0xFF05,0x0002,0x44DF,0xFF06,0x0001,0xFF05,0x0001,0x3458,
	0xFF05,0x0001,0x387C,0xFF06,0x0000,0x3473,0xFF06,0x0001,
	0xFF06,0x0001,0xFF05,0x0004,0x343B,0xFF06,0x0002,0xFF05,
	0x0002,0x44CD,0xFF06,0x0005,0xFF05,0x0002,0x44E2,0xFF06,
	0x0001,0xFF05,0x0001,0x345A,0xFF05,0x0001,0x387E,0xFF06,

	0x0000,0x3474,0xFF06,0x0001,0xFF05,0x0007,0x3CE5,0xFF04,
	0x0002,0xFF09,0x0007,0x3D08,0xFF04,0x0000,0xFF05,0x000F,
	0x3D01,0xFF05,0x0006,0x3CED,0xFF04,0x0002,0xFF09,0x0008,
	0x3D19,0xFF04,0x0000,0xFF05,0x000F,0x3D11,0xFF05,0x0005,
	0x3CF4,0xFF04,0x0002,0xFF09,0x0009,0x3D2A,0xFF04,0x0000,
	0xFF05,0x000F,0x3D21,0xFF05,0x0004,0x3CFA,0xFF04,0x0002,
	0xFF09,0x000A,0x3D3B,0xFF04,0x0000,0xFF05,0x000F,0x3D31,
	0xFF08,0xFF02,0x0001,0xFF03,0x0400,0xFF01,0x0C00,0xFF06,
	0x01BF,0xFF06,0x003F,0xFF06,0x000D,0xFF05,0x0003,0x2850,
	0xFF06,0x000D,0xFF06,0x000D,0xFF05,0x0003,0x2854,0xFF06,
	0x000D,0xFF06,0x000D,0xFF05,0x0002,0x2858,0xFF06,0x000E,
	0xFF06,0x000D,0xFF05,0x0002,0x285B,0xFF06,0x000E,0xFF03,
	0x0300,0xFF06,0x0011,0xFF05,0x0003,0x307A,0xFF06,0x0009,
	0xFF06,0x000D,0xFF05,0x0007,0x307E,0xFF06,0x0009,0xFF06,
	0x0004,0xFF05,0x0001,0x305E,0xFF06,0x0006,0xFF05,0x000B,
	0x3086,0xFF06,0x0005,0xFF06,0x0004,0xFF05,0x0002,0x3060,

	0xFF06,0x0005,0xFF05,0x000B,0x3092,0xFF06,0x0005,0xFF06,
	0x0004,0xFF05,0x0004,0x3063,0xFF06,0x0002,0xFF05,0x000D,
	0x309E,0xFF06,0x0004,0xFF06,0x0004,0xFF05,0x0003,0x3068,
	0xFF06,0x0003,0xFF05,0x000C,0x30AB,0xFF06,0x0005,0xFF06,
	0x0004,0xFF05,0x0006,0x306C,0xFF05,0x000E,0x30B8,0xFF06,
	0x0004,0xFF06,0x0004,0xFF05,0x0006,0x3073,0xFF05,0x000E,
	0x30C7,0xFF06,0x0004,0xFF06,0x007F,0xFF08,0xFF02,0x0002,
	0xFF03,0x0200,0xFF01,0x0900,0xFF06,0x01BF,0xFF05,0x0006,
	0x2001,0xFF06,0x0000,0xFF05,0x0007,0x2008,0xFF05,0x0006,
	0x2001,0xFF06,0x0000,0xFF05,0x0007,0x2008,0xFF05,0x000F,
	0x2010,0xFF05,0x000F,0x2010,0xFF05,0x000F,0x2020,0xFF05,
	0x000F,0x2020,0xFF05,0x000F,0x2030,0xFF05,0x000F,0x2030,
	0xFF05,0x000F,0x2040,0xFF05,0x000F,0x2040,0xFF05,0x000F,
	0x2050,0xFF05,0x000F,0x2050,0xFF05,0x000F,0x2060,0xFF05,
	0x000F,0x2060,0xFF05,0x000F,0x2070,0xFF05,0x000F,0x2070,
	0xFF05,0x000F,0x2080,0xFF05,0x000F,0x2080,0xFF05,0x000D,

	0x2090,0xFF06,0x0000,0x209E,0xFF05,0x000D,0x2090,0xFF06,
	0x0000,0x209E,0x209F,0xFF06,0x0001,0xFF05,0x000A,0x20A0,
	0xFF06,0x0000,0x20AB,0x209F,0xFF06,0x0001,0xFF05,0x000A,
	0x20A0,0xFF06,0x0000,0x20AB,0x20AC,0xFF06,0x0001,0xFF05,
	0x000A,0x20AD,0xFF06,0x0000,0x20B8,0x20AC,0xFF06,0x0001,
	0xFF05,0x000A,0x20AD,0xFF06,0x0000,0x20B8,0x20B9,0xFF06,
	0x0001,0xFF05,0x000C,0x20BA,0x20B9,0xFF06,0x0001,0xFF05,
	0x000C,0x20BA,0xFF05,0x000F,0x20C7,0xFF05,0x000F,0x20C7,
	0xFF06,0x007F,0xFF08,0xFF02,0x0003,0xFF03,0x0200,0xFF01,
	0x0900,0xFF06,0x01BF,0xFF0A,0x0005,0x2501,0xFF05,0x0009,
	0x2501,0xFF05,0x0004,0x255B,0xFF0A,0x0004,0x2501,0xFF0A,
	0x0005,0x2501,0xFF05,0x0005,0x25A6,0xFF05,0x0009,0x250B,
	0xFF05,0x0005,0x2560,0xFF0A,0x0003,0x2501,0xFF05,0x0005,
	0x25A0,0xFF05,0x0005,0x25B2,0xFF05,0x0009,0x2515,0xFF05,
	0x0006,0x2566,0x2501,0xFF05,0x0001,0x256D,0xFF05,0x0005,
	0x25AC,0xFF05,0x0005,0x25BE,0xFF05,0x0009,0x251F,0xFF05,

	0x0009,0x256F,0xFF05,0x0005,0x25B8,0xFF05,0x0005,0x25CA,
	0xFF05,0x0009,0x2529,0xFF05,0x0009,0x2579,0xFF05,0x0005,
	0x25C4,0xFF05,0x0005,0x25D6,0xFF05,0x0009,0x2533,0xFF05,
	0x0009,0x2583,0xFF05,0x0005,0x25D0,0xFF05,0x0005,0x25E2,
	0xFF05,0x0009,0x253D,0xFF05,0x0009,0x258D,0xFF05,0x0005,
	0x25DC,0xFF05,0x0005,0x25EE,0xFF05,0x0009,0x2547,0xFF05,
	0x0002,0x2597,0xFF0A,0x0001,0x2501,0x259A,0xFF0A,0x0001,
	0x2501,0xFF05,0x0001,0x259B,0xFF05,0x0005,0x25E8,0xFF05,
	0x0005,0x25FA,0xFF05,0x0009,0x2551,0xFF0A,0x0009,0x2501,
	0xFF05,0x0005,0x25F4,0xFF03,0x0300,0xFF06,0x0006,0x2CE0,
	0xFF06,0x0002,0x2CE1,0xFF06,0x000A,0x2CE0,0xFF06,0x0002,
	0x2CE1,0xFF06,0x0003,0xFF06,0x0005,0xFF05,0x0006,0x2CE2,
	0xFF06,0x0008,0xFF05,0x0006,0x2CE2,0xFF06,0x0002,0xFF06,
	0x0005,0xFF05,0x0006,0x2CE9,0xFF06,0x0008,0xFF05,0x0006,
	0x2CE9,0xFF06,0x0002,0xFF06,0x0005,0xFF05,0x0006,0x2CF0,
	0xFF06,0x0008,0xFF05,0x0006,0x2CF0,0xFF06,0x0002,0xFF06,

	0x0005,0xFF05,0x0006,0x2CF7,0xFF06,0x0008,0xFF05,0x0006,
	0x2CF7,0xFF06,0x0002,0xFF06,0x007F,0xFF00,0xFF08,0xFF02
};
static UINT16 bloodwar_mcu_4_23[] = { // Warrior 9
	0xFF08,0xFF02,0x0000,0xFF03,0x0400,0xFF01,0x0A00,0xFF06,
	0x01BF,0xFF06,0x0006,0xFF05,0x0001,0x3C88,0xFF06,0x0005,
	0xFF05,0x0001,0x4001,0xFF06,0x0005,0xFF04,0x0002,0xFF09,
	0x0001,0x3C89,0xFF04,0x0000,0xFF06,0x0006,0xFF06,0x0006,
	0xFF05,0x0001,0x3C8A,0xFF06,0x0004,0xFF05,0x0002,0x4003,
	0xFF06,0x0005,0xFF04,0x0002,0xFF09,0x0001,0x3C8B,0xFF04,
	0x0000,0xFF06,0x0006,0xFF06,0x0001,0xFF05,0x0004,0x3032,
	0xFF05,0x0001,0x3C16,0xFF06,0x0004,0xFF05,0x0003,0x4006,
	0xFF06,0x0004,0xFF04,0x0002,0xFF09,0x0001,0x3C17,0xFF09,
	0x0004,0x3036,0xFF04,0x0000,0xFF06,0x0001,0xFF06,0x0000,
	0xFF05,0x0005,0x3037,0xFF05,0x0001,0x3C18,0xFF06,0x0004,
	0xFF05,0x0003,0x400A,0xFF06,0x0004,0xFF04,0x0002,0xFF09,
	0x0001,0x3C19,0xFF09,0x0005,0x303C,0xFF04,0x0000,0xFF06,
	0x0000,0xFF06,0x0000,0xFF05,0x0005,0x303D,0xFF05,0x0001,
	0x3C1A,0xFF06,0x0004,0xFF05,0x0003,0x400E,0xFF06,0x0004,
	0xFF04,0x0002,0xFF09,0x0001,0x3C1B,0xFF09,0x0005,0x3042,

	0xFF04,0x0000,0xFF06,0x0000,0xFF06,0x0000,0xFF05,0x0005,
	0x3043,0xFF05,0x0001,0x3C1C,0xFF06,0x0004,0xFF05,0x0003,
	0x4012,0xFF06,0x0004,0xFF04,0x0002,0xFF09,0x0001,0x3C1D,
	0xFF09,0x0005,0x3048,0xFF06,0x0000,0xFF04,0x0000,0xFF05,
	0x0006,0x3049,0xFF05,0x0001,0x3C1E,0xFF06,0x000D,0xFF04,
	0x0002,0xFF09,0x0001,0x3C1F,0xFF09,0x0006,0x304F,0xFF04,
	0x0000,0xFF05,0x0006,0x3050,0xFF05,0x0001,0x3C20,0xFF06,
	0x000D,0xFF04,0x0002,0xFF09,0x0001,0x3C21,0xFF09,0x0006,
	0x3056,0xFF04,0x0000,0xFF05,0x0006,0x3057,0xFF05,0x0001,
	0x3C22,0xFF06,0x000D,0xFF04,0x0002,0xFF09,0x0001,0x3C23,
	0xFF09,0x0006,0x305D,0xFF04,0x0000,0xFF05,0x0005,0x305E,
	0xFF06,0x0000,0xFF05,0x0001,0x3C24,0xFF06,0x000D,0xFF04,
	0x0002,0xFF09,0x0001,0x3C25,0xFF06,0x0000,0xFF09,0x0005,
	0x3063,0xFF04,0x0000,0xFF06,0x0000,0xFF05,0x0004,0x3064,
	0xFF06,0x0000,0xFF05,0x0001,0x3C26,0xFF06,0x000D,0xFF04,
	0x0002,0xFF09,0x0001,0x3C27,0xFF06,0x0000,0xFF09,0x0004,

	0x3068,0xFF04,0x0000,0xFF06,0x0000,0xFF06,0x0000,0xFF05,
	0x0004,0x3069,0xFF06,0x0000,0xFF05,0x0001,0x3C28,0xFF06,
	0x000D,0xFF04,0x0002,0xFF09,0x0001,0x3C29,0xFF06,0x0000,
	0xFF09,0x0004,0x306D,0xFF04,0x0000,0xFF06,0x0000,0xFF06,
	0x0000,0xFF05,0x0004,0x306E,0xFF06,0x0000,0xFF05,0x0001,
	0x3C2A,0xFF06,0x000D,0xFF04,0x0002,0xFF09,0x0001,0x3C2B,
	0xFF06,0x0000,0xFF09,0x0004,0x3072,0xFF04,0x0000,0xFF06,
	0x0000,0xFF06,0x0000,0xFF05,0x0004,0x3073,0xFF06,0x0000,
	0xFF05,0x0001,0x3C2C,0xFF06,0x000D,0xFF04,0x0002,0xFF09,
	0x0001,0x3C2D,0xFF06,0x0000,0xFF09,0x0004,0x3077,0xFF04,
	0x0000,0xFF06,0x0000,0xFF05,0x0005,0x3078,0xFF06,0x0000,
	0xFF05,0x0001,0x3C2E,0xFF06,0x000D,0xFF04,0x0002,0xFF09,
	0x0001,0x3C2F,0xFF06,0x0000,0xFF09,0x0005,0x307D,0xFF04,
	0x0000,0xFF05,0x0005,0x307E,0xFF06,0x0000,0xFF05,0x0001,
	0x3C30,0xFF06,0x000D,0xFF04,0x0002,0xFF09,0x0001,0x3C31,
	0xFF06,0x0000,0xFF09,0x0005,0x3083,0xFF04,0x0000,0xFF06,

	0x003F,0xFF08,0xFF02,0x0001,0xFF03,0x0200,0xFF01,0x0A00,
	0xFF06,0x01BF,0xFF06,0x0009,0xFF05,0x0001,0x3C8C,0xFF06,
	0x0007,0xFF04,0x0002,0xFF09,0x0001,0x3C8D,0xFF04,0x0000,
	0xFF06,0x0009,0xFF06,0x0001,0xFF05,0x0002,0x40A0,0xFF06,
	0x0004,0xFF05,0x0001,0x3C8E,0xFF06,0x0002,0xFF05,0x0001,
	0x4090,0xFF06,0x0002,0xFF04,0x0002,0xFF09,0x0001,0x3C8F,
	0xFF06,0x0004,0xFF09,0x0002,0x40A2,0xFF04,0x0000,0xFF06,
	0x0001,0xFF06,0x0001,0xFF05,0x0002,0x40A3,0xFF06,0x0000,
	0xFF05,0x0003,0x34C7,0xFF05,0x0001,0x3CAF,0xFF06,0x0001,
	0xFF05,0x0003,0x4092,0xFF06,0x0001,0xFF04,0x0002,0xFF09,
	0x0001,0x3CB0,0xFF09,0x0003,0x34CA,0xFF06,0x0000,0xFF09,
	0x0002,0x40A5,0xFF04,0x0000,0xFF06,0x0001,0xFF06,0x0001,
	0xFF05,0x0002,0x40A6,0xFF05,0x0004,0x34CB,0xFF05,0x0001,
	0x3CB1,0xFF06,0x0002,0xFF05,0x0001,0x4096,0xFF06,0x0002,
	0xFF04,0x0002,0xFF09,0x0001,0x3CB2,0xFF09,0x0004,0x34CF,
	0xFF09,0x0002,0x40A8,0xFF04,0x0000,0xFF06,0x0001,0xFF06,

	0x0001,0xFF05,0x0002,0x40A9,0xFF05,0x0004,0x34D0,0xFF05,
	0x0001,0x3CB3,0xFF06,0x0001,0xFF05,0x0003,0x4098,0xFF06,
	0x0001,0xFF04,0x0002,0xFF09,0x0001,0x3CB4,0xFF09,0x0004,
	0x34D4,0xFF09,0x0002,0x40AB,0xFF04,0x0000,0xFF06,0x0001,
	0xFF06,0x0001,0xFF05,0x0002,0x40AC,0xFF05,0x0004,0x34D5,
	0xFF05,0x0001,0x3CB5,0xFF06,0x0001,0xFF05,0x0003,0x409C,
	0xFF06,0x0001,0xFF04,0x0002,0xFF09,0x0001,0x3CB6,0xFF09,
	0x0004,0x34D9,0xFF09,0x0002,0x40AE,0xFF04,0x0000,0xFF06,
	0x0001,0xFF06,0x0004,0xFF05,0x0004,0x34DA,0xFF05,0x0001,
	0x3CB7,0xFF06,0x0007,0xFF04,0x0002,0xFF09,0x0001,0x3CB8,
	0xFF09,0x0004,0x34DE,0xFF04,0x0000,0xFF06,0x0004,0xFF06,
	0x0004,0xFF05,0x0004,0x34DF,0xFF05,0x0001,0x3CB9,0xFF06,
	0x0007,0xFF04,0x0002,0xFF09,0x0001,0x3CBA,0xFF09,0x0004,
	0x34E3,0xFF04,0x0000,0xFF06,0x0004,0xFF06,0x0004,0xFF05,
	0x0004,0x34E4,0xFF05,0x0001,0x3CBB,0xFF06,0x0007,0xFF04,
	0x0002,0xFF09,0x0001,0x3CBC,0xFF09,0x0004,0x34E8,0xFF04,

	0x0000,0xFF06,0x0004,0xFF06,0x0004,0xFF05,0x0004,0x34E9,
	0xFF05,0x0001,0x3CBD,0xFF06,0x0007,0xFF04,0x0002,0xFF09,
	0x0001,0x3CBE,0xFF09,0x0004,0x34ED,0xFF04,0x0000,0xFF06,
	0x0004,0xFF06,0x0004,0xFF05,0x0004,0x34EE,0xFF05,0x0001,
	0x3CBF,0xFF06,0x0007,0xFF04,0x0002,0xFF09,0x0001,0x3CC0,
	0xFF09,0x0004,0x34F2,0xFF04,0x0000,0xFF06,0x0004,0xFF06,
	0x0005,0xFF05,0x0002,0x34F3,0xFF06,0x0000,0xFF05,0x0001,
	0x3CC1,0xFF06,0x0007,0xFF04,0x0002,0xFF09,0x0001,0x3CC2,
	0xFF06,0x0000,0xFF09,0x0002,0x34F5,0xFF04,0x0000,0xFF06,
	0x0005,0xFF06,0x0004,0xFF05,0x0004,0x34F6,0xFF05,0x0001,
	0x3CC3,0xFF06,0x0007,0xFF04,0x0002,0xFF09,0x0001,0x3CC4,
	0xFF09,0x0004,0x34FA,0xFF04,0x0000,0xFF06,0x0004,0xFF06,
	0x0004,0xFF05,0x0004,0x34FB,0xFF05,0x0001,0x3CC5,0xFF06,
	0x0007,0xFF04,0x0002,0xFF09,0x0001,0x3CC6,0xFF09,0x0004,
	0x34FF,0xFF04,0x0000,0xFF06,0x0004,0xFF06,0x007F,0xFF08,
	0xFF02,0x0002,0xFF03,0x0200,0xFF01,0x0700,0xFF06,0x01BF,

	0xFF05,0x000F,0x3C01,0xFF04,0x0002,0xFF09,0x000F,0x3C10,
	0xFF04,0x0000,0xFF06,0x0003,0xFF05,0x000B,0x3C11,0xFF04,
	0x0002,0xFF09,0x000B,0x3C1C,0xFF04,0x0000,0xFF06,0x0003,
	0xFF06,0x0006,0xFF05,0x0001,0x401D,0xFF06,0x0000,0xFF05,
	0x0002,0x3835,0x3C23,0xFF06,0x0000,0xFF05,0x0001,0x401D,
	0xFF06,0x0000,0xFF04,0x0002,0x3C23,0xFF09,0x0002,0x3837,
	0xFF06,0x0000,0xFF09,0x0001,0x401E,0xFF04,0x0000,0xFF06,
	0x0006,0xFF06,0x0006,0xFF05,0x0001,0x401F,0xFF05,0x0003,
	0x3838,0x3C24,0xFF06,0x0000,0xFF05,0x0001,0x401F,0xFF06,
	0x0000,0xFF04,0x0002,0x3C24,0xFF09,0x0003,0x383B,0xFF09,
	0x0001,0x4020,0xFF04,0x0000,0xFF06,0x0006,0xFF06,0x0006,
	0xFF05,0x0001,0x4021,0xFF05,0x0003,0x383C,0x3C25,0xFF06,
	0x0000,0xFF05,0x0001,0x4021,0xFF06,0x0000,0xFF04,0x0002,
	0x3C25,0xFF09,0x0003,0x383F,0xFF09,0x0001,0x4022,0xFF04,
	0x0000,0xFF06,0x0006,0xFF06,0x0008,0xFF05,0x0003,0x3840,
	0x3C26,0xFF06,0x0003,0xFF04,0x0002,0x3C26,0xFF09,0x0003,

	0x3843,0xFF04,0x0000,0xFF06,0x0008,0xFF06,0x0008,0xFF05,
	0x0003,0x3844,0x3C27,0xFF06,0x0003,0xFF04,0x0002,0x3C27,
	0xFF09,0x0003,0x3847,0xFF04,0x0000,0xFF06,0x0008,0xFF06,
	0x0008,0xFF05,0x0003,0x3848,0x3C28,0xFF06,0x0003,0xFF04,
	0x0002,0x3C28,0xFF09,0x0003,0x384B,0xFF04,0x0000,0xFF06,
	0x0008,0xFF06,0x0008,0xFF05,0x0003,0x384C,0x3C29,0xFF06,
	0x0003,0xFF04,0x0002,0x3C29,0xFF09,0x0003,0x384F,0xFF04,
	0x0000,0xFF06,0x0008,0xFF06,0x0008,0xFF05,0x0003,0x3850,
	0x3C2A,0xFF06,0x0003,0xFF04,0x0002,0x3C2A,0xFF09,0x0003,
	0x3853,0xFF04,0x0000,0xFF06,0x0008,0xFF06,0x0008,0xFF05,
	0x0003,0x3854,0x3C2B,0xFF05,0x0003,0x442D,0xFF04,0x0002,
	0x3C2B,0xFF09,0x0003,0x3857,0xFF04,0x0000,0xFF06,0x0008,
	0xFF06,0x0008,0xFF05,0x0003,0x3858,0x3C2C,0xFF05,0x0003,
	0x4431,0xFF04,0x0002,0x3C2C,0xFF09,0x0003,0x385B,0xFF04,
	0x0000,0xFF06,0x0008,0xFF06,0x0003,0xFF05,0x0017,0x485C,
	0xFF06,0x0003,0xFF05,0x001F,0x4874,0xFF05,0x001F,0x4894,

	0xFF05,0x001F,0x48B4,0xFF05,0x001F,0x48D4,0xFF05,0x000B,
	0x48F4,0xFF05,0x0013,0x4901,0xFF08,0xFF02,0x0003,0xFF03,
	0x0200,0xFF01,0x0800,0xFF06,0x01BF,0xFF05,0x0007,0x2820,
	0xFF05,0x0007,0x2820,0xFF05,0x0007,0x2820,0xFF05,0x0007,
	0x2820,0xFF05,0x0007,0x2828,0xFF05,0x0007,0x2828,0xFF05,
	0x0007,0x2828,0xFF05,0x0007,0x2828,0xFF05,0x0007,0x2830,
	0xFF05,0x0007,0x2830,0xFF05,0x0007,0x2830,0xFF05,0x0007,
	0x2830,0xFF05,0x0007,0x2438,0xFF05,0x0007,0x2438,0xFF05,
	0x0007,0x2438,0xFF05,0x0007,0x2438,0xFF05,0x0007,0x2040,
	0xFF05,0x0007,0x2040,0xFF05,0x0007,0x2040,0xFF05,0x0007,
	0x2040,0xFF05,0x0007,0x2048,0xFF05,0x0007,0x2048,0xFF05,
	0x0007,0x2048,0xFF05,0x0007,0x2048,0xFF0A,0x001F,0x2C50,
	0xFF05,0x0007,0x2051,0xFF05,0x0007,0x2051,0xFF05,0x0007,
	0x2051,0xFF05,0x0007,0x2051,0xFF05,0x0007,0x2059,0xFF05,
	0x0007,0x2059,0xFF05,0x0007,0x2059,0xFF05,0x0007,0x2059,
	0xFF05,0x0007,0x2461,0xFF05,0x0007,0x2461,0xFF05,0x0007,

	0x2461,0xFF05,0x0007,0x2461,0xFF05,0x0007,0x2869,0xFF05,
	0x0007,0x2869,0xFF05,0x0007,0x2869,0xFF05,0x0007,0x2869,
	0xFF05,0x0007,0x2871,0xFF05,0x0007,0x2871,0xFF05,0x0007,
	0x2871,0xFF05,0x0007,0x2871,0xFF05,0x0007,0x2879,0xFF05,
	0x0007,0x2879,0xFF05,0x0007,0x2879,0xFF05,0x0007,0x2879,
	0xFF05,0x0007,0x2881,0xFF05,0x0007,0x2881,0xFF05,0x0007,
	0x2881,0xFF05,0x0007,0x2881,0xFF06,0x007F,0xFF00,0xFF08
};
static UINT16 bloodwar_mcu_4_24[] = { // Warrior 7
	0xFF08,0xFF02,0x0000,0xFF03,0x0400,0xFF01,0x0300,0xFF06,
	0x01BF,0xFF06,0x0000,0x3402,0xFF05,0x0005,0x4C14,0x3402,
	0xFF05,0x0006,0x4C14,0xFF05,0x0006,0x4C14,0xFF04,0x0002,
	0x3402,0xFF04,0x0000,0xFF05,0x0005,0x4C14,0xFF04,0x0002,
	0x3402,0xFF04,0x0000,0xFF06,0x0000,0xFF06,0x0000,0x3403,
	0xFF05,0x0005,0x4C1B,0x3403,0xFF05,0x0002,0x4C1B,0xFF05,
	0x0007,0x4B32,0xFF05,0x0002,0x4C1F,0xFF04,0x0002,0x3403,
	0xFF04,0x0000,0xFF05,0x0005,0x4C1B,0xFF04,0x0002,0x3403,
	0xFF04,0x0000,0xFF06,0x0000,0xFF06,0x0000,0x3404,0xFF05,
	0x0005,0x4C22,0x3404,0xFF05,0x0002,0x4C22,0xFF05,0x0007,
	0x4B3A,0xFF05,0x0002,0x4C26,0xFF04,0x0002,0x3404,0xFF04,
	0x0000,0xFF05,0x0005,0x4C22,0xFF04,0x0002,0x3404,0xFF04,
	0x0000,0xFF06,0x0000,0xFF05,0x0007,0x340C,0xFF05,0x0007,
	0x340C,0xFF05,0x0007,0x340C,0xFF05,0x0007,0x340C,0xFF06,
	0x0000,0x3401,0xFF05,0x0006,0x2029,0xFF05,0x000D,0x207E,
	0xFF05,0x0006,0x2029,0xFF04,0x0002,0x3401,0xFF04,0x0000,

	0xFF06,0x0000,0xFF06,0x0000,0x3402,0xFF05,0x0006,0x2030,
	0xFF05,0x000D,0x208C,0xFF05,0x0006,0x2030,0xFF04,0x0002,
	0x3402,0xFF04,0x0000,0xFF06,0x0000,0xFF06,0x0000,0x3403,
	0xFF05,0x0006,0x2037,0xFF05,0x000D,0x209A,0xFF05,0x0006,
	0x2037,0xFF04,0x0002,0x3403,0xFF04,0x0000,0xFF06,0x0000,
	0xFF06,0x0000,0x3404,0xFF05,0x0006,0x203E,0xFF05,0x000D,
	0x20A8,0xFF05,0x0006,0x203E,0xFF04,0x0002,0x3404,0xFF04,
	0x0000,0xFF06,0x0000,0xFF06,0x0000,0x3405,0xFF05,0x0006,
	0x2045,0xFF05,0x000D,0x20B6,0xFF05,0x0006,0x2045,0xFF04,
	0x0002,0x3405,0xFF04,0x0000,0xFF06,0x0000,0xFF06,0x0000,
	0x3406,0xFF05,0x0001,0x2076,0xFF05,0x0004,0x204E,0xFF05,
	0x000D,0x20C4,0xFF05,0x0004,0x204C,0xFF05,0x0001,0x207A,
	0xFF04,0x0002,0x3406,0xFF04,0x0000,0xFF06,0x0000,0xFF06,
	0x0000,0x3407,0xFF05,0x0001,0x2078,0xFF05,0x0004,0x2055,
	0xFF05,0x000D,0x20D2,0xFF05,0x0004,0x2053,0xFF05,0x0001,
	0x207C,0xFF04,0x0002,0x3407,0xFF04,0x0000,0xFF06,0x0000,

	0xFF06,0x0000,0x3408,0xFF05,0x0006,0x205A,0xFF05,0x000D,
	0x20E0,0xFF05,0x0006,0x205A,0xFF04,0x0002,0x3408,0xFF04,
	0x0000,0xFF06,0x0000,0xFF06,0x0000,0x3409,0xFF05,0x0006,
	0x2061,0xFF05,0x000D,0x20EE,0xFF05,0x0006,0x2061,0xFF04,
	0x0002,0x3409,0xFF04,0x0000,0xFF06,0x0000,0xFF06,0x0000,
	0x340A,0xFF05,0x0006,0x2068,0xFF05,0x000D,0x2101,0xFF05,
	0x0006,0x2068,0xFF04,0x0002,0x340A,0xFF04,0x0000,0xFF06,
	0x0000,0xFF06,0x0000,0x340B,0xFF05,0x0006,0x206F,0xFF05,
	0x000D,0x210F,0xFF05,0x0006,0x206F,0xFF04,0x0002,0x340B,
	0xFF04,0x0000,0xFF06,0x0000,0xFF06,0x005F,0xFF08,0xFF02,
	0x0001,0xFF03,0x0200,0xFF01,0x0600,0xFF06,0x01BF,0xFF06,
	0x007F,0xFF05,0x001F,0x34D0,0xFF06,0x0003,0x34F0,0xFF05,
	0x0004,0x2507,0xFF05,0x000B,0x2501,0xFF05,0x0004,0x2502,
	0xFF04,0x0002,0x34F0,0xFF04,0x0000,0xFF06,0x0003,0xFF06,
	0x0003,0x34F1,0xFF05,0x0004,0x2513,0xFF05,0x000B,0x250D,
	0xFF05,0x0004,0x250E,0xFF04,0x0002,0x34F1,0xFF04,0x0000,

	0xFF06,0x0003,0xFF06,0x0003,0x34F2,0xFF05,0x0004,0x251F,
	0xFF05,0x000B,0x2519,0xFF05,0x0004,0x251A,0xFF04,0x0002,
	0x34F2,0xFF04,0x0000,0xFF06,0x0003,0xFF06,0x0003,0x34F3,
	0xFF05,0x0004,0x252B,0xFF05,0x000B,0x2525,0xFF05,0x0004,
	0x2526,0xFF04,0x0002,0x34F3,0xFF04,0x0000,0xFF06,0x0003,
	0xFF06,0x0003,0x34F4,0xFF05,0x0004,0x2537,0xFF05,0x000B,
	0x2531,0xFF05,0x0004,0x2532,0xFF04,0x0002,0x34F4,0xFF04,
	0x0000,0xFF06,0x0003,0xFF06,0x0003,0x34F5,0xFF05,0x0004,
	0x2543,0xFF05,0x000B,0x253D,0xFF05,0x0004,0x253E,0xFF04,
	0x0002,0x34F5,0xFF04,0x0000,0xFF06,0x0003,0xFF06,0x0003,
	0x34F6,0xFF05,0x0004,0x254F,0xFF05,0x000B,0x2549,0xFF05,
	0x0004,0x254A,0xFF04,0x0002,0x34F6,0xFF04,0x0000,0xFF06,
	0x0003,0xFF06,0x0003,0x34F7,0xFF05,0x0004,0x255B,0xFF05,
	0x000B,0x2555,0xFF05,0x0004,0x2556,0xFF04,0x0002,0x34F7,
	0xFF04,0x0000,0xFF06,0x0003,0xFF06,0x0003,0x34F8,0xFF05,
	0x0004,0x2567,0xFF05,0x000B,0x2561,0xFF05,0x0004,0x2562,

	0xFF04,0x0002,0x34F8,0xFF04,0x0000,0xFF06,0x0003,0xFF06,
	0x007F,0xFF08,0xFF02,0x0002,0xFF03,0x0200,0xFF01,0x0200,
	0xFF06,0x01BF,0xFF06,0x009F,0xFF05,0x001F,0x3408,0xFF06,
	0x0002,0xFF05,0x0003,0x2830,0x3401,0xFF05,0x0003,0x2830,
	0xFF05,0x0007,0x2C28,0xFF05,0x0003,0x2830,0xFF04,0x0002,
	0x3401,0xFF04,0x0000,0xFF05,0x0003,0x2830,0xFF06,0x0002,
	0xFF06,0x0002,0xFF05,0x0003,0x283C,0x3402,0xFF05,0x0003,
	0x283C,0xFF05,0x0007,0x2C34,0xFF05,0x0003,0x283C,0xFF04,
	0x0002,0x3402,0xFF04,0x0000,0xFF05,0x0003,0x283C,0xFF06,
	0x0002,0xFF06,0x0002,0xFF05,0x0003,0x2848,0x3403,0xFF05,
	0x0003,0x2848,0xFF05,0x0007,0x2C40,0xFF05,0x0003,0x2848,
	0xFF04,0x0002,0x3403,0xFF04,0x0000,0xFF05,0x0003,0x2848,
	0xFF06,0x0002,0xFF06,0x0002,0xFF05,0x0003,0x2854,0x3404,
	0xFF05,0x0003,0x2854,0xFF05,0x0007,0x2C4C,0xFF05,0x0003,
	0x2854,0xFF04,0x0002,0x3404,0xFF04,0x0000,0xFF05,0x0003,
	0x2854,0xFF06,0x0002,0xFF06,0x0002,0xFF05,0x0003,0x2860,

	0x3405,0xFF05,0x0003,0x2860,0xFF05,0x0007,0x2C58,0xFF05,
	0x0003,0x2860,0xFF04,0x0002,0x3405,0xFF04,0x0000,0xFF05,
	0x0003,0x2860,0xFF06,0x0002,0xFF06,0x0002,0xFF05,0x0003,
	0x286C,0x3406,0xFF05,0x0003,0x286C,0xFF05,0x0007,0x2C64,
	0xFF05,0x0003,0x286C,0xFF04,0x0002,0x3406,0xFF04,0x0000,
	0xFF05,0x0003,0x286C,0xFF06,0x0002,0xFF06,0x0002,0xFF05,
	0x0003,0x2878,0x3407,0xFF05,0x0003,0x2878,0xFF05,0x0007,
	0x2C70,0xFF05,0x0003,0x2878,0xFF04,0x0002,0x3407,0xFF04,
	0x0000,0xFF05,0x0003,0x2878,0xFF06,0x0002,0xFF06,0x009F,
	0xFF08,0xFF02,0x0003,0xFF03,0x0200,0xFF01,0x0200,0xFF06,
	0x01BF,0xFF06,0x00BF,0xFF06,0x0005,0xFF05,0x0004,0x3480,
	0xFF05,0x0004,0x3480,0xFF05,0x0004,0x3480,0xFF05,0x0004,
	0x3480,0xFF06,0x0005,0xFF06,0x0005,0xFF05,0x0013,0x3085,
	0xFF06,0x0005,0xFF06,0x0005,0xFF05,0x0013,0x3099,0xFF06,
	0x0005,0xFF06,0x0005,0xFF05,0x0013,0x30AD,0xFF06,0x0005,
	0xFF06,0x0005,0xFF05,0x0013,0x30C1,0xFF06,0x0005,0xFF06,

	0x0005,0xFF05,0x0013,0x30D5,0xFF06,0x0005,0xFF05,0x000F,
	0x44E9,0xFF04,0x0002,0xFF09,0x000F,0x44F8,0xFF04,0x0000,
	0xFF05,0x000F,0x4101,0xFF04,0x0002,0xFF09,0x000F,0x4110,
	0xFF04,0x0000,0xFF05,0x000F,0x3D11,0xFF04,0x0002,0xFF09,
	0x000F,0x3D20,0xFF04,0x0000,0xFF05,0x000F,0x3921,0xFF04,
	0x0002,0xFF09,0x000F,0x3930,0xFF04,0x0000,0xFF05,0x000F,
	0x3931,0xFF04,0x0002,0xFF09,0x000F,0x3940,0xFF04,0x0000,
	0xFF05,0x000F,0x3941,0xFF04,0x0002,0xFF09,0x000F,0x3950,
	0xFF04,0x0000,0xFF00,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF
};

// --- fighter data: pointers to ROM ---
static UINT16 bloodwar_mcu_4_25[] = { // Warrior 1
	0x0007,0x2B72,0x0007,0x2B9E,0x0007,0x2C52,0x0007,0x2D36,
	0x0007,0x3584,0x0007,0x2E3A,0x0007,0x2E54,0x0007,0x2E74,
	0x0007,0x2F28,0x0007,0x3022,0x0007,0x35A0,0x0007,0x377C,
	0x0007,0x378E,0x0007,0x37C0,0x0007,0x37F2,0x0007,0x385C,
	0x0007,0x386E,0x0007,0x38A0,0x0007,0x38D2,0x0007,0x3824,
	0x0007,0x3832,0x0007,0x3840,0x0007,0x384E,0x0007,0x3904,
	0x0007,0x3912,0x0007,0x3920,0x0007,0x392E,0x0007,0x30F6,
	0x0007,0x3110,0x0007,0x3142,0x0007,0x31BA,0x0007,0x3232,
	0x0007,0x32AC,0x0007,0x32DE,0x0007,0x3356,0x0007,0x33CE,
	0x0007,0x35BC,0x0007,0x35CE,0x0007,0x3600,0x0007,0x3632,
	0x0007,0x369C,0x0007,0x36AE,0x0007,0x36E0,0x0007,0x3712,
	0x0007,0x3664,0x0007,0x3672,0x0007,0x3680,0x0007,0x368E,
	0x0007,0x3744,0x0007,0x3752,0x0007,0x3760,0x0007,0x376E,
	0x0007,0x3446,0x0007,0x34A4,0x0007,0x3514,0x0007,0x345A,
	0x0007,0x34B8,0x0007,0x3528,0x0007,0x3490,0x0007,0x3500,
	0x0007,0x3570,0x0007,0x3A18,0x0007,0x3A48,0x0007,0x3A9C,

	0x0007,0x3AF0,0x0007,0x3B44,0x0007,0x3BB0,0x0007,0x3C64,
	0x0007,0x3D18,0x0007,0x3DCC,0x0007,0x3E20,0x0007,0x3E98,
	0x0007,0x3F10,0x0007,0x3F88,0x0007,0x3FD6,0x0007,0x4072,
	0x0007,0x410E,0x0007,0x5180,0x0007,0x51BC,0x0007,0x521C,
	0x0007,0x527C,0x0007,0x52DC,0x0007,0x5330,0x0007,0x53D2,
	0x0007,0x5474,0x0007,0x5516,0x0007,0x5570,0x0007,0x55EE,
	0x0007,0x566C,0x0007,0x56EA,0x0007,0x5768,0x0007,0x580A,
	0x0007,0x58AC,0x0007,0x41AA,0x0007,0x41DA,0x0007,0x422E,
	0x0007,0x4282,0x0007,0x42D6,0x0007,0x4336,0x0007,0x43EE,
	0x0007,0x44A6,0x0007,0x455E,0x0007,0x45BE,0x0007,0x4642,
	0x0007,0x46C6,0x0007,0x474A,0x0007,0x47A4,0x0007,0x4866,
	0x0007,0x4928,0x0007,0x594E,0x0007,0x597E,0x0007,0x59D2,
	0x0007,0x5A26,0x0007,0x5A7A,0x0007,0x5ADA,0x0007,0x5B6E,
	0x0007,0x5C02,0x0007,0x5C96,0x0007,0x5CF0,0x0007,0x5D78,
	0x0007,0x5E00,0x0007,0x5E88,0x0007,0x5EE0,0x0007,0x5F50,
	0x0007,0x5FC0,0x0007,0x49EA,0x0007,0x4A1E,0x0007,0x4AB6,

	0x0007,0x4B4E,0x0007,0x4BE6,0x0007,0x4C32,0x0007,0x4CA2,
	0x0007,0x4D12,0x0007,0x6030,0x0007,0x6070,0x0007,0x611E,
	0x0007,0x61CC,0x0007,0x627A,0x0007,0x62BA,0x0007,0x631E,
	0x0007,0x6382,0x0007,0x4D82,0x0007,0x4DDA,0x0007,0x4E96,
	0x0007,0x4F52,0x0007,0x500E,0x0007,0x5048,0x0007,0x50B0,
	0x0007,0x5118,0x0007,0x63E6,0x0007,0x6426,0x0007,0x64CA,
	0x0007,0x656E,0x0007,0x6612,0x0007,0x6652,0x0007,0x66B6,
	0x0007,0x671A,0x0007,0x393C,0x0007,0x3992,0x0007,0x39EE,
	0x0007,0x6FA2,0x0007,0x6FAE,0x0007,0x6FCC,0x0007,0x6FF6,
	0x0007,0x7002,0x0007,0x7020,0x0007,0x704A,0x0007,0x7056,
	0x0007,0x7074,0x0007,0x7118,0x0007,0x712E,0x0007,0x709E,
	0x0007,0x70A6,0x0007,0x713A,0x0007,0x73C6,0x0007,0x7262,
	0x0007,0x72D6,0x0007,0x733C,0x0007,0x7384,0x0007,0x7476,
	0x0007,0x7548,0x0007,0x7906,0x0007,0x7712,0x0007,0x7AD0,
	0x0007,0x7852,0x0007,0x7C32,0x0007,0x7D0A,0x0007,0x7DFC,
	0x0007,0x7EEE,0x0007,0x7FE0,0x0007,0x8158,0x0007,0x824A,

	0x0007,0x833C,0x0007,0x842E,0x0007,0x8F92,0x0007,0x8FB2,
	0x0007,0x8FEE,0x0007,0x902A,0x0007,0x9038,0x0007,0x9066,
	0x0007,0x90C6,0x0007,0x9102,0x0007,0x9108,0x0007,0x9136,
	0x0007,0x9172,0x0007,0x9180,0x0007,0x919E,0x0007,0x91AC,
	0x0007,0x91CA,0x0007,0x9206,0x0007,0x9262,0x0007,0x929C,
	0x0007,0x92AA,0x0007,0x92D0,0x0007,0x930C,0x0007,0x9322,
	0x0007,0x9340,0x0007,0x937C,0x0007,0x93CE,0x0007,0x93E4,
	0x0007,0x9402,0x0007,0x945C,0x0007,0x9462,0x0007,0x9480,
	0x0007,0x94CC,0x0007,0x94EA,0x0007,0x9510,0x0007,0x954C,
	0x0007,0x9552,0x0007,0x677E,0x0007,0x677E,0x0007,0x677E,
	0x0007,0x677E,0x0007,0x67CC,0x0007,0x67CC,0x0007,0x67CC,
	0x0007,0x67CC,0x0007,0x6820,0x0007,0x68A6,0x0007,0x697E,
	0x0007,0x6AA6,0x0007,0x6C1E,0x0007,0x6CBE,0x0007,0x6DAE,
	0x0007,0x6E9E,0x0007,0x6C66,0x0007,0x6D24,0x0007,0x6E14,
	0x0007,0x6F04,0x0007,0x6F8E,0x0007,0x85A6,0x0007,0x85BA,
	0x0007,0x85CE,0x0007,0x862A,0x0007,0x8644,0x0007,0x8658,

	0x0007,0x862A,0x0007,0x8644,0x0007,0x869C,0x0007,0x86A6,
	0x0007,0xCC3C,0x0007,0xCC68,0x0007,0xCD1C,0x0007,0xCD9A
};
static UINT16 bloodwar_mcu_4_26[] = { // Warrior 2
	0x000B,0xB188,0x000B,0xB1C0,0x000B,0xB308,0x000B,0xB590,
	0x000B,0xCF38,0x000B,0xBA00,0x000B,0xBA1A,0x000B,0xBA3A,
	0x000B,0xBE62,0x000B,0xC4AA,0x000B,0xCF54,0x000B,0xD130,
	0x000B,0xD142,0x000B,0xD174,0x000B,0xD1A6,0x000B,0xD210,
	0x000B,0xD222,0x000B,0xD254,0x000B,0xD286,0x000B,0xD1D8,
	0x000B,0xD1E6,0x000B,0xD1F4,0x000B,0xD202,0x000B,0xD2B8,
	0x000B,0xD2C6,0x000B,0xD2D4,0x000B,0xD2E2,0x000B,0xC662,
	0x000B,0xC67C,0x000B,0xC6B4,0x000B,0xC7BC,0x000B,0xC8C4,
	0x000B,0xC9B8,0x000B,0xC9E4,0x000B,0xCB58,0x000B,0xCCCC,
	0x000B,0xCF70,0x000B,0xCF82,0x000B,0xCFB4,0x000B,0xCFE6,
	0x000B,0xD050,0x000B,0xD062,0x000B,0xD094,0x000B,0xD0C6,
	0x000B,0xD018,0x000B,0xD026,0x000B,0xD034,0x000B,0xD042,
	0x000B,0xD0F8,0x000B,0xD106,0x000B,0xD114,0x000B,0xD122,
	0x000B,0xCE18,0x000B,0xCE58,0x000B,0xCECE,0x000B,0xCE2C,
	0x000B,0xCE6C,0x000B,0xCEE2,0x000B,0xCE44,0x000B,0xCEC0,
	0x000B,0xCF2A,0x000B,0xD52A,0x000B,0xD566,0x000B,0xD5C6,

	0x000B,0xD626,0x000B,0xD686,0x000B,0xD6D4,0x000B,0xD780,
	0x000B,0xD82C,0x000B,0xD8D8,0x000B,0xD920,0x000B,0xD99C,
	0x000B,0xDA18,0x000B,0xDA94,0x000B,0xDAEE,0x000B,0xDB86,
	0x000B,0xDC1E,0x000B,0xED72,0x000B,0xED9C,0x000B,0xEDFA,
	0x000B,0xEE58,0x000B,0xEEB6,0x000B,0xEEF8,0x000B,0xEFB8,
	0x000B,0xF078,0x000B,0xF138,0x000B,0xF186,0x000B,0xF208,
	0x000B,0xF28A,0x000B,0xF30C,0x000B,0xF366,0x000B,0xF3FE,
	0x000B,0xF496,0x000B,0xDCB6,0x000B,0xDCEC,0x000B,0xDD56,
	0x000B,0xDDC0,0x000B,0xDE2A,0x000B,0xDE6C,0x000B,0xDF2C,
	0x000B,0xDFEC,0x000B,0xE0AC,0x000B,0xE10C,0x000B,0xE1A0,
	0x000B,0xE234,0x000B,0xE2C8,0x000B,0xE332,0x000B,0xE3B4,
	0x000B,0xE436,0x000B,0xF52E,0x000B,0xF55E,0x000B,0xF5C2,
	0x000B,0xF626,0x000B,0xF68A,0x000B,0xF6CC,0x000B,0xF77C,
	0x000B,0xF82C,0x000B,0xF8DC,0x000B,0xF93A,0x000B,0xF9B0,
	0x000B,0xFA26,0x000B,0xFA9C,0x000B,0xFAF6,0x000B,0xFB8E,
	0x000B,0xFC26,0x000B,0xE4B8,0x000B,0xE4F8,0x000B,0xE59C,

	0x000B,0xE640,0x000B,0xE6E4,0x000B,0xE72A,0x000B,0xE794,
	0x000B,0xE7FE,0x000B,0xFCBE,0x000B,0xFCF2,0x000B,0xFD8A,
	0x000B,0xFE22,0x000B,0xFEBA,0x000B,0xFEEE,0x000B,0xFF46,
	0x000B,0xFF9E,0x000B,0xE868,0x000B,0xE8EE,0x000B,0xE9CE,
	0x000B,0xEAAE,0x000B,0xEB8E,0x000B,0xEBEC,0x000B,0xEC6E,
	0x000B,0xECF0,0x000B,0xFFF6,0x000C,0x008E,0x000C,0x0178,
	0x000C,0x0262,0x000C,0x034C,0x000C,0x038C,0x000C,0x03F0,
	0x000C,0x0454,0x000B,0xD2F0,0x000B,0xD450,0x000B,0xD4E2,
	0x000C,0x0946,0x000C,0x0952,0x000C,0x0970,0x000C,0x099A,
	0x000C,0x09A6,0x000C,0x09C4,0x000C,0x09EE,0x000C,0x09FA,
	0x000C,0x0A18,0x000C,0x0ABC,0x000C,0x0AD2,0x000C,0x0A42,
	0x000C,0x0A4A,0x000C,0x0ADE,0x000C,0x0D6A,0x000C,0x0C06,
	0x000C,0x0C7A,0x000C,0x0CE0,0x000C,0x0D28,0x000C,0x0E1A,
	0x000C,0x0EEC,0x000C,0x12AA,0x000C,0x10B6,0x000C,0x1474,
	0x000C,0x11F6,0x000C,0x15D6,0x000C,0x16AE,0x000C,0x17A0,
	0x000C,0x1892,0x000C,0x1984,0x000C,0x1AFC,0x000C,0x1BEE,

	0x000C,0x1CE0,0x000C,0x1DD2,0x000C,0x246A,0x000C,0x248A,
	0x000C,0x24C6,0x000C,0x2502,0x000C,0x2510,0x000C,0x253E,
	0x000C,0x259E,0x000C,0x25DA,0x000C,0x25E0,0x000C,0x260E,
	0x000C,0x264A,0x000C,0x2658,0x000C,0x2676,0x000C,0x2684,
	0x000C,0x26A2,0x000C,0x26DE,0x000C,0x273A,0x000C,0x2774,
	0x000C,0x2782,0x000C,0x27A8,0x000C,0x27E4,0x000C,0x27FA,
	0x000C,0x2818,0x000C,0x2854,0x000C,0x28A6,0x000C,0x28BC,
	0x000C,0x28DA,0x000C,0x2934,0x000C,0x293A,0x000C,0x2958,
	0x000C,0x29A4,0x000C,0x29C2,0x000C,0x29E8,0x000C,0x2A24,
	0x000C,0x2A2A,0x000C,0x04B8,0x000C,0x0506,0x000C,0x050E,
	0x000C,0x0516,0x000C,0x051E,0x000C,0x0620,0x000C,0x0634,
	0x000C,0x0736,0x000C,0x074A,0x000C,0x0834,0x000C,0x0848,
	0x000C,0x0932,0x000C,0x1F4A,0x000C,0x1F5E,0x000C,0x1F78,
	0x000C,0x1F4A,0x000C,0x1F5E,0x000C,0x1FC2,0x000C,0x1FCC,
	0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF,0xFFFF
};
static UINT16 bloodwar_mcu_4_27[] = { // Warrior 3
	0x0008,0x631C,0x0008,0x6348,0x0008,0x63EC,0x0008,0x6494,
	0x0008,0x6C5C,0x0008,0x6598,0x0008,0x65B2,0x0008,0x65D2,
	0x0008,0x6676,0x0008,0x674A,0x0008,0x6C78,0x0008,0x6E54,
	0x0008,0x6E66,0x0008,0x6E98,0x0008,0x6ECA,0x0008,0x6F34,
	0x0008,0x6F46,0x0008,0x6F78,0x0008,0x6FAA,0x0008,0x6EFC,
	0x0008,0x6F0A,0x0008,0x6F18,0x0008,0x6F26,0x0008,0x6FDC,
	0x0008,0x6FEA,0x0008,0x6FF8,0x0008,0x7006,0x0008,0x681E,
	0x0008,0x6838,0x0008,0x6864,0x0008,0x68CC,0x0008,0x6934,
	0x0008,0x699C,0x0008,0x69C8,0x0008,0x6A30,0x0008,0x6A98,
	0x0008,0x6C94,0x0008,0x6CA6,0x0008,0x6CD8,0x0008,0x6D0A,
	0x0008,0x6D74,0x0008,0x6D86,0x0008,0x6DB8,0x0008,0x6DEA,
	0x0008,0x6D3C,0x0008,0x6D4A,0x0008,0x6D58,0x0008,0x6D66,
	0x0008,0x6E1C,0x0008,0x6E2A,0x0008,0x6E38,0x0008,0x6E46,
	0x0008,0x6B00,0x0008,0x6B64,0x0008,0x6BE0,0x0008,0x6B1A,
	0x0008,0x6B7E,0x0008,0x6C00,0x0008,0x6B4A,0x0008,0x6BC0,
	0x0008,0x6C42,0x0008,0x7100,0x0008,0x7130,0x0008,0x7184,

	0x0008,0x71D8,0x0008,0x722C,0x0008,0x7280,0x0008,0x7322,
	0x0008,0x73C4,0x0008,0x7466,0x0008,0x74AE,0x0008,0x751A,
	0x0008,0x7586,0x0008,0x75F2,0x0008,0x7658,0x0008,0x76E2,
	0x0008,0x776C,0x0008,0x857A,0x0008,0x85AA,0x0008,0x85FE,
	0x0008,0x8652,0x0008,0x86A6,0x0008,0x870C,0x0008,0x8790,
	0x0008,0x8814,0x0008,0x8898,0x0008,0x88EC,0x0008,0x8964,
	0x0008,0x89DC,0x0008,0x8A54,0x0008,0x8ABA,0x0008,0x8B68,
	0x0008,0x8C16,0x0008,0x77F6,0x0008,0x782C,0x0008,0x7886,
	0x0008,0x78E0,0x0008,0x793A,0x0008,0x7982,0x0008,0x7A28,
	0x0008,0x7ACE,0x0008,0x7B74,0x0008,0x7BA4,0x0008,0x7BF8,
	0x0008,0x7C4C,0x0008,0x7CA0,0x0008,0x7CFA,0x0008,0x7D92,
	0x0008,0x7E2A,0x0008,0x8CC4,0x0008,0x8CF4,0x0008,0x8D48,
	0x0008,0x8D9C,0x0008,0x8DF0,0x0008,0x8E3E,0x0008,0x8EEA,
	0x0008,0x8F96,0x0008,0x9042,0x0008,0x907E,0x0008,0x90DE,
	0x0008,0x913E,0x0008,0x919E,0x0008,0x91FE,0x0008,0x929C,
	0x0008,0x933A,0x0008,0x7EC2,0x0008,0x7EF6,0x0008,0x7F8E,

	0x0008,0x8026,0x0008,0x80BE,0x0008,0x80FE,0x0008,0x8152,
	0x0008,0x81A6,0x0008,0x93D8,0x0008,0x9412,0x0008,0x94B0,
	0x0008,0x954E,0x0008,0x95EC,0x0008,0x9644,0x0008,0x96C0,
	0x0008,0x973C,0x0008,0x81FA,0x0008,0x823A,0x0008,0x82DE,
	0x0008,0x8382,0x0008,0x8426,0x0008,0x8460,0x0008,0x84BE,
	0x0008,0x851C,0x0008,0x97B8,0x0008,0x97F2,0x0008,0x9890,
	0x0008,0x992E,0x0008,0x99CC,0x0008,0x9A12,0x0008,0x9A7C,
	0x0008,0x9AE6,0x0008,0x7014,0x0008,0x706A,0x0008,0x70C4,
	0x0008,0xA16E,0x0008,0xA17A,0x0008,0xA198,0x0008,0xA1C2,
	0x0008,0xA1CE,0x0008,0xA1EC,0x0008,0xA216,0x0008,0xA222,
	0x0008,0xA240,0x0008,0xA2E4,0x0008,0xA2FA,0x0008,0xA26A,
	0x0008,0xA272,0x0008,0xA306,0x0008,0xA592,0x0008,0xA42E,
	0x0008,0xA4A2,0x0008,0xA508,0x0008,0xA550,0x0008,0xA642,
	0x0008,0xA714,0x0008,0xAAD2,0x0008,0xA8DE,0x0008,0xAC9C,
	0x0008,0xAA1E,0x0008,0xADFE,0x0008,0xAED6,0x0008,0xAFC8,
	0x0008,0xB0BA,0x0008,0xB1AC,0x0008,0xB324,0x0008,0xB416,

	0x0008,0xB508,0x0008,0xB5FA,0x0008,0xBC1C,0x0008,0xBC3C,
	0x0008,0xBC78,0x0008,0xBCB4,0x0008,0xBCC2,0x0008,0xBCF0,
	0x0008,0xBD50,0x0008,0xBD8C,0x0008,0xBD92,0x0008,0xBDC0,
	0x0008,0xBDFC,0x0008,0xBE0A,0x0008,0xBE28,0x0008,0xBE36,
	0x0008,0xBE54,0x0008,0xBE90,0x0008,0xBEEC,0x0008,0xBF26,
	0x0008,0xBF34,0x0008,0xBF5A,0x0008,0xBF96,0x0008,0xBFAC,
	0x0008,0xBFCA,0x0008,0xC006,0x0008,0xC058,0x0008,0xC06E,
	0x0008,0xC08C,0x0008,0xC0E6,0x0008,0xC0EC,0x0008,0xC10A,
	0x0008,0xC156,0x0008,0xC174,0x0008,0xC19A,0x0008,0xC1D6,
	0x0008,0xC1DC,0x0008,0x9B50,0x0008,0x9BF8,0x0008,0x9CDC,
	0x0008,0x9DC0,0x0008,0x9B52,0x0008,0x9BFA,0x0008,0x9CDE,
	0x0008,0x9DC2,0x0008,0x9EA4,0x0008,0x9EB2,0x0008,0x9F38,
	0x0008,0x9F4C,0x0008,0x9FD2,0x0008,0x9FE6,0x0008,0xA06C,
	0x0008,0xA080,0x0008,0xA106,0x0008,0xA11A,0x0008,0xA11A,
	0x0008,0xA11A,0x0008,0xA11A,0x0008,0xB772,0x0008,0xB786,
	0x0008,0xB7AC,0x0008,0xB7EA,0x0008,0xB7FE,0x0008,0xB818,

	0x0008,0xB772,0x0008,0xB786,0x0008,0xB87E,0x0008,0xB772,
	0x0008,0xB786,0x0008,0xB8F0,0x0008,0xB912,0x0008,0xB93A,
	0x0008,0xF128,0x0008,0xF148,0x0008,0xF1EC,0x0008,0xF2AA
};
static UINT16 bloodwar_mcu_4_28[] = { // Warrior 4
	0x0008,0xF128,0x0008,0xF148,0x0008,0xF1EC,0x0008,0xF2AA,
	0x0008,0xFA80,0x0008,0xF3AA,0x0008,0xF3C4,0x0008,0xF3E4,
	0x0008,0xF4A8,0x0008,0xF56C,0x0008,0xFA9C,0x0008,0xFC78,
	0x0008,0xFC8A,0x0008,0xFCBC,0x0008,0xFCEE,0x0008,0xFD58,
	0x0008,0xFD6A,0x0008,0xFD9C,0x0008,0xFDCE,0x0008,0xFD20,
	0x0008,0xFD2E,0x0008,0xFD3C,0x0008,0xFD4A,0x0008,0xFE00,
	0x0008,0xFE0E,0x0008,0xFE1C,0x0008,0xFE2A,0x0008,0xF630,
	0x0008,0xF64A,0x0008,0xF67C,0x0008,0xF6F4,0x0008,0xF76C,
	0x0008,0xF7E4,0x0008,0xF816,0x0008,0xF88E,0x0008,0xF906,
	0x0008,0xFAB8,0x0008,0xFACA,0x0008,0xFAFC,0x0008,0xFB2E,
	0x0008,0xFB98,0x0008,0xFBAA,0x0008,0xFBDC,0x0008,0xFC0E,
	0x0008,0xFB60,0x0008,0xFB6E,0x0008,0xFB7C,0x0008,0xFB8A,
	0x0008,0xFC40,0x0008,0xFC4E,0x0008,0xFC5C,0x0008,0xFC6A,
	0x0008,0xF97E,0x0008,0xF9D0,0x0008,0xFA28,0x0008,0xF992,
	0x0008,0xF9E4,0x0008,0xFA3C,0x0008,0xF9BC,0x0008,0xFA14,
	0x0008,0xFA6C,0x0008,0xFF1A,0x0008,0xFF4A,0x0008,0xFF9E,

	0x0008,0xFFF2,0x0009,0x0046,0x0009,0x00A0,0x0009,0x012E,
	0x0009,0x01BC,0x0009,0x024A,0x0009,0x02A4,0x0009,0x0322,
	0x0009,0x03A0,0x0009,0x041E,0x0009,0x046C,0x0009,0x04F8,
	0x0009,0x0584,0x0009,0x16C4,0x0009,0x1700,0x0009,0x1760,
	0x0009,0x17C0,0x0009,0x1820,0x0009,0x1868,0x0009,0x190E,
	0x0009,0x19B4,0x0009,0x1A5A,0x0009,0x1AAE,0x0009,0x1B36,
	0x0009,0x1BBE,0x0009,0x1C46,0x0009,0x1C9A,0x0009,0x1D46,
	0x0009,0x1DF2,0x0009,0x0610,0x0009,0x064C,0x0009,0x06BC,
	0x0009,0x072C,0x0009,0x079C,0x0009,0x07F0,0x0009,0x08BC,
	0x0009,0x0988,0x0009,0x0A54,0x0009,0x0A9C,0x0009,0x0B18,
	0x0009,0x0B94,0x0009,0x0C10,0x0009,0x0C76,0x0009,0x0D10,
	0x0009,0x0DAA,0x0009,0x1E9E,0x0009,0x1ECE,0x0009,0x1F22,
	0x0009,0x1F76,0x0009,0x1FCA,0x0009,0x2024,0x0009,0x20BC,
	0x0009,0x2154,0x0009,0x21EC,0x0009,0x2240,0x0009,0x22C8,
	0x0009,0x2350,0x0009,0x23D8,0x0009,0x243E,0x0009,0x24D8,
	0x0009,0x2572,0x0009,0x0E44,0x0009,0x0E90,0x0009,0x0F40,

	0x0009,0x0FF0,0x0009,0x10A0,0x0009,0x1104,0x0009,0x117C,
	0x0009,0x11F4,0x0009,0x260C,0x0009,0x2664,0x0009,0x2700,
	0x0009,0x279C,0x0009,0x2838,0x0009,0x2878,0x0009,0x28DC,
	0x0009,0x2940,0x0009,0x126C,0x0009,0x12D0,0x0009,0x1398,
	0x0009,0x1460,0x0009,0x1528,0x0009,0x1574,0x0009,0x15E4,
	0x0009,0x1654,0x0009,0x29A4,0x0009,0x29EA,0x0009,0x2A84,
	0x0009,0x2B1E,0x0009,0x2BB8,0x0009,0x2BFE,0x0009,0x2C58,
	0x0009,0x2CB2,0x0008,0xFE38,0x0008,0xFEA6,0x0008,0xFEF6,
	0x0009,0x3406,0x0009,0x3412,0x0009,0x3430,0x0009,0x345A,
	0x0009,0x3466,0x0009,0x3484,0x0009,0x34AE,0x0009,0x34BA,
	0x0009,0x34D8,0x0009,0x357C,0x0009,0x3592,0x0009,0x3502,
	0x0009,0x350A,0x0009,0x359E,0x0009,0x379A,0x0009,0x3636,
	0x0009,0x36AA,0x0009,0x3710,0x0009,0x3758,0x0009,0x384A,
	0x0009,0x391C,0x0009,0x3CDA,0x0009,0x3AE6,0x0009,0x3EA4,
	0x0009,0x3C26,0x0009,0x4006,0x0009,0x40DE,0x0009,0x41D0,
	0x0009,0x42C2,0x0009,0x43B4,0x0009,0x452C,0x0009,0x461E,

	0x0009,0x4710,0x0009,0x4802,0x0009,0x4ED8,0x0009,0x4EF8,
	0x0009,0x4F34,0x0009,0x4F70,0x0009,0x4F7E,0x0009,0x4FAC,
	0x0009,0x500C,0x0009,0x5048,0x0009,0x504E,0x0009,0x507C,
	0x0009,0x50B8,0x0009,0x50C6,0x0009,0x50E4,0x0009,0x50F2,
	0x0009,0x5110,0x0009,0x514C,0x0009,0x51A8,0x0009,0x51E2,
	0x0009,0x51F0,0x0009,0x5216,0x0009,0x5252,0x0009,0x5268,
	0x0009,0x5286,0x0009,0x52C2,0x0009,0x5314,0x0009,0x532A,
	0x0009,0x5348,0x0009,0x53A2,0x0009,0x53A8,0x0009,0x53C6,
	0x0009,0x5412,0x0009,0x5430,0x0009,0x5456,0x0009,0x5492,
	0x0009,0x5498,0x0009,0x2D0C,0x0009,0x2DC8,0x0009,0x2E84,
	0x0009,0x2F40,0x0009,0x2D0E,0x0009,0x2DCA,0x0009,0x2E86,
	0x0009,0x2F42,0x0009,0x2FFC,0x0009,0x300A,0x0009,0x300A,
	0x0009,0x300A,0x0009,0x300A,0x0009,0x305E,0x0009,0x3148,
	0x0009,0x3232,0x0009,0x331C,0x0009,0x497A,0x0009,0x498E,
	0x0009,0x49A2,0x0009,0x497A,0x0009,0x498E,0x0009,0x49E6,
	0x0009,0x49F6,0x0009,0x497A,0x0009,0x498E,0x0009,0x4A18,

	0x0009,0x4A2A,0x0009,0x81A8,0x0009,0x81C8,0x0009,0x8270
};
static UINT16 bloodwar_mcu_4_29[] = { // Warrior 5
	0x0007,0xCC3C,0x0007,0xCC68,0x0007,0xCD1C,0x0007,0xCD9A,
	0x0007,0xD616,0x0007,0xCE38,0x0007,0xCE52,0x0007,0xCE72,
	0x0007,0xCF16,0x0007,0xCFAA,0x0007,0xD632,0x0007,0xD80E,
	0x0007,0xD820,0x0007,0xD852,0x0007,0xD884,0x0007,0xD8EE,
	0x0007,0xD900,0x0007,0xD932,0x0007,0xD964,0x0007,0xD8B6,
	0x0007,0xD8C4,0x0007,0xD8D2,0x0007,0xD8E0,0x0007,0xD996,
	0x0007,0xD9A4,0x0007,0xD9B2,0x0007,0xD9C0,0x0007,0xD064,
	0x0007,0xD07E,0x0007,0xD0C2,0x0007,0xD16A,0x0007,0xD212,
	0x0007,0xD2BA,0x0007,0xD2FE,0x0007,0xD3A6,0x0007,0xD44E,
	0x0007,0xD64E,0x0007,0xD660,0x0007,0xD692,0x0007,0xD6C4,
	0x0007,0xD72E,0x0007,0xD740,0x0007,0xD772,0x0007,0xD7A4,
	0x0007,0xD6F6,0x0007,0xD704,0x0007,0xD712,0x0007,0xD720,
	0x0007,0xD7D6,0x0007,0xD7E4,0x0007,0xD7F2,0x0007,0xD800,
	0x0007,0xD4F6,0x0007,0xD54E,0x0007,0xD5BE,0x0007,0xD50A,
	0x0007,0xD562,0x0007,0xD5D2,0x0007,0xD53A,0x0007,0xD5B0,
	0x0007,0xD602,0x0007,0xDA8C,0x0007,0xDAC8,0x0007,0xDB2C,

	0x0007,0xDB90,0x0007,0xDBF4,0x0007,0xDC36,0x0007,0xDCE0,
	0x0007,0xDD8A,0x0007,0xDE34,0x0007,0xDE94,0x0007,0xDF3C,
	0x0007,0xDFE4,0x0007,0xE08C,0x0007,0xE0F2,0x0007,0xE1B4,
	0x0007,0xE276,0x0007,0xF2D6,0x0007,0xF30C,0x0007,0xF366,
	0x0007,0xF3C0,0x0007,0xF41A,0x0007,0xF462,0x0007,0xF538,
	0x0007,0xF60E,0x0007,0xF6E4,0x0007,0xF77A,0x0007,0xF862,
	0x0007,0xF94A,0x0007,0xFA32,0x0007,0xFACE,0x0007,0xFBC6,
	0x0007,0xFCBE,0x0007,0xE338,0x0007,0xE36E,0x0007,0xE3C8,
	0x0007,0xE422,0x0007,0xE47C,0x0007,0xE4B8,0x0007,0xE552,
	0x0007,0xE5EC,0x0007,0xE686,0x0007,0xE6E0,0x0007,0xE772,
	0x0007,0xE804,0x0007,0xE896,0x0007,0xE8E2,0x0007,0xE946,
	0x0007,0xE9AA,0x0007,0xFDB6,0x0007,0xFDE6,0x0007,0xFE3A,
	0x0007,0xFE8E,0x0007,0xFEE2,0x0007,0xFF3C,0x0007,0xFFE4,
	0x0008,0x008C,0x0008,0x0134,0x0008,0x01B2,0x0008,0x0282,
	0x0008,0x0352,0x0008,0x0422,0x0008,0x04A6,0x0008,0x0586,
	0x0008,0x0666,0x0007,0xEA0E,0x0007,0xEA6C,0x0007,0xEB22,

	0x0007,0xEBD8,0x0007,0xEC8E,0x0007,0xECEC,0x0007,0xED72,
	0x0007,0xEDF8,0x0008,0x0746,0x0008,0x079E,0x0008,0x083E,
	0x0008,0x08DE,0x0008,0x097E,0x0008,0x09D6,0x0008,0x0A56,
	0x0008,0x0AD6,0x0007,0xEE7E,0x0007,0xEED0,0x0007,0xEF7A,
	0x0007,0xF024,0x0007,0xF0CE,0x0007,0xF132,0x0007,0xF1BE,
	0x0007,0xF24A,0x0008,0x0B56,0x0008,0x0BB4,0x0008,0x0C5A,
	0x0008,0x0D00,0x0008,0x0DA6,0x0008,0x0E04,0x0008,0x0E8A,
	0x0008,0x0F10,0x0007,0xD9CE,0x0007,0xDA1C,0x0007,0xDA58,
	0x0008,0x1EDC,0x0008,0x1EE8,0x0008,0x1F06,0x0008,0x1F30,
	0x0008,0x1F3C,0x0008,0x1F5A,0x0008,0x1F84,0x0008,0x1F90,
	0x0008,0x1FAE,0x0008,0x204C,0x0008,0x2062,0x0008,0x1FD8,
	0x0008,0x1FE0,0x0008,0x206E,0x0008,0x226A,0x0008,0x2106,
	0x0008,0x217A,0x0008,0x21E0,0x0008,0x2228,0x0008,0x231A,
	0x0008,0x23E6,0x0008,0x27A4,0x0008,0x25B0,0x0008,0x296E,
	0x0008,0x26F0,0x0008,0x2AD0,0x0008,0x2BA8,0x0008,0x2C94,
	0x0008,0x2D80,0x0008,0x2E6C,0x0008,0x2FDE,0x0008,0x30CA,

	0x0008,0x31B6,0x0008,0x32A2,0x0008,0x3414,0x0008,0x3434,
	0x0008,0x3470,0x0008,0x34AC,0x0008,0x34BA,0x0008,0x34E8,
	0x0008,0x3548,0x0008,0x3584,0x0008,0x358A,0x0008,0x35B8,
	0x0008,0x35F4,0x0008,0x3602,0x0008,0x3620,0x0008,0x362E,
	0x0008,0x364C,0x0008,0x3688,0x0008,0x36E4,0x0008,0x371E,
	0x0008,0x372C,0x0008,0x3752,0x0008,0x378E,0x0008,0x37A4,
	0x0008,0x37C2,0x0008,0x37FE,0x0008,0x3850,0x0008,0x3866,
	0x0008,0x3884,0x0008,0x38DE,0x0008,0x38E4,0x0008,0x3902,
	0x0008,0x394E,0x0008,0x396C,0x0008,0x3992,0x0008,0x39CE,
	0x0008,0x39D4,0x0008,0x0F96,0x0008,0x10A2,0x0008,0x10B6,
	0x0008,0x11C2,0x0008,0x11D6,0x0008,0x12E2,0x0008,0x12F6,
	0x0008,0x1402,0x0008,0x1416,0x0008,0x14E8,0x0008,0x15DE,
	0x0008,0x16DE,0x0008,0x17DE,0x0008,0x1934,0x0008,0x1A8A,
	0x0008,0x1BE0,0x0008,0x1D36,0x0008,0x1D50,0x0008,0x1D70,
	0x0008,0x1DAE,0x0008,0x1DC8,0x0008,0x1DE8,0x0008,0x1E2C,
	0x0008,0x1E46,0x0008,0x1E5A,0x0008,0x1DAE,0x0008,0x1DC8,

	0x0008,0x1E9A,0x0008,0x1EAC,0x0008,0x631C,0x0008,0x6348
};
static UINT16 bloodwar_mcu_4_2a[] = { // Warrior 6
	0x000A,0x0E3C,0x000A,0x0E5C,0x000A,0x0F00,0x000A,0x0FA8,
	0x000A,0x16E2,0x000A,0x105C,0x000A,0x1076,0x000A,0x1096,
	0x000A,0x113A,0x000A,0x11DE,0x000A,0x16FE,0x000A,0x18DA,
	0x000A,0x18EC,0x000A,0x191E,0x000A,0x1950,0x000A,0x19BA,
	0x000A,0x19CC,0x000A,0x19FE,0x000A,0x1A30,0x000A,0x1982,
	0x000A,0x1990,0x000A,0x199E,0x000A,0x19AC,0x000A,0x1A62,
	0x000A,0x1A70,0x000A,0x1A7E,0x000A,0x1A8C,0x000A,0x1286,
	0x000A,0x12A0,0x000A,0x12D2,0x000A,0x134A,0x000A,0x13C2,
	0x000A,0x143A,0x000A,0x146C,0x000A,0x14E4,0x000A,0x155C,
	0x000A,0x171A,0x000A,0x172C,0x000A,0x175E,0x000A,0x1790,
	0x000A,0x17FA,0x000A,0x180C,0x000A,0x183E,0x000A,0x1870,
	0x000A,0x17C2,0x000A,0x17D0,0x000A,0x17DE,0x000A,0x17EC,
	0x000A,0x18A2,0x000A,0x18B0,0x000A,0x18BE,0x000A,0x18CC,
	0x000A,0x15D4,0x000A,0x1632,0x000A,0x168A,0x000A,0x15E8,
	0x000A,0x1646,0x000A,0x169E,0x000A,0x161E,0x000A,0x1676,
	0x000A,0x16CE,0x000A,0x1B52,0x000A,0x1B82,0x000A,0x1BD6,

	0x000A,0x1C2A,0x000A,0x1C7E,0x000A,0x1CCC,0x000A,0x1D68,
	0x000A,0x1E04,0x000A,0x1EA0,0x000A,0x1EE8,0x000A,0x1F54,
	0x000A,0x1FC0,0x000A,0x202C,0x000A,0x207A,0x000A,0x2106,
	0x000A,0x2192,0x000A,0x3092,0x000A,0x30C2,0x000A,0x3116,
	0x000A,0x316A,0x000A,0x31BE,0x000A,0x320C,0x000A,0x32B8,
	0x000A,0x3364,0x000A,0x3410,0x000A,0x345E,0x000A,0x34D0,
	0x000A,0x3542,0x000A,0x35B4,0x000A,0x3602,0x000A,0x36AE,
	0x000A,0x375A,0x000A,0x221E,0x000A,0x224E,0x000A,0x22A2,
	0x000A,0x22F6,0x000A,0x234A,0x000A,0x2392,0x000A,0x2438,
	0x000A,0x24DE,0x000A,0x2584,0x000A,0x25C6,0x000A,0x262C,
	0x000A,0x2692,0x000A,0x26F8,0x000A,0x273A,0x000A,0x27DA,
	0x000A,0x287A,0x000A,0x3806,0x000A,0x3836,0x000A,0x388A,
	0x000A,0x38DE,0x000A,0x3932,0x000A,0x3980,0x000A,0x3A2C,
	0x000A,0x3AD8,0x000A,0x3B84,0x000A,0x3BCC,0x000A,0x3C48,
	0x000A,0x3CC4,0x000A,0x3D40,0x000A,0x3D8E,0x000A,0x3E3A,
	0x000A,0x3EE6,0x000A,0x291A,0x000A,0x294E,0x000A,0x29E6,

	0x000A,0x2A7E,0x000A,0x2B16,0x000A,0x2B56,0x000A,0x2BBA,
	0x000A,0x2C1E,0x000A,0x3F92,0x000A,0x3FC6,0x000A,0x405E,
	0x000A,0x40F6,0x000A,0x418E,0x000A,0x41C2,0x000A,0x421A,
	0x000A,0x4272,0x000A,0x2C82,0x000A,0x2CCE,0x000A,0x2D86,
	0x000A,0x2E3E,0x000A,0x2EF6,0x000A,0x2F42,0x000A,0x2FB2,
	0x000A,0x3022,0x000A,0x42CA,0x000A,0x42FE,0x000A,0x4396,
	0x000A,0x442E,0x000A,0x44C6,0x000A,0x44FA,0x000A,0x4552,
	0x000A,0x45AA,0x000A,0x1A9A,0x000A,0x1AF0,0x000A,0x1B2E,
	0x000A,0x4D2C,0x000A,0x4D38,0x000A,0x4D56,0x000A,0x4D80,
	0x000A,0x4D8C,0x000A,0x4DAA,0x000A,0x4DD4,0x000A,0x4DE0,
	0x000A,0x4DFE,0x000A,0x4EA2,0x000A,0x4EB8,0x000A,0x4E28,
	0x000A,0x4E30,0x000A,0x4EC4,0x000A,0x50C0,0x000A,0x4F5C,
	0x000A,0x4FD0,0x000A,0x5036,0x000A,0x507E,0x000A,0x5170,
	0x000A,0x5242,0x000A,0x5600,0x000A,0x540C,0x000A,0x57CA,
	0x000A,0x554C,0x000A,0x592C,0x000A,0x5A04,0x000A,0x5AF6,
	0x000A,0x5BE8,0x000A,0x5CDA,0x000A,0x5E52,0x000A,0x5F44,

	0x000A,0x6036,0x000A,0x6128,0x000A,0x6738,0x000A,0x6758,
	0x000A,0x6794,0x000A,0x67D0,0x000A,0x67DE,0x000A,0x680C,
	0x000A,0x686C,0x000A,0x68A8,0x000A,0x68AE,0x000A,0x68DC,
	0x000A,0x6918,0x000A,0x6926,0x000A,0x6944,0x000A,0x6952,
	0x000A,0x6970,0x000A,0x69AC,0x000A,0x6A08,0x000A,0x6A42,
	0x000A,0x6A50,0x000A,0x6A76,0x000A,0x6AB2,0x000A,0x6AC8,
	0x000A,0x6AE6,0x000A,0x6B22,0x000A,0x6B74,0x000A,0x6B8A,
	0x000A,0x6BA8,0x000A,0x6C02,0x000A,0x6C08,0x000A,0x6C26,
	0x000A,0x6C72,0x000A,0x6C90,0x000A,0x6CB6,0x000A,0x6CF2,
	0x000A,0x6CF8,0x000A,0x4602,0x000A,0x4602,0x000A,0x4602,
	0x000A,0x4602,0x000A,0x4644,0x000A,0x46F8,0x000A,0x47AC,
	0x000A,0x4860,0x000A,0x4646,0x000A,0x46FA,0x000A,0x47AE,
	0x000A,0x4862,0x000A,0x4916,0x000A,0x4924,0x000A,0x4A26,
	0x000A,0x4B28,0x000A,0x4C2A,0x000A,0x62A0,0x000A,0x62B4,
	0x000A,0x62DA,0x000A,0x62A0,0x000A,0x62B4,0x000A,0x631E,
	0x000A,0x6338,0x000A,0x94A4,0x000A,0x94C4,0x000A,0x9568
};
static UINT16 bloodwar_mcu_4_2b[] = { // Warrior 7
	0x000A,0x94A4,0x000A,0x94C4,0x000A,0x9568,0x000A,0x9646,
	0x000A,0x9DFC,0x000A,0x9746,0x000A,0x9760,0x000A,0x9780,
	0x000A,0x9824,0x000A,0x98C8,0x000A,0x9E18,0x000A,0x9FF4,
	0x000A,0xA006,0x000A,0xA038,0x000A,0xA06A,0x000A,0xA0D4,
	0x000A,0xA0E6,0x000A,0xA118,0x000A,0xA14A,0x000A,0xA09C,
	0x000A,0xA0AA,0x000A,0xA0B8,0x000A,0xA0C6,0x000A,0xA17C,
	0x000A,0xA18A,0x000A,0xA198,0x000A,0xA1A6,0x000A,0x9970,
	0x000A,0x998A,0x000A,0x99B0,0x000A,0x9A44,0x000A,0x9AD8,
	0x000A,0x9B6C,0x000A,0x9B8C,0x000A,0x9BEA,0x000A,0x9C48,
	0x000A,0x9E34,0x000A,0x9E46,0x000A,0x9E78,0x000A,0x9EAA,
	0x000A,0x9F14,0x000A,0x9F26,0x000A,0x9F58,0x000A,0x9F8A,
	0x000A,0x9EDC,0x000A,0x9EEA,0x000A,0x9EF8,0x000A,0x9F06,
	0x000A,0x9FBC,0x000A,0x9FCA,0x000A,0x9FD8,0x000A,0x9FE6,
	0x000A,0x9CA6,0x000A,0x9D04,0x000A,0x9D86,0x000A,0x9CBA,
	0x000A,0x9D18,0x000A,0x9D9A,0x000A,0x9CF0,0x000A,0x9D72,
	0x000A,0x9DE8,0x000A,0xA260,0x000A,0xA296,0x000A,0xA2F0,

	0x000A,0xA34A,0x000A,0xA3A4,0x000A,0xA3FE,0x000A,0xA4B0,
	0x000A,0xA562,0x000A,0xA614,0x000A,0xA67A,0x000A,0xA6F8,
	0x000A,0xA776,0x000A,0xA7F4,0x000A,0xA860,0x000A,0xA900,
	0x000A,0xA9A0,0x000A,0xB9F2,0x000A,0xBA22,0x000A,0xBA76,
	0x000A,0xBACA,0x000A,0xBB1E,0x000A,0xBB60,0x000A,0xBC00,
	0x000A,0xBCA0,0x000A,0xBD40,0x000A,0xBD88,0x000A,0xBDF4,
	0x000A,0xBE60,0x000A,0xBECC,0x000A,0xBF20,0x000A,0xBFA8,
	0x000A,0xC030,0x000A,0xAA40,0x000A,0xAA76,0x000A,0xAAD0,
	0x000A,0xAB2A,0x000A,0xAB84,0x000A,0xABEA,0x000A,0xAC88,
	0x000A,0xAD26,0x000A,0xADC4,0x000A,0xAE24,0x000A,0xAEB8,
	0x000A,0xAF4C,0x000A,0xAFE0,0x000A,0xB03A,0x000A,0xB0E2,
	0x000A,0xB18A,0x000A,0xC0B8,0x000A,0xC0E8,0x000A,0xC13C,
	0x000A,0xC190,0x000A,0xC1E4,0x000A,0xC226,0x000A,0xC2C6,
	0x000A,0xC366,0x000A,0xC406,0x000A,0xC44E,0x000A,0xC4BA,
	0x000A,0xC526,0x000A,0xC592,0x000A,0xC5D4,0x000A,0xC694,
	0x000A,0xC754,0x000A,0xB232,0x000A,0xB272,0x000A,0xB316,

	0x000A,0xB3BA,0x000A,0xB45E,0x000A,0xB49E,0x000A,0xB502,
	0x000A,0xB566,0x000A,0xC814,0x000A,0xC848,0x000A,0xC8E0,
	0x000A,0xC978,0x000A,0xCA10,0x000A,0xCA44,0x000A,0xCA9C,
	0x000A,0xCAF4,0x000A,0xB5CA,0x000A,0xB622,0x000A,0xB6DE,
	0x000A,0xB79A,0x000A,0xB856,0x000A,0xB8A2,0x000A,0xB912,
	0x000A,0xB982,0x000A,0xCB4C,0x000A,0xCB80,0x000A,0xCC0E,
	0x000A,0xCC9C,0x000A,0xCD2A,0x000A,0xCD6A,0x000A,0xCDCE,
	0x000A,0xCE32,0x000A,0xA1B4,0x000A,0xA1F2,0x000A,0xA236,
	0x000A,0xDD1A,0x000A,0xDD26,0x000A,0xDD44,0x000A,0xDD6E,
	0x000A,0xDD7A,0x000A,0xDD98,0x000A,0xDDC2,0x000A,0xDDCE,
	0x000A,0xDDEC,0x000A,0xDE90,0x000A,0xDEA6,0x000A,0xDE16,
	0x000A,0xDE1E,0x000A,0xDEB2,0x000A,0xE13E,0x000A,0xDFDA,
	0x000A,0xE04E,0x000A,0xE0B4,0x000A,0xE0FC,0x000A,0xE1EE,
	0x000A,0xE2C0,0x000A,0xE67E,0x000A,0xE48A,0x000A,0xE848,
	0x000A,0xE5CA,0x000A,0xE9AA,0x000A,0xEA82,0x000A,0xEB74,
	0x000A,0xEC66,0x000A,0xED58,0x000A,0xEED0,0x000A,0xEFC2,

	0x000A,0xF0B4,0x000A,0xF1A6,0x000A,0xF752,0x000A,0xF772,
	0x000A,0xF7AE,0x000A,0xF7EA,0x000A,0xF7F8,0x000A,0xF826,
	0x000A,0xF886,0x000A,0xF8C2,0x000A,0xF8C8,0x000A,0xF8F6,
	0x000A,0xF932,0x000A,0xF940,0x000A,0xF95E,0x000A,0xF96C,
	0x000A,0xF98A,0x000A,0xF9C6,0x000A,0xFA22,0x000A,0xFA5C,
	0x000A,0xFA6A,0x000A,0xFA90,0x000A,0xFACC,0x000A,0xFAE2,
	0x000A,0xFB00,0x000A,0xFB3C,0x000A,0xFB8E,0x000A,0xFBA4,
	0x000A,0xFBC2,0x000A,0xFC1C,0x000A,0xFC22,0x000A,0xFC40,
	0x000A,0xFC8C,0x000A,0xFCAA,0x000A,0xFCD0,0x000A,0xFD0C,
	0x000A,0xFD12,0x000A,0xCE96,0x000A,0xCFA0,0x000A,0xD0AA,
	0x000A,0xD1B4,0x000A,0xD2BE,0x000A,0xD4FA,0x000A,0xD75A,
	0x000A,0xD9DA,0x000A,0xDC7A,0x000A,0xDC7A,0x000A,0xDC7A,
	0x000A,0xDC7A,0x000A,0xF31E,0x000A,0xF344,0x000A,0xF364,
	0x000A,0xF31E,0x000A,0xF344,0x000A,0xF39C,0x000A,0xF3A6,
	0x000B,0x272C,0x000B,0x274C,0x000B,0x284C,0x000B,0x2924
};
static UINT16 bloodwar_mcu_4_2c[] = { // Warrior 8
	0x000B,0x272C,0x000B,0x274C,0x000B,0x284C,0x000B,0x2924,
	0x000B,0x3242,0x000B,0x2A0E,0x000B,0x2A28,0x000B,0x2A48,
	0x000B,0x2B4C,0x000B,0x2C1A,0x000B,0x325E,0x000B,0x343A,
	0x000B,0x344C,0x000B,0x347E,0x000B,0x34B0,0x000B,0x351A,
	0x000B,0x352C,0x000B,0x355E,0x000B,0x3590,0x000B,0x34E2,
	0x000B,0x34F0,0x000B,0x34FE,0x000B,0x350C,0x000B,0x35C2,
	0x000B,0x35D0,0x000B,0x35DE,0x000B,0x35EC,0x000B,0x2D1A,
	0x000B,0x2D34,0x000B,0x2D66,0x000B,0x2DFE,0x000B,0x2E96,
	0x000B,0x2F2E,0x000B,0x2F66,0x000B,0x2FFE,0x000B,0x3096,
	0x000B,0x327A,0x000B,0x328C,0x000B,0x32BE,0x000B,0x32F0,
	0x000B,0x335A,0x000B,0x336C,0x000B,0x339E,0x000B,0x33D0,
	0x000B,0x3322,0x000B,0x3330,0x000B,0x333E,0x000B,0x334C,
	0x000B,0x3402,0x000B,0x3410,0x000B,0x341E,0x000B,0x342C,
	0x000B,0x312E,0x000B,0x3186,0x000B,0x31E4,0x000B,0x3142,
	0x000B,0x31A0,0x000B,0x31FE,0x000B,0x3172,0x000B,0x31D0,
	0x000B,0x322E,0x000B,0x3702,0x000B,0x373E,0x000B,0x37AE,

	0x000B,0x381E,0x000B,0x388E,0x000B,0x38D6,0x000B,0x397C,
	0x000B,0x3A22,0x000B,0x3AC8,0x000B,0x3B10,0x000B,0x3B86,
	0x000B,0x3BFC,0x000B,0x3C72,0x000B,0x3CC0,0x000B,0x3D6C,
	0x000B,0x3E18,0x000B,0x4D98,0x000B,0x4DD4,0x000B,0x4E44,
	0x000B,0x4EB4,0x000B,0x4F24,0x000B,0x4F78,0x000B,0x501A,
	0x000B,0x50BC,0x000B,0x515E,0x000B,0x51AC,0x000B,0x5212,
	0x000B,0x5278,0x000B,0x52DE,0x000B,0x5320,0x000B,0x53D0,
	0x000B,0x5480,0x000B,0x3EC4,0x000B,0x3EF4,0x000B,0x3F58,
	0x000B,0x3FBC,0x000B,0x4020,0x000B,0x405C,0x000B,0x4120,
	0x000B,0x41E4,0x000B,0x42A8,0x000B,0x42DE,0x000B,0x4348,
	0x000B,0x43B2,0x000B,0x441C,0x000B,0x4458,0x000B,0x44D8,
	0x000B,0x4558,0x000B,0x5530,0x000B,0x5560,0x000B,0x55C4,
	0x000B,0x5628,0x000B,0x568C,0x000B,0x56C8,0x000B,0x5782,
	0x000B,0x583C,0x000B,0x58F6,0x000B,0x594A,0x000B,0x59BC,
	0x000B,0x5A2E,0x000B,0x5AA0,0x000B,0x5AE8,0x000B,0x5B8E,
	0x000B,0x5C34,0x000B,0x45D8,0x000B,0x4624,0x000B,0x46D4,

	0x000B,0x4784,0x000B,0x4834,0x000B,0x4880,0x000B,0x48F0,
	0x000B,0x4960,0x000B,0x5CDA,0x000B,0x5D26,0x000B,0x5DD6,
	0x000B,0x5E86,0x000B,0x5F36,0x000B,0x5F82,0x000B,0x5FF2,
	0x000B,0x6062,0x000B,0x49D0,0x000B,0x4A10,0x000B,0x4AB4,
	0x000B,0x4B58,0x000B,0x4BFC,0x000B,0x4C48,0x000B,0x4CB8,
	0x000B,0x4D28,0x000B,0x60D2,0x000B,0x6112,0x000B,0x61B6,
	0x000B,0x625A,0x000B,0x62FE,0x000B,0x634A,0x000B,0x63BA,
	0x000B,0x642A,0x000B,0x35FA,0x000B,0x3666,0x000B,0x36D8,
	0x000B,0x6B1A,0x000B,0x6B26,0x000B,0x6B44,0x000B,0x6B6E,
	0x000B,0x6B7A,0x000B,0x6B98,0x000B,0x6BC2,0x000B,0x6BCE,
	0x000B,0x6BEC,0x000B,0x6C90,0x000B,0x6CA6,0x000B,0x6C16,
	0x000B,0x6C1E,0x000B,0x6CB2,0x000B,0x6EAE,0x000B,0x6D4A,
	0x000B,0x6DBE,0x000B,0x6E24,0x000B,0x6E6C,0x000B,0x6F5E,
	0x000B,0x7030,0x000B,0x73EE,0x000B,0x71FA,0x000B,0x75B8,
	0x000B,0x733A,0x000B,0x771A,0x000B,0x77F2,0x000B,0x78E4,
	0x000B,0x79D6,0x000B,0x7AC8,0x000B,0x7C40,0x000B,0x7D32,

	0x000B,0x7E24,0x000B,0x7F16,0x000B,0x84AE,0x000B,0x84CE,
	0x000B,0x850A,0x000B,0x8546,0x000B,0x8554,0x000B,0x8582,
	0x000B,0x85E2,0x000B,0x861E,0x000B,0x8624,0x000B,0x8652,
	0x000B,0x868E,0x000B,0x869C,0x000B,0x86BA,0x000B,0x86C8,
	0x000B,0x86E6,0x000B,0x8722,0x000B,0x877E,0x000B,0x87B8,
	0x000B,0x87C6,0x000B,0x87EC,0x000B,0x8828,0x000B,0x883E,
	0x000B,0x885C,0x000B,0x8898,0x000B,0x88EA,0x000B,0x8900,
	0x000B,0x891E,0x000B,0x8978,0x000B,0x897E,0x000B,0x899C,
	0x000B,0x89E8,0x000B,0x8A06,0x000B,0x8A2C,0x000B,0x8A68,
	0x000B,0x8A6E,0x000B,0x649A,0x000B,0x649A,0x000B,0x649A,
	0x000B,0x649A,0x000B,0x64D0,0x000B,0x65B6,0x000B,0x66DC,
	0x000B,0x6802,0x000B,0x6928,0x000B,0x698C,0x000B,0x6A08,
	0x000B,0x6A84,0x000B,0x693C,0x000B,0x69A0,0x000B,0x6A1C,
	0x000B,0x6A98,0x000B,0x6B00,0x000B,0x808E,0x000B,0x80A2,
	0x000B,0x80C8,0x000B,0x808E,0x000B,0x80A2,0x000B,0x811C,
	0x000B,0x813E,0x000B,0xB188,0x000B,0xB1C0,0x000B,0xB308
};
static UINT16 bloodwar_mcu_4_2d[] = { // Warrior 9
	0x0009,0x81A8,0x0009,0x81C8,0x0009,0x8270,0x0009,0x8328,
	0x0009,0x8A98,0x0009,0x8416,0x0009,0x8430,0x0009,0x8450,
	0x0009,0x84E8,0x0009,0x8580,0x0009,0x8AB4,0x0009,0x8C90,
	0x0009,0x8CA2,0x0009,0x8CD4,0x0009,0x8D06,0x0009,0x8D70,
	0x0009,0x8D82,0x0009,0x8DB4,0x0009,0x8DE6,0x0009,0x8D38,
	0x0009,0x8D46,0x0009,0x8D54,0x0009,0x8D62,0x0009,0x8E18,
	0x0009,0x8E26,0x0009,0x8E34,0x0009,0x8E42,0x0009,0x864E,
	0x0009,0x8668,0x0009,0x8694,0x0009,0x870C,0x0009,0x8784,
	0x0009,0x87FC,0x0009,0x8828,0x0009,0x88A0,0x0009,0x8918,
	0x0009,0x8AD0,0x0009,0x8AE2,0x0009,0x8B14,0x0009,0x8B46,
	0x0009,0x8BB0,0x0009,0x8BC2,0x0009,0x8BF4,0x0009,0x8C26,
	0x0009,0x8B78,0x0009,0x8B86,0x0009,0x8B94,0x0009,0x8BA2,
	0x0009,0x8C58,0x0009,0x8C66,0x0009,0x8C74,0x0009,0x8C82,
	0x0009,0x8990,0x0009,0x89EE,0x0009,0x8A46,0x0009,0x89A4,
	0x0009,0x8A02,0x0009,0x8A5A,0x0009,0x89DA,0x0009,0x8A32,
	0x0009,0x8A8A,0x0009,0x8F0E,0x0009,0x8F50,0x0009,0x8FB6,

	0x0009,0x901C,0x0009,0x9082,0x0009,0x90DC,0x0009,0x9184,
	0x0009,0x922C,0x0009,0x92D4,0x0009,0x9310,0x0009,0x9370,
	0x0009,0x93D0,0x0009,0x9430,0x0009,0x94A2,0x0009,0x9548,
	0x0009,0x95EE,0x0009,0xA4F0,0x0009,0xA520,0x0009,0xA574,
	0x0009,0xA5C8,0x0009,0xA61C,0x0009,0xA66A,0x0009,0xA716,
	0x0009,0xA7C2,0x0009,0xA86E,0x0009,0xA8B0,0x0009,0xA926,
	0x0009,0xA99C,0x0009,0xAA12,0x0009,0xAA78,0x0009,0xAB12,
	0x0009,0xABAC,0x0009,0x9694,0x0009,0x96D0,0x0009,0x9730,
	0x0009,0x9790,0x0009,0x97F0,0x0009,0x9838,0x0009,0x98DE,
	0x0009,0x9984,0x0009,0x9A2A,0x0009,0x9A66,0x0009,0x9AD6,
	0x0009,0x9B46,0x0009,0x9BB6,0x0009,0x9C16,0x0009,0x9CC4,
	0x0009,0x9D72,0x0009,0xAC46,0x0009,0xAC6A,0x0009,0xACB2,
	0x0009,0xACFA,0x0009,0xAD42,0x0009,0xAD84,0x0009,0xAE34,
	0x0009,0xAEE4,0x0009,0xAF94,0x0009,0xAFEC,0x0009,0xB05C,
	0x0009,0xB0CC,0x0009,0xB13C,0x0009,0xB196,0x0009,0xB248,
	0x0009,0xB2FA,0x0009,0x9E20,0x0009,0x9E54,0x0009,0x9EEC,

	0x0009,0x9F84,0x0009,0xA01C,0x0009,0xA050,0x0009,0xA0A8,
	0x0009,0xA100,0x0009,0xB3AC,0x0009,0xB3E0,0x0009,0xB478,
	0x0009,0xB510,0x0009,0xB5A8,0x0009,0xB5E8,0x0009,0xB64C,
	0x0009,0xB6B0,0x0009,0xA158,0x0009,0xA198,0x0009,0xA23C,
	0x0009,0xA2E0,0x0009,0xA384,0x0009,0xA3C4,0x0009,0xA428,
	0x0009,0xA48C,0x0009,0xB714,0x0009,0xB748,0x0009,0xB7E0,
	0x0009,0xB878,0x0009,0xB910,0x0009,0xB95C,0x0009,0xB9CC,
	0x0009,0xBA3C,0x0009,0x8E50,0x0009,0x8E82,0x0009,0x8ED2,
	0x0009,0xC388,0x0009,0xC394,0x0009,0xC3B2,0x0009,0xC3DC,
	0x0009,0xC3E8,0x0009,0xC406,0x0009,0xC430,0x0009,0xC43C,
	0x0009,0xC45A,0x0009,0xC4FE,0x0009,0xC514,0x0009,0xC484,
	0x0009,0xC48C,0x0009,0xC520,0x0009,0xC71C,0x0009,0xC5B8,
	0x0009,0xC62C,0x0009,0xC692,0x0009,0xC6DA,0x0009,0xC7CC,
	0x0009,0xC89E,0x0009,0xCC5C,0x0009,0xCA68,0x0009,0xCE26,
	0x0009,0xCBA8,0x0009,0xCF88,0x0009,0xD060,0x0009,0xD152,
	0x0009,0xD244,0x0009,0xD336,0x0009,0xD4AE,0x0009,0xD5A0,

	0x0009,0xD692,0x0009,0xD784,0x0009,0xDDC4,0x0009,0xDDE4,
	0x0009,0xDE20,0x0009,0xDE5C,0x0009,0xDE6A,0x0009,0xDE98,
	0x0009,0xDEF8,0x0009,0xDF34,0x0009,0xDF3A,0x0009,0xDF68,
	0x0009,0xDFA4,0x0009,0xDFB2,0x0009,0xDFD0,0x0009,0xDFDE,
	0x0009,0xDFFC,0x0009,0xE038,0x0009,0xE094,0x0009,0xE0CE,
	0x0009,0xE0DC,0x0009,0xE102,0x0009,0xE13E,0x0009,0xE154,
	0x0009,0xE172,0x0009,0xE1AE,0x0009,0xE200,0x0009,0xE216,
	0x0009,0xE234,0x0009,0xE28E,0x0009,0xE294,0x0009,0xE2B2,
	0x0009,0xE2FE,0x0009,0xE31C,0x0009,0xE342,0x0009,0xE37E,
	0x0009,0xE384,0x0009,0xBAAC,0x0009,0xBAAC,0x0009,0xBAAC,
	0x0009,0xBAAC,0x0009,0xBB44,0x0009,0xBC0C,0x0009,0xBCF4,
	0x0009,0xBDFC,0x0009,0xBF24,0x0009,0xC00E,0x0009,0xC040,
	0x0009,0xC124,0x0009,0xC156,0x0009,0xC240,0x0009,0xC272,
	0x0009,0xC356,0x0009,0xD8FC,0x0009,0xD910,0x0009,0xD936,
	0x0009,0xD8FC,0x0009,0xD910,0x0009,0xD96E,0x0009,0xD8FC,
	0x0009,0xD910,0x0009,0xD9B8,0x0009,0xD9D2,0x000A,0x0E3C
};
