/***************************************************************************

  inptport.c

  Input ports handling

TODO:	remove the 1 analog device per port limitation
		support for inputports producing interrupts
		support for extra "real" hardware (PC throttle's, spinners etc)

***************************************************************************/

#include "driver.h"
#include <math.h>

#ifdef MAME_NET
#include "network.h"

static unsigned short input_port_defaults[MAX_INPUT_PORTS];
static int default_player;
static int analog_player_port[MAX_INPUT_PORTS];
#endif /* MAME_NET */

#ifdef KAILLERA
#include "kailleraclient.h"
#include "KailleraChat.h"
#include "ticker.h"
#include "ui_temp.h" /*//kt */
#include "extmem.h"
#include "zlib.h"
#include <time.h>
int kMaxDipSwitch;							//kt
int kDipSwitchValues[MAX_INPUT_PORTS][2];	//kt
int kPlayerDup;			//kt
static int kMaxMahjong;							//kt
static int kMahjongPlayValues[4][256-1][3];		//kt
static int kAnalogPlayValues[4][MAX_INPUT_PORTS];	//kt
int kBitsPlayValues[4][16][3*2];
int kFirstMsg;
static unsigned short kValXor;	//kt
unsigned short kDefValues[MAX_INPUT_PORTS];		//kt
extern int kPlay;
extern void ResetReplay(void);
#endif /* KAILLERA */

#ifdef _MSC_VER
#include "vc_prefix.h"
#endif /* _MSC_VER */

/* header identifying the version of the game.cfg file */
/* mame 0.36b11 */
#define MAMECFGSTRING_V5 "MAMECFG\5"
#define MAMEDEFSTRING_V5 "MAMEDEF\4"

/* mame 0.36b12 with multi key/joy extension */
#define MAMECFGSTRING_V6 "MAMECFG\6"
#define MAMEDEFSTRING_V6 "MAMEDEF\5"

/* mame 0.36b13 with and/or/not combination */
#define MAMECFGSTRING_V7 "MAMECFG\7"
#define MAMEDEFSTRING_V7 "MAMEDEF\6"

/* mame 0.36b16 with key/joy merge */
#define MAMECFGSTRING_V8 "MAMECFG\x8"
#define MAMEDEFSTRING_V8 "MAMEDEF\7"

extern void *record;
extern void *playback;
#ifdef MAME32JP
extern void *recordsub;
extern void *playbacksub;
#endif

extern unsigned int dispensed_tickets;
extern unsigned int coins[COIN_COUNTERS];
extern unsigned int lastcoin[COIN_COUNTERS];
extern unsigned int coinlockedout[COIN_COUNTERS];

static unsigned short input_port_value[MAX_INPUT_PORTS];
static unsigned short input_vblank[MAX_INPUT_PORTS];

/* Assuming a maxium of one analog input device per port BW 101297 */
static struct InputPort *input_analog[MAX_INPUT_PORTS];
static int input_analog_current_value[MAX_INPUT_PORTS],input_analog_previous_value[MAX_INPUT_PORTS];
static int input_analog_init[MAX_INPUT_PORTS];
static int input_analog_scale[MAX_INPUT_PORTS];
static int mouse_delta_x[OSD_MAX_JOY_ANALOG], mouse_delta_y[OSD_MAX_JOY_ANALOG];
static int analog_current_x[OSD_MAX_JOY_ANALOG], analog_current_y[OSD_MAX_JOY_ANALOG];
static int analog_previous_x[OSD_MAX_JOY_ANALOG], analog_previous_y[OSD_MAX_JOY_ANALOG];

#ifdef MAME32JP
#define MAX_INPUT_BITS  1024
static int auto_pressed(InputSeq *seq, UINT32 type, int bit);
static UINT8  autopressed[MAX_INPUT_BITS];
static UINT32 autofire_enable;

extern INT32 volume_multiplier;
#endif

#ifdef USE_CUSTOM_BUTTON
UINT16 custom_button[MAX_PLAYERS][MAX_CUSTOM_BUTTONS];

static struct {
	int port;
	UINT16 mask;
} normal_button[MAX_PLAYERS][MAX_NORMAL_BUTTONS];

int custom_buttons;

static int normal_buttons = 0;
static int players = 0;
#endif /* USE_CUSTOM_BUTTON */

#ifdef USE_SHOW_INPUT_LOG
UINT8 command_buffer[COMMAND_LOG_BUFSIZE];
int show_input_log    = 0;
int show_input_player = 0;
int max_input_players = 0;
int command_counter   = 0;
static void make_input_log(void);
#endif /* USE_SHOW_INPUT_LOG */

static int playback_flag;

/***************************************************************************

  Configuration load/save

***************************************************************************/

/* this must match the enum in inptport.h */
char ipdn_defaultstrings[][MAX_DEFSTR_LEN] =
{
#ifdef JAPANESE
	"OFF",
	"ON",
	"",
	"͂",
	"Ct",
	"{[iXCt",
	"Փx",
	"fTEh",
	"RC",
	"RCA",
	"RCB",
	"9RC/1NWbg",
	"8RC/1NWbg",
	"7RC/1NWbg",
	"6RC/1NWbg",
	"5RC/1NWbg",
	"4RC/1NWbg",
	"3RC/1NWbg",
	"8RC/3NWbg",
	"4RC/2NWbg",
	"2RC/1NWbg",
	"5RC/3NWbg",
	"3RC/2NWbg",
	"4RC/3NWbg",
	"4RC/4NWbg",
	"3RC/3NWbg",
	"2RC/2NWbg",
	"1RC/1NWbg",
	"4RC/5NWbg",
	"3RC/4NWbg",
	"2RC/3NWbg",
	"4RC/7NWbg",
	"2RC/4NWbg",
	"1RC/2NWbg",
	"2RC/5NWbg",
	"2RC/6NWbg",
	"1RC/3NWbg",
	"2RC/7NWbg",
	"2RC/8NWbg",
	"1RC/4NWbg",
	"1RC/5NWbg",
	"1RC/6NWbg",
	"1RC/7NWbg",
	"1RC/8NWbg",
	"1RC/9NWbg",
	"t[vC",
	"➑",
	"AbvCg",
	"JNe",
	"ʔ]",
	"T[rX[h",
	"ꎞ~",
	"eXg",
	"eBg",
	"o[W",
	"[W",
	"C^[iVi",
	"{",
	"AJ",
	"[bp",
	"AWA",
	"E",
	"e",
	"",
	"p",
	"{",
	"hCc",
	"tX",
	"C^A",
	"XyC",
	"Very Easy",
	"Easiest",
	"Easier",
	"Easy",
	"Normal",
	"Medium",
	"Hard",
	"Harder",
	"Hardest",
	"Very Hard",
	"Very Low",
	"Low",
	"High",
	"Higher",
	"Highest",
	"Very High",
	"vC[",
	"Rg[",
	"fA",
	"VO",
	"Q[",
	"ReBj[z",
	"Rg[[",
	"e",
	"WCXeBbN",
	"gbN{[",
	"ReBj[",
	"ReBj[",
	"ՓxI",
	"",
	"XeI",
	"m",
	"gp",
	"s",
	"W",
	"]",
	"ʔ",
	"Ȃ"
#else
	"Off",
	"On",
	"No",
	"Yes",
	"Lives",
	"Bonus Life",
	"Difficulty",
	"Demo Sounds",
	"Coinage",
	"Coin A",
	"Coin B",
	"9 Coins/1 Credit",
	"8 Coins/1 Credit",
	"7 Coins/1 Credit",
	"6 Coins/1 Credit",
	"5 Coins/1 Credit",
	"4 Coins/1 Credit",
	"3 Coins/1 Credit",
	"8 Coins/3 Credits",
	"4 Coins/2 Credits",
	"2 Coins/1 Credit",
	"5 Coins/3 Credits",
	"3 Coins/2 Credits",
	"4 Coins/3 Credits",
	"4 Coins/4 Credits",
	"3 Coins/3 Credits",
	"2 Coins/2 Credits",
	"1 Coin/1 Credit",
	"4 Coins/5 Credits",
	"3 Coins/4 Credits",
	"2 Coins/3 Credits",
	"4 Coins/7 Credits",
	"2 Coins/4 Credits",
	"1 Coin/2 Credits",
	"2 Coins/5 Credits",
	"2 Coins/6 Credits",
	"1 Coin/3 Credits",
	"2 Coins/7 Credits",
	"2 Coins/8 Credits",
	"1 Coin/4 Credits",
	"1 Coin/5 Credits",
	"1 Coin/6 Credits",
	"1 Coin/7 Credits",
	"1 Coin/8 Credits",
	"1 Coin/9 Credits",
	"Free Play",
	"Cabinet",
	"Upright",
	"Cocktail",
	"Flip Screen",
	"Service Mode",
	"Pause",
	"Test",
	"Tilt",
	"Version",
	"Region",
	"International",
	"Japan",
	"USA",
	"Europe",
	"Asia",
	"World",
	"Hispanic",
	"Language",
	"English",
	"Japanese",
	"German",
	"French",
	"Italian",
	"Spanish",
	"Very Easy",
	"Easiest",
	"Easier",
	"Easy",
	"Normal",
	"Medium",
	"Hard",
	"Harder",
	"Hardest",
	"Very Hard",
	"Very Low",
	"Low",
	"High",
	"Higher",
	"Highest",
	"Very High",
	"Players",
	"Controls",
	"Dual",
	"Single",
	"Game Time",
	"Continue Price",
	"Controller",
	"Light Gun",
	"Joystick",
	"Trackball",
	"Continues",
	"Allow Continue",
	"Level Select",
	"Infinite",
	"Stereo",
	"Mono",
	"Unused",
	"Unknown",
	"Standard",
	"Reverse",
	"Alternate",
	"None"
#endif
};

struct ipd inputport_defaults[] =
{
#ifdef JAPANESE
	{ IPT_UI_CONFIGURE,         "ݒ胁j[",               SEQ_DEF_1(KEYCODE_TAB) },
	{ IPT_UI_ON_SCREEN_DISPLAY, "IXN[fBXvC", SEQ_DEF_1(KEYCODE_O) },
	{ IPT_UI_PAUSE,             "|[Y",                     SEQ_DEF_1(KEYCODE_P) },
	{ IPT_UI_RESET_MACHINE,     "Q[̃Zbg",           SEQ_DEF_3(KEYCODE_F3, CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_SHOW_GFX,          "OtBbNf[^\x95\x5c",     SEQ_DEF_3(KEYCODE_F4, CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_FRAMESKIP_DEC,     "t[XLbv",     SEQ_DEF_1(KEYCODE_F8) },
	{ IPT_UI_FRAMESKIP_INC,     "t[XLbv",     SEQ_DEF_1(KEYCODE_F9) },
	{ IPT_UI_THROTTLE,          "Xs[h L/",     SEQ_DEF_1(KEYCODE_F10) },
	{ IPT_UI_SHOW_FPS,          "FPS\x95\x5c",                  SEQ_DEF_5(KEYCODE_F11, CODE_NOT, KEYCODE_LCONTROL, CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_SHOW_PROFILER,     "vt@C\x95\x5c",           SEQ_DEF_2(KEYCODE_F11, KEYCODE_LSHIFT) },
#ifdef MESS
	{ IPT_UI_TOGGLE_UI,         "UI \x95\x5c؂ւ",            SEQ_DEF_1(KEYCODE_SCRLOCK) },
#endif
	{ IPT_UI_SNAPSHOT,          "XibvVbg̕ۑ",     SEQ_DEF_1(KEYCODE_F12) },
	{ IPT_UI_TOGGLE_CHEAT,      "`[g L/",           SEQ_DEF_3(KEYCODE_F6, CODE_NOT, KEYCODE_LSHIFT) },
#ifdef MAME32JP
	{ IPT_UI_TOGGLE_AUTOFIRE,   "A ؂ւ",              SEQ_DEF_1(KEYCODE_INSERT) },
	{ IPT_UI_TOGGLE_LOGWAVE,    "WAV^ Jn/~",          SEQ_DEF_0 },
	{ IPT_UI_COMMAND,           "R}h\x95\x5c",               SEQ_DEF_0 },
#endif
	{ IPT_UI_UP,                "UI ",                      SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP) },
	{ IPT_UI_DOWN,              "UI ",                      SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_UI_LEFT,              "UI ",                      SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT) },
	{ IPT_UI_RIGHT,             "UI E",                      SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT) },
	{ IPT_UI_SELECT,            "UI ",                    SEQ_DEF_3(KEYCODE_ENTER, CODE_OR, JOYCODE_1_BUTTON1) },
	{ IPT_UI_CANCEL,            "UI LZ",              SEQ_DEF_1(KEYCODE_ESC) },
#if 0
	{ IPT_UI_PAN_UP,            "ʂɈړ",             SEQ_DEF_3(KEYCODE_PGUP, CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_PAN_DOWN,          "ʂɈړ",             SEQ_DEF_3(KEYCODE_PGDN, CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_PAN_LEFT,          "ʂɈړ",             SEQ_DEF_2(KEYCODE_PGUP, KEYCODE_LSHIFT) },
	{ IPT_UI_PAN_RIGHT,         "ʂEɈړ",             SEQ_DEF_2(KEYCODE_PGDN, KEYCODE_LSHIFT) },
#endif
#ifdef MAME_DEBUG
	{ IPT_UI_TOGGLE_DEBUG,      "fobK\x95\x5c؂ւ",       SEQ_DEF_3(KEYCODE_F5, CODE_NOT, KEYCODE_LSHIFT) },
#endif
#ifdef KAILLERA

	{ IPT_UI_KAILLERA_PLAYER_INC,	"KailleravC[ʒuOi",	SEQ_DEF_2(KEYCODE_F5, KEYCODE_LSHIFT) }, //kt
	{ IPT_UI_KAILLERA_PLAYER_DEC,	"KailleravC[ʒu",	SEQ_DEF_2(KEYCODE_F6, KEYCODE_LSHIFT) }, //kt
//	{ IPT_UI_KAILLERA_PLAYER_2IN,	"Kaillera 2InputʒuύX",		SEQ_DEF_5(KEYCODE_F5 , CODE_NOT, KEYCODE_LSHIFT, CODE_NOT, KEYCODE_RSHIFT) },
//	{ IPT_UI_KAILLERA_PLAYER_POS,	"KailleraʒuړΏەύX",		SEQ_DEF_3(KEYCODE_F6 , CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_KAILLERA_PLAYER_DUP,	"Kailleradʒu̎gp",		SEQ_DEF_2(KEYCODE_F4, KEYCODE_LSHIFT) },

	{ IPT_UI_KAILLERA_TEST_1,"KailleraI[gZ[u",			SEQ_DEF_2(KEYCODE_F8, KEYCODE_LSHIFT) },
	{ IPT_UI_KAILLERA_TEST_2,"KailleraԒ߃xύX",		SEQ_DEF_3(KEYCODE_F9 , CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_KAILLERA_TEST_3,"Kaillerao[W`FbN",		SEQ_DEF_4(KEYCODE_F10, KEYCODE_LSHIFT, CODE_NOT, KEYCODE_RSHIFT) }, // mamẽo[W`FbN
	{ IPT_UI_KAILLERA_TEST_4,"KaillerafBbvXCb`M",	SEQ_DEF_2(KEYCODE_F3 , KEYCODE_LSHIFT) },
	{ IPT_UI_KAILLERA_TEST_7,"KailleraXbgI",			SEQ_DEF_2(KEYCODE_F9 , KEYCODE_LSHIFT) },
	{ IPT_UI_KAILLERA_TEST_8,"KailleraZ[uf[^M",	SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST_9,"KailleraZ[uf[^M",		SEQ_DEF_3(KEYCODE_F10, KEYCODE_LSHIFT , KEYCODE_RSHIFT) },


	{ IPT_UI_KAILLERA_TEST1_0,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST1_1,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST1_2,"Kaillera`FbN",		  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST1_3,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST2_4,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST2_5,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST2_6,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST2_7,"gp",						  SEQ_DEF_0 },
#ifdef USE_SHOW_TIME
	{ IPT_UI_KAILLERA_TEST2_0,"ݎԂ\x95\x5c",			  SEQ_DEF_0 },
#else
	{ IPT_UI_KAILLERA_TEST2_0,"gp",						  SEQ_DEF_0 },
#endif
#ifdef USE_SHOW_INPUT_LOG
	{ IPT_UI_KAILLERA_TEST2_1,"̓R}h\x95\x5c",		  SEQ_DEF_0 },
#else
	{ IPT_UI_KAILLERA_TEST2_1,"gp",						  SEQ_DEF_0 },
#endif
//	{ IPT_UI_KAILLERA_TEST2_2,"͂̕ۑ 蒼",		  SEQ_DEF_0 },
//	{ IPT_UI_KAILLERA_TEST2_3,"͂̍Č \x95\x5c",		  SEQ_DEF_0 },

//	{ IPT_UI_KAILLERA_TEST1_4,"ԑ Jn/~",			  SEQ_DEF_0 },
//	{ IPT_UI_KAILLERA_TEST1_5,"ԑ \x95\x5c",				  SEQ_DEF_0 },
//	{ IPT_UI_KAILLERA_TEST1_6,"debug_search_cpu",			  SEQ_DEF_2(KEYCODE_C, KEYCODE_RSHIFT) },
//	{ IPT_UI_KAILLERA_TEST1_6,"gp",						  SEQ_DEF_0 },
//	{ IPT_UI_KAILLERA_TEST1_7,"_Ox",			  SEQ_DEF_1(KEYCODE_F1) },
	{ IPT_UI_KAILLERA_TEST1_9,"`bg O",		  SEQ_DEF_2(KEYCODE_BACKSPACE , KEYCODE_RSHIFT) },

	{ IPT_UI_CHAT_OPEN,         "`bg J",                    SEQ_DEF_1(KEYCODE_HOME) },
//	{ IPT_UI_CHAT_CHANGE_MODE,  "`bg `惂[hύX",      SEQ_DEF_1(KEYCODE_NONE) },
	{ IPT_UI_CHAT_SHOW_LOG,     "`bg O\x95\x5c",        SEQ_DEF_1(KEYCODE_END) },
#endif /* KAILLERA */
	{ IPT_UI_SAVE_STATE,        "vCԂ̕ۑ",           SEQ_DEF_2(KEYCODE_F7, KEYCODE_LSHIFT) },
	{ IPT_UI_LOAD_STATE,        "vCԂ̕A",           SEQ_DEF_2(KEYCODE_F7, KEYCODE_RSHIFT) },
	{ IPT_UI_ADD_CHEAT,         "`[gǉ",                 SEQ_DEF_1(KEYCODE_A) },
	{ IPT_UI_DELETE_CHEAT,      "`[g폜",                 SEQ_DEF_1(KEYCODE_D) },
	{ IPT_UI_SAVE_CHEAT,        "`[gۑ",                 SEQ_DEF_1(KEYCODE_S) },
	{ IPT_UI_WATCH_VALUE,       "EHb`̒l\x95\x5c",           SEQ_DEF_1(KEYCODE_W) },
	{ IPT_UI_EDIT_CHEAT,		"`[gҏW",			SEQ_DEF_1(KEYCODE_E) },
	{ IPT_UI_TOGGLE_CROSSHAIR,	"\x8f\x5c̃gO",		SEQ_DEF_1(KEYCODE_F1) },
	{ IPT_START1, "1vC[ X^[g", SEQ_DEF_3(KEYCODE_1, CODE_OR, JOYCODE_1_START) },
	{ IPT_START2, "2vC[ X^[g", SEQ_DEF_3(KEYCODE_2, CODE_OR, JOYCODE_2_START) },
	{ IPT_START3, "3vC[ X^[g", SEQ_DEF_3(KEYCODE_3, CODE_OR, JOYCODE_3_START) },
	{ IPT_START4, "4vC[ X^[g", SEQ_DEF_3(KEYCODE_4, CODE_OR, JOYCODE_4_START) },
	{ IPT_COIN1,  "RC1",         SEQ_DEF_3(KEYCODE_5, CODE_OR, JOYCODE_1_SELECT) },
	{ IPT_COIN2,  "RC2",         SEQ_DEF_3(KEYCODE_6, CODE_OR, JOYCODE_2_SELECT) },
	{ IPT_COIN3,  "RC3",         SEQ_DEF_3(KEYCODE_7, CODE_OR, JOYCODE_3_SELECT) },
	{ IPT_COIN4,  "RC4",         SEQ_DEF_3(KEYCODE_8, CODE_OR, JOYCODE_4_SELECT) },
	{ IPT_SERVICE1, "T[rX1",     SEQ_DEF_1(KEYCODE_9) },
	{ IPT_SERVICE2, "T[rX2",     SEQ_DEF_1(KEYCODE_0) },
	{ IPT_SERVICE3, "T[rX3",     SEQ_DEF_1(KEYCODE_MINUS) },
	{ IPT_SERVICE4, "T[rX4",     SEQ_DEF_1(KEYCODE_EQUALS) },
	{ IPT_TILT,   "eBg",        SEQ_DEF_0 },

	{ IPT_JOYSTICK_UP         | IPF_PLAYER1, "P1 ",          SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP)    },
	{ IPT_JOYSTICK_DOWN       | IPF_PLAYER1, "P1 ",          SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN)  },
	{ IPT_JOYSTICK_LEFT       | IPF_PLAYER1, "P1 ",          SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT)  },
	{ IPT_JOYSTICK_RIGHT      | IPF_PLAYER1, "P1 E",          SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT) },
	{ IPT_BUTTON1             | IPF_PLAYER1, "P1 {^1",     SEQ_DEF_5(KEYCODE_LCONTROL, CODE_OR, JOYCODE_1_BUTTON1, CODE_OR, JOYCODE_MOUSE_1_BUTTON1) },
	{ IPT_BUTTON2             | IPF_PLAYER1, "P1 {^2",     SEQ_DEF_5(KEYCODE_LALT, CODE_OR, JOYCODE_1_BUTTON2, CODE_OR, JOYCODE_MOUSE_1_BUTTON3) },
	{ IPT_BUTTON3             | IPF_PLAYER1, "P1 {^3",     SEQ_DEF_5(KEYCODE_SPACE, CODE_OR, JOYCODE_1_BUTTON3, CODE_OR, JOYCODE_MOUSE_1_BUTTON2) },
	{ IPT_BUTTON4             | IPF_PLAYER1, "P1 {^4",     SEQ_DEF_3(KEYCODE_LSHIFT, CODE_OR, JOYCODE_1_BUTTON4) },
	{ IPT_BUTTON5             | IPF_PLAYER1, "P1 {^5",     SEQ_DEF_3(KEYCODE_Z, CODE_OR, JOYCODE_1_BUTTON5) },
	{ IPT_BUTTON6             | IPF_PLAYER1, "P1 {^6",     SEQ_DEF_3(KEYCODE_X, CODE_OR, JOYCODE_1_BUTTON6) },
	{ IPT_BUTTON7             | IPF_PLAYER1, "P1 {^7",     SEQ_DEF_3(KEYCODE_C, CODE_OR, JOYCODE_1_BUTTON7) },
	{ IPT_BUTTON8             | IPF_PLAYER1, "P1 {^8",     SEQ_DEF_3(KEYCODE_V, CODE_OR, JOYCODE_1_BUTTON8) },
	{ IPT_BUTTON9             | IPF_PLAYER1, "P1 {^9",     SEQ_DEF_3(KEYCODE_B, CODE_OR, JOYCODE_1_BUTTON9) },
	{ IPT_BUTTON10            | IPF_PLAYER1, "P1 {^10",    SEQ_DEF_1(KEYCODE_N) },
#ifdef USE_CUSTOM_BUTTON
	{ IPT_CUSTOM1             | IPF_PLAYER1, "P1 JX^ 1",    SEQ_DEF_0 },
	{ IPT_CUSTOM2             | IPF_PLAYER1, "P1 JX^ 2",    SEQ_DEF_0 },
	{ IPT_CUSTOM3             | IPF_PLAYER1, "P1 JX^ 3",    SEQ_DEF_0 },
	{ IPT_CUSTOM4             | IPF_PLAYER1, "P1 JX^ 4"   , SEQ_DEF_0 },
#endif /* USE_CUSTOM_BUTTON */
#ifdef MAME32JP
	{ IPT_NEOGEO1             | IPF_PLAYER1, "P1 A+B (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO2             | IPF_PLAYER1, "P1 A+C (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO3             | IPF_PLAYER1, "P1 A+D (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO4             | IPF_PLAYER1, "P1 B+C (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO5             | IPF_PLAYER1, "P1 B+D (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO6             | IPF_PLAYER1, "P1 C+D (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO7             | IPF_PLAYER1, "P1 A+B+C (Neo-Geo)",  SEQ_DEF_0 },
	{ IPT_NEOGEO8             | IPF_PLAYER1, "P1 A+B+D (Neo-Geo)",  SEQ_DEF_0 },
	{ IPT_NEOGEO9             | IPF_PLAYER1, "P1 B+C+D (Neo-Geo)",  SEQ_DEF_0 },
	{ IPT_NEOGEO10            | IPF_PLAYER1, "P1 A+B+C+D (Neo-Geo)",SEQ_DEF_0 },
	{ IPT_CPS1                | IPF_PLAYER1, "P1 p`~2 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS2                | IPF_PLAYER1, "P1 p`~3 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS3                | IPF_PLAYER1, "P1 LbN~2 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS4                | IPF_PLAYER1, "P1 LbN~3 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS5                | IPF_PLAYER1, "P1 {^1+2 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS6                | IPF_PLAYER1, "P1 {^2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS7                | IPF_PLAYER1, "P1 {^1+2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_SPEC                | IPF_PLAYER1, "P1 {^1+2",  SEQ_DEF_0 },
#endif
	{ IPT_JOYSTICKRIGHT_UP    | IPF_PLAYER1, "P1 Eo[/", SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_1_BUTTON2) },
	{ IPT_JOYSTICKRIGHT_DOWN  | IPF_PLAYER1, "P1 Eo[/", SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_1_BUTTON3) },
	{ IPT_JOYSTICKRIGHT_LEFT  | IPF_PLAYER1, "P1 Eo[/", SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_1_BUTTON1) },
	{ IPT_JOYSTICKRIGHT_RIGHT | IPF_PLAYER1, "P1 Eo[/E", SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_1_BUTTON4) },
	{ IPT_JOYSTICKLEFT_UP     | IPF_PLAYER1, "P1 o[/", SEQ_DEF_3(KEYCODE_E, CODE_OR, JOYCODE_1_UP) },
	{ IPT_JOYSTICKLEFT_DOWN   | IPF_PLAYER1, "P1 o[/", SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_JOYSTICKLEFT_LEFT   | IPF_PLAYER1, "P1 o[/", SEQ_DEF_3(KEYCODE_S, CODE_OR, JOYCODE_1_LEFT) },
	{ IPT_JOYSTICKLEFT_RIGHT  | IPF_PLAYER1, "P1 o[/E", SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_1_RIGHT) },

	{ IPT_JOYSTICK_UP         | IPF_PLAYER2, "P2 ",          SEQ_DEF_3(KEYCODE_R, CODE_OR, JOYCODE_2_UP)    },
	{ IPT_JOYSTICK_DOWN       | IPF_PLAYER2, "P2 ",          SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_2_DOWN)  },
	{ IPT_JOYSTICK_LEFT       | IPF_PLAYER2, "P2 ",          SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_2_LEFT)  },
	{ IPT_JOYSTICK_RIGHT      | IPF_PLAYER2, "P2 E",          SEQ_DEF_3(KEYCODE_G, CODE_OR, JOYCODE_2_RIGHT) },
	{ IPT_BUTTON1             | IPF_PLAYER2, "P2 {^1",     SEQ_DEF_3(KEYCODE_A, CODE_OR, JOYCODE_2_BUTTON1) },
	{ IPT_BUTTON2             | IPF_PLAYER2, "P2 {^2",     SEQ_DEF_3(KEYCODE_S, CODE_OR, JOYCODE_2_BUTTON2) },
	{ IPT_BUTTON3             | IPF_PLAYER2, "P2 {^3",     SEQ_DEF_3(KEYCODE_Q, CODE_OR, JOYCODE_2_BUTTON3) },
	{ IPT_BUTTON4             | IPF_PLAYER2, "P2 {^4",     SEQ_DEF_3(KEYCODE_W, CODE_OR, JOYCODE_2_BUTTON4) },
	{ IPT_BUTTON5             | IPF_PLAYER2, "P2 {^5",     SEQ_DEF_1(JOYCODE_2_BUTTON5) },
	{ IPT_BUTTON6             | IPF_PLAYER2, "P2 {^6",     SEQ_DEF_1(JOYCODE_2_BUTTON6) },
	{ IPT_BUTTON7             | IPF_PLAYER2, "P2 {^7",     SEQ_DEF_1(JOYCODE_2_BUTTON7) },
	{ IPT_BUTTON8             | IPF_PLAYER2, "P2 {^8",     SEQ_DEF_1(JOYCODE_2_BUTTON8) },
	{ IPT_BUTTON9             | IPF_PLAYER2, "P2 {^9",     SEQ_DEF_1(JOYCODE_2_BUTTON9) },
	{ IPT_BUTTON10            | IPF_PLAYER2, "P2 {^10",    SEQ_DEF_0 },
#ifdef USE_CUSTOM_BUTTON
	{ IPT_CUSTOM1             | IPF_PLAYER2, "P2 JX^ 1",    SEQ_DEF_0 },
	{ IPT_CUSTOM2             | IPF_PLAYER2, "P2 JX^ 2",    SEQ_DEF_0 },
	{ IPT_CUSTOM3             | IPF_PLAYER2, "P2 JX^ 3",    SEQ_DEF_0 },
	{ IPT_CUSTOM4             | IPF_PLAYER2, "P2 JX^ 4",    SEQ_DEF_0 },
#endif /* USE_CUSTOM_BUTTON */
#ifdef MAME32JP
	{ IPT_NEOGEO1             | IPF_PLAYER2, "P2 A+B (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO2             | IPF_PLAYER2, "P2 A+C (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO3             | IPF_PLAYER2, "P2 A+D (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO4             | IPF_PLAYER2, "P2 B+C (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO5             | IPF_PLAYER2, "P2 B+D (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO6             | IPF_PLAYER2, "P2 C+D (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO7             | IPF_PLAYER2, "P2 A+B+C (Neo-Geo)",  SEQ_DEF_0 },
	{ IPT_NEOGEO8             | IPF_PLAYER2, "P2 A+B+D (Neo-Geo)",  SEQ_DEF_0 },
	{ IPT_NEOGEO9             | IPF_PLAYER2, "P2 B+C+D (Neo-Geo)",  SEQ_DEF_0 },
	{ IPT_NEOGEO10            | IPF_PLAYER2, "P2 A+B+C+D (Neo-Geo)",SEQ_DEF_0 },
	{ IPT_CPS1                | IPF_PLAYER2, "P2 p`~2 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS2                | IPF_PLAYER2, "P2 p`~3 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS3                | IPF_PLAYER2, "P2 LbN~2 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS4                | IPF_PLAYER2, "P2 LbN~3 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS5                | IPF_PLAYER2, "P2 {^1+2 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS6                | IPF_PLAYER2, "P2 {^2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS7                | IPF_PLAYER2, "P2 {^1+2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_SPEC                | IPF_PLAYER2, "P2 {^1+2",  SEQ_DEF_0 },
#endif
	{ IPT_JOYSTICKRIGHT_UP    | IPF_PLAYER2, "P2 Eo[/", SEQ_DEF_0 },
	{ IPT_JOYSTICKRIGHT_DOWN  | IPF_PLAYER2, "P2 Eo[/", SEQ_DEF_0 },
	{ IPT_JOYSTICKRIGHT_LEFT  | IPF_PLAYER2, "P2 Eo[/", SEQ_DEF_0 },
	{ IPT_JOYSTICKRIGHT_RIGHT | IPF_PLAYER2, "P2 Eo[/E", SEQ_DEF_0 },
	{ IPT_JOYSTICKLEFT_UP     | IPF_PLAYER2, "P2 o[/", SEQ_DEF_0 },
	{ IPT_JOYSTICKLEFT_DOWN   | IPF_PLAYER2, "P2 o[/", SEQ_DEF_0 },
	{ IPT_JOYSTICKLEFT_LEFT   | IPF_PLAYER2, "P2 o[/", SEQ_DEF_0 },
	{ IPT_JOYSTICKLEFT_RIGHT  | IPF_PLAYER2, "P2 o[/E", SEQ_DEF_0 },

	{ IPT_JOYSTICK_UP         | IPF_PLAYER3, "P3 ",         SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_3_UP)    },
	{ IPT_JOYSTICK_DOWN       | IPF_PLAYER3, "P3 ",         SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_3_DOWN)  },
	{ IPT_JOYSTICK_LEFT       | IPF_PLAYER3, "P3 ",         SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_3_LEFT)  },
	{ IPT_JOYSTICK_RIGHT      | IPF_PLAYER3, "P3 E",         SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_3_RIGHT) },
	{ IPT_BUTTON1             | IPF_PLAYER3, "P3 {^1",    SEQ_DEF_3(KEYCODE_RCONTROL, CODE_OR, JOYCODE_3_BUTTON1) },
	{ IPT_BUTTON2             | IPF_PLAYER3, "P3 {^2",    SEQ_DEF_3(KEYCODE_RSHIFT, CODE_OR, JOYCODE_3_BUTTON2) },
	{ IPT_BUTTON3             | IPF_PLAYER3, "P3 {^3",    SEQ_DEF_3(KEYCODE_ENTER, CODE_OR, JOYCODE_3_BUTTON3) },
	{ IPT_BUTTON4             | IPF_PLAYER3, "P3 {^4",    SEQ_DEF_1(JOYCODE_3_BUTTON4) },

#ifdef USE_CUSTOM_BUTTON
	{ IPT_CUSTOM1             | IPF_PLAYER3, "P3 JX^ 1",    SEQ_DEF_0 },
	{ IPT_CUSTOM2             | IPF_PLAYER3, "P3 JX^ 2",    SEQ_DEF_0 },
	{ IPT_CUSTOM3             | IPF_PLAYER3, "P3 JX^ 3",    SEQ_DEF_0 },
	{ IPT_CUSTOM4             | IPF_PLAYER3, "P3 JX^ 4",    SEQ_DEF_0 },
#endif /* USE_CUSTOM_BUTTON */

#ifdef MAME32JP
	{ IPT_CPS5                | IPF_PLAYER3, "P3 {^1+2 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS6                | IPF_PLAYER3, "P3 {^2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS7                | IPF_PLAYER3, "P3 {^1+2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_SPEC                | IPF_PLAYER3, "P3 {^1+2",  SEQ_DEF_0 },
#endif
	{ IPT_JOYSTICK_UP         | IPF_PLAYER4, "P4 ",         SEQ_DEF_1(JOYCODE_4_UP) },
	{ IPT_JOYSTICK_DOWN       | IPF_PLAYER4, "P4 ",         SEQ_DEF_1(JOYCODE_4_DOWN) },
	{ IPT_JOYSTICK_LEFT       | IPF_PLAYER4, "P4 ",         SEQ_DEF_1(JOYCODE_4_LEFT) },
	{ IPT_JOYSTICK_RIGHT      | IPF_PLAYER4, "P4 E",         SEQ_DEF_1(JOYCODE_4_RIGHT) },
	{ IPT_BUTTON1             | IPF_PLAYER4, "P4 {^1",    SEQ_DEF_1(JOYCODE_4_BUTTON1) },
	{ IPT_BUTTON2             | IPF_PLAYER4, "P4 {^2",    SEQ_DEF_1(JOYCODE_4_BUTTON2) },
	{ IPT_BUTTON3             | IPF_PLAYER4, "P4 {^3",    SEQ_DEF_1(JOYCODE_4_BUTTON3) },
	{ IPT_BUTTON4             | IPF_PLAYER4, "P4 {^4",    SEQ_DEF_1(JOYCODE_4_BUTTON4) },

#ifdef USE_CUSTOM_BUTTON
	{ IPT_CUSTOM1             | IPF_PLAYER4, "P4 JX^ 1",    SEQ_DEF_0 },
	{ IPT_CUSTOM2             | IPF_PLAYER4, "P4 JX^ 2",    SEQ_DEF_0 },
	{ IPT_CUSTOM3             | IPF_PLAYER4, "P4 JX^ 3",    SEQ_DEF_0 },
	{ IPT_CUSTOM4             | IPF_PLAYER4, "P4 JX^ 4",    SEQ_DEF_0 },
#endif /* USE_CUSTOM_BUTTON */

#ifdef MAME32JP
	{ IPT_CPS5                | IPF_PLAYER4, "P4 {^1+2 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS6                | IPF_PLAYER4, "P4 {^2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS7                | IPF_PLAYER4, "P4 {^1+2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_SPEC                | IPF_PLAYER4, "P4 {^1+2",  SEQ_DEF_0 },
#endif
	{ IPT_PEDAL	                | IPF_PLAYER1, "P1y_ 1",        SEQ_DEF_3(KEYCODE_LCONTROL, CODE_OR, JOYCODE_1_BUTTON1) },
	{ (IPT_PEDAL+IPT_EXTENSION) | IPF_PLAYER1, "P1 [X <Y/N>", SEQ_DEF_1(KEYCODE_Y) },
	{ IPT_PEDAL                 | IPF_PLAYER2, "P2y_ 1",        SEQ_DEF_3(KEYCODE_A, CODE_OR, JOYCODE_2_BUTTON1) },
	{ (IPT_PEDAL+IPT_EXTENSION) | IPF_PLAYER2, "P2 [X <Y/N>", SEQ_DEF_1(KEYCODE_Y) },
	{ IPT_PEDAL                 | IPF_PLAYER3, "P3y_ 1",        SEQ_DEF_3(KEYCODE_RCONTROL, CODE_OR, JOYCODE_3_BUTTON1) },
	{ (IPT_PEDAL+IPT_EXTENSION) | IPF_PLAYER3, "P3 [X <Y/N>", SEQ_DEF_1(KEYCODE_Y) },
	{ IPT_PEDAL                 | IPF_PLAYER4, "P4y_ 1",        SEQ_DEF_1(JOYCODE_4_BUTTON1) },
	{ (IPT_PEDAL+IPT_EXTENSION) | IPF_PLAYER4, "P4 [X <Y/N>", SEQ_DEF_1(KEYCODE_Y) },

	{ IPT_PEDAL2	                | IPF_PLAYER1, "P1y_ 2",     SEQ_DEF_1(JOYCODE_1_DOWN) },
	{ (IPT_PEDAL2+IPT_EXTENSION) | IPF_PLAYER1, "P1 [X <Y/N>", SEQ_DEF_1(KEYCODE_Y) },
	{ IPT_PEDAL2                 | IPF_PLAYER2, "P2y_ 2",        SEQ_DEF_1(JOYCODE_2_DOWN) },
	{ (IPT_PEDAL2+IPT_EXTENSION) | IPF_PLAYER2, "P2 [X <Y/N>", SEQ_DEF_1(KEYCODE_Y) },
	{ IPT_PEDAL2                 | IPF_PLAYER3, "P3y_ 2",        SEQ_DEF_1(JOYCODE_3_DOWN) },
	{ (IPT_PEDAL2+IPT_EXTENSION) | IPF_PLAYER3, "P3 [X <Y/N>", SEQ_DEF_1(KEYCODE_Y) },
	{ IPT_PEDAL2                 | IPF_PLAYER4, "P4y_ 2",        SEQ_DEF_1(JOYCODE_4_DOWN) },
	{ (IPT_PEDAL2+IPT_EXTENSION) | IPF_PLAYER4, "P4 [X <Y/N>", SEQ_DEF_1(KEYCODE_Y) },

	{ IPT_PADDLE | IPF_PLAYER1,  "ph",        SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT) },
	{ (IPT_PADDLE | IPF_PLAYER1)+IPT_EXTENSION,             "ph",        SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT)  },
	{ IPT_PADDLE | IPF_PLAYER2,  "ph 2",      SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_2_LEFT) },
	{ (IPT_PADDLE | IPF_PLAYER2)+IPT_EXTENSION,             "ph 2",      SEQ_DEF_3(KEYCODE_G, CODE_OR, JOYCODE_2_RIGHT) },
	{ IPT_PADDLE | IPF_PLAYER3,  "ph 3",      SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_3_LEFT) },
	{ (IPT_PADDLE | IPF_PLAYER3)+IPT_EXTENSION,             "ph 3",      SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_3_RIGHT) },
	{ IPT_PADDLE | IPF_PLAYER4,  "ph 4",      SEQ_DEF_1(JOYCODE_4_LEFT) },
	{ (IPT_PADDLE | IPF_PLAYER4)+IPT_EXTENSION,             "ph 4",      SEQ_DEF_1(JOYCODE_4_RIGHT) },
	{ IPT_PADDLE_V | IPF_PLAYER1,  "ph V",          SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP) },
	{ (IPT_PADDLE_V | IPF_PLAYER1)+IPT_EXTENSION,             "ph V",          SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_PADDLE_V | IPF_PLAYER2,  "ph V 2",        SEQ_DEF_3(KEYCODE_R, CODE_OR, JOYCODE_2_UP) },
	{ (IPT_PADDLE_V | IPF_PLAYER2)+IPT_EXTENSION,             "ph V 2",      SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_2_DOWN) },
	{ IPT_PADDLE_V | IPF_PLAYER3,  "ph V 3",        SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_3_UP) },
	{ (IPT_PADDLE_V | IPF_PLAYER3)+IPT_EXTENSION,             "ph V 3",      SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_3_DOWN) },
	{ IPT_PADDLE_V | IPF_PLAYER4,  "ph V 4",        SEQ_DEF_1(JOYCODE_4_UP) },
	{ (IPT_PADDLE_V | IPF_PLAYER4)+IPT_EXTENSION,             "ph V 4",      SEQ_DEF_1(JOYCODE_4_DOWN) },
	{ IPT_DIAL | IPF_PLAYER1,    "_CA",          SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT) },
	{ (IPT_DIAL | IPF_PLAYER1)+IPT_EXTENSION,               "_CA",          SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT) },
	{ IPT_DIAL | IPF_PLAYER2,    "_CA 2",        SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_2_LEFT) },
	{ (IPT_DIAL | IPF_PLAYER2)+IPT_EXTENSION,               "_CA 2",      SEQ_DEF_3(KEYCODE_G, CODE_OR, JOYCODE_2_RIGHT) },
	{ IPT_DIAL | IPF_PLAYER3,    "_CA 3",        SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_3_LEFT) },
	{ (IPT_DIAL | IPF_PLAYER3)+IPT_EXTENSION,               "_CA 3",      SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_3_RIGHT) },
	{ IPT_DIAL | IPF_PLAYER4,    "_CA 4",        SEQ_DEF_1(JOYCODE_4_LEFT) },
	{ (IPT_DIAL | IPF_PLAYER4)+IPT_EXTENSION,               "_CA 4",      SEQ_DEF_1(JOYCODE_4_RIGHT) },
	{ IPT_DIAL_V | IPF_PLAYER1,  "_CA V",          SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP) },
	{ (IPT_DIAL_V | IPF_PLAYER1)+IPT_EXTENSION,             "_CA V",          SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_DIAL_V | IPF_PLAYER2,  "_CA V 2",        SEQ_DEF_3(KEYCODE_R, CODE_OR, JOYCODE_2_UP) },
	{ (IPT_DIAL_V | IPF_PLAYER2)+IPT_EXTENSION,             "_CA V 2",      SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_2_DOWN) },
	{ IPT_DIAL_V | IPF_PLAYER3,  "_CA V 3",        SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_3_UP) },
	{ (IPT_DIAL_V | IPF_PLAYER3)+IPT_EXTENSION,             "_CA V 3",      SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_3_DOWN) },
	{ IPT_DIAL_V | IPF_PLAYER4,  "_CA V 4",        SEQ_DEF_1(JOYCODE_4_UP) },
	{ (IPT_DIAL_V | IPF_PLAYER4)+IPT_EXTENSION,             "_CA V 4",      SEQ_DEF_1(JOYCODE_4_DOWN) },

	{ IPT_TRACKBALL_X | IPF_PLAYER1, "gbN X",   SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT) },
	{ (IPT_TRACKBALL_X | IPF_PLAYER1)+IPT_EXTENSION,                 "gbN X",   SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT) },
	{ IPT_TRACKBALL_X | IPF_PLAYER2, "gbN X 2", SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_2_LEFT) },
	{ (IPT_TRACKBALL_X | IPF_PLAYER2)+IPT_EXTENSION,                 "gbN X 2", SEQ_DEF_3(KEYCODE_G, CODE_OR, JOYCODE_2_RIGHT) },
	{ IPT_TRACKBALL_X | IPF_PLAYER3, "gbN X 3", SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_3_LEFT) },
	{ (IPT_TRACKBALL_X | IPF_PLAYER3)+IPT_EXTENSION,                 "gbN X 3", SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_3_RIGHT) },
	{ IPT_TRACKBALL_X | IPF_PLAYER4, "gbN X 4", SEQ_DEF_1(JOYCODE_4_LEFT) },
	{ (IPT_TRACKBALL_X | IPF_PLAYER4)+IPT_EXTENSION,                 "gbN X 4", SEQ_DEF_1(JOYCODE_4_RIGHT) },

	{ IPT_TRACKBALL_Y | IPF_PLAYER1, "gbN Y",   SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP) },
	{ (IPT_TRACKBALL_Y | IPF_PLAYER1)+IPT_EXTENSION,                 "gbN Y",   SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_TRACKBALL_Y | IPF_PLAYER2, "gbN Y 2", SEQ_DEF_3(KEYCODE_R, CODE_OR, JOYCODE_2_UP) },
	{ (IPT_TRACKBALL_Y | IPF_PLAYER2)+IPT_EXTENSION,                 "gbN Y 2", SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_2_DOWN) },
	{ IPT_TRACKBALL_Y | IPF_PLAYER3, "gbN Y 3", SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_3_UP) },
	{ (IPT_TRACKBALL_Y | IPF_PLAYER3)+IPT_EXTENSION,                 "gbN Y 3", SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_3_DOWN) },
	{ IPT_TRACKBALL_Y | IPF_PLAYER4, "gbN Y 4", SEQ_DEF_1(JOYCODE_4_UP) },
	{ (IPT_TRACKBALL_Y | IPF_PLAYER4)+IPT_EXTENSION,                 "gbN Y 4", SEQ_DEF_1(JOYCODE_4_DOWN) },

	{ IPT_AD_STICK_X | IPF_PLAYER1, "AD XeBbN X",   SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT) },
	{ (IPT_AD_STICK_X | IPF_PLAYER1)+IPT_EXTENSION,                "AD XeBbN X",   SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT) },
	{ IPT_AD_STICK_X | IPF_PLAYER2, "AD XeBbN X 2", SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_2_LEFT) },
	{ (IPT_AD_STICK_X | IPF_PLAYER2)+IPT_EXTENSION,                "AD XeBbN X 2", SEQ_DEF_3(KEYCODE_G, CODE_OR, JOYCODE_2_RIGHT) },
	{ IPT_AD_STICK_X | IPF_PLAYER3, "AD XeBbN X 3", SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_3_LEFT) },
	{ (IPT_AD_STICK_X | IPF_PLAYER3)+IPT_EXTENSION,                "AD XeBbN X 3", SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_3_RIGHT) },
	{ IPT_AD_STICK_X | IPF_PLAYER4, "AD XeBbN X 4", SEQ_DEF_1(JOYCODE_4_LEFT) },
	{ (IPT_AD_STICK_X | IPF_PLAYER4)+IPT_EXTENSION,                "AD XeBbN X 4", SEQ_DEF_1(JOYCODE_4_RIGHT) },

	{ IPT_AD_STICK_Y | IPF_PLAYER1, "AD XeBbN Y",   SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP) },
	{ (IPT_AD_STICK_Y | IPF_PLAYER1)+IPT_EXTENSION,                "AD XeBbN Y",   SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_AD_STICK_Y | IPF_PLAYER2, "AD XeBbN Y 2", SEQ_DEF_3(KEYCODE_R, CODE_OR, JOYCODE_2_UP) },
	{ (IPT_AD_STICK_Y | IPF_PLAYER2)+IPT_EXTENSION,                "AD XeBbN Y 2", SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_2_DOWN) },
	{ IPT_AD_STICK_Y | IPF_PLAYER3, "AD XeBbN Y 3", SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_3_UP) },
	{ (IPT_AD_STICK_Y | IPF_PLAYER3)+IPT_EXTENSION,                "AD XeBbN Y 3", SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_3_DOWN) },
	{ IPT_AD_STICK_Y | IPF_PLAYER4, "AD XeBbN Y 4", SEQ_DEF_1(JOYCODE_4_UP) },
	{ (IPT_AD_STICK_Y | IPF_PLAYER4)+IPT_EXTENSION,                "AD XeBbN Y 4", SEQ_DEF_1(JOYCODE_4_DOWN) },

	{ IPT_AD_STICK_Z | IPF_PLAYER1, "AD XeBbN Z",   SEQ_DEF_0 },
	{ (IPT_AD_STICK_Z | IPF_PLAYER1)+IPT_EXTENSION,                "AD XeBbN Z",   SEQ_DEF_0 },
	{ IPT_AD_STICK_Z | IPF_PLAYER2, "AD XeBbN Z 2", SEQ_DEF_0 },
	{ (IPT_AD_STICK_Z | IPF_PLAYER2)+IPT_EXTENSION,                "AD XeBbN Z 2", SEQ_DEF_0 },
	{ IPT_AD_STICK_Z | IPF_PLAYER3, "AD XeBbN Z 3", SEQ_DEF_0 },
	{ (IPT_AD_STICK_Z | IPF_PLAYER3)+IPT_EXTENSION,                "AD XeBbN Z 3", SEQ_DEF_0 },
	{ IPT_AD_STICK_Z | IPF_PLAYER4, "AD XeBbN Z 4", SEQ_DEF_0 },
	{ (IPT_AD_STICK_Z | IPF_PLAYER4)+IPT_EXTENSION,                "AD XeBbN Z 4", SEQ_DEF_0 },

	{ IPT_LIGHTGUN_X | IPF_PLAYER1, "e X",   SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT) },
	{ (IPT_LIGHTGUN_X | IPF_PLAYER1)+IPT_EXTENSION,                "e X",   SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT) },
	{ IPT_LIGHTGUN_X | IPF_PLAYER2, "e X 2", SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_2_LEFT) },
	{ (IPT_LIGHTGUN_X | IPF_PLAYER2)+IPT_EXTENSION,                "e X 2", SEQ_DEF_3(KEYCODE_G, CODE_OR, JOYCODE_2_RIGHT) },
	{ IPT_LIGHTGUN_X | IPF_PLAYER3, "e X 3", SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_3_LEFT) },
	{ (IPT_LIGHTGUN_X | IPF_PLAYER3)+IPT_EXTENSION,                "e X 3", SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_3_RIGHT) },
	{ IPT_LIGHTGUN_X | IPF_PLAYER4, "e X 4", SEQ_DEF_1(JOYCODE_4_LEFT) },
	{ (IPT_LIGHTGUN_X | IPF_PLAYER4)+IPT_EXTENSION,                "e X 4", SEQ_DEF_1(JOYCODE_4_RIGHT) },

	{ IPT_LIGHTGUN_Y | IPF_PLAYER1, "e Y",   SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP) },
	{ (IPT_LIGHTGUN_Y | IPF_PLAYER1)+IPT_EXTENSION,                "e Y",   SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_LIGHTGUN_Y | IPF_PLAYER2, "e Y 2", SEQ_DEF_3(KEYCODE_R, CODE_OR, JOYCODE_2_UP) },
	{ (IPT_LIGHTGUN_Y | IPF_PLAYER2)+IPT_EXTENSION,                "e Y 2", SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_2_DOWN) },
	{ IPT_LIGHTGUN_Y | IPF_PLAYER3, "e Y 3", SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_3_UP) },
	{ (IPT_LIGHTGUN_Y | IPF_PLAYER3)+IPT_EXTENSION,                "e Y 3", SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_3_DOWN) },
	{ IPT_LIGHTGUN_Y | IPF_PLAYER4, "e Y 4", SEQ_DEF_1(JOYCODE_4_UP) },
	{ (IPT_LIGHTGUN_Y | IPF_PLAYER4)+IPT_EXTENSION,                "e Y 4", SEQ_DEF_1(JOYCODE_4_DOWN) },

	{ IPT_UNKNOWN,             "s",            SEQ_DEF_0 },
	{ IPT_UI_BOOST,             "^[{u[Xg",                   SEQ_DEF_0 },
	{ IPT_UI_CHEAT_LIST,        "`[gXg\x95\x5c",               SEQ_DEF_0 }, // CHEAT_LIST
	{ IPT_OSD_RESERVED,        "",                SEQ_DEF_0 },
	{ IPT_OSD_RESERVED,        "",                SEQ_DEF_0 },
	{ IPT_END,                 0,                 SEQ_DEF_0 }	/* returned when there is no match */
#else
	{ IPT_UI_CONFIGURE,         "Config Menu",			SEQ_DEF_1(KEYCODE_TAB) },
	{ IPT_UI_ON_SCREEN_DISPLAY, "On Screen Display",	SEQ_DEF_1(KEYCODE_O) },
	{ IPT_UI_PAUSE,             "Pause",				SEQ_DEF_1(KEYCODE_P) },
	{ IPT_UI_RESET_MACHINE,     "Reset Game",			SEQ_DEF_3(KEYCODE_F3, CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_SHOW_GFX,          "Show Gfx",				SEQ_DEF_1(KEYCODE_F4) },
	{ IPT_UI_FRAMESKIP_DEC,     "Frameskip Dec",		SEQ_DEF_1(KEYCODE_F8) },
	{ IPT_UI_FRAMESKIP_INC,     "Frameskip Inc",		SEQ_DEF_1(KEYCODE_F9) },
	{ IPT_UI_THROTTLE,          "Throttle",				SEQ_DEF_1(KEYCODE_F10) },
	{ IPT_UI_SHOW_FPS,          "Show FPS",				SEQ_DEF_5(KEYCODE_F11, CODE_NOT, KEYCODE_LCONTROL, CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_SHOW_PROFILER,     "Show Profiler",		SEQ_DEF_2(KEYCODE_F11, KEYCODE_LSHIFT) },
#ifdef MESS
	{ IPT_UI_TOGGLE_UI,         "UI Toggle",			SEQ_DEF_1(KEYCODE_SCRLOCK) },
#endif
	{ IPT_UI_SNAPSHOT,          "Save Snapshot",		SEQ_DEF_1(KEYCODE_F12) },
	{ IPT_UI_TOGGLE_CHEAT,      "Toggle Cheat",			SEQ_DEF_1(KEYCODE_F6) },
#ifdef MAME32JP
	{ IPT_UI_TOGGLE_AUTOFIRE,   "Toggle Autofire",      SEQ_DEF_1(KEYCODE_INSERT) },
	{ IPT_UI_TOGGLE_LOGWAVE,    "Toggle Log Wave",      SEQ_DEF_1(KEYCODE_DEL) },
	{ IPT_UI_COMMAND,           "Show Command",         SEQ_DEF_1(KEYCODE_END) },
#endif
#ifdef KAILLERA

	{ IPT_UI_KAILLERA_PLAYER_INC,	"KailleravC[ʒuOi",	SEQ_DEF_2(KEYCODE_F5, KEYCODE_LSHIFT) }, //kt
	{ IPT_UI_KAILLERA_PLAYER_DEC,	"KailleravC[ʒu",	SEQ_DEF_2(KEYCODE_F6, KEYCODE_LSHIFT) }, //kt
//	{ IPT_UI_KAILLERA_PLAYER_2IN,	"Kaillera 2InputʒuύX",		SEQ_DEF_5(KEYCODE_F5 , CODE_NOT, KEYCODE_LSHIFT, CODE_NOT, KEYCODE_RSHIFT) },
	{ IPT_UI_KAILLERA_PLAYER_POS,	"KailleraʒuړΏەύX",		SEQ_DEF_3(KEYCODE_F6 , CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_KAILLERA_PLAYER_DUP,	"Kailleradʒu̎gp",		SEQ_DEF_2(KEYCODE_F4, KEYCODE_LSHIFT) },

	{ IPT_UI_KAILLERA_TEST_1,"KailleraI[gZ[u",			SEQ_DEF_2(KEYCODE_F8, KEYCODE_LSHIFT) },
	{ IPT_UI_KAILLERA_TEST_2,"KailleraԒ߃xύX",		SEQ_DEF_3(KEYCODE_F9 , CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_KAILLERA_TEST_3,"Kaillerao[W`FbN",		SEQ_DEF_4(KEYCODE_F10, KEYCODE_LSHIFT, CODE_NOT, KEYCODE_RSHIFT) }, // mamẽo[W`FbN
	{ IPT_UI_KAILLERA_TEST_4,"KaillerafBbvXCb`M",	SEQ_DEF_2(KEYCODE_F3 , KEYCODE_LSHIFT) },
	{ IPT_UI_KAILLERA_TEST_7,"KailleraXbgI",			SEQ_DEF_2(KEYCODE_F9 , KEYCODE_LSHIFT) },
	{ IPT_UI_KAILLERA_TEST_8,"KailleraZ[uf[^M",	SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST_9,"KailleraZ[uf[^M",		SEQ_DEF_3(KEYCODE_F10, KEYCODE_LSHIFT , KEYCODE_RSHIFT) },


	{ IPT_UI_KAILLERA_TEST1_0,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST1_1,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST1_2,"Kaillera`FbN",		  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST1_3,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST2_4,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST2_5,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST2_6,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST2_7,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST2_0,"gp",						  SEQ_DEF_0 },
	{ IPT_UI_KAILLERA_TEST2_1,"gp",						  SEQ_DEF_0 },
//	{ IPT_UI_KAILLERA_TEST2_2,"͂̕ۑ 蒼",		  SEQ_DEF_0 },
//	{ IPT_UI_KAILLERA_TEST2_3,"͂̍Č \x95\x5c",		  SEQ_DEF_0 },

//	{ IPT_UI_KAILLERA_TEST1_4,"ԑ Jn/~",			  SEQ_DEF_0 },
//	{ IPT_UI_KAILLERA_TEST1_5,"ԑ \x95\x5c",				  SEQ_DEF_0 },
//	{ IPT_UI_KAILLERA_TEST1_6,"debug_search_cpu",			  SEQ_DEF_2(KEYCODE_C, KEYCODE_RSHIFT) },
	{ IPT_UI_KAILLERA_TEST1_6,"gp",						  SEQ_DEF_0 },
//	{ IPT_UI_KAILLERA_TEST1_7,"_Ox",			  SEQ_DEF_1(KEYCODE_F1) },
	{ IPT_UI_KAILLERA_TEST1_9,"`bg O",		  SEQ_DEF_2(KEYCODE_BACKSPACE , KEYCODE_RSHIFT) },

	{ IPT_UI_CHAT_OPEN,         "Kaillera Chat Open",   SEQ_DEF_1(KEYCODE_NONE) },
	{ IPT_UI_CHAT_CHANGE_MODE,  "Kaillera Chat Change Draw Mode", SEQ_DEF_1(KEYCODE_NONE) },
	{ IPT_UI_CHAT_SHOW_LOG,     "Kaillera Chat Show Chat Log", SEQ_DEF_1(KEYCODE_NONE) },
#endif /* KAILLERA */
	{ IPT_UI_UP,                "UI Up",				SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP) },
	{ IPT_UI_DOWN,              "UI Down",				SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_UI_LEFT,              "UI Left",				SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT) },
	{ IPT_UI_RIGHT,             "UI Right",				SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT) },
	{ IPT_UI_SELECT,            "UI Select",			SEQ_DEF_3(KEYCODE_ENTER, CODE_OR, JOYCODE_1_BUTTON1) },
	{ IPT_UI_CANCEL,            "UI Cancel",			SEQ_DEF_1(KEYCODE_ESC) },
	{ IPT_UI_PAN_UP,            "Pan Up",				SEQ_DEF_3(KEYCODE_PGUP, CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_PAN_DOWN,          "Pan Down",				SEQ_DEF_3(KEYCODE_PGDN, CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_PAN_LEFT,          "Pan Left",				SEQ_DEF_2(KEYCODE_PGUP, KEYCODE_LSHIFT) },
	{ IPT_UI_PAN_RIGHT,         "Pan Right",			SEQ_DEF_2(KEYCODE_PGDN, KEYCODE_LSHIFT) },
	{ IPT_UI_TOGGLE_DEBUG,      "Toggle Debugger",		SEQ_DEF_1(KEYCODE_F5) },
	{ IPT_UI_SAVE_STATE,        "Save State",			SEQ_DEF_2(KEYCODE_F7, KEYCODE_LSHIFT) },
	{ IPT_UI_LOAD_STATE,        "Load State",			SEQ_DEF_3(KEYCODE_F7, CODE_NOT, KEYCODE_LSHIFT) },
	{ IPT_UI_ADD_CHEAT,			"Add Cheat",			SEQ_DEF_1(KEYCODE_A) },
	{ IPT_UI_DELETE_CHEAT,		"Delete Cheat",			SEQ_DEF_1(KEYCODE_D) },
	{ IPT_UI_SAVE_CHEAT,		"Save Cheat",			SEQ_DEF_1(KEYCODE_S) },
	{ IPT_UI_WATCH_VALUE,		"Watch Value",			SEQ_DEF_1(KEYCODE_W) },
	{ IPT_UI_EDIT_CHEAT,		"Edit Cheat",			SEQ_DEF_1(KEYCODE_E) },
	{ IPT_UI_TOGGLE_CROSSHAIR,	"Toggle Crosshair",		SEQ_DEF_1(KEYCODE_F1) },
	{ IPT_START1, "1 Player Start",  SEQ_DEF_3(KEYCODE_1, CODE_OR, JOYCODE_1_START) },
	{ IPT_START2, "2 Players Start", SEQ_DEF_3(KEYCODE_2, CODE_OR, JOYCODE_2_START) },
	{ IPT_START3, "3 Players Start", SEQ_DEF_3(KEYCODE_3, CODE_OR, JOYCODE_3_START) },
	{ IPT_START4, "4 Players Start", SEQ_DEF_3(KEYCODE_4, CODE_OR, JOYCODE_4_START) },
	{ IPT_COIN1,  "Coin 1",          SEQ_DEF_3(KEYCODE_5, CODE_OR, JOYCODE_1_SELECT) },
	{ IPT_COIN2,  "Coin 2",          SEQ_DEF_3(KEYCODE_6, CODE_OR, JOYCODE_2_SELECT) },
	{ IPT_COIN3,  "Coin 3",          SEQ_DEF_3(KEYCODE_7, CODE_OR, JOYCODE_3_SELECT) },
	{ IPT_COIN4,  "Coin 4",          SEQ_DEF_3(KEYCODE_8, CODE_OR, JOYCODE_4_SELECT) },
	{ IPT_SERVICE1, "Service 1",     SEQ_DEF_1(KEYCODE_9) },
	{ IPT_SERVICE2, "Service 2",     SEQ_DEF_1(KEYCODE_0) },
	{ IPT_SERVICE3, "Service 3",     SEQ_DEF_1(KEYCODE_MINUS) },
	{ IPT_SERVICE4, "Service 4",     SEQ_DEF_1(KEYCODE_EQUALS) },
	{ IPT_TILT,   "Tilt",            SEQ_DEF_0 },

	{ IPT_JOYSTICK_UP         | IPF_PLAYER1, "P1 Up",          SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP)    },
	{ IPT_JOYSTICK_DOWN       | IPF_PLAYER1, "P1 Down",        SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN)  },
	{ IPT_JOYSTICK_LEFT       | IPF_PLAYER1, "P1 Left",        SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT)  },
	{ IPT_JOYSTICK_RIGHT      | IPF_PLAYER1, "P1 Right",       SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT) },
	{ IPT_BUTTON1             | IPF_PLAYER1, "P1 Button 1",    SEQ_DEF_5(KEYCODE_LCONTROL, CODE_OR, JOYCODE_1_BUTTON1, CODE_OR, JOYCODE_MOUSE_1_BUTTON1) },
	{ IPT_BUTTON2             | IPF_PLAYER1, "P1 Button 2",    SEQ_DEF_5(KEYCODE_LALT, CODE_OR, JOYCODE_1_BUTTON2, CODE_OR, JOYCODE_MOUSE_1_BUTTON3) },
	{ IPT_BUTTON3             | IPF_PLAYER1, "P1 Button 3",    SEQ_DEF_5(KEYCODE_SPACE, CODE_OR, JOYCODE_1_BUTTON3, CODE_OR, JOYCODE_MOUSE_1_BUTTON2) },
	{ IPT_BUTTON4             | IPF_PLAYER1, "P1 Button 4",    SEQ_DEF_3(KEYCODE_LSHIFT, CODE_OR, JOYCODE_1_BUTTON4) },
	{ IPT_BUTTON5             | IPF_PLAYER1, "P1 Button 5",    SEQ_DEF_3(KEYCODE_Z, CODE_OR, JOYCODE_1_BUTTON5) },
	{ IPT_BUTTON6             | IPF_PLAYER1, "P1 Button 6",    SEQ_DEF_3(KEYCODE_X, CODE_OR, JOYCODE_1_BUTTON6) },
	{ IPT_BUTTON7             | IPF_PLAYER1, "P1 Button 7",    SEQ_DEF_1(KEYCODE_C) },
	{ IPT_BUTTON8             | IPF_PLAYER1, "P1 Button 8",    SEQ_DEF_1(KEYCODE_V) },
	{ IPT_BUTTON9             | IPF_PLAYER1, "P1 Button 9",    SEQ_DEF_1(KEYCODE_B) },
	{ IPT_BUTTON10            | IPF_PLAYER1, "P1 Button 10",   SEQ_DEF_1(KEYCODE_N) },

#ifdef USE_CUSTOM_BUTTON
	{ IPT_CUSTOM1             | IPF_PLAYER1, "P1 Custom 1",    SEQ_DEF_0 },
	{ IPT_CUSTOM2             | IPF_PLAYER1, "P1 Custom 2",    SEQ_DEF_0 },
	{ IPT_CUSTOM3             | IPF_PLAYER1, "P1 Custom 3",    SEQ_DEF_0 },
	{ IPT_CUSTOM4             | IPF_PLAYER1, "P1 Custom 4"   , SEQ_DEF_0 },
#endif /* USE_CUSTOM_BUTTON */

#ifdef MAME32JP
	{ IPT_NEOGEO1             | IPF_PLAYER1, "P1 A+B (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO2             | IPF_PLAYER1, "P1 A+C (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO3             | IPF_PLAYER1, "P1 A+D (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO4             | IPF_PLAYER1, "P1 B+C (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO5             | IPF_PLAYER1, "P1 B+D (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO6             | IPF_PLAYER1, "P1 C+D (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO7             | IPF_PLAYER1, "P1 A+B+C (Neo-Geo)",  SEQ_DEF_0 },
	{ IPT_NEOGEO8             | IPF_PLAYER1, "P1 A+B+D (Neo-Geo)",  SEQ_DEF_0 },
	{ IPT_NEOGEO9             | IPF_PLAYER1, "P1 B+C+D (Neo-Geo)",  SEQ_DEF_0 },
	{ IPT_NEOGEO10            | IPF_PLAYER1, "P1 A+B+C+D (Neo-Geo)",SEQ_DEF_0 },
	{ IPT_CPS1                | IPF_PLAYER1, "P1 2 Punches (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS2                | IPF_PLAYER1, "P1 3 Punches (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS3                | IPF_PLAYER1, "P1 2 Kicks (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS4                | IPF_PLAYER1, "P1 3 Kicks (CPS)",    SEQ_DEF_0 },
	{ IPT_CPS5                | IPF_PLAYER1, "P1 Button 1+2 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS6                | IPF_PLAYER1, "P1 Button 2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS7                | IPF_PLAYER1, "P1 Button 1+2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_SPEC                | IPF_PLAYER1, "P1 Button 1+2",  SEQ_DEF_0 },
#endif
	{ IPT_JOYSTICKRIGHT_UP    | IPF_PLAYER1, "P1 Right/Up",    SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_1_BUTTON2) },
	{ IPT_JOYSTICKRIGHT_DOWN  | IPF_PLAYER1, "P1 Right/Down",  SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_1_BUTTON3) },
	{ IPT_JOYSTICKRIGHT_LEFT  | IPF_PLAYER1, "P1 Right/Left",  SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_1_BUTTON1) },
	{ IPT_JOYSTICKRIGHT_RIGHT | IPF_PLAYER1, "P1 Right/Right", SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_1_BUTTON4) },
	{ IPT_JOYSTICKLEFT_UP     | IPF_PLAYER1, "P1 Left/Up",     SEQ_DEF_3(KEYCODE_E, CODE_OR, JOYCODE_1_UP) },
	{ IPT_JOYSTICKLEFT_DOWN   | IPF_PLAYER1, "P1 Left/Down",   SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_JOYSTICKLEFT_LEFT   | IPF_PLAYER1, "P1 Left/Left",   SEQ_DEF_3(KEYCODE_S, CODE_OR, JOYCODE_1_LEFT) },
	{ IPT_JOYSTICKLEFT_RIGHT  | IPF_PLAYER1, "P1 Left/Right",  SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_1_RIGHT) },

	{ IPT_JOYSTICK_UP         | IPF_PLAYER2, "P2 Up",          SEQ_DEF_3(KEYCODE_R, CODE_OR, JOYCODE_2_UP)    },
	{ IPT_JOYSTICK_DOWN       | IPF_PLAYER2, "P2 Down",        SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_2_DOWN)  },
	{ IPT_JOYSTICK_LEFT       | IPF_PLAYER2, "P2 Left",        SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_2_LEFT)  },
	{ IPT_JOYSTICK_RIGHT      | IPF_PLAYER2, "P2 Right",       SEQ_DEF_3(KEYCODE_G, CODE_OR, JOYCODE_2_RIGHT) },
	{ IPT_BUTTON1             | IPF_PLAYER2, "P2 Button 1",    SEQ_DEF_3(KEYCODE_A, CODE_OR, JOYCODE_2_BUTTON1) },
	{ IPT_BUTTON2             | IPF_PLAYER2, "P2 Button 2",    SEQ_DEF_3(KEYCODE_S, CODE_OR, JOYCODE_2_BUTTON2) },
	{ IPT_BUTTON3             | IPF_PLAYER2, "P2 Button 3",    SEQ_DEF_3(KEYCODE_Q, CODE_OR, JOYCODE_2_BUTTON3) },
	{ IPT_BUTTON4             | IPF_PLAYER2, "P2 Button 4",    SEQ_DEF_3(KEYCODE_W, CODE_OR, JOYCODE_2_BUTTON4) },
	{ IPT_BUTTON5             | IPF_PLAYER2, "P2 Button 5",    SEQ_DEF_1(JOYCODE_2_BUTTON5) },
	{ IPT_BUTTON6             | IPF_PLAYER2, "P2 Button 6",    SEQ_DEF_1(JOYCODE_2_BUTTON6) },
	{ IPT_BUTTON7             | IPF_PLAYER2, "P2 Button 7",    SEQ_DEF_0 },
	{ IPT_BUTTON8             | IPF_PLAYER2, "P2 Button 8",    SEQ_DEF_0 },
	{ IPT_BUTTON9             | IPF_PLAYER2, "P2 Button 9",    SEQ_DEF_0 },
	{ IPT_BUTTON10            | IPF_PLAYER2, "P2 Button 10",   SEQ_DEF_0 },

#ifdef USE_CUSTOM_BUTTON
	{ IPT_CUSTOM1             | IPF_PLAYER2, "P2 Custom 1",    SEQ_DEF_0 },
	{ IPT_CUSTOM2             | IPF_PLAYER2, "P2 Custom 2",    SEQ_DEF_0 },
	{ IPT_CUSTOM3             | IPF_PLAYER2, "P2 Custom 3",    SEQ_DEF_0 },
	{ IPT_CUSTOM4             | IPF_PLAYER2, "P2 Custom 4",    SEQ_DEF_0 },
#endif /* USE_CUSTOM_BUTTON */

#ifdef MAME32JP
	{ IPT_NEOGEO1             | IPF_PLAYER2, "P2 A+B (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO2             | IPF_PLAYER2, "P2 A+C (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO3             | IPF_PLAYER2, "P2 A+D (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO4             | IPF_PLAYER2, "P2 B+C (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO5             | IPF_PLAYER2, "P2 B+D (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO6             | IPF_PLAYER2, "P2 C+D (Neo-Geo)",    SEQ_DEF_0 },
	{ IPT_NEOGEO7             | IPF_PLAYER2, "P2 A+B+C (Neo-Geo)",  SEQ_DEF_0 },
	{ IPT_NEOGEO8             | IPF_PLAYER2, "P2 A+B+D (Neo-Geo)",  SEQ_DEF_0 },
	{ IPT_NEOGEO9             | IPF_PLAYER2, "P2 B+C+D (Neo-Geo)",  SEQ_DEF_0 },
	{ IPT_NEOGEO10            | IPF_PLAYER2, "P2 A+B+C+D (Neo-Geo)",SEQ_DEF_0 },
	{ IPT_CPS1                | IPF_PLAYER2, "P2 2 Punches (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS2                | IPF_PLAYER2, "P2 3 Punches (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS3                | IPF_PLAYER2, "P2 2 Kicks (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS4                | IPF_PLAYER2, "P2 3 Kicks (CPS)",    SEQ_DEF_0 },
	{ IPT_CPS5                | IPF_PLAYER2, "P2 Button 1+2 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS6                | IPF_PLAYER2, "P2 Button 2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS7                | IPF_PLAYER2, "P2 Button 1+2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_SPEC                | IPF_PLAYER2, "P2 Button 1+2",  SEQ_DEF_0 },
#endif
	{ IPT_JOYSTICKRIGHT_UP    | IPF_PLAYER2, "P2 Right/Up",    SEQ_DEF_0 },
	{ IPT_JOYSTICKRIGHT_DOWN  | IPF_PLAYER2, "P2 Right/Down",  SEQ_DEF_0 },
	{ IPT_JOYSTICKRIGHT_LEFT  | IPF_PLAYER2, "P2 Right/Left",  SEQ_DEF_0 },
	{ IPT_JOYSTICKRIGHT_RIGHT | IPF_PLAYER2, "P2 Right/Right", SEQ_DEF_0 },
	{ IPT_JOYSTICKLEFT_UP     | IPF_PLAYER2, "P2 Left/Up",     SEQ_DEF_0 },
	{ IPT_JOYSTICKLEFT_DOWN   | IPF_PLAYER2, "P2 Left/Down",   SEQ_DEF_0 },
	{ IPT_JOYSTICKLEFT_LEFT   | IPF_PLAYER2, "P2 Left/Left",   SEQ_DEF_0 },
	{ IPT_JOYSTICKLEFT_RIGHT  | IPF_PLAYER2, "P2 Left/Right",  SEQ_DEF_0 },

	{ IPT_JOYSTICK_UP         | IPF_PLAYER3, "P3 Up",          SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_3_UP)    },
	{ IPT_JOYSTICK_DOWN       | IPF_PLAYER3, "P3 Down",        SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_3_DOWN)  },
	{ IPT_JOYSTICK_LEFT       | IPF_PLAYER3, "P3 Left",        SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_3_LEFT)  },
	{ IPT_JOYSTICK_RIGHT      | IPF_PLAYER3, "P3 Right",       SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_3_RIGHT) },
	{ IPT_BUTTON1             | IPF_PLAYER3, "P3 Button 1",    SEQ_DEF_3(KEYCODE_RCONTROL, CODE_OR, JOYCODE_3_BUTTON1) },
	{ IPT_BUTTON2             | IPF_PLAYER3, "P3 Button 2",    SEQ_DEF_3(KEYCODE_RSHIFT, CODE_OR, JOYCODE_3_BUTTON2) },
	{ IPT_BUTTON3             | IPF_PLAYER3, "P3 Button 3",    SEQ_DEF_3(KEYCODE_ENTER, CODE_OR, JOYCODE_3_BUTTON3) },
	{ IPT_BUTTON4             | IPF_PLAYER3, "P3 Button 4",    SEQ_DEF_1(JOYCODE_3_BUTTON4) },

#ifdef USE_CUSTOM_BUTTON
	{ IPT_CUSTOM1             | IPF_PLAYER3, "P3 Custom 1",    SEQ_DEF_0 },
	{ IPT_CUSTOM2             | IPF_PLAYER3, "P3 Custom 2",    SEQ_DEF_0 },
	{ IPT_CUSTOM3             | IPF_PLAYER3, "P3 Custom 3",    SEQ_DEF_0 },
	{ IPT_CUSTOM4             | IPF_PLAYER3, "P3 Custom 4",    SEQ_DEF_0 },
#endif /* USE_CUSTOM_BUTTON */

#ifdef MAME32JP
	{ IPT_CPS5                | IPF_PLAYER3, "P3 Button 1+2 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS6                | IPF_PLAYER3, "P3 Button 2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS7                | IPF_PLAYER3, "P3 Button 1+2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_SPEC                | IPF_PLAYER3, "P3 Button 1+2",  SEQ_DEF_0 },
#endif
	{ IPT_JOYSTICK_UP         | IPF_PLAYER4, "P4 Up",          SEQ_DEF_1(JOYCODE_4_UP) },
	{ IPT_JOYSTICK_DOWN       | IPF_PLAYER4, "P4 Down",        SEQ_DEF_1(JOYCODE_4_DOWN) },
	{ IPT_JOYSTICK_LEFT       | IPF_PLAYER4, "P4 Left",        SEQ_DEF_1(JOYCODE_4_LEFT) },
	{ IPT_JOYSTICK_RIGHT      | IPF_PLAYER4, "P4 Right",       SEQ_DEF_1(JOYCODE_4_RIGHT) },
	{ IPT_BUTTON1             | IPF_PLAYER4, "P4 Button 1",    SEQ_DEF_1(JOYCODE_4_BUTTON1) },
	{ IPT_BUTTON2             | IPF_PLAYER4, "P4 Button 2",    SEQ_DEF_1(JOYCODE_4_BUTTON2) },
	{ IPT_BUTTON3             | IPF_PLAYER4, "P4 Button 3",    SEQ_DEF_1(JOYCODE_4_BUTTON3) },
	{ IPT_BUTTON4             | IPF_PLAYER4, "P4 Button 4",    SEQ_DEF_1(JOYCODE_4_BUTTON4) },

#ifdef USE_CUSTOM_BUTTON
	{ IPT_CUSTOM1             | IPF_PLAYER4, "P4 Custom 1",    SEQ_DEF_0 },
	{ IPT_CUSTOM2             | IPF_PLAYER4, "P4 Custom 2",    SEQ_DEF_0 },
	{ IPT_CUSTOM3             | IPF_PLAYER4, "P4 Custom 3",    SEQ_DEF_0 },
	{ IPT_CUSTOM4             | IPF_PLAYER4, "P4 Custom 4",    SEQ_DEF_0 },
#endif /* USE_CUSTOM_BUTTON */

#ifdef MAME32JP
	{ IPT_CPS5                | IPF_PLAYER4, "P4 Button 1+2 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS6                | IPF_PLAYER4, "P4 Button 2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_CPS7                | IPF_PLAYER4, "P4 Button 1+2+3 (CPS)",  SEQ_DEF_0 },
	{ IPT_SPEC                | IPF_PLAYER4, "P4 Button 1+2",  SEQ_DEF_0 },
#endif
	{ IPT_PEDAL	                | IPF_PLAYER1, "P1 Pedal 1",        SEQ_DEF_3(KEYCODE_LCONTROL, CODE_OR, JOYCODE_1_BUTTON1) },
	{ (IPT_PEDAL+IPT_EXTENSION) | IPF_PLAYER1, "P1 Auto Release <Y/N>", SEQ_DEF_1(KEYCODE_Y) },
	{ IPT_PEDAL                 | IPF_PLAYER2, "P2 Pedal 1",        SEQ_DEF_3(KEYCODE_A, CODE_OR, JOYCODE_2_BUTTON1) },
	{ (IPT_PEDAL+IPT_EXTENSION) | IPF_PLAYER2, "P2 Auto Release <Y/N>", SEQ_DEF_1(KEYCODE_Y) },
	{ IPT_PEDAL                 | IPF_PLAYER3, "P3 Pedal 1",        SEQ_DEF_3(KEYCODE_RCONTROL, CODE_OR, JOYCODE_3_BUTTON1) },
	{ (IPT_PEDAL+IPT_EXTENSION) | IPF_PLAYER3, "P3 Auto Release <Y/N>", SEQ_DEF_1(KEYCODE_Y) },
	{ IPT_PEDAL                 | IPF_PLAYER4, "P4 Pedal 1",        SEQ_DEF_1(JOYCODE_4_BUTTON1) },
	{ (IPT_PEDAL+IPT_EXTENSION) | IPF_PLAYER4, "P4 Auto Release <Y/N>", SEQ_DEF_1(KEYCODE_Y) },

	{ IPT_PEDAL2	             | IPF_PLAYER1, "P1 Pedal 2",    SEQ_DEF_1(JOYCODE_1_DOWN) },
	{ (IPT_PEDAL2+IPT_EXTENSION) | IPF_PLAYER1, "P1 Auto Release <Y/N>", SEQ_DEF_1(KEYCODE_Y) },
	{ IPT_PEDAL2                 | IPF_PLAYER2, "P2 Pedal 2",    SEQ_DEF_1(JOYCODE_2_DOWN) },
	{ (IPT_PEDAL2+IPT_EXTENSION) | IPF_PLAYER2, "P2 Auto Release <Y/N>", SEQ_DEF_1(KEYCODE_Y) },
	{ IPT_PEDAL2                 | IPF_PLAYER3, "P3 Pedal 2",    SEQ_DEF_1(JOYCODE_3_DOWN) },
	{ (IPT_PEDAL2+IPT_EXTENSION) | IPF_PLAYER3, "P3 Auto Release <Y/N>", SEQ_DEF_1(KEYCODE_Y) },
	{ IPT_PEDAL2                 | IPF_PLAYER4, "P4 Pedal 2",    SEQ_DEF_1(JOYCODE_4_DOWN) },
	{ (IPT_PEDAL2+IPT_EXTENSION) | IPF_PLAYER4, "P4 Auto Release <Y/N>", SEQ_DEF_1(KEYCODE_Y) },

	{ IPT_PADDLE | IPF_PLAYER1,  "Paddle",        SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT) },
	{ (IPT_PADDLE | IPF_PLAYER1)+IPT_EXTENSION,             "Paddle",        SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT)  },
	{ IPT_PADDLE | IPF_PLAYER2,  "Paddle 2",      SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_2_LEFT) },
	{ (IPT_PADDLE | IPF_PLAYER2)+IPT_EXTENSION,             "Paddle 2",      SEQ_DEF_3(KEYCODE_G, CODE_OR, JOYCODE_2_RIGHT) },
	{ IPT_PADDLE | IPF_PLAYER3,  "Paddle 3",      SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_3_LEFT) },
	{ (IPT_PADDLE | IPF_PLAYER3)+IPT_EXTENSION,             "Paddle 3",      SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_3_RIGHT) },
	{ IPT_PADDLE | IPF_PLAYER4,  "Paddle 4",      SEQ_DEF_1(JOYCODE_4_LEFT) },
	{ (IPT_PADDLE | IPF_PLAYER4)+IPT_EXTENSION,             "Paddle 4",      SEQ_DEF_1(JOYCODE_4_RIGHT) },
	{ IPT_PADDLE_V | IPF_PLAYER1,  "Paddle V",          SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP) },
	{ (IPT_PADDLE_V | IPF_PLAYER1)+IPT_EXTENSION,             "Paddle V",          SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_PADDLE_V | IPF_PLAYER2,  "Paddle V 2",        SEQ_DEF_3(KEYCODE_R, CODE_OR, JOYCODE_2_UP) },
	{ (IPT_PADDLE_V | IPF_PLAYER2)+IPT_EXTENSION,             "Paddle V 2",      SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_2_DOWN) },
	{ IPT_PADDLE_V | IPF_PLAYER3,  "Paddle V 3",        SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_3_UP) },
	{ (IPT_PADDLE_V | IPF_PLAYER3)+IPT_EXTENSION,             "Paddle V 3",      SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_3_DOWN) },
	{ IPT_PADDLE_V | IPF_PLAYER4,  "Paddle V 4",        SEQ_DEF_1(JOYCODE_4_UP) },
	{ (IPT_PADDLE_V | IPF_PLAYER4)+IPT_EXTENSION,             "Paddle V 4",      SEQ_DEF_1(JOYCODE_4_DOWN) },
	{ IPT_DIAL | IPF_PLAYER1,    "Dial",          SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT) },
	{ (IPT_DIAL | IPF_PLAYER1)+IPT_EXTENSION,               "Dial",          SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT) },
	{ IPT_DIAL | IPF_PLAYER2,    "Dial 2",        SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_2_LEFT) },
	{ (IPT_DIAL | IPF_PLAYER2)+IPT_EXTENSION,               "Dial 2",      SEQ_DEF_3(KEYCODE_G, CODE_OR, JOYCODE_2_RIGHT) },
	{ IPT_DIAL | IPF_PLAYER3,    "Dial 3",        SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_3_LEFT) },
	{ (IPT_DIAL | IPF_PLAYER3)+IPT_EXTENSION,               "Dial 3",      SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_3_RIGHT) },
	{ IPT_DIAL | IPF_PLAYER4,    "Dial 4",        SEQ_DEF_1(JOYCODE_4_LEFT) },
	{ (IPT_DIAL | IPF_PLAYER4)+IPT_EXTENSION,               "Dial 4",      SEQ_DEF_1(JOYCODE_4_RIGHT) },
	{ IPT_DIAL_V | IPF_PLAYER1,  "Dial V",          SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP) },
	{ (IPT_DIAL_V | IPF_PLAYER1)+IPT_EXTENSION,             "Dial V",          SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_DIAL_V | IPF_PLAYER2,  "Dial V 2",        SEQ_DEF_3(KEYCODE_R, CODE_OR, JOYCODE_2_UP) },
	{ (IPT_DIAL_V | IPF_PLAYER2)+IPT_EXTENSION,             "Dial V 2",      SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_2_DOWN) },
	{ IPT_DIAL_V | IPF_PLAYER3,  "Dial V 3",        SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_3_UP) },
	{ (IPT_DIAL_V | IPF_PLAYER3)+IPT_EXTENSION,             "Dial V 3",      SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_3_DOWN) },
	{ IPT_DIAL_V | IPF_PLAYER4,  "Dial V 4",        SEQ_DEF_1(JOYCODE_4_UP) },
	{ (IPT_DIAL_V | IPF_PLAYER4)+IPT_EXTENSION,             "Dial V 4",      SEQ_DEF_1(JOYCODE_4_DOWN) },

	{ IPT_TRACKBALL_X | IPF_PLAYER1, "Track X",   SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT) },
	{ (IPT_TRACKBALL_X | IPF_PLAYER1)+IPT_EXTENSION,                 "Track X",   SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT) },
	{ IPT_TRACKBALL_X | IPF_PLAYER2, "Track X 2", SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_2_LEFT) },
	{ (IPT_TRACKBALL_X | IPF_PLAYER2)+IPT_EXTENSION,                 "Track X 2", SEQ_DEF_3(KEYCODE_G, CODE_OR, JOYCODE_2_RIGHT) },
	{ IPT_TRACKBALL_X | IPF_PLAYER3, "Track X 3", SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_3_LEFT) },
	{ (IPT_TRACKBALL_X | IPF_PLAYER3)+IPT_EXTENSION,                 "Track X 3", SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_3_RIGHT) },
	{ IPT_TRACKBALL_X | IPF_PLAYER4, "Track X 4", SEQ_DEF_1(JOYCODE_4_LEFT) },
	{ (IPT_TRACKBALL_X | IPF_PLAYER4)+IPT_EXTENSION,                 "Track X 4", SEQ_DEF_1(JOYCODE_4_RIGHT) },

	{ IPT_TRACKBALL_Y | IPF_PLAYER1, "Track Y",   SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP) },
	{ (IPT_TRACKBALL_Y | IPF_PLAYER1)+IPT_EXTENSION,                 "Track Y",   SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_TRACKBALL_Y | IPF_PLAYER2, "Track Y 2", SEQ_DEF_3(KEYCODE_R, CODE_OR, JOYCODE_2_UP) },
	{ (IPT_TRACKBALL_Y | IPF_PLAYER2)+IPT_EXTENSION,                 "Track Y 2", SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_2_DOWN) },
	{ IPT_TRACKBALL_Y | IPF_PLAYER3, "Track Y 3", SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_3_UP) },
	{ (IPT_TRACKBALL_Y | IPF_PLAYER3)+IPT_EXTENSION,                 "Track Y 3", SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_3_DOWN) },
	{ IPT_TRACKBALL_Y | IPF_PLAYER4, "Track Y 4", SEQ_DEF_1(JOYCODE_4_UP) },
	{ (IPT_TRACKBALL_Y | IPF_PLAYER4)+IPT_EXTENSION,                 "Track Y 4", SEQ_DEF_1(JOYCODE_4_DOWN) },

	{ IPT_AD_STICK_X | IPF_PLAYER1, "AD Stick X",   SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT) },
	{ (IPT_AD_STICK_X | IPF_PLAYER1)+IPT_EXTENSION,                "AD Stick X",   SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT) },
	{ IPT_AD_STICK_X | IPF_PLAYER2, "AD Stick X 2", SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_2_LEFT) },
	{ (IPT_AD_STICK_X | IPF_PLAYER2)+IPT_EXTENSION,                "AD Stick X 2", SEQ_DEF_3(KEYCODE_G, CODE_OR, JOYCODE_2_RIGHT) },
	{ IPT_AD_STICK_X | IPF_PLAYER3, "AD Stick X 3", SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_3_LEFT) },
	{ (IPT_AD_STICK_X | IPF_PLAYER3)+IPT_EXTENSION,                "AD Stick X 3", SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_3_RIGHT) },
	{ IPT_AD_STICK_X | IPF_PLAYER4, "AD Stick X 4", SEQ_DEF_1(JOYCODE_4_LEFT) },
	{ (IPT_AD_STICK_X | IPF_PLAYER4)+IPT_EXTENSION,                "AD Stick X 4", SEQ_DEF_1(JOYCODE_4_RIGHT) },

	{ IPT_AD_STICK_Y | IPF_PLAYER1, "AD Stick Y",   SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP) },
	{ (IPT_AD_STICK_Y | IPF_PLAYER1)+IPT_EXTENSION,                "AD Stick Y",   SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_AD_STICK_Y | IPF_PLAYER2, "AD Stick Y 2", SEQ_DEF_3(KEYCODE_R, CODE_OR, JOYCODE_2_UP) },
	{ (IPT_AD_STICK_Y | IPF_PLAYER2)+IPT_EXTENSION,                "AD Stick Y 2", SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_2_DOWN) },
	{ IPT_AD_STICK_Y | IPF_PLAYER3, "AD Stick Y 3", SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_3_UP) },
	{ (IPT_AD_STICK_Y | IPF_PLAYER3)+IPT_EXTENSION,                "AD Stick Y 3", SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_3_DOWN) },
	{ IPT_AD_STICK_Y | IPF_PLAYER4, "AD Stick Y 4", SEQ_DEF_1(JOYCODE_4_UP) },
	{ (IPT_AD_STICK_Y | IPF_PLAYER4)+IPT_EXTENSION,                "AD Stick Y 4", SEQ_DEF_1(JOYCODE_4_DOWN) },

	{ IPT_AD_STICK_Z | IPF_PLAYER1, "AD Stick Z",   SEQ_DEF_0 },
	{ (IPT_AD_STICK_Z | IPF_PLAYER1)+IPT_EXTENSION,                "AD Stick Z",   SEQ_DEF_0 },
	{ IPT_AD_STICK_Z | IPF_PLAYER2, "AD Stick Z 2", SEQ_DEF_0 },
	{ (IPT_AD_STICK_Z | IPF_PLAYER2)+IPT_EXTENSION,                "AD Stick Z 2", SEQ_DEF_0 },
	{ IPT_AD_STICK_Z | IPF_PLAYER3, "AD Stick Z 3", SEQ_DEF_0 },
	{ (IPT_AD_STICK_Z | IPF_PLAYER3)+IPT_EXTENSION,                "AD Stick Z 3", SEQ_DEF_0 },
	{ IPT_AD_STICK_Z | IPF_PLAYER4, "AD Stick Z 4", SEQ_DEF_0 },
	{ (IPT_AD_STICK_Z | IPF_PLAYER4)+IPT_EXTENSION,                "AD Stick Z 4", SEQ_DEF_0 },

	{ IPT_LIGHTGUN_X | IPF_PLAYER1, "Lightgun X",   SEQ_DEF_3(KEYCODE_LEFT, CODE_OR, JOYCODE_1_LEFT) },
	{ (IPT_LIGHTGUN_X | IPF_PLAYER1)+IPT_EXTENSION,                "Lightgun X",   SEQ_DEF_3(KEYCODE_RIGHT, CODE_OR, JOYCODE_1_RIGHT) },
	{ IPT_LIGHTGUN_X | IPF_PLAYER2, "Lightgun X 2", SEQ_DEF_3(KEYCODE_D, CODE_OR, JOYCODE_2_LEFT) },
	{ (IPT_LIGHTGUN_X | IPF_PLAYER2)+IPT_EXTENSION,                "Lightgun X 2", SEQ_DEF_3(KEYCODE_G, CODE_OR, JOYCODE_2_RIGHT) },
	{ IPT_LIGHTGUN_X | IPF_PLAYER3, "Lightgun X 3", SEQ_DEF_3(KEYCODE_J, CODE_OR, JOYCODE_3_LEFT) },
	{ (IPT_LIGHTGUN_X | IPF_PLAYER3)+IPT_EXTENSION,                "Lightgun X 3", SEQ_DEF_3(KEYCODE_L, CODE_OR, JOYCODE_3_RIGHT) },
	{ IPT_LIGHTGUN_X | IPF_PLAYER4, "Lightgun X 4", SEQ_DEF_1(JOYCODE_4_LEFT) },
	{ (IPT_LIGHTGUN_X | IPF_PLAYER4)+IPT_EXTENSION,                "Lightgun X 4", SEQ_DEF_1(JOYCODE_4_RIGHT) },

	{ IPT_LIGHTGUN_Y | IPF_PLAYER1, "Lightgun Y",   SEQ_DEF_3(KEYCODE_UP, CODE_OR, JOYCODE_1_UP) },
	{ (IPT_LIGHTGUN_Y | IPF_PLAYER1)+IPT_EXTENSION,                "Lightgun Y",   SEQ_DEF_3(KEYCODE_DOWN, CODE_OR, JOYCODE_1_DOWN) },
	{ IPT_LIGHTGUN_Y | IPF_PLAYER2, "Lightgun Y 2", SEQ_DEF_3(KEYCODE_R, CODE_OR, JOYCODE_2_UP) },
	{ (IPT_LIGHTGUN_Y | IPF_PLAYER2)+IPT_EXTENSION,                "Lightgun Y 2", SEQ_DEF_3(KEYCODE_F, CODE_OR, JOYCODE_2_DOWN) },
	{ IPT_LIGHTGUN_Y | IPF_PLAYER3, "Lightgun Y 3", SEQ_DEF_3(KEYCODE_I, CODE_OR, JOYCODE_3_UP) },
	{ (IPT_LIGHTGUN_Y | IPF_PLAYER3)+IPT_EXTENSION,                "Lightgun Y 3", SEQ_DEF_3(KEYCODE_K, CODE_OR, JOYCODE_3_DOWN) },
	{ IPT_LIGHTGUN_Y | IPF_PLAYER4, "Lightgun Y 4", SEQ_DEF_1(JOYCODE_4_UP) },
	{ (IPT_LIGHTGUN_Y | IPF_PLAYER4)+IPT_EXTENSION,                "Lightgun Y 4", SEQ_DEF_1(JOYCODE_4_DOWN) },

	{ IPT_UNKNOWN,             "UNKNOWN",         SEQ_DEF_0 },
	{ IPT_UI_BOOST,             "boost",                SEQ_DEF_1(KEYCODE_T) },
	{ IPT_UI_CHEAT_LIST,        "Show Cheat List",      SEQ_DEF_1(KEYCODE_NONE) }, // CHEAT_LIST
	{ IPT_OSD_RESERVED,        "",                SEQ_DEF_0 },
	{ IPT_OSD_RESERVED,        "",                SEQ_DEF_0 },
	{ IPT_END,                 0,                 SEQ_DEF_0 }	/* returned when there is no match */
#endif
};

struct ipd inputport_defaults_backup[sizeof(inputport_defaults)/sizeof(struct ipd)];


struct ik *osd_input_keywords = NULL;

struct ik input_keywords[] =
{
	{ "KEYCODE_A",		   		IKT_STD,		KEYCODE_A },
	{ "KEYCODE_B",		   		IKT_STD,		KEYCODE_B },
	{ "KEYCODE_C",		   		IKT_STD,		KEYCODE_C },
	{ "KEYCODE_D",		   		IKT_STD,		KEYCODE_D },
	{ "KEYCODE_E",		   		IKT_STD,		KEYCODE_E },
	{ "KEYCODE_F",		   		IKT_STD,		KEYCODE_F },
	{ "KEYCODE_G",		   		IKT_STD,		KEYCODE_G },
	{ "KEYCODE_H",		   		IKT_STD,		KEYCODE_H },
	{ "KEYCODE_I",		   		IKT_STD,		KEYCODE_I },
	{ "KEYCODE_J",		   		IKT_STD,		KEYCODE_J },
	{ "KEYCODE_K",		   		IKT_STD,		KEYCODE_K },
	{ "KEYCODE_L",		   		IKT_STD,		KEYCODE_L },
	{ "KEYCODE_M",		   		IKT_STD,		KEYCODE_M },
	{ "KEYCODE_N",		   		IKT_STD,		KEYCODE_N },
	{ "KEYCODE_O",		   		IKT_STD,		KEYCODE_O },
	{ "KEYCODE_P",		   		IKT_STD,		KEYCODE_P },
	{ "KEYCODE_Q",		   		IKT_STD,		KEYCODE_Q },
	{ "KEYCODE_R",		   		IKT_STD,		KEYCODE_R },
	{ "KEYCODE_S",		   		IKT_STD,		KEYCODE_S },
	{ "KEYCODE_T",		   		IKT_STD,		KEYCODE_T },
	{ "KEYCODE_U",		   		IKT_STD,		KEYCODE_U },
	{ "KEYCODE_V",		   		IKT_STD,		KEYCODE_V },
	{ "KEYCODE_W",		   		IKT_STD,		KEYCODE_W },
	{ "KEYCODE_X",		   		IKT_STD,		KEYCODE_X },
	{ "KEYCODE_Y",		   		IKT_STD,		KEYCODE_Y },
	{ "KEYCODE_Z",		   		IKT_STD,		KEYCODE_Z },
	{ "KEYCODE_0",		   		IKT_STD,		KEYCODE_0 },
	{ "KEYCODE_1",		   		IKT_STD,		KEYCODE_1 },
	{ "KEYCODE_2",		   		IKT_STD,		KEYCODE_2 },
	{ "KEYCODE_3",		   		IKT_STD,		KEYCODE_3 },
	{ "KEYCODE_4",		   		IKT_STD,		KEYCODE_4 },
	{ "KEYCODE_5",		   		IKT_STD,		KEYCODE_5 },
	{ "KEYCODE_6",		   		IKT_STD,		KEYCODE_6 },
	{ "KEYCODE_7",		   		IKT_STD,		KEYCODE_7 },
	{ "KEYCODE_8",		   		IKT_STD,		KEYCODE_8 },
	{ "KEYCODE_9",		   		IKT_STD,		KEYCODE_9 },
	{ "KEYCODE_0_PAD",	   		IKT_STD,		KEYCODE_0_PAD },
	{ "KEYCODE_1_PAD",	   		IKT_STD,		KEYCODE_1_PAD },
	{ "KEYCODE_2_PAD",	   		IKT_STD,		KEYCODE_2_PAD },
	{ "KEYCODE_3_PAD",	   		IKT_STD,		KEYCODE_3_PAD },
	{ "KEYCODE_4_PAD",	   		IKT_STD,		KEYCODE_4_PAD },
	{ "KEYCODE_5_PAD",	   		IKT_STD,		KEYCODE_5_PAD },
	{ "KEYCODE_6_PAD",	   		IKT_STD,		KEYCODE_6_PAD },
	{ "KEYCODE_7_PAD",	   		IKT_STD,		KEYCODE_7_PAD },
	{ "KEYCODE_8_PAD",	      	IKT_STD,		KEYCODE_8_PAD },
	{ "KEYCODE_9_PAD",	      	IKT_STD,		KEYCODE_9_PAD },
	{ "KEYCODE_F1",		   		IKT_STD,		KEYCODE_F1 },
	{ "KEYCODE_F2",			  	IKT_STD,		KEYCODE_F2 },
	{ "KEYCODE_F3",			  	IKT_STD,		KEYCODE_F3 },
	{ "KEYCODE_F4",			  	IKT_STD,		KEYCODE_F4 },
	{ "KEYCODE_F5",			  	IKT_STD,		KEYCODE_F5 },
	{ "KEYCODE_F6",			  	IKT_STD,		KEYCODE_F6 },
	{ "KEYCODE_F7",			  	IKT_STD,		KEYCODE_F7 },
	{ "KEYCODE_F8",			  	IKT_STD,		KEYCODE_F8 },
	{ "KEYCODE_F9",			  	IKT_STD,		KEYCODE_F9 },
	{ "KEYCODE_F10",		  	IKT_STD,		KEYCODE_F10 },
	{ "KEYCODE_F11",		  	IKT_STD,		KEYCODE_F11 },
	{ "KEYCODE_F12",		  	IKT_STD,		KEYCODE_F12 },
	{ "KEYCODE_ESC",		  	IKT_STD,		KEYCODE_ESC },
	{ "KEYCODE_TILDE",		  	IKT_STD,		KEYCODE_TILDE },
	{ "KEYCODE_MINUS",		  	IKT_STD,		KEYCODE_MINUS },
	{ "KEYCODE_EQUALS",		  	IKT_STD,		KEYCODE_EQUALS },
	{ "KEYCODE_BACKSPACE",	  	IKT_STD,		KEYCODE_BACKSPACE },
	{ "KEYCODE_TAB",		  	IKT_STD,		KEYCODE_TAB },
	{ "KEYCODE_OPENBRACE",	  	IKT_STD,		KEYCODE_OPENBRACE },
	{ "KEYCODE_CLOSEBRACE",	  	IKT_STD,		KEYCODE_CLOSEBRACE },
	{ "KEYCODE_ENTER",		  	IKT_STD,		KEYCODE_ENTER },
	{ "KEYCODE_COLON",		  	IKT_STD,		KEYCODE_COLON },
	{ "KEYCODE_QUOTE",		  	IKT_STD,		KEYCODE_QUOTE },
	{ "KEYCODE_BACKSLASH",	  	IKT_STD,		KEYCODE_BACKSLASH },
	{ "KEYCODE_BACKSLASH2",	  	IKT_STD,		KEYCODE_BACKSLASH2 },
	{ "KEYCODE_COMMA",		  	IKT_STD,		KEYCODE_COMMA },
	{ "KEYCODE_STOP",		  	IKT_STD,		KEYCODE_STOP },
	{ "KEYCODE_SLASH",		  	IKT_STD,		KEYCODE_SLASH },
	{ "KEYCODE_SPACE",		  	IKT_STD,		KEYCODE_SPACE },
	{ "KEYCODE_INSERT",		  	IKT_STD,		KEYCODE_INSERT },
	{ "KEYCODE_DEL",		  	IKT_STD,		KEYCODE_DEL },
	{ "KEYCODE_HOME",		  	IKT_STD,		KEYCODE_HOME },
	{ "KEYCODE_END",		  	IKT_STD,		KEYCODE_END },
	{ "KEYCODE_PGUP",		  	IKT_STD,		KEYCODE_PGUP },
	{ "KEYCODE_PGDN",		  	IKT_STD,		KEYCODE_PGDN },
	{ "KEYCODE_LEFT",		  	IKT_STD,		KEYCODE_LEFT },
	{ "KEYCODE_RIGHT",		  	IKT_STD,		KEYCODE_RIGHT },
	{ "KEYCODE_UP",			  	IKT_STD,		KEYCODE_UP },
	{ "KEYCODE_DOWN",		  	IKT_STD,		KEYCODE_DOWN },
	{ "KEYCODE_SLASH_PAD",	  	IKT_STD,		KEYCODE_SLASH_PAD },
	{ "KEYCODE_ASTERISK",	  	IKT_STD,		KEYCODE_ASTERISK },
	{ "KEYCODE_MINUS_PAD",	  	IKT_STD,		KEYCODE_MINUS_PAD },
	{ "KEYCODE_PLUS_PAD",	  	IKT_STD,		KEYCODE_PLUS_PAD },
	{ "KEYCODE_DEL_PAD",	  	IKT_STD,		KEYCODE_DEL_PAD },
	{ "KEYCODE_ENTER_PAD",	  	IKT_STD,		KEYCODE_ENTER_PAD },
	{ "KEYCODE_PRTSCR",		  	IKT_STD,		KEYCODE_PRTSCR },
	{ "KEYCODE_PAUSE",		  	IKT_STD,		KEYCODE_PAUSE },
	{ "KEYCODE_LSHIFT",		  	IKT_STD,		KEYCODE_LSHIFT },
	{ "KEYCODE_RSHIFT",		  	IKT_STD,		KEYCODE_RSHIFT },
	{ "KEYCODE_LCONTROL",	  	IKT_STD,		KEYCODE_LCONTROL },
	{ "KEYCODE_RCONTROL",	  	IKT_STD,		KEYCODE_RCONTROL },
	{ "KEYCODE_LALT",		  	IKT_STD,		KEYCODE_LALT },
	{ "KEYCODE_RALT",		  	IKT_STD,		KEYCODE_RALT },
	{ "KEYCODE_SCRLOCK",	  	IKT_STD,		KEYCODE_SCRLOCK },
	{ "KEYCODE_NUMLOCK",	  	IKT_STD,		KEYCODE_NUMLOCK },
	{ "KEYCODE_CAPSLOCK",	  	IKT_STD,		KEYCODE_CAPSLOCK },
	{ "KEYCODE_LWIN",		  	IKT_STD,		KEYCODE_LWIN },
	{ "KEYCODE_RWIN",		  	IKT_STD,		KEYCODE_RWIN },
	{ "KEYCODE_MENU",		  	IKT_STD,		KEYCODE_MENU },

	{ "JOYCODE_1_LEFT",		  	IKT_STD,		JOYCODE_1_LEFT },
	{ "JOYCODE_1_RIGHT",	  	IKT_STD,		JOYCODE_1_RIGHT },
	{ "JOYCODE_1_UP",		  	IKT_STD,		JOYCODE_1_UP },
	{ "JOYCODE_1_DOWN",		  	IKT_STD,		JOYCODE_1_DOWN },
	{ "JOYCODE_1_BUTTON1",	  	IKT_STD,		JOYCODE_1_BUTTON1 },
	{ "JOYCODE_1_BUTTON2",	  	IKT_STD,		JOYCODE_1_BUTTON2 },
	{ "JOYCODE_1_BUTTON3",	  	IKT_STD,		JOYCODE_1_BUTTON3 },
	{ "JOYCODE_1_BUTTON4",	  	IKT_STD,		JOYCODE_1_BUTTON4 },
	{ "JOYCODE_1_BUTTON5",	  	IKT_STD,		JOYCODE_1_BUTTON5 },
	{ "JOYCODE_1_BUTTON6",	  	IKT_STD,		JOYCODE_1_BUTTON6 },
	{ "JOYCODE_1_START",	  	IKT_STD,		JOYCODE_1_START },
	{ "JOYCODE_1_SELECT",	  	IKT_STD,		JOYCODE_1_SELECT },
	{ "JOYCODE_2_LEFT",		  	IKT_STD,		JOYCODE_2_LEFT },
	{ "JOYCODE_2_RIGHT",	  	IKT_STD,		JOYCODE_2_RIGHT },
	{ "JOYCODE_2_UP",		  	IKT_STD,		JOYCODE_2_UP },
	{ "JOYCODE_2_DOWN",		  	IKT_STD,		JOYCODE_2_DOWN },
	{ "JOYCODE_2_BUTTON1",	  	IKT_STD,		JOYCODE_2_BUTTON1 },
	{ "JOYCODE_2_BUTTON2",	  	IKT_STD,		JOYCODE_2_BUTTON2 },
	{ "JOYCODE_2_BUTTON3",	  	IKT_STD,		JOYCODE_2_BUTTON3 },
	{ "JOYCODE_2_BUTTON4",	  	IKT_STD,		JOYCODE_2_BUTTON4 },
	{ "JOYCODE_2_BUTTON5",	  	IKT_STD,		JOYCODE_2_BUTTON5 },
	{ "JOYCODE_2_BUTTON6",	  	IKT_STD,		JOYCODE_2_BUTTON6 },
	{ "JOYCODE_2_START",	  	IKT_STD,		JOYCODE_2_START },
	{ "JOYCODE_2_SELECT",	  	IKT_STD,		JOYCODE_2_SELECT },
	{ "JOYCODE_3_LEFT",		  	IKT_STD,		JOYCODE_3_LEFT },
	{ "JOYCODE_3_RIGHT",	  	IKT_STD,		JOYCODE_3_RIGHT },
	{ "JOYCODE_3_UP",		  	IKT_STD,		JOYCODE_3_UP },
	{ "JOYCODE_3_DOWN",		  	IKT_STD,		JOYCODE_3_DOWN },
	{ "JOYCODE_3_BUTTON1",	  	IKT_STD,		JOYCODE_3_BUTTON1 },
	{ "JOYCODE_3_BUTTON2",	  	IKT_STD,		JOYCODE_3_BUTTON2 },
	{ "JOYCODE_3_BUTTON3",	  	IKT_STD,		JOYCODE_3_BUTTON3 },
	{ "JOYCODE_3_BUTTON4",	  	IKT_STD,		JOYCODE_3_BUTTON4 },
	{ "JOYCODE_3_BUTTON5",	  	IKT_STD,		JOYCODE_3_BUTTON5 },
	{ "JOYCODE_3_BUTTON6",	  	IKT_STD,		JOYCODE_3_BUTTON6 },
	{ "JOYCODE_3_START",	  	IKT_STD,		JOYCODE_3_START },
	{ "JOYCODE_3_SELECT",	  	IKT_STD,		JOYCODE_3_SELECT },
	{ "JOYCODE_4_LEFT",		  	IKT_STD,		JOYCODE_4_LEFT },
	{ "JOYCODE_4_RIGHT",	  	IKT_STD,		JOYCODE_4_RIGHT },
	{ "JOYCODE_4_UP",		  	IKT_STD,		JOYCODE_4_UP },
	{ "JOYCODE_4_DOWN",		  	IKT_STD,		JOYCODE_4_DOWN },
	{ "JOYCODE_4_BUTTON1",	  	IKT_STD,		JOYCODE_4_BUTTON1 },
	{ "JOYCODE_4_BUTTON2",	  	IKT_STD,		JOYCODE_4_BUTTON2 },
	{ "JOYCODE_4_BUTTON3",	  	IKT_STD,		JOYCODE_4_BUTTON3 },
	{ "JOYCODE_4_BUTTON4",	  	IKT_STD,		JOYCODE_4_BUTTON4 },
	{ "JOYCODE_4_BUTTON5",	  	IKT_STD,		JOYCODE_4_BUTTON5 },
	{ "JOYCODE_4_BUTTON6",	  	IKT_STD,		JOYCODE_4_BUTTON6 },
	{ "JOYCODE_4_START",	  	IKT_STD,		JOYCODE_4_START },
	{ "JOYCODE_4_SELECT",	  	IKT_STD,		JOYCODE_4_SELECT },

	{ "MOUSECODE_1_BUTTON1", 	IKT_STD,		JOYCODE_MOUSE_1_BUTTON1 },
	{ "MOUSECODE_1_BUTTON2", 	IKT_STD,		JOYCODE_MOUSE_1_BUTTON2 },
	{ "MOUSECODE_1_BUTTON3", 	IKT_STD,		JOYCODE_MOUSE_1_BUTTON3 },

	{ "KEYCODE_NONE",			IKT_STD,		CODE_NONE },
	{ "CODE_NONE",			  	IKT_STD,		CODE_NONE },
	{ "CODE_OTHER",				IKT_STD,		CODE_OTHER },
	{ "CODE_DEFAULT",			IKT_STD,		CODE_DEFAULT },
	{ "CODE_PREVIOUS",			IKT_STD,		CODE_PREVIOUS },
	{ "CODE_NOT",				IKT_STD,		CODE_NOT },
	{ "CODE_OR",			   	IKT_STD,		CODE_OR },
	{ "!",						IKT_STD,		CODE_NOT },
	{ "|",					   	IKT_STD,		CODE_OR },

	{ "UI_CONFIGURE", 			IKT_IPT,	 	IPT_UI_CONFIGURE },
	{ "UI_ON_SCREEN_DISPLAY",	IKT_IPT,		IPT_UI_ON_SCREEN_DISPLAY },
	{ "UI_PAUSE",				IKT_IPT,		IPT_UI_PAUSE },
	{ "UI_RESET_MACHINE",		IKT_IPT,		IPT_UI_RESET_MACHINE },
	{ "UI_SHOW_GFX",			IKT_IPT,		IPT_UI_SHOW_GFX },
	{ "UI_FRAMESKIP_DEC",		IKT_IPT,		IPT_UI_FRAMESKIP_DEC },
	{ "UI_FRAMESKIP_INC",		IKT_IPT,		IPT_UI_FRAMESKIP_INC },
	{ "UI_THROTTLE",			IKT_IPT,		IPT_UI_THROTTLE },
	{ "UI_SHOW_FPS",			IKT_IPT,		IPT_UI_SHOW_FPS },
	{ "UI_SHOW_PROFILER",		IKT_IPT,		IPT_UI_SHOW_PROFILER },
#ifdef MESS
	{ "UI_TOGGLE_UI",			IKT_IPT,		IPT_UI_TOGGLE_UI },
#endif
	{ "UI_SNAPSHOT",			IKT_IPT,		IPT_UI_SNAPSHOT },
	{ "UI_TOGGLE_CHEAT",		IKT_IPT,		IPT_UI_TOGGLE_CHEAT },
	{ "UI_UP",					IKT_IPT,		IPT_UI_UP },
	{ "UI_DOWN",				IKT_IPT,		IPT_UI_DOWN },
	{ "UI_LEFT",				IKT_IPT,		IPT_UI_LEFT },
	{ "UI_RIGHT",				IKT_IPT,		IPT_UI_RIGHT },
	{ "UI_SELECT",				IKT_IPT,		IPT_UI_SELECT },
	{ "UI_CANCEL",				IKT_IPT,		IPT_UI_CANCEL },
	{ "UI_PAN_UP",				IKT_IPT,		IPT_UI_PAN_UP },
	{ "UI_PAN_DOWN",			IKT_IPT,		IPT_UI_PAN_DOWN },
	{ "UI_PAN_LEFT",			IKT_IPT,		IPT_UI_PAN_LEFT },
	{ "UI_PAN_RIGHT",			IKT_IPT,		IPT_UI_PAN_RIGHT },
	{ "UI_TOGGLE_DEBUG",		IKT_IPT,		IPT_UI_TOGGLE_DEBUG },
	{ "UI_SAVE_STATE",			IKT_IPT,		IPT_UI_SAVE_STATE },
	{ "UI_LOAD_STATE",			IKT_IPT,		IPT_UI_LOAD_STATE },
	{ "UI_ADD_CHEAT",			IKT_IPT,		IPT_UI_ADD_CHEAT },
	{ "UI_DELETE_CHEAT",		IKT_IPT,		IPT_UI_DELETE_CHEAT },
	{ "UI_SAVE_CHEAT",			IKT_IPT,		IPT_UI_SAVE_CHEAT },
	{ "UI_WATCH_VALUE",			IKT_IPT,		IPT_UI_WATCH_VALUE },
	{ "UI_EDIT_CHEAT",			IKT_IPT,		IPT_UI_EDIT_CHEAT },
	{ "UI_TOGGLE_CROSSHAIR",	IKT_IPT,		IPT_UI_TOGGLE_CROSSHAIR },
	{ "START1",					IKT_IPT,		IPT_START1 },
	{ "START2",					IKT_IPT,		IPT_START2 },
	{ "START3",					IKT_IPT,		IPT_START3 },
	{ "START4",					IKT_IPT,		IPT_START4 },
	{ "COIN1",					IKT_IPT,		IPT_COIN1 },
	{ "COIN2",					IKT_IPT,		IPT_COIN2 },
	{ "COIN3",					IKT_IPT,		IPT_COIN3 },
	{ "COIN4",					IKT_IPT,		IPT_COIN4 },
	{ "SERVICE1",				IKT_IPT,		IPT_SERVICE1 },
	{ "SERVICE2",				IKT_IPT,		IPT_SERVICE2 },
	{ "SERVICE3",				IKT_IPT,		IPT_SERVICE3 },
	{ "SERVICE4",				IKT_IPT,		IPT_SERVICE4 },
	{ "TILT",					IKT_IPT,		IPT_TILT },

	{ "P1_JOYSTICK_UP",			IKT_IPT,		IPF_PLAYER1 | IPT_JOYSTICK_UP },
	{ "P1_JOYSTICK_DOWN",		IKT_IPT,		IPF_PLAYER1 | IPT_JOYSTICK_DOWN },
	{ "P1_JOYSTICK_LEFT",		IKT_IPT,		IPF_PLAYER1 | IPT_JOYSTICK_LEFT },
	{ "P1_JOYSTICK_RIGHT",		IKT_IPT,		IPF_PLAYER1 | IPT_JOYSTICK_RIGHT },
	{ "P1_BUTTON1",				IKT_IPT,		IPF_PLAYER1 | IPT_BUTTON1 },
	{ "P1_BUTTON2",				IKT_IPT,		IPF_PLAYER1 | IPT_BUTTON2 },
	{ "P1_BUTTON3",				IKT_IPT,		IPF_PLAYER1 | IPT_BUTTON3 },
	{ "P1_BUTTON4",				IKT_IPT,		IPF_PLAYER1 | IPT_BUTTON4 },
	{ "P1_BUTTON5",				IKT_IPT,		IPF_PLAYER1 | IPT_BUTTON5 },
	{ "P1_BUTTON6",				IKT_IPT,		IPF_PLAYER1 | IPT_BUTTON6 },
	{ "P1_BUTTON7",				IKT_IPT,		IPF_PLAYER1 | IPT_BUTTON7 },
	{ "P1_BUTTON8",				IKT_IPT,		IPF_PLAYER1 | IPT_BUTTON8 },
	{ "P1_BUTTON9",				IKT_IPT,		IPF_PLAYER1 | IPT_BUTTON9 },
	{ "P1_BUTTON10",			IKT_IPT,		IPF_PLAYER1 | IPT_BUTTON10 },
#ifdef USE_CUSTOM_BUTTON
	{ "P1_CUSTOM1",				IKT_IPT,		IPF_PLAYER1 | IPT_CUSTOM1 },
	{ "P1_CUSTOM2",				IKT_IPT,		IPF_PLAYER1 | IPT_CUSTOM2 },
	{ "P1_CUSTOM3",				IKT_IPT,		IPF_PLAYER1 | IPT_CUSTOM3 },
	{ "P1_CUSTOM4",				IKT_IPT,		IPF_PLAYER1 | IPT_CUSTOM4 },
#endif /* USE_CUSTOM_BUTTON */
	{ "P1_JOYSTICKRIGHT_UP",	IKT_IPT,		IPF_PLAYER1 | IPT_JOYSTICKRIGHT_UP },
	{ "P1_JOYSTICKRIGHT_DOWN",	IKT_IPT,		IPF_PLAYER1 | IPT_JOYSTICKRIGHT_DOWN },
	{ "P1_JOYSTICKRIGHT_LEFT",	IKT_IPT,		IPF_PLAYER1 | IPT_JOYSTICKRIGHT_LEFT },
	{ "P1_JOYSTICKRIGHT_RIGHT",	IKT_IPT,		IPF_PLAYER1 | IPT_JOYSTICKRIGHT_RIGHT },
	{ "P1_JOYSTICKLEFT_UP",		IKT_IPT,		IPF_PLAYER1 | IPT_JOYSTICKLEFT_UP },
	{ "P1_JOYSTICKLEFT_DOWN",	IKT_IPT,		IPF_PLAYER1 | IPT_JOYSTICKLEFT_DOWN },
	{ "P1_JOYSTICKLEFT_LEFT",	IKT_IPT,		IPF_PLAYER1 | IPT_JOYSTICKLEFT_LEFT },
	{ "P1_JOYSTICKLEFT_RIGHT",	IKT_IPT,		IPF_PLAYER1 | IPT_JOYSTICKLEFT_RIGHT },

	{ "P2_JOYSTICK_UP",			IKT_IPT,		IPF_PLAYER2 | IPT_JOYSTICK_UP },
	{ "P2_JOYSTICK_DOWN",		IKT_IPT,		IPF_PLAYER2 | IPT_JOYSTICK_DOWN },
	{ "P2_JOYSTICK_LEFT",		IKT_IPT,		IPF_PLAYER2 | IPT_JOYSTICK_LEFT },
	{ "P2_JOYSTICK_RIGHT",		IKT_IPT,		IPF_PLAYER2 | IPT_JOYSTICK_RIGHT },
	{ "P2_BUTTON1",				IKT_IPT,		IPF_PLAYER2 | IPT_BUTTON1 },
	{ "P2_BUTTON2",				IKT_IPT,		IPF_PLAYER2 | IPT_BUTTON2 },
	{ "P2_BUTTON3",				IKT_IPT,		IPF_PLAYER2 | IPT_BUTTON3 },
	{ "P2_BUTTON4",				IKT_IPT,		IPF_PLAYER2 | IPT_BUTTON4 },
	{ "P2_BUTTON5",				IKT_IPT,		IPF_PLAYER2 | IPT_BUTTON5 },
	{ "P2_BUTTON6",				IKT_IPT,		IPF_PLAYER2 | IPT_BUTTON6 },
	{ "P2_BUTTON7",				IKT_IPT,		IPF_PLAYER2 | IPT_BUTTON7 },
	{ "P2_BUTTON8",				IKT_IPT,		IPF_PLAYER2 | IPT_BUTTON8 },
	{ "P2_BUTTON9",				IKT_IPT,		IPF_PLAYER2 | IPT_BUTTON9 },
	{ "P2_BUTTON10",			IKT_IPT,		IPF_PLAYER2 | IPT_BUTTON10 },
#ifdef USE_CUSTOM_BUTTON
	{ "P2_CUSTOM1",				IKT_IPT,		IPF_PLAYER2 | IPT_CUSTOM1 },
	{ "P2_CUSTOM2",				IKT_IPT,		IPF_PLAYER2 | IPT_CUSTOM2 },
	{ "P2_CUSTOM3",				IKT_IPT,		IPF_PLAYER2 | IPT_CUSTOM3 },
	{ "P2_CUSTOM4",				IKT_IPT,		IPF_PLAYER2 | IPT_CUSTOM4 },
#endif /* USE_CUSTOM_BUTTON */
	{ "P2_JOYSTICKRIGHT_UP",	IKT_IPT,		IPF_PLAYER2 | IPT_JOYSTICKRIGHT_UP },
	{ "P2_JOYSTICKRIGHT_DOWN",	IKT_IPT,		IPF_PLAYER2 | IPT_JOYSTICKRIGHT_DOWN },
	{ "P2_JOYSTICKRIGHT_LEFT",	IKT_IPT,		IPF_PLAYER2 | IPT_JOYSTICKRIGHT_LEFT },
	{ "P2_JOYSTICKRIGHT_RIGHT",	IKT_IPT,		IPF_PLAYER2 | IPT_JOYSTICKRIGHT_RIGHT },
	{ "P2_JOYSTICKLEFT_UP",		IKT_IPT,		IPF_PLAYER2 | IPT_JOYSTICKLEFT_UP },
	{ "P2_JOYSTICKLEFT_DOWN",	IKT_IPT,		IPF_PLAYER2 | IPT_JOYSTICKLEFT_DOWN },
	{ "P2_JOYSTICKLEFT_LEFT",	IKT_IPT,		IPF_PLAYER2 | IPT_JOYSTICKLEFT_LEFT },
	{ "P2_JOYSTICKLEFT_RIGHT",	IKT_IPT,		IPF_PLAYER2 | IPT_JOYSTICKLEFT_RIGHT },

	{ "P3_JOYSTICK_UP",			IKT_IPT,		IPF_PLAYER3 | IPT_JOYSTICK_UP },
	{ "P3_JOYSTICK_DOWN",		IKT_IPT,		IPF_PLAYER3 | IPT_JOYSTICK_DOWN },
	{ "P3_JOYSTICK_LEFT",		IKT_IPT,		IPF_PLAYER3 | IPT_JOYSTICK_LEFT },
	{ "P3_JOYSTICK_RIGHT",		IKT_IPT,		IPF_PLAYER3 | IPT_JOYSTICK_RIGHT },
	{ "P3_BUTTON1",				IKT_IPT,		IPF_PLAYER3 | IPT_BUTTON1 },
	{ "P3_BUTTON2",				IKT_IPT,		IPF_PLAYER3 | IPT_BUTTON2 },
	{ "P3_BUTTON3",				IKT_IPT,		IPF_PLAYER3 | IPT_BUTTON3 },
	{ "P3_BUTTON4",				IKT_IPT,		IPF_PLAYER3 | IPT_BUTTON4 },
#ifdef USE_CUSTOM_BUTTON
	{ "P3_CUSTOM1",				IKT_IPT,		IPF_PLAYER3 | IPT_CUSTOM1 },
	{ "P3_CUSTOM2",				IKT_IPT,		IPF_PLAYER3 | IPT_CUSTOM2 },
	{ "P3_CUSTOM3",				IKT_IPT,		IPF_PLAYER3 | IPT_CUSTOM3 },
	{ "P3_CUSTOM4",				IKT_IPT,		IPF_PLAYER3 | IPT_CUSTOM4 },
#endif /* USE_CUSTOM_BUTTON */

	{ "P4_JOYSTICK_UP",			IKT_IPT,		IPF_PLAYER4 | IPT_JOYSTICK_UP },
	{ "P4_JOYSTICK_DOWN",		IKT_IPT,		IPF_PLAYER4 | IPT_JOYSTICK_DOWN },
	{ "P4_JOYSTICK_LEFT",		IKT_IPT,		IPF_PLAYER4 | IPT_JOYSTICK_LEFT },
	{ "P4_JOYSTICK_RIGHT",		IKT_IPT,		IPF_PLAYER4 | IPT_JOYSTICK_RIGHT },
	{ "P4_BUTTON1",				IKT_IPT,		IPF_PLAYER4 | IPT_BUTTON1 },
	{ "P4_BUTTON2",				IKT_IPT,		IPF_PLAYER4 | IPT_BUTTON2 },
	{ "P4_BUTTON3",				IKT_IPT,		IPF_PLAYER4 | IPT_BUTTON3 },
	{ "P4_BUTTON4",				IKT_IPT,		IPF_PLAYER4 | IPT_BUTTON4 },
#ifdef USE_CUSTOM_BUTTON
	{ "P4_CUSTOM1",				IKT_IPT,		IPF_PLAYER4 | IPT_CUSTOM1 },
	{ "P4_CUSTOM2",				IKT_IPT,		IPF_PLAYER4 | IPT_CUSTOM2 },
	{ "P4_CUSTOM3",				IKT_IPT,		IPF_PLAYER4 | IPT_CUSTOM3 },
	{ "P4_CUSTOM4",				IKT_IPT,		IPF_PLAYER4 | IPT_CUSTOM4 },
#endif /* USE_CUSTOM_BUTTON */

	{ "P1_PEDAL	",				IKT_IPT,		IPF_PLAYER1 | IPT_PEDAL },
	{ "P1_PEDAL_EXT",			IKT_IPT_EXT,	IPF_PLAYER1 | IPT_PEDAL },
	{ "P2_PEDAL",				IKT_IPT,		IPF_PLAYER2 | IPT_PEDAL },
	{ "P2_PEDAL_EXT",			IKT_IPT_EXT,	IPF_PLAYER2 | IPT_PEDAL },
	{ "P3_PEDAL",				IKT_IPT,		IPF_PLAYER3 | IPT_PEDAL },
	{ "P3_PEDAL_EXT",			IKT_IPT_EXT,	IPF_PLAYER3 | IPT_PEDAL },
	{ "P4_PEDAL",				IKT_IPT,		IPF_PLAYER4 | IPT_PEDAL },
	{ "P4_PEDAL_EXT",			IKT_IPT_EXT,	IPF_PLAYER4 | IPT_PEDAL },

	{ "P1_PEDAL2",				IKT_IPT,		IPF_PLAYER1 | IPT_PEDAL2 },
	{ "P1_PEDAL2_EXT",			IKT_IPT_EXT,	IPF_PLAYER1 | IPT_PEDAL2 },
	{ "P2_PEDAL2",				IKT_IPT,		IPF_PLAYER2 | IPT_PEDAL2 },
	{ "P2_PEDAL2_EXT",			IKT_IPT_EXT,	IPF_PLAYER2 | IPT_PEDAL2 },
	{ "P3_PEDAL2",				IKT_IPT,		IPF_PLAYER3 | IPT_PEDAL2 },
	{ "P3_PEDAL2_EXT",			IKT_IPT_EXT,	IPF_PLAYER3 | IPT_PEDAL2 },
	{ "P4_PEDAL2",				IKT_IPT,		IPF_PLAYER4 | IPT_PEDAL2 },
	{ "P4_PEDAL2_EXT",			IKT_IPT_EXT,	IPF_PLAYER4 | IPT_PEDAL2 },

	{ "P1_PADDLE",				IKT_IPT,		IPF_PLAYER1 | IPT_PADDLE },
	{ "P1_PADDLE_EXT",			IKT_IPT_EXT,	IPF_PLAYER1 | IPT_PADDLE },
	{ "P2_PADDLE",				IKT_IPT,		IPF_PLAYER2 | IPT_PADDLE },
	{ "P2_PADDLE_EXT",			IKT_IPT_EXT,	IPF_PLAYER2 | IPT_PADDLE },
	{ "P3_PADDLE",				IKT_IPT,		IPF_PLAYER3 | IPT_PADDLE },
	{ "P3_PADDLE_EXT",			IKT_IPT_EXT,	IPF_PLAYER3 | IPT_PADDLE },
	{ "P4_PADDLE",				IKT_IPT,		IPF_PLAYER4 | IPT_PADDLE },
	{ "P4_PADDLE_EXT",			IKT_IPT_EXT,	IPF_PLAYER4 | IPT_PADDLE },
	{ "P1_PADDLE_V",			IKT_IPT,		IPF_PLAYER1 | IPT_PADDLE_V },
	{ "P1_PADDLE_V_EXT",		IKT_IPT_EXT,	IPF_PLAYER1 | IPT_PADDLE_V },
	{ "P2_PADDLE_V",			IKT_IPT,		IPF_PLAYER2 | IPT_PADDLE_V },
	{ "P2_PADDLE_V_EXT",		IKT_IPT_EXT,	IPF_PLAYER2 | IPT_PADDLE_V },
	{ "P3_PADDLE_V",			IKT_IPT,		IPF_PLAYER3 | IPT_PADDLE_V },
	{ "P3_PADDLE_V_EXT",		IKT_IPT_EXT,	IPF_PLAYER3 | IPT_PADDLE_V },
	{ "P4_PADDLE_V",			IKT_IPT,		IPF_PLAYER4 | IPT_PADDLE_V },
	{ "P4_PADDLE_V_EXT",		IKT_IPT_EXT,	IPF_PLAYER4 | IPT_PADDLE_V },

	{ "P1_DIAL",				IKT_IPT,		IPF_PLAYER1 | IPT_DIAL },
	{ "P1_DIAL_EXT",			IKT_IPT_EXT,	IPF_PLAYER1 | IPT_DIAL },
	{ "P2_DIAL",				IKT_IPT,		IPF_PLAYER2 | IPT_DIAL },
	{ "P2_DIAL_EXT",			IKT_IPT_EXT,	IPF_PLAYER2 | IPT_DIAL },
	{ "P3_DIAL",				IKT_IPT,		IPF_PLAYER3 | IPT_DIAL },
	{ "P3_DIAL_EXT",			IKT_IPT_EXT,	IPF_PLAYER3 | IPT_DIAL },
	{ "P4_DIAL",				IKT_IPT,		IPF_PLAYER4 | IPT_DIAL },
	{ "P4_DIAL_EXT",			IKT_IPT_EXT,	IPF_PLAYER4 | IPT_DIAL },
	{ "P1_DIAL_V",				IKT_IPT,		IPF_PLAYER1 | IPT_DIAL_V },
	{ "P1_DIAL_V_EXT",			IKT_IPT_EXT,	IPF_PLAYER1 | IPT_DIAL_V },
	{ "P2_DIAL_V",				IKT_IPT,		IPF_PLAYER2 | IPT_DIAL_V },
	{ "P2_DIAL_V_EXT",			IKT_IPT_EXT,	IPF_PLAYER2 | IPT_DIAL_V },
	{ "P3_DIAL_V",				IKT_IPT,		IPF_PLAYER3 | IPT_DIAL_V },
	{ "P3_DIAL_V_EXT",			IKT_IPT_EXT,	IPF_PLAYER3 | IPT_DIAL_V },
	{ "P4_DIAL_V",				IKT_IPT,		IPF_PLAYER4 | IPT_DIAL_V },
	{ "P4_DIAL_V_EXT",			IKT_IPT_EXT,	IPF_PLAYER4 | IPT_DIAL_V },

	{ "P1_TRACKBALL_X",			IKT_IPT,		IPF_PLAYER1 | IPT_TRACKBALL_X },
	{ "P1_TRACKBALL_X_EXT",		IKT_IPT_EXT,	IPF_PLAYER1 | IPT_TRACKBALL_X },
	{ "P2_TRACKBALL_X",			IKT_IPT,		IPF_PLAYER2 | IPT_TRACKBALL_X },
	{ "P2_TRACKBALL_X_EXT",		IKT_IPT_EXT,	IPF_PLAYER2 | IPT_TRACKBALL_X },
	{ "P3_TRACKBALL_X",			IKT_IPT,		IPF_PLAYER3 | IPT_TRACKBALL_X },
	{ "P3_TRACKBALL_X_EXT",		IKT_IPT_EXT,	IPF_PLAYER3 | IPT_TRACKBALL_X },
	{ "P4_TRACKBALL_X",			IKT_IPT,		IPF_PLAYER4 | IPT_TRACKBALL_X },
	{ "P4_TRACKBALL_X_EXT",		IKT_IPT_EXT,	IPF_PLAYER4 | IPT_TRACKBALL_X },

	{ "P1_TRACKBALL_Y",			IKT_IPT,		IPF_PLAYER1 | IPT_TRACKBALL_Y },
	{ "P1_TRACKBALL_Y_EXT",		IKT_IPT_EXT,	IPF_PLAYER1 | IPT_TRACKBALL_Y },
	{ "P2_TRACKBALL_Y",			IKT_IPT,		IPF_PLAYER2 | IPT_TRACKBALL_Y },
	{ "P2_TRACKBALL_Y_EXT",		IKT_IPT_EXT,	IPF_PLAYER2 | IPT_TRACKBALL_Y },
	{ "P3_TRACKBALL_Y",			IKT_IPT,		IPF_PLAYER3 | IPT_TRACKBALL_Y },
	{ "P3_TRACKBALL_Y_EXT",		IKT_IPT_EXT,	IPF_PLAYER3 | IPT_TRACKBALL_Y },
	{ "P4_TRACKBALL_Y",			IKT_IPT,		IPF_PLAYER4 | IPT_TRACKBALL_Y },
	{ "P4_TRACKBALL_Y_EXT",		IKT_IPT_EXT,	IPF_PLAYER4 | IPT_TRACKBALL_Y },

	{ "P1_AD_STICK_X",			IKT_IPT,		IPF_PLAYER1 | IPT_AD_STICK_X },
	{ "P1_AD_STICK_X_EXT",		IKT_IPT_EXT,	IPF_PLAYER1 | IPT_AD_STICK_X },
	{ "P2_AD_STICK_X",			IKT_IPT,		IPF_PLAYER2 | IPT_AD_STICK_X },
	{ "P2_AD_STICK_X_EXT",		IKT_IPT_EXT,	IPF_PLAYER2 | IPT_AD_STICK_X },
	{ "P3_AD_STICK_X",			IKT_IPT,		IPF_PLAYER3 | IPT_AD_STICK_X },
	{ "P3_AD_STICK_X_EXT",		IKT_IPT_EXT,	IPF_PLAYER3 | IPT_AD_STICK_X },
	{ "P4_AD_STICK_X",			IKT_IPT,		IPF_PLAYER4 | IPT_AD_STICK_X },
	{ "P4_AD_STICK_X_EXT",		IKT_IPT_EXT,	IPF_PLAYER4 | IPT_AD_STICK_X },

	{ "P1_AD_STICK_Y",			IKT_IPT,		IPF_PLAYER1 | IPT_AD_STICK_Y },
	{ "P1_AD_STICK_Y_EXT",		IKT_IPT_EXT,	IPF_PLAYER1 | IPT_AD_STICK_Y },
	{ "P2_AD_STICK_Y",			IKT_IPT,		IPF_PLAYER2 | IPT_AD_STICK_Y },
	{ "P2_AD_STICK_Y_EXT",		IKT_IPT_EXT,	IPF_PLAYER2 | IPT_AD_STICK_Y },
	{ "P3_AD_STICK_Y",			IKT_IPT,		IPF_PLAYER3 | IPT_AD_STICK_Y },
	{ "P3_AD_STICK_Y_EXT",		IKT_IPT_EXT,	IPF_PLAYER3 | IPT_AD_STICK_Y },
	{ "P4_AD_STICK_Y",			IKT_IPT,		IPF_PLAYER4 | IPT_AD_STICK_Y },
	{ "P4_AD_STICK_Y_EXT",		IKT_IPT_EXT,	IPF_PLAYER4 | IPT_AD_STICK_Y },

	{ "P1_LIGHTGUN_X",			IKT_IPT,		IPF_PLAYER1 | IPT_LIGHTGUN_X },
	{ "P1_LIGHTGUN_X_EXT",		IKT_IPT_EXT,	IPF_PLAYER1 | IPT_LIGHTGUN_X },
	{ "P2_LIGHTGUN_X",			IKT_IPT,		IPF_PLAYER2 | IPT_LIGHTGUN_X },
	{ "P2_LIGHTGUN_X_EXT",		IKT_IPT_EXT,	IPF_PLAYER2 | IPT_LIGHTGUN_X },
	{ "P3_LIGHTGUN_X",			IKT_IPT,		IPF_PLAYER3 | IPT_LIGHTGUN_X },
	{ "P3_LIGHTGUN_X_EXT",		IKT_IPT_EXT,	IPF_PLAYER3 | IPT_LIGHTGUN_X },
	{ "P4_LIGHTGUN_X",			IKT_IPT,		IPF_PLAYER4 | IPT_LIGHTGUN_X },
	{ "P4_LIGHTGUN_X_EXT",		IKT_IPT_EXT,	IPF_PLAYER4 | IPT_LIGHTGUN_X },

	{ "P1_LIGHTGUN_Y",			IKT_IPT,		IPF_PLAYER1 | IPT_LIGHTGUN_Y },
	{ "P1_LIGHTGUN_Y_EXT",		IKT_IPT_EXT,	IPF_PLAYER1 | IPT_LIGHTGUN_Y },
	{ "P2_LIGHTGUN_Y",			IKT_IPT,		IPF_PLAYER2 | IPT_LIGHTGUN_Y },
	{ "P2_LIGHTGUN_Y_EXT",		IKT_IPT_EXT,	IPF_PLAYER2 | IPT_LIGHTGUN_Y },
	{ "P3_LIGHTGUN_Y",			IKT_IPT,		IPF_PLAYER3 | IPT_LIGHTGUN_Y },
	{ "P3_LIGHTGUN_Y_EXT",		IKT_IPT_EXT,	IPF_PLAYER3 | IPT_LIGHTGUN_Y },
	{ "P4_LIGHTGUN_Y",			IKT_IPT,		IPF_PLAYER4 | IPT_LIGHTGUN_Y },
	{ "P4_LIGHTGUN_Y_EXT",		IKT_IPT_EXT,	IPF_PLAYER4 | IPT_LIGHTGUN_Y },

	{ "P1_AD_STICK_Z",			IKT_IPT,		IPF_PLAYER1 | IPT_AD_STICK_Z },
	{ "P1_AD_STICK_Z_EXT",		IKT_IPT_EXT,	IPF_PLAYER1 | IPT_AD_STICK_Z },
	{ "P2_AD_STICK_Z",			IKT_IPT,		IPF_PLAYER2 | IPT_AD_STICK_Z },
	{ "P2_AD_STICK_Z_EXT",		IKT_IPT_EXT,	IPF_PLAYER2 | IPT_AD_STICK_Z },
	{ "P3_AD_STICK_Z",			IKT_IPT,		IPF_PLAYER3 | IPT_AD_STICK_Z },
	{ "P3_AD_STICK_Z_EXT",		IKT_IPT_EXT,	IPF_PLAYER3 | IPT_AD_STICK_Z },
	{ "P4_AD_STICK_Z",			IKT_IPT,		IPF_PLAYER4 | IPT_AD_STICK_Z },
	{ "P4_AD_STICK_Z_EXT",		IKT_IPT_EXT,	IPF_PLAYER4 | IPT_AD_STICK_Z },

	{ "OSD_1",					IKT_IPT,		IPT_OSD_1 },
	{ "OSD_2",					IKT_IPT,		IPT_OSD_2 },
	{ "OSD_3",					IKT_IPT,		IPT_OSD_3 },
	{ "OSD_4",					IKT_IPT,		IPT_OSD_4 },

	{ "UNKNOWN",				IKT_IPT,		IPT_UNKNOWN },
	{ "END",					IKT_IPT,		IPT_END },

	{ "",						0,	0 }
};

int num_ik = sizeof(input_keywords)/sizeof(struct ik);

/***************************************************************************/
/* Generic IO */

static int readint(void *f,UINT32 *num)
{
	unsigned i;

	*num = 0;
	for (i = 0;i < sizeof(UINT32);i++)
	{
		unsigned char c;


		*num <<= 8;
		if (osd_fread(f,&c,1) != 1)
			return -1;
		*num |= c;
	}

	return 0;
}

static void writeint(void *f,UINT32 num)
{
	unsigned i;

	for (i = 0;i < sizeof(UINT32);i++)
	{
		unsigned char c;


		c = (num >> 8 * (sizeof(UINT32)-1)) & 0xff;
		osd_fwrite(f,&c,1);
		num <<= 8;
	}
}

static int readword(void *f,UINT16 *num)
{
	unsigned i;
	int res;

	res = 0;
	for (i = 0;i < sizeof(UINT16);i++)
	{
		unsigned char c;


		res <<= 8;
		if (osd_fread(f,&c,1) != 1)
			return -1;
		res |= c;
	}

	*num = res;
	return 0;
}

static void writeword(void *f,UINT16 num)
{
	unsigned i;

	for (i = 0;i < sizeof(UINT16);i++)
	{
		unsigned char c;


		c = (num >> 8 * (sizeof(UINT16)-1)) & 0xff;
		osd_fwrite(f,&c,1);
		num <<= 8;
	}
}

#ifndef NOLEGACY
#include "legacy.h"
#endif

static int seq_read_ver_8(void* f, InputSeq* seq)
{
	int j,len;
	UINT32 i;
	UINT16 w;

	if (readword(f,&w) != 0)
		return -1;

	len = w;
	seq_set_0(seq);
	for(j=0;j<len;++j)
	{
		if (readint(f,&i) != 0)
 			return -1;
		(*seq)[j] = savecode_to_code(i);
 	}

 	return 0;
  }

static int seq_read(void* f, InputSeq* seq, int ver)
  {
#ifdef NOLEGACY
	if (ver==8)
		return seq_read_ver_8(f,seq);
#else
	switch (ver) {
		case 5 : return seq_read_ver_5(f,seq);
		case 6 : return seq_read_ver_6(f,seq);
		case 7 : return seq_read_ver_7(f,seq);
		case 8 : return seq_read_ver_8(f,seq);
	}
#endif
	return -1;
  }

static void seq_write(void* f, InputSeq* seq)
  {
	int j,len;
        for(len=0;len<SEQ_MAX;++len)
		if ((*seq)[len] == CODE_NONE)
			break;
	writeword(f,len);
	for(j=0;j<len;++j)
		writeint(f, code_to_savecode( (*seq)[j] ));
  }

/***************************************************************************/
/* Load */

static void load_default_keys(void)
{
	void *f;


#ifdef MAME32JP
	memset(autopressed, 0, MAX_INPUT_BITS);
	autofire_enable = 0;

	if (options.autofiredelay <= 0)
		options.autofiredelay = 1;
#endif

	osd_customize_inputport_defaults(inputport_defaults);
	memcpy(inputport_defaults_backup,inputport_defaults,sizeof(inputport_defaults));

	if ((f = osd_fopen("default",0,OSD_FILETYPE_CONFIG,0)) != 0)
	{
		char buf[8];
		int version;

		/* read header */
		if (osd_fread(f,buf,8) != 8)
			goto getout;

		if (memcmp(buf,MAMEDEFSTRING_V5,8) == 0)
			version = 5;
		else if (memcmp(buf,MAMEDEFSTRING_V6,8) == 0)
			version = 6;
		else if (memcmp(buf,MAMEDEFSTRING_V7,8) == 0)
			version = 7;
		else if (memcmp(buf,MAMEDEFSTRING_V8,8) == 0)
			version = 8;
		else
			goto getout;	/* header invalid */

		for (;;)
		{
			UINT32 type;
			InputSeq def_seq;
			InputSeq seq;
			int i;

			if (readint(f,&type) != 0)
				goto getout;

			if (seq_read(f,&def_seq,version)!=0)
				goto getout;
			if (seq_read(f,&seq,version)!=0)
				goto getout;

			i = 0;
			while (inputport_defaults[i].type != IPT_END)
			{
				if (inputport_defaults[i].type == type)
				{
					/* load stored settings only if the default hasn't changed */
					if (seq_cmp(&inputport_defaults[i].seq,&def_seq)==0)
						seq_copy(&inputport_defaults[i].seq,&seq);
				}

				i++;
			}
		}

getout:
		osd_fclose(f);
	}
}

static void save_default_keys(void)
{
	void *f;


	if ((f = osd_fopen("default",0,OSD_FILETYPE_CONFIG,1)) != 0)
	{
		int i;


		/* write header */
		osd_fwrite(f,MAMEDEFSTRING_V8,8);

		i = 0;
		while (inputport_defaults[i].type != IPT_END)
		{
			if (inputport_defaults[i].type != IPT_OSD_RESERVED)
			{
				writeint(f,inputport_defaults[i].type);

				seq_write(f,&inputport_defaults_backup[i].seq);
				seq_write(f,&inputport_defaults[i].seq);
			}

			i++;
		}

		osd_fclose(f);
	}
	memcpy(inputport_defaults,inputport_defaults_backup,sizeof(inputport_defaults_backup));
}

static int input_port_read_ver_8(void *f,struct InputPort *in)
{
	UINT32 i;
	UINT16 w;
	if (readint(f,&i) != 0)
		return -1;
	in->type = i;

	if (readword(f,&w) != 0)
		return -1;
	in->mask = w;

	if (readword(f,&w) != 0)
		return -1;
	in->default_value = w;

	if (seq_read_ver_8(f,&in->seq) != 0)
		return -1;

	return 0;
}

static int input_port_read(void *f,struct InputPort *in, int ver)
{
#ifdef NOLEGACY
	if (ver==8)
		return input_port_read_ver_8(f,in);
#else
	switch (ver) {
		case 5 : return	input_port_read_ver_5(f,in);
		case 6 : return	input_port_read_ver_6(f,in);
		case 7 : return	input_port_read_ver_7(f,in);
		case 8 : return	input_port_read_ver_8(f,in);
	}
#endif
	return -1;
}

static void input_port_write(void *f,struct InputPort *in)
{
	writeint(f,in->type);
	writeword(f,in->mask);
	writeword(f,in->default_value);
	seq_write(f,&in->seq);
}

//kt s
static void scale_analog_port(int port);
void kAnalog_input_port_clear(void)
{
	int i;
	for(i=0;i<MAX_INPUT_PORTS ;i++) {
		input_analog_previous_value[i] = 0;//
		input_analog_current_value[i] = 0;
	}

	for(i=0;i<OSD_MAX_JOY_ANALOG ;i++) {

		mouse_delta_x[i]		= 0; mouse_delta_y[i]		= 0;
		analog_current_x[i]		= 0; analog_current_y[i]	= 0;
		analog_previous_x[i]	= 0; analog_previous_y[i]	= 0;

	}
}

void kAnalog_input_port_end(void)
{
	extern int kPlay;
	int port;

	if(!kPlay) return;

	for (port = 0;port < MAX_INPUT_PORTS;port++)
	{
		input_port_value[port] = 0;
		input_vblank[port] = 0;
		input_analog[port] = 0;
	}
}
//kt e


int load_input_port_settings(void)
{
	void *f;
#ifdef MAME_NET
    struct InputPort *in;
    int port, player;
#endif /* MAME_NET */


	load_default_keys();

#ifdef MAME32JP
	volume_multiplier = 10 << 8;
#endif

	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_CONFIG,0)) != 0)
	{
#ifndef MAME_NET
		struct InputPort *in;
#endif
		unsigned int total,savedtotal;
		char buf[8];
		int i;
		int version;

#ifdef USE_CUSTOM_BUTTON
		memset(custom_button, 0, sizeof(custom_button));
#endif /* USE_CUSTOM_BUTTON */

		in = Machine->input_ports_default;

		/* calculate the size of the array */
		total = 0;
		while (in->type != IPT_END)
		{
			total++;
			in++;
		}

		/* read header */
		if (osd_fread(f,buf,8) != 8)
			goto getout;

		if (memcmp(buf,MAMECFGSTRING_V5,8) == 0)
			version = 5;
		else if (memcmp(buf,MAMECFGSTRING_V6,8) == 0)
			version = 6;
		else if (memcmp(buf,MAMECFGSTRING_V7,8) == 0)
			version = 7;
		else if (memcmp(buf,MAMECFGSTRING_V8,8) == 0)
			version = 8;
		else
			goto getout;	/* header invalid */

		/* read array size */
		if (readint(f,&savedtotal) != 0)
			goto getout;
		if (total != savedtotal)
			goto getout;	/* different size */

		/* read the original settings and compare them with the ones defined in the driver */
		in = Machine->input_ports_default;
		while (in->type != IPT_END)
		{
			struct InputPort saved;

			if (input_port_read(f,&saved,version) != 0)
				goto getout;

			if (in->mask != saved.mask ||
				in->default_value != saved.default_value ||
				in->type != saved.type ||
				seq_cmp(&in->seq,&saved.seq) !=0 )
			goto getout;	/* the default values are different */

			in++;
		}

		/* read the current settings */
		in = Machine->input_ports;
		while (in->type != IPT_END)
		{
			if (input_port_read(f,in,version) != 0)
				goto getout;
			in++;
		}

		/* Clear the coin & ticket counters/flags - LBO 042898 */
		for (i = 0; i < COIN_COUNTERS; i ++)
			coins[i] = lastcoin[i] = coinlockedout[i] = 0;
		dispensed_tickets = 0;

		/* read in the coin/ticket counters */
		for (i = 0; i < COIN_COUNTERS; i ++)
		{
			if (readint(f,&coins[i]) != 0)
				goto getout;
		}
		if (readint(f,&dispensed_tickets) != 0)
			goto getout;

#ifdef USE_CUSTOM_BUTTON
				{
					int p, b;

					for (p = 0; p < players; p++)
						for (b = 0; b < custom_buttons; b++)
							if (readword(f, &custom_button[p][b]) != 0)
								goto getout;
				}
#endif /* USE_CUSTOM_BUTTON */

		mixer_read_config(f);
#ifdef MAME32JP
		{
			INT32 n;

			if (osd_fread(f, &n, sizeof(INT32)) != 0)
				volume_multiplier = n;
		}
#endif

getout:
		osd_fclose(f);
	}

	/* All analog ports need initialization */
	{
		int i;
		for (i = 0; i < MAX_INPUT_PORTS; i++)
			input_analog_init[i] = 1;
	}
#ifdef MAME_NET
	/* Find out what port is used by what player and swap regular inputs */
	in = Machine->input_ports;

//	if (in->type == IPT_END) return; 	/* nothing to do */

	/* make sure the InputPort definition is correct */
//	if (in->type != IPT_PORT)
//	{
//		logerror("Error in InputPort definition: expecting PORT_START\n");
//		return;
//	}
//	else in++;
	in++;

	/* scan all the input ports */
	port = 0;
	while (in->type != IPT_END && port < MAX_INPUT_PORTS)
	{
		/* now check the input bits. */
		while (in->type != IPT_END && in->type != IPT_PORT)
		{
			if ((in->type & ~IPF_MASK) != IPT_DIPSWITCH_SETTING &&	/* skip dipswitch definitions */
				(in->type & ~IPF_MASK) != IPT_EXTENSION &&			/* skip analog extension fields */
				(in->type & IPF_UNUSED) == 0 &&						/* skip unused bits */
				!(!options.cheat && (in->type & IPF_CHEAT)) &&				/* skip cheats if cheats disabled */
				(in->type & ~IPF_MASK) != IPT_VBLANK &&				/* skip vblank stuff */
				((in->type & ~IPF_MASK) >= IPT_COIN1 &&				/* skip if coin input and it's locked out */
				(in->type & ~IPF_MASK) <= IPT_COIN4 &&
                 coinlockedout[(in->type & ~IPF_MASK) - IPT_COIN1]))
			{
				player = 0;
				if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER2) player = 1;
				else if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER3) player = 2;
				else if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER4) player = 3;

				if (((in->type & ~IPF_MASK) > IPT_ANALOG_START)
					&& ((in->type & ~IPF_MASK) < IPT_ANALOG_END))
				{
					analog_player_port[port] = player;
				}
				if (((in->type & ~IPF_MASK) == IPT_BUTTON1) ||
					((in->type & ~IPF_MASK) == IPT_BUTTON2) ||
					((in->type & ~IPF_MASK) == IPT_BUTTON3) ||
					((in->type & ~IPF_MASK) == IPT_BUTTON4) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICK_UP) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICK_DOWN) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICK_LEFT) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICK_RIGHT) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKRIGHT_UP) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKRIGHT_DOWN) ||
 					((in->type & ~IPF_MASK) == IPT_JOYSTICKRIGHT_LEFT) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKRIGHT_RIGHT) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKLEFT_UP) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKLEFT_DOWN) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKLEFT_LEFT) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKLEFT_RIGHT) ||
					((in->type & ~IPF_MASK) == IPT_PADDLE) ||
					((in->type & ~IPF_MASK) == IPT_DIAL) ||
					((in->type & ~IPF_MASK) == IPT_TRACKBALL_X) ||
					((in->type & ~IPF_MASK) == IPT_TRACKBALL_Y) ||
					((in->type & ~IPF_MASK) == IPT_AD_STICK_X) ||
					((in->type & ~IPF_MASK) == IPT_AD_STICK_Y))
				{
					switch (default_player)
					{
						case 0:
							/* do nothing */
							break;
						case 1:
							if (player == 0)
							{
								in->type &= ~IPF_PLAYER1;
								in->type |= IPF_PLAYER2;
							}
							else if (player == 1)
							{
								in->type &= ~IPF_PLAYER2;
								in->type |= IPF_PLAYER1;
							}
							break;
						case 2:
							if (player == 0)
							{
								in->type &= ~IPF_PLAYER1;
								in->type |= IPF_PLAYER3;
							}
							else if (player == 2)
							{
								in->type &= ~IPF_PLAYER3;
								in->type |= IPF_PLAYER1;
							}
							break;
						case 3:
							if (player == 0)
							{
								in->type &= ~IPF_PLAYER1;
								in->type |= IPF_PLAYER4;
							}
							else if (player == 3)
							{
								in->type &= ~IPF_PLAYER4;
								in->type |= IPF_PLAYER1;
							}
							break;
					}
				}
			}
			in++;
		}
		port++;
		if (in->type == IPT_PORT) in++;
	}

	/* TODO: at this point the games should initialize peers to same as server */

#endif /* MAME_NET */
kAnalog_input_port_clear();//kt
#ifdef KAILLERA
	if (kPlay)
	{
		struct InputPort *in;
		int port;
		int KAnalogCtrl = -1;	//kt	KaillerãAiORg[gp
		int Dipswitch_ServiceMode = -1;	//kt
		int is6button = 0;

		KailleraStartOption.gameinputmin = 0;
		// Sega
		if (!strcmp(Machine->gamedrv->name, "ga2j4p"))			KailleraStartOption.gameinputmin = 4;
		// Naamco
		if (!strcmp(Machine->gamedrv->name, "numanath"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "numanatj"))		KailleraStartOption.gameinputmin = 4;
		// Konami
		if (!strcmp(Machine->gamedrv->name, "vendetta"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "vendetao"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "esckids"))			KailleraStartOption.gameinputmin = 4;
		// Copcom
		if (!strcmp(Machine->gamedrv->name, "captcomm3p"))		KailleraStartOption.gameinputmin = 3;
		if (!strcmp(Machine->gamedrv->name, "captcomu3p"))		KailleraStartOption.gameinputmin = 3;
		if (!strcmp(Machine->gamedrv->name, "captcomj3p"))		KailleraStartOption.gameinputmin = 3;
		if (!strcmp(Machine->gamedrv->name, "captcomm4p"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "captcomu4p"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "captcomj4p"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "avsp3p"))			KailleraStartOption.gameinputmin = 3;
		if (!strcmp(Machine->gamedrv->name, "avspu3p"))			KailleraStartOption.gameinputmin = 3;
		if (!strcmp(Machine->gamedrv->name, "avspj3p"))			KailleraStartOption.gameinputmin = 3;
		if (!strcmp(Machine->gamedrv->name, "avspa3p"))			KailleraStartOption.gameinputmin = 3;
		if (!strcmp(Machine->gamedrv->name, "batcir4p"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "batcirj4p"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "ddsom4p"))			KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "ddsomr2_4p"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "ddsomu4p"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "ddsomur1_4p"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "ddsomj4p"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "ddsomjr1_4p"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "ddsoma4p"))		KailleraStartOption.gameinputmin = 4;

#if 1
		// Psikyo
		if (!strcmp(Machine->gamedrv->name, "hotgmck_k"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "hgkairak_k"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "hotgmck3_k"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "hotgm4ev_k"))		KailleraStartOption.gameinputmin = 4;

		// Video System Co.
		if (!strcmp(Machine->gamedrv->name, "fromanc2_k"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "fromancr_k"))		KailleraStartOption.gameinputmin = 4;
		if (!strcmp(Machine->gamedrv->name, "fromanc4_k"))		KailleraStartOption.gameinputmin = 4;
#endif

		KailleraPlayerOption.subplayer = 0;
		KailleraPlayerOption.playercontrol = KailleraPlayerOption.subplayer;

		if (!strcmp(Machine->gamedrv->name, "gunlock"))		KAnalogCtrl = 0;
		if (!strcmp(Machine->gamedrv->name, "rayforce"))	KAnalogCtrl = 0;
		if (!strcmp(Machine->gamedrv->name, "rayforcj"))	KAnalogCtrl = 0;
		if (!strcmp(Machine->gamedrv->name, "dariusg"))		KAnalogCtrl = 0;
		if (!strcmp(Machine->gamedrv->name, "dariusgx"))	KAnalogCtrl = 0;
		if (!strcmp(Machine->gamedrv->name, "landmakr"))	KAnalogCtrl = 0;
		if (!strcmp(Machine->gamedrv->name, "ktiger2"))		KAnalogCtrl = 0;
		if (!strcmp(Machine->gamedrv->name, "twinqix"))		KAnalogCtrl = 0;
		if (!strcmp(Machine->gamedrv->name, "lightbr"))		KAnalogCtrl = 0;
		if (!strcmp(Machine->gamedrv->name, "gekirido"))	KAnalogCtrl = 0;


		memset(&kBitsPlayValues,-1,sizeof(kBitsPlayValues));
		memset(&kMahjongPlayValues,-1,sizeof(kMahjongPlayValues));	//kt
		memset(&kDipSwitchValues,-1,sizeof(kDipSwitchValues));		//kt
		memset(&kAnalogPlayValues,-1,sizeof(kAnalogPlayValues));	//kt
		kAnalog_input_port_clear();
		kMaxDipSwitch	= 0;	//kt
		kMaxMahjong		= 0;	//kt

		in = Machine->input_ports;
		in++;

		port = 0;
		while (in->type != IPT_END && port < MAX_INPUT_PORTS)
		{
			while (in->type != IPT_END && in->type != IPT_PORT)
			{
				int player=-1,pos=-1;
				int analog=-1,dipswitch=-1,mahjong=-1; //kt

				if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER1) player=0;
				if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER2) player=1;
				if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER3) player=2;
				if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER4) player=3;

				switch(in->type & ~IPF_MASK)
				{
				case IPT_BUTTON1:						pos=0; break;
				case IPT_BUTTON2:						pos=1; break;
				case IPT_BUTTON3:						pos=2; break;
				case IPT_BUTTON4:						pos=3; break;
				case IPT_BUTTON5:						pos=4; break;
				case IPT_BUTTON6:						pos=5; is6button=1; break;
				case IPT_BUTTON7:						pos=6; is6button=1; break;
				case IPT_JOYSTICK_UP:					pos=7; break;
				case IPT_JOYSTICK_DOWN:					pos=8; break;
				case IPT_JOYSTICK_LEFT:					pos=9; break;
				case IPT_JOYSTICK_RIGHT:				pos=10; break;

				case IPT_COIN1:				player=0;	pos=11; break;
				case IPT_START1:			player=0;	pos=12; break;

				case IPT_COIN2:				player=1;	pos=11; break;
				case IPT_START2:			player=1;	pos=12; break;

				case IPT_COIN3:				player=2;	pos=11; break;
				case IPT_START3:			player=2;	pos=12; break;

				case IPT_COIN4:				player=3;	pos=11; break;
				case IPT_START4:			player=3;	pos=12; break;

				//case IPT_UI_RESET_MACHINE:	player=0;	pos=13; break;
				//case IPT_SERVICE:			player=0;	pos=14; break;
				case IPT_SERVICE:
					if (!strcmp(Machine->gamedrv->source_file, "src/drivers/qix.c"))
					{
						if(!strcmp(in->name, "Test Advance"))	{ player=0;	pos =  3;	break;}
						if(!strcmp(in->name, "Test Next line"))	{ player=0;	pos = 14;	break;}
						if(!strcmp(in->name, "Test Slew Up"))	{ player=0;	pos =  4;	break;}
						if(!strcmp(in->name, "Test Slew Down"))	{ player=0;	pos =  5;	break;}
						break;
					}
					if (Dipswitch_ServiceMode == 0) break;
					player=0;	pos=14;	
					break;
				case IPT_SERVICE1:			player=0;	pos=15; break;

				case IPT_JOYSTICKRIGHT_UP:				pos= 7; break;
				case IPT_JOYSTICKRIGHT_DOWN:			pos= 8; break;
				case IPT_JOYSTICKRIGHT_LEFT:			pos= 9; break;
				case IPT_JOYSTICKRIGHT_RIGHT:			pos=10; break;

				case IPT_JOYSTICKLEFT_UP:				pos= 3; break;
				case IPT_JOYSTICKLEFT_DOWN:				pos= 4; break;
				case IPT_JOYSTICKLEFT_LEFT:				pos= 5; break;
				case IPT_JOYSTICKLEFT_RIGHT:			pos= 6; break;


				case IPT_PADDLE:			analog=0;	pos= 0; break;
				case IPT_PADDLE_V:			analog=0;	pos= 1; break;
				case IPT_DIAL:				analog=0;	pos= 2; break;
				case IPT_DIAL_V:			analog=0;	pos= 3; break;
				case IPT_TRACKBALL_X:		analog=0;	pos= 4; break;
				case IPT_TRACKBALL_Y:		analog=0;	pos= 5; break;
				case IPT_AD_STICK_X:		analog=0;	pos= 6; break;
				case IPT_AD_STICK_Y:		analog=0;	pos= 7; break;
				case IPT_PEDAL:				analog=0;	pos= 8; break;

				//case IPT_SERVICE1:								break;
				case IPT_SERVICE2:
					if (!strcmp(Machine->gamedrv->source_file, "src/drivers/playch10.c") &&
						!strcmp(in->name, "Channel Select"))	{ player=0;	pos =  3;	break;}
					break;
				case IPT_SERVICE3:
					if (!strcmp(Machine->gamedrv->source_file, "src/drivers/playch10.c") &&
						!strcmp(in->name, "Enter"))				{ player=0;	pos =  4;	break;}
					break;
				case IPT_SERVICE4:
					if (!strcmp(Machine->gamedrv->source_file, "src/drivers/playch10.c") &&
						!strcmp(in->name, "Reset"))				{ player=0;	pos =  5;	break;}
					break;

				case IPT_DIPSWITCH_NAME:

					if (!strcmp(Machine->gamedrv->source_file, "src/drivers/namcona1.c"))
						if (!strcmp(in->name, "Test"))	{ player=0;	pos =  4;	break;}

					if (!strcmp(in->name, DEF_STR( Service_Mode )) &&
						(in->type & IPF_MASK) == IPF_TOGGLE)
					{	//PORT_SERVICE(mask,default)
						player=0;	pos=14;	
						kBitsPlayValues[player][pos][0]=port;
						kBitsPlayValues[player][pos][1]=in->mask;
						if (in->default_value)	kBitsPlayValues[player][pos][2]=IP_ACTIVE_LOW;
						else					kBitsPlayValues[player][pos][2]=IP_ACTIVE_HIGH;
						Dipswitch_ServiceMode = 0;
						player=-1;	pos=-1;
						break;
					}

					player=0;	pos= 0;	dipswitch=0;
					break;
				case 0:	//mahjong
					{
						char ch[256];
						if( in->name == IP_NAME_DEFAULT )
							break;
						if( strlen(in->name)>255 )
							break;

						if (!strcmp(Machine->gamedrv->name, "gakusai")	||
							!strcmp(Machine->gamedrv->name, "gakusai2")) {
							player=0;
							strcpy(ch, (char*)in->name);
						} else {
							char pl[4];
							if( strlen(in->name)<4 )
								break;
							memcpy(pl, in->name, 3);
							pl[3] = 0;
							if (!strcmp(pl, "P1 "))	player=0;
							if (!strcmp(pl, "P2 "))	player=1;
							if (!strcmp(pl, "P3 "))	player=2;
							if (!strcmp(pl, "P4 "))	player=3;

							if (!strcmp(Machine->gamedrv->source_file, "src/drivers/vsnes.c"))
							{	// vsnes
								if (!strcmp(in->name, "2nd Side 1 Player Start"))	{ player=0;	pos =  4;	break;}
								if (!strcmp(in->name, "2nd Side 2 Player Start"))	{ player=1;	pos =  4;	break;}
								if (!strcmp(in->name, "2nd Side 3 Player Start"))	{ player=2;	pos =  4;	break;}
								if (!strcmp(in->name, "2nd Side 4 Player Start"))	{ player=3;	pos =  4;	break;}
							}
							if (!strcmp(Machine->gamedrv->source_file, "src/drivers/wmsyunit.c"))
							{
								if (!strcmp(in->name, "Advance"))	{ player=0;	pos = 14;	break;}
							}

							{
								//extern struct GameDriver driver_neogeo;
								//if(Machine->gamedrv->clone_of == &driver_neogeo)
								if(!strcmp(Machine->gamedrv->source_file, "src/drivers/neogeo.c"))
									if(in->name) {
										if(!strcmp(in->name, "Test Switch"))	{ player=0;	pos=14; break;}
										if(!strcmp(in->name, "SELECT 1"))		{ player=0;	pos= 4; break;}
										if(!strcmp(in->name, "SELECT 2"))		{ player=1;	pos= 4; break;}
									}
							}


							strcpy(ch, (char*)in->name+3);
						}

						if (!strcmp(ch, "Flip"))		{ pos =  0; mahjong=0;}
						if (!strcmp(ch, "Flip Flop"))	{ pos =  0; mahjong=0;}	//sub
						if (!strcmp(ch, "FF"))			{ pos =  0; mahjong=0;}	//sub
						if (!strcmp(ch, "Start"))		{ pos =  1; mahjong=0;}
						if (!strcmp(ch, "Bet"))			{ pos =  2; mahjong=0;}
						if (!strcmp(ch, "BT"))			{ pos =  2; mahjong=0;}	//sub

						if (!strcmp(ch, "Take Score"))	{ pos =  3; mahjong=0;}
						if (!strcmp(ch, "Double Up"))	{ pos =  4; mahjong=0;}
						if (!strcmp(ch, "Big"))			{ pos =  5; mahjong=0;}
						if (!strcmp(ch, "Small"))		{ pos =  6; mahjong=0;}

						if (!strcmp(ch, "Last Chance"))	{ pos =  7; mahjong=0;}
						if (!strcmp(ch, "LC"))			{ pos =  7; mahjong=0;}	//sub
						if (!strcmp(ch, "Kan"))			{ pos =  8; mahjong=0;}
						if (!strcmp(ch, "Pon"))			{ pos =  9; mahjong=0;}
						if (!strcmp(ch, "Chi"))			{ pos = 10; mahjong=0;}
						if (!strcmp(ch, "Chii"))		{ pos = 10; mahjong=0;}	//sub
						if (!strcmp(ch, "Reach"))		{ pos = 11; mahjong=0;}

						if (!strcmp(ch, "Ron"))			{ pos = 12; mahjong=0;}

						if (!strcmp(ch, "A"))			{ pos = 13; mahjong=0;}
						if (!strcmp(ch, "B"))			{ pos = 14; mahjong=0;}
						if (!strcmp(ch, "C"))			{ pos = 15; mahjong=0;}
						if (!strcmp(ch, "D"))			{ pos = 16; mahjong=0;}
						if (!strcmp(ch, "E"))			{ pos = 17; mahjong=0;}
						if (!strcmp(ch, "F"))			{ pos = 18; mahjong=0;}
						if (!strcmp(ch, "G"))			{ pos = 19; mahjong=0;}
						if (!strcmp(ch, "H"))			{ pos = 20; mahjong=0;}
						if (!strcmp(ch, "I"))			{ pos = 21; mahjong=0;}
						if (!strcmp(ch, "J"))			{ pos = 22; mahjong=0;}
						if (!strcmp(ch, "K"))			{ pos = 23; mahjong=0;}
						if (!strcmp(ch, "L"))			{ pos = 24; mahjong=0;}
						if (!strcmp(ch, "M"))			{ pos = 25; mahjong=0;}
						if (!strcmp(ch, "N"))			{ pos = 26; mahjong=0;}

					}
					break;
				
				}
				
				if (!strcmp(Machine->gamedrv->source_file, "src/drivers/fromanc2.c"))
				{
					switch(in->type & ~IPF_MASK)
					{
					case IPT_COIN1:				player=0;	pos=11; break;
					case IPT_COIN2:				player=-1;	pos=-1; break;
					case IPT_COIN3:				player=1;	pos=11; break;
					case IPT_COIN4:				player=-1;	pos=-1; break;
					}
				}

				if(pos!=-1 && player!=-1)
				{
					if(mahjong!=-1) {
						kMahjongPlayValues[player][pos][0]=port;
						kMahjongPlayValues[player][pos][1]=in->mask;
						kMahjongPlayValues[player][pos][2]=in->default_value;
						kMaxMahjong++;

					} else if(dipswitch!=-1) {
						kDipSwitchValues[kMaxDipSwitch][0]=port;
						kDipSwitchValues[kMaxDipSwitch][1]=in->mask;
						kMaxDipSwitch++;

					} else if(analog!=-1 && KAnalogCtrl) {
						kAnalogPlayValues[player][pos]=port;
						if(player == 0)Kaillera_analog_port++;
						
					} else {
						if (kBitsPlayValues[player][pos][0]==-1)	//	{^ꍇB
						{
							kBitsPlayValues[player][pos][0]=port;
							kBitsPlayValues[player][pos][1]=in->mask;
							kBitsPlayValues[player][pos][2]=in->default_value;
						} else
						{
							if (kBitsPlayValues[player][pos][0] == port)
							{
								kBitsPlayValues[player][pos][1]|=in->mask;
							} else
							{
								if (kBitsPlayValues[player][pos][0+3]==-1)
								{
									kBitsPlayValues[player][pos][0+3]=port;
									kBitsPlayValues[player][pos][1+3]=in->mask;
									kBitsPlayValues[player][pos][2+3]=in->default_value;
								}

							}
						}
					}
				}

				in++;
			}
			port++;
			if (in->type == IPT_PORT) in++;
		}
		{
			int i;
			if (is6button && !Kaillera_analog_port && !kMaxMahjong)
				if (kBitsPlayValues[0][15][0]!=-1)
					// clear IPT_SERVICE1
					for (i = 0; i < 5; i++)
						kBitsPlayValues[0][15][i] = -1;
		}
		kFirstMsg=1;
		{
			int j;
			kPlayerDup = 0;
			kValXor = 0;
			for(j=0; j<16; j++)
			{
				if(kBitsPlayValues[0][j][0]!=-1)
				{
					if(kBitsPlayValues[0][j][2] != IP_ACTIVE_LOW)
						kValXor |= (1<<j);
				}
			}
		}
	}
	
	{//kt start		gprbgTB
		int i,j,jj;
		unsigned short mask=0, b=1;
		int *usedkeys = usedkeys_get();
		j=0;jj=0;
		for(i=0; i<16; i++)
		{
			if(kBitsPlayValues[0][i][0]==-1)
			{
				usedkeys[j++] = i;
				if( jj<3 ){
					jj++;
					mask |= b;
				}
			}
			b<<=1;
		}
		usedkeysMask_set(~mask);
		//usrintf_showmessage("key %d",jj );
	}//kt end
#endif /* KAILLERA */

	playback_flag = 0;

	update_input_ports();

	/* if we didn't find a saved config, return 0 so the main core knows that it */
	/* is the first time the game is run and it should diplay the disclaimer. */
	if (f) return 1;
	else return 0;
}

/***************************************************************************/
/* Save */

void save_input_port_settings(void)
{
	void *f;
#ifdef MAME_NET
	struct InputPort *in;
	int port, player;

	/* Swap input port definitions back to defaults */
	in = Machine->input_ports;

	if (in->type == IPT_END) return; 	/* nothing to do */

	/* make sure the InputPort definition is correct */
	if (in->type != IPT_PORT)
	{
		logerror("Error in InputPort definition: expecting PORT_START\n");
		return;
	}
	else in++;

	/* scan all the input ports */
	port = 0;
	while (in->type != IPT_END && port < MAX_INPUT_PORTS)
	{
		/* now check the input bits. */
		while (in->type != IPT_END && in->type != IPT_PORT)
		{
			if ((in->type & ~IPF_MASK) != IPT_DIPSWITCH_SETTING &&	/* skip dipswitch definitions */
				(in->type & ~IPF_MASK) != IPT_EXTENSION &&			/* skip analog extension fields */
				(in->type & IPF_UNUSED) == 0 &&						/* skip unused bits */
				!(!options.cheat && (in->type & IPF_CHEAT)) &&				/* skip cheats if cheats disabled */
				(in->type & ~IPF_MASK) != IPT_VBLANK &&				/* skip vblank stuff */
				((in->type & ~IPF_MASK) >= IPT_COIN1 &&				/* skip if coin input and it's locked out */
				(in->type & ~IPF_MASK) <= IPT_COIN4 &&
                 coinlockedout[(in->type & ~IPF_MASK) - IPT_COIN1]))
			{
				player = 0;
				if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER2) player = 1;
				else if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER3) player = 2;
				else if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER4) player = 3;

				if (((in->type & ~IPF_MASK) == IPT_BUTTON1) ||
					((in->type & ~IPF_MASK) == IPT_BUTTON2) ||
					((in->type & ~IPF_MASK) == IPT_BUTTON3) ||
					((in->type & ~IPF_MASK) == IPT_BUTTON4) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICK_UP) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICK_DOWN) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICK_LEFT) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICK_RIGHT) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKRIGHT_UP) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKRIGHT_DOWN) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKRIGHT_LEFT) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKRIGHT_RIGHT) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKLEFT_UP) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKLEFT_DOWN) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKLEFT_LEFT) ||
					((in->type & ~IPF_MASK) == IPT_JOYSTICKLEFT_RIGHT) ||
					((in->type & ~IPF_MASK) == IPT_PADDLE) ||
					((in->type & ~IPF_MASK) == IPT_DIAL) ||
					((in->type & ~IPF_MASK) == IPT_TRACKBALL_X) ||
					((in->type & ~IPF_MASK) == IPT_TRACKBALL_Y) ||
					((in->type & ~IPF_MASK) == IPT_AD_STICK_X) ||
					((in->type & ~IPF_MASK) == IPT_AD_STICK_Y))
				{
					switch (default_player)
					{
						case 0:
							/* do nothing */
							analog_player_port[port] = player;
							break;
						case 1:
							if (player == 0)
							{
								in->type &= ~IPF_PLAYER1;
								in->type |= IPF_PLAYER2;
								analog_player_port[port] = 1;
							}
							else if (player == 1)
							{
								in->type &= ~IPF_PLAYER2;
								in->type |= IPF_PLAYER1;
								analog_player_port[port] = 0;
							}
							break;
						case 2:
							if (player == 0)
							{
								in->type &= ~IPF_PLAYER1;
								in->type |= IPF_PLAYER3;
								analog_player_port[port] = 2;
							}
							else if (player == 2)
							{
								in->type &= ~IPF_PLAYER3;
								in->type |= IPF_PLAYER1;
								analog_player_port[port] = 0;
							}
							break;
						case 3:
							if (player == 0)
							{
								in->type &= ~IPF_PLAYER1;
								in->type |= IPF_PLAYER4;
								analog_player_port[port] = 3;
							}
							else if (player == 3)
							{
								in->type &= ~IPF_PLAYER4;
								in->type |= IPF_PLAYER1;
								analog_player_port[port] = 0;
							}
							break;
					}
				}
			}
			in++;
		}
		port++;
		if (in->type == IPT_PORT) in++;
	}
#endif /* MAME_NET */

	save_default_keys();

	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_CONFIG,1)) != 0)
	{
#ifndef MAME_NET
		struct InputPort *in;
#endif /* MAME_NET */
		int total;
		int i;


		in = Machine->input_ports_default;

		/* calculate the size of the array */
		total = 0;
		while (in->type != IPT_END)
		{
			total++;
			in++;
		}

		/* write header */
		osd_fwrite(f,MAMECFGSTRING_V8,8);
		/* write array size */
		writeint(f,total);
		/* write the original settings as defined in the driver */
		in = Machine->input_ports_default;
		while (in->type != IPT_END)
		{
			input_port_write(f,in);
			in++;
		}
		/* write the current settings */
		in = Machine->input_ports;
		while (in->type != IPT_END)
		{
			input_port_write(f,in);
			in++;
		}

		/* write out the coin/ticket counters for this machine - LBO 042898 */
		for (i = 0; i < COIN_COUNTERS; i ++)
			writeint(f,coins[i]);
		writeint(f,dispensed_tickets);

#ifdef USE_CUSTOM_BUTTON
		{
			int p, b;

			for (p = 0; p < players; p++)
				for (b = 0; b < custom_buttons; b++)
					writeword(f, custom_button[p][b]);
		}
#endif /* USE_CUSTOM_BUTTON */

		mixer_write_config(f);
#ifdef MAME32JP
		osd_fwrite(f, &volume_multiplier, sizeof(INT32));
#endif
		osd_fclose(f);
	}
}


#ifdef MAME32JP
struct fix_name_t
{
	const char *org_name;
	const char *jpn_name;
};

static struct fix_name_t fix_port_names[] =
{
	{ "Pon",			"|" },
	{ "Chi",			"`[" },
	{ "Kan",			"J" },
	{ "Ron",			"" },
	{ "Reach",			"[`" },

	{ "P1 Pon",			"P1 |" },
	{ "P1 Chi",			"P1 `[" },
	{ "P1 Kan",			"P1 J" },
	{ "P1 Ron",			"P1 " },
	{ "P1 Reach",		"P1 [`" },
//	{ "P1 Bet",			"P1 xbg" },
	{ "P1 Small",		"P1 X[" },
	{ "P1 Big",			"P1 rbO" },
	{ "P1 Flip",		"P1 tbv" },
	{ "P1 Double Up",	"P1 _uAbv" },
	{ "P1 Take Score",	"P1 XRAmF" },
	{ "P1 Last Chance",	"P1 Xg`X" },

	{ "P2 Pon",			"P2 |" },
	{ "P2 Chi",			"P2 `[" },
	{ "P2 Kan",			"P2 J" },
	{ "P2 Ron",			"P2 " },
	{ "P2 Reach",		"P2 [`" },
//	{ "P2 Bet",			"P2 xbg" },
	{ "P2 Small",		"P2 X[" },
	{ "P2 Big",			"P2 rbO" },
	{ "P2 Flip",		"P2 tbv" },
	{ "P2 Double Up",	"P2 _uAbv" },
	{ "P2 Take Score",	"P2 XRAmF" },
	{ "P2 Last Chance",	"P2 Xg`X" },

#if 0
	{ "Continue",			"ReBj[" },
	{ "Allow Continue",		"ReBj[" },
	{ "Continue Play",		"ReBj[" },

	{ "Country",			"n" },
	{ "Any",				"wȂ" },
	{ "China",				"" },
	{ "Domestic",			"" },
	{ "England",			"CMX" },
	{ "Germany",			"hCc" },
	{ "Hong Kong",			"`" },
	{ "Italy",				"C^A" },
	{ "Japan",				"{" },
	{ "Korea",				"؍" },
	{ "Oversea",			"CO" },
	{ "Taiwan",				"p" },
	{ "USA",				"AJ" },
	{ "World",				"E" },

	{ "Game Language",		"" },
	{ "Language",			"" },
	{ "Language 1",			" 1" },
	{ "Language 2",			" 2" },
	{ "English",			"p" },
	{ "Foreign (NEED ROM)",	"O(ROMKv)" },
	{ "French",				"tX" },
	{ "German",				"hCc" },
	{ "Italian",			"C^A" },
	{ "Japanese",			"{" },
	{ "Nihongo",			"{" },
	{ "Spanish",			"XyC" },

	{ "Play Time",			"vC" },
	{ "Time",				"" },
	{ "5 sec",				"5b" },
	{ "10 sec",				"10b" },
	{ "15 sec",				"15b" },
	{ "20 sec",				"20b" },
	{ "25 sec",				"25b" },
	{ "30 sec",				"30b" },
	{ "35 sec",				"35b" },
	{ "40 sec",				"40b" },
	{ "45 sec",				"45b" },
	{ "50 sec",				"50b" },
	{ "55 sec",				"55b" },
	{ "60 sec",				"60b" },
	{ "1 min",				"1" },
	{ "2 min",				"2" },
	{ "3 min",				"3" },
	{ "4 min",				"4" },
	{ "5 min",				"5" },
	{ "6 min",				"6" },
	{ "7 min",				"7" },
	{ "8 min",				"8" },
	{ "9 min",				"9" },
	{ "10 min",				"10" },
	{ "11 min",				"11" },
	{ "12 min",				"12" },
	{ "2 min/1 min",		"2/1" },
	{ "3 min/1.5 min",		"3/1.5" },

	{ "None",				"Ȃ" },
	{ "Nothing",			"Ȃ" },
	{ "Infinite",			"" },
	{ "Unlimited",			"" },
	{ "Normal",				"W" },
	{ "Inverted",			"]" },
	{ "Slow",				"x" },
	{ "Fast",				"" },
	{ "Same",				"" },
	{ "Individual",			"" },
	{ "Horizontally",		"" },
	{ "Vertically",			"" },

	{ "Bet Min",			"ŏxbg" },
	{ "Bet Max",			"őxbg" },

	{ "Invulnerability",	"ϋv" },
	{ "Ship Increase",		"@" },

	{ "Max Players",		"ővC[" },

	{ "Service Mode/Free Play",	"T[rX[h/t[vC" },

	{ "Coin Chutes",		"RC" },
	{ "Coin Slot",			"RCXbg" },
	{ "Disable All Coins",	"ׂẴRC𖳌" },

	{ "First Bonus",		"{[iX" },
	{ "Second Bonus",		"{[iX2" },

	{ "1st Bonus Life",		"{[iXCt" },
	{ "2nd Bonus Life",		"{[iXCt2" },

	{ "Freeze",				"t[Y" },
	{ "Cabinet Type",		"➑̃^Cv" },
	{ "Upright 1",			"AbvCg1" },
	{ "Upright 2",			"AbvCg2" },
	{ "Throttle Lever",		"Xbgo[" },
#endif

	{ 0, 0 }
};

static const char *input_port_name_fix(const char *name)
{
	int i = 0;

	if (name == NULL)
		return name;

	while (fix_port_names[i].org_name)
	{
		if (!stricmp(name, fix_port_names[i].org_name))
			return fix_port_names[i].jpn_name;
		i++;
	}
	return name;
}
#endif

/* Note that the following 3 routines have slightly different meanings with analog ports */
const char *input_port_name(const struct InputPort *in)
{
	int i;
	unsigned type;

#if defined(JAPANESE) && defined(MAME32JP)
	if (in->name != IP_NAME_DEFAULT) return input_port_name_fix(in->name);
#else
	if (in->name != IP_NAME_DEFAULT) return in->name;
#endif

	i = 0;

	if ((in->type & ~IPF_MASK) == IPT_EXTENSION)
		type = (in-1)->type & (~IPF_MASK | IPF_PLAYERMASK);
	else
		type = in->type & (~IPF_MASK | IPF_PLAYERMASK);

	while (inputport_defaults[i].type != IPT_END &&
			inputport_defaults[i].type != type)
		i++;

	if ((in->type & ~IPF_MASK) == IPT_EXTENSION)
		return inputport_defaults[i+1].name;
	else
		return inputport_defaults[i].name;
}

InputSeq* input_port_type_seq(int type)
{
	unsigned i;

	i = 0;

	while (inputport_defaults[i].type != IPT_END &&
			inputport_defaults[i].type != type)
		i++;

	return &inputport_defaults[i].seq;
}

InputSeq* input_port_seq(const struct InputPort *in)
{
	int i,type;

	static InputSeq ip_none = SEQ_DEF_1(CODE_NONE);

	while (seq_get_1((InputSeq*)&in->seq) == CODE_PREVIOUS) in--;

	if ((in->type & ~IPF_MASK) == IPT_EXTENSION)
	{
		type = (in-1)->type & (~IPF_MASK | IPF_PLAYERMASK);
		/* if port is disabled, or cheat with cheats disabled, return no key */
		if (((in-1)->type & IPF_UNUSED) || (!options.cheat && ((in-1)->type & IPF_CHEAT)))
			return &ip_none;
	}
	else
	{
		type = in->type & (~IPF_MASK | IPF_PLAYERMASK);
		/* if port is disabled, or cheat with cheats disabled, return no key */
		if ((in->type & IPF_UNUSED) || (!options.cheat && (in->type & IPF_CHEAT)))
			return &ip_none;
	}

	if (seq_get_1((InputSeq*)&in->seq) != CODE_DEFAULT)
		return (InputSeq*)&in->seq;

	i = 0;

	while (inputport_defaults[i].type != IPT_END &&
			inputport_defaults[i].type != type)
		i++;

	if ((in->type & ~IPF_MASK) == IPT_EXTENSION)
		return &inputport_defaults[i+1].seq;
	else
		return &inputport_defaults[i].seq;
}

void update_analog_port(int port)
{
	struct InputPort *in;
	int current, delta, type, sensitivity, min, max, default_value;
	int axis, is_stick, is_gun, check_bounds;
	InputSeq* incseq;
	InputSeq* decseq;
	int keydelta;
	int player;

	/* get input definition */
	in = input_analog[port];

	/* if we're not cheating and this is a cheat-only port, bail */
	if (!options.cheat && (in->type & IPF_CHEAT)) return;
	type=(in->type & ~IPF_MASK);

	decseq = input_port_seq(in);
	incseq = input_port_seq(in+1);

	keydelta = IP_GET_DELTA(in);

	switch (type)
	{
		case IPT_PADDLE:
			axis = X_AXIS; is_stick = 1; is_gun=0; check_bounds = 1; break;
		case IPT_PADDLE_V:
			axis = Y_AXIS; is_stick = 1; is_gun=0; check_bounds = 1; break;
		case IPT_DIAL:
			axis = X_AXIS; is_stick = 0; is_gun=0; check_bounds = 0; break;
		case IPT_DIAL_V:
			axis = Y_AXIS; is_stick = 0; is_gun=0; check_bounds = 0; break;
		case IPT_TRACKBALL_X:
			axis = X_AXIS; is_stick = 0; is_gun=0; check_bounds = 0; break;
		case IPT_TRACKBALL_Y:
			axis = Y_AXIS; is_stick = 0; is_gun=0; check_bounds = 0; break;
		case IPT_AD_STICK_X:
			axis = X_AXIS; is_stick = 1; is_gun=0; check_bounds = 1; break;
		case IPT_AD_STICK_Y:
			axis = Y_AXIS; is_stick = 1; is_gun=0; check_bounds = 1; break;
		case IPT_AD_STICK_Z:
			axis = Z_AXIS; is_stick = 1; is_gun=0; check_bounds = 1; break;
		case IPT_LIGHTGUN_X:
			axis = X_AXIS; is_stick = 1; is_gun=1; check_bounds = 1; break;
		case IPT_LIGHTGUN_Y:
			axis = Y_AXIS; is_stick = 1; is_gun=1; check_bounds = 1; break;
		case IPT_PEDAL:
			axis = PEDAL_AXIS; is_stick = 0; is_gun=0; check_bounds = 1; break;
		case IPT_PEDAL2:
			axis = Z_AXIS; is_stick = 0; is_gun=0; check_bounds = 1; break;
		default:
			/* Use some defaults to prevent crash */
			axis = X_AXIS; is_stick = 0; is_gun=0; check_bounds = 0;
			logerror("Oops, polling non analog device in update_analog_port()????\n");
	}


	sensitivity = IP_GET_SENSITIVITY(in);
	min = IP_GET_MIN(in);
	max = IP_GET_MAX(in);
	default_value = in->default_value * 100 / sensitivity;
	/* extremes can be either signed or unsigned */
	if (min > max)
	{
		if (in->mask > 0xff) min = min - 0x10000;
		else min = min - 0x100;
	}


	input_analog_previous_value[port] = input_analog_current_value[port];

	/* if IPF_CENTER go back to the default position */
	/* sticks are handled later... */
	if ((in->type & IPF_CENTER) && (!is_stick))
		input_analog_current_value[port] = in->default_value * 100 / sensitivity;

	current = input_analog_current_value[port];

	delta = 0;

	switch (in->type & IPF_PLAYERMASK)
	{
		case IPF_PLAYER2:          player = 1; break;
		case IPF_PLAYER3:          player = 2; break;
		case IPF_PLAYER4:          player = 3; break;
		case IPF_PLAYER1: default: player = 0; break;
	}

	if (axis == X_AXIS)
		delta = mouse_delta_x[player];
	else
		delta = mouse_delta_y[player];

	if (seq_pressed(decseq)) delta -= keydelta;

	if (type != IPT_PEDAL && type != IPT_PEDAL2)
	{
		if (seq_pressed(incseq)) delta += keydelta;
	}
	else
	{
		/* is this cheesy or what? */
		if (!delta && seq_get_1(incseq) == KEYCODE_Y) delta += keydelta;
		delta = -delta;
	}

	if (in->type & IPF_REVERSE) delta = -delta;

	if (is_stick && (!options.use_djoystick))
	{
		int new, prev;

		/* center stick */
		if ((delta == 0) && (in->type & IPF_CENTER))
		{
			if (current > default_value)
			delta = -100 / sensitivity;
			if (current < default_value)
			delta = 100 / sensitivity;
		}

		/* An analog joystick which is not at zero position (or has just */
		/* moved there) takes precedence over all other computations */
		/* analog_x/y holds values from -128 to 128 (yes, 128, not 127) */

		if (axis == X_AXIS)
		{
			new  = analog_current_x[player];
			prev = analog_previous_x[player];
		}
		else
		{
			new  = analog_current_y[player];
			prev = analog_previous_y[player];
		}

		if ((new != 0) || (new-prev != 0))
		{
			delta=0;

			/* for pedals, need to change to possitive number */
			/* and, if needed, reverse pedal input */
			if (type == IPT_PEDAL || type == IPT_PEDAL2)
			{
				new  = -new;
				prev = -prev;
				if (in->type & IPF_REVERSE)		// a reversed pedal is diff than normal reverse
				{								// 128 = no gas, 0 = all gas
					new  = 128-new;				// the default "new=-new" doesn't handle this
					prev = 128-prev;
				}
			}
			else if (in->type & IPF_REVERSE)
			{
				new  = -new;
				prev = -prev;
			}

			/* apply sensitivity using a logarithmic scale */
			if (in->mask > 0xff)
			{
				if (new > 0)
				{
					current = (pow(new / 32768.0, 100.0 / sensitivity) * (max-in->default_value)
							+ in->default_value) * 100 / sensitivity;
				}
				else
				{
					current = (pow(-new / 32768.0, 100.0 / sensitivity) * (min-in->default_value)
							+ in->default_value) * 100 / sensitivity;
				}
			}
			else
			{
				if (new > 0)
				{
					current = (pow(new / 128.0, 100.0 / sensitivity) * (max-in->default_value)
							+ in->default_value) * 100 / sensitivity;
				}
				else
				{
					current = (pow(-new / 128.0, 100.0 / sensitivity) * (min-in->default_value)
							+ in->default_value) * 100 / sensitivity;
				}
			}
		}
	}

	#ifdef KAILLERA
	if(kPlay) { //kt
		#if KAILLERA_ANALOG_LEN == 4
		kinput_analog_delta[port][0] = delta;
		delta = kinput_analog_delta[port][1];
		#endif
		#if KAILLERA_ANALOG_LEN == 2
		kinput_analog_delta[port][0] = (short)(delta & 0xffff);
		delta = ((int)kinput_analog_delta[port][1] << 16 >> 16);
		#endif
	}
	#endif

	current += delta;

	if (check_bounds)
	{
		int temp;

		if (current >= 0)
			temp = (current * sensitivity + 50) / 100;
		else
			temp = (-current * sensitivity + 50) / -100;

		if (temp < min)
		{
			if (min >= 0)
				current = (min * 100 + sensitivity/2) / sensitivity;
			else
				current = (-min * 100 + sensitivity/2) / -sensitivity;
		}
		if (temp > max)
		{
			if (max >= 0)
				current = (max * 100 + sensitivity/2) / sensitivity;
			else
				current = (-max * 100 + sensitivity/2) / -sensitivity;
		}
	}

	input_analog_current_value[port] = current;
}

static void scale_analog_port(int port)
{
	struct InputPort *in;
	int delta,current,sensitivity;

profiler_mark(PROFILER_INPUT);
	in = input_analog[port];
	sensitivity = IP_GET_SENSITIVITY(in);

	/* apply scaling fairly in both positive and negative directions */
	delta = input_analog_current_value[port] - input_analog_previous_value[port];
	if (delta >= 0)
		delta = cpu_scalebyfcount(delta);
	else
		delta = -cpu_scalebyfcount(-delta);

	current = input_analog_previous_value[port] + delta;

	/* An ugly hack to remove scaling on lightgun ports */
	if (input_analog_scale[port]) {
		/* apply scaling fairly in both positive and negative directions */
		if (current >= 0)
			current = (current * sensitivity + 50) / 100;
		else
			current = (-current * sensitivity + 50) / -100;
	}

	input_port_value[port] &= ~in->mask;
	input_port_value[port] |= current & in->mask;

	if (playback)
		readword(playback,&input_port_value[port]);
	if (record)
		writeword(record,input_port_value[port]);
#ifdef MAME_NET
	if ( net_active() && (default_player != NET_SPECTATOR) )
		net_analog_sync((unsigned char *) input_port_value, port, analog_player_port, default_player);
#endif /* MAME_NET */
profiler_mark(PROFILER_END);
}

#define MAX_JOYSTICKS 3
#ifndef USE_CUSTOM_BUTTON
#define MAX_PLAYERS 4
#endif /* USE_CUSTOM_BUTTON */
static int mJoyCurrent[MAX_JOYSTICKS*MAX_PLAYERS];
static int mJoyPrevious[MAX_JOYSTICKS*MAX_PLAYERS];
static int mJoy4Way[MAX_JOYSTICKS*MAX_PLAYERS];
/*
The above "Joy" states contain packed bits:
	0001	up
	0010	down
	0100	left
	1000	right
*/

static void
ScanJoysticks( struct InputPort *in )
{
	int i;
	int port = 0;

	/* Save old Joystick state. */
	memcpy( mJoyPrevious, mJoyCurrent, sizeof(mJoyPrevious) );

	/* Initialize bits of mJoyCurrent to zero. */
	memset( mJoyCurrent, 0, sizeof(mJoyCurrent) );

	/* Now iterate over the input port structure to populate mJoyCurrent. */
	while( in->type != IPT_END && port < MAX_INPUT_PORTS )
	{
		while (in->type != IPT_END && in->type != IPT_PORT)
		{
			if ((in->type & ~IPF_MASK) >= IPT_JOYSTICK_UP &&
				(in->type & ~IPF_MASK) <= IPT_JOYSTICKLEFT_RIGHT)
			{
				InputSeq* seq;
				seq = input_port_seq(in);
				if( seq_pressed(seq) )
				{
					int joynum,joydir,player;
					player = 0;
					if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER2)
						player = 1;
					else if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER3)
						player = 2;
					else if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER4)
						player = 3;

					joynum = player * MAX_JOYSTICKS +
							 ((in->type & ~IPF_MASK) - IPT_JOYSTICK_UP) / 4;
					joydir = ((in->type & ~IPF_MASK) - IPT_JOYSTICK_UP) % 4;

					mJoyCurrent[joynum] |= 1<<joydir;
				}
			}
			in++;
		}
		port++;
		if (in->type == IPT_PORT) in++;
	}

	/* Process the joystick states, to filter out illegal combinations of switches. */
	for( i=0; i<MAX_JOYSTICKS*MAX_PLAYERS; i++ )
	{
		if( (mJoyCurrent[i]&0x3)==0x3 ) /* both up and down are pressed */
		{
			mJoyCurrent[i]^=mJoyPrevious[i]&0x3; 
		}
		if( (mJoyCurrent[i]&0xc)==0xc ) /* both left and right are pressed */
		{
			mJoyCurrent[i]^=mJoyPrevious[i]&0xc; 
		}

		/* Only update mJoy4Way if the joystick has moved. */
		if( mJoyCurrent[i]!=mJoyPrevious[i] )
		{
			mJoy4Way[i] = mJoyCurrent[i];

			if( (mJoy4Way[i] & 0x3) && (mJoy4Way[i] & 0xc) )
			{
				/* If joystick is pointing at a diagonal, acknowledge that the player moved
				 * the joystick by favoring a direction change.  This minimizes frustration
				 * when using a keyboard for input, and maximizes responsiveness.
				 *
				 * For example, if you are holding "left" then switch to "up" (where both left
				 * and up are briefly pressed at the same time), we'll transition immediately
				 * to "up."
				 *
				 * Under the old "sticky" key implentation, "up" wouldn't be triggered until
				 * left was released.
				 *
				 * Zero any switches that didn't change from the previous to current state.
				 */
				mJoy4Way[i] ^= (mJoy4Way[i] & mJoyPrevious[i]);
			}

			if( (mJoy4Way[i] & 0x3) && (mJoy4Way[i] & 0xc) )
			{
				/* If we are still pointing at a diagonal, we are in an indeterminant state.
				 *
				 * This could happen if the player moved the joystick from the idle position directly
				 * to a diagonal, or from one diagonal directly to an extreme diagonal.
				 *
				 * The chances of this happening with a keyboard are slim, but we still need to
				 * constrain this case.
				 *
				 * For now, just resolve randomly.
				 */
				if( rand()&1 )
				{
					mJoy4Way[i] &= 0x3; /* eliminate horizontal component */
				}
				else
				{
					mJoy4Way[i] &= 0xc; /* eliminate vertical component */
				}
			}
		}
	}
} /* ScanJoysticks */

void update_input_ports(void)
{
	int port,ib;
	struct InputPort *in;

#define MAX_INPUT_BITS 1024
	static int impulsecount[MAX_INPUT_BITS];
	static int waspressed[MAX_INPUT_BITS];
	static int pbwaspressed[MAX_INPUT_BITS];

#ifdef MAME_NET
	int player;
#endif /* MAME_NET */
#ifdef KAILLERA
	int perform_ui = 0;
	int perform_ui_dat = 0;
#endif
#ifdef MAME_AVI
	extern BOOL bAviRun;
#endif

profiler_mark(PROFILER_INPUT);

	/* clear all the values before proceeding */
	for (port = 0;port < MAX_INPUT_PORTS;port++)
	{
		input_port_value[port] = 0;
		input_vblank[port] = 0;
		input_analog[port] = 0;
	}

	in = Machine->input_ports;
	if (in->type == IPT_END) return; 	/* nothing to do */

	/* make sure the InputPort definition is correct */
	if (in->type != IPT_PORT)
	{
		logerror("Error in InputPort definition: expecting PORT_START\n");
		return;
	}
	else
	{
		in++;
	}

	ScanJoysticks( in ); /* populates mJoyCurrent[] */

	/* scan all the input ports */
	port = 0;
	ib = 0;
	while (in->type != IPT_END && port < MAX_INPUT_PORTS)
	{
		struct InputPort *start;
		/* first of all, scan the whole input port definition and build the */
		/* default value. I must do it before checking for input because otherwise */
		/* multiple keys associated with the same input bit wouldn't work (the bit */
		/* would be reset to its default value by the second entry, regardless if */
		/* the key associated with the first entry was pressed) */
		start = in;
		while (in->type != IPT_END && in->type != IPT_PORT)
		{
			if ((in->type & ~IPF_MASK) != IPT_DIPSWITCH_SETTING &&	/* skip dipswitch definitions */
				(in->type & ~IPF_MASK) != IPT_EXTENSION)			/* skip analog extension fields */
			{
				input_port_value[port] =
						(input_port_value[port] & ~in->mask) | (in->default_value & in->mask);
#ifdef MAME_NET
				if ( net_active() )
					input_port_defaults[port] = input_port_value[port];
#endif /* MAME_NET */
			}

			in++;
		}

		/* now get back to the beginning of the input port and check the input bits. */
		for (in = start;
			 in->type != IPT_END && in->type != IPT_PORT;
			 in++, ib++)
		{
#ifdef MAME_NET
			player = 0;
			if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER2) player = 1;
			else if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER3) player = 2;
			else if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER4) player = 3;
#endif /* MAME_NET */
			if ((in->type & ~IPF_MASK) != IPT_DIPSWITCH_SETTING &&	/* skip dipswitch definitions */
					(in->type & ~IPF_MASK) != IPT_EXTENSION)		/* skip analog extension fields */
			{
				if ((in->type & ~IPF_MASK) == IPT_VBLANK)
				{
					input_vblank[port] ^= in->mask;
					input_port_value[port] ^= in->mask;
if (Machine->drv->vblank_duration == 0)
	logerror("Warning: you are using IPT_VBLANK with vblank_duration = 0. You need to increase vblank_duration for IPT_VBLANK to work.\n");
				}
				/* If it's an analog control, handle it appropriately */
				else if (((in->type & ~IPF_MASK) > IPT_ANALOG_START)
					  && ((in->type & ~IPF_MASK) < IPT_ANALOG_END  )) /* LBO 120897 */
				{
					input_analog[port]=in;
					/* reset the analog port on first access */
					if (input_analog_init[port])
					{
						input_analog_init[port] = 0;
						input_analog_scale[port] = 1;
						if (options.use_djoystick) 
						{
						input_analog_current_value[port] = input_analog_previous_value[port] = in->default_value;
						}
						else
						{
						input_analog_current_value[port] = input_analog_previous_value[port]
							= in->default_value * 100 / IP_GET_SENSITIVITY(in);
						}
					}
				}
				else
				{
					InputSeq* seq;
					seq = input_port_seq(in);
#ifdef MAME32JP
					if (auto_pressed(seq, in->type, ib))
#else
					if (seq_pressed(seq))
#endif
					{
						/* skip if coin input and it's locked out */
						if ((in->type & ~IPF_MASK) >= IPT_COIN1 &&
							(in->type & ~IPF_MASK) <= IPT_COIN4 &&
                            coinlockedout[(in->type & ~IPF_MASK) - IPT_COIN1])
						{
							continue;
						}

						/* if IPF_RESET set, reset the first CPU */
						if ((in->type & IPF_RESETCPU) && waspressed[ib] == 0 && !playback)
						{
							cpu_set_reset_line(0,PULSE_LINE);
						}

						if (in->type & IPF_IMPULSE)
						{
if (IP_GET_IMPULSE(in) == 0)
	logerror("error in input port definition: IPF_IMPULSE with length = 0\n");
							if (waspressed[ib] == 0)
								impulsecount[ib] = IP_GET_IMPULSE(in);
								/* the input bit will be toggled later */
						}
						else if (in->type & IPF_TOGGLE)
						{
							if (waspressed[ib] == 0)
							{
								in->default_value ^= in->mask;
								input_port_value[port] ^= in->mask;
							}
						}
						else if ((in->type & ~IPF_MASK) >= IPT_JOYSTICK_UP &&
								(in->type & ~IPF_MASK) <= IPT_JOYSTICKLEFT_RIGHT)
						{
#ifndef MAME_NET
							int joynum,joydir,mask,player;


							player = 0;
							if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER2) player = 1;
							else if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER3) player = 2;
							else if ((in->type & IPF_PLAYERMASK) == IPF_PLAYER4) player = 3;
#else
							int joynum,joydir,mask;
#endif /* !MAME_NET */
							joynum = player * MAX_JOYSTICKS +
									((in->type & ~IPF_MASK) - IPT_JOYSTICK_UP) / 4;

							joydir = ((in->type & ~IPF_MASK) - IPT_JOYSTICK_UP) % 4;

							mask = in->mask;

							if( in->type & IPF_4WAY )
							{
								/* apply 4-way joystick constraint */
								if( ((mJoy4Way[joynum]>>joydir)&1) == 0 )
								{
									mask = 0;
								}
							}
							else
							{
								/* filter up+down and left+right */
								if( ((mJoyCurrent[joynum]>>joydir)&1) == 0 )
								{
									mask = 0;
								}
							}

							input_port_value[port] ^= mask;
						} /* joystick */
#ifdef USE_CUSTOM_BUTTON
						else if ((in->type & ~IPF_MASK) >= IPT_CUSTOM1 &&
						         (in->type & ~IPF_MASK) < IPT_CUSTOM1 + MAX_CUSTOM_BUTTONS)
						{
							int i, n = 1;
							int p = 0;
							int custom = (in->type & ~IPF_MASK) - IPT_CUSTOM1;

							switch (in->type & IPF_PLAYERMASK)
							{
							case IPF_PLAYER1:
								p = 0;
								break;
							case IPF_PLAYER2:
								p = 1;
								break;
							case IPF_PLAYER3:
								p = 2;
								break;
							case IPF_PLAYER4:
								p = 3;
								break;
							}

							for (i = 0; i < normal_buttons; i++)
							{
								if (custom_button[p][custom] & n)
									input_port_value[normal_button[p][i].port] ^= normal_button[p][i].mask;

								n <<= 1;
							}
						}
#endif /* USE_CUSTOM_BUTTON */
						else
						{
							input_port_value[port] ^= in->mask;
						}
						waspressed[ib] = 1;
					}
					else
						waspressed[ib] = 0;

					if ((in->type & IPF_IMPULSE) && impulsecount[ib] > 0)
					{
						impulsecount[ib]--;
						waspressed[ib] = 1;
						input_port_value[port] ^= in->mask;
					}
				}
			}
		}

		port++;
		if (in->type == IPT_PORT) in++;
	}

	if (playback)
	{
		int i;

		ib=0;
		in = Machine->input_ports;
		in++;
		for (i = 0; i < MAX_INPUT_PORTS; i ++)
		{
			if (readword(playback,&input_port_value[i]) < 0)
				if (!playback_flag)
				{
					playback_flag = 1;
#ifdef MAME_AVI
					if (!bAviRun)
#endif
					usrintf_showmessage("ĐI");
				}

			/* check if the input port includes an IPF_RESETCPU bit
			   and reset the CPU on first "press", no need to check
			   the impulse count as this was done during recording */
			for (; in->type != IPT_END && in->type != IPT_PORT; in++, ib++)
			{
				if (in->type & IPF_RESETCPU)
				{
					if((input_port_value[i] ^ in->default_value) & in->mask)
					{
						if (pbwaspressed[ib] == 0)
							cpu_set_reset_line(0,PULSE_LINE);
						pbwaspressed[ib] = 1;
					}
					else
						pbwaspressed[ib] = 0;
				}
			}
			if (in->type == IPT_PORT) in++;
		}
	}

#ifdef KAILLERA

	if (playbacksub)
	{
		input_ui_temp = 0;
		perform_ui_count--;
		if(perform_ui_count <= 0)
		{
			readword(playbacksub,(UINT16*)&perform_ui);
			readword(playbacksub,(UINT16*)&perform_ui_dat );
			readword(playbacksub,((UINT16*)&perform_ui_dat)+1 );
			readword(playbacksub,(UINT16*)&perform_ui_count);
			perform_ui_count &= 0xffff;
			perform_ui &= 0xffff;

			input_ui_temp = perform_ui;
			input_ui_temp_dat[0] = perform_ui_dat;
		}
		//usrintf_showmessage("pui_count %d",perform_ui_count );
	}

	if(input_ui_pressed(IPT_UI_KAILLERA_TEST1_1))
	{	//kt test
		char	kailleraver[20];
		if (kPlay)
		{
			memset(kailleraver, 0, 20);
			kailleraGetVersion(kailleraver);
			usrintf_showmessage("kailleraver %s", kailleraver);
		}

		//usrintf_showmessage("nCustomButton_Start=%d, nCustomButton_End=%d, nCustomButton_TotalCode=%d", nCustomButton_Start, nCustomButton_End, nCustomButton_TotalCode);
	}


 if(kPlay)
 {

  input_ui_temp = 0;
  if(kFirstMsg)
  {
	  int i,b;
	  //extern void *record;
	  kFirstMsg=0;

	  if( record )
	  {
		  extern char kaillera_recode_filename[MAX_PATH];
		  usrintf_showmessage("%sɓ͂ۑȂs܂", kaillera_recode_filename);
	  }

      for(i=0;i<4;i++)
      {
		int j;
        b=1;
        for(j=0;j<16;j++)
        {
          if(kBitsPlayValues[i][j][0]!=-1)
          {
            if(kBitsPlayValues[i][j][2] != IP_ACTIVE_LOW) {
              if(!(1))
                  ;
			  else
				  input_port_value[kBitsPlayValues[i][j][0]] &= ~kBitsPlayValues[i][j][1]; //kt
            } else {
			  if(0)
			      ;
			  else
				  input_port_value[kBitsPlayValues[i][j][0]] |= kBitsPlayValues[i][j][1]; //kt
			}
          }
          b=b<<1;
        }
	  }

	  memcpy(kDefValues,input_port_value,sizeof(input_port_value));
  }
  else
  {



	KAILLERA_VAL_INT val[KAILLERA_MAX_PLAYER];
	unsigned char chval[32*KAILLERA_MAX_PLAYER];
    TICKER st;
	TICKER st2;	//kt
    int i,j,b,recvLen,recvPlayer,recvPlsub;

	int kaillera_ipu_ui = 0;		//kt
	int *usedkeys = usedkeys_get(); //kt

    val[0]=0;
    b=1;
    for(i=0;i<16;i++)
    {
      if(kBitsPlayValues[0][i][0]!=-1)
        if(~input_port_value[kBitsPlayValues[0][i][0]] & kBitsPlayValues[0][i][1]) val[0] |= b;
      b=b<<1;
    }


	for(j=1; j<KailleraPlayerOption.subplayer+1; j++)
	{
		val[j]=0;
		b=1;
	    for(i=0;i<16;i++)
		{
			if(kBitsPlayValues[j][i][0]!=-1)
				if(~input_port_value[kBitsPlayValues[j][i][0]] & kBitsPlayValues[j][i][1]) val[j] |= b;
			b=b<<1;
		}
	}

	//usrintf_showmessage( IntToBit((int)val[0]));	//kt test

	if(kPlay){	//kt start

		kaillera_ipu_ui = 0;
		if(input_ui_pressed(IPT_UI_RESET_MACHINE))		kaillera_ipu_ui = 1;
		if(Kaillera_StateSave_Flags & KAILLERA_FLAGS_RESET_MACHINE) {
			kaillera_ipu_ui = 1;
			Kaillera_StateSave_Flags &= ~KAILLERA_FLAGS_RESET_MACHINE;
		}

		if(Kaillera_StateSave_Count <= 0 && Kaillera_StateSave_TimeRemainder <= 0 && (~Kaillera_Send_Flags & 0x1) && KailleraChatdataPreparationcheck.timeremainder <= 0) {

			if( Kaillera_StateSave_Flags & KAILLERA_STATESAVE_AUTOSAVE ) {
				if(((~synccount) % KailleraStartOption.autosave_time_interval) == 0 ) kaillera_ipu_ui = 2;				// I[gZ[u
			}


			if(KailleraStartOption.player == 1) { // NGCgl݂̂̑\x94\x5c
				int f=0;
				if(input_ui_pressed(IPT_UI_LOAD_STATE))			kaillera_ipu_ui = 3;		// sta[h
				if(input_ui_pressed(IPT_UI_KAILLERA_TEST_7))	Kaillera_StateSave_SelectFile = ~Kaillera_StateSave_SelectFile; // Xe[gZ[uA[hŎgpgq̕ύX
				if(input_ui_pressed(IPT_UI_SAVE_STATE)) {// staZ[u
					char tmp[256];
					kaillera_ipu_ui = 2;
					wsprintf(tmp, "st%c ɕۑ܂", Kaillera_StateSave_file);
					kailleraChatSend(tmp);//`bgőS\x95\x5cB
				}

				if(input_ui_pressed(IPT_UI_KAILLERA_TEST_4)) {// fBbvXCb`̏Ԃ𑗐M
					//int j;
					long dat[64];
					UINT16 *val2 = (UINT16*)&dat[1];
					
					if( kMaxDipSwitch<=0 )
						usrintf_showmessage("fBbvXCb`܂");
					else if( kMaxDipSwitch>120/4 )
						usrintf_showmessage("fBbvXCb`܂");
					else {
						i=0;
						for(i=0;i<kMaxDipSwitch;i++) {
							(*val2) = input_port_value[kDipSwitchValues[i][0]] & kDipSwitchValues[i][1];
							val2++;
						}
						if(i&0x1) i++;

						KailleraChatdataPreparationcheck.nmb		= 8;
						KailleraChatdataPreparationcheck.str		= "fBbvXCb`M";
						KailleraChatdataPreparationcheck.count		= KailleraPlayerOption.max;
						KailleraChatdataPreparationcheck.timeremainder	= 150;
						KailleraChatdataPreparationcheck.addtime	= 90;
						KailleraChatdataPreparationcheck.maxtime	= 256;
						KailleraChatdataPreparationcheck.Callback	= SendDipSwitch;

						dat[0] = KailleraChatdataPreparationcheck.nmb;
						kailleraChatSend(kChatData(&dat[0], (1+i/2)*4));//Sɓ`B
					}
				}

				if(input_ui_pressed(IPT_UI_KAILLERA_TEST_8)) {
					KailleraPlayerOption.sendfilespeed = 0x0; f=1;
					kailleraChatSend("Z[uf[^]");
				} 

				if(input_ui_pressed(IPT_UI_KAILLERA_TEST_9)) { KailleraPlayerOption.sendfilespeed = KailleraStartOption.send_file_speed; f=2; }

				if(f>0) {
					UINT32 length, destLen;
					char *temp,*dest;
					void *file;
					char name[2];
					int zl;
					name[0] = Kaillera_StateSave_file;
					name[1] = 0;
					{
						//int flag;
						file = osd_fopen(Machine->gamedrv->name, name, OSD_FILETYPE_STATE, 0);
					}
					if(!file) usrintf_showmessage("%s.st%c ܂", Machine->gamedrv->name, name[0]);
					else {
					length = osd_fsize(file);
					destLen = length + 12;
					temp = malloc(length);
					dest = malloc(destLen);
					osd_fread(file, temp, length);
					Kaillera_Send_CRC = crc32(0, (Bytef *)temp, length);
					Kaillera_Send_Flags &= ~0x4;
					zl = compress2 ((Bytef *)dest, (unsigned long*)&destLen, (Bytef *)temp, length, 9);
					if( zl == Z_OK) {
						long dat[64];
						//Kaillera_Send_Flags			|= 0x1;
						Kaillera_Send_Len			 = destLen;
						Kaillera_Send_DecompressLen  = length;
						lpkChatDatabit				 = dest;


						KailleraChatdataPreparationcheck.nmb		= 9;
						KailleraChatdataPreparationcheck.str		= "stat@CM";
						KailleraChatdataPreparationcheck.count		= KailleraPlayerOption.max - 1;
						KailleraChatdataPreparationcheck.timeremainder	= 150;
						KailleraChatdataPreparationcheck.addtime	= 90;
						KailleraChatdataPreparationcheck.maxtime	= 256;
						KailleraChatdataPreparationcheck.Callback			= SendStateSaveFile;
						KailleraChatdataPreparationcheck.Callback_Update	= SendStateSaveFile_Update;

						if(KailleraPlayerOption.max <= 1) {
							usrintf_showmessage("M肪܂" );
							PreparationcheckClear();
						}
						else {
							// ŏɃf[^TCYȂǂ𑗐M
							dat[0] = KailleraChatdataPreparationcheck.nmb;
							dat[1] = 0x00000000;	// ]xȂǁB
							dat[2] = Kaillera_Send_Len;
							dat[3] = Kaillera_Send_DecompressLen;
							dat[4] = Kaillera_Send_CRC;
							Kaillera_Send_Pos = 0;
							kailleraChatSend(kChatData(&dat[0], 5*4));
						}
					} else {
						usrintf_showmessage("G[AMɎs܂" );
						free(dest);
					}
					free(temp);
					osd_fclose(file);
					} /* if(file == -1) */
				}

			} /* NGCgl݂̂̑͂܂ */

		}

		
		if(input_ui_pressed(IPT_UI_KAILLERA_PLAYER_DUP))
			if(KailleraStartOption.player == 1)		kaillera_ipu_ui = 4;


		if(KailleraPlayerOption.playercontrol) {	//2 Input ̃vC[ʒuړ
			int ipu_ui = 0;
			if(input_ui_pressed(IPT_UI_KAILLERA_PLAYER_INC))ipu_ui = 7;
			if(input_ui_pressed(IPT_UI_KAILLERA_PLAYER_DEC))ipu_ui = 6;
			val[KailleraPlayerOption.playercontrol] &= usedkeysMask_get();
			val[KailleraPlayerOption.playercontrol] |=	((ipu_ui & 0x1) << usedkeys[0])		|
														((ipu_ui & 0x2) << (usedkeys[1]-1)) |
														((ipu_ui & 0x4) << (usedkeys[2]-2));
		} else {
			if(input_ui_pressed(IPT_UI_KAILLERA_PLAYER_INC))kaillera_ipu_ui = 7;
			if(input_ui_pressed(IPT_UI_KAILLERA_PLAYER_DEC))kaillera_ipu_ui = 6;
		}


		if(input_ui_pressed(IPT_UI_KAILLERA_TEST_1) && KailleraStartOption.player == 1) {
			char tmp[] = "I[gZ[uXXXX  ";
			if( Kaillera_StateSave_Flags & KAILLERA_STATESAVE_AUTOSAVE ) {
				Kaillera_StateSave_Flags &= ~KAILLERA_STATESAVE_AUTOSAVE;
				strcpy(&tmp[12] , "~");
				kailleraChatSend(tmp);
			} else { 
				Kaillera_StateSave_Flags |= KAILLERA_STATESAVE_AUTOSAVE;
				strcpy(&tmp[12] , "Jn");
				kailleraChatSend(tmp);

				KailleraStartOption.autosave_time_interval	= (int)(69.0 * (double)Machine->drv->frames_per_second + 0.5);
			}
		}
		if(input_ui_pressed(IPT_UI_KAILLERA_TEST_3) && KailleraStartOption.player == 1) {// mamẽo[W`FbN
			long dat[64];
			dat[0] = 0x00000005;
			dat[1] = 0;
			kailleraChatSend(kChatData(&dat[0], 8));//Sɓ`B
		}

		if(input_ui_pressed(IPT_UI_KAILLERA_TEST_2) && KailleraStartOption.player == 1)	// Ԓ߃xύX
		{
			long dat[64];
			dat[0] = 0x0000000d;
			dat[1] = (KailleraPlayerOption.waittimemode+1) % 5;
			kailleraChatSend(kChatData(&dat[0], 8));//Sɓ`B
		}



		if(input_ui_pressed(IPT_UI_KAILLERA_TEST1_2) 
			&& KailleraChatdataPreparationcheck.timeremainder <= 0
			//&& !KailleraSyncCheck.count
			)
		{	//Y`FbN
			if (KailleraSyncCheck.count)
			{
				if (KailleraChatdataPreparationcheck.nmb == 11 &&
					!strcmp(KailleraChatdataPreparationcheck.str, "`FbN") )
					usrintf_showmessage("`FbNł" );
				else
					usrintf_showmessage("̃vC[`FbNł" );
			} else
			if(KailleraPlayerOption.max <= 1) {
				usrintf_showmessage("`FbN̑肪܂" );
			} else
			{
				long dat[64];
				const unsigned long pos = KailleraPlayerOption.chatsend_timelag;
				const unsigned short steppos = 8, count = 8;	// MAX count 10?
				KailleraChatdataPreparationcheck.nmb			= 11;
				KailleraChatdataPreparationcheck.str			= "`FbN";
				KailleraChatdataPreparationcheck.count			= KailleraPlayerOption.max;
				KailleraChatdataPreparationcheck.timeremainder	= 150 + pos + steppos*count;
				KailleraChatdataPreparationcheck.addtime		= 90;
				KailleraChatdataPreparationcheck.maxtime		= 256 + pos + steppos*count;
				KailleraChatdataPreparationcheck.flag			= 0;
				KailleraChatdataPreparationcheck.Callback			= SendSyncCheck;
				KailleraChatdataPreparationcheck.Callback_Update	= SendSyncCheck_Update;
			
				dat[0] = KailleraChatdataPreparationcheck.nmb | ((KailleraStartOption.player & 0xff) << 24);
				dat[1] = synccount + pos;	//	`FbNJn|Cg
				dat[2] = (steppos) | (count<<16);	//8t[ɂWCRC`FbN
				kailleraChatSend(kChatData(&dat[0], 3*4));//Sɓ`B

				KailleraSyncCheck.basepos		= synccount + pos;
				KailleraSyncCheck.totalcount	= count;			
				KailleraSyncCheck.step			= steppos;
				KailleraSyncCheck.count			= KailleraSyncCheck.totalcount;
				KailleraSyncCheck.pos			= KailleraSyncCheck.basepos + KailleraSyncCheck.step;
				usrintf_showmessage("`FbNJn" );
			}
		}
		


		val[0] &= usedkeysMask_get();
		val[0] |=	((kaillera_ipu_ui & 0x1) << usedkeys[0]) |
					((kaillera_ipu_ui & 0x2) << (usedkeys[1]-1)) |
					((kaillera_ipu_ui & 0x4) << (usedkeys[2]-2));

		synccount++;
		if(KAILLERA_VAL_LEN == 4) {
			val[0] &= 0x0000ffff;
			val[0] |= ((synccount & 0xffff) << 16);
		}
		



	}			//kt end


	{
		//static unsigned short sba = 0,sbb = 0;
		static unsigned char ia = 0; ib=0; //,ib = 0;
		
	
		Kaillera_Val_Len = KAILLERA_VAL_LEN + Kaillera_analog_port * KAILLERA_ANALOG_LEN;
		if( kMaxMahjong )
			Kaillera_Val_Len++;


		b=0;
		for(i=0;i<16;i++)
		{
			//int port = kAnalogPlayValues[0][i];
			port = kAnalogPlayValues[0][i];
			if(port != -1) {
				//struct InputPort *in;
				in = input_analog[port];
				memcpy(&chval[KAILLERA_VAL_LEN + (b++)*KAILLERA_ANALOG_LEN], &kinput_analog_delta[port][0], KAILLERA_ANALOG_LEN);
			}
		}


		if(kMaxMahjong)
		for(i=0;i<27;i++)
		{
			chval[KAILLERA_VAL_LEN + (Kaillera_analog_port * KAILLERA_ANALOG_LEN)] = 0;	// ŏɃNAĂB
			if(kMahjongPlayValues[0][i][0]!=-1)
			{
				if(kMahjongPlayValues[0][i][2] != IP_ACTIVE_LOW) {
					if( input_port_value[kMahjongPlayValues[0][i][0]] & kMahjongPlayValues[0][i][1] ) {
						chval[KAILLERA_VAL_LEN + (Kaillera_analog_port * KAILLERA_ANALOG_LEN)] = i+1;
						break;
					}
				} else {
					if(!(input_port_value[kMahjongPlayValues[0][i][0]] & kMahjongPlayValues[0][i][1]) ) {
						chval[KAILLERA_VAL_LEN + (Kaillera_analog_port * KAILLERA_ANALOG_LEN)] = i+1;
						break;
					}
				}
			}
		}

		memcpy(&chval[0], &val[0], KAILLERA_VAL_LEN);

		for(j=1; j<KailleraPlayerOption.subplayer+1; j++)
			memcpy(&chval[0]+(Kaillera_Val_Len * j) , &val[j], KAILLERA_VAL_LEN);

		if (Kaillera_StatusFlag & KAILLERA_STATUSFLAG_LOST_CONNECTION
			&& KailleraStartOption.lost_connection_time )
		{
			st=ticker();
			recvLen=-1;
		} else
		{
			KailleraLostConnectionCheck(0);
			st=ticker();
			recvLen=kailleraModifyPlayValues((void *)chval, Kaillera_Val_Len + (Kaillera_Val_Len * KailleraPlayerOption.subplayer));
			//recvLen=Kaillera_Val_Len + (Kaillera_Val_Len * KailleraPlayerOption.subplayer);
		}
		st2 = (ticker()-st);
		if (Kaillera_Inp_InitSleepTime<=0)
			KailleraLostConnectionCheck(1);

		if (recvLen == -1)
			KailleraLostConnection();


		//kailleraChatSend_cb_update();


		if (synccount == 1)
		{
			//extern void SetActivateWindow(void);
			//SetActivateWindow();
		}

	if(input_ui_pressed(IPT_UI_KAILLERA_TEST1_6))
	{	//kt test
		//unsigned int size, bankcpu, bankcount;
		//int cpu = get_game_ram_serch_cpu(&size, &bankcpu, &bankcount);

		//usrintf_showmessage( "Search Cpu %d, Ram %uByte, Over %uByte", cpu, size, oversize );
		//usrintf_showmessage( "Search Cpu %d, Ram %uKB, Bank %u, BankBase %u", cpu, size / 1000, bankcount, bankcpu );
		
	}
		if( Kaillera_Inp_InitSleepTime>0 )
		{
			if (	recvLen == 0 ||
					Kaillera_Inp_InitSleepTime > (KAILLERA_STATESAVE_NORMAL_DELAYTIME / 4 - 1) )
			{
				//const int players = KailleraStartOption.numplayers * (KailleraPlayerOption.subplayer+1);
				int pltemp;
				const int k_players = KailleraStartOption.numplayers * (KailleraPlayerOption.subplayer+1);
				pltemp = k_players;
				if (k_players < 4) pltemp = 4;

				player_val_clear( (char *)chval, kValXor, pltemp, kMaxMahjong);
				recvLen = Kaillera_Val_Len * k_players;
			}
		}

		KailleraWaitSubTick += st2;
		if(KailleraWaitSubTick > ((TICKER)CLOCKS_PER_SEC<<7))
			KailleraWaitSubTick = ((TICKER)CLOCKS_PER_SEC<<7);

		KailleraWaitTick += st2;

		{
			addTick(st2);
		}


		if(recvLen > 255)recvLen = 255;
		if(recvLen <= 0) { recvLen = 0; recvPlayer = recvLen;}
		else recvPlayer = (int)(recvLen/Kaillera_Val_Len);

		recvPlsub = recvPlayer;
		if((recvPlayer < KailleraStartOption.gameinputmin) && recvPlayer) {
			recvPlayer = KailleraStartOption.gameinputmin;
			{
				//int i;
				memset(&chval[recvPlsub*Kaillera_Val_Len], 0, (recvPlayer-recvPlsub)*Kaillera_Val_Len);
				for(i=0; i<recvPlayer-recvPlsub; i++)
					*((unsigned short*)&chval[recvPlsub*Kaillera_Val_Len + i*Kaillera_Val_Len]) = kValXor;
			}
		}


		if(KailleraPlayerOption.subplayer) recvPlsub >>= 1;



		
		if( Kaillera_Inp_InitSleepTime>0 ) {
			Kaillera_Inp_InitSleepTime--;
			if( Kaillera_Inp_InitSleepTime<=0 )
			{
				//extern void SetActivateWindow(void);
				if (Kaillera_StatusFlag & KAILLERA_STATUSFLAG_2INPUTSTART)
				{
					long dat[64];
					dat[0] = 0x0000000f;
					dat[1] = 0x00000101;
					kailleraChatSend(kChatData(&dat[0], 8));

					Kaillera_StatusFlag &= ~KAILLERA_STATUSFLAG_2INPUTSTART;
				}
				//SetActivateWindow();
			}
		}
		Kaillera_Inp_CRC = crc32(Kaillera_Inp_CRC, &chval[0], recvLen);


		for(i=0; i<recvPlayer ; i++)
			memcpy(&val[i], &chval[i*Kaillera_Val_Len], KAILLERA_VAL_LEN);

		ia++;ib--;
	}


	if(kPlay){	//kt start

		if(recvLen != maxplayer) { //vC[ωAvC[ʒuB
			maxplayer = recvLen;
			if( Kaillera_StateSave_Flags & KAILLERA_STATESAVE_AUTOSAVE )
				usrintf_showmessage("I[gZ[u𒆎~܂" );
			playernmb_clear();
			playernmb_dup_clear();
			Kaillera_StateSave_Count = 0;
			Kaillera_StateSave_Flags = 0;
			Kaillera_StateSave_Retry = 0;
		}


		if(Kaillera_StateSave_TimeRemainder == KAILLERA_STATESAVE_NORMAL_DELAYTIME) { // Z[ûŁACRC`FbNB
			long dat[64];
			UINT32 crc;
			char name[2];
			name[0] = '@';
			name[1] = 0;
		
			crc = game_ram_serch_crc32_kaillera_state_save(Kaillera_Inp_StateSave_CRC);
			Kaillera_StateSave_CRC		 = crc;

			dat[0] = 0x00000001;
			dat[1] = Kaillera_StateSave_CRC;
			kailleraChatSend(kChatData(&dat[0], 8));//Sɓ`B
			
		}

		if(Kaillera_Send_Flags & 0x1) { // `bggđ傫f[^M
			//unsigned long syslen = 8;
			unsigned long len;
			//int pos = 2;
			//int i;

			static unsigned int count;
			unsigned int up;
			int loop;
			

			if (KailleraPlayerOption.sendfilespeed < 0)
			{
				loop = -KailleraPlayerOption.sendfilespeed;
				up = 1;
			} else
			{
				loop = 1;
				up = KailleraPlayerOption.sendfilespeed+1;
			}

			if((count++ % up) == 0)
			{
			for(i=0; i<loop; i++) {
				char *ch;
				len = 108;

				if( len + Kaillera_Send_Pos > Kaillera_Send_Len)
					len = Kaillera_Send_Len - Kaillera_Send_Pos;
				ch = kChatDatabit(lpkChatDatabit + Kaillera_Send_Pos, len);
				kailleraChatSend(ch);
				Kaillera_Send_Pos += len;
				if( Kaillera_Send_Pos >= Kaillera_Send_Len ) {
					free(lpkChatDatabit);
					lpkChatDatabit = 0;
					Kaillera_Send_Flags &= ~0x1;
					Kaillera_StateSave_TimeRemainder = KAILLERA_STATESAVE_NORMAL_DELAYTIME-1;
					usrintf_showmessage("f[^M");
					break;
				}
			}
			}

		}

		if (KailleraSyncCheck.count)	//`FbN
		{
			if (synccount == KailleraSyncCheck.pos)
			{
				
				KailleraSyncCheck.crc[KailleraStartOption.player-1][KailleraSyncCheck.totalcount - KailleraSyncCheck.count] = game_ram_serch_crc32_(0);	//Q[CPUgpĂ郁CRCg
				KailleraSyncCheck.pos += KailleraSyncCheck.step;
				KailleraSyncCheck.count--;
				if (!KailleraSyncCheck.count)	//S`FbN̂ŁA`bgCRC𑗐M
				{
					//int i;
					long dat[64];
					dat[0] = 0x0000000f | ((KailleraStartOption.player & 0xff) << 24);
					dat[1] = 0x0000000b;
					dat[2] = 0x00000000;

					memcpy (&dat[3], &KailleraSyncCheck.crc[KailleraStartOption.player-1][0], sizeof(long) * KailleraSyncCheck.totalcount);

					kailleraChatSend(kChatData(&dat[0], (3 + KailleraSyncCheck.totalcount)*sizeof(long)));
				}
			}

		}


		kaillera_ipu_ui	=	((val[0] >> usedkeys[0]) & 0x1) |
							((val[0] >> (usedkeys[1]-1)) & 0x2) |
							((val[0] >> (usedkeys[2]-2)) & 0x4);

		switch( kaillera_ipu_ui )
		{
		case 1:
			if (GetShowSystemMessage())
				usrintf_showmessage("Zbg܂");
			synccount = 0;
			KailleraSyncCheck.basepos = KailleraSyncCheck.step;
			KailleraSyncCheck.count = 0;

			Kaillera_StateSave_Retry = 0;
			Kaillera_Inp_CRC = crc32(0, &chval[0], recvLen);
			{
				extern int time_to_reset;
				time_to_reset = 2;
				ResetReplay();
				machine_reset();
				perform_ui = 3;
				perform_ui_dat = 0;
			}
			
			break;
		case 2:						// Xe[gZ[u
			{
				int filen = 0;
				if(Kaillera_StateSave_Count > 0) break;
				filen = '@';
				cpu_loadsave_schedule(LOADSAVE_SAVE, filen);
				perform_ui = 1;
				perform_ui_dat = (int)Kaillera_StateSave_file & 0xff;
				Kaillera_StateSave_TimeRemainder = KAILLERA_STATESAVE_NORMAL_DELAYTIME + 8;

				if(recvPlsub < KailleraStartOption.numplayers)
					Kaillera_StateSave_Count	= KailleraStartOption.numplayers;
				else
					Kaillera_StateSave_Count	= recvPlsub;

				Kaillera_Inp_StateSave_CRC = Kaillera_Inp_CRC;
			}
			break;
		case 3:
			{
				int file = 0;
				//int flag;
				if(Kaillera_StateSave_Count > 0) break;
				file = Kaillera_StateSave_file;

				ResetReplay();

				cpu_loadsave_schedule(LOADSAVE_LOAD, file);
				if (GetShowSystemMessage())
					usrintf_showmessage("%s.st%c ǂݍ݂܂", Machine->gamedrv->name, file);
				//palette_refresh();
				perform_ui = 2;
				perform_ui_dat = (int)Kaillera_StateSave_file & 0xff;
				Kaillera_StateSave_Count = 0;
				Kaillera_StateSave_Retry = 0;
				Kaillera_Inp_CRC = crc32(0, &chval[0], recvLen);
			}
			break;
		case 4:
			kPlayerDup = !kPlayerDup;
			if(kPlayerDup)	usrintf_showmessage("vC[ʒȕdw肪\x94\x5cɂȂ܂");
			else			usrintf_showmessage("vC[ʒȕdw肪܂");

			break;
		case 5:
			break;		
		case 6: 

		default:;
		}
		if( Kaillera_StateSave_TimeRemainder > 0 ) {
			Kaillera_StateSave_TimeRemainder--;
			if( Kaillera_StateSave_TimeRemainder <= 0) 
				if(Kaillera_StateSave_Count > 0) {
						usrintf_showmessage("Z[u`FbN^CAEg܂"); 
					Kaillera_StateSave_Count = 0;
					Kaillera_StateSave_Retry = 0;

				}
		}
		if( Kaillera_Send_SleepTime > 0 ) {
			Kaillera_Send_SleepTime--;
			if( Kaillera_Send_SleepTime <= 0) { 
				usrintf_showmessage("f[^M^CAEg܂");
				Kaillera_Send_Flags &= ~0x2;
				if( lpkChatDatabit )
					free( lpkChatDatabit );
				lpkChatDatabit = 0;
			}
		}

		if( KailleraChatdataPreparationcheck.timeremainder>0 ) {
			KailleraChatdataPreparationcheck.timeremainder--;
			if( KailleraChatdataPreparationcheck.timeremainder<=0 ) {
				char str[256];
				strcpy(str, KailleraChatdataPreparationcheck.str);
				strcat(str, "^CAEg܂");
				
				PreparationcheckClear();
				usrintf_showmessage(str);
			}
		}


		if( 1<recvPlayer )
		{
			if(kPlayerDup)	//dʒu̎gp
			{
				for(i=0; i<recvPlayer ; i++)
					memcpy(&val[i], &chval[i*Kaillera_Val_Len], KAILLERA_VAL_LEN);

				for(i=0; i<recvPlayer; i++)
				{
					kaillera_ipu_ui	=	((val[i] >> usedkeys[0]) & 0x1) |
										((val[i] >> (usedkeys[1]-1)) & 0x2) |
										((val[i] >> (usedkeys[2]-2)) & 0x4);

					switch ( kaillera_ipu_ui )
					{
					case 3:
						if((i % (KailleraPlayerOption.subplayer+1))
							&& KailleraPlayerOption.subplayer )
						{
							//int j;
							char s[256];

							j=KailleraStartOption.numplayers;
							playernmb_dup_set(i,j);

							getmessage_playernmb_dup(s, recvPlayer, i, "ύX", 1);
							usrintf_showmessage(s);
						}
						break;
					case 6:
						{
							//int j;
							char s[256];
							j = playernmb_dup[i];
							if(j<recvPlayer-1) j++;
							playernmb_dup_set(i,j);
					
							getmessage_playernmb_dup(s, recvPlayer, i, "", 0);
							usrintf_showmessage(s);
						}
						break;
					case 7:
						{
							//int j;
							char s[256];
							j = playernmb_dup[i];
							if(j>0) j--;
							playernmb_dup_set(i,j);

							getmessage_playernmb_dup(s, recvPlayer, i, "Oi", 0);
							usrintf_showmessage(s);
						}
						break;

					default:;
					}

				}

				player_renmb_dup( (char *)chval, kValXor, recvPlayer, kMaxMahjong);
				for(i=0; i<recvPlayer ; i++)
					memcpy(&val[i], &chval[i*Kaillera_Val_Len], KAILLERA_VAL_LEN);
			} else
			{
				player_renmb( chval, Kaillera_Val_Len);
				for(i=0; i<recvPlayer ; i++)
					memcpy(&val[i], &chval[i*Kaillera_Val_Len], KAILLERA_VAL_LEN);
				for(i=0; i<recvPlayer; i++)
				{
					kaillera_ipu_ui	=	((val[i] >> usedkeys[0]) & 0x1) |
										((val[i] >> (usedkeys[1]-1)) & 0x2) |
										((val[i] >> (usedkeys[2]-2)) & 0x4);

					switch ( kaillera_ipu_ui )
					{
						int pl;
					case 3:
						pl = playernmb[i];

						if((pl % (KailleraPlayerOption.subplayer+1)) == KailleraPlayerOption.subplayer && KailleraPlayerOption.subplayer )
						{
							//int j;
							char s[256];
							j=KailleraStartOption.numplayers;
							playernmb_set(i,j);

							getmessage_playernmb(s, recvPlayer, pl, "ύX", 1);
							usrintf_showmessage(s);
						}
						break;
					case 6:
						{
							//int j;
							char s[256];
							pl = playernmb[i];
							j=i+1;
							if(j>=recvPlayer) j=recvPlayer-1;
							playernmb_set(i,j);

							getmessage_playernmb(s, recvPlayer, pl, "", 0);
							usrintf_showmessage(s);
							break;
						}
					case 7:
						{
							//int j;
							char s[256];
							pl = playernmb[i];
							j=i-1;
							if(j<0) j=0;
							playernmb_set(i,j);

							getmessage_playernmb(s, recvPlayer, pl, "Oi", 0);
							usrintf_showmessage(s);
						break;
						}
					}
				}
				}
			}

			//MemoryHack_KailleraInputVal(val, KailleraStartOption.numplayers);
	}			//kt end


    if(recvLen>0)
    {
	  if(recvPlayer > 4) recvPlayer = 4;//kt

	  //usrintf_showmessage("%d",*((short*)&chval[0]));
	  //usrintf_showmessage( IntToBit((int)val[0]));

      memcpy(input_port_value,kDefValues,sizeof(input_port_value));
      for(i=0;i<recvPlayer;i++)
      {
        //int j;
        b=1;
        for(j=0;j<16;j++)
        {


          if(kBitsPlayValues[i][j][0]!=-1)
          {
            if(kBitsPlayValues[i][j][2] != IP_ACTIVE_LOW) {
              if(!(val[i] & b))
                  input_port_value[kBitsPlayValues[i][j][0]] |= kBitsPlayValues[i][j][1];
			  else
				  input_port_value[kBitsPlayValues[i][j][0]] &= ~kBitsPlayValues[i][j][1]; //kt
            } else {
			  if(val[i] & b)
			      input_port_value[kBitsPlayValues[i][j][0]] &= ~kBitsPlayValues[i][j][1];
			  else
				  input_port_value[kBitsPlayValues[i][j][0]] |= kBitsPlayValues[i][j][1]; //kt
			}
          }

          if(kBitsPlayValues[i][j][0+3]!=-1)
          {
            if(kBitsPlayValues[i][j][2+3] != IP_ACTIVE_LOW) {
              if(!(val[i] & b))
                  input_port_value[kBitsPlayValues[i][j][0+3]] |= kBitsPlayValues[i][j][1+3];
			  else
				  input_port_value[kBitsPlayValues[i][j][0+3]] &= ~kBitsPlayValues[i][j][1+3]; //kt
            } else {
			  if(val[i] & b)
			      input_port_value[kBitsPlayValues[i][j][0+3]] &= ~kBitsPlayValues[i][j][1+3];
			  else
				  input_port_value[kBitsPlayValues[i][j][0+3]] |= kBitsPlayValues[i][j][1+3]; //kt
			}
          }

          b=b<<1;
        }
		//kt s
		b=0;
		for(j=0;j<16;j++) {
			if(kAnalogPlayValues[i][j]!=-1) {
				memcpy(&kinput_analog_delta[kAnalogPlayValues[i][j]][1], &chval[KAILLERA_VAL_LEN+(b++)*KAILLERA_ANALOG_LEN+i*Kaillera_Val_Len], KAILLERA_ANALOG_LEN);
			}
		}

		if(kMaxMahjong)
		for(j=0;j<27;j++)
		{
			if(kMahjongPlayValues[i][j][0]!=-1)
			{
				if(kMahjongPlayValues[i][j][2] != IP_ACTIVE_LOW) {
					if(chval[KAILLERA_VAL_LEN + Kaillera_analog_port*KAILLERA_ANALOG_LEN + i*Kaillera_Val_Len] == j+1)
						input_port_value[kMahjongPlayValues[i][j][0]] |= kMahjongPlayValues[i][j][1];
					else
						input_port_value[kMahjongPlayValues[i][j][0]] &= ~kMahjongPlayValues[i][j][1];
				} else {
					if(chval[KAILLERA_VAL_LEN + Kaillera_analog_port*KAILLERA_ANALOG_LEN + i*Kaillera_Val_Len] == j+1)
						input_port_value[kMahjongPlayValues[i][j][0]] &= ~kMahjongPlayValues[i][j][1];
					else
						input_port_value[kMahjongPlayValues[i][j][0]] |= kMahjongPlayValues[i][j][1];
				}
			}
		}
		//kt e
      }
    }
    if(recvLen==0) memcpy(kDefValues,input_port_value,sizeof(input_port_value));
      
	if(recvPlayer < 4 && (recvLen>0 || Kaillera_Inp_InitSleepTime>0) )
      for(i=recvPlayer;i<4;i++)
		{
        //int j;
        for(j=0;j<16;j++)
        {
          if(kBitsPlayValues[i][j][0]!=-1)
          {
            if(kBitsPlayValues[i][j][2] != IP_ACTIVE_LOW) {
				  input_port_value[kBitsPlayValues[i][j][0]] &= ~kBitsPlayValues[i][j][1]; //kt
            } else {
				  input_port_value[kBitsPlayValues[i][j][0]] |= kBitsPlayValues[i][j][1]; //kt
			}
          }

          if(kBitsPlayValues[i][j][0+3]!=-1)
          {
            if(kBitsPlayValues[i][j][2+3] != IP_ACTIVE_LOW) {
				  input_port_value[kBitsPlayValues[i][j][0+3]] &= ~kBitsPlayValues[i][j][1+3]; //kt
            } else {
				  input_port_value[kBitsPlayValues[i][j][0+3]] |= kBitsPlayValues[i][j][1+3]; //kt
			}
          }

        }

		for(j=0;j<16;j++) {
			if(kAnalogPlayValues[i][j]!=-1) {
				kinput_analog_delta[kAnalogPlayValues[i][j]][1] = 0;
			}
		}

		if(kMaxMahjong)
		for(j=0;j<27;j++)
		{
			if(kMahjongPlayValues[i][j][0]!=-1)
			{
				if(kMahjongPlayValues[i][j][2] != IP_ACTIVE_LOW) {
					input_port_value[kMahjongPlayValues[i][j][0]] &= ~kMahjongPlayValues[i][j][1];
				} else {
					input_port_value[kMahjongPlayValues[i][j][0]] |= kMahjongPlayValues[i][j][1];
				}
			}
		}


	}
	
	}
 } /* kPlay */
#endif /* KAILLERA */

	if (record)
	{
		int i;

		for (i = 0; i < MAX_INPUT_PORTS; i ++)
			writeword(record,input_port_value[i]);
	}

#ifdef MAME32JP
	{
		switch (input_ui_temp)
		{
		case 1:	//Xe[gZ[u
			{
				//int flag;
				cpu_loadsave_schedule(LOADSAVE_SAVE, input_ui_temp_dat[0]);
				if (!playbacksub && GetShowSystemMessage()) usrintf_showmessage("%s.st%c ɕۑ܂", Machine->gamedrv->name, input_ui_temp_dat[0]);
			}
			perform_ui = input_ui_temp;
			perform_ui_dat = (int)input_ui_temp_dat[0] & 0xff;
			break;
		case 2:	//[h
			{
				//int flag;

				ResetReplay();

				cpu_loadsave_schedule(LOADSAVE_LOAD, input_ui_temp_dat[0]);
				//palette_refresh();
				if (GetShowSystemMessage())
					usrintf_showmessage("%s.st%c ǂݍ݂܂", Machine->gamedrv->name, input_ui_temp_dat[0]);
			}
			perform_ui = input_ui_temp;
			perform_ui_dat = (int)input_ui_temp_dat[0] & 0xff;
			break;
		case 3:	//Zbg
			{
				extern int time_to_reset;
				time_to_reset = 2;
				ResetReplay();
				machine_reset();
			}
			perform_ui = input_ui_temp;
			perform_ui_dat = 0;
			break;

		default:;
		}
		input_ui_temp = 0;
	}

	if (recordsub)
	{
		perform_ui_count++;
		if(perform_ui || (perform_ui_count >= 0xffff))
		{
			int i;
			writeword(recordsub,(short)(perform_ui_count&0xffff));
			writeword(recordsub,(short)(perform_ui&0xffff));
			writeword(recordsub,(short)(perform_ui_dat&0xffff) );
			writeword(recordsub,(short)((perform_ui_dat>>16)&0xffff));
			perform_ui_count = 0;

			switch (perform_ui)
			{
			case 1:	//Xe[gZ[u
				for(i=0; i<perform_ui_statesave_file_size+1; i++)
				{
					if(perform_ui_statesave_file[i] == (char)perform_ui_dat) { i=65535; break;}
				}
				if( i<65535 )
					perform_ui_statesave_file[perform_ui_statesave_file_size++] = (char)perform_ui_dat;
				if(perform_ui_statesave_file_size > 255) perform_ui_statesave_file_size=255;
				break;

			}
		}
	}
#endif

#ifdef MAME_NET
	if ( net_active() && (default_player != NET_SPECTATOR) )
		net_input_sync((unsigned char *) input_port_value, (unsigned char *) input_port_defaults, MAX_INPUT_PORTS);
#endif /* MAME_NET */

#ifdef USE_SHOW_INPUT_LOG
	/* show input log */
	if (show_input_log)
		make_input_log();
#endif /* USE_SHOW_INPUT_LOG */

profiler_mark(PROFILER_END);
}



/* used the the CPU interface to notify that VBlank has ended, so we can update */
/* IPT_VBLANK input ports. */
void inputport_vblank_end(void)
{
	int port;
	int i;


profiler_mark(PROFILER_INPUT);
	for (port = 0;port < MAX_INPUT_PORTS;port++)
	{
		if (input_vblank[port])
		{
			input_port_value[port] ^= input_vblank[port];
			input_vblank[port] = 0;
		}
	}

	/* update the analog devices */
	for (i = 0;i < OSD_MAX_JOY_ANALOG;i++)
	{
		/* update the analog joystick position */
		analog_previous_x[i] = analog_current_x[i];
		analog_previous_y[i] = analog_current_y[i];
		osd_analogjoy_read (i, &(analog_current_x[i]), &(analog_current_y[i]));

		/* update mouse/trackball position */
		osd_trak_read (i, &mouse_delta_x[i], &mouse_delta_y[i]);
	}

	for (i = 0;i < MAX_INPUT_PORTS;i++)
	{
		struct InputPort *in;

		in=input_analog[i];
		if (in)
		{
			update_analog_port(i);
		}
	}
profiler_mark(PROFILER_END);
}



int readinputport(int port)
{
	struct InputPort *in;

	/* Update analog ports on demand */
	in=input_analog[port];
	if (in)
	{
		scale_analog_port(port);
	}

	return input_port_value[port];
}

READ_HANDLER( input_port_0_r ) { return readinputport(0); }
READ_HANDLER( input_port_1_r ) { return readinputport(1); }
READ_HANDLER( input_port_2_r ) { return readinputport(2); }
READ_HANDLER( input_port_3_r ) { return readinputport(3); }
READ_HANDLER( input_port_4_r ) { return readinputport(4); }
READ_HANDLER( input_port_5_r ) { return readinputport(5); }
READ_HANDLER( input_port_6_r ) { return readinputport(6); }
READ_HANDLER( input_port_7_r ) { return readinputport(7); }
READ_HANDLER( input_port_8_r ) { return readinputport(8); }
READ_HANDLER( input_port_9_r ) { return readinputport(9); }
READ_HANDLER( input_port_10_r ) { return readinputport(10); }
READ_HANDLER( input_port_11_r ) { return readinputport(11); }
READ_HANDLER( input_port_12_r ) { return readinputport(12); }
READ_HANDLER( input_port_13_r ) { return readinputport(13); }
READ_HANDLER( input_port_14_r ) { return readinputport(14); }
READ_HANDLER( input_port_15_r ) { return readinputport(15); }
READ_HANDLER( input_port_16_r ) { return readinputport(16); }
READ_HANDLER( input_port_17_r ) { return readinputport(17); }
READ_HANDLER( input_port_18_r ) { return readinputport(18); }
READ_HANDLER( input_port_19_r ) { return readinputport(19); }

READ16_HANDLER( input_port_0_word_r ) { return readinputport(0); }
READ16_HANDLER( input_port_1_word_r ) { return readinputport(1); }
READ16_HANDLER( input_port_2_word_r ) { return readinputport(2); }
READ16_HANDLER( input_port_3_word_r ) { return readinputport(3); }
READ16_HANDLER( input_port_4_word_r ) { return readinputport(4); }
READ16_HANDLER( input_port_5_word_r ) { return readinputport(5); }
READ16_HANDLER( input_port_6_word_r ) { return readinputport(6); }
READ16_HANDLER( input_port_7_word_r ) { return readinputport(7); }
READ16_HANDLER( input_port_8_word_r ) { return readinputport(8); }
READ16_HANDLER( input_port_9_word_r ) { return readinputport(9); }
READ16_HANDLER( input_port_10_word_r ) { return readinputport(10); }
READ16_HANDLER( input_port_11_word_r ) { return readinputport(11); }
READ16_HANDLER( input_port_12_word_r ) { return readinputport(12); }
READ16_HANDLER( input_port_13_word_r ) { return readinputport(13); }
READ16_HANDLER( input_port_14_word_r ) { return readinputport(14); }
READ16_HANDLER( input_port_15_word_r ) { return readinputport(15); }
READ16_HANDLER( input_port_16_word_r ) { return readinputport(16); }
READ16_HANDLER( input_port_17_word_r ) { return readinputport(17); }
READ16_HANDLER( input_port_18_word_r ) { return readinputport(18); }
READ16_HANDLER( input_port_19_word_r ) { return readinputport(19); }

#ifdef MAME_NET
void set_default_player_controls(int player)
{
	if (player == NET_SPECTATOR)
		default_player = NET_SPECTATOR;
	else
		default_player = player - 1;
}
#endif /* MAME_NET */

/***************************************************************************/
/* InputPort conversion */

static unsigned input_port_count(const struct InputPortTiny *src)
{
	unsigned total;

	total = 0;
	while (src->type != IPT_END)
	{
		int type = src->type & ~IPF_MASK;
		if (type > IPT_ANALOG_START && type < IPT_ANALOG_END)
			total += 2;
		else if (type != IPT_EXTENSION)
			++total;
		++src;
	}

	++total; /* for IPT_END */

	return total;
}

struct InputPort* input_port_allocate(const struct InputPortTiny *src)
{
	struct InputPort* dst;
	struct InputPort* base;
	unsigned total;

#ifdef USE_CUSTOM_BUTTON
	{
		const struct InputPortTiny *inp;
		int port = 0;
		int p;
		int b;

		players = 0;
		normal_buttons = 0;

		for (inp = src; inp->type != IPT_END; inp++)
		{
			if (inp->type == IPT_PORT)
				port++;

			if ((inp->type & ~IPF_MASK) == IPT_EXTENSION)
				continue;

			switch (inp->type & IPF_PLAYERMASK)
			{
			case IPF_PLAYER1:
				p = 1;
				break;
			case IPF_PLAYER2:
				p = 2;
				break;
			case IPF_PLAYER3:
				p = 3;
				break;
			case IPF_PLAYER4:
				p = 4;
				break;
			default:
				p = 0;
			}

			if (!p)
				continue;

			b = (inp->type & ~IPF_MASK) - IPT_BUTTON1 + 1;
			if (b < 1 || b > MAX_NORMAL_BUTTONS)
				continue;

			if (p > players)
				players = p;

			if (b > normal_buttons)
				normal_buttons = b;

			normal_button[p - 1][b - 1].mask = inp->mask;
			normal_button[p - 1][b - 1].port = port - 1;
		}

		if (normal_buttons > 2)
			custom_buttons = 4;
		else if (normal_buttons == 2)
			custom_buttons = 3;
		else
			custom_buttons = normal_buttons;
	}

	total = input_port_count(src) + players * custom_buttons;
#else /* USE_CUSTOM_BUTTON */
	total = input_port_count(src);
#endif /* USE_CUSTOM_BUTTON */

	base = (struct InputPort*) auto_malloc(total * sizeof(struct InputPort));
	if (!base)
		return NULL;
	memset(base, 0, total * sizeof(struct InputPort));
	dst = base;

	while (src->type != IPT_END)
	{
		int type = src->type & ~IPF_MASK;
		const struct InputPortTiny *ext;
		const struct InputPortTiny *src_end;
		InputCode seq_default;

		if (type > IPT_ANALOG_START && type < IPT_ANALOG_END)
			src_end = src + 2;
		else
			src_end = src + 1;

		switch (type)
		{
			case IPT_END :
			case IPT_PORT :
			case IPT_DIPSWITCH_NAME :
			case IPT_DIPSWITCH_SETTING :
				seq_default = CODE_NONE;
			break;
			default:
				seq_default = CODE_DEFAULT;
		}

		ext = src_end;
		while (src != src_end)
		{
			dst->type = src->type;
			dst->mask = src->mask;
			dst->default_value = src->default_value;
			dst->name = src->name;

  			if (ext->type == IPT_EXTENSION)
  			{
				InputCode or1 =	IP_GET_CODE_OR1(ext);
				InputCode or2 =	IP_GET_CODE_OR2(ext);

				if (or1 < __code_max)
				{
					if (or2 < __code_max)
						seq_set_3(&dst->seq, or1, CODE_OR, or2);
					else
						seq_set_1(&dst->seq, or1);
				} else {
					if (or1 == CODE_NONE)
						seq_set_1(&dst->seq, or2);
					else
						seq_set_1(&dst->seq, or1);
				}

  				++ext;
  			} else {
				seq_set_1(&dst->seq,seq_default);
  			}

			++src;
			++dst;
		}

		src = ext;
	}

#ifdef USE_CUSTOM_BUTTON
	{
		static int pf[MAX_PLAYERS] = {
			IPF_PLAYER1,
			IPF_PLAYER2,
			IPF_PLAYER3,
			IPF_PLAYER4
		};

		int p;
		int b;

		for (p = 0; p < players; p++)
			for (b = 0; b < custom_buttons; b++)
			{
				dst->type = (IPT_CUSTOM1 + b) | pf[p];
				dst->mask = 0;
				dst->default_value = IP_ACTIVE_LOW;
				dst->name = IP_NAME_DEFAULT;
				seq_set_1(&dst->seq, CODE_DEFAULT);

				dst++;
			}
	}
#endif /* USE_CUSTOM_BUTTON */


	dst->type = IPT_END;

	return base;
}


void seq_set_string(InputSeq* a, const char *buf)
{
	char *lbuf;
	char *arg = NULL;
	int j;
	struct ik *pik;
	int found;

	// create a locale buffer to be parsed by strtok
	lbuf = malloc (strlen(buf)+1);

	// copy the input string
	strcpy (lbuf, buf);

	for(j=0;j<SEQ_MAX;++j)
		(*a)[j] = CODE_NONE;

	arg = strtok(lbuf, " \t\r\n");
	j = 0;
	while( arg != NULL )
	{
		found = 0;

		pik = input_keywords;

		while (!found && pik->name && pik->name[0] != 0)
		{
			if (strcmp(pik->name,arg) == 0)
			{
				// this entry is only valid if it is a KEYCODE
				if (pik->type == IKT_STD)
				{
					(*a)[j] = pik->val;
					j++;
					found = 1;
				}
			}
			pik++;
		}

		pik = osd_input_keywords;

		if (pik)
		{
			while (!found && pik->name && pik->name[0] != 0)
			{
				if (strcmp(pik->name,arg) == 0)
				{
					switch (pik->type)
					{
						case IKT_STD:
							(*a)[j] = pik->val;
							j++;
							found = 1;
						break;

						case IKT_OSD_KEY:
							(*a)[j] = keyoscode_to_code(pik->val);
							j++;
							found = 1;
						break;

						case IKT_OSD_JOY:
							(*a)[j] = joyoscode_to_code(pik->val);
							j++;
							found = 1;
						break;
					}
				}
				pik++;
			}
		}

		arg = strtok(NULL, " \t\r\n");
	}
	free (lbuf);
}

#ifdef MAME32JP
void toggle_autofire(void)
{
	autofire_enable = autofire_enable ? 0 : 1;
}

static int auto_pressed(InputSeq *seq, UINT32 type, int bit)
{
	int pressed = seq_pressed(seq);

	if (pressed)
	{
		if ((type & IPF_AUTOFIRE_ON) || ((type & IPF_AUTOFIRE_TOGGLE) && autofire_enable))
		{
			if (autopressed[bit] >= options.autofiredelay)
			{
				pressed = 0;
				autopressed[bit] = 0;
			}
			else
				autopressed[bit]++;
		}
	}

	return pressed;
}
#endif

#ifdef USE_SHOW_INPUT_LOG
#define JOYDIR_UP			0
#define JOYDIR_DOWN			1
#define JOYDIR_LEFT			2
#define JOYDIR_RIGHT		3

#define JOYDIR_UP_BIT		(1 << JOYDIR_UP)
#define JOYDIR_DOWN_BIT		(1 << JOYDIR_DOWN)
#define JOYDIR_LEFT_BIT		(1 << JOYDIR_LEFT)
#define JOYDIR_RIGHT_BIT	(1 << JOYDIR_RIGHT)

INLINE void copy_command_buffer(char logs)
{
	extern void convert_command_move(char *buf);
	int i, len;

	len = strlen((char *)command_buffer);

	if (len >= MAX_COMMAND_LOG - 1)
	{
		for (i = 0; i < MAX_COMMAND_LOG - 2; i++)
			command_buffer[i] = command_buffer[i + 2];
	}

	command_buffer[MAX_COMMAND_LOG - 2] = '\0';
	command_buffer[MAX_COMMAND_LOG - 1] = '\0';

	len = strlen((char *)command_buffer);

	command_buffer[len++] = '_';
	command_buffer[len++] = logs;

	convert_command_move((char *)command_buffer);
}

static void make_input_log(void)
{
	struct InputPort *port = Machine->input_ports;
	int player = show_input_player;

	if (port == 0)
		return;

	/* loop over all the joysticks for current input player */
	//if (player < max_input_players)
	{
		int joyindex=0;
		static int old_dir = -1;
		static int now_dir = 0;

		//for (joyindex = 0; joyindex < joyindex; joyindex++)
		{
			//struct DigitalJoystickInfo *info = &joystick_info[player][joyindex];

			//if (info->inuse)
			{
				/* set the status of neutral (assumed to be only in the defaults) */
				now_dir = 0;

				/* if this is a digital joystick type, apply 4-way rules */
				switch(mJoyCurrent[player*MAX_JOYSTICKS+joyindex])
				{
					case JOYDIR_DOWN_BIT:
						now_dir = 2;
						break;
					case JOYDIR_LEFT_BIT:
						now_dir = 4;
						break;
					case JOYDIR_RIGHT_BIT:
						now_dir = 6;
						break;
					case JOYDIR_UP_BIT:
						now_dir = 8;
						break;
				}

				/* if this is a digital joystick type, apply 8-way rules */
				//if (!(port->type &  IPF_4WAY))
				switch(mJoyCurrent[player*MAX_JOYSTICKS+joyindex])
				{
					case JOYDIR_DOWN_BIT | JOYDIR_LEFT_BIT:
						now_dir = 1;
						break;
					case JOYDIR_DOWN_BIT | JOYDIR_RIGHT_BIT:
						now_dir = 3;
						break;
					case JOYDIR_UP_BIT | JOYDIR_LEFT_BIT:
						now_dir = 7;
						break;
					case JOYDIR_UP_BIT | JOYDIR_RIGHT_BIT:
						now_dir = 9;
						break;
				}

				/* if we're not pressed, reset old_dir = -1 */
				if (now_dir == 0)
					old_dir = -1;
			}
		}

		/* if this is the first press, show input log */
		if (old_dir != now_dir)
		{
			if (now_dir != 0)
			{
				char colorbutton = '0';
				copy_command_buffer(colorbutton + now_dir);
				command_counter = 60;
				old_dir = now_dir;
			}
		}
	}
	/* End of loop over all the joysticks for player 1*/

	/* loop over all the buttons */
	if (normal_buttons > 0)
	{
		int is_neogeo = !stricmp(Machine->gamedrv->source_file+12, "neogeo.c");
		static UINT16 old_btn = 0;
		static UINT16 now_btn;
		int is_pressed = 0;

		now_btn = 0;

		for (port = Machine->input_ports; port->type != IPT_END; port++)
		{
			/* if this is current player, read input port */
			if ((port->type & IPF_PLAYERMASK) == player)
			{
				int i;

				/* if this is normal buttons type, apply usable buttons */
				for (i = 0; i < normal_buttons; i++)
					if (seq_pressed(input_port_seq(port)) && (port->type & ~IPF_MASK) == IPT_BUTTON1 + i)
						now_btn |= 1 << ((port->type & ~IPF_MASK) - IPT_BUTTON1);

#if 0
				/* if this is start button type (MESS only) */
				if (seq_pressed(input_port_seq(port)) && (port->type & ~IPF_MASK) == IPT_START1)
					now_btn |= 1 << normal_buttons;

				/* if this is select button type (MESS only) */
				if (seq_pressed(input_port_seq(port)) && (port->type & ~IPF_MASK) == IPT_SELECT1)
					now_btn |= 1 << (normal_buttons + 1);
#endif

#ifdef USE_CUSTOM_BUTTON
				/* if this is custon buttons type, apply usable buttons */
				if (seq_pressed(input_port_seq(port)) && (port->type & ~IPF_MASK) >= IPT_CUSTOM1 && (port->type & ~IPF_MASK) <= IPT_CUSTOM4)
					if (custom_button[player][(port->type & ~IPF_MASK) - IPT_CUSTOM1] != 0)
					{
						if (seq_pressed(input_port_seq(port)))
							now_btn |= custom_button[player][(port->type & ~IPF_MASK) - IPT_CUSTOM1];
					}

#endif /* USE_CUSTOM_BUTTON */

				/* if buttons press, leave is_pressed = 1 */
				if (now_btn != 0)
					is_pressed |= 1;
			}

			/* if this is start button type */
			if (seq_pressed(input_port_seq(port)) && (port->type & ~IPF_MASK) == (IPT_START1 + player))
			{
				now_btn |= 1 << normal_buttons;
				is_pressed |= 1;
			}
		}

		/* if we're not pressed, reset old_btn = 0 */
		if (!is_pressed)
			old_btn = 0;

		/* if this is the first press, show input log */
		if (old_btn != now_btn)
		{
			if (now_btn != 0)
			{
				/* if this is Neo-Geo games, than alphabetic button type */
				/*                           else numerical  button type */
				char colorbutton = is_neogeo ? 'A' : 'a';
				int n = 1;
				int i;

				for (i = 0; i < normal_buttons; i++, n <<= 1)
				{
					if ((now_btn & n) != 0 && (old_btn & n) == 0)
						copy_command_buffer(colorbutton + i);
				}

				/* if this is start button */
				if (now_btn & 1 << normal_buttons)
					copy_command_buffer('S');

				/* if this is select button (MESS only) */
				if (now_btn & 1 << (normal_buttons + 1))
					copy_command_buffer('s');

				command_counter = 60;
				old_btn = now_btn;
				now_btn = 0;
			}
		}
	}
	/* End of loop over all the buttons */
}
#endif /* USE_SHOW_INPUT_LOG */
