/***************************************************************************

  input.c

  OS dependent stuff (display handling, keyboard scan...)

 ***************************************************************************/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <assert.h>
#include <stdio.h>
#include "osdepend.h"
#include "win32.h"
#include "misc.h"
#include "Keyboard.h"
#include "Joystick.h"
#include "mouse.h"
#include "math.h"

/***************************************************************************
    Keyboard
 ***************************************************************************/

const struct KeyboardInfo *osd_get_key_list(void)
{
    return MAME32App.m_pKeyboard->get_key_list();
}

void osd_customize_inputport_defaults(struct ipd *defaults)
{
    MAME32App.m_pKeyboard->customize_inputport_defaults(defaults);
}

int osd_is_key_pressed(int keycode)
{
    return MAME32App.m_pKeyboard->is_key_pressed(keycode);
}

int osd_readkey_unicode(int flush)
{
    return MAME32App.m_pKeyboard->readkey_unicode(flush);
}

/***************************************************************************
    Joystick
 ***************************************************************************/

const struct JoystickInfo *osd_get_joy_list(void)
{
    return MAME32App.m_pJoystick->get_joy_list();
}

int osd_is_joy_pressed(int joycode)
{
    if (!MAME32App.m_bIsInitialized)
        return 0;

    if (MAME32App.m_pMouse != NULL)
    {
        switch (joycode)
        {
        case MOUSE_BUTTON(1):
            if (MAME32App.m_pMouse->trak_pressed(TRAK_FIRE1))
                return 1;
            break;

        case MOUSE_BUTTON(2):
            if (MAME32App.m_pMouse->trak_pressed(TRAK_FIRE2))
                return 1;
            break;

        case MOUSE_BUTTON(3):
            if (MAME32App.m_pMouse->trak_pressed(TRAK_FIRE3))
                return 1;
            break;

        case MOUSE_BUTTON(4):
            if (MAME32App.m_pMouse->trak_pressed(TRAK_FIRE4))
                return 1;
            break;

        case MOUSE_BUTTON(5):
            if (MAME32App.m_pMouse->trak_pressed(TRAK_FIRE5))
                return 1;
            break;
        }
    }

    return MAME32App.m_pJoystick->is_joy_pressed(joycode);
}

void osd_analogjoy_read(int player, int *analog_x, int *analog_y)
{
    MAME32App.m_pJoystick->analogjoy_read(player, analog_x, analog_y);
}

void osd_joystick_get_device_numbers(int *buf)
{
    MAME32App.m_pJoystick->get_device_numbers(buf);
}

void osd_joystick_set_device_numbers(int *buf)
{
    MAME32App.m_pJoystick->set_device_numbers(buf);
}

const char *osd_joystick_get_device_name(int number)
{
    return MAME32App.m_pJoystick->get_device_name(number);
}

/***************************************************************************
    Trakball
 ***************************************************************************/

void osd_trak_read(int player, int *deltax, int *deltay)
{
    MAME32App.m_pMouse->PollMouse();

    if (MAME32App.m_bUseAIMouse == TRUE)
    {
        MAME32App.m_pMouse->trak_read(player, deltax, deltay);
        return;
    }

    if (MAME32App.m_pJoystick == NULL)
    {
        *deltax = *deltay = 0;
        return;
    }

    *deltax = MAME32App.m_pJoystick->standard_analog_read(player, X_AXIS);
    *deltay = MAME32App.m_pJoystick->standard_analog_read(player, Y_AXIS);
}
