#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- setup.tcl --
#
### Package extension #########################################################
lappend auto_path ../../BWidget-1.7.0
package require BWidget

### Global variables. #########################################################
set RES ""
set cwd [pwd]
cd $tk_library
cd ../..
set WISHCMD [pwd]
cd $cwd
switch $tcl_platform(platform) {
    "windows" {
        regsub -all -- {/} $WISHCMD {\\} WISHCMD
        append WISHCMD "\\bin\\wish"
        regsub -all -- {\.} $tk_version {} wishver
        append WISHCMD $wishver ".exe"
        set BINDIR  "C:\\Program Files\\atedit"
        set CONFDIR $BINDIR
        set EXECMD  "atedit.bat"
    }
    default {
        append WISHCMD "/bin/wish" $tk_version
        set BINDIR  [file join /usr local lib atedit]
        set CONFDIR $BINDIR
        set EXECMD  "atedit"
    }
}
set CONFFILE "conf.txt"
set INFOFILE "instinfo.tcl"
set PROGRAMS {"../BWidget-1.7.0" "icon" "messages" \
              "edit_menu.tcl" "file_menu.tcl" "file_utils.tcl" "global.tcl"  \
              "help_menu.tcl" "instinfo.tcl" "king_gui.tcl" "king_utils.tcl" \
              "main.tcl" "mark.tcl" "tools_menu.tcl" "option_menu.tcl"       \
              "startup.tcl"}
lappend PROGRAMS $EXECMD
set CMDLIST ""
set LANG ""
set LANGLIST {" English" " Japanese" " Italiano"}

source ./messages_en.tcl

### Dialog settings. ##########################################################
#
wm title . $M001
wm protocol . WM_DELETE_WINDOW {set RES "cancel"}
wm resizable . 0 0

### Functions #################################################################
#
proc delete_install_dialog {} {
    global RES

    set RES "cancel"
}

proc install_dialog {} {
    global tcl_platform
    global RES
    global M001 M002 M003 M004 M005 M006 M007 M008 M009 M010 M027 WM027
    global WISHCMD BINDIR CONFDIR CONFFILE LANG LANGLIST

    label .title -text $M001
    pack .title -padx 2 -pady 2
    frame .f -bd 2 -relief groove
    pack .f -padx 4 -pady 4
       frame .f.f1
       pack .f.f1 -anchor w -fill x -expand 1 -padx 2 -pady 2
         label .f.f1.l1 -text $M002
         pack .f.f1.l1 -side left -anchor w
       frame .f.f2
       pack .f.f2 -anchor w -fill x -expand 1 -padx 2
         entry .f.f2.e1 -width 40
         .f.f2.e1 insert 0 $WISHCMD
         pack .f.f2.e1 -side left -anchor w
         button .f.f2.b1 -text $M003 -command {
             set tmp [file nativename [tk_getOpenFile -title $M004 \
                                        -initialdir [file dirname $WISHCMD]]]
             if {$tmp != ""} {
                 .f.f2.e1 delete 0 end
                 .f.f2.e1 insert 0 $tmp
             }
         }
         pack .f.f2.b1 -side left
       frame .f.f3
       pack .f.f3 -anchor w -fill x -expand 1 -padx 2 -pady 2
         label .f.f3.l1 -text $M005
         pack .f.f3.l1 -side left -anchor w
       frame .f.f4
       pack .f.f4 -anchor w -fill x -expand 1 -padx 2
         entry .f.f4.e1 -width 40
         .f.f4.e1 insert 0 $BINDIR
         pack .f.f4.e1 -side left -anchor w
         button .f.f4.b1 -text $M003 -command {
             if [file isdirectory $BINDIR] {
                 set tmp \
                     [file nativename [tk_chooseDirectory -title $M006 \
                                                          -initialdir $BINDIR]]
             } else {
                 set tmp \
                     [file nativename [tk_chooseDirectory -title $M006 \
                                           -initialdir [file dirname $BINDIR]]]
             }
             if {$tmp != ""} {
                 .f.f4.e1 delete 0 end
                 .f.f4.e1 insert 0 $tmp
             }
         }
         pack .f.f4.b1 -side left
       if {$tcl_platform(platform) != "unix"} {
           frame .f.f5
           pack .f.f5 -anchor w -fill x -expand 1 -padx 2 -pady 2
             label .f.f5.l1 -text $M007
             pack .f.f5.l1 -side left -anchor w
           frame .f.f6
           pack .f.f6 -anchor w -fill x -expand 1 -padx 2
             entry .f.f6.e1 -width 40
             .f.f6.e1 insert 0 $CONFDIR
             pack .f.f6.e1 -side left -anchor w
             button .f.f6.b1 -text $M003 -command {
                 if [file isdirectory $CONFDIR] {
                     set tmp \
                       [file nativename [tk_chooseDirectory -title $M008 \
                                                        -initialdir $CONFDIR]]
                 } else {
                     set tmp \
                       [file nativename [tk_chooseDirectory -title $M008 \
                                          -initialdir [file dirname $CONFDIR]]]
                 }
                 if {$tmp != ""} {
                     .f.f6.e1 delete 0 end
                     .f.f6.e1 insert 0 $tmp
                 }
             }
             pack .f.f6.b1 -side left
       }
       frame .f.f7
       pack .f.f7 -anchor w -fill x -expand 1 -padx 2 -pady 2
       label .f.f7.l1 -text $M027 -width $WM027 -anchor w
       pack .f.f7.l1 -expand 0 -side left -anchor w
       frame .f.f8
       pack .f.f8 -anchor w -fill x -expand 1 -padx 2
       ComboBox .f.f8.c -values $LANGLIST
       .f.f8.c setvalue first
       pack .f.f8.c -expand 1 -fill x -pady 2

       frame .f2 -bd 2 -relief groove
       pack .f2 -fill x -expand 1 -padx 4 -pady 2
         button .f2.b2 -text $M010 -command {set RES "cancel"}
         bind .f2.b2 <Return> {
             set RES "cancel"
         }
         pack .f2.b2 -side right
         button .f2.b1 -text $M009 -command {set RES "ok"}
         bind .f2.b1 <Return> {
             set RES "ok"
         }
         pack .f2.b1 -side right

    return
}

proc args_check {} {
    global tcl_platform
    global WISHCMD BINDIR CONFDIR LANG LANGLIST
    global M011 M012 M013 M014 M015

    set WISHCMD [.f.f2.e1 get]
    if ![file executable $WISHCMD] {
        tk_messageBox -type ok -title $M011 -message "$M012 $WISHCMD $M013"
        return 0
    }
    set BINDIR [.f.f4.e1 get]
    if {![file isdirectory $BINDIR] && ![file isfile $BINDIR]} {
        if {[tk_messageBox -type yesno -title $M011 \
                           -message "$BINDIR $M014"   ] == "yes"} {
        } else {
            return 0
        }
    }
    if {$tcl_platform(platform) != "unix"} {
        set CONFDIR [.f.f6.e1 get]
        if {![file isdirectory $CONFDIR] && ![file isfile $CONFDIR]} {
            if {$CONFDIR != $BINDIR} {
                if {[tk_messageBox -type yesno -title $M011 \
                               -message "$CONFDIR $M014"   ] == "yes"} {
                } else {
                    return 0
                }
            }
        }
    } else {
        set CONFDIR $BINDIR
    }
    set LANG [lindex $LANGLIST [.f.f8.c getvalue]]
    switch $LANG {
        " Japanese" { set LANG "ja"}
		" Italiano" { set LANG "it"}
        default     { set LANG "en"}
    }

    return 1
}

### main routine. #############################################################
install_dialog
while 1 {
    vwait RES
    if {$RES == "cancel"} {
        if {[tk_messageBox -type yesno -title $M017 -message $M018] == "yes"} {
            exit
        }
        continue
    }

    if [args_check] {
        if {![file isdirectory $BINDIR] && ![file isfile $BINDIR]} {
            if [catch {file mkdir $BINDIR}] {
                tk_messageBox -type ok -title $M011 \
                  -message "$BINDIR $M024 \n $errorInfo"
                exit
            }
        }
        if {$tcl_platform(platform) != "unix"} {
            if {![file isdirectory $CONFDIR] && ![file isfile $CONFDIR]} {
                if [catch {file mkdir $CONFDIR}] {
                    tk_messageBox -type ok -title $M011 \
                      -message "$CONFDIR $M024 \n $errorInfo"
                    exit
                }
            }
        } else {
            set CONFDIR $BINDIR
        }
        switch $tcl_platform(platform) {
            "unix" {
                file attributes $CONFDIR -permissions rwxr-xr-x
            }
        }
        set conf [file join "../../atedit"  $INFOFILE]
        if [catch {open $conf w} fd] {
            tk_messageBox -type ok -title $M011 -message $M015
            exit
        }
        foreach i {WISHCMD BINDIR CONFDIR CONFFILE LANG} {
            set w ""
            switch $i {
                "WISHCMD" {
                    append w "set WISHCMD "
                    append w {"}
                    if {$tcl_platform(platform) == "windows"} {
                        regsub -all -- {\\} $WISHCMD {\\\\} WISHCMD
                    }
                    append w $WISHCMD
                    append w {"}
                }
                "BINDIR" {
                    append w "set BINDIR "
                    append w {"}
                    if {$tcl_platform(platform) == "windows"} {
                        regsub -all -- {\\} $BINDIR {\\\\} BINDIR
                    }
                    append w $BINDIR
                    append w {"}
                }
                "CONFDIR" {
                    append w "set CONFDIR "
                    append w {"}
                    if {$tcl_platform(platform) == "windows"} {
                        regsub -all -- {\\} $CONFDIR {\\\\} CONFDIR
                    }
                    append w $CONFDIR
                    append w {"}
                }
                "CONFFILE" {
                    append w "set CONFFILE "
                    append w {"}
                    append w $CONFFILE
                    append w {"}
                }
                "LANG" {
                    append w "set LANG "
                    append w $LANG
                }
            }

            if [catch {puts $fd $w}] {
                tk_messageBox -type ok -title $M011 -message $M016
                close $fd
                exit
            }
        }
        close $fd

        ### Create the file "startup.tcl" #####################################
        set CMDLIST {}
        set f1   [file join "../../atedit" "gpl2_template.txt"]
        set conf [file join "../../atedit" "startup.tcl"]
        if [catch {file delete -force $conf}] {
            tk_messageBox -type ok -title $M011 \
                          -message "$M025 \n $errorInfo"
            exit
        }
        if [catch {file copy -force $f1 $conf}] {
            tk_messageBox -type ok -title $M011 -message "$M026 \n $errorInfo"
            exit
        }
        if [catch {open $conf a} fd] {
            tk_messageBox -type ok -title $M011 -message "$M026 \n $errorInfo"
            exit
        }
        switch $tcl_platform(platform) {
            "windows" {
                set w1 {source "}
                regsub -all -- {\\\\} $BINDIR {/} w0
                append w1 $w0
                set w2 $w1
                append w1 {/instinfo.tcl"}
                append w2 {/main.tcl"}
                lappend CMDLIST "$w1"
                lappend CMDLIST "$w2"
            }
            default {
                set w1 {source "}
                append w1 $BINDIR
                set w2 $w1
                append w1 {/instinfo.tcl"}
                append w2 {/main.tcl"}
                lappend CMDLIST "$w1"
                lappend CMDLIST "$w2"
            }
        }
        foreach w $CMDLIST {
            if [catch {puts $fd $w}] {
                tk_messageBox -type ok -title $M011 -message $M016
                close $fd
                return -1
            }
        }
        close $fd

        ### Create the file "atedit.bat". #####################################
        set CMDLIST {}
        set conf [file join "../../atedit"  $EXECMD]
        if [catch {open $conf w} fd] {
            tk_messageBox -type ok -title $M011 -message $M026
            exit
        }
        switch $tcl_platform(platform) {
            "windows" {
                regsub -all -- {\\\\} $WISHCMD {\\} w0
                set w1 {"}
                append w1 "$w0"
                append w1 {" }
                regsub -all -- {\\\\} $BINDIR {\\} w0
                append w1 {"}
                append w1 "$w0"
                append w1 "\\"
                append w1 {startup.tcl" -dummy %*}
                lappend CMDLIST "$w1"
            }
            default {
                set w1 "#!/bin/sh"
                lappend CMDLIST "$w1"
                set w2 "'$WISHCMD' "
                append w2 "'$BINDIR"
                append w2 "/" 
                append w2 "startup.tcl' -dummy \"$@\""
                lappend CMDLIST "$w2"
            }
        }
        foreach w $CMDLIST {
            if [catch {puts $fd $w}] {
                tk_messageBox -type ok -title $M011 -message $M016
                close $fd
                return -1
            }
        }
        close $fd
        switch $tcl_platform(platform) {
            "unix" {
                file attributes $conf -permissions rwxr-xr-x
            }
        }

        ### Copy the script files to $BINDIR. #################################
        set d "../../atedit"
        set cnt 1
        ProgressDlg .pd -title $M022 -maximum [llength PROGRAMS] \
                        -variable cnt -stop $M023 \
                        -textvariable fl -command {
                            if {[tk_messageBox -type yesno -title $M017 \
                                -message $M018] == "yes"} {
                                exit
                            }
                        }
        foreach fl $PROGRAMS {
            if [regexp "^../" $fl] {
                regsub -all -- {^\.\./} $fl {} dfl
            } else {
                set dfl $fl
            }
            if [catch {file delete -force [file join $BINDIR $dfl]}] {
                tk_messageBox -type ok -title $M011 \
                              -message "$M025 \n $errorInfo"
                exit
            }
            if [catch {file copy -force [file join $d $fl] $BINDIR}] {
                tk_messageBox -type ok -title $M011 \
                              -message "$M019 \n $errorInfo"
                exit
            }
            incr cnt
        }
        tk_messageBox -type ok -title $M020 -message $M021
        exit
    }
}


