#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- messages_it.tcl --
#
### Messages ####################################################################
# Every Message ID has 5 digits.
#
# M      x                  999
# ^      ^                  ^
# fixed  Kind of message    Sequence number
#          0 - Menu
#          1 - Barra degli Strumenti(Help text)
#          2 - Titolo
#          3 - MessageBox's title
#          4 - MessageBox's body
#          5 - Etichetta
#          9 - Altro
#
#--- Menu ---------------------------------------------------------------------
set M0100 "File(F)"
set UM0100 5
set M0110 "Nuovo(N)"
set UM0110 6
set M0120 "Apri(O)           Ctrl-O"
set UM0120 5
set M0130 "Salva(S)          Ctrl-S"
set UM0130 6
set M0140 "Salva come..(A)"
set UM0140 13
set M0150 "Stampa(P)"
set UM0150 7
set M0160 "Esci(Q)"
set UM0160 5
set M0170 "Open at cursor(I)"
set UM0170 15
set M0180 "Chiudi e Apri"

set M0200 "Modifica(E)"
set UM0200 9
set M0210 "Annula ulltima operazione(U) Ctrl-Z"
set UM0210 26
set M0220 "Taglia(X)                    Ctrl-X"
set UM0220 7
set M0230 "Copia(C)                     Ctrl-C" 
set UM0230 6
set M0240 "Incolla(P)                   Ctrl-V"
set UM0240 8
set M0250 "Trova(F)                     Ctrl-F"
set UM0250 6
set M0260 "Sostituisci(R)               Ctrl-R"
set UM0260 12
set M0270 "Seleziona Tutto(A)           Ctrl-A"
set UM0270 16
set M0280 "Vai alla linea(G)            Ctrl-G"
set UM0280 15

set M0300 "Traduci(T)"
set UM0300 9
set M0310 "Giapponese --> Inglese(J)"
set UM0310 23
set M0320 "Inglese --> Giapponese(E)"
set UM0320 23
set M0330 "Dizionario(D)"
set UM0330 11

set M0350 "Strumenti(I)"
set UM0350 10
set M0360 "Data"
set M0370 "Ora"

set M0400 "Opzioni(O)"
set UM0400 8
set M0410 "Configura(O)"
set UM0410 10

set M0500 "Aiuto"
set UM0500 6
set M0510 "Aiuto(A)"
set UM0510 6

#--- Toolbar ------------------------------------------------------------------
set M1001 "Nuovo"
set M1002 "Apri"
set M1003 "Salva"
set M1004 "Stampa"
set M1005 "Annula Ultima Operazione"
set M1006 "Taglia"
set M1007 "Copia"
set M1008 "Incolla"
set M1009 "Trova"
set M1010 "Trova successivo <F3>"
set M1011 "Trova precedente <Shift-F3>"
set M1012 "Segna"
set M1013 "Vai a selezione"

#--- Titlebar -----------------------------------------------------------------
set M2001 "(Changed)"

#--- MessageBox's title -------------------------------------------------------
set M3001 "Errore"
set M3002 "Attenzione"
set M3003 "Apri"
set M3004 "Salva"
set M3005 "Informazione"
set M3006 "Trova"
set M3007 "Sostituisci"
set M3008 "Vai alla linea"
set M3009 "Opzioni"
set M3010 "Risultati"
set M3011 "Colori"
set M3012 "Caratteri"
set M3013 "Estensione"
set M3014 "Aiuto A.T.Edit"
set M3015 "Dizionario"
set M3016 "Chiudi e Apri"

#--- MessageBox's body --------------------------------------------------------
set M4000 "Versione Tcl/Tk installata da aggiornare.\n \
(Versione installata ==> $tk_version) \n\n \
Scarica l'ultima versione da <http://www.scriptics.com/> e installala."
set M4001 "Il file ? stato modificato. Salvare il file ?"
set M4002 "? cambiato. Salvare il file ?"
set M4003 "Non esiste"
set M4004 "? una cartella"
set M4005 ": Errore in lettura "
set M4006 ": Errore in scrittura "
set M4007 "Impossibile aprire il file"
set M4008 "Errore durante la scrittura su file"
set M4009 "Non trovato"
set M4010 "Espressione regolare non corretta"
set M4011 "Vocaboli sostituiti"
set M4012 "Impssibile aprire i file di configurazione"
set M4013 "Errore durante la scrittura dei file di configurazione"
set M4014 "File temporaneo di traduzione non creato"
set M4015 "File temporaneo di stampa non creato"
set M4016 "Avvio A.T.Edit fallito: Un altro file con lo stesso nome ? presente nella cartella"
set M4017 "Impossibile creare la cartella di lavoro"
set M4018 "Errore durante la stampa\n"
set M4019 "Errore durante la traduzione\n"
set M4020 "Traducendo..."
set M4021 "Completato"

#--- Label --------------------------------------------------------------------
set M5001  "Trova   : "
set M5002  "Espressione regolare"
set M5003  "Distinzione tra maiuscolo e minuscolo"
set M5004  "Avanti"
set M5005  "Indietro"
set WM5005 11
set M5006  "Chiudi"
set M5007  "Linea: "
set M5008  "   OK   "
set M5009  " Cancella "
set M5010  "Larghezza : "
set M5011  "Altezza: "
set M5012  "Carattere: "
set M5013  "Seleziona"
set WM5013 12
set M5014  "Solo intervallo selezionato"
set M5015  "Sostituisci: "
set M5016  "Conferma prima di sostituire"
set M5017  "Sostituisci tutto"
set M5018  "Sostituisci"
set M5019  "Salta"
set M5020  "Sostituisci + successico"
set M5021  "In primo piano :"
set M5022  "In secondo piano :"
set M5023  "Evidenzia  :"
set M5024  "Aspetto"
set M5025  "ABCDE abcde 12345"
set M5026  "Estensione"
set M5027  "Comando"
set M5028  "Aggiungi"
set M5029  "Modifica"
set M5030  "Elimina"
set M5031  "Sposta verso l'alto"
set M5032  "Sposta verso il basso"
set WM5028 10
set M5033  " Stampa "
set M5034  " Traduzione "
set M5035  "Giapponese --> Inglese: "
set M5036  "Inglese --> Giapponese: "
set M5037  "Look up            : "
set WM5035 26
set M5038  "Nome"
set WM5038 8
set M5039  "Pattern"
set M5040  "ex) *.*, *.txt"
set M5041  "Tab: "
set M5042  "Lingua: "
set WM5042 10
set M5043  "Look up"
set WM5043 12
set M5044  "Vai a selezione"
set M5055  "Muovi"
set M5056  "Giapponese --> Inglese"
set M5057  "Inglese --> Giapponese"
set M5058  "Look up"
set M5059  "Cursore alla linea:"

#--- Others -------------------------------------------------------------------
set M9001 "Senza Titolo"
set M9002 "A.T.Edit - "
set M9003 "A.T.Edit version 1.03"
set M9004 "(C) 2004 Shinji Morino"
set M9005 "<http://sourceforge.net/projects/atedit/>"
set M9006 "<peace24@blue.email.ne.jp>"

