#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- king_utils.tcl --
#
### Functions to use king #####################################################
#
# @dict_lookup
#
proc dict_lookup {word} {
    global USR_CNF_KING_DICT

    .dict.base.bar.word delete 0 end
    .dict.base.bar.word insert 0 $word
    .dict.base.bar.word icursor end
    .dict.base.text configure -state normal
    .dict.base.text delete 0.0 end
    regsub -all -- {%s} $USR_CNF_KING_DICT $word com
    switch [llength $com] {
        "1" {
            set str [exec [lindex $com 0]]
        }
        "2" {
            set str [exec [lindex $com 0] [lindex $com 1]]
        }
        "3" {
            set str [exec [lindex $com 0] [lindex $com 1] [lindex $com 2]]
        }
        "4" {
            set str [exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                          [lindex $com 3]                                   ]
        }
        "5" {
            set str [exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                          [lindex $com 3] [lindex $com 4]                   ]
        }
        "6" {
            set str [exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                          [lindex $com 3] [lindex $com 4] [lindex $com 5]   ]
        }
        "7" {
            set str [exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                          [lindex $com 3] [lindex $com 4] [lindex $com 5] \
                          [lindex $com 6]                                   ]
        }
        "8" {
            set str [exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                          [lindex $com 3] [lindex $com 4] [lindex $com 5] \
                          [lindex $com 6] [lindex $com 7]                   ]
        }
        "9" {
            set str [exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                          [lindex $com 3] [lindex $com 4] [lindex $com 5] \
                          [lindex $com 6] [lindex $com 7] [lindex $com 8]   ]
        }
        "10" {
            set str [exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                          [lindex $com 3] [lindex $com 4] [lindex $com 5] \
                          [lindex $com 6] [lindex $com 7] [lindex $com 8] \
                          [lindex $com 9]                                   ]
        }
    }
    .dict.base.text insert end $str
    .dict.base.text mark set insert end
    .dict.base.text configure -state disabled
}

#
# @cb_trans_dict
#
proc cb_trans_dict {src} {
    wm state .dict normal
    raise .dict

    if {$src == "toolbar"} {
        if {[llength [.base.textarea tag ranges sel]] > 0} {
            set si [lindex [.base.textarea tag ranges sel] 0]
            set ei [lindex [.base.textarea tag ranges sel] 1]
            dict_lookup [.base.textarea get $si $ei]
        } else {
            .dict.base.bar.word delete 0 end
            .dict.base.text configure -state normal
            .dict.base.text delete 0.0 end
            .dict.base.text configure -state disabled
        }
    } else {
        set wd [.dict.base.bar.word get]
        if {$wd != ""} {
            dict_lookup $wd
        }
    }
}

#
# @cb_trans
#
proc cb_trans {td} {
    global tcl_platform
    global WISHCMD BINDIR CONFDIR
    global USR_CNF_T_WIDTH USR_CNF_T_HEIGHT USR_CNF_T_TAB USR_CNF_LANG
    global USR_CNF_KING_EJ USR_CNF_KING_JE
    global TEMP_CWD
    global M3001 M4014 M4019 M4020 M4021

    for {set i 1} {$i < 99} {incr i} {
        set f0 "ORG"
        set f1 [file join $CONFDIR [append f0 $i]]
        if [file exists $f1] {
            set f0 ""
        } else {
            break
        }
    }
    if {$f1 == ""} {
        tk_messageBox -type ok -title $M3001 -message $M4014
        return
    }
    for {set i 1} {$i < 99} {incr i} {
        set f0 "TRANS"
        set f2 [file join $CONFDIR [append f0 $i]]
        if [file exists $f2] {
            set f0 ""
        } else {
            break
        }
    }
    if {$f2 == ""} {
        tk_messageBox -type ok -title $M3001 -message $M4014
        return
    }

    if {[llength [.base.textarea tag ranges sel]] > 0} {
        set si [lindex [.base.textarea tag ranges sel] 0]
        set ei [lindex [.base.textarea tag ranges sel] 1]
    } else {
        set si "1.0"
        set ei "end"
    }

    if [catch {set fd [open $f1 w]} em] {
        tk_messageBox -type ok -title $M3001 -message "$M4014 \n $em"
        return
    } else {
        set str [.base.textarea get $si $ei]
        if [catch {puts -nonewline $fd $str} em] {
        tk_messageBox -type ok -title $M3001 -message "$M4014 \n $em"
            close $fd
            return
        } 
        close $fd
    }

    .sbar.s2 configure -text $M4020
    # Should need delay time to display $M4020.
    after 5 {
        set RES "ok"
    }
    vwait RES

    if {$td == "etoj"} {
        regsub -all -- {%s} $USR_CNF_KING_EJ "$f1" com
    } else {
        regsub -all -- {%s} $USR_CNF_KING_JE "$f1" com
    }
    switch [llength [split $com " "]] {
        "1" {
            if [catch {
                    exec [lindex $com 0] > $f2
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4019 -- $errorInfo"
            }
        }
        "2" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] > $f2
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4019 -- $errorInfo"
            }
        }
        "3" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2]  > $f2
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4019 -- $errorInfo"
            }
        }
        "4" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3]  > $f2
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4019 -- $errorInfo"
            }
        }
        "5" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] [lindex $com 4] > $f2
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4019 -- $errorInfo"
            }
        }
        "6" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] [lindex $com 4] [lindex $com 5] > $f2
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4019 -- $errorInfo"
            }
        }
        "7" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] [lindex $com 4] [lindex $com 5] \
                         [lindex $com 6] > $f2
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4019 -- $errorInfo"
            }
        }
        "8" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] [lindex $com 4] [lindex $com 5] \
                         [lindex $com 6] [lindex $com 7] > $f2
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4019 -- $errorInfo"
            }
        }
        "9" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] [lindex $com 4] [lindex $com 5] \
                         [lindex $com 6] [lindex $com 7] [lindex $com 8] > $f2
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4019 -- $errorInfo"
            }
        }
        "10" {
            if [catch {
                    exec [lindex $com 0] [lindex $com 1] [lindex $com 2] \
                         [lindex $com 3] [lindex $com 4] [lindex $com 5] \
                         [lindex $com 6] [lindex $com 7] [lindex $com 8] \
                         [lindex $com 9] > $f2
                }] {
                tk_messageBox -type ok -icon error -title $M3001 \
                              -message "$M4019 -- $errorInfo"
            }
        }
    }
    file delete -force $f1
    set str1 $WISHCMD
    set str2 [file join $BINDIR "startup.tcl"]
    exec $str1 $str2 -trans $f2 $TEMP_CWD \
                     -width  $USR_CNF_T_WIDTH  \
                     -height $USR_CNF_T_HEIGHT \
                     -tab    $USR_CNF_T_TAB    \
                     -lang   $USR_CNF_LANG     \
                     -king &

    .sbar.s2 configure -text $M4021
}

#
# @make_kingbar
#
proc make_kingbar {} {
    global BINDIR
    global M5056 M5057 M5058

    .toolbar.kingbar.toolbar add -image [xpm-to-image \
                                          [file join $BINDIR icon jtoe.xpm]] \
                                 -highlightthickness 0 -takefocus 0 \
                                 -relief link -borderwidth 1        \
                                 -padx 1 -pady 1 -helptext $M5056 \
                                 -command {cb_trans "jtoe"}

    .toolbar.kingbar.toolbar add -image [xpm-to-image \
                                          [file join $BINDIR icon etoj.xpm]] \
                                 -highlightthickness 0 -takefocus 0 \
                                 -relief link -borderwidth 1        \
                                 -helptext $M5057                   \
                                 -command {cb_trans "etoj"}

    .toolbar.kingbar.toolbar add -image [xpm-to-image \
                                          [file join $BINDIR icon dict.xpm]] \
                                 -highlightthickness 0 -takefocus 0 \
                                 -relief link -borderwidth 1        \
                                 -padx 1 -pady 1 -helptext $M5058   \
                                 -command {cb_trans_dict "toolbar"}

    pack .toolbar.kingbar -side left -anchor w -fill x -padx 2 -pady 1
    pack .toolbar.kingbar.toolbar    -side left -anchor w
}


