#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- king_gui.tcl --
#
### GUI components to use king. ###############################################
frame      .toolbar.kingbar
  ButtonBox  .toolbar.kingbar.toolbar -spacing 0 -padx 1 -pady 1

#--- for dictionary dialog ----------------------------------------------------
toplevel   .dict
wm transient .dict
wm protocol  .dict WM_DELETE_WINDOW {wm withdraw .dict}
wm title     .dict $M3015

frame    .dict.base
frame    .dict.base.bar
  Entry    .dict.base.bar.word -width 15
    bind .dict.base.bar.word <Return> {
        cb_trans_dict ""
    }

  button   .dict.base.bar.btn  -text $M5043 -width $WM5043  \
                               -font $CST_BTN_FONT          \
                               -command {cb_trans_dict ""}
    bind .dict.base.bar.btn <Return> {
        cb_trans_dict ""
    }

text     .dict.base.text -width  40 \
                         -height 15 \
                         -fg $USR_CNF_T_FG -bg $USR_CNF_T_BG -bd $T_BD \
                         -font $USR_CNF_T_FONT                         \
                         -yscrollcommand {.dict.base.y set}            \
                         -exportselection true
.dict.base.text tag configure sel -background $USR_CNF_HIGHLIGHT
scrollbar  .dict.base.y -command {.dict.base.text yview} -orient vertical

pack .dict.base -fill both -expand 1 -padx 1 -pady 1
pack .dict.base.bar -fill x -padx 2 -pady 2
pack .dict.base.bar.word -fill x -expand 1 -side left
pack .dict.base.bar.btn  -padx 1 -side left

pack .dict.base.text -side left -fill both -expand 1
pack .dict.base.y    -side right -fill y

wm withdraw .dict

