#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- messages_en.tcl --
#
### Messages ####################################################################
# Every Message ID has 5 digits.
#
# M      x                  999
# ^      ^                  ^
# fixed  Kind of message    Sequence number
#          0 - Menu
#          1 - Toolbar(Help text)
#          2 - Title bar
#          3 - MessageBox's title
#          4 - MessageBox's body
#          5 - Label
#          9 - Others
#
#--- Menu ---------------------------------------------------------------------
set M0100 "File(F)"
set UM0100 5
set M0110 "New(N)"
set UM0110 4
set M0120 "Open(O)"
set UM0120 5
set M0130 "Save(S)"
set UM0130 5
set M0140 "Save As..(A)"
set UM0140 10
set M0150 "Print(P)"
set UM0150 6
set M0160 "Quit(Q)"
set UM0160 5
set M0170 "Open at cursor(I)"
set UM0170 15
set M0180 "Close and Open"

set M0200 "Edit(E)"
set UM0200 5
set M0210 "Undo(U)"
set UM0210 5
set M0220 "Cut(X)"
set UM0220 4
set M0230 "Copy(C)"
set UM0230 5
set M0240 "Paste(P)"
set UM0240 6
set M0250 "Find(F)"
set UM0250 5
set M0260 "Replace(R)"
set UM0260 8
set M0270 "Select All(A)"
set UM0270 11
set M0280 "Goto line(G)"
set UM0280 10

set M0300 "Translation(T)"
set UM0300 12
set M0310 "Japanese to English(J)"
set UM0310 20
set M0320 "English to Japanese(E)"
set UM0320 20
set M0330 "Dictionary(D)"
set UM0330 11

set M0400 "Option(O)"
set UM0400 7
set M0410 "Option(O)"
set UM0410 7

set M0500 "Help(H)"
set UM0500 5
set M0510 "About(A)"
set UM0510 6

#--- Toolbar ------------------------------------------------------------------
set M1001 "New"
set M1002 "Open"
set M1003 "Save"
set M1004 "Print"
set M1005 "Undo"
set M1006 "Cut"
set M1007 "Copy"
set M1008 "Paste"
set M1009 "Find"
set M1010 "Find forwards"
set M1011 "Find backwards"
set M1012 "Mark"
set M1013 "Goto mark"

#--- Titlebar -----------------------------------------------------------------
set M2001 "(Changed)"

#--- MessageBox's title -------------------------------------------------------
set M3001 "Error"
set M3002 "Warning"
set M3003 "Open"
set M3004 "Save"
set M3005 "Information"
set M3006 "Find"
set M3007 "Replace"
set M3008 "Goto line"
set M3009 "Option"
set M3010 "Results"
set M3011 "Color"
set M3012 "Font"
set M3013 "Extension"
set M3014 "About A.T.Edit"
set M3015 "Dictionary"
set M3016 "Close and Open"

#--- MessageBox's body --------------------------------------------------------
set M4000 "Installed Tcl/Tk is older version.\n \
(installed version ==> $tk_version) \n\n \
Please get the latest version from <http://www.scriptics.com/> and install."
set M4001 "This file is changed. Save this file ?"
set M4002 "is changed. Save this file ?"
set M4003 "doesn't exist."
set M4004 "is directory."
set M4005 ": Permission error. (read) "
set M4006 ": Permission error. (write)"
set M4007 "Can't open file."
set M4008 "Error was occuered while writing the file."
set M4009 "Not found."
set M4010 "Regular expression is incorrect."
set M4011 "words replaced."
set M4012 "Can't open the configuration file."
set M4013 "An error occurred during writing configuration file."
set M4014 "The temporary file for translation has not been created."
set M4015 "The temporary file for printing has not been created."
set M4016 "Starting A.T.Edit was failed: There is a same named file as working directory."
set M4017 "Can't create the working directory."
set M4018 "An error occurred during printing.\n"
set M4019 "An error occurred during translation.\n"
set M4020 "Translating..."
set M4021 "Completed."

#--- Label --------------------------------------------------------------------
set M5001  "Find   : "
set M5002  "Regular expression"
set M5003  "Distinguish capital letter from small letter."
set M5004  "Forwards"
set M5005  "Backwards"
set WM5005 11
set M5006  "Close"
set M5007  "Line: "
set M5008  "   OK   "
set M5009  " Cancel "
set M5010  "Width : "
set M5011  "Height: "
set M5012  "Font: "
set M5013  "Select"
set WM5013 8
set M5014  "Selected range only"
set M5015  "Replace: "
set M5016  "Confirm before replace"
set M5017  "Replace all"
set M5018  "Replace"
set M5019  "Skip"
set M5020  "Replace + next"
set M5021  "Foreground :"
set M5022  "Background :"
set M5023  "Highlight  :"
set M5024  "Appearance"
set M5025  "ABCDE abcde 12345"
set M5026  "Extension"
set M5027  "Command"
set M5028  "Add"
set M5029  "Edit"
set M5030  "Delete"
set M5031  "Up"
set M5032  "Down"
set WM5028 6
set M5033  " Printing "
set M5034  " Translation "
set M5035  "Japanese to English: "
set M5036  "English to Japanese: "
set M5037  "Look up            : "
set WM5035 24
set M5038  "Name"
set WM5038 8
set M5039  "Pattern"
set M5040  "ex) *.*, *.txt"
set M5041  "Tab: "
set M5042  "Language: "
set WM5042 10
set M5043  "Look up"
set WM5043 12
set M5044  "Goto mark"
set M5055  "Move"
set M5056  "Japanese to English"
set M5057  "English to Japanese"
set M5058  "Look up"
set M5059  "Cursor line:"

#--- Others -------------------------------------------------------------------
set M9001 "Untitled"
set M9002 "A.T.Edit - "
set M9003 "A.T.Edit version 1.02"
set M9004 "(C) 2004 Shinji Morino"
set M9005 "<http://sourceforge.net/projects/atedit/>"
set M9006 "<peace24@blue.email.ne.jp>"

