#
# A.T.Edit -- Another Tcl/Tk based text editor
# Copyright (C) 2004 Shinji Moiino
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
#-- file_utils.tcl --
#
### Utility function. #########################################################
#
#------------------------------------------------------------------------------
# @file_can_read
#
#  success : return 0
#  failed  : return error code [-9 - -1]
#------------------------------------------------------------------------------
proc file_can_read {fn dg} {
    global M3001 M4003 M4004 M4005
    if {$fn == ""} { return -1}

    if {$fn != ""} {
        if ![file exists $fn] {
            if {$dg == 1} {
                tk_messageBox -type ok -title $M3001 -icon error \
                    -message "$fn $M4003"
            }
            return -2
        }
        if ![file isfile $fn] {
            tk_messageBox -type ok -title $M3001 -icon error \
                -message "$fn $M4004"
            return -3
        }
        if ![file readable $fn] {
            tk_messageBox -type ok -title $M3001 -icon error \
                -message "$fn $M4005"
            return -4
        }
    }

    return 0
}

#------------------------------------------------------------------------------
# @file_can_write
#
#  success : return 0
#  failed  : return error code [-9 - -1]
#------------------------------------------------------------------------------
proc file_can_write {fn chk_exist} {
    global M4003 M4004 M4006

    if {$fn == ""} { return 0}

    if {$fn != ""} {
        if [file exists $fn] {
            if ![file isfile $fn] {
                tk_messageBox -type ok -title $M3001 -icon error \
                    -message "$fn $M4004"
                return -3
            }
            if ![file writable $fn] {
                tk_messageBox -type ok -title $M3001 -icon error \
                    -message "$fn $M4006"
                return -4
            }
        } else {
            if {$chk_exist == 1} {
                if ![file exists $fn] {
                    tk_messageBox -type ok -title $M3001 -icon error \
                        -message "$fn $M4003"
                    return -2
                }
            }

        }
    }

    return 0
}

#------------------------------------------------------------------------------
# @open_file
#
#  success : return file descripter
#  failed  : return error code [-9 - -1]
#------------------------------------------------------------------------------
proc open_file {fn dg} {
    global M3001 M4007

    set RES [file_can_read $fn $dg]
    if {$RES == 0} {
        if [catch {set fd [open $fn r]} em] {
            tk_messageBox -type ok -title $M3001 -icon error \
                -message "$M4007\n{$em}"
            return -5
        } else {
          return $fd
        }
    } else {
        return $RES
    }    
}

#------------------------------------------------------------------------------
# @save_file
#------------------------------------------------------------------------------
proc save_file {fn} {
    global tk_version
    global M3001 M4007 M4008 M9002
    global TEMP_FILENAME TEMP_TEXT_MODIFIED TEMP_UNTITLED

    set res [file_can_write $fn 0]
    if {$res == 0} {
        if [catch {set fd [open $fn w]} em] {
            tk_messageBox -type ok -title $M3001 -icon error \
                -message "$M4007\n{$em}"
            return -5
        }
    } else {
        return $res
    }

    set str [.base.textarea get 1.0 "end -1 chars"]
    if [catch {puts -nonewline $fd $str} em] {
        tk_messageBox -type ok -title wait -icon error \
            -message "$M4008\n{$em}"
        close $fd
        return -6
    } 
    close $fd
    if {$tk_version > "8.3"} {
        .base.textarea edit modified false
    }
    set TEMP_TEXT_MODIFIED 0
    set TEMP_UNTITLED      0
    set TEMP_FILENAME      $fn
    get_cwd $fn
    wm title . "$M9002 $TEMP_FILENAME"

    return $res
}

#------------------------------------------------------------------------------
# @get_cwd
#------------------------------------------------------------------------------
proc get_cwd fn {
    global BINDIR TEMP_CWD TEMP_FILENAME

    set sdir [pwd]
    set dir [file dirname $fn]
    if {$dir != ""} {
        cd $dir
        set TEMP_CWD [pwd]
        cd $sdir
    } else {
        set TEMP_CWD [pwd]
    }
    set TEMP_FILENAME [file join $TEMP_CWD [file tail $fn]] 
    set TEMP_FILENAME [file nativename $TEMP_FILENAME]
}
