#ifndef __PANELSCRIBBLE_H__
#define __PANELSCRIBBLE_H__

#include <wx/wx.h>
#include <set>

//-----------------------------------------------------------------------------
// PanelScribble
//-----------------------------------------------------------------------------
class PanelScribble : public wxPanel {
private:
	typedef std::set<int> KeyCodes;
private:
	wxBitmap *_pBmpSurface;
	KeyCodes _keyCodesPressed;
public:
	PanelScribble(wxWindow *pParent, wxWindowID id, long style);
	inline wxBitmap *GetBitmap() { return _pBmpSurface; }
	inline bool IsKeyPressed(int keyCode) {
		return _keyCodesPressed.find(keyCode) != _keyCodesPressed.end();
	}
	inline bool IsAnyKeyPressed() const { return !_keyCodesPressed.empty(); }
private:
	DECLARE_EVENT_TABLE()
	void OnSize(wxSizeEvent &event);
	void OnEraseBackground(wxEraseEvent &event);
	void OnPaint(wxPaintEvent &event);
	void OnKeyDown(wxKeyEvent &event);
	void OnKeyUp(wxKeyEvent &event);
};

#endif
