#include "Application.h"
#include "FrameMain.h"
#include "ConfigDialog.h"
#include "Config.h"

//-----------------------------------------------------------------------------
// FrameMain
//-----------------------------------------------------------------------------
FrameMain::FrameMain(wxWindow *pParent) : wxFrame(pParent, wxID_ANY, wxT("AScript Shell"),
			Config::FrameMain::ReadPosition(), Config::FrameMain::ReadSize())
{
	//SetIcon(wxICON(MainIcon));
	wxMenuBar *pMenuBar = new wxMenuBar();
	SetMenuBar(pMenuBar);
	do {
		wxMenu *pMenu = new wxMenu();
		pMenuBar->Append(pMenu, wxT("&File"));
		pMenu->Append(wxID_OPEN, wxT("&Open...\tCtrl+O"));
		pMenu->AppendSeparator();
		pMenu->Append(wxID_EXIT, wxT("E&xit"));
	} while (0);
	do {
		wxMenu *pMenu = new wxMenu();
		pMenuBar->Append(pMenu, wxT("&Window"));
		pMenu->AppendCheckItem(ID_MENU_ShowScribble, wxT("Show &Scribble"));
		pMenu->Append(ID_MENU_Config, wxT("C&onfig..."));
	} while (0);
	do {
		wxStatusBar *pStatusBar = new wxStatusBar(this, wxID_ANY, wxST_SIZEGRIP);
		SetStatusBar(pStatusBar);
	} while (0);
	_pPanel = new Panel(this, wxID_ANY);
}

FrameMain::~FrameMain()
{
	Config::FrameMain::WritePosition(GetPosition());
	Config::FrameMain::WriteSize(GetSize());
}

BEGIN_EVENT_TABLE(FrameMain, wxFrame)
	EVT_MENU_OPEN(FrameMain::OnMenuOpen)
	EVT_MENU(wxID_OPEN,				FrameMain::OnMenu_Open)
	EVT_MENU(wxID_EXIT,				FrameMain::OnMenu_Exit)
	EVT_MENU(ID_MENU_ShowScribble,	FrameMain::OnMenu_ShowScribble)
	EVT_MENU(ID_MENU_Config,		FrameMain::OnMenu_Config)
END_EVENT_TABLE()

void FrameMain::OnMenuOpen(wxMenuEvent &event)
{
	const wxMenuItemList &list = event.GetMenu()->GetMenuItems();
	for (wxMenuItemList::Node *pNode = list.GetFirst();
							pNode != NULL; pNode = pNode->GetNext()) {
		wxMenuItem *pItem = pNode->GetData();
		int id = pItem->GetId();
		if (id == wxID_OPEN) {
			pItem->Enable(!_pPanel->GetAScriptShell()->IsThreadRunning());
		} else if (id == ID_MENU_ShowScribble) {
			FrameScribble *pFrameScribble = Application::GetInstance()->GetFrameScribble();
			pItem->Check(pFrameScribble->IsShown());
		}
	}
}

void FrameMain::OnMenu_Open(wxCommandEvent &event)
{
	wxString fileName = ::wxFileSelector(
			wxT("Open Script File"), wxT(""), _fileNameDefault, wxT("az"),
			wxT("AScript script file (*.az)|*.az")
			wxT("|All files (*.*)|*.*"), wxFD_OPEN);
	if (!fileName.empty()) {
		_fileNameDefault = fileName;
		_pPanel->GetAScriptShell()->EvalFile(fileName);
	}
}

void FrameMain::OnMenu_Exit(wxCommandEvent &event)
{
	Close();
}

void FrameMain::OnMenu_ShowScribble(wxCommandEvent &event)
{
	FrameScribble *pFrameScribble = Application::GetInstance()->GetFrameScribble();
	pFrameScribble->ShowEx(!pFrameScribble->IsShown());
}

void FrameMain::OnMenu_Config(wxCommandEvent &event)
{
	ConfigDialog dlg(this, ConfigDialog::PAGEID_None);
	dlg.ShowModal();
	do {
		AScriptShell *pCtrl = _pPanel->GetAScriptShell();
		pCtrl->UpdateFont();
		pCtrl->UpdateColor();
		pCtrl->Refresh();
	} while (0);
}

//-----------------------------------------------------------------------------
// FrameMain::Panel
//-----------------------------------------------------------------------------
FrameMain::Panel::Panel(wxWindow *pParent, wxWindowID id) :
		wxPanel(pParent, id, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL)
{
	wxBoxSizer *pOuterBox = new wxBoxSizer(wxVERTICAL);
	SetSizer(pOuterBox);
	wxBoxSizer *pVBox = new wxBoxSizer(wxVERTICAL);
	pOuterBox->Add(pVBox, wxSizerFlags(1).Expand());
	do {
		wxStaticLine *pCtrl = new wxStaticLine(this, wxID_ANY,
							wxDefaultPosition, wxDefaultSize, wxLI_HORIZONTAL);
		pVBox->Add(pCtrl, wxSizerFlags(0).Expand());
	} while (0);
	do {
		AScriptShell *pCtrl = new AScriptShell(this, wxID_ANY, 0);
		pVBox->Add(pCtrl, wxSizerFlags(1).Expand().Border(wxTOP, 1));
		_pAScriptShell = pCtrl;
	} while (0);
}

BEGIN_EVENT_TABLE(FrameMain::Panel, wxPanel)
END_EVENT_TABLE()
